package Net::Kubernetes::Resource::ServiceAccount;
$Net::Kubernetes::Resource::ServiceAccount::VERSION = '1.08';
# ABSTRACT: Object representatioon of a Kubernetes service account

use Moose;

extends 'Net::Kubernetes::Resource';

has secrets => (
    is  => 'rw',
    isa => 'ArrayRef',
);

has imagePullSecrets => (
    is  => 'rw',
    isa => 'ArrayRef',
);

augment 'as_hashref' => sub {
	my $self = shift;

	return (
		secrets          => $self->secrets,
		imagePullSecrets => $self->imagePullSecrets,
	);
};

return 42;

__END__

=pod

=encoding UTF-8

=head1 NAME

Net::Kubernetes::Resource::ServiceAccount - Object representatioon of a Kubernetes service account

=head1 VERSION

version 1.08

=head1 AUTHOR

Dave Mueller <dave@perljedi.com>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2015 by Liquid Web Inc.

This is free software, licensed under:

  The MIT (X11) License

=head1 SEE ALSO

Please see those modules/websites for more information related to this module.

=over 4

=item *

L<Net::Kubernetes|Net::Kubernetes>

=back

=cut
