package App::Manoc::Netwalker::WorkersRole;
use Moose::Role;
our $VERSION = '2.99.4'; ##TRIAL VERSION

use namespace::autoclean;

with 'MooseX::Workers';
with 'App::Manoc::Logger::Role';

use Try::Tiny;
use POE qw(Filter::Reference Filter::Line);

requires 'on_tick';

has config => (
    is       => 'ro',
    isa      => 'App::Manoc::Netwalker::Config',
    required => 1
);

has schema => (
    is       => 'ro',
    required => 1
);

sub BUILD {
    my $self = shift;

    $self->max_workers( $self->config->n_procs );
}


sub worker_stderr {
    my ( $self, $stderr_msg ) = @_;
    print STDERR "$stderr_msg\n";
}


sub worker_stdout {
    my ( $self, $result ) = @_;

    # pass
}


sub stdout_filter { POE::Filter::Reference->new }


sub stderr_filter { POE::Filter::Line->new }

no Moose::Role;
1;
# Local Variables:
# mode: cperl
# indent-tabs-mode: nil
# cperl-indent-level: 4
# cperl-indent-parens-as-block: t
# End:

__END__

=pod

=head1 NAME

App::Manoc::Netwalker::WorkersRole

=head1 VERSION

version 2.99.4

=head2 worker_stderr

Called when a child prints to STDERR

=head2 worker_stdout

Called when a child prints to STDOUT

=head2 stdout_filter

Returns the POE::Filter to be used for stdout.

=head2 stderr_filter

Returns the POE::Filter to be used for stderr.

=head1 AUTHORS

=over 4

=item *

Gabriele Mambrini <gmambro@cpan.org>

=item *

Enrico Liguori

=back

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Gabriele Mambrini.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
