#!/usr/bin/perl

use strict;
use lib 't/lib';

use Test::Deep qw(cmp_deeply);

use FusionInventory::Agent::Tools::Hardware;
use FusionInventory::Test::Hardware;

my %tests = (
    'juniper/ex2200.1.walk' => [
        {
            MANUFACTURER => 'Juniper',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Juniper Networks, Inc. ex2200-24t-4g internet router, kernel JUNOS 11.1R3.5 #0: 2011-06-25 00:35:00 UTC     builder@briath.juniper.net:/volume/build/junos/11.1/release/11.1R3.5/obj-arm/bsd/kernels/JUNIPER-EX/kernel Build date: 2011-06-25 00:31:37 UTC Cop',
            SNMPHOSTNAME => 'INTERUFR-219-ex2200-24',
            MAC          => '78:FE:3D:D5:0E:C0',
        },
        {
            MANUFACTURER => 'Juniper',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Juniper Networks, Inc. ex2200-24t-4g internet router, kernel JUNOS 11.1R3.5 #0: 2011-06-25 00:35:00 UTC     builder@briath.juniper.net:/volume/build/junos/11.1/release/11.1R3.5/obj-arm/bsd/kernels/JUNIPER-EX/kernel Build date: 2011-06-25 00:31:37 UTC Cop',
            SNMPHOSTNAME => 'INTERUFR-219-ex2200-24',
            MAC          => '78:FE:3D:D5:0E:C0',
            MODELSNMP    => 'Networking2185',
            MODEL        => undef,
            FIRMWARE     => undef,
            SERIAL       => 'CW0211513175',
        },
        {
            INFO => {
                MANUFACTURER => 'Juniper',
                TYPE         => 'NETWORKING',
                COMMENTS     => 'Juniper Networks, Inc. ex2200-24t-4g internet router, kernel JUNOS 11.1R3.5 #0: 2011-06-25 00:35:00 UTC     builder@briath.juniper.net:/volume/build/junos/11.1/release/11.1R3.5/obj-arm/bsd/kernels/JUNIPER-EX/kernel Build date: 2011-06-25 00:31:37 UTC Cop',
                MAC          => '78:FE:3D:D5:0E:C0',
                NAME         => 'INTERUFR-219-ex2200-24',
                MEMORY       => 0,
                SERIAL       => 'CW0211513175',
                CONTACT      => 'cricesr@dauphine.fr',
                UPTIME       => '(9174471) 1 day, 1:29:04.71',
                RAM          => 512,
                ID           => undef,
                LOCATION     => 'CB',
                MODEL        => undef,
                IPS          => {
                    IP => [
                        '128.0.0.1',
                        '128.0.0.127',
                        '128.0.0.16',
                        '128.0.0.32',
                        '192.168.1.219'
                    ]
                },
            },
            PORTS => {
                PORT => [
                {
                    IFNUMBER         => '4',
                    IFNAME           => 'lsi',
                    IFTYPE           => 'mplsTunnel(150)',
                    IFINOCTETS       => '0',
                    IFSTATUS         => 'up(1)',
                    IFDESCR          => 'lsi',
                    IFLASTCHANGE     => '(4298) 0:00:42.98',
                    IFMTU            => '1496',
                    IFOUTOCTETS      => '0',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFSPEED          => '0',
                    IFINERRORS       => '0'
                },
                {
                    IFNUMBER         => '5',
                    IFDESCR          => 'dsc',
                    IFLASTCHANGE     => '(4128) 0:00:41.28',
                    IFMTU            => '2147483647',
                    IFOUTOCTETS      => '0',
                    IFNAME           => 'dsc',
                    IFTYPE           => 'other(1)',
                    IFINOCTETS       => '0',
                    IFSTATUS         => 'up(1)',
                    IFSPEED          => '0',
                    IFINERRORS       => '0',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)'
                },
                {
                    IFNUMBER         => '6',
                    IFSPEED          => '0',
                    IFINERRORS       => '0',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFDESCR          => 'lo0',
                    IFOUTOCTETS      => '131885047',
                    IFMTU            => '2147483647',
                    IFLASTCHANGE     => '(4295) 0:00:42.95',
                    IFTYPE           => 'softwareLoopback(24)',
                    IFNAME           => 'lo0',
                    IFSTATUS         => 'up(1)',
                    IFINOCTETS       => '131885047'
                },
                {
                    IFNUMBER         => '7',
                    IFOUTOCTETS      => '0',
                    IFMTU            => '2147483647',
                    IFLASTCHANGE     => '(4311) 0:00:43.11',
                    IFDESCR          => 'tap',
                    IFSTATUS         => 'up(1)',
                    IFINOCTETS       => '0',
                    IFTYPE           => 'other(1)',
                    IFNAME           => 'tap',
                    IFINERRORS       => '0',
                    IFSPEED          => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0'
                },
                {
                    IFNUMBER         => '8',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFSPEED          => '0',
                    IFINERRORS       => '0',
                    IFTYPE           => 'tunnel(131)',
                    IFNAME           => 'gre',
                    IFSTATUS         => 'up(1)',
                    IFINOCTETS       => '0',
                    IFDESCR          => 'gre',
                    IFOUTOCTETS      => '0',
                    IFMTU            => '2147483647',
                    IFLASTCHANGE     => '(4282) 0:00:42.82'
                },
                {
                    IFNUMBER         => '9',
                    IFINOCTETS       => '0',
                    IFSTATUS         => 'up(1)',
                    IFNAME           => 'ipip',
                    IFTYPE           => 'tunnel(131)',
                    IFLASTCHANGE     => '(4288) 0:00:42.88',
                    IFMTU            => '2147483647',
                    IFOUTOCTETS      => '0',
                    IFDESCR          => 'ipip',
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0',
                    IFINERRORS       => '0',
                    IFSPEED          => '0'
                },
                {
                    IFNUMBER         => '10',
                    IFDESCR          => 'pime',
                    IFLASTCHANGE     => '(4309) 0:00:43.09',
                    IFMTU            => '2147483647',
                    IFOUTOCTETS      => '0',
                    IFNAME           => 'pime',
                    IFTYPE           => 'tunnel(131)',
                    IFINOCTETS       => '0',
                    IFSTATUS         => 'up(1)',
                    IFSPEED          => '0',
                    IFINERRORS       => '0',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)'
                },
                {
                    IFSPEED          => '0',
                    IFINERRORS       => '0',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFNUMBER         => '11',
                    IFDESCR          => 'pimd',
                    IFOUTOCTETS      => '0',
                    IFMTU            => '2147483647',
                    IFLASTCHANGE     => '(4307) 0:00:43.07',
                    IFTYPE           => 'tunnel(131)',
                    IFNAME           => 'pimd',
                    IFSTATUS         => 'up(1)',
                    IFINOCTETS       => '0'
                },
                {
                    IFNUMBER         => '12',
                    IFDESCR          => 'mtun',
                    IFOUTOCTETS      => '0',
                    IFLASTCHANGE     => '(4304) 0:00:43.04',
                    IFMTU            => '2147483647',
                    IFTYPE           => 'tunnel(131)',
                    IFNAME           => 'mtun',
                    IFSTATUS         => 'up(1)',
                    IFINOCTETS       => '0',
                    IFSPEED          => '0',
                    IFINERRORS       => '0',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)'
                },
                {
                    IFSTATUS         => 'up(1)',
                    MAC => '',
                    IFINOCTETS       => '14638812',
                    IFTYPE           => 'ethernetCsmacd(6)',
                    IFNAME           => 'me0',
                    IFOUTOCTETS      => '0',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(4300) 0:00:43.00',
                    IFNUMBER         => '33',
                    IFDESCR          => 'me0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0',
                    IFINERRORS       => '0',
                    IFSPEED          => '100000000'
                },
                {
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0',
                    IFINERRORS       => '0',
                    IFSPEED          => '100000000',
                    MAC => '',
                    IFINOCTETS       => '14638898',
                    IFSTATUS         => 'up(1)',
                    IFNAME           => 'me0.0',
                    IFTYPE           => 'propVirtual(53)',
                    IFLASTCHANGE     => '(4302) 0:00:43.02',
                    IFMTU            => '1500',
                    IFOUTOCTETS      => '3954144',
                    IFDESCR          => 'me0.0',
                    IFNUMBER         => '34'
                },
                {
                    IFSTATUS         => 'up(1)',
                    IFINOCTETS       => '0',
                    MAC => '',
                    IFTYPE           => 'ethernetCsmacd(6)',
                    IFNAME           => 'bme0',
                    IFOUTOCTETS      => '13256588',
                    IFLASTCHANGE     => '(4123) 0:00:41.23',
                    IFMTU            => '1576',
                    IFNUMBER         => '37',
                    IFDESCR          => 'bme0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0',
                    IFINERRORS       => '0',
                    IFSPEED          => '0'
                },
                {
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0',
                    IFINERRORS       => '0',
                    IFSPEED          => '0',
                    IFSTATUS         => 'up(1)',
                    MAC => '',
                    IFINOCTETS       => '3337783',
                    IFTYPE           => 'propVirtual(53)',
                    IFNAME           => 'bme0.32768',
                    IFOUTOCTETS      => '126',
                    IFLASTCHANGE     => '(4125) 0:00:41.25',
                    IFMTU            => '1562',
                    IFNUMBER         => '38',
                    IFDESCR          => 'bme0.32768'
                },
                {
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0',
                    IFINERRORS       => '0',
                    IFSPEED          => '0',
                    IFINOCTETS       => '0',
                    MAC => '',
                    IFSTATUS         => 'down(2)',
                    IFNAME           => 'ge-0/0/0',
                    IFTYPE           => 'ethernetCsmacd(6)',
                    IFLASTCHANGE     => '(4130) 0:00:41.30',
                    IFMTU            => '1514',
                    IFOUTOCTETS      => '0',
                    IFDESCR          => 'ge-0/0/0',
                    IFNUMBER         => '501'
                },
                {
                    IFLASTCHANGE     => '(4131) 0:00:41.31',
                    IFMTU            => '1514',
                    IFOUTOCTETS      => '0',
                    IFDESCR          => 'ge-0/0/0.0',
                    IFNUMBER         => '502',
                    IFINOCTETS       => '0',
                    MAC => '',
                    IFSTATUS         => 'lowerLayerDown(7)',
                    IFNAME           => 'ge-0/0/0.0',
                    IFTYPE           => 'propVirtual(53)',
                    IFINERRORS       => '0',
                    IFSPEED          => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0'
                },
                {
                    IFNUMBER         => '503',
                    IFDESCR          => 'ge-0/0/1',
                    IFOUTOCTETS      => '0',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(4134) 0:00:41.34',
                    IFTYPE           => 'ethernetCsmacd(6)',
                    IFNAME           => 'ge-0/0/1',
                    IFSTATUS         => 'down(2)',
                    IFINOCTETS       => '0',
                    MAC => '',
                    IFSPEED          => '0',
                    IFINERRORS       => '0',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)'
                },
                {
                    IFTYPE           => 'propVirtual(53)',
                    IFNAME           => 'ge-0/0/1.0',
                    IFSTATUS         => 'lowerLayerDown(7)',
                    MAC => '',
                    IFINOCTETS       => '0',
                    IFNUMBER         => '504',
                    IFDESCR          => 'ge-0/0/1.0',
                    IFOUTOCTETS      => '0',
                    IFLASTCHANGE     => '(4136) 0:00:41.36',
                    IFMTU            => '1514',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFSPEED          => '0',
                    IFINERRORS       => '0'
                },
                {
                    IFTYPE           => 'ethernetCsmacd(6)',
                    IFNAME           => 'ge-0/0/10',
                    IFSTATUS         => 'down(2)',
                    IFINOCTETS       => '0',
                    MAC => '',
                    IFNUMBER         => '505',
                    IFDESCR          => 'ge-0/0/10',
                    IFOUTOCTETS      => '0',
                    IFLASTCHANGE     => '(4172) 0:00:41.72',
                    IFMTU            => '1514',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFSPEED          => '0',
                    IFINERRORS       => '0'
                },
                {
                    MAC => '',
                    IFINOCTETS       => '0',
                    IFSTATUS         => 'lowerLayerDown(7)',
                    IFNAME           => 'ge-0/0/10.0',
                    IFTYPE           => 'propVirtual(53)',
                    IFLASTCHANGE     => '(4172) 0:00:41.72',
                    IFMTU            => '1514',
                    IFOUTOCTETS      => '0',
                    IFDESCR          => 'ge-0/0/10.0',
                    IFNUMBER         => '506',
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0',
                    IFINERRORS       => '0',
                    IFSPEED          => '0'
                },
                {
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0',
                    IFINERRORS       => '0',
                    IFSPEED          => '0',
                    IFINOCTETS       => '0',
                    MAC => '',
                    IFSTATUS         => 'down(2)',
                    IFNAME           => 'ge-0/0/11',
                    IFTYPE           => 'ethernetCsmacd(6)',
                    IFLASTCHANGE     => '(4264) 0:00:42.64',
                    IFMTU            => '1514',
                    IFOUTOCTETS      => '0',
                    IFDESCR          => 'ge-0/0/11',
                    IFNUMBER         => '507'
                },
                {
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0',
                    IFINERRORS       => '0',
                    IFSPEED          => '0',
                    IFSTATUS         => 'lowerLayerDown(7)',
                    IFINOCTETS       => '0',
                    MAC => '',
                    IFTYPE           => 'propVirtual(53)',
                    IFNAME           => 'ge-0/0/11.0',
                    IFOUTOCTETS      => '0',
                    IFLASTCHANGE     => '(4264) 0:00:42.64',
                    IFMTU            => '1514',
                    IFNUMBER         => '508',
                    IFDESCR          => 'ge-0/0/11.0'
                },
                {
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(4332) 0:00:43.32',
                    IFOUTOCTETS      => '0',
                    IFDESCR          => 'ge-0/0/12',
                    IFNUMBER         => '509',
                    MAC => '',
                    IFINOCTETS       => '0',
                    IFSTATUS         => 'down(2)',
                    IFNAME           => 'ge-0/0/12',
                    IFTYPE           => 'ethernetCsmacd(6)',
                    IFINERRORS       => '0',
                    IFSPEED          => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0'
                },
                {
                    IFINERRORS       => '0',
                    IFSPEED          => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0',
                    IFLASTCHANGE     => '(4332) 0:00:43.32',
                    IFMTU            => '1514',
                    IFOUTOCTETS      => '0',
                    IFDESCR          => 'ge-0/0/12.0',
                    IFNUMBER         => '510',
                    MAC => '',
                    IFINOCTETS       => '0',
                    IFSTATUS         => 'lowerLayerDown(7)',
                    IFNAME           => 'ge-0/0/12.0',
                    IFTYPE           => 'propVirtual(53)'
                },
                {
                    IFTYPE           => 'ethernetCsmacd(6)',
                    IFNAME           => 'ge-0/0/13',
                    IFSTATUS         => 'down(2)',
                    MAC => '',
                    IFINOCTETS       => '0',
                    IFNUMBER         => '511',
                    IFDESCR          => 'ge-0/0/13',
                    IFOUTOCTETS      => '0',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(4357) 0:00:43.57',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFSPEED          => '0',
                    IFINERRORS       => '0'
                },
                {
                    IFTYPE           => 'propVirtual(53)',
                    IFNAME           => 'ge-0/0/13.0',
                    IFSTATUS         => 'lowerLayerDown(7)',
                    MAC => '',
                    IFINOCTETS       => '0',
                    IFNUMBER         => '512',
                    IFDESCR          => 'ge-0/0/13.0',
                    IFOUTOCTETS      => '0',
                    IFLASTCHANGE     => '(4357) 0:00:43.57',
                    IFMTU            => '1514',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFSPEED          => '0',
                    IFINERRORS       => '0'
                },
                {
                    IFDESCR          => 'ge-0/0/14',
                    IFNUMBER         => '513',
                    IFLASTCHANGE     => '(4383) 0:00:43.83',
                    IFMTU            => '1514',
                    IFOUTOCTETS      => '0',
                    IFNAME           => 'ge-0/0/14',
                    IFTYPE           => 'ethernetCsmacd(6)',
                    MAC => '',
                    IFINOCTETS       => '0',
                    IFSTATUS         => 'down(2)',
                    IFSPEED          => '0',
                    IFINERRORS       => '0',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)'
                },
                {
                    IFDESCR          => 'ge-0/0/14.0',
                    IFNUMBER         => '514',
                    IFLASTCHANGE     => '(4383) 0:00:43.83',
                    IFMTU            => '1514',
                    IFOUTOCTETS      => '0',
                    IFNAME           => 'ge-0/0/14.0',
                    IFTYPE           => 'propVirtual(53)',
                    MAC => '',
                    IFINOCTETS       => '0',
                    IFSTATUS         => 'lowerLayerDown(7)',
                    IFSPEED          => '0',
                    IFINERRORS       => '0',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)'
                },
                {
                    IFNAME           => 'ge-0/0/15',
                    IFTYPE           => 'ethernetCsmacd(6)',
                    MAC => '',
                    IFINOCTETS       => '0',
                    IFSTATUS         => 'down(2)',
                    IFDESCR          => 'ge-0/0/15',
                    IFNUMBER         => '515',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(4418) 0:00:44.18',
                    IFOUTOCTETS      => '0',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFSPEED          => '0',
                    IFINERRORS       => '0'
                },
                {
                    IFSPEED          => '0',
                    IFINERRORS       => '0',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFDESCR          => 'ge-0/0/15.0',
                    IFNUMBER         => '516',
                    IFLASTCHANGE     => '(4418) 0:00:44.18',
                    IFMTU            => '1514',
                    IFOUTOCTETS      => '0',
                    IFNAME           => 'ge-0/0/15.0',
                    IFTYPE           => 'propVirtual(53)',
                    IFINOCTETS       => '0',
                    MAC => '',
                    IFSTATUS         => 'lowerLayerDown(7)'
                },
                {
                    IFOUTOCTETS      => '0',
                    IFLASTCHANGE     => '(4450) 0:00:44.50',
                    IFMTU            => '1514',
                    IFNUMBER         => '517',
                    IFDESCR          => 'ge-0/0/16',
                    IFSTATUS         => 'down(2)',
                    IFINOCTETS       => '0',
                    MAC => '',
                    IFTYPE           => 'ethernetCsmacd(6)',
                    IFNAME           => 'ge-0/0/16',
                    IFINERRORS       => '0',
                    IFSPEED          => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0'
                },
                {
                    IFNAME           => 'ge-0/0/16.0',
                    IFTYPE           => 'propVirtual(53)',
                    MAC => '',
                    IFINOCTETS       => '0',
                    IFSTATUS         => 'lowerLayerDown(7)',
                    IFDESCR          => 'ge-0/0/16.0',
                    IFNUMBER         => '518',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(4450) 0:00:44.50',
                    IFOUTOCTETS      => '0',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFSPEED          => '0',
                    IFINERRORS       => '0'
                },
                {
                    IFINERRORS       => '0',
                    IFSPEED          => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(4479) 0:00:44.79',
                    IFOUTOCTETS      => '0',
                    IFDESCR          => 'ge-0/0/17',
                    IFNUMBER         => '519',
                    MAC => '',
                    IFINOCTETS       => '0',
                    IFSTATUS         => 'down(2)',
                    IFNAME           => 'ge-0/0/17',
                    IFTYPE           => 'ethernetCsmacd(6)'
                },
                {
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0',
                    IFINERRORS       => '0',
                    IFSPEED          => '0',
                    IFSTATUS         => 'lowerLayerDown(7)',
                    IFINOCTETS       => '0',
                    MAC => '',
                    IFTYPE           => 'propVirtual(53)',
                    IFNAME           => 'ge-0/0/17.0',
                    IFOUTOCTETS      => '0',
                    IFLASTCHANGE     => '(4479) 0:00:44.79',
                    IFMTU            => '1514',
                    IFNUMBER         => '520',
                    IFDESCR          => 'ge-0/0/17.0'
                },
                {
                    IFDESCR          => 'ge-0/0/18',
                    IFNUMBER         => '521',
                    IFLASTCHANGE     => '(4511) 0:00:45.11',
                    IFMTU            => '1514',
                    IFOUTOCTETS      => '0',
                    IFNAME           => 'ge-0/0/18',
                    IFTYPE           => 'ethernetCsmacd(6)',
                    MAC => '',
                    IFINOCTETS       => '0',
                    IFSTATUS         => 'down(2)',
                    IFSPEED          => '0',
                    IFINERRORS       => '0',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)'
                },
                {
                    IFLASTCHANGE     => '(4511) 0:00:45.11',
                    IFMTU            => '1514',
                    IFOUTOCTETS      => '0',
                    IFDESCR          => 'ge-0/0/18.0',
                    IFNUMBER         => '522',
                    IFINOCTETS       => '0',
                    MAC => '',
                    IFSTATUS         => 'lowerLayerDown(7)',
                    IFNAME           => 'ge-0/0/18.0',
                    IFTYPE           => 'propVirtual(53)',
                    IFINERRORS       => '0',
                    IFSPEED          => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0'
                },
                {
                    IFNAME           => 'ge-0/0/19',
                    IFTYPE           => 'ethernetCsmacd(6)',
                    MAC => '',
                    IFINOCTETS       => '0',
                    IFSTATUS         => 'down(2)',
                    IFDESCR          => 'ge-0/0/19',
                    IFNUMBER         => '523',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(4536) 0:00:45.36',
                    IFOUTOCTETS      => '0',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFSPEED          => '0',
                    IFINERRORS       => '0'
                },
                {
                    IFLASTCHANGE     => '(4536) 0:00:45.36',
                    IFMTU            => '1514',
                    IFOUTOCTETS      => '0',
                    IFDESCR          => 'ge-0/0/19.0',
                    IFNUMBER         => '524',
                    IFINOCTETS       => '0',
                    MAC => '',
                    IFSTATUS         => 'lowerLayerDown(7)',
                    IFNAME           => 'ge-0/0/19.0',
                    IFTYPE           => 'propVirtual(53)',
                    IFINERRORS       => '0',
                    IFSPEED          => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0'
                },
                {
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0',
                    IFINERRORS       => '0',
                    IFSPEED          => '0',
                    MAC => '',
                    IFINOCTETS       => '0',
                    IFSTATUS         => 'down(2)',
                    IFNAME           => 'ge-0/0/2',
                    IFTYPE           => 'ethernetCsmacd(6)',
                    IFLASTCHANGE     => '(4211) 0:00:42.11',
                    IFMTU            => '1514',
                    IFOUTOCTETS      => '0',
                    IFDESCR          => 'ge-0/0/2',
                    IFNUMBER         => '525'
                },
                {
                    IFNUMBER         => '526',
                    IFDESCR          => 'ge-0/0/2.0',
                    IFOUTOCTETS      => '0',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(4213) 0:00:42.13',
                    IFTYPE           => 'propVirtual(53)',
                    IFNAME           => 'ge-0/0/2.0',
                    IFSTATUS         => 'lowerLayerDown(7)',
                    IFINOCTETS       => '0',
                    MAC => '',
                    IFSPEED          => '0',
                    IFINERRORS       => '0',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)'
                },
                {
                    IFINERRORS       => '0',
                    IFSPEED          => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0',
                    IFLASTCHANGE     => '(4557) 0:00:45.57',
                    IFMTU            => '1514',
                    IFOUTOCTETS      => '0',
                    IFDESCR          => 'ge-0/0/20',
                    IFNUMBER         => '527',
                    IFINOCTETS       => '0',
                    MAC => '',
                    IFSTATUS         => 'down(2)',
                    IFNAME           => 'ge-0/0/20',
                    IFTYPE           => 'ethernetCsmacd(6)'
                },
                {
                    IFSTATUS         => 'lowerLayerDown(7)',
                    IFINOCTETS       => '0',
                    MAC => '',
                    IFTYPE           => 'propVirtual(53)',
                    IFNAME           => 'ge-0/0/20.0',
                    IFOUTOCTETS      => '0',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(4557) 0:00:45.57',
                    IFNUMBER         => '528',
                    IFDESCR          => 'ge-0/0/20.0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0',
                    IFINERRORS       => '0',
                    IFSPEED          => '0'
                },
                {
                    IFINOCTETS       => '0',
                    MAC => '',
                    IFSTATUS         => 'down(2)',
                    IFNAME           => 'ge-0/0/21',
                    IFTYPE           => 'ethernetCsmacd(6)',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(4567) 0:00:45.67',
                    IFOUTOCTETS      => '0',
                    IFDESCR          => 'ge-0/0/21',
                    IFNUMBER         => '529',
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0',
                    IFINERRORS       => '0',
                    IFSPEED          => '0'
                },
                {
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(4567) 0:00:45.67',
                    IFOUTOCTETS      => '0',
                    IFDESCR          => 'ge-0/0/21.0',
                    IFNUMBER         => '530',
                    IFINOCTETS       => '0',
                    MAC => '',
                    IFSTATUS         => 'lowerLayerDown(7)',
                    IFNAME           => 'ge-0/0/21.0',
                    IFTYPE           => 'propVirtual(53)',
                    IFINERRORS       => '0',
                    IFSPEED          => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0'
                },
                {
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0',
                    IFINERRORS       => '0',
                    IFSPEED          => '0',
                    MAC => '',
                    IFINOCTETS       => '0',
                    IFSTATUS         => 'down(2)',
                    IFNAME           => 'ge-0/0/22',
                    IFTYPE           => 'ethernetCsmacd(6)',
                    IFLASTCHANGE     => '(4587) 0:00:45.87',
                    IFMTU            => '1514',
                    IFOUTOCTETS      => '0',
                    IFDESCR          => 'ge-0/0/22',
                    IFNUMBER         => '531'
                },
                {
                    IFSTATUS         => 'lowerLayerDown(7)',
                    MAC => '',
                    IFINOCTETS       => '0',
                    IFTYPE           => 'propVirtual(53)',
                    IFNAME           => 'ge-0/0/22.0',
                    IFOUTOCTETS      => '0',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(4587) 0:00:45.87',
                    IFNUMBER         => '532',
                    IFDESCR          => 'ge-0/0/22.0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0',
                    IFINERRORS       => '0',
                    IFSPEED          => '0'
                },
                {
                    IFTYPE           => 'ethernetCsmacd(6)',
                    IFNAME           => 'ge-0/0/23',
                    IFSTATUS         => 'down(2)',
                    IFINOCTETS       => '0',
                    MAC => '',
                    IFNUMBER         => '533',
                    IFDESCR          => 'ge-0/0/23',
                    IFOUTOCTETS      => '0',
                    IFLASTCHANGE     => '(4618) 0:00:46.18',
                    IFMTU            => '1514',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFSPEED          => '0',
                    IFINERRORS       => '0'
                },
                {
                    IFINERRORS       => '0',
                    IFSPEED          => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0',
                    IFLASTCHANGE     => '(4618) 0:00:46.18',
                    IFMTU            => '1514',
                    IFOUTOCTETS      => '0',
                    IFDESCR          => 'ge-0/0/23.0',
                    IFNUMBER         => '534',
                    IFINOCTETS       => '0',
                    MAC => '',
                    IFSTATUS         => 'lowerLayerDown(7)',
                    IFNAME           => 'ge-0/0/23.0',
                    IFTYPE           => 'propVirtual(53)'
                },
                {
                    IFINERRORS       => '0',
                    IFSPEED          => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0',
                    IFLASTCHANGE     => '(4236) 0:00:42.36',
                    IFMTU            => '1514',
                    IFOUTOCTETS      => '0',
                    IFDESCR          => 'ge-0/0/3',
                    IFNUMBER         => '535',
                    IFINOCTETS       => '0',
                    MAC => '',
                    IFSTATUS         => 'down(2)',
                    IFNAME           => 'ge-0/0/3',
                    IFTYPE           => 'ethernetCsmacd(6)'
                },
                {
                    IFSPEED          => '0',
                    IFINERRORS       => '0',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFNUMBER         => '536',
                    IFDESCR          => 'ge-0/0/3.0',
                    IFOUTOCTETS      => '0',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(4238) 0:00:42.38',
                    IFTYPE           => 'propVirtual(53)',
                    IFNAME           => 'ge-0/0/3.0',
                    IFSTATUS         => 'lowerLayerDown(7)',
                    MAC => '',
                    IFINOCTETS       => '0'
                },
                {
                    IFDESCR          => 'ge-0/0/4',
                    IFNUMBER         => '537',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(4239) 0:00:42.39',
                    IFOUTOCTETS      => '0',
                    IFNAME           => 'ge-0/0/4',
                    IFTYPE           => 'ethernetCsmacd(6)',
                    IFINOCTETS       => '0',
                    MAC => '',
                    IFSTATUS         => 'down(2)',
                    IFSPEED          => '0',
                    IFINERRORS       => '0',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)'
                },
                {
                    IFNUMBER         => '538',
                    IFDESCR          => 'ge-0/0/4.0',
                    IFOUTOCTETS      => '0',
                    IFLASTCHANGE     => '(4240) 0:00:42.40',
                    IFMTU            => '1514',
                    IFTYPE           => 'propVirtual(53)',
                    IFNAME           => 'ge-0/0/4.0',
                    IFSTATUS         => 'lowerLayerDown(7)',
                    IFINOCTETS       => '0',
                    MAC => '',
                    IFSPEED          => '0',
                    IFINERRORS       => '0',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)'
                },
                {
                    IFSTATUS         => 'down(2)',
                    MAC => '',
                    IFINOCTETS       => '0',
                    IFTYPE           => 'ethernetCsmacd(6)',
                    IFNAME           => 'ge-0/0/5',
                    IFOUTOCTETS      => '0',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(4242) 0:00:42.42',
                    IFNUMBER         => '539',
                    IFDESCR          => 'ge-0/0/5',
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0',
                    IFINERRORS       => '0',
                    IFSPEED          => '0'
                },
                {
                    IFSPEED          => '0',
                    IFINERRORS       => '0',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFDESCR          => 'ge-0/0/5.0',
                    IFNUMBER         => '540',
                    IFLASTCHANGE     => '(4245) 0:00:42.45',
                    IFMTU            => '1514',
                    IFOUTOCTETS      => '0',
                    IFNAME           => 'ge-0/0/5.0',
                    IFTYPE           => 'propVirtual(53)',
                    IFINOCTETS       => '0',
                    MAC => '',
                    IFSTATUS         => 'lowerLayerDown(7)'
                },
                {
                    IFSPEED          => '0',
                    IFINERRORS       => '0',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFDESCR          => 'ge-0/0/6',
                    IFNUMBER         => '541',
                    IFLASTCHANGE     => '(4247) 0:00:42.47',
                    IFMTU            => '1514',
                    IFOUTOCTETS      => '0',
                    IFNAME           => 'ge-0/0/6',
                    IFTYPE           => 'ethernetCsmacd(6)',
                    IFINOCTETS       => '0',
                    MAC => '',
                    IFSTATUS         => 'down(2)'
                },
                {
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0',
                    IFINERRORS       => '0',
                    IFSPEED          => '0',
                    IFSTATUS         => 'lowerLayerDown(7)',
                    MAC => '',
                    IFINOCTETS       => '0',
                    IFTYPE           => 'propVirtual(53)',
                    IFNAME           => 'ge-0/0/6.0',
                    IFOUTOCTETS      => '0',
                    IFLASTCHANGE     => '(4250) 0:00:42.50',
                    IFMTU            => '1514',
                    IFNUMBER         => '542',
                    IFDESCR          => 'ge-0/0/6.0'
                },
                {
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(4254) 0:00:42.54',
                    IFOUTOCTETS      => '0',
                    IFDESCR          => 'ge-0/0/7',
                    IFNUMBER         => '543',
                    IFINOCTETS       => '0',
                    MAC => '',
                    IFSTATUS         => 'down(2)',
                    IFNAME           => 'ge-0/0/7',
                    IFTYPE           => 'ethernetCsmacd(6)',
                    IFINERRORS       => '0',
                    IFSPEED          => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0'
                },
                {
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0',
                    IFINERRORS       => '0',
                    IFSPEED          => '0',
                    IFSTATUS         => 'lowerLayerDown(7)',
                    MAC => '',
                    IFINOCTETS       => '0',
                    IFTYPE           => 'propVirtual(53)',
                    IFNAME           => 'ge-0/0/7.0',
                    IFOUTOCTETS      => '0',
                    IFLASTCHANGE     => '(4257) 0:00:42.57',
                    IFMTU            => '1514',
                    IFNUMBER         => '544',
                    IFDESCR          => 'ge-0/0/7.0'
                },
                {
                    IFNAME           => 'ge-0/0/8',
                    IFTYPE           => 'ethernetCsmacd(6)',
                    IFINOCTETS       => '0',
                    MAC => '',
                    IFSTATUS         => 'down(2)',
                    IFDESCR          => 'ge-0/0/8',
                    IFNUMBER         => '545',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(4260) 0:00:42.60',
                    IFOUTOCTETS      => '0',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFSPEED          => '0',
                    IFINERRORS       => '0'
                },
                {
                    IFNAME           => 'ge-0/0/8.0',
                    IFTYPE           => 'propVirtual(53)',
                    IFINOCTETS       => '0',
                    MAC => '',
                    IFSTATUS         => 'lowerLayerDown(7)',
                    IFDESCR          => 'ge-0/0/8.0',
                    IFNUMBER         => '546',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(4266) 0:00:42.66',
                    IFOUTOCTETS      => '0',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFSPEED          => '0',
                    IFINERRORS       => '0'
                },
                {
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFSPEED          => '0',
                    IFINERRORS       => '0',
                    IFTYPE           => 'ethernetCsmacd(6)',
                    IFNAME           => 'ge-0/0/9',
                    IFSTATUS         => 'down(2)',
                    IFINOCTETS       => '0',
                    MAC => '',
                    IFNUMBER         => '547',
                    IFDESCR          => 'ge-0/0/9',
                    IFOUTOCTETS      => '0',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(4269) 0:00:42.69'
                },
                {
                    IFNUMBER         => '548',
                    IFDESCR          => 'ge-0/0/9.0',
                    IFOUTOCTETS      => '0',
                    IFLASTCHANGE     => '(4271) 0:00:42.71',
                    IFMTU            => '1514',
                    IFTYPE           => 'propVirtual(53)',
                    IFNAME           => 'ge-0/0/9.0',
                    IFSTATUS         => 'lowerLayerDown(7)',
                    MAC => '',
                    IFINOCTETS       => '0',
                    IFSPEED          => '0',
                    IFINERRORS       => '0',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)'
                },
                {
                    IFSTATUS         => 'up(1)',
                    MAC => '',
                    IFINOCTETS       => '2760591156',
                    IFTYPE           => 'ethernetCsmacd(6)',
                    IFNAME           => 'ge-0/1/0',
                    IFOUTOCTETS      => '742321097',
                    IFLASTCHANGE     => '(4627) 0:00:46.27',
                    IFMTU            => '1514',
                    IFNUMBER         => '549',
                    IFDESCR          => 'ge-0/1/0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0',
                    IFINERRORS       => '0',
                    IFSPEED          => '1000000000'
                },
                {
                    CONNECTIONS => {
                        CONNECTION => {
                            MAC => [
                                '00:10:5A:13:A5:47',
                                '00:10:5A:1B:C5:BE',
                                '00:D0:B7:45:80:30',
                                '00:18:F3:F0:0C:0E',
                                '00:19:D1:82:AB:F6',
                                '00:1B:2F:B3:C0:D5',
                                '00:1B:2F:B3:C0:D7',
                                '00:1C:C0:BD:D2:82',
                                '00:1C:C0:BD:D7:79',
                                '00:1C:C0:BD:D7:54',
                                '00:1C:C0:BD:D9:1B',
                                '00:1C:C0:BD:D9:3F',
                                '00:1C:C0:DC:69:5A',
                                '00:1C:C0:DC:6B:FA',
                                '00:1C:C0:DC:6D:47',
                                '00:1C:C0:DC:7A:EA',
                                '00:1C:C0:DC:7B:17',
                                '00:1C:C0:DC:7D:7F',
                                '00:1C:C0:DF:39:EE',
                                '00:1C:C0:DF:39:F6',
                                '00:1C:C0:DF:3A:8A',
                                '00:1C:C0:DF:3A:8B',
                                '00:1C:C0:DF:3A:1F',
                                '00:1C:C0:DF:3A:55',
                                '00:03:22:01:9B:19',
                                '00:27:0E:2D:F8:64',
                                '00:27:0E:2D:F9:60',
                                '00:40:0D:8A:8B:47',
                                '00:50:DA:7C:51:52',
                                '00:50:DA:7C:63:4C',
                                '00:50:DA:D8:4E:47',
                                '00:50:04:82:CE:89',
                                '00:50:04:A9:60:39',
                                '00:50:04:50:54:E8',
                                '00:60:08:64:12:81',
                                '00:60:08:64:15:F0',
                                '00:60:08:64:16:8C',
                                '00:60:08:64:16:11',
                                '00:60:08:64:16:3F',
                                '00:60:08:64:16:46',
                                '00:60:08:64:16:4C',
                                '00:60:08:64:23:E5',
                                '00:60:08:72:78:CB',
                                '00:60:08:0C:01:7D',
                                '00:60:08:9F:35:83',
                                '00:60:08:63:FA:63',
                                '78:E7:D1:A9:3C:2B',
                                '8C:89:A5:3A:BA:20',
                                'B4:B5:2F:54:C9:30',
                                'BC:AE:C5:43:DA:70',
                                'C8:9C:DC:F3:E7:71',
                                'F8:0F:41:36:13:75',
                                'F8:0F:41:36:13:63',
                                'F8:0F:41:36:49:6B',
                                'F8:0F:41:36:49:03',
                                'F8:0F:41:3B:13:6F',
                                'F8:0F:41:3D:1E:E6',
                                'F8:0F:41:3D:38:66',
                                'F8:0F:41:3D:38:A0',
                                'F8:0F:41:3D:38:D7',
                                'F8:0F:41:3D:38:DA',
                                'F8:0F:41:3D:38:26',
                                'F8:0F:41:3D:39:85',
                                'F8:0F:41:3D:39:32',
                                'F8:0F:41:3D:39:35',
                                'F8:0F:41:3D:43:64',
                                'F8:0F:41:3D:43:69',
                                'F8:0F:41:3D:43:8B',
                                'F8:0F:41:3D:47:00',
                                'F8:0F:41:3D:48:95',
                                'F8:0F:41:3D:48:C4',
                                'F8:0F:41:3D:48:CA',
                                'F8:0F:41:3D:48:59',
                                'F8:0F:41:3E:0A:D1',
                                'F8:0F:41:3E:0A:29',
                                'F8:0F:41:3E:0B:C5',
                                'F8:0F:41:3E:0B:D2',
                                'F8:0F:41:3E:0C:BD',
                                'F8:0F:41:3E:0C:33',
                                'F8:0F:41:3E:07:37',
                                'F8:0F:41:3E:09:2E',
                                '20:CF:30:F0:82:D8',
                                '20:CF:30:F0:82:E6'
                            ]
                        }
                    },
                    IFINERRORS       => '0',
                    IFSPEED          => '1000000000',
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0',
                    IFOUTOCTETS      => '6487435',
                    IFLASTCHANGE     => '(4627) 0:00:46.27',
                    IFMTU            => '1514',
                    IFNUMBER         => '550',
                    IFDESCR          => 'ge-0/1/0.0',
                    IFSTATUS         => 'up(1)',
                    MAC => '',
                    IFINOCTETS       => '1518484',
                    IFTYPE           => 'propVirtual(53)',
                    IFNAME           => 'ge-0/1/0.0'
                },
                {
                    IFLASTCHANGE     => '(4674) 0:00:46.74',
                    IFMTU            => '1514',
                    IFOUTOCTETS      => '2761755337',
                    IFDESCR          => 'ge-0/1/3',
                    IFNUMBER         => '555',
                    MAC => '',
                    IFINOCTETS       => '738384759',
                    IFSTATUS         => 'up(1)',
                    IFNAME           => 'ge-0/1/3',
                    IFTYPE           => 'ethernetCsmacd(6)',
                    IFINERRORS       => '0',
                    IFSPEED          => '1000000000',
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0'
                },
                {
                    IFMTU            => '1518',
                    IFLASTCHANGE     => '(4290) 0:00:42.90',
                    IFOUTOCTETS      => '0',
                    IFDESCR          => 'jsrv',
                    IFNUMBER         => '556',
                    IFINOCTETS       => '0',
                    MAC => '',
                    IFSTATUS         => 'up(1)',
                    IFNAME           => 'jsrv',
                    IFTYPE           => 'ethernetCsmacd(6)',
                    IFINERRORS       => '0',
                    IFSPEED          => '1000000000',
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0'
                },
                {
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFSPEED          => '1000000000',
                    IFINERRORS       => '0',
                    IFNAME           => 'jsrv.1',
                    IFTYPE           => 'propVirtual(53)',
                    IFINOCTETS       => '0',
                    MAC => '',
                    IFSTATUS         => 'up(1)',
                    IFDESCR          => 'jsrv.1',
                    IFNUMBER         => '557',
                    IFLASTCHANGE     => '(4293) 0:00:42.93',
                    IFMTU            => '1500',
                    IFOUTOCTETS      => '42'
                },
                {
                    IFTYPE           => 'ethernetCsmacd(6)',
                    IFNAME           => 'vlan',
                    IFSTATUS         => 'up(1)',
                    MAC => '',
                    IFINOCTETS       => '0',
                    IFNUMBER         => '558',
                    IFDESCR          => 'vlan',
                    IFOUTOCTETS      => '0',
                    IFMTU            => '1518',
                    IFLASTCHANGE     => '(4316) 0:00:43.16',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFSPEED          => '1000000000',
                    IFINERRORS       => '0'
                },
                {
                    CONNECTIONS => {
                        CONNECTION => {
                            MAC => [
                                '00:11:85:69:2F:08',
                                '00:11:85:69:2F:09',
                                '00:12:79:39:3C:6E',
                                '00:12:79:39:3C:30',
                                '00:15:60:A8:9A:31',
                                '00:15:60:A8:9A:32',
                                '00:15:60:A8:C8:A5',
                                '00:15:60:A8:C8:A6',
                                '00:24:81:A5:8C:99',
                                '00:24:81:A5:8C:9A',
                                '00:24:81:A5:AD:82',
                                '00:24:81:A5:AD:84',
                                '00:25:B3:AA:D6:B6',
                                '00:50:56:B7:0B:86',
                                '00:50:56:B7:20:69',
                                '78:E3:B5:12:97:D8',
                                '78:E3:B5:12:97:DA',
                                '78:E3:B5:12:A7:0A',
                                '78:E3:B5:12:A7:08',
                                '9C:8E:99:14:8A:9C',
                                '9C:8E:99:14:8A:9E',
                                '9C:8E:99:14:8A:A4',
                                '9C:8E:99:14:8A:A6',
                                'B4:99:BA:C0:EB:A4',
                                'B4:99:BA:C0:EB:A6',
                                'B4:99:BA:C0:EB:A8',
                                'B4:99:BA:C0:EB:AA',
                                'E4:11:5B:B0:29:FE',
                                'E4:11:5B:B0:2A:02',
                                'E4:11:5B:B0:2A:04',
                                '18:33:9D:E7:15:1A'
                            ]
                        }
                    },
                    IFINERRORS       => '0',
                    IFSPEED          => '1000000000',
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0',
                    IFOUTOCTETS      => '6009138',
                    IFLASTCHANGE     => '(4674) 0:00:46.74',
                    IFMTU            => '1514',
                    IFNUMBER         => '559',
                    IFDESCR          => 'ge-0/1/3.0',
                    IFSTATUS         => 'up(1)',
                    MAC => '',
                    IFINOCTETS       => '796377',
                    IFTYPE           => 'propVirtual(53)',
                    IFNAME           => 'ge-0/1/3.0'
                }
                ]
            },
        }
    ],
    'juniper/ex2200.2.walk' => [
        {
            MANUFACTURER => 'Juniper',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Juniper Networks, Inc. ex2200-48t-4g internet router, kernel JUNOS 11.4R5.5 #0: 2012-08-25 05:21:13 UTC     builder@evenath.juniper.net:/volume/build/junos/11.4/release/11.4R5.5/obj-arm/bsd/kernels/JUNIPER-EX-2200/kernel Build date: 2012-08-25 04:48:47 U',
            SNMPHOSTNAME => 'jtc407-01',
            MAC          => '00:0B:CA:FE:00:00'
        },
        {
            MANUFACTURER => 'Juniper',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Juniper Networks, Inc. ex2200-48t-4g internet router, kernel JUNOS 11.4R5.5 #0: 2012-08-25 05:21:13 UTC     builder@evenath.juniper.net:/volume/build/junos/11.4/release/11.4R5.5/obj-arm/bsd/kernels/JUNIPER-EX-2200/kernel Build date: 2012-08-25 04:48:47 U',
            SNMPHOSTNAME => 'jtc407-01',
            MAC          => '78:FE:3D:36:F7:00',
            MODELSNMP    => 'Networking2495',
            MODEL        => undef,
            FIRMWARE     => undef,
            SERIAL       => undef,
        },
        {
            INFO => {
                MANUFACTURER => 'Juniper',
                TYPE         => 'NETWORKING',
                COMMENTS     => 'Juniper Networks, Inc. ex2200-48t-4g internet router, kernel JUNOS 11.4R5.5 #0: 2012-08-25 05:21:13 UTC     builder@evenath.juniper.net:/volume/build/junos/11.4/release/11.4R5.5/obj-arm/bsd/kernels/JUNIPER-EX-2200/kernel Build date: 2012-08-25 04:48:47 U',
                UPTIME       => '(690838738) 79 days, 22:59:47.38',
                MODEL        => undef,
                ID           => undef,
                NAME         => 'jtc407-01',
                MAC          => '78:FE:3D:36:F7:00',
                IPS          => {
                    IP => [
                        '128.0.0.1',
                        '128.0.0.16',
                        '128.0.0.32',
                        '192.168.100.65'
                    ]
                },
            },
            PORTS => {
                PORT => [
                {
                    IFNAME           => 'lsi',
                    IFTYPE           => '150',
                    IFINOCTETS       => '0',
                    IFSTATUS         => '1',
                    IFDESCR          => 'lsi',
                    IFNUMBER         => '4',
                    IFLASTCHANGE     => '(0) 0:00:00.00',
                    IFMTU            => '1496',
                    IFOUTOCTETS      => '0',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => '1',
                    IFSPEED          => '0',
                    IFINERRORS       => '0'
                },
                {
                    IFNAME           => 'dsc',
                    IFTYPE           => '1',
                    IFINOCTETS       => '0',
                    IFSTATUS         => '1',
                    IFDESCR          => 'dsc',
                    IFNUMBER         => '5',
                    IFMTU            => '2147483647',
                    IFLASTCHANGE     => '(3199) 0:00:31.99',
                    IFOUTOCTETS      => '0',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => '1',
                    IFSPEED          => '0',
                    IFINERRORS       => '0'
                },
                {
                    IFINOCTETS       => '3299710309',
                    IFSTATUS         => '1',
                    IFNAME           => 'lo0',
                    IFTYPE           => '24',
                    IFMTU            => '2147483647',
                    IFLASTCHANGE     => '(3203) 0:00:32.03',
                    IFOUTOCTETS      => '3300277085',
                    IFDESCR          => 'lo0',
                    IFNUMBER         => '6',
                    IFINTERNALSTATUS => '1',
                    IFOUTERRORS      => '0',
                    IFINERRORS       => '0',
                    IFSPEED          => '0'
                },
                {
                    IFSPEED          => '0',
                    IFINERRORS       => '0',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => '1',
                    IFNUMBER         => '7',
                    IFDESCR          => 'tap',
                    IFOUTOCTETS      => '0',
                    IFMTU            => '2147483647',
                    IFLASTCHANGE     => '(3204) 0:00:32.04',
                    IFTYPE           => '1',
                    IFNAME           => 'tap',
                    IFSTATUS         => '1',
                    IFINOCTETS       => '0'
                },
                {
                    IFLASTCHANGE     => '(3201) 0:00:32.01',
                    IFMTU            => '2147483647',
                    IFOUTOCTETS      => '0',
                    IFDESCR          => 'gre',
                    IFNUMBER         => '8',
                    IFINOCTETS       => '0',
                    IFSTATUS         => '1',
                    IFNAME           => 'gre',
                    IFTYPE           => '131',
                    IFINERRORS       => '0',
                    IFSPEED          => '0',
                    IFINTERNALSTATUS => '1',
                    IFOUTERRORS      => '0'
                },
                {
                    IFSTATUS         => '1',
                    IFINOCTETS       => '0',
                    IFTYPE           => '131',
                    IFNAME           => 'ipip',
                    IFOUTOCTETS      => '0',
                    IFMTU            => '2147483647',
                    IFLASTCHANGE     => '(3202) 0:00:32.02',
                    IFNUMBER         => '9',
                    IFDESCR          => 'ipip',
                    IFINTERNALSTATUS => '1',
                    IFOUTERRORS      => '0',
                    IFINERRORS       => '0',
                    IFSPEED          => '0'
                },
                {
                    IFNUMBER         => '10',
                    IFTYPE           => '131',
                    IFNAME           => 'pime',
                    IFSTATUS         => '1',
                    IFINOCTETS       => '0',
                    IFDESCR          => 'pime',
                    IFOUTOCTETS      => '0',
                    IFMTU            => '2147483647',
                    IFLASTCHANGE     => '(3208) 0:00:32.08',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => '1',
                    IFSPEED          => '0',
                    IFINERRORS       => '0'
                },
                {
                    IFNUMBER         => '11',
                    IFDESCR          => 'pimd',
                    IFOUTOCTETS      => '0',
                    IFMTU            => '2147483647',
                    IFLASTCHANGE     => '(3209) 0:00:32.09',
                    IFTYPE           => '131',
                    IFNAME           => 'pimd',
                    IFSTATUS         => '1',
                    IFINOCTETS       => '0',
                    IFSPEED          => '0',
                    IFINERRORS       => '0',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => '1'
                },
                {
                    IFSPEED          => '0',
                    IFINERRORS       => '0',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => '1',
                    IFDESCR          => 'mtun',
                    IFNUMBER         => '12',
                    IFLASTCHANGE     => '(3211) 0:00:32.11',
                    IFMTU            => '2147483647',
                    IFOUTOCTETS      => '0',
                    IFNAME           => 'mtun',
                    IFTYPE           => '131',
                    IFINOCTETS       => '0',
                    IFSTATUS         => '1'
                },
                {
                    IFNUMBER         => '33',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => '1',
                    IFSPEED          => '0',
                    IFINERRORS       => '0',
                    IFTYPE           => '6',
                    IFNAME           => 'me0',
                    IFSTATUS         => '2',
                    MAC              => '78:FE:3D:36:F7:3F',
                    IFINOCTETS       => '0',
                    IFDESCR          => 'me0',
                    IFOUTOCTETS      => '0',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(3210) 0:00:32.10'
                },
                {
                    IFSPEED          => '0',
                    IFINERRORS       => '0',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => '1',
                    IFNUMBER         => '37',
                    IFDESCR          => 'bme0',
                    IFOUTOCTETS      => '2715463516',
                    IFMTU            => '1576',
                    IFLASTCHANGE     => '(3198) 0:00:31.98',
                    IFTYPE           => '6',
                    IFNAME           => 'bme0',
                    IFSTATUS         => '1',
                    MAC              => '00:0B:CA:FE:00:00',
                    IFINOCTETS       => '0'
                },
                {
                    IFDESCR          => 'bme0.32768',
                    IFNUMBER         => '38',
                    IFLASTCHANGE     => '(3213) 0:00:32.13',
                    IFMTU            => '1562',
                    IFOUTOCTETS      => '126',
                    IFNAME           => 'bme0.32768',
                    IFTYPE           => '53',
                    MAC => '00:0B:CA:FE:00:00',
                    IFINOCTETS       => '901244274',
                    IFSTATUS         => '1',
                    IFSPEED          => '0',
                    IFINERRORS       => '0',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => '1'
                },
                {
                    IFINERRORS       => '0',
                    IFSPEED          => '1000000000',
                    IFINTERNALSTATUS => '1',
                    IFOUTERRORS      => '0',
                    IFOUTOCTETS      => '1776131026',
                    IFLASTCHANGE     => '(7247) 0:01:12.47',
                    IFMTU            => '1514',
                    IFNUMBER         => '501',
                    IFDESCR          => 'ge-0/0/0',
                    IFSTATUS         => '1',
                    IFPORTDUPLEX     => '3',
                    IFINOCTETS       => '3654820112',
                    MAC => '78:FE:3D:36:F7:03',
                    IFTYPE           => '6',
                    IFNAME           => 'ge-0/0/0'
                },
                {
                    IFSTATUS         => '7',
                    MAC => '78:FE:3D:36:F7:03',
                    IFINOCTETS       => '0',
                    IFPORTDUPLEX     => '3',
                    IFTYPE           => '53',
                    IFNAME           => 'ge-0/0/46.0',
                    IFOUTOCTETS      => '0',
                    IFLASTCHANGE     => '(3891) 0:00:38.91',
                    IFMTU            => '1514',
                    IFNUMBER         => '502',
                    IFDESCR          => 'ge-0/0/46.0',
                    IFINTERNALSTATUS => '1',
                    IFOUTERRORS      => '0',
                    IFINERRORS       => '0',
                    IFSPEED          => '1000000000'
                },
                {
                    IFINTERNALSTATUS => '1',
                    IFOUTERRORS      => '0',
                    IFINERRORS       => '0',
                    IFSPEED          => '1000000000',
                    IFINOCTETS       => '99911270',
                    MAC => '78:FE:3D:36:F7:04',
                    IFPORTDUPLEX     => '3',
                    IFSTATUS         => '1',
                    IFNAME           => 'ge-0/0/1',
                    IFTYPE           => '6',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(7247) 0:01:12.47',
                    IFOUTOCTETS      => '3838463887',
                    IFDESCR          => 'ge-0/0/1',
                    IFNUMBER         => '503'
                },
                {
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => '1',
                    IFSPEED          => '0',
                    IFINERRORS       => '0',
                    IFNAME           => 'ge-0/0/1.0',
                    IFTYPE           => '53',
                    IFPORTDUPLEX     => '3',
                    IFINOCTETS       => '188602',
                    MAC => '78:FE:3D:36:F7:04',
                    IFSTATUS         => '1',
                    IFDESCR          => 'ge-0/0/1.0',
                    IFNUMBER         => '504',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(7247) 0:01:12.47',
                    IFOUTOCTETS      => '465720827'
                },
                {
                    IFINTERNALSTATUS => '1',
                    IFOUTERRORS      => '0',
                    IFINERRORS       => '0',
                    IFSPEED          => '0',
                    IFPORTDUPLEX     => '3',
                    IFINOCTETS       => '0',
                    MAC => '78:FE:3D:36:F7:0D',
                    IFSTATUS         => '2',
                    IFNAME           => 'ge-0/0/10',
                    IFTYPE           => '6',
                    IFLASTCHANGE     => '(3345) 0:00:33.45',
                    IFMTU            => '1514',
                    IFOUTOCTETS      => '0',
                    IFDESCR          => 'ge-0/0/10',
                    IFNUMBER         => '505'
                },
                {
                    IFTYPE           => '53',
                    IFNAME           => 'ge-0/0/10.0',
                    IFSTATUS         => '7',
                    IFPORTDUPLEX     => '3',
                    IFINOCTETS       => '0',
                    MAC => '78:FE:3D:36:F7:0D',
                    IFNUMBER         => '506',
                    IFDESCR          => 'ge-0/0/10.0',
                    IFOUTOCTETS      => '0',
                    IFLASTCHANGE     => '(3347) 0:00:33.47',
                    IFMTU            => '1514',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => '1',
                    IFSPEED          => '0',
                    IFINERRORS       => '0'
                },
                {
                    IFINOCTETS       => '0',
                    IFPORTDUPLEX     => '3',
                    MAC => '78:FE:3D:36:F7:0E',
                    IFSTATUS         => '2',
                    IFNAME           => 'ge-0/0/11',
                    IFTYPE           => '6',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(3356) 0:00:33.56',
                    IFOUTOCTETS      => '0',
                    IFDESCR          => 'ge-0/0/11',
                    IFNUMBER         => '507',
                    IFINTERNALSTATUS => '1',
                    IFOUTERRORS      => '0',
                    IFINERRORS       => '0',
                    IFSPEED          => '0'
                },
                {
                    IFINTERNALSTATUS => '1',
                    IFOUTERRORS      => '0',
                    IFINERRORS       => '0',
                    IFSPEED          => '0',
                    IFSTATUS         => '7',
                    MAC => '78:FE:3D:36:F7:0E',
                    IFINOCTETS       => '0',
                    IFPORTDUPLEX     => '3',
                    IFTYPE           => '53',
                    IFNAME           => 'ge-0/0/11.0',
                    IFOUTOCTETS      => '0',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(3359) 0:00:33.59',
                    IFNUMBER         => '508',
                    IFDESCR          => 'ge-0/0/11.0'
                },
                {
                    IFINERRORS       => '0',
                    IFSPEED          => '0',
                    IFINTERNALSTATUS => '1',
                    IFOUTERRORS      => '0',
                    IFLASTCHANGE     => '(3367) 0:00:33.67',
                    IFMTU            => '1514',
                    IFOUTOCTETS      => '0',
                    IFDESCR          => 'ge-0/0/12',
                    IFNUMBER         => '509',
                    MAC => '78:FE:3D:36:F7:0F',
                    IFINOCTETS       => '0',
                    IFPORTDUPLEX     => '3',
                    IFSTATUS         => '2',
                    IFNAME           => 'ge-0/0/12',
                    IFTYPE           => '6'
                },
                {
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(3371) 0:00:33.71',
                    IFOUTOCTETS      => '0',
                    IFDESCR          => 'ge-0/0/12.0',
                    IFNUMBER         => '510',
                    MAC => '78:FE:3D:36:F7:0F',
                    IFINOCTETS       => '0',
                    IFPORTDUPLEX     => '3',
                    IFSTATUS         => '7',
                    IFNAME           => 'ge-0/0/12.0',
                    IFTYPE           => '53',
                    IFINERRORS       => '0',
                    IFSPEED          => '0',
                    IFINTERNALSTATUS => '1',
                    IFOUTERRORS      => '0'
                },
                {
                    IFINTERNALSTATUS => '1',
                    IFOUTERRORS      => '0',
                    IFINERRORS       => '0',
                    IFSPEED          => '1000000000',
                    IFSTATUS         => '1',
                    IFINOCTETS       => '3030652257',
                    IFPORTDUPLEX     => '3',
                    MAC => '78:FE:3D:36:F7:10',
                    IFTYPE           => '6',
                    IFNAME           => 'ge-0/0/13',
                    IFOUTOCTETS      => '3013626698',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(577843267) 66 days, 21:07:12.67',
                    IFNUMBER         => '511',
                    IFDESCR          => 'ge-0/0/13'
                },
                {
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => '1',
                    IFSPEED          => '0',
                    IFINERRORS       => '0',
                    IFNAME           => 'ge-0/0/13.0',
                    IFTYPE           => '53',
                    IFINOCTETS       => '33585640',
                    MAC => '78:FE:3D:36:F7:10',
                    IFPORTDUPLEX     => '3',
                    IFSTATUS         => '1',
                    IFDESCR          => 'ge-0/0/13.0',
                    IFNUMBER         => '512',
                    IFLASTCHANGE     => '(577843267) 66 days, 21:07:12.67',
                    IFMTU            => '1514',
                    IFOUTOCTETS      => '465476805'
                },
                {
                    IFLASTCHANGE     => '(654577277) 75 days, 18:16:12.77',
                    IFMTU            => '1514',
                    IFOUTOCTETS      => '1283149072',
                    IFDESCR          => 'ge-0/0/14',
                    IFNUMBER         => '513',
                    IFINOCTETS       => '3319962578',
                    MAC => '78:FE:3D:36:F7:11',
                    IFPORTDUPLEX     => '3',
                    IFSTATUS         => '1',
                    IFNAME           => 'ge-0/0/14',
                    IFTYPE           => '6',
                    IFINERRORS       => '0',
                    IFSPEED          => '1000000000',
                    IFINTERNALSTATUS => '1',
                    IFOUTERRORS      => '0'
                },
                {
                    IFLASTCHANGE     => '(654577277) 75 days, 18:16:12.77',
                    IFMTU            => '1514',
                    IFOUTOCTETS      => '465486252',
                    IFDESCR          => 'ge-0/0/14.0',
                    IFNUMBER         => '514',
                    IFPORTDUPLEX     => '3',
                    IFINOCTETS       => '8379249',
                    MAC => '78:FE:3D:36:F7:11',
                    IFSTATUS         => '1',
                    IFNAME           => 'ge-0/0/14.0',
                    IFTYPE           => '53',
                    IFINERRORS       => '0',
                    IFSPEED          => '0',
                    IFINTERNALSTATUS => '1',
                    IFOUTERRORS      => '0'
                },
                {
                    IFNAME           => 'ge-0/0/15',
                    IFTYPE           => '6',
                    IFINOCTETS       => '0',
                    IFPORTDUPLEX     => '3',
                    MAC => '78:FE:3D:36:F7:12',
                    IFSTATUS         => '2',
                    IFDESCR          => 'ge-0/0/15',
                    IFNUMBER         => '515',
                    IFLASTCHANGE     => '(3405) 0:00:34.05',
                    IFMTU            => '1514',
                    IFOUTOCTETS      => '0',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => '1',
                    IFSPEED          => '0',
                    IFINERRORS       => '0'
                },
                {
                    IFINTERNALSTATUS => '1',
                    IFOUTERRORS      => '0',
                    IFINERRORS       => '0',
                    IFSPEED          => '0',
                    IFINOCTETS       => '0',
                    IFPORTDUPLEX     => '3',
                    MAC => '78:FE:3D:36:F7:12',
                    IFSTATUS         => '7',
                    IFNAME           => 'ge-0/0/15.0',
                    IFTYPE           => '53',
                    IFLASTCHANGE     => '(3407) 0:00:34.07',
                    IFMTU            => '1514',
                    IFOUTOCTETS      => '0',
                    IFDESCR          => 'ge-0/0/15.0',
                    IFNUMBER         => '516'
                },
                {
                    IFNUMBER         => '517',
                    IFDESCR          => 'ge-0/0/16',
                    IFOUTOCTETS      => '0',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(3414) 0:00:34.14',
                    IFTYPE           => '6',
                    IFNAME           => 'ge-0/0/16',
                    IFSTATUS         => '2',
                    IFPORTDUPLEX     => '3',
                    IFINOCTETS       => '0',
                    MAC => '78:FE:3D:36:F7:13',
                    IFSPEED          => '0',
                    IFINERRORS       => '0',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => '1'
                },
                {
                    IFNUMBER         => '518',
                    IFDESCR          => 'ge-0/0/16.0',
                    IFOUTOCTETS      => '0',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(3418) 0:00:34.18',
                    IFTYPE           => '53',
                    IFNAME           => 'ge-0/0/16.0',
                    IFSTATUS         => '7',
                    IFINOCTETS       => '0',
                    IFPORTDUPLEX     => '3',
                    MAC => '78:FE:3D:36:F7:13',
                    IFSPEED          => '0',
                    IFINERRORS       => '0',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => '1'
                },
                {
                    MAC => '78:FE:3D:36:F7:14',
                    IFINOCTETS       => '0',
                    IFPORTDUPLEX     => '3',
                    IFSTATUS         => '2',
                    IFNAME           => 'ge-0/0/17',
                    IFTYPE           => '6',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(3424) 0:00:34.24',
                    IFOUTOCTETS      => '0',
                    IFDESCR          => 'ge-0/0/17',
                    IFNUMBER         => '519',
                    IFINTERNALSTATUS => '1',
                    IFOUTERRORS      => '0',
                    IFINERRORS       => '0',
                    IFSPEED          => '0'
                },
                {
                    IFNUMBER         => '520',
                    IFDESCR          => 'ge-0/0/17.0',
                    IFOUTOCTETS      => '0',
                    IFLASTCHANGE     => '(3435) 0:00:34.35',
                    IFMTU            => '1514',
                    IFTYPE           => '53',
                    IFNAME           => 'ge-0/0/17.0',
                    IFSTATUS         => '7',
                    IFPORTDUPLEX     => '3',
                    IFINOCTETS       => '0',
                    MAC => '78:FE:3D:36:F7:14',
                    IFSPEED          => '0',
                    IFINERRORS       => '0',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => '1'
                },
                {
                    IFSPEED          => '0',
                    IFINERRORS       => '0',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => '1',
                    IFNUMBER         => '521',
                    IFDESCR          => 'ge-0/0/18',
                    IFOUTOCTETS      => '0',
                    IFLASTCHANGE     => '(3426) 0:00:34.26',
                    IFMTU            => '1514',
                    IFTYPE           => '6',
                    IFNAME           => 'ge-0/0/18',
                    IFSTATUS         => '2',
                    IFPORTDUPLEX     => '3',
                    IFINOCTETS       => '0',
                    MAC => '78:FE:3D:36:F7:15'
                },
                {
                    IFDESCR          => 'ge-0/0/18.0',
                    IFNUMBER         => '522',
                    IFLASTCHANGE     => '(3446) 0:00:34.46',
                    IFMTU            => '1514',
                    IFOUTOCTETS      => '0',
                    IFNAME           => 'ge-0/0/18.0',
                    IFTYPE           => '53',
                    IFINOCTETS       => '0',
                    MAC => '78:FE:3D:36:F7:15',
                    IFPORTDUPLEX     => '3',
                    IFSTATUS         => '7',
                    IFSPEED          => '0',
                    IFINERRORS       => '0',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => '1'
                },
                {
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => '1',
                    IFSPEED          => '0',
                    IFINERRORS       => '0',
                    IFTYPE           => '6',
                    IFNAME           => 'ge-0/0/19',
                    IFSTATUS         => '2',
                    IFINOCTETS       => '0',
                    IFPORTDUPLEX     => '3',
                    MAC => '78:FE:3D:36:F7:16',
                    IFNUMBER         => '523',
                    IFDESCR          => 'ge-0/0/19',
                    IFOUTOCTETS      => '0',
                    IFLASTCHANGE     => '(3442) 0:00:34.42',
                    IFMTU            => '1514'
                },
                {
                    IFNAME           => 'ge-0/0/19.0',
                    IFTYPE           => '53',
                    IFINOCTETS       => '0',
                    MAC => '78:FE:3D:36:F7:16',
                    IFPORTDUPLEX     => '3',
                    IFSTATUS         => '7',
                    IFDESCR          => 'ge-0/0/19.0',
                    IFNUMBER         => '524',
                    IFLASTCHANGE     => '(3454) 0:00:34.54',
                    IFMTU            => '1514',
                    IFOUTOCTETS      => '0',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => '1',
                    IFSPEED          => '0',
                    IFINERRORS       => '0'
                },
                {
                    IFTYPE           => '6',
                    IFNAME           => 'ge-0/0/2',
                    IFSTATUS         => '2',
                    IFINOCTETS       => '0',
                    IFPORTDUPLEX     => '3',
                    MAC => '78:FE:3D:36:F7:05',
                    IFNUMBER         => '525',
                    IFDESCR          => 'ge-0/0/2',
                    IFOUTOCTETS      => '0',
                    IFLASTCHANGE     => '(3248) 0:00:32.48',
                    IFMTU            => '1514',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => '1',
                    IFSPEED          => '0',
                    IFINERRORS       => '0'
                },
                {
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => '1',
                    IFSPEED          => '0',
                    IFINERRORS       => '0',
                    IFTYPE           => '53',
                    IFNAME           => 'ge-0/0/2.0',
                    IFSTATUS         => '7',
                    IFINOCTETS       => '0',
                    IFPORTDUPLEX     => '3',
                    MAC => '78:FE:3D:36:F7:05',
                    IFNUMBER         => '526',
                    IFDESCR          => 'ge-0/0/2.0',
                    IFOUTOCTETS      => '0',
                    IFLASTCHANGE     => '(3250) 0:00:32.50',
                    IFMTU            => '1514'
                },
                {
                    MAC => '78:FE:3D:36:F7:17',
                    IFINOCTETS       => '0',
                    IFPORTDUPLEX     => '3',
                    IFSTATUS         => '2',
                    IFNAME           => 'ge-0/0/20',
                    IFTYPE           => '6',
                    IFLASTCHANGE     => '(3449) 0:00:34.49',
                    IFMTU            => '1514',
                    IFOUTOCTETS      => '0',
                    IFDESCR          => 'ge-0/0/20',
                    IFNUMBER         => '527',
                    IFINTERNALSTATUS => '1',
                    IFOUTERRORS      => '0',
                    IFINERRORS       => '0',
                    IFSPEED          => '0'
                },
                {
                    IFINOCTETS       => '0',
                    MAC => '78:FE:3D:36:F7:17',
                    IFPORTDUPLEX     => '3',
                    IFSTATUS         => '7',
                    IFNAME           => 'ge-0/0/20.0',
                    IFTYPE           => '53',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(3460) 0:00:34.60',
                    IFOUTOCTETS      => '0',
                    IFDESCR          => 'ge-0/0/20.0',
                    IFNUMBER         => '528',
                    IFINTERNALSTATUS => '1',
                    IFOUTERRORS      => '0',
                    IFINERRORS       => '0',
                    IFSPEED          => '0'
                },
                {
                    IFNAME           => 'ge-0/0/21',
                    IFTYPE           => '6',
                    MAC => '78:FE:3D:36:F7:18',
                    IFINOCTETS       => '0',
                    IFPORTDUPLEX     => '3',
                    IFSTATUS         => '2',
                    IFDESCR          => 'ge-0/0/21',
                    IFNUMBER         => '529',
                    IFLASTCHANGE     => '(3456) 0:00:34.56',
                    IFMTU            => '1514',
                    IFOUTOCTETS      => '0',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => '1',
                    IFSPEED          => '0',
                    IFINERRORS       => '0'
                },
                {
                    IFINTERNALSTATUS => '1',
                    IFOUTERRORS      => '0',
                    IFINERRORS       => '0',
                    IFSPEED          => '0',
                    IFSTATUS         => '7',
                    IFINOCTETS       => '0',
                    MAC => '78:FE:3D:36:F7:18',
                    IFPORTDUPLEX     => '3',
                    IFTYPE           => '53',
                    IFNAME           => 'ge-0/0/21.0',
                    IFOUTOCTETS      => '0',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(3474) 0:00:34.74',
                    IFNUMBER         => '530',
                    IFDESCR          => 'ge-0/0/21.0'
                },
                {
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => '1',
                    IFSPEED          => '0',
                    IFINERRORS       => '0',
                    IFTYPE           => '6',
                    IFNAME           => 'ge-0/0/22',
                    IFSTATUS         => '2',
                    IFINOCTETS       => '0',
                    IFPORTDUPLEX     => '3',
                    MAC => '78:FE:3D:36:F7:19',
                    IFNUMBER         => '531',
                    IFDESCR          => 'ge-0/0/22',
                    IFOUTOCTETS      => '0',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(3462) 0:00:34.62'
                },
                {
                    IFINTERNALSTATUS => '1',
                    IFOUTERRORS      => '0',
                    IFINERRORS       => '0',
                    IFSPEED          => '0',
                    IFINOCTETS       => '0',
                    IFPORTDUPLEX     => '3',
                    MAC => '78:FE:3D:36:F7:19',
                    IFSTATUS         => '7',
                    IFNAME           => 'ge-0/0/22.0',
                    IFTYPE           => '53',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(3501) 0:00:35.01',
                    IFOUTOCTETS      => '0',
                    IFDESCR          => 'ge-0/0/22.0',
                    IFNUMBER         => '532'
                },
                {
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(3467) 0:00:34.67',
                    IFOUTOCTETS      => '0',
                    IFDESCR          => 'ge-0/0/23',
                    IFNUMBER         => '533',
                    IFPORTDUPLEX     => '3',
                    IFINOCTETS       => '0',
                    MAC => '78:FE:3D:36:F7:1A',
                    IFSTATUS         => '2',
                    IFNAME           => 'ge-0/0/23',
                    IFTYPE           => '6',
                    IFINERRORS       => '0',
                    IFSPEED          => '0',
                    IFINTERNALSTATUS => '1',
                    IFOUTERRORS      => '0'
                },
                {
                    IFDESCR          => 'ge-0/0/23.0',
                    IFNUMBER         => '534',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(3519) 0:00:35.19',
                    IFOUTOCTETS      => '0',
                    IFNAME           => 'ge-0/0/23.0',
                    IFTYPE           => '53',
                    IFINOCTETS       => '0',
                    MAC => '78:FE:3D:36:F7:1A',
                    IFPORTDUPLEX     => '3',
                    IFSTATUS         => '7',
                    IFSPEED          => '0',
                    IFINERRORS       => '0',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => '1'
                },
                {
                    IFNAME           => 'ge-0/0/24',
                    IFTYPE           => '6',
                    IFINOCTETS       => '0',
                    IFPORTDUPLEX     => '3',
                    MAC => '78:FE:3D:36:F7:1B',
                    IFSTATUS         => '2',
                    IFDESCR          => 'ge-0/0/24',
                    IFNUMBER         => '535',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(3471) 0:00:34.71',
                    IFOUTOCTETS      => '0',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => '1',
                    IFSPEED          => '0',
                    IFINERRORS       => '0'
                },
                {
                    IFSTATUS         => '7',
                    IFINOCTETS       => '0',
                    MAC => '78:FE:3D:36:F7:1B',
                    IFPORTDUPLEX     => '3',
                    IFTYPE           => '53',
                    IFNAME           => 'ge-0/0/24.0',
                    IFOUTOCTETS      => '0',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(3532) 0:00:35.32',
                    IFNUMBER         => '536',
                    IFDESCR          => 'ge-0/0/24.0',
                    IFINTERNALSTATUS => '1',
                    IFOUTERRORS      => '0',
                    IFINERRORS       => '0',
                    IFSPEED          => '0'
                },
                {
                    IFTYPE           => '6',
                    IFNAME           => 'ge-0/0/25',
                    IFSTATUS         => '1',
                    MAC => '78:FE:3D:36:F7:1C',
                    IFINOCTETS       => '995965943',
                    IFPORTDUPLEX     => '3',
                    IFNUMBER         => '537',
                    IFDESCR          => 'ge-0/0/25',
                    IFOUTOCTETS      => '3951591485',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(7370) 0:01:13.70',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => '1',
                    IFSPEED          => '1000000000',
                    IFINERRORS       => '0'
                },
                {
                    IFINOCTETS       => '5187440',
                    IFPORTDUPLEX     => '3',
                    MAC => '78:FE:3D:36:F7:1C',
                    IFSTATUS         => '1',
                    IFNAME           => 'ge-0/0/25.0',
                    IFTYPE           => '53',
                    IFLASTCHANGE     => '(7370) 0:01:13.70',
                    IFMTU            => '1514',
                    IFOUTOCTETS      => '466471737',
                    IFDESCR          => 'ge-0/0/25.0',
                    IFNUMBER         => '538',
                    IFINTERNALSTATUS => '1',
                    IFOUTERRORS      => '0',
                    IFINERRORS       => '0',
                    IFSPEED          => '0'
                },
                {
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => '1',
                    IFSPEED          => '0',
                    IFINERRORS       => '0',
                    IFTYPE           => '6',
                    IFNAME           => 'ge-0/0/26',
                    IFSTATUS         => '2',
                    IFPORTDUPLEX     => '3',
                    IFINOCTETS       => '0',
                    MAC => '78:FE:3D:36:F7:1D',
                    IFNUMBER         => '539',
                    IFDESCR          => 'ge-0/0/26',
                    IFOUTOCTETS      => '0',
                    IFLASTCHANGE     => '(3487) 0:00:34.87',
                    IFMTU            => '1514'
                },
                {
                    IFSPEED          => '0',
                    IFINERRORS       => '0',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => '1',
                    IFNUMBER         => '540',
                    IFDESCR          => 'ge-0/0/26.0',
                    IFOUTOCTETS      => '0',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(3589) 0:00:35.89',
                    IFTYPE           => '53',
                    IFNAME           => 'ge-0/0/26.0',
                    IFSTATUS         => '7',
                    IFPORTDUPLEX     => '3',
                    IFINOCTETS       => '0',
                    MAC => '78:FE:3D:36:F7:1D'
                },
                {
                    IFINERRORS       => '0',
                    IFSPEED          => '0',
                    IFINTERNALSTATUS => '1',
                    IFOUTERRORS      => '0',
                    IFOUTOCTETS      => '0',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(3493) 0:00:34.93',
                    IFNUMBER         => '541',
                    IFDESCR          => 'ge-0/0/27',
                    IFSTATUS         => '2',
                    MAC => '78:FE:3D:36:F7:1E',
                    IFINOCTETS       => '0',
                    IFPORTDUPLEX     => '3',
                    IFTYPE           => '6',
                    IFNAME           => 'ge-0/0/27'
                },
                {
                    IFINERRORS       => '0',
                    IFSPEED          => '0',
                    IFINTERNALSTATUS => '1',
                    IFOUTERRORS      => '0',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(3605) 0:00:36.05',
                    IFOUTOCTETS      => '0',
                    IFDESCR          => 'ge-0/0/27.0',
                    IFNUMBER         => '542',
                    IFINOCTETS       => '0',
                    IFPORTDUPLEX     => '3',
                    MAC => '78:FE:3D:36:F7:1E',
                    IFSTATUS         => '7',
                    IFNAME           => 'ge-0/0/27.0',
                    IFTYPE           => '53'
                },
                {
                    IFSPEED          => '0',
                    IFINERRORS       => '0',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => '1',
                    IFNUMBER         => '543',
                    IFDESCR          => 'ge-0/0/28',
                    IFOUTOCTETS      => '0',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(3496) 0:00:34.96',
                    IFTYPE           => '6',
                    IFNAME           => 'ge-0/0/28',
                    IFSTATUS         => '2',
                    IFINOCTETS       => '0',
                    IFPORTDUPLEX     => '3',
                    MAC => '78:FE:3D:36:F7:1F'
                },
                {
                    IFLASTCHANGE     => '(3630) 0:00:36.30',
                    IFMTU            => '1514',
                    IFOUTOCTETS      => '0',
                    IFDESCR          => 'ge-0/0/28.0',
                    IFNUMBER         => '544',
                    IFPORTDUPLEX     => '3',
                    IFINOCTETS       => '0',
                    MAC => '78:FE:3D:36:F7:1F',
                    IFSTATUS         => '7',
                    IFNAME           => 'ge-0/0/28.0',
                    IFTYPE           => '53',
                    IFINERRORS       => '0',
                    IFSPEED          => '0',
                    IFINTERNALSTATUS => '1',
                    IFOUTERRORS      => '0'
                },
                {
                    IFSPEED          => '0',
                    IFINERRORS       => '0',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => '1',
                    IFNUMBER         => '545',
                    IFDESCR          => 'ge-0/0/29',
                    IFOUTOCTETS      => '0',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(3505) 0:00:35.05',
                    IFTYPE           => '6',
                    IFNAME           => 'ge-0/0/29',
                    IFSTATUS         => '2',
                    IFINOCTETS       => '0',
                    IFPORTDUPLEX     => '3',
                    MAC => '78:FE:3D:36:F7:20'
                },
                {
                    IFINERRORS       => '0',
                    IFSPEED          => '0',
                    IFINTERNALSTATUS => '1',
                    IFOUTERRORS      => '0',
                    IFOUTOCTETS      => '0',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(3641) 0:00:36.41',
                    IFNUMBER         => '546',
                    IFDESCR          => 'ge-0/0/29.0',
                    IFSTATUS         => '7',
                    IFINOCTETS       => '0',
                    IFPORTDUPLEX     => '3',
                    MAC => '78:FE:3D:36:F7:20',
                    IFTYPE           => '53',
                    IFNAME           => 'ge-0/0/29.0'
                },
                {
                    IFSTATUS         => '2',
                    IFPORTDUPLEX     => '3',
                    IFINOCTETS       => '0',
                    MAC => '78:FE:3D:36:F7:06',
                    IFTYPE           => '6',
                    IFNAME           => 'ge-0/0/3',
                    IFOUTOCTETS      => '0',
                    IFLASTCHANGE     => '(3252) 0:00:32.52',
                    IFMTU            => '1514',
                    IFNUMBER         => '547',
                    IFDESCR          => 'ge-0/0/3',
                    IFINTERNALSTATUS => '1',
                    IFOUTERRORS      => '0',
                    IFINERRORS       => '0',
                    IFSPEED          => '0'
                },
                {
                    IFINTERNALSTATUS => '1',
                    IFOUTERRORS      => '0',
                    IFINERRORS       => '0',
                    IFSPEED          => '0',
                    IFSTATUS         => '7',
                    IFPORTDUPLEX     => '3',
                    IFINOCTETS       => '0',
                    MAC => '78:FE:3D:36:F7:06',
                    IFTYPE           => '53',
                    IFNAME           => 'ge-0/0/3.0',
                    IFOUTOCTETS      => '0',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(3253) 0:00:32.53',
                    IFNUMBER         => '548',
                    IFDESCR          => 'ge-0/0/3.0'
                },
                {
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => '1',
                    IFSPEED          => '0',
                    IFINERRORS       => '0',
                    IFNAME           => 'ge-0/0/30',
                    IFTYPE           => '6',
                    IFPORTDUPLEX     => '3',
                    IFINOCTETS       => '0',
                    MAC => '78:FE:3D:36:F7:21',
                    IFSTATUS         => '2',
                    IFDESCR          => 'ge-0/0/30',
                    IFNUMBER         => '549',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(3508) 0:00:35.08',
                    IFOUTOCTETS      => '0'
                },
                {
                    MAC => '78:FE:3D:36:F7:21',
                    IFINOCTETS       => '0',
                    IFPORTDUPLEX     => '3',
                    IFSTATUS         => '7',
                    IFNAME           => 'ge-0/0/30.0',
                    IFTYPE           => '53',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(3645) 0:00:36.45',
                    IFOUTOCTETS      => '0',
                    IFDESCR          => 'ge-0/0/30.0',
                    IFNUMBER         => '550',
                    IFINTERNALSTATUS => '1',
                    IFOUTERRORS      => '0',
                    IFINERRORS       => '0',
                    IFSPEED          => '0'
                },
                {
                    IFINTERNALSTATUS => '1',
                    IFOUTERRORS      => '0',
                    IFINERRORS       => '0',
                    IFSPEED          => '1000000000',
                    IFINOCTETS       => '141635944',
                    IFPORTDUPLEX     => '3',
                    MAC => '78:FE:3D:36:F7:22',
                    IFSTATUS         => '1',
                    IFNAME           => 'ge-0/0/31',
                    IFTYPE           => '6',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(688688737) 79 days, 17:01:27.37',
                    IFOUTOCTETS      => '3460900081',
                    IFDESCR          => 'ge-0/0/31',
                    IFNUMBER         => '551'
                },
                {
                    IFINERRORS       => '0',
                    IFSPEED          => '0',
                    IFINTERNALSTATUS => '1',
                    IFOUTERRORS      => '0',
                    IFOUTOCTETS      => '421381483',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(688688737) 79 days, 17:01:27.37',
                    IFNUMBER         => '552',
                    IFDESCR          => 'ge-0/0/31.0',
                    IFSTATUS         => '1',
                    MAC => '78:FE:3D:36:F7:22',
                    IFINOCTETS       => '500773',
                    IFPORTDUPLEX     => '3',
                    IFTYPE           => '53',
                    IFNAME           => 'ge-0/0/31.0'
                },
                {
                    IFNAME           => 'ge-0/0/32',
                    IFTYPE           => '6',
                    IFINOCTETS       => '86562173',
                    MAC => '78:FE:3D:36:F7:23',
                    IFPORTDUPLEX     => '3',
                    IFSTATUS         => '1',
                    IFDESCR          => 'ge-0/0/32',
                    IFNUMBER         => '553',
                    IFLASTCHANGE     => '(689602367) 79 days, 19:33:43.67',
                    IFMTU            => '1514',
                    IFOUTOCTETS      => '1295216410',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => '1',
                    IFSPEED          => '10000000',
                    IFINERRORS       => '0'
                },
                {
                    IFNAME           => 'ge-0/0/32.0',
                    IFTYPE           => '53',
                    IFINOCTETS       => '694827',
                    IFPORTDUPLEX     => '3',
                    MAC => '78:FE:3D:36:F7:23',
                    IFSTATUS         => '1',
                    IFDESCR          => 'ge-0/0/32.0',
                    IFNUMBER         => '554',
                    IFLASTCHANGE     => '(689602367) 79 days, 19:33:43.67',
                    IFMTU            => '1514',
                    IFOUTOCTETS      => '61338038',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => '1',
                    IFSPEED          => '0',
                    IFINERRORS       => '0'
                },
                {
                    IFSPEED          => '1000000000',
                    IFINERRORS       => '0',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => '1',
                    IFDESCR          => 'ge-0/0/33',
                    IFNUMBER         => '555',
                    IFLASTCHANGE     => '(7371) 0:01:13.71',
                    IFMTU            => '1514',
                    IFOUTOCTETS      => '3301180591',
                    IFNAME           => 'ge-0/0/33',
                    IFTYPE           => '6',
                    MAC => '78:FE:3D:36:F7:24',
                    IFINOCTETS       => '4011077581',
                    IFPORTDUPLEX     => '3',
                    IFSTATUS         => '1'
                },
                {
                    IFSPEED          => '0',
                    IFINERRORS       => '0',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => '1',
                    IFDESCR          => 'ge-0/0/33.0',
                    IFNUMBER         => '556',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(7371) 0:01:13.71',
                    IFOUTOCTETS      => '449527190',
                    IFNAME           => 'ge-0/0/33.0',
                    IFTYPE           => '53',
                    MAC => '78:FE:3D:36:F7:24',
                    IFINOCTETS       => '7570937',
                    IFPORTDUPLEX     => '3',
                    IFSTATUS         => '1'
                },
                {
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => '1',
                    IFSPEED          => '1000000000',
                    IFINERRORS       => '0',
                    IFTYPE           => '6',
                    IFNAME           => 'ge-0/0/34',
                    IFSTATUS         => '1',
                    IFPORTDUPLEX     => '3',
                    IFINOCTETS       => '1188771734',
                    MAC => '78:FE:3D:36:F7:25',
                    IFNUMBER         => '557',
                    IFDESCR          => 'ge-0/0/34',
                    IFOUTOCTETS      => '3796981610',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(605122587) 70 days, 0:53:45.87'
                },
                {
                    IFDESCR          => 'ge-0/0/34.0',
                    IFNUMBER         => '558',
                    IFLASTCHANGE     => '(605122587) 70 days, 0:53:45.87',
                    IFMTU            => '1514',
                    IFOUTOCTETS      => '464675284',
                    IFNAME           => 'ge-0/0/34.0',
                    IFTYPE           => '53',
                    MAC => '78:FE:3D:36:F7:25',
                    IFINOCTETS       => '5660368',
                    IFPORTDUPLEX     => '3',
                    IFSTATUS         => '1',
                    IFSPEED          => '0',
                    IFINERRORS       => '0',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => '1'
                },
                {
                    IFSPEED          => '1000000000',
                    IFINERRORS       => '0',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => '1',
                    IFDESCR          => 'ge-0/0/35',
                    IFNUMBER         => '559',
                    IFLASTCHANGE     => '(603753039) 69 days, 21:05:30.39',
                    IFMTU            => '1514',
                    IFOUTOCTETS      => '1859341136',
                    IFNAME           => 'ge-0/0/35',
                    IFTYPE           => '6',
                    IFINOCTETS       => '717085133',
                    MAC => '78:FE:3D:36:F7:26',
                    IFPORTDUPLEX     => '3',
                    IFSTATUS         => '2'
                },
                {
                    IFSPEED          => '0',
                    IFINERRORS       => '0',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => '1',
                    IFDESCR          => 'ge-0/0/35.0',
                    IFNUMBER         => '560',
                    IFLASTCHANGE     => '(603753039) 69 days, 21:05:30.39',
                    IFMTU            => '1514',
                    IFOUTOCTETS      => '407661671',
                    IFNAME           => 'ge-0/0/35.0',
                    IFTYPE           => '53',
                    IFINOCTETS       => '6150747',
                    IFPORTDUPLEX     => '3',
                    MAC => '78:FE:3D:36:F7:26',
                    IFSTATUS         => '7'
                },
                {
                    IFINERRORS       => '0',
                    IFSPEED          => '1000000000',
                    IFINTERNALSTATUS => '1',
                    IFOUTERRORS      => '0',
                    IFLASTCHANGE     => '(630152097) 72 days, 22:25:20.97',
                    IFMTU            => '1514',
                    IFOUTOCTETS      => '3123063969',
                    IFDESCR          => 'ge-0/0/36',
                    IFNUMBER         => '561',
                    IFINOCTETS       => '2150647287',
                    IFPORTDUPLEX     => '3',
                    MAC => '78:FE:3D:36:F7:27',
                    IFSTATUS         => '1',
                    IFNAME           => 'ge-0/0/36',
                    IFTYPE           => '6'
                },
                {
                    IFDESCR          => 'ge-0/0/36.0',
                    IFNUMBER         => '562',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(630152097) 72 days, 22:25:20.97',
                    IFOUTOCTETS      => '76952215',
                    IFNAME           => 'ge-0/0/36.0',
                    IFTYPE           => '53',
                    IFINOCTETS       => '210659779',
                    MAC => '78:FE:3D:36:F7:27',
                    IFPORTDUPLEX     => '3',
                    IFSTATUS         => '1',
                    IFSPEED          => '0',
                    IFINERRORS       => '0',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => '1'
                },
                {
                    IFOUTOCTETS      => '713610076',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(672589657) 77 days, 20:18:16.57',
                    IFNUMBER         => '563',
                    IFDESCR          => 'ge-0/0/37',
                    IFSTATUS         => '1',
                    IFINOCTETS       => '2139115923',
                    IFPORTDUPLEX     => '3',
                    MAC => '78:FE:3D:36:F7:28',
                    IFTYPE           => '6',
                    IFNAME           => 'ge-0/0/37',
                    IFINERRORS       => '0',
                    IFSPEED          => '100000000',
                    IFINTERNALSTATUS => '1',
                    IFOUTERRORS      => '0'
                },
                {
                    IFNAME           => 'ge-0/0/37.0',
                    IFTYPE           => '53',
                    IFINOCTETS       => '2007812',
                    MAC => '78:FE:3D:36:F7:28',
                    IFPORTDUPLEX     => '3',
                    IFSTATUS         => '1',
                    IFDESCR          => 'ge-0/0/37.0',
                    IFNUMBER         => '564',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(672589657) 77 days, 20:18:16.57',
                    IFOUTOCTETS      => '449518210',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => '1',
                    IFSPEED          => '0',
                    IFINERRORS       => '0'
                },
                {
                    IFINERRORS       => '0',
                    IFSPEED          => '1000000000',
                    IFINTERNALSTATUS => '1',
                    IFOUTERRORS      => '0',
                    IFOUTOCTETS      => '3562479292',
                    IFLASTCHANGE     => '(671864217) 77 days, 18:17:22.17',
                    IFMTU            => '1514',
                    IFNUMBER         => '565',
                    IFDESCR          => 'ge-0/0/38',
                    IFSTATUS         => '1',
                    IFINOCTETS       => '2276628107',
                    IFPORTDUPLEX     => '3',
                    MAC => '78:FE:3D:36:F7:29',
                    IFTYPE           => '6',
                    IFNAME           => 'ge-0/0/38'
                },
                {
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => '1',
                    IFSPEED          => '0',
                    IFINERRORS       => '0',
                    IFTYPE           => '53',
                    IFNAME           => 'ge-0/0/38.0',
                    IFSTATUS         => '1',
                    IFINOCTETS       => '3779632',
                    MAC => '78:FE:3D:36:F7:29',
                    IFPORTDUPLEX     => '3',
                    IFNUMBER         => '566',
                    IFDESCR          => 'ge-0/0/38.0',
                    IFOUTOCTETS      => '449506711',
                    IFLASTCHANGE     => '(671864217) 77 days, 18:17:22.17',
                    IFMTU            => '1514'
                },
                {
                    IFOUTOCTETS      => '0',
                    IFLASTCHANGE     => '(3579) 0:00:35.79',
                    IFMTU            => '1514',
                    IFNUMBER         => '567',
                    IFDESCR          => 'ge-0/0/39',
                    IFSTATUS         => '2',
                    IFINOCTETS       => '0',
                    IFPORTDUPLEX     => '3',
                    MAC => '78:FE:3D:36:F7:2A',
                    IFTYPE           => '6',
                    IFNAME           => 'ge-0/0/39',
                    IFINERRORS       => '0',
                    IFSPEED          => '0',
                    IFINTERNALSTATUS => '1',
                    IFOUTERRORS      => '0'
                },
                {
                    IFINERRORS       => '0',
                    IFSPEED          => '0',
                    IFINTERNALSTATUS => '1',
                    IFOUTERRORS      => '0',
                    IFOUTOCTETS      => '0',
                    IFLASTCHANGE     => '(3785) 0:00:37.85',
                    IFMTU            => '1514',
                    IFNUMBER         => '568',
                    IFDESCR          => 'ge-0/0/39.0',
                    IFSTATUS         => '7',
                    MAC => '78:FE:3D:36:F7:2A',
                    IFINOCTETS       => '0',
                    IFPORTDUPLEX     => '3',
                    IFTYPE           => '53',
                    IFNAME           => 'ge-0/0/39.0'
                },
                {
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => '1',
                    IFSPEED          => '0',
                    IFINERRORS       => '0',
                    IFTYPE           => '6',
                    IFNAME           => 'ge-0/0/4',
                    IFSTATUS         => '2',
                    IFINOCTETS       => '0',
                    MAC => '78:FE:3D:36:F7:07',
                    IFPORTDUPLEX     => '3',
                    IFNUMBER         => '569',
                    IFDESCR          => 'ge-0/0/4',
                    IFOUTOCTETS      => '0',
                    IFLASTCHANGE     => '(3256) 0:00:32.56',
                    IFMTU            => '1514'
                },
                {
                    IFSTATUS         => '7',
                    IFINOCTETS       => '0',
                    MAC => '78:FE:3D:36:F7:07',
                    IFPORTDUPLEX     => '3',
                    IFTYPE           => '53',
                    IFNAME           => 'ge-0/0/4.0',
                    IFOUTOCTETS      => '0',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(3258) 0:00:32.58',
                    IFNUMBER         => '570',
                    IFDESCR          => 'ge-0/0/4.0',
                    IFINTERNALSTATUS => '1',
                    IFOUTERRORS      => '0',
                    IFINERRORS       => '0',
                    IFSPEED          => '0'
                },
                {
                    IFSPEED          => '10000000',
                    IFINERRORS       => '0',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => '1',
                    IFNUMBER         => '571',
                    IFDESCR          => 'ge-0/0/40',
                    IFOUTOCTETS      => '2633122441',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(623010977) 72 days, 2:35:09.77',
                    IFTYPE           => '6',
                    IFNAME           => 'ge-0/0/40',
                    IFSTATUS         => '1',
                    IFINOCTETS       => '3533234512',
                    MAC => '78:FE:3D:36:F7:2B',
                    IFPORTDUPLEX     => '3'
                },
                {
                    IFINTERNALSTATUS => '1',
                    IFOUTERRORS      => '0',
                    IFINERRORS       => '0',
                    IFSPEED          => '0',
                    IFPORTDUPLEX     => '3',
                    IFINOCTETS       => '3134933',
                    MAC => '78:FE:3D:36:F7:2B',
                    IFSTATUS         => '1',
                    IFNAME           => 'ge-0/0/40.0',
                    IFTYPE           => '53',
                    IFLASTCHANGE     => '(623010977) 72 days, 2:35:09.77',
                    IFMTU            => '1514',
                    IFOUTOCTETS      => '449446120',
                    IFDESCR          => 'ge-0/0/40.0',
                    IFNUMBER         => '572'
                },
                {
                    IFINERRORS       => '0',
                    IFSPEED          => '100000000',
                    IFINTERNALSTATUS => '1',
                    IFOUTERRORS      => '0',
                    IFLASTCHANGE     => '(380811077) 44 days, 1:48:30.77',
                    IFMTU            => '1514',
                    IFOUTOCTETS      => '1143757502',
                    IFDESCR          => 'ge-0/0/41',
                    IFNUMBER         => '573',
                    IFINOCTETS       => '3363359789',
                    MAC => '78:FE:3D:36:F7:2C',
                    IFPORTDUPLEX     => '3',
                    IFSTATUS         => '1',
                    IFNAME           => 'ge-0/0/41',
                    IFTYPE           => '6'
                },
                {
                    IFOUTOCTETS      => '449497792',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(380811077) 44 days, 1:48:30.77',
                    IFNUMBER         => '574',
                    IFDESCR          => 'ge-0/0/41.0',
                    IFSTATUS         => '1',
                    IFINOCTETS       => '6930628',
                    MAC => '78:FE:3D:36:F7:2C',
                    IFPORTDUPLEX     => '3',
                    IFTYPE           => '53',
                    IFNAME           => 'ge-0/0/41.0',
                    IFINERRORS       => '0',
                    IFSPEED          => '0',
                    IFINTERNALSTATUS => '1',
                    IFOUTERRORS      => '0'
                },
                {
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(626710427) 72 days, 12:51:44.27',
                    IFOUTOCTETS      => '1936465493',
                    IFDESCR          => 'ge-0/0/42',
                    IFNUMBER         => '575',
                    IFINOCTETS       => '360348982',
                    MAC => '78:FE:3D:36:F7:2D',
                    IFPORTDUPLEX     => '3',
                    IFSTATUS         => '1',
                    IFNAME           => 'ge-0/0/42',
                    IFTYPE           => '6',
                    IFINERRORS       => '0',
                    IFSPEED          => '100000000',
                    IFINTERNALSTATUS => '1',
                    IFOUTERRORS      => '0'
                },
                {
                    IFINERRORS       => '0',
                    IFSPEED          => '0',
                    IFINTERNALSTATUS => '1',
                    IFOUTERRORS      => '0',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(626710427) 72 days, 12:51:44.27',
                    IFOUTOCTETS      => '93754257',
                    IFDESCR          => 'ge-0/0/42.0',
                    IFNUMBER         => '576',
                    IFPORTDUPLEX     => '3',
                    IFINOCTETS       => '928054',
                    MAC => '78:FE:3D:36:F7:2D',
                    IFSTATUS         => '1',
                    IFNAME           => 'ge-0/0/42.0',
                    IFTYPE           => '53'
                },
                {
                    IFOUTOCTETS      => '0',
                    IFLASTCHANGE     => '(3616) 0:00:36.16',
                    IFMTU            => '1514',
                    IFNUMBER         => '577',
                    IFDESCR          => 'ge-0/0/43',
                    IFSTATUS         => '2',
                    IFINOCTETS       => '0',
                    IFPORTDUPLEX     => '3',
                    MAC => '78:FE:3D:36:F7:2E',
                    IFTYPE           => '6',
                    IFNAME           => 'ge-0/0/43',
                    IFINERRORS       => '0',
                    IFSPEED          => '0',
                    IFINTERNALSTATUS => '1',
                    IFOUTERRORS      => '0'
                },
                {
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => '1',
                    IFSPEED          => '0',
                    IFINERRORS       => '0',
                    IFNAME           => 'ge-0/0/43.0',
                    IFTYPE           => '53',
                    IFINOCTETS       => '0',
                    IFPORTDUPLEX     => '3',
                    MAC => '78:FE:3D:36:F7:2E',
                    IFSTATUS         => '7',
                    IFDESCR          => 'ge-0/0/43.0',
                    IFNUMBER         => '578',
                    IFLASTCHANGE     => '(3833) 0:00:38.33',
                    IFMTU            => '1514',
                    IFOUTOCTETS      => '0'
                },
                {
                    IFINTERNALSTATUS => '1',
                    IFOUTERRORS      => '0',
                    IFINERRORS       => '0',
                    IFSPEED          => '1000000000',
                    IFINOCTETS       => '3158408642',
                    IFPORTDUPLEX     => '3',
                    MAC => '78:FE:3D:36:F7:2F',
                    IFSTATUS         => '1',
                    IFNAME           => 'ge-0/0/44',
                    IFTYPE           => '6',
                    IFLASTCHANGE     => '(654832517) 75 days, 18:58:45.17',
                    IFMTU            => '1514',
                    IFOUTOCTETS      => '4246970219',
                    IFDESCR          => 'ge-0/0/44',
                    IFNUMBER         => '579'
                },
                {
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => '1',
                    IFTYPE           => '53',
                    IFNAME           => 'ge-0/0/44.0',
                    MAC => '78:FE:3D:36:F7:2F',
                    IFPORTDUPLEX     => '3',
                    IFNUMBER         => '580',
                    IFLASTCHANGE     => '(654832517) 75 days, 18:58:45.17',
                    IFMTU            => '1514',
                    IFSPEED          => '0',
                    IFINERRORS       => '0',
                    CONNECTIONS => {
                        CONNECTION => {
                            SYSMAC   => '00:1A:1E:CD:BB:02',
                            IFDESCR  => 'eth0',
                            IFNUMBER => '0x001A1ECDBB02',
                            SYSDESCR => 'ArubaOS (MODEL: 125), Version 6.2.1.2 (38711)',
                            SYSNAME  => 'PMF-sap-c407'
                        },
                        CDP => 1
                    },
                    IFSTATUS         => '1',
                    IFINOCTETS       => '41406521',
                    IFDESCR          => 'ge-0/0/44.0',
                    IFOUTOCTETS      => '449536917'
                },
                {
                    IFSTATUS         => '1',
                    IFPORTDUPLEX     => '3',
                    IFINOCTETS       => '3458219972',
                    MAC => '78:FE:3D:36:F7:30',
                    IFTYPE           => '6',
                    IFNAME           => 'ge-0/0/45',
                    IFOUTOCTETS      => '244487005',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(561606847) 65 days, 0:01:08.47',
                    IFNUMBER         => '581',
                    IFDESCR          => 'ge-0/0/45',
                    IFINTERNALSTATUS => '1',
                    IFOUTERRORS      => '0',
                    IFINERRORS       => '0',
                    IFSPEED          => '1000000000'
                },
                {
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(561606847) 65 days, 0:01:08.47',
                    IFOUTOCTETS      => '465451921',
                    IFDESCR          => 'ge-0/0/45.0',
                    IFNUMBER         => '582',
                    IFINOCTETS       => '16584800',
                    MAC => '78:FE:3D:36:F7:30',
                    IFPORTDUPLEX     => '3',
                    IFSTATUS         => '1',
                    IFNAME           => 'ge-0/0/45.0',
                    IFTYPE           => '53',
                    IFINERRORS       => '0',
                    IFSPEED          => '0',
                    IFINTERNALSTATUS => '1',
                    IFOUTERRORS      => '0'
                },
                {
                    IFINERRORS       => '0',
                    IFSPEED          => '1000000000',
                    IFINTERNALSTATUS => '1',
                    IFOUTERRORS      => '0',
                    IFOUTOCTETS      => '0',
                    IFLASTCHANGE     => '(3635) 0:00:36.35',
                    IFMTU            => '1514',
                    IFNUMBER         => '583',
                    IFDESCR          => 'ge-0/0/46',
                    IFSTATUS         => '2',
                    IFINOCTETS       => '0',
                    IFPORTDUPLEX     => '3',
                    MAC => '78:FE:3D:36:F7:03',
                    IFTYPE           => '6',
                    IFNAME           => 'ge-0/0/46'
                },
                {
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => '1',
                    IFSPEED          => '1000000000',
                    IFINERRORS       => '0',
                    IFNAME           => 'ge-0/0/47.0',
                    IFTYPE           => '53',
                    IFPORTDUPLEX     => '3',
                    IFINOCTETS       => '0',
                    MAC => '78:FE:3D:36:F7:03',
                    IFSTATUS         => '7',
                    IFDESCR          => 'ge-0/0/47.0',
                    IFNUMBER         => '584',
                    IFLASTCHANGE     => '(3903) 0:00:39.03',
                    IFMTU            => '1514',
                    IFOUTOCTETS      => '0'
                },
                {
                    IFTYPE           => '6',
                    IFNAME           => 'ge-0/0/47',
                    IFSTATUS         => '2',
                    IFPORTDUPLEX     => '3',
                    IFINOCTETS       => '0',
                    MAC => '78:FE:3D:36:F7:03',
                    IFNUMBER         => '585',
                    IFDESCR          => 'ge-0/0/47',
                    IFOUTOCTETS      => '0',
                    IFLASTCHANGE     => '(3638) 0:00:36.38',
                    IFMTU            => '1514',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => '1',
                    IFSPEED          => '1000000000',
                    IFINERRORS       => '0'
                },
                {
                    IFINTERNALSTATUS => '1',
                    IFOUTERRORS      => '0',
                    IFINERRORS       => '0',
                    IFSPEED          => '0',
                    IFPORTDUPLEX     => '3',
                    IFINOCTETS       => '3030702800',
                    MAC => '78:FE:3D:36:F7:03',
                    IFSTATUS         => '1',
                    IFNAME           => 'ge-0/0/0.0',
                    IFTYPE           => '53',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(7247) 0:01:12.47',
                    IFOUTOCTETS      => '171078177',
                    IFDESCR          => 'ge-0/0/0.0',
                    IFNUMBER         => '586'
                },
                {
                    IFNUMBER         => '587',
                    IFDESCR          => 'ge-0/0/5',
                    IFOUTOCTETS      => '0',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(3259) 0:00:32.59',
                    IFTYPE           => '6',
                    IFNAME           => 'ge-0/0/5',
                    IFSTATUS         => '2',
                    IFINOCTETS       => '0',
                    IFPORTDUPLEX     => '3',
                    MAC => '78:FE:3D:36:F7:08',
                    IFSPEED          => '0',
                    IFINERRORS       => '0',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => '1'
                },
                {
                    IFSTATUS         => '7',
                    IFINOCTETS       => '0',
                    IFPORTDUPLEX     => '3',
                    MAC => '78:FE:3D:36:F7:08',
                    IFTYPE           => '53',
                    IFNAME           => 'ge-0/0/5.0',
                    IFOUTOCTETS      => '0',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(3261) 0:00:32.61',
                    IFNUMBER         => '588',
                    IFDESCR          => 'ge-0/0/5.0',
                    IFINTERNALSTATUS => '1',
                    IFOUTERRORS      => '0',
                    IFINERRORS       => '0',
                    IFSPEED          => '0'
                },
                {
                    IFINTERNALSTATUS => '1',
                    IFOUTERRORS      => '0',
                    IFINERRORS       => '0',
                    IFSPEED          => '0',
                    IFSTATUS         => '2',
                    IFINOCTETS       => '0',
                    IFPORTDUPLEX     => '3',
                    MAC => '78:FE:3D:36:F7:09',
                    IFTYPE           => '6',
                    IFNAME           => 'ge-0/0/6',
                    IFOUTOCTETS      => '0',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(3301) 0:00:33.01',
                    IFNUMBER         => '589',
                    IFDESCR          => 'ge-0/0/6'
                },
                {
                    IFINTERNALSTATUS => '1',
                    IFOUTERRORS      => '0',
                    IFINERRORS       => '0',
                    IFSPEED          => '0',
                    IFINOCTETS       => '0',
                    MAC => '78:FE:3D:36:F7:09',
                    IFPORTDUPLEX     => '3',
                    IFSTATUS         => '7',
                    IFNAME           => 'ge-0/0/6.0',
                    IFTYPE           => '53',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(3304) 0:00:33.04',
                    IFOUTOCTETS      => '0',
                    IFDESCR          => 'ge-0/0/6.0',
                    IFNUMBER         => '590'
                },
                {
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => '1',
                    IFSPEED          => '0',
                    IFINERRORS       => '0',
                    IFTYPE           => '6',
                    IFNAME           => 'ge-0/0/7',
                    IFSTATUS         => '2',
                    IFINOCTETS       => '0',
                    IFPORTDUPLEX     => '3',
                    MAC => '78:FE:3D:36:F7:0A',
                    IFNUMBER         => '591',
                    IFDESCR          => 'ge-0/0/7',
                    IFOUTOCTETS      => '0',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(3311) 0:00:33.11'
                },
                {
                    IFDESCR          => 'ge-0/0/7.0',
                    IFNUMBER         => '592',
                    IFLASTCHANGE     => '(3314) 0:00:33.14',
                    IFMTU            => '1514',
                    IFOUTOCTETS      => '0',
                    IFNAME           => 'ge-0/0/7.0',
                    IFTYPE           => '53',
                    IFPORTDUPLEX     => '3',
                    IFINOCTETS       => '0',
                    MAC => '78:FE:3D:36:F7:0A',
                    IFSTATUS         => '7',
                    IFSPEED          => '0',
                    IFINERRORS       => '0',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => '1'
                },
                {
                    IFDESCR          => 'ge-0/0/8',
                    IFNUMBER         => '593',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(3328) 0:00:33.28',
                    IFOUTOCTETS      => '0',
                    IFNAME           => 'ge-0/0/8',
                    IFTYPE           => '6',
                    IFINOCTETS       => '0',
                    MAC => '78:FE:3D:36:F7:0B',
                    IFPORTDUPLEX     => '3',
                    IFSTATUS         => '2',
                    IFSPEED          => '0',
                    IFINERRORS       => '0',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => '1'
                },
                {
                    IFNAME           => 'ge-0/0/8.0',
                    IFTYPE           => '53',
                    IFPORTDUPLEX     => '3',
                    IFINOCTETS       => '0',
                    MAC => '78:FE:3D:36:F7:0B',
                    IFSTATUS         => '7',
                    IFDESCR          => 'ge-0/0/8.0',
                    IFNUMBER         => '594',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(3333) 0:00:33.33',
                    IFOUTOCTETS      => '0',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => '1',
                    IFSPEED          => '0',
                    IFINERRORS       => '0'
                },
                {
                    IFINTERNALSTATUS => '1',
                    IFOUTERRORS      => '0',
                    IFINERRORS       => '0',
                    IFSPEED          => '0',
                    IFSTATUS         => '2',
                    IFINOCTETS       => '0',
                    MAC              => '78:FE:3D:36:F7:0C',
                    IFPORTDUPLEX     => '3',
                    IFTYPE           => '6',
                    IFNAME           => 'ge-0/0/9',
                    IFOUTOCTETS      => '0',
                    IFLASTCHANGE     => '(3338) 0:00:33.38',
                    IFMTU            => '1514',
                    IFNUMBER         => '595',
                    IFDESCR          => 'ge-0/0/9'
                },
                {
                    IFINERRORS       => '0',
                    IFSPEED          => '0',
                    IFINTERNALSTATUS => '1',
                    IFOUTERRORS      => '0',
                    IFOUTOCTETS      => '0',
                    IFLASTCHANGE     => '(3340) 0:00:33.40',
                    IFMTU            => '1514',
                    IFNUMBER         => '596',
                    IFDESCR          => 'ge-0/0/9.0',
                    IFSTATUS         => '7',
                    MAC              => '78:FE:3D:36:F7:0C',
                    IFINOCTETS       => '0',
                    IFPORTDUPLEX     => '3',
                    IFTYPE           => '53',
                    IFNAME           => 'ge-0/0/9.0'
                },
                {
                    IFSTATUS         => '1',
                    MAC              => '78:FE:3D:36:F7:01',
                    IFINOCTETS       => '1782820774',
                    IFTYPE           => '6',
                    IFNAME           => 'vlan',
                    IFOUTOCTETS      => '68750026',
                    IFMTU            => '1518',
                    IFLASTCHANGE     => '(3224) 0:00:32.24',
                    IFNUMBER         => '599',
                    IFDESCR          => 'vlan',
                    IFINTERNALSTATUS => '1',
                    IFOUTERRORS      => '0',
                    IFINERRORS       => '18',
                    IFSPEED          => '1000000000'
                },
                {
                    IFSPEED          => '1000000000',
                    IFINERRORS       => '0',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => '1',
                    IFDESCR          => 'vlan.0',
                    IFNUMBER         => '600',
                    IFMTU            => '1500',
                    IFLASTCHANGE     => '(7309) 0:01:13.09',
                    IFOUTOCTETS      => '64824825',
                    IFNAME           => 'vlan.0',
                    IFTYPE           => '53',
                    IFINOCTETS       => '1782820862',
                    MAC => '78:FE:3D:36:F7:01',
                    IFSTATUS         => '1'
                },
                {
                    IFSTATUS         => '2',
                    MAC => '78:FE:3D:36:F7:03',
                    IFINOCTETS       => '0',
                    IFTYPE           => '161',
                    IFNAME           => 'ae0',
                    IFOUTOCTETS      => '0',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(3215) 0:00:32.15',
                    IFNUMBER         => '609',
                    IFDESCR          => 'ae0',
                    IFINTERNALSTATUS => '1',
                    IFOUTERRORS      => '0',
                    IFINERRORS       => '0',
                    IFSPEED          => '0'
                },
                {
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => '1',
                    IFSPEED          => '0',
                    IFINERRORS       => '0',
                    IFTYPE           => '161',
                    IFNAME           => 'ae1',
                    IFSTATUS         => '2',
                    IFINOCTETS       => '0',
                    MAC => '78:FE:3D:36:F7:04',
                    IFNUMBER         => '610',
                    IFDESCR          => 'ae1',
                    IFOUTOCTETS      => '0',
                    IFLASTCHANGE     => '(3216) 0:00:32.16',
                    IFMTU            => '1514'
                },
                {
                    IFINTERNALSTATUS => '1',
                    IFOUTERRORS      => '0',
                    IFINERRORS       => '0',
                    IFSPEED          => '0',
                    IFINOCTETS       => '0',
                    MAC => '78:FE:3D:36:F7:05',
                    IFSTATUS         => '2',
                    IFNAME           => 'ae2',
                    IFTYPE           => '161',
                    IFLASTCHANGE     => '(3218) 0:00:32.18',
                    IFMTU            => '1514',
                    IFOUTOCTETS      => '0',
                    IFDESCR          => 'ae2',
                    IFNUMBER         => '611'
                },
                {
                    IFLASTCHANGE     => '(3219) 0:00:32.19',
                    IFMTU            => '1514',
                    IFOUTOCTETS      => '0',
                    IFDESCR          => 'ae3',
                    IFNUMBER         => '612',
                    MAC => '78:FE:3D:36:F7:06',
                    IFINOCTETS       => '0',
                    IFSTATUS         => '2',
                    IFNAME           => 'ae3',
                    IFTYPE           => '161',
                    IFINERRORS       => '0',
                    IFSPEED          => '0',
                    IFINTERNALSTATUS => '1',
                    IFOUTERRORS      => '0'
                },
                {
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => '1',
                    IFSPEED          => '0',
                    IFINERRORS       => '0',
                    IFNAME           => 'ae4',
                    IFTYPE           => '161',
                    IFINOCTETS       => '0',
                    MAC => '78:FE:3D:36:F7:07',
                    IFSTATUS         => '2',
                    IFDESCR          => 'ae4',
                    IFNUMBER         => '613',
                    IFLASTCHANGE     => '(3221) 0:00:32.21',
                    IFMTU            => '1514',
                    IFOUTOCTETS      => '0'
                },
                {
                    IFINERRORS       => '0',
                    IFSPEED          => '0',
                    IFINTERNALSTATUS => '1',
                    IFOUTERRORS      => '0',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(3222) 0:00:32.22',
                    IFOUTOCTETS      => '0',
                    IFDESCR          => 'ae0.0',
                    IFNUMBER         => '614',
                    MAC => '78:FE:3D:36:F7:03',
                    IFINOCTETS       => '0',
                    IFSTATUS         => '2',
                    IFNAME           => 'ae0.0',
                    IFTYPE           => '161'
                }
                ]
            }
        }
    ],
    'juniper/ex2200.3.walk' => [
        {
            MANUFACTURER => 'Juniper',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Juniper Networks, Inc. ex2200-c-12p-2g internet router, kernel JUNOS 11.3R1.7 #0: 2011-08-30 11:49:21 UTC     builder@dagmath.juniper.net:/volume/build/junos/11.3/release/11.3R1.7/obj-arm/bsd/kernels/JUNIPER-EX-2200/kernel Build date: 2011-08-30 11:32:01',
            SNMPHOSTNAME => 'AB-B404-23-ex2200',
            MAC          => '00:0B:CA:FE:00:00'
        },
        {
            MANUFACTURER => 'Juniper',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Juniper Networks, Inc. ex2200-c-12p-2g internet router, kernel JUNOS 11.3R1.7 #0: 2011-08-30 11:49:21 UTC     builder@dagmath.juniper.net:/volume/build/junos/11.3/release/11.3R1.7/obj-arm/bsd/kernels/JUNIPER-EX-2200/kernel Build date: 2011-08-30 11:32:01',
            SNMPHOSTNAME => 'AB-B404-23-ex2200',
            MAC          => '00:0B:CA:FE:00:00',
            MODELSNMP    => 'Networking2181',
            MODEL        => undef,
            FIRMWARE     => undef,
            SERIAL       => undef,
        },
        {
            INFO => {
                MANUFACTURER => 'Juniper',
                TYPE         => 'NETWORKING',
                COMMENTS     => 'Juniper Networks, Inc. ex2200-c-12p-2g internet router, kernel JUNOS 11.3R1.7 #0: 2011-08-30 11:49:21 UTC     builder@dagmath.juniper.net:/volume/build/junos/11.3/release/11.3R1.7/obj-arm/bsd/kernels/JUNIPER-EX-2200/kernel Build date: 2011-08-30 11:32:01',
                NAME         => 'AB-B404-23-ex2200',
                UPTIME       => '(1896073543) 219 days, 10:52:15.43',
                CONTACT      => undef,
                ID           => undef,
                MODEL        => undef,
                LOCATION     => undef,
                IPS          => {
                    IP => [
                        '128.0.0.1',
                        '128.0.0.127',
                        '128.0.0.16',
                        '128.0.0.32',
                        '192.168.1.23'
                    ]
                }
            },
            PORTS => {
                PORT => [
                {
                    IFINOCTETS       => '0',
                    IFSTATUS         => 'up(1)',
                    IFNAME           => 'lsi',
                    IFTYPE           => 'mplsTunnel(150)',
                    IFMTU            => '1496',
                    IFLASTCHANGE     => '(210618496) 24 days, 9:03:04.96',
                    IFOUTOCTETS      => '0',
                    IFDESCR          => 'lsi',
                    IFNUMBER         => '4',
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0',
                    IFINERRORS       => '0',
                    IFSPEED          => '0'
                },
                {
                    IFNAME           => 'dsc',
                    IFTYPE           => 'other(1)',
                    IFINOCTETS       => '0',
                    IFSTATUS         => 'up(1)',
                    IFDESCR          => 'dsc',
                    IFNUMBER         => '5',
                    IFMTU            => '2147483647',
                    IFLASTCHANGE     => '(210651137) 24 days, 9:08:31.37',
                    IFOUTOCTETS      => '0',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFSPEED          => '0',
                    IFINERRORS       => '0'
                },
                {
                    IFOUTOCTETS      => '3847149791',
                    IFMTU            => '2147483647',
                    IFLASTCHANGE     => '(210651144) 24 days, 9:08:31.44',
                    IFNUMBER         => '6',
                    IFDESCR          => 'lo0',
                    IFSTATUS         => 'up(1)',
                    IFINOCTETS       => '3847149791',
                    IFTYPE           => 'softwareLoopback(24)',
                    IFNAME           => 'lo0',
                    IFINERRORS       => '0',
                    IFSPEED          => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0'
                },
                {
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFSPEED          => '0',
                    IFINERRORS       => '0',
                    IFTYPE           => 'other(1)',
                    IFNAME           => 'tap',
                    IFSTATUS         => 'up(1)',
                    IFINOCTETS       => '0',
                    IFNUMBER         => '7',
                    IFDESCR          => 'tap',
                    IFOUTOCTETS      => '0',
                    IFMTU            => '2147483647',
                    IFLASTCHANGE     => '(210651150) 24 days, 9:08:31.50'
                },
                {
                    IFNAME           => 'gre',
                    IFTYPE           => 'tunnel(131)',
                    IFINOCTETS       => '0',
                    IFSTATUS         => 'up(1)',
                    IFDESCR          => 'gre',
                    IFNUMBER         => '8',
                    IFLASTCHANGE     => '(210651140) 24 days, 9:08:31.40',
                    IFMTU            => '2147483647',
                    IFOUTOCTETS      => '0',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFSPEED          => '0',
                    IFINERRORS       => '0'
                },
                {
                    IFMTU            => '2147483647',
                    IFLASTCHANGE     => '(210651143) 24 days, 9:08:31.43',
                    IFOUTOCTETS      => '0',
                    IFDESCR          => 'ipip',
                    IFNUMBER         => '9',
                    IFINOCTETS       => '0',
                    IFSTATUS         => 'up(1)',
                    IFNAME           => 'ipip',
                    IFTYPE           => 'tunnel(131)',
                    IFINERRORS       => '0',
                    IFSPEED          => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0'
                },
                {
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFSPEED          => '0',
                    IFINERRORS       => '0',
                    IFTYPE           => 'tunnel(131)',
                    IFNAME           => 'pime',
                    IFSTATUS         => 'up(1)',
                    IFINOCTETS       => '0',
                    IFNUMBER         => '10',
                    IFDESCR          => 'pime',
                    IFOUTOCTETS      => '0',
                    IFLASTCHANGE     => '(210651130) 24 days, 9:08:31.30',
                    IFMTU            => '2147483647'
                },
                {
                    IFDESCR          => 'pimd',
                    IFNUMBER         => '11',
                    IFLASTCHANGE     => '(210651132) 24 days, 9:08:31.32',
                    IFMTU            => '2147483647',
                    IFOUTOCTETS      => '0',
                    IFNAME           => 'pimd',
                    IFTYPE           => 'tunnel(131)',
                    IFINOCTETS       => '0',
                    IFSTATUS         => 'up(1)',
                    IFSPEED          => '0',
                    IFINERRORS       => '0',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)'
                },
                {
                    IFINERRORS       => '0',
                    IFSPEED          => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0',
                    IFOUTOCTETS      => '0',
                    IFMTU            => '2147483647',
                    IFLASTCHANGE     => '(210651149) 24 days, 9:08:31.49',
                    IFNUMBER         => '12',
                    IFDESCR          => 'mtun',
                    IFSTATUS         => 'up(1)',
                    IFINOCTETS       => '0',
                    IFTYPE           => 'tunnel(131)',
                    IFNAME           => 'mtun'
                },
                {
                    IFNUMBER         => '33',
                    IFDESCR          => 'me0',
                    IFOUTOCTETS      => '0',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(210651147) 24 days, 9:08:31.47',
                    IFTYPE           => 'ethernetCsmacd(6)',
                    IFNAME           => 'me0',
                    IFSTATUS         => 'down(2)',
                    IFINOCTETS       => '0',
                    IFSPEED          => '0',
                    IFINERRORS       => '0',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)'
                },
                {
                    IFSTATUS         => 'up(1)',
                    IFINOCTETS       => '0',
                    IFTYPE           => 'ethernetCsmacd(6)',
                    IFNAME           => 'bme0',
                    IFOUTOCTETS      => '1660461977',
                    IFLASTCHANGE     => '(210651124) 24 days, 9:08:31.24',
                    IFMTU            => '1576',
                    IFNUMBER         => '37',
                    IFDESCR          => 'bme0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0',
                    IFINERRORS       => '0',
                    IFSPEED          => '0'
                },
                {
                    IFSTATUS         => 'up(1)',
                    IFINOCTETS       => '0',
                    IFTYPE           => 'propVirtual(53)',
                    IFNAME           => 'bme0.32768',
                    IFOUTOCTETS      => '0',
                    IFMTU            => '1562',
                    IFLASTCHANGE     => '(210651153) 24 days, 9:08:31.53',
                    IFNUMBER         => '38',
                    IFDESCR          => 'bme0.32768',
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0',
                    IFINERRORS       => '0',
                    IFSPEED          => '0'
                },
                {
                    IFDESCR          => 'jsrv',
                    IFNUMBER         => '501',
                    IFLASTCHANGE     => '(795719864) 92 days, 2:19:58.64',
                    IFMTU            => '1518',
                    IFOUTOCTETS      => '0',
                    IFNAME           => 'jsrv',
                    IFTYPE           => 'ethernetCsmacd(6)',
                    IFINOCTETS       => '0',
                    IFSTATUS         => 'up(1)',
                    IFSPEED          => '1000000000',
                    IFINERRORS       => '0',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)'
                },
                {
                    IFMTU            => '1500',
                    IFLASTCHANGE     => '(795719864) 92 days, 2:19:58.64',
                    IFOUTOCTETS      => '42',
                    IFDESCR          => 'jsrv.1',
                    IFNUMBER         => '502',
                    IFINOCTETS       => '0',
                    IFSTATUS         => 'up(1)',
                    IFNAME           => 'jsrv.1',
                    IFTYPE           => 'propVirtual(53)',
                    IFINERRORS       => '0',
                    IFSPEED          => '1000000000',
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0'
                },
                {
                    IFTYPE           => 'ethernetCsmacd(6)',
                    IFNAME           => 'vlan',
                    IFSTATUS         => 'up(1)',
                    IFINOCTETS       => '2169597684',
                    IFNUMBER         => '503',
                    IFDESCR          => 'vlan',
                    IFOUTOCTETS      => '378679611',
                    IFLASTCHANGE     => '(210651161) 24 days, 9:08:31.61',
                    IFMTU            => '1518',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFSPEED          => '1000000000',
                    IFINERRORS       => '22'
                },
                {
                    IFDESCR          => 'ge-0/0/0',
                    IFNUMBER         => '504',
                    IFLASTCHANGE     => '(2080979263) 240 days, 20:29:52.63',
                    IFMTU            => '1514',
                    IFOUTOCTETS      => '3775595507',
                    IFNAME           => 'ge-0/0/0',
                    IFTYPE           => 'ethernetCsmacd(6)',
                    IFINOCTETS       => '54996177',
                    IFSTATUS         => 'up(1)',
                    IFSPEED          => '1000000000',
                    IFINERRORS       => '0',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)'
                },
                {
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(2081029863) 240 days, 20:38:18.63',
                    IFOUTOCTETS      => '8617260',
                    IFDESCR          => 'ge-0/0/1',
                    IFNUMBER         => '505',
                    IFINOCTETS       => '42701777',
                    IFSTATUS         => 'up(1)',
                    IFNAME           => 'ge-0/0/1',
                    IFTYPE           => 'ethernetCsmacd(6)',
                    IFINERRORS       => '0',
                    IFSPEED          => '1000000000',
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0'
                },
                {
                    IFINOCTETS       => '276103333',
                    IFSTATUS         => 'up(1)',
                    IFNAME           => 'ge-0/0/2',
                    IFTYPE           => 'ethernetCsmacd(6)',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(2080957353) 240 days, 20:26:13.53',
                    IFOUTOCTETS      => '1776301481',
                    IFDESCR          => 'ge-0/0/2',
                    IFNUMBER         => '506',
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0',
                    IFINERRORS       => '0',
                    IFSPEED          => '1000000000'
                },
                {
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFSPEED          => '1000000000',
                    IFINERRORS       => '0',
                    IFNAME           => 'ge-0/0/3',
                    IFTYPE           => 'ethernetCsmacd(6)',
                    IFINOCTETS       => '743174854',
                    IFSTATUS         => 'up(1)',
                    IFDESCR          => 'ge-0/0/3',
                    IFNUMBER         => '507',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(2081042643) 240 days, 20:40:26.43',
                    IFOUTOCTETS      => '1617417859'
                },
                {
                    IFSPEED          => '1000000000',
                    IFINERRORS       => '0',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFDESCR          => 'ge-0/0/4',
                    IFNUMBER         => '508',
                    IFLASTCHANGE     => '(2081034223) 240 days, 20:39:02.23',
                    IFMTU            => '1514',
                    IFOUTOCTETS      => '729029155',
                    IFNAME           => 'ge-0/0/4',
                    IFTYPE           => 'ethernetCsmacd(6)',
                    IFINOCTETS       => '65424546',
                    IFSTATUS         => 'up(1)'
                },
                {
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFSPEED          => '1000000000',
                    IFINERRORS       => '0',
                    IFNAME           => 'ge-0/0/5',
                    IFTYPE           => 'ethernetCsmacd(6)',
                    IFINOCTETS       => '121426929',
                    IFSTATUS         => 'up(1)',
                    IFDESCR          => 'ge-0/0/5',
                    IFNUMBER         => '509',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(2081071652) 240 days, 20:45:16.52',
                    IFOUTOCTETS      => '786124744'
                },
                {
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0',
                    IFINERRORS       => '0',
                    IFSPEED          => '1000000000',
                    IFINOCTETS       => '310326639',
                    IFSTATUS         => 'up(1)',
                    IFNAME           => 'ge-0/0/6',
                    IFTYPE           => 'ethernetCsmacd(6)',
                    IFLASTCHANGE     => '(2081053722) 240 days, 20:42:17.22',
                    IFMTU            => '1514',
                    IFOUTOCTETS      => '1458885492',
                    IFDESCR          => 'ge-0/0/6',
                    IFNUMBER         => '510'
                },
                {
                    IFOUTOCTETS      => '0',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(210651201) 24 days, 9:08:32.01',
                    IFNUMBER         => '511',
                    IFDESCR          => 'ge-0/0/7',
                    IFSTATUS         => 'down(2)',
                    IFINOCTETS       => '0',
                    IFTYPE           => 'ethernetCsmacd(6)',
                    IFNAME           => 'ge-0/0/7',
                    IFINERRORS       => '0',
                    IFSPEED          => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0'
                },
                {
                    IFSPEED          => '0',
                    IFINERRORS       => '0',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFDESCR          => 'ge-0/0/8',
                    IFNUMBER         => '512',
                    IFLASTCHANGE     => '(210651203) 24 days, 9:08:32.03',
                    IFMTU            => '1514',
                    IFOUTOCTETS      => '0',
                    IFNAME           => 'ge-0/0/8',
                    IFTYPE           => 'ethernetCsmacd(6)',
                    IFINOCTETS       => '0',
                    IFSTATUS         => 'down(2)'
                },
                {
                    IFOUTOCTETS      => '5825457',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(2080979263) 240 days, 20:29:52.63',
                    IFNUMBER         => '513',
                    IFDESCR          => 'ge-0/0/0.0',
                    IFSTATUS         => 'up(1)',
                    IFINOCTETS       => '12422938',
                    IFTYPE           => 'propVirtual(53)',
                    IFNAME           => 'ge-0/0/0.0',
                    IFINERRORS       => '0',
                    IFSPEED          => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0'
                },
                {
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0',
                    IFINERRORS       => '0',
                    IFSPEED          => '1000000000',
                    IFSTATUS         => 'up(1)',
                    IFINOCTETS       => '703703523',
                    IFTYPE           => 'ethernetCsmacd(6)',
                    IFNAME           => 'ge-0/0/9',
                    IFOUTOCTETS      => '1577399105',
                    IFLASTCHANGE     => '(2080931282) 240 days, 20:21:52.82',
                    IFMTU            => '1514',
                    IFNUMBER         => '514',
                    IFDESCR          => 'ge-0/0/9'
                },
                {
                    IFDESCR          => 'ge-0/0/10',
                    IFNUMBER         => '515',
                    IFLASTCHANGE     => '(210651209) 24 days, 9:08:32.09',
                    IFMTU            => '1514',
                    IFOUTOCTETS      => '0',
                    IFNAME           => 'ge-0/0/10',
                    IFTYPE           => 'ethernetCsmacd(6)',
                    IFINOCTETS       => '0',
                    IFSTATUS         => 'down(2)',
                    IFSPEED          => '0',
                    IFINERRORS       => '0',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)'
                },
                {
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0',
                    IFINERRORS       => '0',
                    IFSPEED          => '0',
                    IFSTATUS         => 'up(1)',
                    IFINOCTETS       => '12416987',
                    IFTYPE           => 'propVirtual(53)',
                    IFNAME           => 'ge-0/0/1.0',
                    IFOUTOCTETS      => '5824725',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(2081029863) 240 days, 20:38:18.63',
                    IFNUMBER         => '516',
                    IFDESCR          => 'ge-0/0/1.0'
                },
                {
                    IFTYPE           => 'ethernetCsmacd(6)',
                    IFNAME           => 'ge-0/0/11',
                    IFSTATUS         => 'up(1)',
                    IFINOCTETS       => '242475284',
                    IFNUMBER         => '517',
                    IFDESCR          => 'ge-0/0/11',
                    IFOUTOCTETS      => '1017324509',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(2080999052) 240 days, 20:33:10.52',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFSPEED          => '1000000000',
                    IFINERRORS       => '0'
                },
                {
                    IFINOCTETS       => '37828621',
                    IFSTATUS         => 'up(1)',
                    IFNAME           => 'ge-0/0/2.0',
                    IFTYPE           => 'propVirtual(53)',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(2080957353) 240 days, 20:26:13.53',
                    IFOUTOCTETS      => '127953081',
                    IFDESCR          => 'ge-0/0/2.0',
                    IFNUMBER         => '518',
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0',
                    IFINERRORS       => '0',
                    IFSPEED          => '0'
                },
                {
                    IFINERRORS       => '0',
                    IFSPEED          => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0',
                    IFOUTOCTETS      => '128037429',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(2081042643) 240 days, 20:40:26.43',
                    IFNUMBER         => '519',
                    IFDESCR          => 'ge-0/0/3.0',
                    IFSTATUS         => 'up(1)',
                    IFINOCTETS       => '37862757',
                    IFTYPE           => 'propVirtual(53)',
                    IFNAME           => 'ge-0/0/3.0'
                },
                {
                    IFINERRORS       => '0',
                    IFSPEED          => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(2081034223) 240 days, 20:39:02.23',
                    IFOUTOCTETS      => '33823397',
                    IFDESCR          => 'ge-0/0/4.0',
                    IFNUMBER         => '520',
                    IFINOCTETS       => '18172757',
                    IFSTATUS         => 'up(1)',
                    IFNAME           => 'ge-0/0/4.0',
                    IFTYPE           => 'propVirtual(53)'
                },
                {
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(2081071652) 240 days, 20:45:16.52',
                    IFOUTOCTETS      => '117501872',
                    IFDESCR          => 'ge-0/0/5.0',
                    IFNUMBER         => '521',
                    IFINOCTETS       => '35637120',
                    IFSTATUS         => 'up(1)',
                    IFNAME           => 'ge-0/0/5.0',
                    IFTYPE           => 'propVirtual(53)',
                    IFINERRORS       => '0',
                    IFSPEED          => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0'
                },
                {
                    IFNAME           => 'ge-0/0/6.0',
                    IFTYPE           => 'propVirtual(53)',
                    IFINOCTETS       => '38298814',
                    IFSTATUS         => 'up(1)',
                    IFDESCR          => 'ge-0/0/6.0',
                    IFNUMBER         => '522',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(2081053722) 240 days, 20:42:17.22',
                    IFOUTOCTETS      => '130188996',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFSPEED          => '0',
                    IFINERRORS       => '0'
                },
                {
                    IFSPEED          => '0',
                    IFINERRORS       => '0',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFDESCR          => 'ge-0/0/7.0',
                    IFNUMBER         => '523',
                    IFLASTCHANGE     => '(210651217) 24 days, 9:08:32.17',
                    IFMTU            => '1514',
                    IFOUTOCTETS      => '0',
                    IFNAME           => 'ge-0/0/7.0',
                    IFTYPE           => 'propVirtual(53)',
                    IFINOCTETS       => '0',
                    IFSTATUS         => 'lowerLayerDown(7)'
                },
                {
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0',
                    IFINERRORS       => '0',
                    IFSPEED          => '0',
                    IFINOCTETS       => '0',
                    IFSTATUS         => 'lowerLayerDown(7)',
                    IFNAME           => 'ge-0/0/8.0',
                    IFTYPE           => 'propVirtual(53)',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(210651220) 24 days, 9:08:32.20',
                    IFOUTOCTETS      => '0',
                    IFDESCR          => 'ge-0/0/8.0',
                    IFNUMBER         => '524'
                },
                {
                    IFSPEED          => '0',
                    IFINERRORS       => '0',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFDESCR          => 'ge-0/0/9.0',
                    IFNUMBER         => '525',
                    IFLASTCHANGE     => '(2080931282) 240 days, 20:21:52.82',
                    IFMTU            => '1514',
                    IFOUTOCTETS      => '128195994',
                    IFNAME           => 'ge-0/0/9.0',
                    IFTYPE           => 'propVirtual(53)',
                    IFINOCTETS       => '37907646',
                    IFSTATUS         => 'up(1)'
                },
                {
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFSPEED          => '0',
                    IFINERRORS       => '0',
                    IFNAME           => 'ge-0/0/10.0',
                    IFTYPE           => 'propVirtual(53)',
                    IFINOCTETS       => '0',
                    IFSTATUS         => 'lowerLayerDown(7)',
                    IFDESCR          => 'ge-0/0/10.0',
                    IFNUMBER         => '526',
                    IFLASTCHANGE     => '(210651225) 24 days, 9:08:32.25',
                    IFMTU            => '1514',
                    IFOUTOCTETS      => '0'
                },
                {
                    IFNUMBER         => '527',
                    IFDESCR          => 'ge-0/0/11.0',
                    IFOUTOCTETS      => '108809558',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(2080999052) 240 days, 20:33:10.52',
                    IFTYPE           => 'propVirtual(53)',
                    IFNAME           => 'ge-0/0/11.0',
                    IFSTATUS         => 'up(1)',
                    IFINOCTETS       => '33695673',
                    IFSPEED          => '0',
                    IFINERRORS       => '0',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)'
                },
                {
                    IFTYPE           => 'ethernetCsmacd(6)',
                    IFNAME           => 'ge-0/1/0',
                    IFSTATUS         => 'down(2)',
                    IFINOCTETS       => '0',
                    IFNUMBER         => '528',
                    IFDESCR          => 'ge-0/1/0',
                    IFOUTOCTETS      => '0',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(210651230) 24 days, 9:08:32.30',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFSPEED          => '0',
                    IFINERRORS       => '0'
                },
                {
                    IFSTATUS         => 'lowerLayerDown(7)',
                    IFINOCTETS       => '0',
                    IFTYPE           => 'propVirtual(53)',
                    IFNAME           => 'ge-0/1/0.0',
                    IFOUTOCTETS      => '0',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(210651234) 24 days, 9:08:32.34',
                    IFNUMBER         => '529',
                    IFDESCR          => 'ge-0/1/0.0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0',
                    IFINERRORS       => '0',
                    IFSPEED          => '0'
                },
                {
                    IFDESCR          => 'ge-0/1/1',
                    IFNUMBER         => '530',
                    IFLASTCHANGE     => '(210651853) 24 days, 9:08:38.53',
                    IFMTU            => '1514',
                    IFOUTOCTETS      => '2897992952',
                    IFNAME           => 'ge-0/1/1',
                    IFTYPE           => 'ethernetCsmacd(6)',
                    IFINOCTETS       => '1984754089',
                    IFSTATUS         => 'up(1)',
                    IFSPEED          => '1000000000',
                    IFINERRORS       => '0',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)'
                },
                {
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFSPEED          => '0',
                    IFINERRORS       => '0',
                    IFTYPE           => 'propVirtual(53)',
                    IFNAME           => 'ge-0/1/1.0',
                    IFSTATUS         => 'up(1)',
                    IFINOCTETS       => '3925538024',
                    IFNUMBER         => '531',
                    IFDESCR          => 'ge-0/1/1.0',
                    IFOUTOCTETS      => '515351797',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(210651853) 24 days, 9:08:38.53'
                },
                {
                    IFTYPE           => 'propVirtual(53)',
                    IFNAME           => 'vlan.0',
                    IFSTATUS         => 'up(1)',
                    IFINOCTETS       => '2169600207',
                    IFNUMBER         => '532',
                    IFDESCR          => 'vlan.0',
                    IFOUTOCTETS      => '344650884',
                    IFMTU            => '1500',
                    IFLASTCHANGE     => '(210651853) 24 days, 9:08:38.53',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFSPEED          => '1000000000',
                    IFINERRORS       => '0'
                }
                ]
            }
        }
    ],
    'juniper/ex2200.4.walk' => [
        {
            MANUFACTURER => 'Juniper',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Juniper Networks, Inc. ex2200-48t-4g internet router, kernel JUNOS 11.1R3.5 #0: 2011-06-25 00:35:00 UTC     builder@briath.juniper.net:/volume/build/junos/11.1/release/11.1R3.5/obj-arm/bsd/kernels/JUNIPER-EX/kernel Build date: 2011-06-25 00:31:37 UTC Cop',
            SNMPHOSTNAME => 'AB-BU6-132-ex2200-48',
            MAC          => '78:FE:3D:37:5E:C0',
        },
        {
            MANUFACTURER => 'Juniper',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Juniper Networks, Inc. ex2200-48t-4g internet router, kernel JUNOS 11.1R3.5 #0: 2011-06-25 00:35:00 UTC     builder@briath.juniper.net:/volume/build/junos/11.1/release/11.1R3.5/obj-arm/bsd/kernels/JUNIPER-EX/kernel Build date: 2011-06-25 00:31:37 UTC Cop',
            SNMPHOSTNAME => 'AB-BU6-132-ex2200-48',
            MAC          => '78:FE:3D:37:5E:C0',
            MODELSNMP    => 'Networking2190',
            MODEL        => undef,
            FIRMWARE     => undef,
            SERIAL       => 'CU0211450517',
        },
        {
            INFO => {
                MANUFACTURER => 'Juniper',
                TYPE         => 'NETWORKING',
                COMMENTS     => 'Juniper Networks, Inc. ex2200-48t-4g internet router, kernel JUNOS 11.1R3.5 #0: 2011-06-25 00:35:00 UTC     builder@briath.juniper.net:/volume/build/junos/11.1/release/11.1R3.5/obj-arm/bsd/kernels/JUNIPER-EX/kernel Build date: 2011-06-25 00:31:37 UTC Cop',
                CONTACT      => 'cricesr@dauphine.fr',
                UPTIME       => '(1514669572) 175 days, 7:24:55.72',
                RAM          => 512,
                ID           => undef,
                MODEL        => undef,
                LOCATION     => 'AB-BU6',
                NAME         => 'AB-BU6-132-ex2200-48',
                MAC          => '78:FE:3D:37:5E:C0',
                MEMORY       => 0,
                SERIAL       => 'CU0211450517',
                IPS          => {
                    IP => [
                        '128.0.0.1',
                        '128.0.0.127',
                        '128.0.0.16',
                        '128.0.0.32',
                        '192.168.1.132'
                    ]
                },
            },
            PORTS => {
                PORT => [
                {
                    IFSPEED          => '0',
                    IFINERRORS       => '0',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFDESCR          => 'lsi',
                    IFNUMBER         => '4',
                    IFLASTCHANGE     => '(3055) 0:00:30.55',
                    IFMTU            => '1496',
                    IFOUTOCTETS      => '0',
                    IFNAME           => 'lsi',
                    IFTYPE           => 'mplsTunnel(150)',
                    IFINOCTETS       => '0',
                    IFSTATUS         => 'up(1)'
                },
                {
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFSPEED          => '0',
                    IFINERRORS       => '0',
                    IFNAME           => 'dsc',
                    IFTYPE           => 'other(1)',
                    IFINOCTETS       => '0',
                    IFSTATUS         => 'up(1)',
                    IFDESCR          => 'dsc',
                    IFNUMBER         => '5',
                    IFLASTCHANGE     => '(3012) 0:00:30.12',
                    IFMTU            => '2147483647',
                    IFOUTOCTETS      => '0'
                },
                {
                    IFOUTOCTETS      => '4148591022',
                    IFMTU            => '2147483647',
                    IFLASTCHANGE     => '(3019) 0:00:30.19',
                    IFNUMBER         => '6',
                    IFDESCR          => 'lo0',
                    IFSTATUS         => 'up(1)',
                    IFINOCTETS       => '4148021786',
                    IFTYPE           => 'softwareLoopback(24)',
                    IFNAME           => 'lo0',
                    IFINERRORS       => '0',
                    IFSPEED          => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0'
                },
                {
                    IFINERRORS       => '0',
                    IFSPEED          => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0',
                    IFLASTCHANGE     => '(3066) 0:00:30.66',
                    IFMTU            => '2147483647',
                    IFOUTOCTETS      => '0',
                    IFDESCR          => 'tap',
                    IFNUMBER         => '7',
                    IFINOCTETS       => '0',
                    IFSTATUS         => 'up(1)',
                    IFNAME           => 'tap',
                    IFTYPE           => 'other(1)'
                },
                {
                    IFNAME           => 'gre',
                    IFTYPE           => 'tunnel(131)',
                    IFINOCTETS       => '0',
                    IFSTATUS         => 'up(1)',
                    IFDESCR          => 'gre',
                    IFNUMBER         => '8',
                    IFMTU            => '2147483647',
                    IFLASTCHANGE     => '(3014) 0:00:30.14',
                    IFOUTOCTETS      => '0',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFSPEED          => '0',
                    IFINERRORS       => '0'
                },
                {
                    IFINERRORS       => '0',
                    IFSPEED          => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0',
                    IFOUTOCTETS      => '0',
                    IFMTU            => '2147483647',
                    IFLASTCHANGE     => '(3015) 0:00:30.15',
                    IFNUMBER         => '9',
                    IFDESCR          => 'ipip',
                    IFSTATUS         => 'up(1)',
                    IFINOCTETS       => '0',
                    IFTYPE           => 'tunnel(131)',
                    IFNAME           => 'ipip'
                },
                {
                    IFOUTOCTETS      => '0',
                    IFLASTCHANGE     => '(3065) 0:00:30.65',
                    IFMTU            => '2147483647',
                    IFNUMBER         => '10',
                    IFDESCR          => 'pime',
                    IFSTATUS         => 'up(1)',
                    IFINOCTETS       => '0',
                    IFTYPE           => 'tunnel(131)',
                    IFNAME           => 'pime',
                    IFINERRORS       => '0',
                    IFSPEED          => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0'
                },
                {
                    IFSPEED          => '0',
                    IFINERRORS       => '0',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFNUMBER         => '11',
                    IFDESCR          => 'pimd',
                    IFOUTOCTETS      => '0',
                    IFMTU            => '2147483647',
                    IFLASTCHANGE     => '(3063) 0:00:30.63',
                    IFTYPE           => 'tunnel(131)',
                    IFNAME           => 'pimd',
                    IFSTATUS         => 'up(1)',
                    IFINOCTETS       => '0'
                },
                {
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFSPEED          => '0',
                    IFINERRORS       => '0',
                    IFNAME           => 'mtun',
                    IFTYPE           => 'tunnel(131)',
                    IFINOCTETS       => '0',
                    IFSTATUS         => 'up(1)',
                    IFDESCR          => 'mtun',
                    IFNUMBER         => '12',
                    IFLASTCHANGE     => '(3060) 0:00:30.60',
                    IFMTU            => '2147483647',
                    IFOUTOCTETS      => '0'
                },
                {
                    IFINERRORS       => '0',
                    IFSPEED          => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(3058) 0:00:30.58',
                    IFOUTOCTETS      => '0',
                    IFDESCR          => 'me0',
                    IFNUMBER         => '33',
                    IFINOCTETS       => '0',
                    IFSTATUS         => 'down(2)',
                    IFNAME           => 'me0',
                    IFTYPE           => 'ethernetCsmacd(6)'
                },
                {
                    IFNAME           => 'bme0',
                    IFTYPE           => 'ethernetCsmacd(6)',
                    IFINOCTETS       => '0',
                    IFSTATUS         => 'up(1)',
                    IFDESCR          => 'bme0',
                    IFNUMBER         => '37',
                    IFLASTCHANGE     => '(3010) 0:00:30.10',
                    IFMTU            => '1576',
                    IFOUTOCTETS      => '901896814',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFSPEED          => '0',
                    IFINERRORS       => '0'
                },
                {
                    IFINERRORS       => '0',
                    IFSPEED          => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0',
                    IFOUTOCTETS      => '126',
                    IFMTU            => '1562',
                    IFLASTCHANGE     => '(3011) 0:00:30.11',
                    IFNUMBER         => '38',
                    IFDESCR          => 'bme0.32768',
                    IFSTATUS         => 'up(1)',
                    IFINOCTETS       => '2267152155',
                    IFTYPE           => 'propVirtual(53)',
                    IFNAME           => 'bme0.32768'
                },
                {
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(1513913595) 175 days, 5:18:55.95',
                    IFOUTOCTETS      => '2121260600',
                    IFDESCR          => 'ge-0/0/0',
                    IFNUMBER         => '501',
                    IFINOCTETS       => '62430575',
                    IFSTATUS         => 'up(1)',
                    IFNAME           => 'ge-0/0/0',
                    IFTYPE           => 'ethernetCsmacd(6)',
                    IFINERRORS       => '0',
                    IFSPEED          => '1000000000',
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0'
                },
                {
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0',
                    IFINERRORS       => '0',
                    IFSPEED          => '0',
                    IFINOCTETS       => '614461',
                    IFSTATUS         => 'up(1)',
                    IFNAME           => 'ge-0/0/0.0',
                    IFTYPE           => 'propVirtual(53)',
                    IFLASTCHANGE     => '(1513913595) 175 days, 5:18:55.95',
                    IFMTU            => '1514',
                    IFOUTOCTETS      => '323610',
                    IFDESCR          => 'ge-0/0/0.0',
                    IFNUMBER         => '502'
                },
                {
                    IFSTATUS         => 'down(2)',
                    IFINOCTETS       => '147698220',
                    IFTYPE           => 'ethernetCsmacd(6)',
                    IFNAME           => 'ge-0/0/1',
                    IFOUTOCTETS      => '886946729',
                    IFLASTCHANGE     => '(1507307600) 174 days, 10:57:56.00',
                    IFMTU            => '1514',
                    IFNUMBER         => '503',
                    IFDESCR          => 'ge-0/0/1',
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0',
                    IFINERRORS       => '0',
                    IFSPEED          => '1000000000'
                },
                {
                    IFOUTOCTETS      => '754660',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(1507307600) 174 days, 10:57:56.00',
                    IFNUMBER         => '504',
                    IFDESCR          => 'ge-0/0/1.0',
                    IFSTATUS         => 'lowerLayerDown(7)',
                    IFINOCTETS       => '1758171',
                    IFTYPE           => 'propVirtual(53)',
                    IFNAME           => 'ge-0/0/1.0',
                    IFINERRORS       => '0',
                    IFSPEED          => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0'
                },
                {
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0',
                    IFINERRORS       => '0',
                    IFSPEED          => '1000000000',
                    IFINOCTETS       => '33040562',
                    IFSTATUS         => 'down(2)',
                    IFNAME           => 'ge-0/0/10',
                    IFTYPE           => 'ethernetCsmacd(6)',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(1202418760) 139 days, 4:03:07.60',
                    IFOUTOCTETS      => '919887004',
                    IFDESCR          => 'ge-0/0/10',
                    IFNUMBER         => '505'
                },
                {
                    IFINOCTETS       => '260404',
                    IFSTATUS         => 'lowerLayerDown(7)',
                    IFNAME           => 'ge-0/0/10.0',
                    IFTYPE           => 'propVirtual(53)',
                    IFLASTCHANGE     => '(1202418760) 139 days, 4:03:07.60',
                    IFMTU            => '1514',
                    IFOUTOCTETS      => '113845',
                    IFDESCR          => 'ge-0/0/10.0',
                    IFNUMBER         => '506',
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0',
                    IFINERRORS       => '0',
                    IFSPEED          => '0'
                },
                {
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0',
                    IFINERRORS       => '0',
                    IFSPEED          => '1000000000',
                    IFINOCTETS       => '23866591',
                    IFSTATUS         => 'down(2)',
                    IFNAME           => 'ge-0/0/11',
                    IFTYPE           => 'ethernetCsmacd(6)',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(1204402388) 139 days, 9:33:43.88',
                    IFOUTOCTETS      => '573739283',
                    IFDESCR          => 'ge-0/0/11',
                    IFNUMBER         => '507'
                },
                {
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFSPEED          => '0',
                    IFINERRORS       => '0',
                    IFNAME           => 'ge-0/0/11.0',
                    IFTYPE           => 'propVirtual(53)',
                    IFINOCTETS       => '687393',
                    IFSTATUS         => 'lowerLayerDown(7)',
                    IFDESCR          => 'ge-0/0/11.0',
                    IFNUMBER         => '508',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(1204402388) 139 days, 9:33:43.88',
                    IFOUTOCTETS      => '75969'
                },
                {
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFSPEED          => '1000000000',
                    IFINERRORS       => '0',
                    IFTYPE           => 'ethernetCsmacd(6)',
                    IFNAME           => 'ge-0/0/12',
                    IFSTATUS         => 'down(2)',
                    IFINOCTETS       => '65490962',
                    IFNUMBER         => '509',
                    IFDESCR          => 'ge-0/0/12',
                    IFOUTOCTETS      => '3128608219',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(1454505788) 168 days, 8:17:37.88'
                },
                {
                    IFOUTOCTETS      => '668789',
                    IFLASTCHANGE     => '(1454505788) 168 days, 8:17:37.88',
                    IFMTU            => '1514',
                    IFNUMBER         => '510',
                    IFDESCR          => 'ge-0/0/12.0',
                    IFSTATUS         => 'lowerLayerDown(7)',
                    IFINOCTETS       => '1205122',
                    IFTYPE           => 'propVirtual(53)',
                    IFNAME           => 'ge-0/0/12.0',
                    IFINERRORS       => '0',
                    IFSPEED          => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0'
                },
                {
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0',
                    IFINERRORS       => '0',
                    IFSPEED          => '100000000',
                    IFSTATUS         => 'down(2)',
                    IFINOCTETS       => '50434211',
                    IFTYPE           => 'ethernetCsmacd(6)',
                    IFNAME           => 'ge-0/0/13',
                    IFOUTOCTETS      => '2070139092',
                    IFLASTCHANGE     => '(1383988034) 160 days, 4:24:40.34',
                    IFMTU            => '1514',
                    IFNUMBER         => '511',
                    IFDESCR          => 'ge-0/0/13'
                },
                {
                    IFTYPE           => 'propVirtual(53)',
                    IFNAME           => 'ge-0/0/13.0',
                    IFSTATUS         => 'lowerLayerDown(7)',
                    IFINOCTETS       => '390894',
                    IFNUMBER         => '512',
                    IFDESCR          => 'ge-0/0/13.0',
                    IFOUTOCTETS      => '131871',
                    IFLASTCHANGE     => '(1383988034) 160 days, 4:24:40.34',
                    IFMTU            => '1514',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFSPEED          => '0',
                    IFINERRORS       => '0'
                },
                {
                    IFDESCR          => 'ge-0/0/14',
                    IFNUMBER         => '513',
                    IFLASTCHANGE     => '(1392608516) 161 days, 4:21:25.16',
                    IFMTU            => '1514',
                    IFOUTOCTETS      => '2042948528',
                    IFNAME           => 'ge-0/0/14',
                    IFTYPE           => 'ethernetCsmacd(6)',
                    IFINOCTETS       => '73541065',
                    IFSTATUS         => 'down(2)',
                    IFSPEED          => '1000000000',
                    IFINERRORS       => '0',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)'
                },
                {
                    IFSPEED          => '0',
                    IFINERRORS       => '0',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFNUMBER         => '514',
                    IFDESCR          => 'ge-0/0/14.0',
                    IFOUTOCTETS      => '142940',
                    IFLASTCHANGE     => '(1392608516) 161 days, 4:21:25.16',
                    IFMTU            => '1514',
                    IFTYPE           => 'propVirtual(53)',
                    IFNAME           => 'ge-0/0/14.0',
                    IFSTATUS         => 'lowerLayerDown(7)',
                    IFINOCTETS       => '247639'
                },
                {
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0',
                    IFINERRORS       => '0',
                    IFSPEED          => '1000000000',
                    IFSTATUS         => 'down(2)',
                    IFINOCTETS       => '10291556',
                    IFTYPE           => 'ethernetCsmacd(6)',
                    IFNAME           => 'ge-0/0/15',
                    IFOUTOCTETS      => '920149549',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(1383987392) 160 days, 4:24:33.92',
                    IFNUMBER         => '515',
                    IFDESCR          => 'ge-0/0/15'
                },
                {
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(1383987392) 160 days, 4:24:33.92',
                    IFOUTOCTETS      => '193755',
                    IFDESCR          => 'ge-0/0/15.0',
                    IFNUMBER         => '516',
                    IFINOCTETS       => '624396',
                    IFSTATUS         => 'lowerLayerDown(7)',
                    IFNAME           => 'ge-0/0/15.0',
                    IFTYPE           => 'propVirtual(53)',
                    IFINERRORS       => '0',
                    IFSPEED          => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0'
                },
                {
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFSPEED          => '100000000',
                    IFINERRORS       => '0',
                    IFNAME           => 'ge-0/0/16',
                    IFTYPE           => 'ethernetCsmacd(6)',
                    IFINOCTETS       => '144694897',
                    IFSTATUS         => 'down(2)',
                    IFDESCR          => 'ge-0/0/16',
                    IFNUMBER         => '517',
                    IFLASTCHANGE     => '(1402988034) 162 days, 9:11:20.34',
                    IFMTU            => '1514',
                    IFOUTOCTETS      => '373175314'
                },
                {
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0',
                    IFINERRORS       => '0',
                    IFSPEED          => '0',
                    IFINOCTETS       => '4168655',
                    IFSTATUS         => 'lowerLayerDown(7)',
                    IFNAME           => 'ge-0/0/16.0',
                    IFTYPE           => 'propVirtual(53)',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(1402988034) 162 days, 9:11:20.34',
                    IFOUTOCTETS      => '800961',
                    IFDESCR          => 'ge-0/0/16.0',
                    IFNUMBER         => '518'
                },
                {
                    IFNAME           => 'ge-0/0/17',
                    IFTYPE           => 'ethernetCsmacd(6)',
                    IFINOCTETS       => '112282597',
                    IFSTATUS         => 'down(2)',
                    IFDESCR          => 'ge-0/0/17',
                    IFNUMBER         => '519',
                    IFLASTCHANGE     => '(1505111362) 174 days, 4:51:53.62',
                    IFMTU            => '1514',
                    IFOUTOCTETS      => '3622860141',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFSPEED          => '1000000000',
                    IFINERRORS       => '0'
                },
                {
                    IFINOCTETS       => '3263756',
                    IFSTATUS         => 'lowerLayerDown(7)',
                    IFNAME           => 'ge-0/0/17.0',
                    IFTYPE           => 'propVirtual(53)',
                    IFLASTCHANGE     => '(1505111362) 174 days, 4:51:53.62',
                    IFMTU            => '1514',
                    IFOUTOCTETS      => '388748',
                    IFDESCR          => 'ge-0/0/17.0',
                    IFNUMBER         => '520',
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0',
                    IFINERRORS       => '0',
                    IFSPEED          => '0'
                },
                {
                    IFSTATUS         => 'down(2)',
                    IFINOCTETS       => '69571870',
                    IFTYPE           => 'ethernetCsmacd(6)',
                    IFNAME           => 'ge-0/0/18',
                    IFOUTOCTETS      => '2110991844',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(1143701810) 132 days, 8:56:58.10',
                    IFNUMBER         => '521',
                    IFDESCR          => 'ge-0/0/18',
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0',
                    IFINERRORS       => '0',
                    IFSPEED          => '100000000'
                },
                {
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0',
                    IFINERRORS       => '0',
                    IFSPEED          => '0',
                    IFSTATUS         => 'lowerLayerDown(7)',
                    IFINOCTETS       => '2358039',
                    IFTYPE           => 'propVirtual(53)',
                    IFNAME           => 'ge-0/0/18.0',
                    IFOUTOCTETS      => '498770',
                    IFLASTCHANGE     => '(1143701810) 132 days, 8:56:58.10',
                    IFMTU            => '1514',
                    IFNUMBER         => '522',
                    IFDESCR          => 'ge-0/0/18.0'
                },
                {
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFSPEED          => '100000000',
                    IFINERRORS       => '0',
                    IFNAME           => 'ge-0/0/19',
                    IFTYPE           => 'ethernetCsmacd(6)',
                    IFINOCTETS       => '54665076',
                    IFSTATUS         => 'down(2)',
                    IFDESCR          => 'ge-0/0/19',
                    IFNUMBER         => '523',
                    IFLASTCHANGE     => '(1143887182) 132 days, 9:27:51.82',
                    IFMTU            => '1514',
                    IFOUTOCTETS      => '1198628365'
                },
                {
                    IFINOCTETS       => '844445',
                    IFSTATUS         => 'lowerLayerDown(7)',
                    IFNAME           => 'ge-0/0/19.0',
                    IFTYPE           => 'propVirtual(53)',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(1143887182) 132 days, 9:27:51.82',
                    IFOUTOCTETS      => '84168',
                    IFDESCR          => 'ge-0/0/19.0',
                    IFNUMBER         => '524',
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0',
                    IFINERRORS       => '0',
                    IFSPEED          => '0'
                },
                {
                    IFSTATUS         => 'up(1)',
                    IFINOCTETS       => '71549018',
                    IFTYPE           => 'ethernetCsmacd(6)',
                    IFNAME           => 'ge-0/0/2',
                    IFOUTOCTETS      => '2214237751',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(1514274855) 175 days, 6:19:08.55',
                    IFNUMBER         => '525',
                    IFDESCR          => 'ge-0/0/2',
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0',
                    IFINERRORS       => '0',
                    IFSPEED          => '1000000000'
                },
                {
                    IFNUMBER         => '526',
                    IFDESCR          => 'ge-0/0/2.0',
                    IFOUTOCTETS      => '216986',
                    IFLASTCHANGE     => '(1514274855) 175 days, 6:19:08.55',
                    IFMTU            => '1514',
                    IFTYPE           => 'propVirtual(53)',
                    IFNAME           => 'ge-0/0/2.0',
                    IFSTATUS         => 'up(1)',
                    IFINOCTETS       => '1344926',
                    IFSPEED          => '0',
                    IFINERRORS       => '0',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)'
                },
                {
                    IFSTATUS         => 'down(2)',
                    IFINOCTETS       => '101162940',
                    IFTYPE           => 'ethernetCsmacd(6)',
                    IFNAME           => 'ge-0/0/20',
                    IFOUTOCTETS      => '3191603905',
                    IFLASTCHANGE     => '(1031918668) 119 days, 10:26:26.68',
                    IFMTU            => '1514',
                    IFNUMBER         => '527',
                    IFDESCR          => 'ge-0/0/20',
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0',
                    IFINERRORS       => '0',
                    IFSPEED          => '100000000'
                },
                {
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0',
                    IFINERRORS       => '0',
                    IFSPEED          => '0',
                    IFINOCTETS       => '287186',
                    IFSTATUS         => 'lowerLayerDown(7)',
                    IFNAME           => 'ge-0/0/20.0',
                    IFTYPE           => 'propVirtual(53)',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(1031918668) 119 days, 10:26:26.68',
                    IFOUTOCTETS      => '331734',
                    IFDESCR          => 'ge-0/0/20.0',
                    IFNUMBER         => '528'
                },
                {
                    IFINERRORS       => '0',
                    IFSPEED          => '1000000000',
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0',
                    IFOUTOCTETS      => '1112146726',
                    IFLASTCHANGE     => '(1452971670) 168 days, 4:01:56.70',
                    IFMTU            => '1514',
                    IFNUMBER         => '529',
                    IFDESCR          => 'ge-0/0/21',
                    IFSTATUS         => 'down(2)',
                    IFINOCTETS       => '45333984',
                    IFTYPE           => 'ethernetCsmacd(6)',
                    IFNAME           => 'ge-0/0/21'
                },
                {
                    IFSTATUS         => 'lowerLayerDown(7)',
                    IFINOCTETS       => '2170170',
                    IFTYPE           => 'propVirtual(53)',
                    IFNAME           => 'ge-0/0/21.0',
                    IFOUTOCTETS      => '118187',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(1452971670) 168 days, 4:01:56.70',
                    IFNUMBER         => '530',
                    IFDESCR          => 'ge-0/0/21.0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0',
                    IFINERRORS       => '0',
                    IFSPEED          => '0'
                },
                {
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFSPEED          => '1000000000',
                    IFINERRORS       => '0',
                    IFNAME           => 'ge-0/0/22',
                    IFTYPE           => 'ethernetCsmacd(6)',
                    IFINOCTETS       => '349227121',
                    IFSTATUS         => 'down(2)',
                    IFDESCR          => 'ge-0/0/22',
                    IFNUMBER         => '531',
                    IFLASTCHANGE     => '(1507744280) 174 days, 12:10:42.80',
                    IFMTU            => '1514',
                    IFOUTOCTETS      => '2349516312'
                },
                {
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0',
                    IFINERRORS       => '0',
                    IFSPEED          => '0',
                    IFSTATUS         => 'lowerLayerDown(7)',
                    IFINOCTETS       => '7875686',
                    IFTYPE           => 'propVirtual(53)',
                    IFNAME           => 'ge-0/0/22.0',
                    IFOUTOCTETS      => '837854',
                    IFLASTCHANGE     => '(1507744280) 174 days, 12:10:42.80',
                    IFMTU            => '1514',
                    IFNUMBER         => '532',
                    IFDESCR          => 'ge-0/0/22.0'
                },
                {
                    IFINERRORS       => '0',
                    IFSPEED          => '1000000000',
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0',
                    IFLASTCHANGE     => '(1384857878) 160 days, 6:49:38.78',
                    IFMTU            => '1514',
                    IFOUTOCTETS      => '3770626360',
                    IFDESCR          => 'ge-0/0/23',
                    IFNUMBER         => '533',
                    IFINOCTETS       => '63700153',
                    IFSTATUS         => 'down(2)',
                    IFNAME           => 'ge-0/0/23',
                    IFTYPE           => 'ethernetCsmacd(6)'
                },
                {
                    IFOUTOCTETS      => '505220',
                    IFLASTCHANGE     => '(1384857878) 160 days, 6:49:38.78',
                    IFMTU            => '1514',
                    IFNUMBER         => '534',
                    IFDESCR          => 'ge-0/0/23.0',
                    IFSTATUS         => 'lowerLayerDown(7)',
                    IFINOCTETS       => '1953525',
                    IFTYPE           => 'propVirtual(53)',
                    IFNAME           => 'ge-0/0/23.0',
                    IFINERRORS       => '0',
                    IFSPEED          => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0'
                },
                {
                    IFNUMBER         => '535',
                    IFDESCR          => 'ge-0/0/24',
                    IFOUTOCTETS      => '1675279409',
                    IFLASTCHANGE     => '(1506337000) 174 days, 8:16:10.00',
                    IFMTU            => '1514',
                    IFTYPE           => 'ethernetCsmacd(6)',
                    IFNAME           => 'ge-0/0/24',
                    IFSTATUS         => 'down(2)',
                    IFINOCTETS       => '24341650',
                    IFSPEED          => '10000000',
                    IFINERRORS       => '0',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)'
                },
                {
                    IFSPEED          => '0',
                    IFINERRORS       => '0',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFDESCR          => 'ge-0/0/24.0',
                    IFNUMBER         => '536',
                    IFLASTCHANGE     => '(1506337000) 174 days, 8:16:10.00',
                    IFMTU            => '1514',
                    IFOUTOCTETS      => '215960',
                    IFNAME           => 'ge-0/0/24.0',
                    IFTYPE           => 'propVirtual(53)',
                    IFINOCTETS       => '299238',
                    IFSTATUS         => 'lowerLayerDown(7)'
                },
                {
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFSPEED          => '1000000000',
                    IFINERRORS       => '0',
                    IFNAME           => 'ge-0/0/25',
                    IFTYPE           => 'ethernetCsmacd(6)',
                    IFINOCTETS       => '149804990',
                    IFSTATUS         => 'down(2)',
                    IFDESCR          => 'ge-0/0/25',
                    IFNUMBER         => '537',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(1506965500) 174 days, 10:00:55.00',
                    IFOUTOCTETS      => '958374164'
                },
                {
                    IFSTATUS         => 'lowerLayerDown(7)',
                    IFINOCTETS       => '3824745',
                    IFTYPE           => 'propVirtual(53)',
                    IFNAME           => 'ge-0/0/25.0',
                    IFOUTOCTETS      => '429062',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(1506965500) 174 days, 10:00:55.00',
                    IFNUMBER         => '538',
                    IFDESCR          => 'ge-0/0/25.0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0',
                    IFINERRORS       => '0',
                    IFSPEED          => '0'
                },
                {
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0',
                    IFINERRORS       => '0',
                    IFSPEED          => '100000000',
                    IFSTATUS         => 'down(2)',
                    IFINOCTETS       => '8707382',
                    IFTYPE           => 'ethernetCsmacd(6)',
                    IFNAME           => 'ge-0/0/26',
                    IFOUTOCTETS      => '314497846',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(1030566650) 119 days, 6:41:06.50',
                    IFNUMBER         => '539',
                    IFDESCR          => 'ge-0/0/26'
                },
                {
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFSPEED          => '0',
                    IFINERRORS       => '0',
                    IFNAME           => 'ge-0/0/26.0',
                    IFTYPE           => 'propVirtual(53)',
                    IFINOCTETS       => '250977',
                    IFSTATUS         => 'lowerLayerDown(7)',
                    IFDESCR          => 'ge-0/0/26.0',
                    IFNUMBER         => '540',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(1030566650) 119 days, 6:41:06.50',
                    IFOUTOCTETS      => '6710'
                },
                {
                    IFNAME           => 'ge-0/0/27',
                    IFTYPE           => 'ethernetCsmacd(6)',
                    IFINOCTETS       => '59953469',
                    IFSTATUS         => 'down(2)',
                    IFDESCR          => 'ge-0/0/27',
                    IFNUMBER         => '541',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(1507221140) 174 days, 10:43:31.40',
                    IFOUTOCTETS      => '2945748283',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFSPEED          => '100000000',
                    IFINERRORS       => '0'
                },
                {
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(1507221140) 174 days, 10:43:31.40',
                    IFOUTOCTETS      => '118141',
                    IFDESCR          => 'ge-0/0/27.0',
                    IFNUMBER         => '542',
                    IFINOCTETS       => '424630',
                    IFSTATUS         => 'lowerLayerDown(7)',
                    IFNAME           => 'ge-0/0/27.0',
                    IFTYPE           => 'propVirtual(53)',
                    IFINERRORS       => '0',
                    IFSPEED          => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0'
                },
                {
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFSPEED          => '1000000000',
                    IFINERRORS       => '0',
                    IFTYPE           => 'ethernetCsmacd(6)',
                    IFNAME           => 'ge-0/0/28',
                    IFSTATUS         => 'down(2)',
                    IFINOCTETS       => '35974557',
                    IFNUMBER         => '543',
                    IFDESCR          => 'ge-0/0/28',
                    IFOUTOCTETS      => '801954910',
                    IFLASTCHANGE     => '(850490968) 98 days, 10:28:29.68',
                    IFMTU            => '1514'
                },
                {
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(850490968) 98 days, 10:28:29.68',
                    IFOUTOCTETS      => '460',
                    IFDESCR          => 'ge-0/0/28.0',
                    IFNUMBER         => '544',
                    IFINOCTETS       => '1732098',
                    IFSTATUS         => 'lowerLayerDown(7)',
                    IFNAME           => 'ge-0/0/28.0',
                    IFTYPE           => 'propVirtual(53)',
                    IFINERRORS       => '0',
                    IFSPEED          => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0'
                },
                {
                    IFINERRORS       => '0',
                    IFSPEED          => '100000000',
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0',
                    IFOUTOCTETS      => '2935236434',
                    IFLASTCHANGE     => '(1470728810) 170 days, 5:21:28.10',
                    IFMTU            => '1514',
                    IFNUMBER         => '545',
                    IFDESCR          => 'ge-0/0/29',
                    IFSTATUS         => 'down(2)',
                    IFINOCTETS       => '62331862',
                    IFTYPE           => 'ethernetCsmacd(6)',
                    IFNAME           => 'ge-0/0/29'
                },
                {
                    IFDESCR          => 'ge-0/0/29.0',
                    IFNUMBER         => '546',
                    IFLASTCHANGE     => '(1470728810) 170 days, 5:21:28.10',
                    IFMTU            => '1514',
                    IFOUTOCTETS      => '265039',
                    IFNAME           => 'ge-0/0/29.0',
                    IFTYPE           => 'propVirtual(53)',
                    IFINOCTETS       => '1758447',
                    IFSTATUS         => 'lowerLayerDown(7)',
                    IFSPEED          => '0',
                    IFINERRORS       => '0',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)'
                },
                {
                    IFINOCTETS       => '63492350',
                    IFSTATUS         => 'down(2)',
                    IFNAME           => 'ge-0/0/3',
                    IFTYPE           => 'ethernetCsmacd(6)',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(1092023384) 126 days, 9:23:53.84',
                    IFOUTOCTETS      => '3428946165',
                    IFDESCR          => 'ge-0/0/3',
                    IFNUMBER         => '547',
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0',
                    IFINERRORS       => '0',
                    IFSPEED          => '1000000000'
                },
                {
                    IFINERRORS       => '0',
                    IFSPEED          => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0',
                    IFOUTOCTETS      => '309544',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(1092023384) 126 days, 9:23:53.84',
                    IFNUMBER         => '548',
                    IFDESCR          => 'ge-0/0/3.0',
                    IFSTATUS         => 'lowerLayerDown(7)',
                    IFINOCTETS       => '671676',
                    IFTYPE           => 'propVirtual(53)',
                    IFNAME           => 'ge-0/0/3.0'
                },
                {
                    IFNUMBER         => '549',
                    IFDESCR          => 'ge-0/0/30',
                    IFOUTOCTETS      => '490225744',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(1470404984) 170 days, 4:27:29.84',
                    IFTYPE           => 'ethernetCsmacd(6)',
                    IFNAME           => 'ge-0/0/30',
                    IFSTATUS         => 'down(2)',
                    IFINOCTETS       => '7460415',
                    IFSPEED          => '100000000',
                    IFINERRORS       => '0',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)'
                },
                {
                    IFINERRORS       => '0',
                    IFSPEED          => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0',
                    IFOUTOCTETS      => '115652',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(1470404984) 170 days, 4:27:29.84',
                    IFNUMBER         => '550',
                    IFDESCR          => 'ge-0/0/30.0',
                    IFSTATUS         => 'lowerLayerDown(7)',
                    IFINOCTETS       => '350036',
                    IFTYPE           => 'propVirtual(53)',
                    IFNAME           => 'ge-0/0/30.0'
                },
                {
                    IFSTATUS         => 'down(2)',
                    IFINOCTETS       => '125852225',
                    IFTYPE           => 'ethernetCsmacd(6)',
                    IFNAME           => 'ge-0/0/31',
                    IFOUTOCTETS      => '1174250796',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(1110357572) 128 days, 12:19:35.72',
                    IFNUMBER         => '551',
                    IFDESCR          => 'ge-0/0/31',
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0',
                    IFINERRORS       => '0',
                    IFSPEED          => '100000000'
                },
                {
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFSPEED          => '0',
                    IFINERRORS       => '0',
                    IFTYPE           => 'propVirtual(53)',
                    IFNAME           => 'ge-0/0/31.0',
                    IFSTATUS         => 'lowerLayerDown(7)',
                    IFINOCTETS       => '3504165',
                    IFNUMBER         => '552',
                    IFDESCR          => 'ge-0/0/31.0',
                    IFOUTOCTETS      => '647546',
                    IFLASTCHANGE     => '(1110357572) 128 days, 12:19:35.72',
                    IFMTU            => '1514'
                },
                {
                    IFDESCR          => 'ge-0/0/32',
                    IFNUMBER         => '553',
                    IFLASTCHANGE     => '(1384810132) 160 days, 6:41:41.32',
                    IFMTU            => '1514',
                    IFOUTOCTETS      => '3504587939',
                    IFNAME           => 'ge-0/0/32',
                    IFTYPE           => 'ethernetCsmacd(6)',
                    IFINOCTETS       => '124837521',
                    IFSTATUS         => 'down(2)',
                    IFSPEED          => '1000000000',
                    IFINERRORS       => '0',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)'
                },
                {
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFSPEED          => '0',
                    IFINERRORS       => '0',
                    IFTYPE           => 'propVirtual(53)',
                    IFNAME           => 'ge-0/0/32.0',
                    IFSTATUS         => 'lowerLayerDown(7)',
                    IFINOCTETS       => '3993337',
                    IFNUMBER         => '554',
                    IFDESCR          => 'ge-0/0/32.0',
                    IFOUTOCTETS      => '566590',
                    IFLASTCHANGE     => '(1384810132) 160 days, 6:41:41.32',
                    IFMTU            => '1514'
                },
                {
                    IFNAME           => 'ge-0/0/33',
                    IFTYPE           => 'ethernetCsmacd(6)',
                    IFINOCTETS       => '96592127',
                    IFSTATUS         => 'down(2)',
                    IFDESCR          => 'ge-0/0/33',
                    IFNUMBER         => '555',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(1143565972) 132 days, 8:34:19.72',
                    IFOUTOCTETS      => '2598548649',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFSPEED          => '1000000000',
                    IFINERRORS       => '0'
                },
                {
                    IFINERRORS       => '0',
                    IFSPEED          => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0',
                    IFOUTOCTETS      => '356779',
                    IFLASTCHANGE     => '(1143565972) 132 days, 8:34:19.72',
                    IFMTU            => '1514',
                    IFNUMBER         => '556',
                    IFDESCR          => 'ge-0/0/33.0',
                    IFSTATUS         => 'lowerLayerDown(7)',
                    IFINOCTETS       => '2466593',
                    IFTYPE           => 'propVirtual(53)',
                    IFNAME           => 'ge-0/0/33.0'
                },
                {
                    IFNUMBER         => '557',
                    IFDESCR          => 'ge-0/0/34',
                    IFOUTOCTETS      => '550813130',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(1384542134) 160 days, 5:57:01.34',
                    IFTYPE           => 'ethernetCsmacd(6)',
                    IFNAME           => 'ge-0/0/34',
                    IFSTATUS         => 'down(2)',
                    IFINOCTETS       => '16553538',
                    IFSPEED          => '100000000',
                    IFINERRORS       => '0',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)'
                },
                {
                    IFNAME           => 'ge-0/0/35',
                    IFTYPE           => 'ethernetCsmacd(6)',
                    IFINOCTETS       => '33379366',
                    IFSTATUS         => 'down(2)',
                    IFDESCR          => 'ge-0/0/35',
                    IFNUMBER         => '558',
                    IFLASTCHANGE     => '(1118850195) 129 days, 11:55:01.95',
                    IFMTU            => '1514',
                    IFOUTOCTETS      => '1447930462',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFSPEED          => '100000000',
                    IFINERRORS       => '0'
                },
                {
                    IFOUTOCTETS      => '713660693',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(1410733362) 163 days, 6:42:13.62',
                    IFNUMBER         => '559',
                    IFDESCR          => 'ge-0/0/36',
                    IFSTATUS         => 'down(2)',
                    IFINOCTETS       => '23981022',
                    IFTYPE           => 'ethernetCsmacd(6)',
                    IFNAME           => 'ge-0/0/36',
                    IFINERRORS       => '0',
                    IFSPEED          => '100000000',
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0'
                },
                {
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0',
                    IFINERRORS       => '0',
                    IFSPEED          => '100000000',
                    IFINOCTETS       => '152170123',
                    IFSTATUS         => 'down(2)',
                    IFNAME           => 'ge-0/0/37',
                    IFTYPE           => 'ethernetCsmacd(6)',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(1211950856) 140 days, 6:31:48.56',
                    IFOUTOCTETS      => '3016135548',
                    IFDESCR          => 'ge-0/0/37',
                    IFNUMBER         => '560'
                },
                {
                    IFINERRORS       => '0',
                    IFSPEED          => '100000000',
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(1455360768) 168 days, 10:40:07.68',
                    IFOUTOCTETS      => '3017918010',
                    IFDESCR          => 'ge-0/0/38',
                    IFNUMBER         => '561',
                    IFINOCTETS       => '76749283',
                    IFSTATUS         => 'down(2)',
                    IFNAME           => 'ge-0/0/38',
                    IFTYPE           => 'ethernetCsmacd(6)'
                },
                {
                    IFINOCTETS       => '203771803',
                    IFSTATUS         => 'down(2)',
                    IFNAME           => 'ge-0/0/39',
                    IFTYPE           => 'ethernetCsmacd(6)',
                    IFLASTCHANGE     => '(1505307478) 174 days, 5:24:34.78',
                    IFMTU            => '1514',
                    IFOUTOCTETS      => '2659142896',
                    IFDESCR          => 'ge-0/0/39',
                    IFNUMBER         => '562',
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0',
                    IFINERRORS       => '0',
                    IFSPEED          => '1000000000'
                },
                {
                    IFINERRORS       => '0',
                    IFSPEED          => '1000000000',
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(1099914508) 127 days, 7:19:05.08',
                    IFOUTOCTETS      => '1007329801',
                    IFDESCR          => 'ge-0/0/4',
                    IFNUMBER         => '563',
                    IFINOCTETS       => '38057500',
                    IFSTATUS         => 'down(2)',
                    IFNAME           => 'ge-0/0/4',
                    IFTYPE           => 'ethernetCsmacd(6)'
                },
                {
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFSPEED          => '0',
                    IFINERRORS       => '0',
                    IFNAME           => 'ge-0/0/4.0',
                    IFTYPE           => 'propVirtual(53)',
                    IFINOCTETS       => '3524662',
                    IFSTATUS         => 'lowerLayerDown(7)',
                    IFDESCR          => 'ge-0/0/4.0',
                    IFNUMBER         => '564',
                    IFLASTCHANGE     => '(1099914508) 127 days, 7:19:05.08',
                    IFMTU            => '1514',
                    IFOUTOCTETS      => '145026'
                },
                {
                    IFSTATUS         => 'down(2)',
                    IFINOCTETS       => '0',
                    IFTYPE           => 'ethernetCsmacd(6)',
                    IFNAME           => 'ge-0/0/40',
                    IFOUTOCTETS      => '0',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(5428) 0:00:54.28',
                    IFNUMBER         => '565',
                    IFDESCR          => 'ge-0/0/40',
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0',
                    IFINERRORS       => '0',
                    IFSPEED          => '0'
                },
                {
                    IFNUMBER         => '566',
                    IFDESCR          => 'ge-0/0/41',
                    IFOUTOCTETS      => '0',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(5434) 0:00:54.34',
                    IFTYPE           => 'ethernetCsmacd(6)',
                    IFNAME           => 'ge-0/0/41',
                    IFSTATUS         => 'down(2)',
                    IFINOCTETS       => '0',
                    IFSPEED          => '0',
                    IFINERRORS       => '0',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)'
                },
                {
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0',
                    IFINERRORS       => '0',
                    IFSPEED          => '0',
                    IFINOCTETS       => '0',
                    IFSTATUS         => 'down(2)',
                    IFNAME           => 'ge-0/0/42',
                    IFTYPE           => 'ethernetCsmacd(6)',
                    IFLASTCHANGE     => '(5441) 0:00:54.41',
                    IFMTU            => '1514',
                    IFOUTOCTETS      => '0',
                    IFDESCR          => 'ge-0/0/42',
                    IFNUMBER         => '567'
                },
                {
                    IFNUMBER         => '568',
                    IFDESCR          => 'ge-0/0/43',
                    IFOUTOCTETS      => '0',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(5448) 0:00:54.48',
                    IFTYPE           => 'ethernetCsmacd(6)',
                    IFNAME           => 'ge-0/0/43',
                    IFSTATUS         => 'down(2)',
                    IFINOCTETS       => '0',
                    IFSPEED          => '0',
                    IFINERRORS       => '0',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)'
                },
                {
                    IFINOCTETS       => '0',
                    IFSTATUS         => 'down(2)',
                    IFNAME           => 'ge-0/0/44',
                    IFTYPE           => 'ethernetCsmacd(6)',
                    IFLASTCHANGE     => '(5458) 0:00:54.58',
                    IFMTU            => '1514',
                    IFOUTOCTETS      => '0',
                    IFDESCR          => 'ge-0/0/44',
                    IFNUMBER         => '569',
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0',
                    IFINERRORS       => '0',
                    IFSPEED          => '0'
                },
                {
                    IFSTATUS         => 'down(2)',
                    IFINOCTETS       => '0',
                    IFTYPE           => 'ethernetCsmacd(6)',
                    IFNAME           => 'ge-0/0/45',
                    IFOUTOCTETS      => '0',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(5466) 0:00:54.66',
                    IFNUMBER         => '570',
                    IFDESCR          => 'ge-0/0/45',
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0',
                    IFINERRORS       => '0',
                    IFSPEED          => '0'
                },
                {
                    IFINERRORS       => '0',
                    IFSPEED          => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(5473) 0:00:54.73',
                    IFOUTOCTETS      => '0',
                    IFDESCR          => 'ge-0/0/46',
                    IFNUMBER         => '571',
                    IFINOCTETS       => '0',
                    IFSTATUS         => 'down(2)',
                    IFNAME           => 'ge-0/0/46',
                    IFTYPE           => 'ethernetCsmacd(6)'
                },
                {
                    IFSPEED          => '100000000',
                    IFINERRORS       => '0',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFDESCR          => 'ge-0/0/47',
                    IFNUMBER         => '572',
                    IFLASTCHANGE     => '(6575) 0:01:05.75',
                    IFMTU            => '1514',
                    IFOUTOCTETS      => '759695086',
                    IFNAME           => 'ge-0/0/47',
                    IFTYPE           => 'ethernetCsmacd(6)',
                    IFINOCTETS       => '3459942395',
                    IFSTATUS         => 'up(1)'
                },
                {
                    IFINOCTETS       => '13515708',
                    IFSTATUS         => 'down(2)',
                    IFNAME           => 'ge-0/0/5',
                    IFTYPE           => 'ethernetCsmacd(6)',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(848117844) 98 days, 3:52:58.44',
                    IFOUTOCTETS      => '817163343',
                    IFDESCR          => 'ge-0/0/5',
                    IFNUMBER         => '573',
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0',
                    IFINERRORS       => '0',
                    IFSPEED          => '1000000000'
                },
                {
                    IFOUTOCTETS      => '460',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(848117844) 98 days, 3:52:58.44',
                    IFNUMBER         => '574',
                    IFDESCR          => 'ge-0/0/5.0',
                    IFSTATUS         => 'lowerLayerDown(7)',
                    IFINOCTETS       => '74580',
                    IFTYPE           => 'propVirtual(53)',
                    IFNAME           => 'ge-0/0/5.0',
                    IFINERRORS       => '0',
                    IFSPEED          => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0'
                },
                {
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFSPEED          => '1000000000',
                    IFINERRORS       => '0',
                    IFNAME           => 'ge-0/0/6',
                    IFTYPE           => 'ethernetCsmacd(6)',
                    IFINOCTETS       => '19677539',
                    IFSTATUS         => 'down(2)',
                    IFDESCR          => 'ge-0/0/6',
                    IFNUMBER         => '575',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(1401432020) 162 days, 4:52:00.20',
                    IFOUTOCTETS      => '560323704'
                },
                {
                    IFSTATUS         => 'lowerLayerDown(7)',
                    IFINOCTETS       => '1654420',
                    IFTYPE           => 'propVirtual(53)',
                    IFNAME           => 'ge-0/0/6.0',
                    IFOUTOCTETS      => '85644',
                    IFLASTCHANGE     => '(1401432020) 162 days, 4:52:00.20',
                    IFMTU            => '1514',
                    IFNUMBER         => '576',
                    IFDESCR          => 'ge-0/0/6.0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0',
                    IFINERRORS       => '0',
                    IFSPEED          => '0'
                },
                {
                    IFDESCR          => 'ge-0/0/7',
                    IFNUMBER         => '577',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(1098601452) 127 days, 3:40:14.52',
                    IFOUTOCTETS      => '1046046635',
                    IFNAME           => 'ge-0/0/7',
                    IFTYPE           => 'ethernetCsmacd(6)',
                    IFINOCTETS       => '28825938',
                    IFSTATUS         => 'down(2)',
                    IFSPEED          => '10000000',
                    IFINERRORS       => '0',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)'
                },
                {
                    IFLASTCHANGE     => '(1098601452) 127 days, 3:40:14.52',
                    IFMTU            => '1514',
                    IFOUTOCTETS      => '75874',
                    IFDESCR          => 'ge-0/0/7.0',
                    IFNUMBER         => '578',
                    IFINOCTETS       => '149457',
                    IFSTATUS         => 'lowerLayerDown(7)',
                    IFNAME           => 'ge-0/0/7.0',
                    IFTYPE           => 'propVirtual(53)',
                    IFINERRORS       => '0',
                    IFSPEED          => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0'
                },
                {
                    IFINOCTETS       => '69584990',
                    IFSTATUS         => 'down(2)',
                    IFNAME           => 'ge-0/0/8',
                    IFTYPE           => 'ethernetCsmacd(6)',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(1030139372) 119 days, 5:29:53.72',
                    IFOUTOCTETS      => '4092848179',
                    IFDESCR          => 'ge-0/0/8',
                    IFNUMBER         => '579',
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0',
                    IFINERRORS       => '0',
                    IFSPEED          => '1000000000'
                },
                {
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFSPEED          => '0',
                    IFINERRORS       => '0',
                    IFNAME           => 'ge-0/0/8.0',
                    IFTYPE           => 'propVirtual(53)',
                    IFINOCTETS       => '644434',
                    IFSTATUS         => 'lowerLayerDown(7)',
                    IFDESCR          => 'ge-0/0/8.0',
                    IFNUMBER         => '580',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(1030139372) 119 days, 5:29:53.72',
                    IFOUTOCTETS      => '656200'
                },
                {
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFSPEED          => '1000000000',
                    IFINERRORS       => '0',
                    IFTYPE           => 'ethernetCsmacd(6)',
                    IFNAME           => 'ge-0/0/9',
                    IFSTATUS         => 'down(2)',
                    IFINOCTETS       => '1575617312',
                    IFNUMBER         => '581',
                    IFDESCR          => 'ge-0/0/9',
                    IFOUTOCTETS      => '3989857445',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(1453646644) 168 days, 5:54:26.44'
                },
                {
                    IFTYPE           => 'propVirtual(53)',
                    IFNAME           => 'ge-0/0/9.0',
                    IFSTATUS         => 'lowerLayerDown(7)',
                    IFINOCTETS       => '1953950',
                    IFNUMBER         => '582',
                    IFDESCR          => 'ge-0/0/9.0',
                    IFOUTOCTETS      => '601344',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(1453646644) 168 days, 5:54:26.44',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFSPEED          => '0',
                    IFINERRORS       => '0'
                },
                {
                    IFSPEED          => '1000000000',
                    IFINERRORS       => '0',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFDESCR          => 'jsrv',
                    IFNUMBER         => '583',
                    IFMTU            => '1518',
                    IFLASTCHANGE     => '(3017) 0:00:30.17',
                    IFOUTOCTETS      => '0',
                    IFNAME           => 'jsrv',
                    IFTYPE           => 'ethernetCsmacd(6)',
                    IFINOCTETS       => '0',
                    IFSTATUS         => 'up(1)'
                },
                {
                    IFDESCR          => 'jsrv.1',
                    IFNUMBER         => '584',
                    IFMTU            => '1500',
                    IFLASTCHANGE     => '(3839) 0:00:38.39',
                    IFOUTOCTETS      => '42',
                    IFNAME           => 'jsrv.1',
                    IFTYPE           => 'propVirtual(53)',
                    IFINOCTETS       => '0',
                    IFSTATUS         => 'up(1)',
                    IFSPEED          => '1000000000',
                    IFINERRORS       => '0',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)'
                },
                {
                    IFOUTOCTETS      => '507220467',
                    IFLASTCHANGE     => '(4134) 0:00:41.34',
                    IFMTU            => '1518',
                    IFNUMBER         => '585',
                    IFDESCR          => 'vlan',
                    IFSTATUS         => 'up(1)',
                    IFINOCTETS       => '1771188614',
                    IFTYPE           => 'ethernetCsmacd(6)',
                    IFNAME           => 'vlan',
                    IFINERRORS       => '0',
                    IFSPEED          => '1000000000',
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0'
                },
                {
                    IFTYPE           => 'propVirtual(53)',
                    IFNAME           => 'ge-0/0/34.0',
                    IFSTATUS         => 'lowerLayerDown(7)',
                    IFINOCTETS       => '1127322',
                    IFNUMBER         => '586',
                    IFDESCR          => 'ge-0/0/34.0',
                    IFOUTOCTETS      => '154281',
                    IFLASTCHANGE     => '(1384542134) 160 days, 5:57:01.34',
                    IFMTU            => '1514',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFSPEED          => '0',
                    IFINERRORS       => '0'
                },
                {
                    IFSPEED          => '0',
                    IFINERRORS       => '0',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFDESCR          => 'ge-0/0/35.0',
                    IFNUMBER         => '587',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(1118850195) 129 days, 11:55:01.95',
                    IFOUTOCTETS      => '225632',
                    IFNAME           => 'ge-0/0/35.0',
                    IFTYPE           => 'propVirtual(53)',
                    IFINOCTETS       => '223310',
                    IFSTATUS         => 'lowerLayerDown(7)'
                },
                {
                    IFNUMBER         => '588',
                    IFDESCR          => 'ge-0/0/36.0',
                    IFOUTOCTETS      => '48493',
                    IFLASTCHANGE     => '(1410733362) 163 days, 6:42:13.62',
                    IFMTU            => '1514',
                    IFTYPE           => 'propVirtual(53)',
                    IFNAME           => 'ge-0/0/36.0',
                    IFSTATUS         => 'lowerLayerDown(7)',
                    IFINOCTETS       => '503203',
                    IFSPEED          => '0',
                    IFINERRORS       => '0',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)'
                },
                {
                    IFTYPE           => 'propVirtual(53)',
                    IFNAME           => 'ge-0/0/37.0',
                    IFSTATUS         => 'lowerLayerDown(7)',
                    IFINOCTETS       => '376559',
                    IFNUMBER         => '589',
                    IFDESCR          => 'ge-0/0/37.0',
                    IFOUTOCTETS      => '165325',
                    IFLASTCHANGE     => '(1211950856) 140 days, 6:31:48.56',
                    IFMTU            => '1514',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFSPEED          => '0',
                    IFINERRORS       => '0'
                },
                {
                    IFTYPE           => 'propVirtual(53)',
                    IFNAME           => 'ge-0/0/38.0',
                    IFSTATUS         => 'lowerLayerDown(7)',
                    IFINOCTETS       => '1999894',
                    IFNUMBER         => '590',
                    IFDESCR          => 'ge-0/0/38.0',
                    IFOUTOCTETS      => '393988',
                    IFLASTCHANGE     => '(1455360768) 168 days, 10:40:07.68',
                    IFMTU            => '1514',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFSPEED          => '0',
                    IFINERRORS       => '0'
                },
                {
                    IFINERRORS       => '0',
                    IFSPEED          => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0',
                    IFLASTCHANGE     => '(1505307478) 174 days, 5:24:34.78',
                    IFMTU            => '1514',
                    IFOUTOCTETS      => '810980',
                    IFDESCR          => 'ge-0/0/39.0',
                    IFNUMBER         => '591',
                    IFINOCTETS       => '3498450',
                    IFSTATUS         => 'lowerLayerDown(7)',
                    IFNAME           => 'ge-0/0/39.0',
                    IFTYPE           => 'propVirtual(53)'
                },
                {
                    IFLASTCHANGE     => '(5431) 0:00:54.31',
                    IFMTU            => '1514',
                    IFOUTOCTETS      => '0',
                    IFDESCR          => 'ge-0/0/40.0',
                    IFNUMBER         => '592',
                    IFINOCTETS       => '0',
                    IFSTATUS         => 'lowerLayerDown(7)',
                    IFNAME           => 'ge-0/0/40.0',
                    IFTYPE           => 'propVirtual(53)',
                    IFINERRORS       => '0',
                    IFSPEED          => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0'
                },
                {
                    IFOUTOCTETS      => '0',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(5438) 0:00:54.38',
                    IFNUMBER         => '593',
                    IFDESCR          => 'ge-0/0/41.0',
                    IFSTATUS         => 'lowerLayerDown(7)',
                    IFINOCTETS       => '0',
                    IFTYPE           => 'propVirtual(53)',
                    IFNAME           => 'ge-0/0/41.0',
                    IFINERRORS       => '0',
                    IFSPEED          => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0'
                },
                {
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0',
                    IFINERRORS       => '0',
                    IFSPEED          => '0',
                    IFSTATUS         => 'lowerLayerDown(7)',
                    IFINOCTETS       => '0',
                    IFTYPE           => 'propVirtual(53)',
                    IFNAME           => 'ge-0/0/42.0',
                    IFOUTOCTETS      => '0',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(5445) 0:00:54.45',
                    IFNUMBER         => '594',
                    IFDESCR          => 'ge-0/0/42.0'
                },
                {
                    IFLASTCHANGE     => '(5453) 0:00:54.53',
                    IFMTU            => '1514',
                    IFOUTOCTETS      => '0',
                    IFDESCR          => 'ge-0/0/43.0',
                    IFNUMBER         => '595',
                    IFINOCTETS       => '0',
                    IFSTATUS         => 'lowerLayerDown(7)',
                    IFNAME           => 'ge-0/0/43.0',
                    IFTYPE           => 'propVirtual(53)',
                    IFINERRORS       => '0',
                    IFSPEED          => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0'
                },
                {
                    IFINERRORS       => '0',
                    IFSPEED          => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(5462) 0:00:54.62',
                    IFOUTOCTETS      => '0',
                    IFDESCR          => 'ge-0/0/44.0',
                    IFNUMBER         => '596',
                    IFINOCTETS       => '0',
                    IFSTATUS         => 'lowerLayerDown(7)',
                    IFNAME           => 'ge-0/0/44.0',
                    IFTYPE           => 'propVirtual(53)'
                },
                {
                    IFTYPE           => 'propVirtual(53)',
                    IFNAME           => 'ge-0/0/45.0',
                    IFSTATUS         => 'lowerLayerDown(7)',
                    IFINOCTETS       => '0',
                    IFNUMBER         => '597',
                    IFDESCR          => 'ge-0/0/45.0',
                    IFOUTOCTETS      => '0',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(5470) 0:00:54.70',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFSPEED          => '0',
                    IFINERRORS       => '0'
                },
                {
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0',
                    IFINERRORS       => '0',
                    IFSPEED          => '0',
                    IFSTATUS         => 'lowerLayerDown(7)',
                    IFINOCTETS       => '0',
                    IFTYPE           => 'propVirtual(53)',
                    IFNAME           => 'ge-0/0/46.0',
                    IFOUTOCTETS      => '0',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(5477) 0:00:54.77',
                    IFNUMBER         => '598',
                    IFDESCR          => 'ge-0/0/46.0'
                },
                {
                    CONNECTIONS => {
                        CONNECTION => {
                            MAC => [
                                '00:0B:FD:15:BB:EE',
                                '00:0B:5F:CC:D8:80',
                                '00:19:D1:92:0C:4C',
                                '00:09:43:09:04:18',
                                'E8:E7:32:27:63:F4',
                                'E8:E7:32:2A:E0:9E',
                                'E8:E7:32:2A:E8:A4',
                                'E8:E7:32:2B:C1:E2',
                                'E8:E7:32:4B:7B:B4',
                                'E8:E7:32:4B:8A:CC'
                            ]
                        }
                    },
                    IFTYPE           => 'propVirtual(53)',
                    IFNAME           => 'ge-0/0/47.0',
                    IFSTATUS         => 'up(1)',
                    IFINOCTETS       => '85681745',
                    IFNUMBER         => '599',
                    IFDESCR          => 'ge-0/0/47.0',
                    IFOUTOCTETS      => '593871581',
                    IFLASTCHANGE     => '(6575) 0:01:05.75',
                    IFMTU            => '1514',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFSPEED          => '0',
                    IFINERRORS       => '0'
                },
                {
                    IFSTATUS         => 'up(1)',
                    IFINOCTETS       => '1771189919',
                    IFTYPE           => 'propVirtual(53)',
                    IFNAME           => 'vlan.0',
                    IFOUTOCTETS      => '447506369',
                    IFLASTCHANGE     => '(6577) 0:01:05.77',
                    IFMTU            => '1500',
                    IFNUMBER         => '600',
                    IFDESCR          => 'vlan.0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0',
                    IFINERRORS       => '0',
                    IFSPEED          => '1000000000'
                }
                ]
            },
        }
    ],
    'juniper/ex2200.5.walk' => [
        {
            MANUFACTURER => 'Juniper',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Juniper Networks, Inc. ex2200-c-12p-2g internet router, kernel JUNOS 11.4R1.6 #0: 2011-11-15 10:11:59 UTC     builder@evenath.juniper.net:/volume/build/junos/11.4/release/11.4R1.6/obj-arm/bsd/kernels/JUNIPER-EX-2200/kernel Build date: 2011-11-15 09:57:14',
            SNMPHOSTNAME => 'C005-236b-ex2200',
            MAC          => '00:0B:CA:FE:00:00'
        },
        {
            MANUFACTURER => 'Juniper',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Juniper Networks, Inc. ex2200-c-12p-2g internet router, kernel JUNOS 11.4R1.6 #0: 2011-11-15 10:11:59 UTC     builder@evenath.juniper.net:/volume/build/junos/11.4/release/11.4R1.6/obj-arm/bsd/kernels/JUNIPER-EX-2200/kernel Build date: 2011-11-15 09:57:14',
            SNMPHOSTNAME => 'C005-236b-ex2200',
            MAC          => '00:0B:CA:FE:00:00',
            MODELSNMP    => 'Networking2180',
            MODEL        => undef,
            SERIAL       => undef,
            FIRMWARE     => undef,
        },
        {
            INFO => {
                MANUFACTURER => 'Juniper',
                TYPE         => 'NETWORKING',
                ID           => undef,
                MODEL        => undef,
                CONTACT      => undef,
                IPS          => {
                    IP => [
                        '128.0.0.1',
                        '128.0.0.127',
                        '128.0.0.16',
                        '128.0.0.32',
                        '192.168.1.236'
                    ]
                },
            },
            PORTS => {
                PORT => [
                {
                    IFDESCR          => 'lsi',
                    IFNUMBER         => '4',
                    IFMTU            => '1496',
                    IFLASTCHANGE     => '(0) 0:00:00.00',
                    IFOUTOCTETS      => '0',
                    IFTYPE           => 'mplsTunnel(150)',
                    IFINOCTETS       => '0',
                    IFSTATUS         => 'up(1)',
                    IFSPEED          => '0',
                    IFINERRORS       => '0',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)'
                },
                {
                    IFDESCR          => 'dsc',
                    IFNUMBER         => '5',
                    IFMTU            => '2147483647',
                    IFLASTCHANGE     => '(1328) 0:00:13.28',
                    IFOUTOCTETS      => '0',
                    IFTYPE           => 'other(1)',
                    IFINOCTETS       => '0',
                    IFSTATUS         => 'up(1)',
                    IFSPEED          => '0',
                    IFINERRORS       => '0',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)'
                },
                {
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0',
                    IFINERRORS       => '0',
                    IFSPEED          => '0',
                    IFINOCTETS       => '1205099385',
                    IFSTATUS         => 'up(1)',
                    IFTYPE           => 'softwareLoopback(24)',
                    IFMTU            => '2147483647',
                    IFLASTCHANGE     => '(1356) 0:00:13.56',
                    IFOUTOCTETS      => '1205099385',
                    IFDESCR          => 'lo0',
                    IFNUMBER         => '6'
                },
                {
                    IFINOCTETS       => '0',
                    IFSTATUS         => 'up(1)',
                    IFTYPE           => 'other(1)',
                    IFMTU            => '2147483647',
                    IFLASTCHANGE     => '(1371) 0:00:13.71',
                    IFOUTOCTETS      => '0',
                    IFDESCR          => 'tap',
                    IFNUMBER         => '7',
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0',
                    IFINERRORS       => '0',
                    IFSPEED          => '0'
                },
                {
                    IFOUTOCTETS      => '0',
                    IFLASTCHANGE     => '(1336) 0:00:13.36',
                    IFMTU            => '2147483647',
                    IFNUMBER         => '8',
                    IFDESCR          => 'gre',
                    IFSTATUS         => 'up(1)',
                    IFINOCTETS       => '0',
                    IFTYPE           => 'tunnel(131)',
                    IFINERRORS       => '0',
                    IFSPEED          => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0'
                },
                {
                    IFINERRORS       => '0',
                    IFSPEED          => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0',
                    IFLASTCHANGE     => '(1352) 0:00:13.52',
                    IFMTU            => '2147483647',
                    IFOUTOCTETS      => '0',
                    IFDESCR          => 'ipip',
                    IFNUMBER         => '9',
                    IFINOCTETS       => '0',
                    IFSTATUS         => 'up(1)',
                    IFTYPE           => 'tunnel(131)'
                },
                {
                    IFMTU            => '2147483647',
                    IFLASTCHANGE     => '(1271) 0:00:12.71',
                    IFOUTOCTETS      => '0',
                    IFDESCR          => 'pime',
                    IFNUMBER         => '10',
                    IFINOCTETS       => '0',
                    IFSTATUS         => 'up(1)',
                    IFTYPE           => 'tunnel(131)',
                    IFINERRORS       => '0',
                    IFSPEED          => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0'
                },
                {
                    IFOUTOCTETS      => '0',
                    IFMTU            => '2147483647',
                    IFLASTCHANGE     => '(1274) 0:00:12.74',
                    IFNUMBER         => '11',
                    IFDESCR          => 'pimd',
                    IFSTATUS         => 'up(1)',
                    IFINOCTETS       => '0',
                    IFTYPE           => 'tunnel(131)',
                    IFINERRORS       => '0',
                    IFSPEED          => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0'
                },
                {
                    IFINERRORS       => '0',
                    IFSPEED          => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0',
                    IFOUTOCTETS      => '0',
                    IFLASTCHANGE     => '(1363) 0:00:13.63',
                    IFMTU            => '2147483647',
                    IFNUMBER         => '12',
                    IFDESCR          => 'mtun',
                    IFSTATUS         => 'up(1)',
                    IFINOCTETS       => '0',
                    IFTYPE           => 'tunnel(131)'
                },
                {
                    IFSTATUS         => 'down(2)',
                    IFINOCTETS       => '0',
                    IFTYPE           => 'ethernetCsmacd(6)',
                    IFOUTOCTETS      => '0',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(1358) 0:00:13.58',
                    IFNUMBER         => '33',
                    IFDESCR          => 'me0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0',
                    IFINERRORS       => '0',
                    IFSPEED          => '0'
                },
                {
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFSPEED          => '0',
                    IFINERRORS       => '0',
                    IFTYPE           => 'ethernetCsmacd(6)',
                    IFINOCTETS       => '0',
                    IFSTATUS         => 'up(1)',
                    IFDESCR          => 'bme0',
                    IFNUMBER         => '37',
                    IFLASTCHANGE     => '(1268) 0:00:12.68',
                    IFMTU            => '1576',
                    IFOUTOCTETS      => '534363148'
                },
                {
                    IFMTU            => '1562',
                    IFLASTCHANGE     => '(1377) 0:00:13.77',
                    IFOUTOCTETS      => '0',
                    IFDESCR          => 'bme0.32768',
                    IFNUMBER         => '38',
                    IFINOCTETS       => '0',
                    IFSTATUS         => 'up(1)',
                    IFTYPE           => 'propVirtual(53)',
                    IFINERRORS       => '0',
                    IFSPEED          => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0'
                },
                {
                    IFINOCTETS       => '0',
                    IFSTATUS         => 'up(1)',
                    IFTYPE           => 'ethernetCsmacd(6)',
                    IFMTU            => '1518',
                    IFLASTCHANGE     => '(1288) 0:00:12.88',
                    IFOUTOCTETS      => '0',
                    IFDESCR          => 'jsrv',
                    IFNUMBER         => '501',
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0',
                    IFINERRORS       => '0',
                    IFSPEED          => '1000000000'
                },
                {
                    IFNUMBER         => '502',
                    IFDESCR          => 'jsrv.1',
                    IFOUTOCTETS      => '42',
                    IFLASTCHANGE     => '(1292) 0:00:12.92',
                    IFMTU            => '1500',
                    IFTYPE           => 'propVirtual(53)',
                    IFSTATUS         => 'up(1)',
                    IFINOCTETS       => '0',
                    IFSPEED          => '1000000000',
                    IFINERRORS       => '0',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)'
                },
                {
                    IFINOCTETS       => '1895692302',
                    IFSTATUS         => 'up(1)',
                    IFTYPE           => 'ethernetCsmacd(6)',
                    IFMTU            => '1518',
                    IFLASTCHANGE     => '(1391) 0:00:13.91',
                    IFOUTOCTETS      => '350482164',
                    IFDESCR          => 'vlan',
                    IFNUMBER         => '503',
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0',
                    IFINERRORS       => '18',
                    IFSPEED          => '1000000000'
                },
                {
                    IFSTATUS         => 'down(2)',
                    IFINOCTETS       => '0',
                    IFTYPE           => 'ethernetCsmacd(6)',
                    IFOUTOCTETS      => '0',
                    IFLASTCHANGE     => '(1404) 0:00:14.04',
                    IFMTU            => '1514',
                    IFNUMBER         => '504',
                    IFDESCR          => 'ge-0/0/0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0',
                    IFINERRORS       => '0',
                    IFSPEED          => '0'
                },
                {
                    IFTYPE           => 'propVirtual(53)',
                    IFSTATUS         => 'lowerLayerDown(7)',
                    IFINOCTETS       => '0',
                    IFNUMBER         => '505',
                    IFDESCR          => 'ge-0/0/0.0',
                    IFOUTOCTETS      => '0',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(1407) 0:00:14.07',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFSPEED          => '0',
                    IFINERRORS       => '0'
                },
                {
                    IFTYPE           => 'ethernetCsmacd(6)',
                    IFSTATUS         => 'up(1)',
                    IFINOCTETS       => '671285559',
                    IFNUMBER         => '506',
                    IFDESCR          => 'ge-0/0/1',
                    IFOUTOCTETS      => '1344808667',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(1519198217) 175 days, 19:59:42.17',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFSPEED          => '1000000000',
                    IFINERRORS       => '0'
                },
                {
                    IFSPEED          => '0',
                    IFINERRORS       => '0',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFDESCR          => 'ge-0/0/1.0',
                    IFNUMBER         => '507',
                    IFLASTCHANGE     => '(1519198217) 175 days, 19:59:42.17',
                    IFMTU            => '1514',
                    IFOUTOCTETS      => '5704',
                    IFTYPE           => 'propVirtual(53)',
                    IFINOCTETS       => '19465116',
                    IFSTATUS         => 'up(1)'
                },
                {
                    IFSPEED          => '0',
                    IFINERRORS       => '0',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFDESCR          => 'ge-0/0/2',
                    IFNUMBER         => '508',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(1428) 0:00:14.28',
                    IFOUTOCTETS      => '0',
                    IFTYPE           => 'ethernetCsmacd(6)',
                    IFINOCTETS       => '0',
                    IFSTATUS         => 'down(2)'
                },
                {
                    IFDESCR          => 'ge-0/0/2.0',
                    IFNUMBER         => '509',
                    IFLASTCHANGE     => '(1441) 0:00:14.41',
                    IFMTU            => '1514',
                    IFOUTOCTETS      => '0',
                    IFTYPE           => 'propVirtual(53)',
                    IFINOCTETS       => '0',
                    IFSTATUS         => 'lowerLayerDown(7)',
                    IFSPEED          => '0',
                    IFINERRORS       => '0',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)'
                },
                {
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0',
                    IFINERRORS       => '0',
                    IFSPEED          => '1000000000',
                    IFINOCTETS       => '1801889333',
                    IFSTATUS         => 'up(1)',
                    IFTYPE           => 'ethernetCsmacd(6)',
                    IFLASTCHANGE     => '(1519237117) 175 days, 20:06:11.17',
                    IFMTU            => '1514',
                    IFOUTOCTETS      => '2786297666',
                    IFDESCR          => 'ge-0/0/3',
                    IFNUMBER         => '510'
                },
                {
                    IFLASTCHANGE     => '(1519237117) 175 days, 20:06:11.17',
                    IFMTU            => '1514',
                    IFOUTOCTETS      => '6670',
                    IFDESCR          => 'ge-0/0/3.0',
                    IFNUMBER         => '511',
                    IFINOCTETS       => '30642324',
                    IFSTATUS         => 'up(1)',
                    IFTYPE           => 'propVirtual(53)',
                    IFINERRORS       => '0',
                    IFSPEED          => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0'
                },
                {
                    IFTYPE           => 'ethernetCsmacd(6)',
                    IFSTATUS         => 'up(1)',
                    IFINOCTETS       => '749044509',
                    IFNUMBER         => '512',
                    IFDESCR          => 'ge-0/0/4',
                    IFOUTOCTETS      => '1606606341',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(1519160047) 175 days, 19:53:20.47',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFSPEED          => '1000000000',
                    IFINERRORS       => '0'
                },
                {
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFSPEED          => '0',
                    IFINERRORS       => '0',
                    IFTYPE           => 'propVirtual(53)',
                    IFSTATUS         => 'up(1)',
                    IFINOCTETS       => '24091394',
                    IFNUMBER         => '513',
                    IFDESCR          => 'ge-0/0/4.0',
                    IFOUTOCTETS      => '6578',
                    IFLASTCHANGE     => '(1519160047) 175 days, 19:53:20.47',
                    IFMTU            => '1514'
                },
                {
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFSPEED          => '100000000',
                    IFINERRORS       => '0',
                    IFTYPE           => 'ethernetCsmacd(6)',
                    IFSTATUS         => 'up(1)',
                    IFINOCTETS       => '1460221696',
                    IFNUMBER         => '514',
                    IFDESCR          => 'ge-0/0/5',
                    IFOUTOCTETS      => '2680801766',
                    IFLASTCHANGE     => '(1520147727) 175 days, 22:37:57.27',
                    IFMTU            => '1514'
                },
                {
                    IFINERRORS       => '0',
                    IFSPEED          => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0',
                    IFOUTOCTETS      => '7636',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(1520147727) 175 days, 22:37:57.27',
                    IFNUMBER         => '515',
                    IFDESCR          => 'ge-0/0/5.0',
                    IFSTATUS         => 'up(1)',
                    IFINOCTETS       => '24573648',
                    IFTYPE           => 'propVirtual(53)'
                },
                {
                    IFDESCR          => 'ge-0/0/6',
                    IFNUMBER         => '516',
                    IFLASTCHANGE     => '(1519144687) 175 days, 19:50:46.87',
                    IFMTU            => '1514',
                    IFOUTOCTETS      => '2280812113',
                    IFTYPE           => 'ethernetCsmacd(6)',
                    IFINOCTETS       => '1204472549',
                    IFSTATUS         => 'up(1)',
                    IFSPEED          => '1000000000',
                    IFINERRORS       => '0',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)'
                },
                {
                    IFNUMBER         => '517',
                    IFDESCR          => 'ge-0/0/6.0',
                    IFOUTOCTETS      => '4784',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(1519144687) 175 days, 19:50:46.87',
                    IFTYPE           => 'propVirtual(53)',
                    IFSTATUS         => 'up(1)',
                    IFINOCTETS       => '25579766',
                    IFSPEED          => '0',
                    IFINERRORS       => '0',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)'
                },
                {
                    IFSPEED          => '1000000000',
                    IFINERRORS       => '0',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFNUMBER         => '518',
                    IFDESCR          => 'ge-0/0/7',
                    IFOUTOCTETS      => '538',
                    IFLASTCHANGE     => '(276784128) 32 days, 0:50:41.28',
                    IFMTU            => '1514',
                    IFTYPE           => 'ethernetCsmacd(6)',
                    IFSTATUS         => 'down(2)',
                    IFINOCTETS       => '1884'
                },
                {
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFSPEED          => '0',
                    IFINERRORS       => '0',
                    IFTYPE           => 'propVirtual(53)',
                    IFINOCTETS       => '826',
                    IFSTATUS         => 'lowerLayerDown(7)',
                    IFDESCR          => 'ge-0/0/7.0',
                    IFNUMBER         => '519',
                    IFLASTCHANGE     => '(276784128) 32 days, 0:50:41.28',
                    IFMTU            => '1514',
                    IFOUTOCTETS      => '92'
                },
                {
                    IFTYPE           => 'ethernetCsmacd(6)',
                    IFINOCTETS       => '1293235433',
                    IFSTATUS         => 'up(1)',
                    IFDESCR          => 'ge-0/0/8',
                    IFNUMBER         => '520',
                    IFLASTCHANGE     => '(1519114587) 175 days, 19:45:45.87',
                    IFMTU            => '1514',
                    IFOUTOCTETS      => '2255802556',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFSPEED          => '1000000000',
                    IFINERRORS       => '0'
                },
                {
                    IFOUTOCTETS      => '576',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(276799604) 32 days, 0:53:16.04',
                    IFNUMBER         => '521',
                    IFDESCR          => 'ge-0/0/9',
                    IFSTATUS         => 'down(2)',
                    IFINOCTETS       => '1998',
                    IFTYPE           => 'ethernetCsmacd(6)',
                    IFINERRORS       => '0',
                    IFSPEED          => '1000000000',
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0'
                },
                {
                    IFSPEED          => '0',
                    IFINERRORS       => '0',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFNUMBER         => '522',
                    IFDESCR          => 'ge-0/0/10',
                    IFOUTOCTETS      => '0',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(1507) 0:00:15.07',
                    IFTYPE           => 'ethernetCsmacd(6)',
                    IFSTATUS         => 'down(2)',
                    IFINOCTETS       => '0'
                },
                {
                    IFSTATUS         => 'up(1)',
                    IFINOCTETS       => '31177451',
                    IFTYPE           => 'propVirtual(53)',
                    IFOUTOCTETS      => '6532',
                    IFLASTCHANGE     => '(1519114587) 175 days, 19:45:45.87',
                    IFMTU            => '1514',
                    IFNUMBER         => '523',
                    IFDESCR          => 'ge-0/0/8.0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0',
                    IFINERRORS       => '0',
                    IFSPEED          => '0'
                },
                {
                    IFSTATUS         => 'down(2)',
                    IFINOCTETS       => '0',
                    IFTYPE           => 'ethernetCsmacd(6)',
                    IFOUTOCTETS      => '0',
                    IFLASTCHANGE     => '(1512) 0:00:15.12',
                    IFMTU            => '1514',
                    IFNUMBER         => '524',
                    IFDESCR          => 'ge-0/0/11',
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0',
                    IFINERRORS       => '0',
                    IFSPEED          => '0'
                },
                {
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFSPEED          => '0',
                    IFINERRORS       => '0',
                    IFTYPE           => 'propVirtual(53)',
                    IFSTATUS         => 'lowerLayerDown(7)',
                    IFINOCTETS       => '1420',
                    IFNUMBER         => '525',
                    IFDESCR          => 'ge-0/0/9.0',
                    IFOUTOCTETS      => '92',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(276799604) 32 days, 0:53:16.04'
                },
                {
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFSPEED          => '0',
                    IFINERRORS       => '0',
                    IFTYPE           => 'propVirtual(53)',
                    IFINOCTETS       => '0',
                    IFSTATUS         => 'lowerLayerDown(7)',
                    IFDESCR          => 'ge-0/0/10.0',
                    IFNUMBER         => '526',
                    IFLASTCHANGE     => '(1541) 0:00:15.41',
                    IFMTU            => '1514',
                    IFOUTOCTETS      => '0'
                },
                {
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0',
                    IFINERRORS       => '0',
                    IFSPEED          => '0',
                    IFSTATUS         => 'lowerLayerDown(7)',
                    IFINOCTETS       => '0',
                    IFTYPE           => 'propVirtual(53)',
                    IFOUTOCTETS      => '0',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(1554) 0:00:15.54',
                    IFNUMBER         => '527',
                    IFDESCR          => 'ge-0/0/11.0'
                },
                {
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0',
                    IFINERRORS       => '0',
                    IFSPEED          => '0',
                    IFINOCTETS       => '0',
                    IFSTATUS         => 'down(2)',
                    IFTYPE           => 'ethernetCsmacd(6)',
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(1550) 0:00:15.50',
                    IFOUTOCTETS      => '0',
                    IFDESCR          => 'ge-0/1/0',
                    IFNUMBER         => '528'
                },
                {
                    IFMTU            => '1514',
                    IFLASTCHANGE     => '(1572) 0:00:15.72',
                    IFOUTOCTETS      => '0',
                    IFDESCR          => 'ge-0/1/0.0',
                    IFNUMBER         => '529',
                    IFINOCTETS       => '0',
                    IFSTATUS         => 'lowerLayerDown(7)',
                    IFTYPE           => 'propVirtual(53)',
                    IFINERRORS       => '0',
                    IFSPEED          => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFOUTERRORS      => '0'
                },
                {
                    IFDESCR          => 'ge-0/1/1',
                    IFNUMBER         => '530',
                    IFLASTCHANGE     => '(28667) 0:04:46.67',
                    IFMTU            => '1514',
                    IFOUTOCTETS      => '3165078235',
                    IFTYPE           => 'ethernetCsmacd(6)',
                    IFINOCTETS       => '3750278254',
                    IFSTATUS         => 'up(1)',
                    IFSPEED          => '1000000000',
                    IFINERRORS       => '0',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)'
                },
                {
                    IFNUMBER         => '531',
                    IFDESCR          => 'ge-0/1/1.0',
                    IFOUTOCTETS      => '361557089',
                    IFLASTCHANGE     => '(28667) 0:04:46.67',
                    IFMTU            => '1514',
                    IFTYPE           => 'propVirtual(53)',
                    IFSTATUS         => 'up(1)',
                    IFINOCTETS       => '2510254288',
                    IFSPEED          => '0',
                    IFINERRORS       => '0',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)'
                },
                {
                    IFSPEED          => '1000000000',
                    IFINERRORS       => '0',
                    IFOUTERRORS      => '0',
                    IFINTERNALSTATUS => 'up(1)',
                    IFNUMBER         => '532',
                    IFDESCR          => 'vlan.0',
                    IFOUTOCTETS      => '315971005',
                    IFMTU            => '1500',
                    IFLASTCHANGE     => '(28671) 0:04:46.71',
                    IFTYPE           => 'propVirtual(53)',
                    IFSTATUS         => 'up(1)',
                    IFINOCTETS       => '1895694825'
                }
                ]
            }
        }
    ],
    'juniper/ex2200.6.walk' => [
        {
            MANUFACTURER => 'Juniper',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Juniper Networks, Inc. ex2200-48t-4g internet router, kernel JUNOS 11.4R5.5 #0: 2012-08-25 05:21:13 UTC     builder@evenath.juniper.net:/volume/build/junos/11.4/release/11.4R5.5/obj-arm/bsd/kernels/JUNIPER-EX-2200/kernel Build date: 2012-08-25 04:48:47 U',
            SNMPHOSTNAME => 'jtc407-01',
            MAC          => undef
        },
        {
            MANUFACTURER => 'Juniper',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Juniper Networks, Inc. ex2200-48t-4g internet router, kernel JUNOS 11.4R5.5 #0: 2012-08-25 05:21:13 UTC     builder@evenath.juniper.net:/volume/build/junos/11.4/release/11.4R5.5/obj-arm/bsd/kernels/JUNIPER-EX-2200/kernel Build date: 2012-08-25 04:48:47 U',
            SNMPHOSTNAME => 'jtc407-01',
            MAC          => '78:FE:3D:36:F7:00',
            MODELSNMP    => 'Networking2495',
            MODEL        => undef,
            SERIAL       => undef,
            FIRMWARE     => undef,
        },
        {
            INFO => {
                MANUFACTURER => 'Juniper',
                TYPE         => 'NETWORKING',
                COMMENTS     => 'Juniper Networks, Inc. ex2200-48t-4g internet router, kernel JUNOS 11.4R5.5 #0: 2012-08-25 05:21:13 UTC     builder@evenath.juniper.net:/volume/build/junos/11.4/release/11.4R5.5/obj-arm/bsd/kernels/JUNIPER-EX-2200/kernel Build date: 2012-08-25 04:48:47 U',
                UPTIME       => '(690835636) 79 days, 22:59:16.36',
                MODEL        => undef,
                ID           => undef,
                NAME         => 'jtc407-01',
                MAC          => '78:FE:3D:36:F7:00'
            },
            PORTS => {
                PORT => [
                {
                    IFNUMBER         => '4',
                    IFDESCR          => 'lsi',
                    IFSPEED          => '0',
                    IFMTU            => '1496',
                    IFTYPE           => '150',
                    IFNAME           => 'lsi'
                },
                {
                    IFTYPE           => '1',
                    IFNAME           => 'dsc',
                    IFMTU            => '2147483647',
                    IFNUMBER         => '5',
                    IFSPEED          => '0',
                    IFDESCR          => 'dsc'
                },
                {
                    IFSPEED          => '0',
                    IFDESCR          => 'lo0',
                    IFNUMBER         => '6',
                    IFMTU            => '2147483647',
                    IFNAME           => 'lo0',
                    IFTYPE           => '24'
                },
                {
                    IFSPEED          => '0',
                    IFDESCR          => 'tap',
                    IFNUMBER         => '7',
                    IFMTU            => '2147483647',
                    IFNAME           => 'tap',
                    IFTYPE           => '1'
                },
                {
                    IFNUMBER         => '8',
                    IFDESCR          => 'gre',
                    IFMTU            => '2147483647',
                    IFTYPE           => '131',
                    IFNAME           => 'gre'
                },
                {
                    IFMTU            => '2147483647',
                    IFDESCR          => 'ipip',
                    IFNUMBER         => '9',
                    IFNAME           => 'ipip',
                    IFTYPE           => '131'
                },
                {
                    IFNUMBER         => '10',
                    IFDESCR          => 'pime',
                    IFMTU            => '2147483647',
                    IFTYPE           => '131',
                    IFNAME           => 'pime'
                },
                {
                    IFTYPE           => '131',
                    IFNAME           => 'pimd',
                    IFNUMBER         => '11',
                    IFDESCR          => 'pimd',
                    IFMTU            => '2147483647'
                },
                {
                    IFTYPE           => '131',
                    IFNAME           => 'mtun',
                    IFNUMBER         => '12',
                    IFDESCR          => 'mtun',
                    IFMTU            => '2147483647'
                },
                {
                    IFMTU            => '1514',
                    IFDESCR          => 'me0',
                    IFNUMBER         => '33',
                    IFNAME           => 'me0',
                    IFTYPE           => '6'
                },
                {
                    IFTYPE           => '6',
                    IFNAME           => 'bme0',
                    IFNUMBER         => '37',
                    IFDESCR          => 'bme0',
                    IFMTU            => '1576'
                },
                {
                    IFNAME           => 'bme0.32768',
                    IFTYPE           => '53',
                    IFMTU            => '1562',
                    IFDESCR          => 'bme0.32768',
                    IFNUMBER         => '38'
                },
                {
                    IFDESCR          => 'ge-0/0/0',
                    IFNUMBER         => '501',
                    IFMTU            => '1514',
                    IFNAME           => 'ge-0/0/0',
                    IFTYPE           => '6'
                },
                {
                    IFNUMBER         => '502',
                    IFDESCR          => 'ge-0/0/46.0',
                    IFMTU            => '1514',
                    IFTYPE           => '53',
                    IFNAME           => 'ge-0/0/46.0'
                },
                {
                    IFTYPE           => '6',
                    IFNAME           => 'ge-0/0/1',
                    IFMTU            => '1514',
                    IFNUMBER         => '503',
                    IFDESCR          => 'ge-0/0/1'
                },
                {
                    IFMTU            => '1514',
                    IFNUMBER         => '504',
                    IFDESCR          => 'ge-0/0/1.0',
                    IFTYPE           => '53',
                    IFNAME           => 'ge-0/0/1.0'
                },
                {
                    IFMTU            => '1514',
                    IFDESCR          => 'ge-0/0/10',
                    IFNUMBER         => '505',
                    IFNAME           => 'ge-0/0/10',
                    IFTYPE           => '6'
                },
                {
                    IFMTU            => '1514',
                    IFNUMBER         => '506',
                    IFDESCR          => 'ge-0/0/10.0',
                    IFTYPE           => '53',
                    IFNAME           => 'ge-0/0/10.0'
                },
                {
                    IFMTU            => '1514',
                    IFDESCR          => 'ge-0/0/11',
                    IFNUMBER         => '507',
                    IFNAME           => 'ge-0/0/11',
                    IFTYPE           => '6'
                },
                {
                    IFTYPE           => '53',
                    IFNAME           => 'ge-0/0/11.0',
                    IFNUMBER         => '508',
                    IFDESCR          => 'ge-0/0/11.0',
                    IFMTU            => '1514'
                },
                {
                    IFNAME           => 'ge-0/0/12',
                    IFTYPE           => '6',
                    IFDESCR          => 'ge-0/0/12',
                    IFNUMBER         => '509',
                    IFMTU            => '1514'
                },
                {
                    IFMTU            => '1514',
                    IFDESCR          => 'ge-0/0/12.0',
                    IFNUMBER         => '510',
                    IFNAME           => 'ge-0/0/12.0',
                    IFTYPE           => '53'
                },
                {
                    IFDESCR          => 'ge-0/0/13',
                    IFNUMBER         => '511',
                    IFMTU            => '1514',
                    IFNAME           => 'ge-0/0/13',
                    IFTYPE           => '6'
                },
                {
                    IFNUMBER         => '512',
                    IFDESCR          => 'ge-0/0/13.0',
                    IFMTU            => '1514',
                    IFTYPE           => '53',
                    IFNAME           => 'ge-0/0/13.0'
                },
                {
                    IFNUMBER         => '513',
                    IFDESCR          => 'ge-0/0/14',
                    IFMTU            => '1514',
                    IFTYPE           => '6',
                    IFNAME           => 'ge-0/0/14'
                },
                {
                    IFNAME           => 'ge-0/0/14.0',
                    IFTYPE           => '53',
                    IFDESCR          => 'ge-0/0/14.0',
                    IFNUMBER         => '514',
                    IFMTU            => '1514'
                },
                {
                    IFDESCR          => 'ge-0/0/15',
                    IFNUMBER         => '515',
                    IFMTU            => '1514',
                    IFNAME           => 'ge-0/0/15',
                    IFTYPE           => '6'
                },
                {
                    IFNAME           => 'ge-0/0/15.0',
                    IFTYPE           => '53',
                    IFMTU            => '1514',
                    IFDESCR          => 'ge-0/0/15.0',
                    IFNUMBER         => '516'
                },
                {
                    IFNUMBER         => '517',
                    IFDESCR          => 'ge-0/0/16',
                    IFMTU            => '1514',
                    IFTYPE           => '6',
                    IFNAME           => 'ge-0/0/16'
                },
                {
                    IFNAME           => 'ge-0/0/16.0',
                    IFTYPE           => '53',
                    IFMTU            => '1514',
                    IFDESCR          => 'ge-0/0/16.0',
                    IFNUMBER         => '518'
                },
                {
                    IFDESCR          => 'ge-0/0/17',
                    IFNUMBER         => '519',
                    IFMTU            => '1514',
                    IFNAME           => 'ge-0/0/17',
                    IFTYPE           => '6'
                },
                {
                    IFNUMBER         => '520',
                    IFDESCR          => 'ge-0/0/17.0',
                    IFMTU            => '1514',
                    IFTYPE           => '53',
                    IFNAME           => 'ge-0/0/17.0'
                },
                {
                    IFMTU            => '1514',
                    IFDESCR          => 'ge-0/0/18',
                    IFNUMBER         => '521',
                    IFNAME           => 'ge-0/0/18',
                    IFTYPE           => '6'
                },
                {
                    IFTYPE           => '53',
                    IFNAME           => 'ge-0/0/18.0',
                    IFNUMBER         => '522',
                    IFDESCR          => 'ge-0/0/18.0',
                    IFMTU            => '1514'
                },
                {
                    IFTYPE           => '6',
                    IFNAME           => 'ge-0/0/19',
                    IFNUMBER         => '523',
                    IFDESCR          => 'ge-0/0/19',
                    IFMTU            => '1514'
                },
                {
                    IFDESCR          => 'ge-0/0/19.0',
                    IFNUMBER         => '524',
                    IFMTU            => '1514',
                    IFNAME           => 'ge-0/0/19.0',
                    IFTYPE           => '53'
                },
                {
                    IFTYPE           => '6',
                    IFNAME           => 'ge-0/0/2',
                    IFMTU            => '1514',
                    IFNUMBER         => '525',
                    IFDESCR          => 'ge-0/0/2'
                },
                {
                    IFTYPE           => '53',
                    IFNAME           => 'ge-0/0/2.0',
                    IFMTU            => '1514',
                    IFNUMBER         => '526',
                    IFDESCR          => 'ge-0/0/2.0'
                },
                {
                    IFDESCR          => 'ge-0/0/20',
                    IFNUMBER         => '527',
                    IFMTU            => '1514',
                    IFNAME           => 'ge-0/0/20',
                    IFTYPE           => '6'
                },
                {
                    IFMTU            => '1514',
                    IFDESCR          => 'ge-0/0/20.0',
                    IFNUMBER         => '528',
                    IFNAME           => 'ge-0/0/20.0',
                    IFTYPE           => '53'
                },
                {
                    IFDESCR          => 'ge-0/0/21',
                    IFNUMBER         => '529',
                    IFMTU            => '1514',
                    IFNAME           => 'ge-0/0/21',
                    IFTYPE           => '6'
                },
                {
                    IFDESCR          => 'ge-0/0/21.0',
                    IFNUMBER         => '530',
                    IFMTU            => '1514',
                    IFNAME           => 'ge-0/0/21.0',
                    IFTYPE           => '53'
                },
                {
                    IFNAME           => 'ge-0/0/22',
                    IFTYPE           => '6',
                    IFMTU            => '1514',
                    IFDESCR          => 'ge-0/0/22',
                    IFNUMBER         => '531'
                },
                {
                    IFTYPE           => '53',
                    IFNAME           => 'ge-0/0/22.0',
                    IFNUMBER         => '532',
                    IFDESCR          => 'ge-0/0/22.0',
                    IFMTU            => '1514'
                },
                {
                    IFMTU            => '1514',
                    IFNUMBER         => '533',
                    IFDESCR          => 'ge-0/0/23',
                    IFTYPE           => '6',
                    IFNAME           => 'ge-0/0/23'
                },
                {
                    IFTYPE           => '53',
                    IFNAME           => 'ge-0/0/23.0',
                    IFNUMBER         => '534',
                    IFDESCR          => 'ge-0/0/23.0',
                    IFMTU            => '1514'
                },
                {
                    IFDESCR          => 'ge-0/0/24',
                    IFNUMBER         => '535',
                    IFMTU            => '1514',
                    IFNAME           => 'ge-0/0/24',
                    IFTYPE           => '6'
                },
                {
                    IFTYPE           => '53',
                    IFNAME           => 'ge-0/0/24.0',
                    IFNUMBER         => '536',
                    IFDESCR          => 'ge-0/0/24.0',
                    IFMTU            => '1514'
                },
                {
                    IFTYPE           => '6',
                    IFNAME           => 'ge-0/0/25',
                    IFNUMBER         => '537',
                    IFDESCR          => 'ge-0/0/25',
                    IFMTU            => '1514'
                },
                {
                    IFNAME           => 'ge-0/0/25.0',
                    IFTYPE           => '53',
                    IFMTU            => '1514',
                    IFDESCR          => 'ge-0/0/25.0',
                    IFNUMBER         => '538'
                },
                {
                    IFNUMBER         => '539',
                    IFDESCR          => 'ge-0/0/26',
                    IFMTU            => '1514',
                    IFTYPE           => '6',
                    IFNAME           => 'ge-0/0/26'
                },
                {
                    IFDESCR          => 'ge-0/0/26.0',
                    IFNUMBER         => '540',
                    IFMTU            => '1514',
                    IFNAME           => 'ge-0/0/26.0',
                    IFTYPE           => '53'
                },
                {
                    IFTYPE           => '6',
                    IFNAME           => 'ge-0/0/27',
                    IFNUMBER         => '541',
                    IFDESCR          => 'ge-0/0/27',
                    IFMTU            => '1514'
                },
                {
                    IFNUMBER         => '542',
                    IFDESCR          => 'ge-0/0/27.0',
                    IFMTU            => '1514',
                    IFTYPE           => '53',
                    IFNAME           => 'ge-0/0/27.0'
                },
                {
                    IFNUMBER         => '543',
                    IFDESCR          => 'ge-0/0/28',
                    IFMTU            => '1514',
                    IFTYPE           => '6',
                    IFNAME           => 'ge-0/0/28'
                },
                {
                    IFDESCR          => 'ge-0/0/28.0',
                    IFNUMBER         => '544',
                    IFMTU            => '1514',
                    IFNAME           => 'ge-0/0/28.0',
                    IFTYPE           => '53'
                },
                {
                    IFTYPE           => '6',
                    IFNAME           => 'ge-0/0/29',
                    IFNUMBER         => '545',
                    IFDESCR          => 'ge-0/0/29',
                    IFMTU            => '1514'
                },
                {
                    IFMTU            => '1514',
                    IFDESCR          => 'ge-0/0/29.0',
                    IFNUMBER         => '546',
                    IFNAME           => 'ge-0/0/29.0',
                    IFTYPE           => '53'
                },
                {
                    IFMTU            => '1514',
                    IFNUMBER         => '547',
                    IFDESCR          => 'ge-0/0/3',
                    IFTYPE           => '6',
                    IFNAME           => 'ge-0/0/3'
                },
                {
                    IFTYPE           => '53',
                    IFNAME           => 'ge-0/0/3.0',
                    IFMTU            => '1514',
                    IFNUMBER         => '548',
                    IFDESCR          => 'ge-0/0/3.0'
                },
                {
                    IFNAME           => 'ge-0/0/30',
                    IFTYPE           => '6',
                    IFDESCR          => 'ge-0/0/30',
                    IFNUMBER         => '549',
                    IFMTU            => '1514'
                },
                {
                    IFTYPE           => '53',
                    IFNAME           => 'ge-0/0/30.0',
                    IFMTU            => '1514',
                    IFNUMBER         => '550',
                    IFDESCR          => 'ge-0/0/30.0'
                },
                {
                    IFDESCR          => 'ge-0/0/31',
                    IFNUMBER         => '551',
                    IFMTU            => '1514',
                    IFNAME           => 'ge-0/0/31',
                    IFTYPE           => '6'
                },
                {
                    IFDESCR          => 'ge-0/0/31.0',
                    IFNUMBER         => '552',
                    IFMTU            => '1514',
                    IFNAME           => 'ge-0/0/31.0',
                    IFTYPE           => '53'
                },
                {
                    IFNAME           => 'ge-0/0/32',
                    IFTYPE           => '6',
                    IFDESCR          => 'ge-0/0/32',
                    IFNUMBER         => '553',
                    IFMTU            => '1514'
                },
                {
                    IFNAME           => 'ge-0/0/32.0',
                    IFTYPE           => '53',
                    IFMTU            => '1514',
                    IFDESCR          => 'ge-0/0/32.0',
                    IFNUMBER         => '554'
                },
                {
                    IFTYPE           => '6',
                    IFNAME           => 'ge-0/0/33',
                    IFNUMBER         => '555',
                    IFDESCR          => 'ge-0/0/33',
                    IFMTU            => '1514'
                },
                {
                    IFMTU            => '1514',
                    IFDESCR          => 'ge-0/0/33.0',
                    IFNUMBER         => '556',
                    IFNAME           => 'ge-0/0/33.0',
                    IFTYPE           => '53'
                },
                {
                    IFMTU            => '1514',
                    IFDESCR          => 'ge-0/0/34',
                    IFNUMBER         => '557',
                    IFNAME           => 'ge-0/0/34',
                    IFTYPE           => '6'
                },
                {
                    IFTYPE           => '53',
                    IFNAME           => 'ge-0/0/34.0',
                    IFMTU            => '1514',
                    IFNUMBER         => '558',
                    IFDESCR          => 'ge-0/0/34.0'
                },
                {
                    IFMTU            => '1514',
                    IFNUMBER         => '559',
                    IFDESCR          => 'ge-0/0/35',
                    IFTYPE           => '6',
                    IFNAME           => 'ge-0/0/35'
                },
                {
                    IFTYPE           => '53',
                    IFNAME           => 'ge-0/0/35.0',
                    IFNUMBER         => '560',
                    IFDESCR          => 'ge-0/0/35.0',
                    IFMTU            => '1514'
                },
                {
                    IFMTU            => '1514',
                    IFDESCR          => 'ge-0/0/36',
                    IFNUMBER         => '561',
                    IFNAME           => 'ge-0/0/36',
                    IFTYPE           => '6'
                },
                {
                    IFTYPE           => '53',
                    IFNAME           => 'ge-0/0/36.0',
                    IFMTU            => '1514',
                    IFNUMBER         => '562',
                    IFDESCR          => 'ge-0/0/36.0'
                },
                {
                    IFTYPE           => '6',
                    IFNAME           => 'ge-0/0/37',
                    IFMTU            => '1514',
                    IFNUMBER         => '563',
                    IFDESCR          => 'ge-0/0/37'
                },
                {
                    IFNAME           => 'ge-0/0/37.0',
                    IFTYPE           => '53',
                    IFDESCR          => 'ge-0/0/37.0',
                    IFNUMBER         => '564',
                    IFMTU            => '1514'
                },
                {
                    IFDESCR          => 'ge-0/0/38',
                    IFNUMBER         => '565',
                    IFMTU            => '1514',
                    IFNAME           => 'ge-0/0/38',
                    IFTYPE           => '6'
                },
                {
                    IFMTU            => '1514',
                    IFNUMBER         => '566',
                    IFDESCR          => 'ge-0/0/38.0',
                    IFTYPE           => '53',
                    IFNAME           => 'ge-0/0/38.0'
                },
                {
                    IFTYPE           => '6',
                    IFNAME           => 'ge-0/0/39',
                    IFNUMBER         => '567',
                    IFDESCR          => 'ge-0/0/39',
                    IFMTU            => '1514'
                },
                {
                    IFMTU            => '1514',
                    IFNUMBER         => '568',
                    IFDESCR          => 'ge-0/0/39.0',
                    IFTYPE           => '53',
                    IFNAME           => 'ge-0/0/39.0'
                },
                {
                    IFMTU            => '1514',
                    IFNUMBER         => '569',
                    IFDESCR          => 'ge-0/0/4',
                    IFTYPE           => '6',
                    IFNAME           => 'ge-0/0/4'
                },
                {
                    IFDESCR          => 'ge-0/0/4.0',
                    IFNUMBER         => '570',
                    IFMTU            => '1514',
                    IFNAME           => 'ge-0/0/4.0',
                    IFTYPE           => '53'
                },
                {
                    IFNUMBER         => '571',
                    IFDESCR          => 'ge-0/0/40',
                    IFMTU            => '1514',
                    IFTYPE           => '6',
                    IFNAME           => 'ge-0/0/40'
                },
                {
                    IFNAME           => 'ge-0/0/40.0',
                    IFTYPE           => '53',
                    IFMTU            => '1514',
                    IFDESCR          => 'ge-0/0/40.0',
                    IFNUMBER         => '572'
                },
                {
                    IFTYPE           => '6',
                    IFNAME           => 'ge-0/0/41',
                    IFNUMBER         => '573',
                    IFDESCR          => 'ge-0/0/41',
                    IFMTU            => '1514'
                },
                {
                    IFNUMBER         => '574',
                    IFDESCR          => 'ge-0/0/41.0',
                    IFMTU            => '1514',
                    IFTYPE           => '53',
                    IFNAME           => 'ge-0/0/41.0'
                },
                {
                    IFTYPE           => '6',
                    IFNAME           => 'ge-0/0/42',
                    IFNUMBER         => '575',
                    IFDESCR          => 'ge-0/0/42',
                    IFMTU            => '1514'
                },
                {
                    IFNAME           => 'ge-0/0/42.0',
                    IFTYPE           => '53',
                    IFMTU            => '1514',
                    IFDESCR          => 'ge-0/0/42.0',
                    IFNUMBER         => '576'
                },
                {
                    IFNUMBER         => '577',
                    IFDESCR          => 'ge-0/0/43',
                    IFMTU            => '1514',
                    IFTYPE           => '6',
                    IFNAME           => 'ge-0/0/43'
                },
                {
                    IFNAME           => 'ge-0/0/43.0',
                    IFTYPE           => '53',
                    IFMTU            => '1514',
                    IFDESCR          => 'ge-0/0/43.0',
                    IFNUMBER         => '578'
                },
                {
                    IFNAME           => 'ge-0/0/44',
                    IFTYPE           => '6',
                    IFDESCR          => 'ge-0/0/44',
                    IFNUMBER         => '579',
                    IFMTU            => '1514'
                },
                {
                    CONNECTIONS => {
                        CDP => 1,
                        CONNECTION => {
                            IFDESCR  => 'eth0',
                            SYSMAC   => '00:1A:1E:CD:BB:02',
                            SYSNAME  => 'PMF-sap-c407',
                            IFNUMBER => '0x001A1ECDBB02',
                            SYSDESCR => 'ArubaOS (MODEL: 125), Version 6.2.1.2 (38711)'
                        }
                    },
                    IFMTU            => '1514',
                    IFDESCR          => 'ge-0/0/44.0',
                    IFNUMBER         => '580',
                    IFNAME           => 'ge-0/0/44.0',
                    IFTYPE           => '53'
                },
                {
                    IFNAME           => 'ge-0/0/45',
                    IFTYPE           => '6',
                    IFDESCR          => 'ge-0/0/45',
                    IFNUMBER         => '581',
                    IFMTU            => '1514'
                },
                {
                    IFNAME           => 'ge-0/0/45.0',
                    IFTYPE           => '53',
                    IFMTU            => '1514',
                    IFDESCR          => 'ge-0/0/45.0',
                    IFNUMBER         => '582'
                },
                {
                    IFNAME           => 'ge-0/0/46',
                    IFTYPE           => '6',
                    IFMTU            => '1514',
                    IFDESCR          => 'ge-0/0/46',
                    IFNUMBER         => '583'
                },
                {
                    IFTYPE           => '53',
                    IFNAME           => 'ge-0/0/47.0',
                    IFNUMBER         => '584',
                    IFDESCR          => 'ge-0/0/47.0',
                    IFMTU            => '1514'
                },
                {
                    IFNAME           => 'ge-0/0/47',
                    IFTYPE           => '6',
                    IFDESCR          => 'ge-0/0/47',
                    IFNUMBER         => '585',
                    IFMTU            => '1514'
                },
                {
                    IFTYPE           => '53',
                    IFNAME           => 'ge-0/0/0.0',
                    IFNUMBER         => '586',
                    IFDESCR          => 'ge-0/0/0.0',
                    IFMTU            => '1514'
                },
                {
                    IFMTU            => '1514',
                    IFDESCR          => 'ge-0/0/5',
                    IFNUMBER         => '587',
                    IFNAME           => 'ge-0/0/5',
                    IFTYPE           => '6'
                },
                {
                    IFDESCR          => 'ge-0/0/5.0',
                    IFNUMBER         => '588',
                    IFMTU            => '1514',
                    IFNAME           => 'ge-0/0/5.0',
                    IFTYPE           => '53'
                },
                {
                    IFTYPE           => '6',
                    IFNAME           => 'ge-0/0/6',
                    IFNUMBER         => '589',
                    IFDESCR          => 'ge-0/0/6',
                    IFMTU            => '1514'
                },
                {
                    IFMTU            => '1514',
                    IFDESCR          => 'ge-0/0/6.0',
                    IFNUMBER         => '590',
                    IFNAME           => 'ge-0/0/6.0',
                    IFTYPE           => '53'
                },
                {
                    IFNUMBER         => '591',
                    IFDESCR          => 'ge-0/0/7',
                    IFMTU            => '1514',
                    IFTYPE           => '6',
                    IFNAME           => 'ge-0/0/7'
                },
                {
                    IFMTU            => '1514',
                    IFDESCR          => 'ge-0/0/7.0',
                    IFNUMBER         => '592',
                    IFNAME           => 'ge-0/0/7.0',
                    IFTYPE           => '53'
                },
                {
                    IFNAME           => 'ge-0/0/8',
                    IFTYPE           => '6',
                    IFDESCR          => 'ge-0/0/8',
                    IFNUMBER         => '593',
                    IFMTU            => '1514'
                },
                {
                    IFTYPE           => '53',
                    IFNAME           => 'ge-0/0/8.0',
                    IFMTU            => '1514',
                    IFNUMBER         => '594',
                    IFDESCR          => 'ge-0/0/8.0'
                },
                {
                    IFDESCR          => 'ge-0/0/9',
                    IFNUMBER         => '595',
                    IFMTU            => '1514',
                    IFNAME           => 'ge-0/0/9',
                    IFTYPE           => '6'
                },
                {
                    IFNUMBER         => '596',
                    IFDESCR          => 'ge-0/0/9.0',
                    IFMTU            => '1514',
                    IFTYPE           => '53',
                    IFNAME           => 'ge-0/0/9.0'
                },
                {
                    IFMTU            => '1518',
                    IFNUMBER         => '599',
                    IFDESCR          => 'vlan',
                    IFTYPE           => '6',
                    IFNAME           => 'vlan'
                },
                {
                    IFMTU            => '1500',
                    IFDESCR          => 'vlan.0',
                    IFNUMBER         => '600',
                    IFNAME           => 'vlan.0',
                    IFTYPE           => '53'
                },
                {
                    IFTYPE           => '161',
                    IFNAME           => 'ae0',
                    IFNUMBER         => '609',
                    IFDESCR          => 'ae0',
                    IFMTU            => '1514'
                },
                {
                    IFTYPE           => '161',
                    IFNAME           => 'ae1',
                    IFMTU            => '1514',
                    IFNUMBER         => '610',
                    IFDESCR          => 'ae1'
                },
                {
                    IFDESCR          => 'ae2',
                    IFNUMBER         => '611',
                    IFMTU            => '1514',
                    IFNAME           => 'ae2',
                    IFTYPE           => '161'
                },
                {
                    IFNUMBER         => '612',
                    IFDESCR          => 'ae3',
                    IFMTU            => '1514',
                    IFTYPE           => '161',
                    IFNAME           => 'ae3'
                },
                {
                    IFTYPE           => '161',
                    IFNAME           => 'ae4',
                    IFMTU            => '1514',
                    IFNUMBER         => '613',
                    IFDESCR          => 'ae4'
                },
                {
                    IFMTU            => '1514',
                    IFDESCR          => 'ae0.0',
                    IFNUMBER         => '614',
                    IFNAME           => 'ae0.0',
                    IFTYPE           => '161'
                }
                ]
            },
        }
    ],
    'juniper/ex3200.walk' => [
        {
            MANUFACTURER => 'Juniper',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Juniper Networks, Inc. ex3200-48p internet router, kernel JUNOS 10.4R2.6 #0: 2011-02-06 23:48:13 UTC     builder@warth.juniper.net:/volume/build/junos/10.4/release/10.4R2.6/obj-powerpc/bsd/sys/compile/JUNIPER-EX Build date: 2011-02-06 23:17:05 UTC Copyri',
            SNMPHOSTNAME => 'jtc20-03',
            MAC          => '2C:6B:F5:9A:7E:80',
        },
        {
            MANUFACTURER => 'Juniper',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Juniper Networks, Inc. ex3200-48p internet router, kernel JUNOS 10.4R2.6 #0: 2011-02-06 23:48:13 UTC     builder@warth.juniper.net:/volume/build/junos/10.4/release/10.4R2.6/obj-powerpc/bsd/sys/compile/JUNIPER-EX Build date: 2011-02-06 23:17:05 UTC Copyri',
            SNMPHOSTNAME => 'jtc20-03',
            MAC          => '2C:6B:F5:9A:7E:80',
            MODELSNMP    => 'Networking2450',
            MODEL        => undef,
            FIRMWARE     => undef,
            SERIAL       => 'BL0210129540',
        },
        {
            INFO => {
                MANUFACTURER => 'Juniper',
                TYPE         => 'NETWORKING',
                COMMENTS     => 'Juniper Networks, Inc. ex3200-48p internet router, kernel JUNOS 10.4R2.6 #0: 2011-02-06 23:48:13 UTC     builder@warth.juniper.net:/volume/build/junos/10.4/release/10.4R2.6/obj-powerpc/bsd/sys/compile/JUNIPER-EX Build date: 2011-02-06 23:17:05 UTC Copyri',
                MEMORY       => 0,
                MAC          => '2C:6B:F5:9A:7E:80',
                NAME         => 'jtc20-03',
                SERIAL       => 'BL0210129540',
                FIRMWARE     => '10.4R2.6',
                UPTIME       => '(690611103) 79 days, 22:21:51.03',
                ID           => undef,
                RAM          => 0,
                LOCATION     => 'repartiteur PMF 20eme',
                MODEL        => 'Juniper Networks, Inc. ex3200-48p internet router, kernel JUNOS 10.4R2.6 #0: 2011-02-06 23:48:13 UTC     builder@warth.juniper.net:/volume/build/junos/10.4/release/10.4R2.6/obj-powerpc/bsd/sys/compile/JUNIPER-EX Build date: 2011-02-06 23:17:05 UTC Copyri',
                IPS          => {
                    IP => [
                        '128.0.0.1',
                        '128.0.0.127',
                        '128.0.0.16',
                        '128.0.0.32',
                        '192.168.100.44'
                    ]
                }
            },
            PORTS => {
                PORT => [
                    {
                        IFDESCR          => 'lsi',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '0',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFMTU            => '1496',
                        IFNAME           => 'lsi',
                        IFNUMBER         => '4',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '0',
                        IFSPEED          => '0',
                        IFSTATUS         => '1',
                        IFTYPE           => '150',
                    },
                    {
                        IFDESCR          => 'dsc',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '0',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFMTU            => '2147483647',
                        IFNAME           => 'dsc',
                        IFNUMBER         => '5',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '0',
                        IFSPEED          => '0',
                        IFSTATUS         => '1',
                        IFTYPE           => '1'
                    },
                    {
                        IFDESCR          => 'lo0',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '2161453172',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFMTU            => '2147483647',
                        IFNAME           => 'lo0',
                        IFNUMBER         => '6',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '2161453172',
                        IFSPEED          => '0',
                        IFSTATUS         => '1',
                        IFTYPE           => '24',
                    },
                    {
                        IFDESCR          => 'tap',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '0',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFMTU            => '2147483647',
                        IFNAME           => 'tap',
                        IFNUMBER         => '7',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '0',
                        IFSPEED          => '0',
                        IFSTATUS         => '1',
                        IFTYPE           => '1',
                    },
                    {
                        IFDESCR          => 'gre',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '0',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFMTU            => '2147483647',
                        IFNAME           => 'gre',
                        IFNUMBER         => '8',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '0',
                        IFSPEED          => '0',
                        IFSTATUS         => '1',
                        IFTYPE           => '131',
                    },
                    {
                        IFDESCR          => 'ipip',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '0',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFMTU            => '2147483647',
                        IFNAME           => 'ipip',
                        IFNUMBER         => '9',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '0',
                        IFSPEED          => '0',
                        IFSTATUS         => '1',
                        IFTYPE           => '131',
                    },
                    {
                        IFDESCR          => 'pime',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '0',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFMTU            => '2147483647',
                        IFNAME           => 'pime',
                        IFNUMBER         => '10',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '0',
                        IFSPEED          => '0',
                        IFSTATUS         => '1',
                        IFTYPE           => '131',
                    },
                    {
                        IFDESCR          => 'pimd',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '0',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFMTU            => '2147483647',
                        IFNAME           => 'pimd',
                        IFNUMBER         => '11',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '0',
                        IFSPEED          => '0',
                        IFSTATUS         => '1',
                        IFTYPE           => '131'
                    },
                    {
                        IFDESCR          => 'mtun',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '0',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFMTU            => '2147483647',
                        IFNAME           => 'mtun',
                        IFNUMBER         => '12',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '0',
                        IFSPEED          => '0',
                        IFSTATUS         => '1',
                        IFTYPE           => '131',
                    },
                    {
                        IFDESCR          => 'me0',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '0',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFMTU            => '1514',
                        IFNAME           => 'me0',
                        IFNUMBER         => '33',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '0',
                        IFSPEED          => '0',
                        IFSTATUS         => '2',
                        IFTYPE           => '6',
                        MAC              => '2C:6B:F5:9A:7E:FF'
                    },
                    {
                        IFDESCR          => 'me0.0',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '0',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFMTU            => '1500',
                        IFNAME           => 'me0.0',
                        IFNUMBER         => '34',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '0',
                        IFSPEED          => '0',
                        IFSTATUS         => '7',
                        IFTYPE           => '53',
                        MAC              => '2C:6B:F5:9A:7E:FF'
                    },
                    {
                        IFDESCR          => 'bme0',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '0',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFMTU            => '1576',
                        IFNAME           => 'bme0',
                        IFNUMBER         => '37',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '4291428678',
                        IFSPEED          => '0',
                        IFSTATUS         => '1',
                        IFTYPE           => '6',
                        MAC              => '00:0B:CA:FE:00:00'
                    },
                    {
                        IFDESCR          => 'bme0.32768',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '3718526292',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFMTU            => '1562',
                        IFNAME           => 'bme0.32768',
                        IFNUMBER         => '38',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '126',
                        IFSPEED          => '0',
                        IFSTATUS         => '1',
                        IFTYPE           => '53',
                        MAC              => '00:0B:CA:FE:00:00'
                    },
                    {
                        IFDESCR          => 'ge-0/0/0',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '2034641916',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(494) 0:00:04.94',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/0',
                        IFNUMBER         => '501',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '3894747062',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '100000000',
                        IFSTATUS         => '1',
                        IFTYPE           => '6',
                        MAC              => '2C:6B:F5:9A:7E:80'
                    },
                    {
                        CONNECTIONS => {
                            CONNECTION => {
                                MAC => [
                                    '00:01:30:12:91:80',
                                    '00:01:30:12:A6:C0',
                                    '00:01:30:12:A6:D0',
                                    '00:01:30:12:A8:30',
                                    '00:01:30:FD:05:F0',
                                    '00:0B:60:B0:B0:1B',
                                    '00:0F:34:AA:EE:1B',
                                    '00:10:DB:FF:10:02',
                                    '00:02:B3:31:FA:F9',
                                    '00:E0:86:11:1A:27',
                                    '00:E0:86:11:1D:B0',
                                    '00:E0:86:12:D9:6F',
                                    '00:1B:EC:00:04:09',
                                    '00:1D:09:68:40:C8',
                                    '00:1E:C9:DA:3B:FC',
                                    '00:1E:C9:F2:C0:81',
                                    '00:1E:C9:F2:CA:8D',
                                    '00:1E:4F:1F:3C:44',
                                    '00:1E:4F:1F:57:4B',
                                    '00:1E:4F:31:A9:A0',
                                    '00:1E:4F:31:AB:88',
                                    '00:1E:4F:31:AB:AB',
                                    '00:1E:4F:32:E1:D3',
                                    '00:1E:4F:32:E4:69',
                                    '00:1E:4F:32:F7:9E',
                                    '00:1E:4F:33:14:D1',
                                    '00:1E:4F:33:07:E1',
                                    '00:1E:4F:41:D0:A4',
                                    '00:1E:4F:41:D8:69',
                                    '00:1E:4F:41:DC:7E',
                                    '00:1E:4F:41:DD:53',
                                    '00:1E:4F:41:E2:8C',
                                    '00:1E:4F:08:E5:CA',
                                    '00:1E:4F:08:E6:62',
                                    '00:20:4A:0B:24:06',
                                    '00:20:4A:B1:3D:DA',
                                    '00:20:4A:08:72:D2',
                                    '00:20:4A:08:73:01',
                                    '00:20:4A:08:AC:F6',
                                    '00:20:4A:08:AC:56',
                                    '00:20:4A:08:E1:6D',
                                    '00:20:4A:08:60:C6',
                                    '00:22:19:7B:BE:11',
                                    '00:22:19:7B:BE:DA',
                                    '00:22:19:7B:BF:E6',
                                    '00:22:19:85:D9:70',
                                    '00:22:19:63:0F:55',
                                    '00:23:AE:FB:FD:89',
                                    '00:23:AE:FB:FD:B0',
                                    '00:23:AE:FC:00:CD',
                                    '00:23:AE:FC:00:D3',
                                    '00:23:AE:FC:00:D8',
                                    '00:23:AE:FE:9C:E0',
                                    '00:23:AE:FE:A9:E0',
                                    '00:04:96:18:6E:93',
                                    '00:04:96:18:5B:61',
                                    '00:04:96:1C:6F:F0',
                                    '00:04:96:1C:71:00',
                                    '00:04:96:1F:8F:0F',
                                    '00:04:96:1F:91:50',
                                    '00:04:96:27:93:F9',
                                    '00:04:96:34:69:AB',
                                    '00:04:96:34:69:B1',
                                    '00:04:96:34:89:5C',
                                    '00:04:96:34:8B:82',
                                    '00:04:96:34:8B:F8',
                                    '00:04:96:34:8C:10',
                                    '00:04:96:34:8C:11',
                                    '00:04:96:34:92:82',
                                    '00:04:96:34:92:31',
                                    '00:04:96:34:92:47',
                                    '00:04:96:34:AF:AE',
                                    '00:04:96:35:77:14',
                                    '00:04:96:35:77:16',
                                    '00:04:96:35:90:67',
                                    '00:04:96:35:90:4D',
                                    '00:04:96:35:93:B9',
                                    '00:04:96:35:AD:E4',
                                    '00:04:96:35:C8:14',
                                    '00:04:96:35:C8:1F',
                                    '00:04:96:35:FA:AE',
                                    '00:04:96:35:FA:B1',
                                    '00:04:96:08:1E:70',
                                    '00:05:1E:08:F8:20',
                                    '00:05:1E:08:F9:12',
                                    '00:05:1E:09:21:2D',
                                    '00:05:1E:09:21:50',
                                    '00:05:33:F4:D9:DF',
                                    '00:05:33:43:78:2D',
                                    '00:05:33:54:16:AA',
                                    '00:50:56:BC:31:8A',
                                    '00:50:56:50:30:A0',
                                    '00:50:56:50:30:A2',
                                    '00:50:56:50:38:30',
                                    '00:50:56:50:38:32',
                                    '00:60:16:1E:64:79',
                                    '00:60:16:1E:68:23',
                                    '00:60:16:1E:56:F6',
                                    '00:60:16:1E:57:3D',
                                    '64:87:88:B7:A5:C1',
                                    '64:87:88:B7:B6:41',
                                    '64:B9:E8:C0:B7:04',
                                    '78:FE:3D:3F:84:00',
                                    '78:FE:3D:45:28:01',
                                    '84:18:88:A6:06:33',
                                    '84:2B:2B:71:30:F3',
                                    '10:8C:CF:CB:85:5D',
                                    '10:8C:CF:CB:BC:71',
                                    'AC:4B:C8:22:B8:41',
                                    'AC:4B:C8:23:1D:81',
                                    'AC:4B:C8:23:4D:81',
                                    'B0:A8:6E:9A:39:41',
                                    '02:04:96:35:F9:24',
                                    'D0:D0:FD:AB:1A:B6',
                                    'D0:D0:FD:AC:AE:B6',
                                    'D0:57:4C:74:16:01',
                                    'D0:57:4C:86:CD:00',
                                    '18:03:73:0A:29:C2',
                                    '18:03:73:09:AE:8C',
                                    'F0:4D:A2:6E:CF:89',
                                    'F0:4D:A2:6E:D3:E6',
                                    'F0:4D:A2:6E:D4:96',
                                    'F0:4D:A2:6E:D4:1C',
                                    'F0:4D:A2:6F:03:39',
                                    'F0:4D:A2:6F:03:5B',
                                    'F0:4D:A2:D9:BC:3F',
                                    '28:C0:DA:3E:36:6F',
                                    '2C:36:F8:4B:6A:4A',
                                    '2C:36:F8:4B:6B:4C',
                                    '58:35:D9:94:D3:1A',
                                    '5C:26:0A:A5:B9:93',
                                    '5C:5E:AB:65:4A:81',
                                    '5C:5E:AB:66:60:80',
                                    '5C:5E:AB:78:0E:80'
                                ]
                            }
                        },
                        IFDESCR          => 'ge-0/0/0.0',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '101494486',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(494) 0:00:04.94',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/0.0',
                        IFNUMBER         => '502',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '105772066',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '0',
                        IFSTATUS         => '1',
                        IFTYPE           => '53',
                        MAC              => '2C:6B:F5:9A:7E:80'
                    },
                    {
                        IFDESCR          => 'ge-0/0/1',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '3013356695',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(665916869) 77 days, 1:46:08.69',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/1',
                        IFNUMBER         => '503',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '2048911018',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '10000000',
                        IFSTATUS         => '2',
                        IFTYPE           => '6',
                        MAC              => '2C:6B:F5:9A:7E:81'
                    },
                    {
                        IFDESCR          => 'ge-0/0/10',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '0',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(399) 0:00:03.99',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/10',
                        IFNUMBER         => '504',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '0',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '0',
                        IFSTATUS         => '2',
                        IFTYPE           => '6',
                        MAC              => '2C:6B:F5:9A:7E:8A'
                    },
                    {
                        IFDESCR          => 'ge-0/0/11',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '0',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(400) 0:00:04.00',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/11',
                        IFNUMBER         => '505',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '0',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '0',
                        IFSTATUS         => '2',
                        IFTYPE           => '6',
                        MAC              => '2C:6B:F5:9A:7E:8B'
                    },
                    {
                        IFDESCR          => 'ge-0/0/12',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '1571184393',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(689446000) 79 days, 19:07:40.00',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/12',
                        IFNUMBER         => '506',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '1999701488',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '1000000000',
                        IFSTATUS         => '1',
                        IFTYPE           => '6',
                        MAC              => '2C:6B:F5:9A:7E:8C'
                    },
                    {
                        IFDESCR          => 'ge-0/0/13',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '1444043283',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(690118870) 79 days, 20:59:48.70',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/13',
                        IFNUMBER         => '507',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '932766504',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '1000000000',
                        IFSTATUS         => '1',
                        IFTYPE           => '6',
                        MAC              => '2C:6B:F5:9A:7E:8D'
                    },
                    {
                        IFDESCR          => 'ge-0/0/14',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '0',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(406) 0:00:04.06',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/14',
                        IFNUMBER         => '508',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '0',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '0',
                        IFSTATUS         => '2',
                        IFTYPE           => '6',
                        MAC              => '2C:6B:F5:9A:7E:8E'
                    },
                    {
                        IFDESCR          => 'ge-0/0/15',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '473789460',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(680552839) 78 days, 18:25:28.39',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/15',
                        IFNUMBER         => '509',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '3632242426',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '1000000000',
                        IFSTATUS         => '2',
                        IFTYPE           => '6',
                        MAC              => '2C:6B:F5:9A:7E:8F'
                    },
                    {
                        IFDESCR          => 'ge-0/0/16',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '2486916912',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(682689929) 79 days, 0:21:39.29',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/16',
                        IFNUMBER         => '510',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '2403893481',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '10000000',
                        IFSTATUS         => '2',
                        IFTYPE           => '6',
                        MAC              => '2C:6B:F5:9A:7E:90'
                    },
                    {
                        IFDESCR          => 'ge-0/0/17',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '108183',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(77140369) 8 days, 22:16:43.69',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/17',
                        IFNUMBER         => '511',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '384425',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '1000000000',
                        IFSTATUS         => '2',
                        IFTYPE           => '6',
                        MAC              => '2C:6B:F5:9A:7E:91'
                    },
                    {
                        IFDESCR          => 'ge-0/0/18',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '1778337716',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(327809860) 37 days, 22:34:58.60',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/18',
                        IFNUMBER         => '512',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '1325429110',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '100000000',
                        IFSTATUS         => '1',
                        IFTYPE           => '6',
                        MAC              => '2C:6B:F5:9A:7E:92'
                    },
                    {
                        IFDESCR          => 'ge-0/0/19',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '0',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(339) 0:00:03.39',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/19',
                        IFNUMBER         => '513',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '0',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '0',
                        IFSTATUS         => '2',
                        IFTYPE           => '6',
                        MAC              => '2C:6B:F5:9A:7E:93'
                    },
                    {
                        IFDESCR          => 'ge-0/0/2',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '1902005570',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(424349950) 49 days, 2:44:59.50',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/2',
                        IFNUMBER         => '514',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '1584758679',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '100000000',
                        IFSTATUS         => '1',
                        IFTYPE           => '6',
                        MAC              => '2C:6B:F5:9A:7E:82'
                    },
                    {
                        IFDESCR          => 'ge-0/0/20',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '0',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(340) 0:00:03.40',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/20',
                        IFNUMBER         => '515',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '0',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '0',
                        IFSTATUS         => '2',
                        IFTYPE           => '6',
                        MAC              => '2C:6B:F5:9A:7E:94'
                    },
                    {
                        IFDESCR          => 'ge-0/0/21',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '1206753935',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(690152520) 79 days, 21:05:25.20',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/21',
                        IFNUMBER         => '516',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '4210758575',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '100000000',
                        IFSTATUS         => '1',
                        IFTYPE           => '6',
                        MAC              => '2C:6B:F5:9A:7E:95'
                    },
                    {
                        IFDESCR          => 'ge-0/0/22',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '215929658',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(671751825) 77 days, 17:58:38.25',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/22',
                        IFNUMBER         => '517',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '2000058785',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '100000000',
                        IFSTATUS         => '2',
                        IFTYPE           => '6',
                        MAC              => '2C:6B:F5:9A:7E:96'
                    },
                    {
                        IFDESCR          => 'ge-0/0/23',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '188865545',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(690069390) 79 days, 20:51:33.90',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/23',
                        IFNUMBER         => '518',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '3090429957',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '100000000',
                        IFSTATUS         => '1',
                        IFTYPE           => '6',
                        MAC              => '2C:6B:F5:9A:7E:97'
                    },
                    {
                        IFDESCR          => 'ge-0/0/24',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '0',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(409) 0:00:04.09',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/24',
                        IFNUMBER         => '519',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '0',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '0',
                        IFSTATUS         => '2',
                        IFTYPE           => '6',
                        MAC              => '2C:6B:F5:9A:7E:98'
                    },
                    {
                        IFDESCR          => 'ge-0/0/25',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '0',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(411) 0:00:04.11',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/25',
                        IFNUMBER         => '520',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '0',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '0',
                        IFSTATUS         => '2',
                        IFTYPE           => '6',
                        MAC              => '2C:6B:F5:9A:7E:99'
                    },
                    {
                        IFDESCR          => 'ge-0/0/26',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '0',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(414) 0:00:04.14',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/26',
                        IFNUMBER         => '521',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '0',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '0',
                        IFSTATUS         => '2',
                        IFTYPE           => '6',
                        MAC              => '2C:6B:F5:9A:7E:9A'
                    },
                    {
                        IFDESCR          => 'ge-0/0/27',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '3287311125',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(654852400) 75 days, 19:02:04.00',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/27',
                        IFNUMBER         => '522',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '3349027873',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '100000000',
                        IFSTATUS         => '1',
                        IFTYPE           => '6',
                        MAC              => '2C:6B:F5:9A:7E:9B'
                    },
                    {
                        IFDESCR          => 'ge-0/0/28',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '762667247',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(682860119) 79 days, 0:50:01.19',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/28',
                        IFNUMBER         => '523',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '1750605592',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '100000000',
                        IFSTATUS         => '2',
                        IFTYPE           => '6',
                        MAC              => '2C:6B:F5:9A:7E:9C'
                    },
                    {
                        IFDESCR          => 'ge-0/0/29',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '0',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(425) 0:00:04.25',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/29',
                        IFNUMBER         => '524',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '0',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '0',
                        IFSTATUS         => '2',
                        IFTYPE           => '6',
                        MAC              => '2C:6B:F5:9A:7E:9D'
                    },
                    {
                        IFDESCR          => 'ge-0/0/3',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '3546212557',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(690200000) 79 days, 21:13:20.00',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/3',
                        IFNUMBER         => '525',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '3594306636',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '100000000',
                        IFSTATUS         => '1',
                        IFTYPE           => '6',
                        MAC              => '2C:6B:F5:9A:7E:83'
                    },
                    {
                        IFDESCR          => 'ge-0/0/30',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '136129037',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(681550555) 78 days, 21:11:45.55',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/30',
                        IFNUMBER         => '526',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '1849272137',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '10000000',
                        IFSTATUS         => '2',
                        IFTYPE           => '6',
                        MAC              => '2C:6B:F5:9A:7E:9E'
                    },
                    {
                        IFDESCR          => 'ge-0/0/31',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '93466915',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(690560437) 79 days, 22:13:24.37',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/31',
                        IFNUMBER         => '527',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '201306124',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '10000000',
                        IFSTATUS         => '2',
                        IFTYPE           => '6',
                        MAC              => '2C:6B:F5:9A:7E:9F'
                    },
                    {
                        IFDESCR          => 'ge-0/0/32',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '0',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(386) 0:00:03.86',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/32',
                        IFNUMBER         => '528',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '0',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '0',
                        IFSTATUS         => '2',
                        IFTYPE           => '6',
                        MAC              => '2C:6B:F5:9A:7E:A0'
                    },
                    {
                        IFDESCR          => 'ge-0/0/33',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '0',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(387) 0:00:03.87',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/33',
                        IFNUMBER         => '529',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '0',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '0',
                        IFSTATUS         => '2',
                        IFTYPE           => '6',
                        MAC              => '2C:6B:F5:9A:7E:A1'
                    },
                    {
                        IFDESCR          => 'ge-0/0/34',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '53211885',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(59567179) 6 days, 21:27:51.79',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/34',
                        IFNUMBER         => '530',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '539220717',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '1000000000',
                        IFSTATUS         => '2',
                        IFTYPE           => '6',
                        MAC              => '2C:6B:F5:9A:7E:A2'
                    },
                    {
                        IFDESCR          => 'ge-0/0/35',
                        IFINERRORS       => '102',
                        IFINOCTETS       => '118822572',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(690486680) 79 days, 22:01:06.80',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/35',
                        IFNUMBER         => '531',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '2447844600',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '10000000',
                        IFSTATUS         => '1',
                        IFTYPE           => '6',
                        MAC              => '2C:6B:F5:9A:7E:A3'
                    },
                    {
                        IFDESCR          => 'ge-0/0/36',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '8076917',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(208327439) 24 days, 2:41:14.39',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/36',
                        IFNUMBER         => '532',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '438379336',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '100000000',
                        IFSTATUS         => '2',
                        IFTYPE           => '6',
                        MAC              => '2C:6B:F5:9A:7E:A4'
                    },
                    {
                        IFDESCR          => 'ge-0/0/37',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '2685287865',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(533708490) 61 days, 18:31:24.90',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/37',
                        IFNUMBER         => '533',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '3049509646',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '100000000',
                        IFSTATUS         => '1',
                        IFTYPE           => '6',
                        MAC              => '2C:6B:F5:9A:7E:A5'
                    },
                    {
                        IFDESCR          => 'ge-0/0/38',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '1241053012',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(682821860) 79 days, 0:43:38.60',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/38',
                        IFNUMBER         => '534',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '3840965297',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '100000000',
                        IFSTATUS         => '1',
                        IFTYPE           => '6',
                        MAC              => '2C:6B:F5:9A:7E:A6'
                    },
                    {
                        IFDESCR          => 'ge-0/0/39',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '1030838465',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(690387400) 79 days, 21:44:34.00',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/39',
                        IFNUMBER         => '535',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '4181007764',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '100000000',
                        IFSTATUS         => '1',
                        IFTYPE           => '6',
                        MAC              => '2C:6B:F5:9A:7E:A7'
                    },
                    {
                        IFDESCR          => 'ge-0/0/4',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '354731055',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(672589500) 77 days, 20:18:15.00',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/4',
                        IFNUMBER         => '536',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '3768060268',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '100000000',
                        IFSTATUS         => '1',
                        IFTYPE           => '6',
                        MAC              => '2C:6B:F5:9A:7E:84'
                    },
                    {
                        IFDESCR          => 'ge-0/0/40',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '1165890653',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(689500550) 79 days, 19:16:45.50',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/40',
                        IFNUMBER         => '537',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '2069283093',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '100000000',
                        IFSTATUS         => '1',
                        IFTYPE           => '6',
                        MAC              => '2C:6B:F5:9A:7E:A8'
                    },
                    {
                        IFDESCR          => 'ge-0/0/41',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '81453084',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(148050739) 17 days, 3:15:07.39',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/41',
                        IFNUMBER         => '538',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '1543143617',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '1000000000',
                        IFSTATUS         => '2',
                        IFTYPE           => '6',
                        MAC              => '2C:6B:F5:9A:7E:A9'
                    },
                    {
                        IFDESCR          => 'ge-0/0/42',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '1552651383',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(682354629) 78 days, 23:25:46.29',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/42',
                        IFNUMBER         => '539',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '2351683718',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '100000000',
                        IFSTATUS         => '2',
                        IFTYPE           => '6',
                        MAC              => '2C:6B:F5:9A:7E:AA'
                    },
                    {
                        IFDESCR          => 'ge-0/0/43',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '829983992',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(595918169) 68 days, 23:19:41.69',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/43',
                        IFNUMBER         => '540',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '3925839742',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '100000000',
                        IFSTATUS         => '2',
                        IFTYPE           => '6',
                        MAC              => '2C:6B:F5:9A:7E:AB'
                    },
                    {
                        IFDESCR          => 'ge-0/0/44',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '1704785039',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(690512280) 79 days, 22:05:22.80',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/44',
                        IFNUMBER         => '541',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '2373360839',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '100000000',
                        IFSTATUS         => '1',
                        IFTYPE           => '6',
                        MAC              => '2C:6B:F5:9A:7E:AC'
                    },
                    {
                        IFDESCR          => 'ge-0/0/45',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '1721208124',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(672157520) 77 days, 19:06:15.20',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/45',
                        IFNUMBER         => '542',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '3695657617',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '10000000',
                        IFSTATUS         => '1',
                        IFTYPE           => '6',
                        MAC              => '2C:6B:F5:9A:7E:AD'
                    },
                    {
                        IFDESCR          => 'ge-0/0/46',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '1256689629',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(595611380) 68 days, 22:28:33.80',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/46',
                        IFNUMBER         => '543',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '740549357',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '100000000',
                        IFSTATUS         => '1',
                        IFTYPE           => '6',
                        MAC              => '2C:6B:F5:9A:7E:AE'
                    },
                    {
                        IFDESCR          => 'ge-0/0/47',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '2956582641',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(595611051) 68 days, 22:28:30.51',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/47',
                        IFNUMBER         => '544',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '348225454',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '1000000000',
                        IFSTATUS         => '2',
                        IFTYPE           => '6',
                        MAC              => '2C:6B:F5:9A:7E:AF'
                    },
                    {
                        IFDESCR          => 'ge-0/0/5',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '894824395',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(683883700) 79 days, 3:40:37.00',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/5',
                        IFNUMBER         => '545',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '3675464067',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '10000000',
                        IFSTATUS         => '1',
                        IFTYPE           => '6',
                        MAC              => '2C:6B:F5:9A:7E:85'
                    },
                    {
                        IFDESCR          => 'ge-0/0/6',
                        IFINERRORS       => '4',
                        IFINOCTETS       => '2506833587',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(681483205) 78 days, 21:00:32.05',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/6',
                        IFNUMBER         => '546',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '2081076951',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '100000000',
                        IFSTATUS         => '2',
                        IFTYPE           => '6',
                        MAC              => '2C:6B:F5:9A:7E:86'
                    },
                    {
                        IFDESCR          => 'ge-0/0/7',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '0',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(394) 0:00:03.94',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/7',
                        IFNUMBER         => '547',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '0',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '0',
                        IFSTATUS         => '2',
                        IFTYPE           => '6',
                        MAC              => '2C:6B:F5:9A:7E:87'
                    },
                    {
                        IFDESCR          => 'ge-0/0/8',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '2234030194',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1166) 0:00:11.66',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/8',
                        IFNUMBER         => '548',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '2009640690',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '100000000',
                        IFSTATUS         => '1',
                        IFTYPE           => '6',
                        MAC              => '2C:6B:F5:9A:7E:88'
                    },
                    {
                        IFDESCR          => 'ge-0/0/9',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '1130591759',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(683567821) 79 days, 2:47:58.21',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/9',
                        IFNUMBER         => '549',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '1128824234',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '100000000',
                        IFSTATUS         => '2',
                        IFTYPE           => '6',
                        MAC              => '2C:6B:F5:9A:7E:89'
                    },
                    {
                        IFDESCR          => 'vlan',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '1805109523',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(245) 0:00:02.45',
                        IFMTU            => '1518',
                        IFNAME           => 'vlan',
                        IFNUMBER         => '550',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '30471514',
                        IFSPEED          => '1000000000',
                        IFSTATUS         => '1',
                        IFTYPE           => '6',
                        MAC              => '2C:6B:F5:9A:7E:80'
                    },
                    {
                        IFDESCR          => 'ge-0/0/1.0',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '5857',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(665916869) 77 days, 1:46:08.69',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/1.0',
                        IFNUMBER         => '553',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '416395996',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '0',
                        IFSTATUS         => '7',
                        IFTYPE           => '53',
                        MAC              => '2C:6B:F5:9A:7E:81'
                    },
                    {
                        IFDESCR          => 'ge-0/0/10.0',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '0',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(400) 0:00:04.00',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/10.0',
                        IFNUMBER         => '554',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '0',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '0',
                        IFSTATUS         => '7',
                        IFTYPE           => '53',
                        MAC              => '2C:6B:F5:9A:7E:8A'
                    },
                    {
                        IFDESCR          => 'ge-0/0/11.0',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '0',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(401) 0:00:04.01',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/11.0',
                        IFNUMBER         => '555',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '0',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '0',
                        IFSTATUS         => '7',
                        IFTYPE           => '53',
                        MAC              => '2C:6B:F5:9A:7E:8B'
                    },
                    {
                        IFDESCR          => 'ge-0/0/12.0',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '2214652',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(689446000) 79 days, 19:07:40.00',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/12.0',
                        IFNUMBER         => '556',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '69695210',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '0',
                        IFSTATUS         => '1',
                        IFTYPE           => '53',
                        MAC              => '2C:6B:F5:9A:7E:8C'
                    },
                    {
                        IFDESCR          => 'ge-0/0/13.0',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '1047225',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(690118870) 79 days, 20:59:48.70',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/13.0',
                        IFNUMBER         => '557',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '72149489',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '0',
                        IFSTATUS         => '1',
                        IFTYPE           => '53',
                        MAC              => '2C:6B:F5:9A:7E:8D'
                    },
                    {
                        IFDESCR          => 'ge-0/0/14.0',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '0',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(407) 0:00:04.07',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/14.0',
                        IFNUMBER         => '558',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '0',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '0',
                        IFSTATUS         => '7',
                        IFTYPE           => '53',
                        MAC              => '2C:6B:F5:9A:7E:8E'
                    },
                    {
                        IFDESCR          => 'ge-0/0/15.0',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '1447979',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(680552839) 78 days, 18:25:28.39',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/15.0',
                        IFNUMBER         => '559',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '15965923',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '0',
                        IFSTATUS         => '7',
                        IFTYPE           => '53',
                        MAC              => '2C:6B:F5:9A:7E:8F'
                    },
                    {
                        IFDESCR          => 'ge-0/0/16.0',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '1618691',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(682689929) 79 days, 0:21:39.29',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/16.0',
                        IFNUMBER         => '560',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '442853532',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '0',
                        IFSTATUS         => '7',
                        IFTYPE           => '53',
                        MAC              => '2C:6B:F5:9A:7E:90'
                    },
                    {
                        IFDESCR          => 'ge-0/0/17.0',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '22941',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(77140369) 8 days, 22:16:43.69',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/17.0',
                        IFNUMBER         => '561',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '23702',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '0',
                        IFSTATUS         => '7',
                        IFTYPE           => '53',
                        MAC              => '2C:6B:F5:9A:7E:91'
                    },
                    {
                        IFDESCR          => 'ge-0/0/18.0',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '223721',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(327809860) 37 days, 22:34:58.60',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/18.0',
                        IFNUMBER         => '562',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '441314897',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '0',
                        IFSTATUS         => '1',
                        IFTYPE           => '53',
                        MAC              => '2C:6B:F5:9A:7E:92'
                    },
                    {
                        IFDESCR          => 'ge-0/0/19.0',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '0',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(662) 0:00:06.62',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/19.0',
                        IFNUMBER         => '563',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '0',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '0',
                        IFSTATUS         => '7',
                        IFTYPE           => '53',
                        MAC              => '2C:6B:F5:9A:7E:93'
                    },
                    {
                        IFDESCR          => 'ge-0/0/2.0',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '469097',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(424349950) 49 days, 2:44:59.50',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/2.0',
                        IFNUMBER         => '564',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '446847194',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '0',
                        IFSTATUS         => '1',
                        IFTYPE           => '53',
                        MAC              => '2C:6B:F5:9A:7E:82'
                    },
                    {
                        IFDESCR          => 'ge-0/0/20.0',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '0',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(687) 0:00:06.87',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/20.0',
                        IFNUMBER         => '565',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '0',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '0',
                        IFSTATUS         => '7',
                        IFTYPE           => '53',
                        MAC              => '2C:6B:F5:9A:7E:94'
                    },
                    {
                        IFDESCR          => 'ge-0/0/21.0',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '173239',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(690152520) 79 days, 21:05:25.20',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/21.0',
                        IFNUMBER         => '566',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '447475036',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '0',
                        IFSTATUS         => '1',
                        IFTYPE           => '53',
                        MAC              => '2C:6B:F5:9A:7E:95'
                    },
                    {
                        IFDESCR          => 'ge-0/0/22.0',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '350154',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(671751825) 77 days, 17:58:38.25',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/22.0',
                        IFNUMBER         => '567',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '79929851',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '0',
                        IFSTATUS         => '7',
                        IFTYPE           => '53',
                        MAC              => '2C:6B:F5:9A:7E:96'
                    },
                    {
                        IFDESCR          => 'ge-0/0/23.0',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '44505',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(690069390) 79 days, 20:51:33.90',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/23.0',
                        IFNUMBER         => '568',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '447678496',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '0',
                        IFSTATUS         => '1',
                        IFTYPE           => '53',
                        MAC              => '2C:6B:F5:9A:7E:97'
                    },
                    {
                        IFDESCR          => 'ge-0/0/24.0',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '0',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(410) 0:00:04.10',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/24.0',
                        IFNUMBER         => '569',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '0',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '0',
                        IFSTATUS         => '7',
                        IFTYPE           => '53',
                        MAC              => '2C:6B:F5:9A:7E:98'
                    },
                    {
                        IFDESCR          => 'ge-0/0/25.0',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '0',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(413) 0:00:04.13',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/25.0',
                        IFNUMBER         => '570',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '0',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '0',
                        IFSTATUS         => '7',
                        IFTYPE           => '53',
                        MAC              => '2C:6B:F5:9A:7E:99'
                    },
                    {
                        IFDESCR          => 'ge-0/0/26.0',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '0',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(416) 0:00:04.16',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/26.0',
                        IFNUMBER         => '571',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '0',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '0',
                        IFSTATUS         => '7',
                        IFTYPE           => '53',
                        MAC              => '2C:6B:F5:9A:7E:9A'
                    },
                    {
                        IFDESCR          => 'ge-0/0/27.0',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '10178',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(654852400) 75 days, 19:02:04.00',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/27.0',
                        IFNUMBER         => '572',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '448228334',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '0',
                        IFSTATUS         => '1',
                        IFTYPE           => '53',
                        MAC              => '2C:6B:F5:9A:7E:9B'
                    },
                    {
                        IFDESCR          => 'ge-0/0/28.0',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '2685687',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(682860119) 79 days, 0:50:01.19',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/28.0',
                        IFNUMBER         => '573',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '16975010',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '0',
                        IFSTATUS         => '7',
                        IFTYPE           => '53',
                        MAC              => '2C:6B:F5:9A:7E:9C'
                    },
                    {
                        IFDESCR          => 'ge-0/0/29.0',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '0',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(426) 0:00:04.26',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/29.0',
                        IFNUMBER         => '574',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '0',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '0',
                        IFSTATUS         => '7',
                        IFTYPE           => '53',
                        MAC              => '2C:6B:F5:9A:7E:9D'
                    },
                    {
                        IFDESCR          => 'ge-0/0/3.0',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '2303780',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(690200000) 79 days, 21:13:20.00',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/3.0',
                        IFNUMBER         => '575',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '256970338',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '0',
                        IFSTATUS         => '1',
                        IFTYPE           => '53',
                        MAC              => '2C:6B:F5:9A:7E:83'
                    },
                    {
                        IFDESCR          => 'ge-0/0/30.0',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '24694',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(681550555) 78 days, 21:11:45.55',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/30.0',
                        IFNUMBER         => '576',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '385335962',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '0',
                        IFSTATUS         => '7',
                        IFTYPE           => '53',
                        MAC              => '2C:6B:F5:9A:7E:9E'
                    },
                    {
                        IFDESCR          => 'ge-0/0/31.0',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '50282',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(690560437) 79 days, 22:13:24.37',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/31.0',
                        IFNUMBER         => '577',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '3882652',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '0',
                        IFSTATUS         => '7',
                        IFTYPE           => '53',
                        MAC              => '2C:6B:F5:9A:7E:9F'
                    },
                    {
                        IFDESCR          => 'ge-0/0/32.0',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '0',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(643) 0:00:06.43',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/32.0',
                        IFNUMBER         => '578',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '0',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '0',
                        IFSTATUS         => '7',
                        IFTYPE           => '53',
                        MAC              => '2C:6B:F5:9A:7E:A0'
                    },
                    {
                        IFDESCR          => 'ge-0/0/33.0',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '0',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(665) 0:00:06.65',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/33.0',
                        IFNUMBER         => '579',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '0',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '0',
                        IFSTATUS         => '7',
                        IFTYPE           => '53',
                        MAC              => '2C:6B:F5:9A:7E:A1'
                    },
                    {
                        IFDESCR          => 'ge-0/0/34.0',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '147975',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(59567179) 6 days, 21:27:51.79',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/34.0',
                        IFNUMBER         => '580',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '7302800',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '0',
                        IFSTATUS         => '7',
                        IFTYPE           => '53',
                        MAC              => '2C:6B:F5:9A:7E:A2'
                    },
                    {
                        IFDESCR          => 'ge-0/0/35.0',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '137977',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(690486680) 79 days, 22:01:06.80',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/35.0',
                        IFNUMBER         => '581',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '447041540',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '0',
                        IFSTATUS         => '1',
                        IFTYPE           => '53',
                        MAC              => '2C:6B:F5:9A:7E:A3'
                    },
                    {
                        IFDESCR          => 'ge-0/0/36.0',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '156339',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(208327439) 24 days, 2:41:14.39',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/36.0',
                        IFNUMBER         => '582',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '93089646',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '0',
                        IFSTATUS         => '7',
                        IFTYPE           => '53',
                        MAC              => '2C:6B:F5:9A:7E:A4'
                    },
                    {
                        IFDESCR          => 'ge-0/0/37.0',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '3263553',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(533708490) 61 days, 18:31:24.90',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/37.0',
                        IFNUMBER         => '583',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '279079429',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '0',
                        IFSTATUS         => '1',
                        IFTYPE           => '53',
                        MAC              => '2C:6B:F5:9A:7E:A5'
                    },
                    {
                        IFDESCR          => 'ge-0/0/38.0',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '1911627',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(682821860) 79 days, 0:43:38.60',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/38.0',
                        IFNUMBER         => '584',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '447293405',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '0',
                        IFSTATUS         => '1',
                        IFTYPE           => '53',
                        MAC              => '2C:6B:F5:9A:7E:A6'
                    },
                    {
                        IFDESCR          => 'ge-0/0/39.0',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '3365162',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(690387400) 79 days, 21:44:34.00',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/39.0',
                        IFNUMBER         => '585',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '83617872',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '0',
                        IFSTATUS         => '1',
                        IFTYPE           => '53',
                        MAC              => '2C:6B:F5:9A:7E:A7'
                    },
                    {
                        IFDESCR          => 'ge-0/0/4.0',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '439264',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(672589500) 77 days, 20:18:15.00',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/4.0',
                        IFNUMBER         => '586',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '447533137',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '0',
                        IFSTATUS         => '1',
                        IFTYPE           => '53',
                        MAC              => '2C:6B:F5:9A:7E:84'
                    },
                    {
                        IFDESCR          => 'ge-0/0/40.0',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '11338164',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(689500550) 79 days, 19:16:45.50',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/40.0',
                        IFNUMBER         => '587',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '81215246',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '0',
                        IFSTATUS         => '1',
                        IFTYPE           => '53',
                        MAC              => '2C:6B:F5:9A:7E:A8'
                    },
                    {
                        IFDESCR          => 'ge-0/0/41.0',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '215806',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(148050739) 17 days, 3:15:07.39',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/41.0',
                        IFNUMBER         => '588',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '2041083',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '0',
                        IFSTATUS         => '7',
                        IFTYPE           => '53',
                        MAC              => '2C:6B:F5:9A:7E:A9'
                    },
                    {
                        IFDESCR          => 'ge-0/0/42.0',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '76619276',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(682354629) 78 days, 23:25:46.29',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/42.0',
                        IFNUMBER         => '589',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '442621726',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '0',
                        IFSTATUS         => '7',
                        IFTYPE           => '53',
                        MAC              => '2C:6B:F5:9A:7E:AA'
                    },
                    {
                        IFDESCR          => 'ge-0/0/43.0',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '3425509',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(595918169) 68 days, 23:19:41.69',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/43.0',
                        IFNUMBER         => '590',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '49542723',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '0',
                        IFSTATUS         => '7',
                        IFTYPE           => '53',
                        MAC              => '2C:6B:F5:9A:7E:AB'
                    },
                    {
                        IFDESCR          => 'ge-0/0/44.0',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '4537101',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(690512280) 79 days, 22:05:22.80',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/44.0',
                        IFNUMBER         => '591',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '102760044',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '0',
                        IFSTATUS         => '1',
                        IFTYPE           => '53',
                        MAC              => '2C:6B:F5:9A:7E:AC'
                    },
                    {
                        IFDESCR          => 'ge-0/0/45.0',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '76592',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(672157520) 77 days, 19:06:15.20',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/45.0',
                        IFNUMBER         => '592',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '354018094',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '0',
                        IFSTATUS         => '1',
                        IFTYPE           => '53',
                        MAC              => '2C:6B:F5:9A:7E:AD'
                    },
                    {
                        IFDESCR          => 'ge-0/0/46.0',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '952616',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(595611380) 68 days, 22:28:33.80',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/46.0',
                        IFNUMBER         => '593',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '61630220',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '100000000',
                        IFSTATUS         => '1',
                        IFTYPE           => '53',
                        MAC              => '2C:6B:F5:9A:7E:AE'
                    },
                    {
                        IFDESCR          => 'ge-0/0/47.0',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '4911565',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(595611051) 68 days, 22:28:30.51',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/47.0',
                        IFNUMBER         => '594',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '285952935',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '0',
                        IFSTATUS         => '7',
                        IFTYPE           => '53',
                        MAC              => '2C:6B:F5:9A:7E:AF'
                    },
                    {
                        IFDESCR          => 'ge-0/0/5.0',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '2655317',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(683883700) 79 days, 3:40:37.00',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/5.0',
                        IFNUMBER         => '595',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '447689671',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '0',
                        IFSTATUS         => '1',
                        IFTYPE           => '53',
                        MAC              => '2C:6B:F5:9A:7E:85'
                    },
                    {
                        IFDESCR          => 'ge-0/0/6.0',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '340907',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(681483205) 78 days, 21:00:32.05',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/6.0',
                        IFNUMBER         => '596',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '88449606',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '0',
                        IFSTATUS         => '7',
                        IFTYPE           => '53',
                        MAC              => '2C:6B:F5:9A:7E:86'
                    },
                    {
                        IFDESCR          => 'ge-0/0/7.0',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '0',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(395) 0:00:03.95',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/7.0',
                        IFNUMBER         => '597',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '0',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '0',
                        IFSTATUS         => '7',
                        IFTYPE           => '53',
                        MAC              => '2C:6B:F5:9A:7E:87'
                    },
                    {
                        IFDESCR          => 'ge-0/0/8.0',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '8463015',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1166) 0:00:11.66',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/8.0',
                        IFNUMBER         => '598',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '447755052',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '0',
                        IFSTATUS         => '1',
                        IFTYPE           => '53',
                        MAC              => '2C:6B:F5:9A:7E:88'
                    },
                    {
                        IFDESCR          => 'ge-0/0/9.0',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '2799490',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(683567821) 79 days, 2:47:58.21',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/9.0',
                        IFNUMBER         => '599',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '46465074',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '0',
                        IFSTATUS         => '7',
                        IFTYPE           => '53',
                        MAC              => '2C:6B:F5:9A:7E:89'
                    },
                    {
                        IFDESCR          => 'vlan.0',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '1805113747',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(497) 0:00:04.97',
                        IFMTU            => '1500',
                        IFNAME           => 'vlan.0',
                        IFNUMBER         => '602',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '28643566',
                        IFSPEED          => '1000000000',
                        IFSTATUS         => '1',
                        IFTYPE           => '53',
                        MAC              => '2C:6B:F5:9A:7E:80'
                    },
                    {
                        IFDESCR          => 'jsrv',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '0',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFMTU            => '1518',
                        IFNAME           => 'jsrv',
                        IFNUMBER         => '603',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '0',
                        IFSPEED          => '1000000000',
                        IFSTATUS         => '1',
                        IFTYPE           => '6',
                        MAC              => '2C:6B:F5:9A:7E:80'
                    },
                    {
                        IFDESCR          => 'jsrv.1',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '0',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFMTU            => '1500',
                        IFNAME           => 'jsrv.1',
                        IFNUMBER         => '604',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '42',
                        IFSPEED          => '1000000000',
                        IFSTATUS         => '1',
                        IFTYPE           => '53',
                        MAC              => '2C:6B:F5:9A:7E:80'
                    }
                ]
            },
        }
    ],
    'juniper/ex4200.walk' => [
        {
            MANUFACTURER => 'Juniper',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Juniper Networks, Inc. ex4200-48p internet router, kernel JUNOS 10.4R3.4 #0: 2011-03-19 22:06:32 UTC     builder@warth.juniper.net:/volume/build/junos/10.4/release/10.4R3.4/obj-powerpc/bsd/sys/compile/JUNIPER-EX Build date: 2011-03-19 21:51:24 UTC Copyri',
            SNMPHOSTNAME => 'jte4-01',
            MAC          => '2C:6B:F5:9B:48:80',
        },
        {
            MANUFACTURER => 'Juniper',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Juniper Networks, Inc. ex4200-48p internet router, kernel JUNOS 10.4R3.4 #0: 2011-03-19 22:06:32 UTC     builder@warth.juniper.net:/volume/build/junos/10.4/release/10.4R3.4/obj-powerpc/bsd/sys/compile/JUNIPER-EX Build date: 2011-03-19 21:51:24 UTC Copyri',
            SNMPHOSTNAME => 'jte4-01',
            MAC          => '2C:6B:F5:9B:48:80',
            MODELSNMP    => 'Networking2448',
            MODEL        => undef,
            FIRMWARE     => undef,
            SERIAL       => 'BQ0210122093',
        },
        {
            INFO => {
                MANUFACTURER => 'Juniper',
                TYPE         => 'NETWORKING',
                COMMENTS     => 'Juniper Networks, Inc. ex4200-48p internet router, kernel JUNOS 10.4R3.4 #0: 2011-03-19 22:06:32 UTC     builder@warth.juniper.net:/volume/build/junos/10.4/release/10.4R3.4/obj-powerpc/bsd/sys/compile/JUNIPER-EX Build date: 2011-03-19 21:51:24 UTC Copyri',
                UPTIME       => '(1579491875) 182 days, 19:28:38.75',
                MODEL        => undef,
                LOCATION     => 'Salle informatique E4 PMF',
                ID           => undef,
                SERIAL       => 'BQ0210122093',
                MAC          => '2C:6B:F5:9B:48:80',
                NAME         => 'jte4-01',
                MEMORY       => 0,
                FIRMWARE     => 'Juniper Networks, Inc. ex4200-48p , version 10.4R3.4 Build date: 2011-03-19 22:17:08 UTC ',
                IPS          => {
                    IP => [
                            '128.0.0.1',
                            '128.0.0.127',
                            '128.0.0.16',
                            '128.0.0.32',
                            '192.168.100.31'
                        ]
                },
            },
            PORTS => {
                PORT => [
                    {
                        IFDESCR          => 'lsi',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '0',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFMTU            => '1496',
                        IFNAME           => 'lsi',
                        IFNUMBER         => '4',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '0',
                        IFSPEED          => '0',
                        IFSTATUS         => '1',
                        IFTYPE           => '150',
                    },
                    {
                        IFDESCR          => 'dsc',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '0',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5840) 0:00:58.40',
                        IFMTU            => '2147483647',
                        IFNAME           => 'dsc',
                        IFNUMBER         => '5',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '0',
                        IFSPEED          => '0',
                        IFSTATUS         => '1',
                        IFTYPE           => '1',
                    },
                    {
                        IFDESCR          => 'lo0',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '628200578',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5842) 0:00:58.42',
                        IFMTU            => '2147483647',
                        IFNAME           => 'lo0',
                        IFNUMBER         => '6',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '630161982',
                        IFSPEED          => '0',
                        IFSTATUS         => '1',
                        IFTYPE           => '24',
                    },
                    {
                        IFDESCR          => 'tap',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '0',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5845) 0:00:58.45',
                        IFMTU            => '2147483647',
                        IFNAME           => 'tap',
                        IFNUMBER         => '7',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '0',
                        IFSPEED          => '0',
                        IFSTATUS         => '1',
                        IFTYPE           => '1',
                    },
                    {
                        IFDESCR          => 'gre',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '0',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5840) 0:00:58.40',
                        IFMTU            => '2147483647',
                        IFNAME           => 'gre',
                        IFNUMBER         => '8',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '0',
                        IFSTATUS         => '1',
                        IFSPEED          => '0',
                        IFTYPE           => '131',
                    },
                    {
                        IFDESCR          => 'ipip',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '0',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5841) 0:00:58.41',
                        IFMTU            => '2147483647',
                        IFNAME           => 'ipip',
                        IFNUMBER         => '9',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '0',
                        IFSPEED          => '0',
                        IFSTATUS         => '1',
                        IFTYPE           => '131',
                    },
                    {
                        IFDESCR          => 'pime',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '0',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5844) 0:00:58.44',
                        IFMTU            => '2147483647',
                        IFNAME           => 'pime',
                        IFNUMBER         => '10',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '0',
                        IFSPEED          => '0',
                        IFSTATUS         => '1',
                        IFTYPE           => '131',
                    },
                    {
                        IFDESCR          => 'pimd',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '0',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5844) 0:00:58.44',
                        IFMTU            => '2147483647',
                        IFNAME           => 'pimd',
                        IFNUMBER         => '11',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '0',
                        IFSPEED          => '0',
                        IFSTATUS         => '1',
                        IFTYPE           => '131',
                    },
                    {
                        IFDESCR          => 'mtun',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '0',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFMTU            => '2147483647',
                        IFNAME           => 'mtun',
                        IFNUMBER         => '12',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '0',
                        IFSPEED          => '0',
                        IFSTATUS         => '1',
                        IFTYPE           => '131',
                    },
                    {
                        IFDESCR          => 'me0',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '0',
                        IFINTERNALSTATUS => '1',,
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFMTU            => '1514',
                        IFNAME           => 'me0',
                        IFNUMBER         => '33',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '0',
                        IFSPEED          => '0',
                        IFSTATUS         => '2',
                        IFTYPE           => '6',
                        MAC              => '2C:6B:F5:9B:48:81'
                    },
                    {
                        IFDESCR          => 'me0.0',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '0',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1634) 0:00:16.34',
                        IFMTU            => '1514',
                        IFNAME           => 'me0.0',
                        IFNUMBER         => '34',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '0',
                        IFSPEED          => '0',
                        IFSTATUS         => '7',
                        IFTYPE           => '53',
                        MAC              => '2C:6B:F5:9B:48:81'
                    },
                    {
                        IFDESCR          => 'vme',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '0',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFMTU            => '1518',
                        IFNAME           => 'vme',
                        IFNUMBER         => '35',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '0',
                        IFSPEED          => '1000000000',
                        IFSTATUS         => '2',
                        IFTYPE           => '6',
                        MAC              => '2C:6B:F5:9B:48:81'
                    },
                    {
                        IFDESCR          => 'bme0',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '0',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFMTU            => '1576',
                        IFNAME           => 'bme0',
                        IFNUMBER         => '37',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '3190556671',
                        IFSPEED          => '0',
                        IFSTATUS         => '1',
                        IFTYPE           => '6',
                        MAC              => '00:0B:CA:FE:00:00'
                    },
                    {
                        IFDESCR          => 'bme0.32768',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '1267757312',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFMTU            => '1562',
                        IFNAME           => 'bme0.32768',
                        IFNUMBER         => '38',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '2909561371',
                        IFSPEED          => '0',
                        IFSTATUS         => '1',
                        IFTYPE           => '53',
                        MAC              => '00:0B:CA:FE:00:00'
                    },
                    {
                        IFDESCR          => 'bme0.32770',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '0',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(717450037) 83 days, 0:55:00.37',
                        IFMTU            => '1576',
                        IFNAME           => 'bme0.32770',
                        IFNUMBER         => '40',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '0',
                        IFSPEED          => '0',
                        IFSTATUS         => '2',
                        IFTYPE           => '53',
                        MAC              => '00:0B:CA:FE:00:00'
                    },
                    {
                        IFDESCR          => 'bme0.32771',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '0',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(889645996) 102 days, 23:14:19.96',
                        IFMTU            => '1576',
                        IFNAME           => 'bme0.32771',
                        IFNUMBER         => '41',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '0',
                        IFSPEED          => '0',
                        IFSTATUS         => '2',
                        IFTYPE           => '53',
                        MAC              => '00:0B:CA:FE:00:00'
                    },
                    {
                        IFDESCR          => 'bme0.32772',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '0',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(889646000) 102 days, 23:14:20.00',
                        IFMTU            => '1576',
                        IFNAME           => 'bme0.32772',
                        IFNUMBER         => '42',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '0',
                        IFSPEED          => '0',
                        IFSTATUS         => '2',
                        IFTYPE           => '53',
                        MAC              => '00:0B:CA:FE:00:00'
                    },
                    {
                        IFDESCR          => 'bme0.32773',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '0',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(1071466411) 124 days, 0:17:44.11',
                        IFMTU            => '1576',
                        IFNAME           => 'bme0.32773',
                        IFNUMBER         => '43',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '0',
                        IFSPEED          => '0',
                        IFSTATUS         => '2',
                        IFTYPE           => '53',
                        MAC              => '00:0B:CA:FE:00:00'
                    },
                    {
                        IFDESCR          => 'bme0.32774',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '0',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(1071466415) 124 days, 0:17:44.15',
                        IFMTU            => '1576',
                        IFNAME           => 'bme0.32774',
                        IFNUMBER         => '44',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '0',
                        IFSPEED          => '0',
                        IFSTATUS         => '2',
                        IFTYPE           => '53',
                        MAC              => '00:0B:CA:FE:00:00'
                    },
                    {
                        IFDESCR          => 'vcp-0',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '0',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(717449455) 83 days, 0:54:54.55',
                        IFMTU            => '1514',
                        IFNAME           => 'vcp-0',
                        IFNUMBER         => '49',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '0',
                        IFSPEED          => '4294967295',
                        IFSTATUS         => '1',
                        IFTYPE           => '1',
                    },
                    {
                        IFDESCR          => 'vcp-0.32768',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '0',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(717449455) 83 days, 0:54:54.55',
                        IFMTU            => '0',
                        IFNAME           => 'vcp-0.32768',
                        IFNUMBER         => '50',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '0',
                        IFSPEED          => '4294967295',
                        IFSTATUS         => '1',
                        IFTYPE           => '53',
                    },
                    {
                        IFDESCR          => 'vcp-1',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '0',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(717449456) 83 days, 0:54:54.56',
                        IFMTU            => '1514',
                        IFNAME           => 'vcp-1',
                        IFNUMBER         => '51',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '0',
                        IFSPEED          => '4294967295',
                        IFSTATUS         => '1',
                        IFTYPE           => '1',
                    },
                    {
                        IFDESCR          => 'vcp-1.32768',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '0',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(717449456) 83 days, 0:54:54.56',
                        IFMTU            => '0',
                        IFNAME           => 'vcp-1.32768',
                        IFNUMBER         => '52',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '0',
                        IFSPEED          => '4294967295',
                        IFSTATUS         => '1',
                        IFTYPE           => '53',
                    },
                    {
                        IFDESCR          => 'vcp-255/1/2',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '0',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(889641113) 102 days, 23:13:31.13',
                        IFMTU            => '1514',
                        IFNAME           => 'vcp-255/1/2',
                        IFNUMBER         => '105',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '0',
                        IFSPEED          => '4294967295',
                        IFSTATUS         => '1',
                        IFTYPE           => '1',
                    },
                    {
                        IFDESCR          => 'vcp-255/1/2.32768',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '0',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(889641113) 102 days, 23:13:31.13',
                        IFMTU            => '0',
                        IFNAME           => 'vcp-255/1/2.32768',
                        IFNUMBER         => '106',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '0',
                        IFSPEED          => '4294967295',
                        IFSTATUS         => '1',
                        IFTYPE           => '53',
                    },
                    {
                        IFDESCR          => 'jsrv',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '0',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(665) 0:00:06.65',
                        IFMTU            => '1518',
                        IFNAME           => 'jsrv',
                        IFNUMBER         => '501',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '0',
                        IFSPEED          => '1000000000',
                        IFSTATUS         => '1',
                        IFTYPE           => '6',
                        MAC              => '2C:6B:F5:9B:05:80'
                    },
                    {
                        IFDESCR          => 'ge-0/0/0',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '2877542534',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/0',
                        IFNUMBER         => '502',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '1218507182',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '1000000000',
                        IFSTATUS         => '1',
                        IFTYPE           => '6',
                        MAC              => '2C:6B:F5:9B:48:81'
                    },
                    {
                        IFOUTOCTETS      => '173363747',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFMTU            => '1514',
                        IFNUMBER         => '503',
                        IFDESCR          => 'ge-0/0/0.0',
                        IFSTATUS         => '1',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '173229412',
                        IFTYPE           => '53',
                        IFNAME           => 'ge-0/0/0.0',
                        IFINERRORS       => '0',
                        CONNECTIONS => {
                            CONNECTION => {
                                SYSMAC   => '2C:6B:F5:99:7C:00',
                                IFDESCR  => 'ge-0/0/0.0',
                                IFNUMBER => '502',
                                SYSNAME  => 'jte4-02',
                                SYSDESCR => 'Juniper Networks, Inc. ex3200-48p , version 10.3R1.9 Build date: 2010-08-13 12:56:38 UTC '
                            },
                            CDP => 1
                        },
                        IFSPEED          => '1000000000',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        MAC              => '2C:6B:F5:9B:48:81'
                    },
                    {
                        IFDESCR          => 'ge-0/0/1',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '0',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/1',
                        IFNUMBER         => '504',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '0',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '100000000',
                        IFSTATUS         => '2',
                        IFTYPE           => '6',
                        MAC              => '2C:6B:F5:9B:48:81'
                    },
                    {
                        IFDESCR          => 'ge-0/0/1.0',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '0',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/1.0',
                        IFNUMBER         => '505',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '0',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '100000000',
                        IFSTATUS         => '7',
                        IFTYPE           => '53',
                        MAC              => '2C:6B:F5:9B:48:81'
                    },
                    {
                        IFDESCR          => 'ge-0/0/2',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '329254826',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1501251026) 173 days, 18:08:30.26',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/2',
                        IFNUMBER         => '506',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '4242153267',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '1000000000',
                        IFSTATUS         => '2',
                        IFTYPE           => '6',
                        MAC              => '2C:6B:F5:9B:48:82'
                    },
                    {
                        IFDESCR          => 'ge-0/0/2.0',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '766023',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1501251026) 173 days, 18:08:30.26',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/2.0',
                        IFNUMBER         => '507',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '13561778',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '1000000000',
                        IFSTATUS         => '7',
                        IFTYPE           => '53',
                        MAC              => '2C:6B:F5:9B:48:82'
                    },
                    {
                        IFDESCR          => 'ge-0/0/3',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '3333121183',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1485512394) 171 days, 22:25:23.94',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/3',
                        IFNUMBER         => '508',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '846561719',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '1000000000',
                        IFSTATUS         => '1',
                        IFTYPE           => '6',
                        MAC              => '2C:6B:F5:9B:48:83'
                    },
                    {
                        IFDESCR          => 'ge-0/0/3.0',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '31352',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1485512394) 171 days, 22:25:23.94',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/3.0',
                        IFNUMBER         => '509',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '667472987',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '1000000000',
                        IFSTATUS         => '1',
                        IFTYPE           => '53',
                        MAC              => '2C:6B:F5:9B:48:83'
                    },
                    {
                        IFDESCR          => 'ge-0/0/4',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '2623698044',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1547843164) 179 days, 3:33:51.64',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/4',
                        IFNUMBER         => '510',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '4057307380',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '100000000',
                        IFSTATUS         => '2',
                        IFTYPE           => '6',
                        MAC              => '2C:6B:F5:9B:48:84'
                    },
                    {
                        IFDESCR          => 'ge-0/0/4.0',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '2085494',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1547843164) 179 days, 3:33:51.64',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/4.0',
                        IFNUMBER         => '511',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '40748111',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '1000000000',
                        IFSTATUS         => '7',
                        IFTYPE           => '53',
                        MAC              => '2C:6B:F5:9B:48:84'
                    },
                    {
                        IFDESCR          => 'ge-0/0/5',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '0',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/5',
                        IFNUMBER         => '512',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '0',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '1000000000',
                        IFSTATUS         => '2',
                        IFTYPE           => '6',
                        MAC              => '2C:6B:F5:9B:48:85'
                    },
                    {
                        IFDESCR          => 'ge-0/0/5.0',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '0',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/5.0',
                        IFNUMBER         => '513',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '0',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '1000000000',
                        IFSTATUS         => '7',
                        IFTYPE           => '53',
                        MAC              => '2C:6B:F5:9B:48:85'
                    },
                    {
                        IFDESCR          => 'ge-0/0/6',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '620574',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(250446944) 28 days, 23:41:09.44',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/6',
                        IFNUMBER         => '514',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '10228408',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '1000000000',
                        IFSTATUS         => '2',
                        IFTYPE           => '6',
                        MAC              => '2C:6B:F5:9B:48:86'
                    },
                    {
                        IFDESCR          => 'ge-0/0/6.0',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '75363',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(250446944) 28 days, 23:41:09.44',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/6.0',
                        IFNUMBER         => '515',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '384364',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '1000000000',
                        IFSTATUS         => '7',
                        IFTYPE           => '53',
                        MAC              => '2C:6B:F5:9B:48:86'
                    },
                    {
                        IFDESCR          => 'ge-0/0/7',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '12346184',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(251603028) 29 days, 2:53:50.28',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/7',
                        IFNUMBER         => '516',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '67868236',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '1000000000',
                        IFSTATUS         => '2',
                        IFTYPE           => '6',
                        MAC              => '2C:6B:F5:9B:48:87'
                    },
                    {
                        IFDESCR          => 'ge-0/0/7.0',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '50345',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(251603028) 29 days, 2:53:50.28',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/7.0',
                        IFNUMBER         => '517',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '1308607',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '1000000000',
                        IFSTATUS         => '7',
                        IFTYPE           => '53',
                        MAC              => '2C:6B:F5:9B:48:87'
                    },
                    {
                        IFDESCR          => 'ge-0/0/8',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '2086798177',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1578982254) 182 days, 18:03:42.54',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/8',
                        IFNUMBER         => '518',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '865615864',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '1000000000',
                        IFSTATUS         => '1',
                        IFTYPE           => '6',
                        MAC              => '2C:6B:F5:9B:48:88'
                    },
                    {
                        IFDESCR          => 'ge-0/0/8.0',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '5801536',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1578982254) 182 days, 18:03:42.54',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/8.0',
                        IFNUMBER         => '519',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '576687990',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '100000000',
                        IFSTATUS         => '1',
                        IFTYPE           => '53',
                        MAC              => '2C:6B:F5:9B:48:88'
                    },
                    {
                        IFDESCR          => 'ge-0/0/9',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '0',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/9',
                        IFNUMBER         => '520',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '0',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '1000000000',
                        IFSTATUS         => '2',
                        IFTYPE           => '6',
                        MAC              => '2C:6B:F5:9B:48:89'
                    },
                    {
                        IFDESCR          => 'ge-0/0/9.0',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '0',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/9.0',
                        IFNUMBER         => '521',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '0',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '1000000000',
                        IFSTATUS         => '7',
                        IFTYPE           => '53',
                        MAC              => '2C:6B:F5:9B:48:89'
                    },
                    {
                        IFDESCR          => 'ge-0/0/10',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '0',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/10',
                        IFNUMBER         => '522',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '0',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '1000000000',
                        IFSTATUS         => '2',
                        IFTYPE           => '6',
                        MAC              => '2C:6B:F5:9B:48:8A'
                    },
                    {
                        IFDESCR          => 'ge-0/0/10.0',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '0',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/10.0',
                        IFNUMBER         => '523',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '0',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '1000000000',
                        IFSTATUS         => '7',
                        IFTYPE           => '53',
                        MAC              => '2C:6B:F5:9B:48:8A'
                    },
                    {
                        IFDESCR          => 'ge-0/0/11',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '245249012',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1424310274) 164 days, 20:25:02.74',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/11',
                        IFNUMBER         => '524',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '2689590785',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '100000000',
                        IFSTATUS         => '1',
                        IFTYPE           => '6',
                        MAC              => '2C:6B:F5:9B:48:8B'
                    },
                    {
                        IFDESCR          => 'ge-0/0/11.0',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '3345796',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1424310274) 164 days, 20:25:02.74',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/11.0',
                        IFNUMBER         => '525',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '1022331172',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '100000000',
                        IFSTATUS         => '1',
                        IFTYPE           => '53',
                        MAC              => '2C:6B:F5:9B:48:8B'
                    },
                    {
                        IFDESCR          => 'ge-0/0/12',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '1891728511',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1441359724) 166 days, 19:46:37.24',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/12',
                        IFNUMBER         => '526',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '6496905',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '100000000',
                        IFSTATUS         => '1',
                        IFTYPE           => '6',
                        MAC              => '2C:6B:F5:9B:48:8C'
                    },
                    {
                        IFDESCR          => 'ge-0/0/12.0',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '7133205',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1441359724) 166 days, 19:46:37.24',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/12.0',
                        IFNUMBER         => '527',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '1022495546',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '100000000',
                        IFSTATUS         => '1',
                        IFTYPE           => '53',
                        MAC              => '2C:6B:F5:9B:48:8C'
                    },
                    {
                        IFDESCR          => 'ge-0/0/13',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '0',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/13',
                        IFNUMBER         => '528',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '0',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '1000000000',
                        IFSTATUS         => '2',
                        IFTYPE           => '6',
                        MAC              => '2C:6B:F5:9B:48:8D'
                    },
                    {
                        IFDESCR          => 'ge-0/0/13.0',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '0',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/13.0',
                        IFNUMBER         => '529',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '0',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '1000000000',
                        IFSTATUS         => '7',
                        IFTYPE           => '53',
                        MAC              => '2C:6B:F5:9B:48:8D'
                    },
                    {
                        IFDESCR          => 'ge-0/0/14',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '0',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/14',
                        IFNUMBER         => '530',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '0',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '1000000000',
                        IFSTATUS         => '2',
                        IFTYPE           => '6',
                        MAC              => '2C:6B:F5:9B:48:8E'
                    },
                    {
                        IFDESCR          => 'ge-0/0/14.0',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '0',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/14.0',
                        IFNUMBER         => '531',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '0',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '1000000000',
                        IFSTATUS         => '7',
                        IFTYPE           => '53',
                        MAC              => '2C:6B:F5:9B:48:8E'
                    },
                    {
                        IFDESCR          => 'ge-0/0/15',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '2031804275',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1578486224) 182 days, 16:41:02.24',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/15',
                        IFNUMBER         => '532',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '3490600419',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '1000000000',
                        IFSTATUS         => '1',
                        IFTYPE           => '6',
                        MAC              => '2C:6B:F5:9B:48:8F'
                    },
                    {
                        IFDESCR          => 'ge-0/0/15.0',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '5712789',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1578486224) 182 days, 16:41:02.24',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/15.0',
                        IFNUMBER         => '533',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '723121448',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '10000000',
                        IFSTATUS         => '1',
                        IFTYPE           => '53',
                        MAC              => '2C:6B:F5:9B:48:8F'
                    },
                    {
                        IFDESCR          => 'ge-0/0/16',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '0',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/16',
                        IFNUMBER         => '534',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '0',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '1000000000',
                        IFSTATUS         => '2',
                        IFTYPE           => '6',
                        MAC              => '2C:6B:F5:9B:48:90'
                    },
                    {
                        IFDESCR          => 'ge-0/0/16.0',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '0',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/16.0',
                        IFNUMBER         => '535',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '0',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '1000000000',
                        IFSTATUS         => '7',
                        IFTYPE           => '53',
                        MAC              => '2C:6B:F5:9B:48:90'
                    },
                    {
                        IFDESCR          => 'ge-0/0/17',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '514989432',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1544196424) 178 days, 17:26:04.24',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/17',
                        IFNUMBER         => '536',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '2004357564',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '1000000000',
                        IFSTATUS         => '1',
                        IFTYPE           => '6',
                        MAC              => '2C:6B:F5:9B:48:91'
                    },
                    {
                        IFDESCR          => 'ge-0/0/17.0',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '12390212',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1544196424) 178 days, 17:26:04.24',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/17.0',
                        IFNUMBER         => '537',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '1024363386',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '10000000',
                        IFSTATUS         => '1',
                        IFTYPE           => '53',
                        MAC              => '2C:6B:F5:9B:48:91'
                    },
                    {
                        IFDESCR          => 'ge-0/0/18',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '1493202',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(958677754) 110 days, 22:59:37.54',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/18',
                        IFNUMBER         => '538',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '559200749',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '100000000',
                        IFSTATUS         => '1',
                        IFTYPE           => '6',
                        MAC              => '2C:6B:F5:9B:48:92'
                    },
                    {
                        IFDESCR          => 'ge-0/0/18.0',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '0',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(958677754) 110 days, 22:59:37.54',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/18.0',
                        IFNUMBER         => '539',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '435817132',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '1000000000',
                        IFSTATUS         => '1',
                        IFTYPE           => '53',
                        MAC              => '2C:6B:F5:9B:48:92'
                    },
                    {
                        IFDESCR          => 'ge-0/0/19',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '0',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/19',
                        IFNUMBER         => '540',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '0',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '1000000000',
                        IFSTATUS         => '2',
                        IFTYPE           => '6',
                        MAC              => '2C:6B:F5:9B:48:93'
                    },
                    {
                        IFDESCR          => 'ge-0/0/19.0',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '0',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/19.0',
                        IFNUMBER         => '541',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '0',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '1000000000',
                        IFSTATUS         => '7',
                        IFTYPE           => '53',
                        MAC              => '2C:6B:F5:9B:48:93'
                    },
                    {
                        IFDESCR          => 'ge-0/0/20',
                        IFINERRORS       => '0',
                        IFINOCTETS       => '951730651',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1578927064) 182 days, 17:54:30.64',
                        IFMTU            => '1514',
                        IFNAME           => 'ge-0/0/20',
                        IFNUMBER         => '542',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '3733951690',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '1000000000',
                        IFSTATUS         => '1',
                        IFTYPE           => '6',
                        MAC              => '2C:6B:F5:9B:48:94'
                    },
                    {
                        IFSPEED          => '1000000000',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFDESCR          => 'ge-0/0/20.0',
                        IFNUMBER         => '543',
                        IFLASTCHANGE     => '(1578927064) 182 days, 17:54:30.64',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '952648962',
                        IFNAME           => 'ge-0/0/20.0',
                        IFTYPE           => '53',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2249453',
                        IFSTATUS         => '1',
                        MAC              => '2C:6B:F5:9B:48:94'
                    },
                    {
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '630699913',
                        IFSTATUS         => '1',
                        IFNAME           => 'ge-0/0/21',
                        IFTYPE           => '6',
                        IFLASTCHANGE     => '(1578418614) 182 days, 16:29:46.14',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '4030961043',
                        IFDESCR          => 'ge-0/0/21',
                        IFNUMBER         => '544',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '1000000000',
                        MAC              => '2C:6B:F5:9B:48:95'
                    },
                    {
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '1000000000',
                        IFSTATUS         => '1',
                        IFINOCTETS       => '114948',
                        IFPORTDUPLEX     => '3',
                        IFTYPE           => '53',
                        IFNAME           => 'ge-0/0/21.0',
                        IFOUTOCTETS      => '151247500',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1578418614) 182 days, 16:29:46.14',
                        IFNUMBER         => '545',
                        IFDESCR          => 'ge-0/0/21.0',
                        MAC              => '2C:6B:F5:9B:48:95'
                    },
                    {
                        IFOUTOCTETS      => '0',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFMTU            => '1514',
                        IFNUMBER         => '546',
                        IFDESCR          => 'ge-0/0/22',
                        IFSTATUS         => '2',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-0/0/22',
                        IFINERRORS       => '0',
                        IFSPEED          => '1000000000',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        MAC              => '2C:6B:F5:9B:48:96'
                    },
                    {
                        IFINERRORS       => '0',
                        IFSPEED          => '1000000000',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '0',
                        IFDESCR          => 'ge-0/0/22.0',
                        IFNUMBER         => '547',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFSTATUS         => '7',
                        IFNAME           => 'ge-0/0/22.0',
                        IFTYPE           => '53',
                        MAC              => '2C:6B:F5:9B:48:96'
                    },
                    {
                        IFSTATUS         => '2',
                        IFINOCTETS       => '0',
                        IFPORTDUPLEX     => '3',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-0/0/23',
                        IFOUTOCTETS      => '0',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFMTU            => '1514',
                        IFNUMBER         => '548',
                        IFDESCR          => 'ge-0/0/23',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '1000000000',
                        MAC              => '2C:6B:F5:9B:48:97'
                    },
                    {
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '0',
                        IFDESCR          => 'ge-0/0/23.0',
                        IFNUMBER         => '549',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFSTATUS         => '7',
                        IFNAME           => 'ge-0/0/23.0',
                        IFTYPE           => '53',
                        IFINERRORS       => '0',
                        IFSPEED          => '1000000000',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        MAC              => '2C:6B:F5:9B:48:97'
                    },
                    {
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '1000000000',
                        IFINERRORS       => '0',
                        IFNAME           => 'ge-0/0/24',
                        IFTYPE           => '6',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFSTATUS         => '2',
                        IFDESCR          => 'ge-0/0/24',
                        IFNUMBER         => '550',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFOUTOCTETS      => '0',
                        MAC              => '2C:6B:F5:9B:48:98'
                    },
                    {
                        IFINERRORS       => '0',
                        IFSPEED          => '1000000000',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '0',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFMTU            => '1514',
                        IFNUMBER         => '551',
                        IFDESCR          => 'ge-0/0/24.0',
                        IFSTATUS         => '7',
                        IFINOCTETS       => '0',
                        IFPORTDUPLEX     => '3',
                        IFTYPE           => '53',
                        IFNAME           => 'ge-0/0/24.0',
                        MAC              => '2C:6B:F5:9B:48:98'
                    },
                    {
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '1000000000',
                        IFINOCTETS       => '0',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '2',
                        IFNAME           => 'ge-0/0/25',
                        IFTYPE           => '6',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '0',
                        IFDESCR          => 'ge-0/0/25',
                        IFNUMBER         => '552',
                        MAC              => '2C:6B:F5:9B:48:99'
                    },
                    {
                        IFINERRORS       => '0',
                        IFSPEED          => '1000000000',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFOUTOCTETS      => '0',
                        IFDESCR          => 'ge-0/0/25.0',
                        IFNUMBER         => '553',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFSTATUS         => '7',
                        IFNAME           => 'ge-0/0/25.0',
                        IFTYPE           => '53',
                        MAC              => '2C:6B:F5:9B:48:99'
                    },
                    {
                        IFSPEED          => '1000000000',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFDESCR          => 'ge-0/0/26',
                        IFNUMBER         => '554',
                        IFLASTCHANGE     => '(1579124494) 182 days, 18:27:24.94',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '580268911',
                        IFNAME           => 'ge-0/0/26',
                        IFTYPE           => '6',
                        IFINOCTETS       => '2253413489',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '1',
                        MAC              => '2C:6B:F5:9B:48:9A'
                    },
                    {
                        IFSPEED          => '10000000',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFDESCR          => 'ge-0/0/26.0',
                        IFNUMBER         => '555',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1579124494) 182 days, 18:27:24.94',
                        IFOUTOCTETS      => '263400955',
                        IFNAME           => 'ge-0/0/26.0',
                        IFTYPE           => '53',
                        IFINOCTETS       => '3686909',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '1',
                        MAC              => '2C:6B:F5:9B:48:9A'
                    },
                    {
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '1000000000',
                        IFINERRORS       => '0',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-0/0/27',
                        IFSTATUS         => '1',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3044249961',
                        IFNUMBER         => '556',
                        IFDESCR          => 'ge-0/0/27',
                        IFOUTOCTETS      => '3810217102',
                        IFLASTCHANGE     => '(1579123944) 182 days, 18:27:19.44',
                        IFMTU            => '1514',
                        MAC              => '2C:6B:F5:9B:48:9B'
                    },
                    {
                        IFSTATUS         => '1',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '13839122',
                        IFTYPE           => '53',
                        IFNAME           => 'ge-0/0/27.0',
                        IFOUTOCTETS      => '206015125',
                        IFLASTCHANGE     => '(1579123944) 182 days, 18:27:19.44',
                        IFMTU            => '1514',
                        IFNUMBER         => '557',
                        IFDESCR          => 'ge-0/0/27.0',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '1000000000',
                        MAC              => '2C:6B:F5:9B:48:9B'
                    },
                    {
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '1000000000',
                        IFINERRORS       => '10',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-0/0/28',
                        IFSTATUS         => '1',
                        IFINOCTETS       => '285662439',
                        IFPORTDUPLEX     => '3',
                        IFNUMBER         => '558',
                        IFDESCR          => 'ge-0/0/28',
                        IFOUTOCTETS      => '3058559542',
                        IFLASTCHANGE     => '(1570984464) 181 days, 19:50:44.64',
                        IFMTU            => '1514',
                        MAC              => '2C:6B:F5:9B:48:9C'
                    },
                    {
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '1000000000',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '25800',
                        IFSTATUS         => '1',
                        IFNAME           => 'ge-0/0/28.0',
                        IFTYPE           => '53',
                        IFLASTCHANGE     => '(1570984464) 181 days, 19:50:44.64',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '201670561',
                        IFDESCR          => 'ge-0/0/28.0',
                        IFNUMBER         => '559',
                        MAC              => '2C:6B:F5:9B:48:9C'
                    },
                    {
                        IFINERRORS       => '0',
                        IFSPEED          => '1000000000',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '0',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFMTU            => '1514',
                        IFNUMBER         => '560',
                        IFDESCR          => 'ge-0/0/29',
                        IFSTATUS         => '2',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-0/0/29',
                        MAC              => '2C:6B:F5:9B:48:9D'
                    },
                    {
                        IFSPEED          => '1000000000',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFDESCR          => 'ge-0/0/29.0',
                        IFNUMBER         => '561',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFOUTOCTETS      => '0',
                        IFNAME           => 'ge-0/0/29.0',
                        IFTYPE           => '53',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFSTATUS         => '7',
                        MAC              => '2C:6B:F5:9B:48:9D'
                    },
                    {
                        IFINERRORS       => '0',
                        IFSPEED          => '1000000000',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '0',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFNUMBER         => '562',
                        IFDESCR          => 'ge-0/0/30',
                        IFSTATUS         => '2',
                        IFINOCTETS       => '0',
                        IFPORTDUPLEX     => '3',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-0/0/30',
                        MAC              => '2C:6B:F5:9B:48:9E'
                    },
                    {
                        IFSPEED          => '1000000000',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFNUMBER         => '563',
                        IFDESCR          => 'ge-0/0/30.0',
                        IFOUTOCTETS      => '0',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFMTU            => '1514',
                        IFTYPE           => '53',
                        IFNAME           => 'ge-0/0/30.0',
                        IFSTATUS         => '7',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        MAC              => '2C:6B:F5:9B:48:9E'
                    },
                    {
                        IFNUMBER         => '564',
                        IFDESCR          => 'ge-0/0/31',
                        IFOUTOCTETS      => '0',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-0/0/31',
                        IFSTATUS         => '2',
                        IFINOCTETS       => '0',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '1000000000',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        MAC              => '2C:6B:F5:9B:48:9F'
                    },
                    {
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '1000000000',
                        IFINERRORS       => '0',
                        IFNAME           => 'ge-0/0/31.0',
                        IFTYPE           => '53',
                        IFINOCTETS       => '0',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '7',
                        IFDESCR          => 'ge-0/0/31.0',
                        IFNUMBER         => '565',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFOUTOCTETS      => '0',
                        MAC              => '2C:6B:F5:9B:48:9F'
                    },
                    {
                        IFSTATUS         => '2',
                        IFINOCTETS       => '0',
                        IFPORTDUPLEX     => '3',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-0/0/32',
                        IFOUTOCTETS      => '0',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFMTU            => '1514',
                        IFNUMBER         => '566',
                        IFDESCR          => 'ge-0/0/32',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '1000000000',
                        MAC              => '2C:6B:F5:9B:48:A0'
                    },
                    {
                        IFNUMBER         => '567',
                        IFDESCR          => 'ge-0/0/32.0',
                        IFOUTOCTETS      => '0',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFMTU            => '1514',
                        IFTYPE           => '53',
                        IFNAME           => 'ge-0/0/32.0',
                        IFSTATUS         => '7',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFSPEED          => '1000000000',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        MAC              => '2C:6B:F5:9B:48:A0'
                    },
                    {
                        IFTYPE           => '6',
                        IFNAME           => 'ge-0/0/33',
                        IFSTATUS         => '1',
                        IFINOCTETS       => '2905938019',
                        IFPORTDUPLEX     => '3',
                        IFNUMBER         => '568',
                        IFDESCR          => 'ge-0/0/33',
                        IFOUTOCTETS      => '2493025772',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1579011084) 182 days, 18:08:30.84',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '1000000000',
                        IFINERRORS       => '0',
                        MAC              => '2C:6B:F5:9B:48:A1'
                    },
                    {
                        IFNUMBER         => '569',
                        IFDESCR          => 'ge-0/0/33.0',
                        IFOUTOCTETS      => '564930997',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1579011084) 182 days, 18:08:30.84',
                        IFTYPE           => '53',
                        IFNAME           => 'ge-0/0/33.0',
                        IFSTATUS         => '1',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '9569516',
                        IFSPEED          => '10000000',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        MAC              => '2C:6B:F5:9B:48:A1'
                    },
                    {
                        IFDESCR          => 'ge-0/0/34',
                        IFNUMBER         => '570',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFOUTOCTETS      => '0',
                        IFNAME           => 'ge-0/0/34',
                        IFTYPE           => '6',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFSTATUS         => '2',
                        IFSPEED          => '1000000000',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        MAC              => '2C:6B:F5:9B:48:A2'
                    },
                    {
                        IFINERRORS       => '0',
                        IFSPEED          => '1000000000',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '0',
                        IFDESCR          => 'ge-0/0/34.0',
                        IFNUMBER         => '571',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFSTATUS         => '7',
                        IFNAME           => 'ge-0/0/34.0',
                        IFTYPE           => '53',
                        MAC              => '2C:6B:F5:9B:48:A2'
                    },
                    {
                        IFSPEED          => '100000000',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFNUMBER         => '572',
                        IFDESCR          => 'ge-0/0/35',
                        IFOUTOCTETS      => '666800395',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1390704494) 160 days, 23:04:04.94',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-0/0/35',
                        IFSTATUS         => '1',
                        IFINOCTETS       => '5504522',
                        IFPORTDUPLEX     => '3',
                        MAC              => '2C:6B:F5:9B:48:A3'
                    },
                    {
                        IFINERRORS       => '0',
                        IFSPEED          => '100000000',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '1021799248',
                        IFLASTCHANGE     => '(1390704494) 160 days, 23:04:04.94',
                        IFMTU            => '1514',
                        IFNUMBER         => '573',
                        IFDESCR          => 'ge-0/0/35.0',
                        IFSTATUS         => '1',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '105099',
                        IFTYPE           => '53',
                        IFNAME           => 'ge-0/0/35.0',
                        MAC              => '2C:6B:F5:9B:48:A3'
                    },
                    {
                        IFNUMBER         => '574',
                        IFDESCR          => 'ge-0/0/36',
                        IFOUTOCTETS      => '0',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFMTU            => '1514',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-0/0/36',
                        IFSTATUS         => '2',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFSPEED          => '1000000000',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        MAC              => '2C:6B:F5:9B:48:A4'
                    },
                    {
                        IFSTATUS         => '7',
                        IFINOCTETS       => '0',
                        IFPORTDUPLEX     => '3',
                        IFTYPE           => '53',
                        IFNAME           => 'ge-0/0/36.0',
                        IFOUTOCTETS      => '0',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFNUMBER         => '575',
                        IFDESCR          => 'ge-0/0/36.0',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '1000000000',
                        MAC              => '2C:6B:F5:9B:48:A4'
                    },
                    {
                        IFLASTCHANGE     => '(1442498948) 166 days, 22:56:29.48',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '485268381',
                        IFDESCR          => 'ge-0/0/37',
                        IFNUMBER         => '576',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '28250947',
                        IFSTATUS         => '2',
                        IFNAME           => 'ge-0/0/37',
                        IFTYPE           => '6',
                        IFINERRORS       => '0',
                        IFSPEED          => '1000000000',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        MAC              => '2C:6B:F5:9B:48:A5'
                    },
                    {
                        IFINERRORS       => '0',
                        IFSPEED          => '1000000000',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '1742789',
                        IFLASTCHANGE     => '(1442498948) 166 days, 22:56:29.48',
                        IFMTU            => '1514',
                        IFNUMBER         => '577',
                        IFDESCR          => 'ge-0/0/37.0',
                        IFSTATUS         => '7',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '129766',
                        IFTYPE           => '53',
                        IFNAME           => 'ge-0/0/37.0',
                        MAC              => '2C:6B:F5:9B:48:A5'
                    },
                    {
                        IFSTATUS         => '2',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '47896873',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-0/0/38',
                        IFOUTOCTETS      => '771874861',
                        IFLASTCHANGE     => '(1086769174) 125 days, 18:48:11.74',
                        IFMTU            => '1514',
                        IFNUMBER         => '578',
                        IFDESCR          => 'ge-0/0/38',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '1000000000',
                        MAC              => '2C:6B:F5:9B:48:A6'
                    },
                    {
                        IFNUMBER         => '579',
                        IFDESCR          => 'ge-0/0/38.0',
                        IFOUTOCTETS      => '207932553',
                        IFLASTCHANGE     => '(1086769174) 125 days, 18:48:11.74',
                        IFMTU            => '1514',
                        IFTYPE           => '53',
                        IFNAME           => 'ge-0/0/38.0',
                        IFSTATUS         => '7',
                        IFINOCTETS       => '153752',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '10000000',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        MAC              => '2C:6B:F5:9B:48:A6'
                    },
                    {
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '10000000',
                        IFINERRORS       => '0',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-0/0/39',
                        IFSTATUS         => '2',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2340866',
                        IFNUMBER         => '580',
                        IFDESCR          => 'ge-0/0/39',
                        IFOUTOCTETS      => '3301053918',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1207397316) 139 days, 17:52:53.16',
                        MAC              => '2C:6B:F5:9B:48:A7'
                    },
                    {
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '10000000',
                        IFSTATUS         => '7',
                        IFINOCTETS       => '36715',
                        IFPORTDUPLEX     => '3',
                        IFTYPE           => '53',
                        IFNAME           => 'ge-0/0/39.0',
                        IFOUTOCTETS      => '756967915',
                        IFLASTCHANGE     => '(1207397316) 139 days, 17:52:53.16',
                        IFMTU            => '1514',
                        IFNUMBER         => '581',
                        IFDESCR          => 'ge-0/0/39.0',
                        MAC              => '2C:6B:F5:9B:48:A7'
                    },
                    {
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '1000000000',
                        IFINERRORS       => '0',
                        IFNAME           => 'ge-0/0/40',
                        IFTYPE           => '6',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFSTATUS         => '2',
                        IFDESCR          => 'ge-0/0/40',
                        IFNUMBER         => '582',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '0',
                        MAC              => '2C:6B:F5:9B:48:A8'
                    },
                    {
                        IFOUTOCTETS      => '0',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFNUMBER         => '583',
                        IFDESCR          => 'ge-0/0/40.0',
                        IFSTATUS         => '7',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFTYPE           => '53',
                        IFNAME           => 'ge-0/0/40.0',
                        IFINERRORS       => '0',
                        IFSPEED          => '1000000000',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        MAC              => '2C:6B:F5:9B:48:A8'
                    },
                    {
                        IFTYPE           => '6',
                        IFNAME           => 'ge-0/0/41',
                        IFSTATUS         => '2',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFNUMBER         => '584',
                        IFDESCR          => 'ge-0/0/41',
                        IFOUTOCTETS      => '0',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFMTU            => '1514',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '1000000000',
                        IFINERRORS       => '0',
                        MAC              => '2C:6B:F5:9B:48:A9'
                    },
                    {
                        IFINERRORS       => '0',
                        IFSPEED          => '1000000000',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFOUTOCTETS      => '0',
                        IFDESCR          => 'ge-0/0/41.0',
                        IFNUMBER         => '585',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFSTATUS         => '7',
                        IFNAME           => 'ge-0/0/41.0',
                        IFTYPE           => '53',
                        MAC              => '2C:6B:F5:9B:48:A9'
                    },
                    {
                        IFTYPE           => '6',
                        IFNAME           => 'ge-0/0/42',
                        IFSTATUS         => '2',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFNUMBER         => '586',
                        IFDESCR          => 'ge-0/0/42',
                        IFOUTOCTETS      => '0',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '1000000000',
                        IFINERRORS       => '0',
                        MAC              => '2C:6B:F5:9B:48:AA'
                    },
                    {
                        IFNAME           => 'ge-0/0/42.0',
                        IFTYPE           => '53',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFSTATUS         => '7',
                        IFDESCR          => 'ge-0/0/42.0',
                        IFNUMBER         => '587',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '1000000000',
                        IFINERRORS       => '0',
                        MAC              => '2C:6B:F5:9B:48:AA'
                    },
                    {
                        IFNUMBER         => '588',
                        IFDESCR          => 'ge-0/0/43',
                        IFOUTOCTETS      => '0',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFMTU            => '1514',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-0/0/43',
                        IFSTATUS         => '2',
                        IFINOCTETS       => '0',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '1000000000',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        MAC              => '2C:6B:F5:9B:48:AB'
                    },
                    {
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFSTATUS         => '7',
                        IFNAME           => 'ge-0/0/43.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFOUTOCTETS      => '0',
                        IFDESCR          => 'ge-0/0/43.0',
                        IFNUMBER         => '589',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '1000000000',
                        MAC              => '2C:6B:F5:9B:48:AB'
                    },
                    {
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '1000000000',
                        IFSTATUS         => '2',
                        IFINOCTETS       => '0',
                        IFPORTDUPLEX     => '3',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-0/0/44',
                        IFOUTOCTETS      => '0',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFNUMBER         => '590',
                        IFDESCR          => 'ge-0/0/44',
                        MAC              => '2C:6B:F5:9B:48:AC'
                    },
                    {
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '1000000000',
                        IFINERRORS       => '0',
                        IFNAME           => 'ge-0/0/44.0',
                        IFTYPE           => '53',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFSTATUS         => '7',
                        IFDESCR          => 'ge-0/0/44.0',
                        IFNUMBER         => '591',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '0',
                        MAC              => '2C:6B:F5:9B:48:AC'
                    },
                    {
                        IFINERRORS       => '4',
                        IFSPEED          => '100000000',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFLASTCHANGE     => '(1574449874) 182 days, 5:28:18.74',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '3415014528',
                        IFDESCR          => 'ge-0/0/45',
                        IFNUMBER         => '592',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2047226430',
                        IFSTATUS         => '2',
                        IFNAME           => 'ge-0/0/45',
                        IFTYPE           => '6',
                        MAC              => '2C:6B:F5:9B:48:AD'
                    },
                    {
                        IFNUMBER         => '593',
                        IFDESCR          => 'ge-0/0/45.0',
                        IFOUTOCTETS      => '14671618',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1574449874) 182 days, 5:28:18.74',
                        IFTYPE           => '53',
                        IFNAME           => 'ge-0/0/45.0',
                        IFSTATUS         => '7',
                        IFINOCTETS       => '386668',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '1000000000',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        MAC              => '2C:6B:F5:9B:48:AD'
                    },
                    {
                        IFLASTCHANGE     => '(1554279644) 179 days, 21:26:36.44',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '961673912',
                        IFDESCR          => 'ge-0/0/46',
                        IFNUMBER         => '594',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '4080782095',
                        IFSTATUS         => '1',
                        IFNAME           => 'ge-0/0/46',
                        IFTYPE           => '6',
                        IFINERRORS       => '0',
                        IFSPEED          => '1000000000',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        MAC              => '2C:6B:F5:9B:48:AE'
                    },
                    {
                        IFSPEED          => '10000000',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFDESCR          => 'ge-0/0/46.0',
                        IFNUMBER         => '595',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1554279644) 179 days, 21:26:36.44',
                        IFOUTOCTETS      => '1023840701',
                        IFNAME           => 'ge-0/0/46.0',
                        IFTYPE           => '53',
                        IFINOCTETS       => '7598296',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '1',
                        MAC              => '2C:6B:F5:9B:48:AE'
                    },
                    {
                        IFOUTOCTETS      => '3200792434',
                        IFLASTCHANGE     => '(1512743176) 175 days, 2:03:51.76',
                        IFMTU            => '1514',
                        IFNUMBER         => '596',
                        IFDESCR          => 'ge-0/0/47',
                        IFSTATUS         => '2',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2316772724',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-0/0/47',
                        IFINERRORS       => '0',
                        IFSPEED          => '1000000000',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        MAC              => '2C:6B:F5:9B:48:AF'
                    },
                    {
                        IFDESCR          => 'ge-0/0/47.0',
                        IFNUMBER         => '597',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1512743176) 175 days, 2:03:51.76',
                        IFOUTOCTETS      => '60956226',
                        IFNAME           => 'ge-0/0/47.0',
                        IFTYPE           => '53',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1781000',
                        IFSTATUS         => '7',
                        IFSPEED          => '1000000000',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        MAC              => '2C:6B:F5:9B:48:AF'
                    },
                    {
                        IFOUTOCTETS      => '762086845',
                        IFMTU            => '1500',
                        IFLASTCHANGE     => '(668) 0:00:06.68',
                        IFNUMBER         => '598',
                        IFDESCR          => 'vlan.0',
                        IFSTATUS         => '1',
                        IFINOCTETS       => '593793507',
                        IFTYPE           => '53',
                        IFNAME           => 'vlan.0',
                        IFINERRORS       => '0',
                        IFSPEED          => '1000000000',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        MAC              => '2C:6B:F5:9B:48:80'
                    },
                    {
                        IFOUTOCTETS      => '2251187669',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(717450883) 83 days, 0:55:08.83',
                        IFNUMBER         => '599',
                        IFDESCR          => 'ge-1/0/0',
                        IFSTATUS         => '1',
                        IFINOCTETS       => '2135333642',
                        IFPORTDUPLEX     => '3',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-1/0/0',
                        IFINERRORS       => '0',
                        IFSPEED          => '1000000000',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        MAC              => '2C:6B:F5:9B:48:81'
                    },
                    {
                        IFSPEED          => '100000000',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFDESCR          => 'ge-1/0/1',
                        IFNUMBER         => '600',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(717450534) 83 days, 0:55:05.34',
                        IFOUTOCTETS      => '0',
                        IFNAME           => 'ge-1/0/1',
                        IFTYPE           => '6',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFSTATUS         => '2',
                        MAC              => '2C:6B:F5:9B:48:81'
                    },
                    {
                        IFSTATUS         => '1',
                        IFINOCTETS       => '1298647280',
                        IFPORTDUPLEX     => '3',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-1/0/2',
                        IFOUTOCTETS      => '2001027785',
                        IFLASTCHANGE     => '(1518159237) 175 days, 17:06:32.37',
                        IFMTU            => '1514',
                        IFNUMBER         => '601',
                        IFDESCR          => 'ge-1/0/2',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '1000000000',
                        MAC              => '2C:6B:F5:9B:48:82'
                    },
                    {
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '0',
                        IFLASTCHANGE     => '(717450566) 83 days, 0:55:05.66',
                        IFMTU            => '1514',
                        IFNUMBER         => '602',
                        IFDESCR          => 'ge-1/0/3',
                        IFSTATUS         => '2',
                        IFINOCTETS       => '0',
                        IFPORTDUPLEX     => '3',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-1/0/3',
                        MAC              => '2C:6B:F5:9B:48:83'
                    },
                    {
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1579371027) 182 days, 19:08:30.27',
                        IFOUTOCTETS      => '1396723681',
                        IFDESCR          => 'ge-1/0/4',
                        IFNUMBER         => '603',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '269999393',
                        IFSTATUS         => '1',
                        IFNAME           => 'ge-1/0/4',
                        IFTYPE           => '6',
                        IFINERRORS       => '12',
                        IFSPEED          => '1000000000',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        MAC              => '2C:6B:F5:9B:48:84'
                    },
                    {
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        IFSTATUS         => '2',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-1/0/5',
                        IFOUTOCTETS      => '0',
                        IFLASTCHANGE     => '(717450580) 83 days, 0:55:05.80',
                        IFMTU            => '1514',
                        IFNUMBER         => '604',
                        IFDESCR          => 'ge-1/0/5',
                        MAC              => '2C:6B:F5:9B:48:85'
                    },
                    {
                        IFINERRORS       => '0',
                        IFSPEED          => '1000000000',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1303083182) 150 days, 19:40:31.82',
                        IFOUTOCTETS      => '74508102',
                        IFDESCR          => 'ge-1/0/6',
                        IFNUMBER         => '605',
                        IFINOCTETS       => '3005189',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '2',
                        IFNAME           => 'ge-1/0/6',
                        IFTYPE           => '6',
                        MAC              => '2C:6B:F5:9B:48:86'
                    },
                    {
                        IFNUMBER         => '606',
                        IFDESCR          => 'ge-1/0/7',
                        IFOUTOCTETS      => '0',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(717450594) 83 days, 0:55:05.94',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-1/0/7',
                        IFSTATUS         => '2',
                        IFINOCTETS       => '0',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        MAC              => '2C:6B:F5:9B:48:87'
                    },
                    {
                        IFSTATUS         => '2',
                        IFINOCTETS       => '0',
                        IFPORTDUPLEX     => '3',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-1/0/8',
                        IFOUTOCTETS      => '0',
                        IFLASTCHANGE     => '(717450596) 83 days, 0:55:05.96',
                        IFMTU            => '1514',
                        IFNUMBER         => '607',
                        IFDESCR          => 'ge-1/0/8',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        MAC              => '2C:6B:F5:9B:48:88'
                    },
                    {
                        IFOUTOCTETS      => '816666142',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1380784997) 159 days, 19:30:49.97',
                        IFNUMBER         => '608',
                        IFDESCR          => 'ge-1/0/9',
                        IFSTATUS         => '1',
                        IFINOCTETS       => '17126975',
                        IFPORTDUPLEX     => '3',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-1/0/9',
                        IFINERRORS       => '0',
                        IFSPEED          => '100000000',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        MAC              => '2C:6B:F5:9B:48:89'
                    },
                    {
                        IFNUMBER         => '609',
                        IFDESCR          => 'ge-1/0/10',
                        IFOUTOCTETS      => '0',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(717450601) 83 days, 0:55:06.01',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-1/0/10',
                        IFSTATUS         => '2',
                        IFINOCTETS       => '0',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        MAC              => '2C:6B:F5:9B:48:8A'
                    },
                    {
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '18',
                        IFSPEED          => '100000000',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1788658958',
                        IFSTATUS         => '2',
                        IFNAME           => 'ge-1/0/11',
                        IFTYPE           => '6',
                        IFLASTCHANGE     => '(1564125317) 181 days, 0:47:33.17',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '792282323',
                        IFDESCR          => 'ge-1/0/11',
                        IFNUMBER         => '610',
                        MAC              => '2C:6B:F5:9B:48:8B'
                    },
                    {
                        IFSTATUS         => '2',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '226432893',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-1/0/12',
                        IFOUTOCTETS      => '1621258788',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1573444441) 182 days, 2:40:44.41',
                        IFNUMBER         => '611',
                        IFDESCR          => 'ge-1/0/12',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '1000000000',
                        MAC              => '2C:6B:F5:9B:48:8C'
                    },
                    {
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        IFSTATUS         => '2',
                        IFINOCTETS       => '0',
                        IFPORTDUPLEX     => '3',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-1/0/13',
                        IFOUTOCTETS      => '0',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(717450613) 83 days, 0:55:06.13',
                        IFNUMBER         => '612',
                        IFDESCR          => 'ge-1/0/13',
                        MAC              => '2C:6B:F5:9B:48:8D'
                    },
                    {
                        IFNAME           => 'ge-1/0/14',
                        IFTYPE           => '6',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3939751043',
                        IFSTATUS         => '1',
                        IFDESCR          => 'ge-1/0/14',
                        IFNUMBER         => '613',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(717452073) 83 days, 0:55:20.73',
                        IFOUTOCTETS      => '287056337',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '1000000000',
                        IFINERRORS       => '0',
                        MAC              => '2C:6B:F5:9B:48:8E'
                    },
                    {
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFNAME           => 'ge-1/0/15',
                        IFTYPE           => '6',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFSTATUS         => '2',
                        IFDESCR          => 'ge-1/0/15',
                        IFNUMBER         => '614',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(717450621) 83 days, 0:55:06.21',
                        IFOUTOCTETS      => '0',
                        MAC              => '2C:6B:F5:9B:48:8F'
                    },
                    {
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFDESCR          => 'ge-1/0/16',
                        IFNUMBER         => '615',
                        IFLASTCHANGE     => '(717450628) 83 days, 0:55:06.28',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '0',
                        IFNAME           => 'ge-1/0/16',
                        IFTYPE           => '6',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFSTATUS         => '2',
                        MAC              => '2C:6B:F5:9B:48:90'
                    },
                    {
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        IFINOCTETS       => '0',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '2',
                        IFNAME           => 'ge-1/0/17',
                        IFTYPE           => '6',
                        IFLASTCHANGE     => '(717450630) 83 days, 0:55:06.30',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '0',
                        IFDESCR          => 'ge-1/0/17',
                        IFNUMBER         => '616',
                        MAC              => '2C:6B:F5:9B:48:91'
                    },
                    {
                        IFNUMBER         => '617',
                        IFDESCR          => 'ge-1/0/18',
                        IFOUTOCTETS      => '0',
                        IFLASTCHANGE     => '(717450633) 83 days, 0:55:06.33',
                        IFMTU            => '1514',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-1/0/18',
                        IFSTATUS         => '2',
                        IFINOCTETS       => '0',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        MAC              => '2C:6B:F5:9B:48:92'
                    },
                    {
                        IFINERRORS       => '0',
                        IFSPEED          => '1000000000',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFLASTCHANGE     => '(1579481427) 182 days, 19:26:54.27',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '3578805041',
                        IFDESCR          => 'ge-1/0/19',
                        IFNUMBER         => '618',
                        IFINOCTETS       => '3300639445',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '1',
                        IFNAME           => 'ge-1/0/19',
                        IFTYPE           => '6',
                        MAC              => '2C:6B:F5:9B:48:93'
                    },
                    {
                        IFNAME           => 'ge-1/0/20',
                        IFTYPE           => '6',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2439052536',
                        IFSTATUS         => '1',
                        IFDESCR          => 'ge-1/0/20',
                        IFNUMBER         => '619',
                        IFLASTCHANGE     => '(1578881557) 182 days, 17:46:55.57',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '3399781437',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '100000000',
                        IFINERRORS       => '0',
                        MAC              => '2C:6B:F5:9B:48:94'
                    },
                    {
                        IFSTATUS         => '2',
                        IFINOCTETS       => '0',
                        IFPORTDUPLEX     => '3',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-1/0/21',
                        IFOUTOCTETS      => '0',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(717450646) 83 days, 0:55:06.46',
                        IFNUMBER         => '620',
                        IFDESCR          => 'ge-1/0/21',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        MAC              => '2C:6B:F5:9B:48:95'
                    },
                    {
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFSTATUS         => '2',
                        IFNAME           => 'ge-1/0/22',
                        IFTYPE           => '6',
                        IFLASTCHANGE     => '(717450654) 83 days, 0:55:06.54',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '0',
                        IFDESCR          => 'ge-1/0/22',
                        IFNUMBER         => '621',
                        MAC              => '2C:6B:F5:9B:48:96'
                    },
                    {
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFSTATUS         => '2',
                        IFNAME           => 'ge-1/0/23',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(717450655) 83 days, 0:55:06.55',
                        IFOUTOCTETS      => '0',
                        IFDESCR          => 'ge-1/0/23',
                        IFNUMBER         => '622',
                        MAC              => '2C:6B:F5:9B:48:97'
                    },
                    {
                        IFINERRORS       => '0',
                        IFSPEED          => '100000000',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '2506332140',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1573311367) 182 days, 2:18:33.67',
                        IFNUMBER         => '623',
                        IFDESCR          => 'ge-1/0/24',
                        IFSTATUS         => '2',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2028846815',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-1/0/24',
                        MAC              => '2C:6B:F5:9B:48:98'
                    },
                    {
                        IFNUMBER         => '624',
                        IFDESCR          => 'ge-1/0/25',
                        IFOUTOCTETS      => '2549919197',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1578898697) 182 days, 17:49:46.97',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-1/0/25',
                        IFSTATUS         => '1',
                        IFINOCTETS       => '884165878',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '1000000000',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        MAC              => '2C:6B:F5:9B:48:99'
                    },
                    {
                        IFOUTOCTETS      => '56162371',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1277650841) 147 days, 21:01:48.41',
                        IFNUMBER         => '625',
                        IFDESCR          => 'ge-1/0/26',
                        IFSTATUS         => '2',
                        IFINOCTETS       => '3793046',
                        IFPORTDUPLEX     => '3',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-1/0/26',
                        IFINERRORS       => '0',
                        IFSPEED          => '1000000000',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        MAC              => '2C:6B:F5:9B:48:9A'
                    },
                    {
                        IFNUMBER         => '626',
                        IFDESCR          => 'ge-1/0/27',
                        IFOUTOCTETS      => '0',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(717450674) 83 days, 0:55:06.74',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-1/0/27',
                        IFSTATUS         => '2',
                        IFINOCTETS       => '0',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        MAC              => '2C:6B:F5:9B:48:9B'
                    },
                    {
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '10000000',
                        IFINERRORS       => '0',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-1/0/28',
                        IFSTATUS         => '2',
                        IFINOCTETS       => '4380162',
                        IFPORTDUPLEX     => '3',
                        IFNUMBER         => '627',
                        IFDESCR          => 'ge-1/0/28',
                        IFOUTOCTETS      => '12228656',
                        IFLASTCHANGE     => '(975037268) 112 days, 20:26:12.68',
                        IFMTU            => '1514',
                        MAC              => '2C:6B:F5:9B:48:9C'
                    },
                    {
                        IFINERRORS       => '0',
                        IFSPEED          => '1000000000',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1579233077) 182 days, 18:45:30.77',
                        IFOUTOCTETS      => '3111134514',
                        IFDESCR          => 'ge-1/0/29',
                        IFNUMBER         => '628',
                        IFINOCTETS       => '563115901',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '1',
                        IFNAME           => 'ge-1/0/29',
                        IFTYPE           => '6',
                        MAC              => '2C:6B:F5:9B:48:9D'
                    },
                    {
                        IFSTATUS         => '2',
                        IFINOCTETS       => '0',
                        IFPORTDUPLEX     => '3',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-1/0/30',
                        IFOUTOCTETS      => '0',
                        IFLASTCHANGE     => '(717450694) 83 days, 0:55:06.94',
                        IFMTU            => '1514',
                        IFNUMBER         => '629',
                        IFDESCR          => 'ge-1/0/30',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        MAC              => '2C:6B:F5:9B:48:9E'
                    },
                    {
                        IFLASTCHANGE     => '(717450701) 83 days, 0:55:07.01',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '0',
                        IFDESCR          => 'ge-1/0/31',
                        IFNUMBER         => '630',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFSTATUS         => '2',
                        IFNAME           => 'ge-1/0/31',
                        IFTYPE           => '6',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        MAC              => '2C:6B:F5:9B:48:9F'
                    },
                    {
                        IFSTATUS         => '2',
                        IFINOCTETS       => '0',
                        IFPORTDUPLEX     => '3',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-1/0/32',
                        IFOUTOCTETS      => '0',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(717450705) 83 days, 0:55:07.05',
                        IFNUMBER         => '631',
                        IFDESCR          => 'ge-1/0/32',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        MAC              => '2C:6B:F5:9B:48:A0'
                    },
                    {
                        IFSTATUS         => '2',
                        IFINOCTETS       => '1037085341',
                        IFPORTDUPLEX     => '3',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-1/0/33',
                        IFOUTOCTETS      => '746979838',
                        IFLASTCHANGE     => '(1564340617) 181 days, 1:23:26.17',
                        IFMTU            => '1514',
                        IFNUMBER         => '632',
                        IFDESCR          => 'ge-1/0/33',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '1000000000',
                        MAC              => '2C:6B:F5:9B:48:A1'
                    },
                    {
                        IFNUMBER         => '633',
                        IFDESCR          => 'ge-1/0/34',
                        IFOUTOCTETS      => '0',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(717450710) 83 days, 0:55:07.10',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-1/0/34',
                        IFSTATUS         => '2',
                        IFINOCTETS       => '0',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        MAC              => '2C:6B:F5:9B:48:A2'
                    },
                    {
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFSTATUS         => '2',
                        IFNAME           => 'ge-1/0/35',
                        IFTYPE           => '6',
                        IFLASTCHANGE     => '(717450713) 83 days, 0:55:07.13',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '0',
                        IFDESCR          => 'ge-1/0/35',
                        IFNUMBER         => '634',
                        MAC              => '2C:6B:F5:9B:48:A3'
                    },
                    {
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-1/0/36',
                        IFSTATUS         => '2',
                        IFINOCTETS       => '0',
                        IFPORTDUPLEX     => '3',
                        IFNUMBER         => '635',
                        IFDESCR          => 'ge-1/0/36',
                        IFOUTOCTETS      => '0',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(717450715) 83 days, 0:55:07.15',
                        MAC              => '2C:6B:F5:9B:48:A4'
                    },
                    {
                        IFSPEED          => '100000000',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFNUMBER         => '636',
                        IFDESCR          => 'ge-1/0/37',
                        IFOUTOCTETS      => '1068326842',
                        IFLASTCHANGE     => '(1563250557) 180 days, 22:21:45.57',
                        IFMTU            => '1514',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-1/0/37',
                        IFSTATUS         => '1',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '585874889',
                        MAC              => '2C:6B:F5:9B:48:A5'
                    },
                    {
                        IFNUMBER         => '637',
                        IFDESCR          => 'ge-1/0/38',
                        IFOUTOCTETS      => '0',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(717450727) 83 days, 0:55:07.27',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-1/0/38',
                        IFSTATUS         => '2',
                        IFINOCTETS       => '0',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        MAC              => '2C:6B:F5:9B:48:A6'
                    },
                    {
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '1000000000',
                        IFINERRORS       => '0',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-1/0/39',
                        IFSTATUS         => '1',
                        IFINOCTETS       => '120478821',
                        IFPORTDUPLEX     => '3',
                        IFNUMBER         => '638',
                        IFDESCR          => 'ge-1/0/39',
                        IFOUTOCTETS      => '3329871698',
                        IFLASTCHANGE     => '(1578926177) 182 days, 17:54:21.77',
                        IFMTU            => '1514',
                        MAC              => '2C:6B:F5:9B:48:A7'
                    },
                    {
                        IFSTATUS         => '1',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '21191446',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-1/0/40',
                        IFOUTOCTETS      => '4128639709',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(889630237) 102 days, 23:11:42.37',
                        IFNUMBER         => '639',
                        IFDESCR          => 'ge-1/0/40',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '100000000',
                        MAC              => '2C:6B:F5:9B:48:A8'
                    },
                    {
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '1000000000',
                        IFINOCTETS       => '3728173756',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '1',
                        IFNAME           => 'ge-1/0/41',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1579225957) 182 days, 18:44:19.57',
                        IFOUTOCTETS      => '1765117400',
                        IFDESCR          => 'ge-1/0/41',
                        IFNUMBER         => '640',
                        MAC              => '2C:6B:F5:9B:48:A9'
                    },
                    {
                        IFINERRORS       => '0',
                        IFSPEED          => '10000000',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFLASTCHANGE     => '(1547175007) 179 days, 1:42:30.07',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '266988943',
                        IFDESCR          => 'ge-1/0/42',
                        IFNUMBER         => '641',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '4128186084',
                        IFSTATUS         => '1',
                        IFNAME           => 'ge-1/0/42',
                        IFTYPE           => '6',
                        MAC              => '2C:6B:F5:9B:48:AA'
                    },
                    {
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '100000000',
                        IFINERRORS       => '0',
                        IFNAME           => 'ge-1/0/43',
                        IFTYPE           => '6',
                        IFINOCTETS       => '23818785',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '1',
                        IFDESCR          => 'ge-1/0/43',
                        IFNUMBER         => '642',
                        IFLASTCHANGE     => '(1562377137) 180 days, 19:56:11.37',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '33757331',
                        MAC              => '2C:6B:F5:9B:48:AB'
                    },
                    {
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFNUMBER         => '643',
                        IFDESCR          => 'ge-1/0/44',
                        IFOUTOCTETS      => '0',
                        IFLASTCHANGE     => '(717450752) 83 days, 0:55:07.52',
                        IFMTU            => '1514',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-1/0/44',
                        IFSTATUS         => '2',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        MAC              => '2C:6B:F5:9B:48:AC'
                    },
                    {
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFNAME           => 'ge-1/0/45',
                        IFTYPE           => '6',
                        IFINOCTETS       => '0',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '2',
                        IFDESCR          => 'ge-1/0/45',
                        IFNUMBER         => '644',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(717450753) 83 days, 0:55:07.53',
                        IFOUTOCTETS      => '0',
                        MAC              => '2C:6B:F5:9B:48:AD'
                    },
                    {
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(717450759) 83 days, 0:55:07.59',
                        IFOUTOCTETS      => '0',
                        IFDESCR          => 'ge-1/0/46',
                        IFNUMBER         => '645',
                        IFINOCTETS       => '0',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '2',
                        IFNAME           => 'ge-1/0/46',
                        IFTYPE           => '6',
                        MAC              => '2C:6B:F5:9B:48:AE'
                    },
                    {
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '0',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(717450764) 83 days, 0:55:07.64',
                        IFNUMBER         => '646',
                        IFDESCR          => 'ge-1/0/47',
                        IFSTATUS         => '2',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-1/0/47',
                        MAC              => '2C:6B:F5:9B:48:AF'
                    },
                    {
                        IFSTATUS         => '7',
                        IFINOCTETS       => '0',
                        IFPORTDUPLEX     => '3',
                        IFTYPE           => '53',
                        IFNAME           => 'ge-1/0/1.0',
                        IFOUTOCTETS      => '0',
                        IFLASTCHANGE     => '(717450537) 83 days, 0:55:05.37',
                        IFMTU            => '1514',
                        IFNUMBER         => '647',
                        IFDESCR          => 'ge-1/0/1.0',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '100000000',
                        MAC              => '2C:6B:F5:9B:48:81'
                    },
                    {
                        IFTYPE           => '6',
                        IFNAME           => 'vlan',
                        IFSTATUS         => '1',
                        IFINOCTETS       => '593798147',
                        IFNUMBER         => '648',
                        IFDESCR          => 'vlan',
                        IFOUTOCTETS      => '835095128',
                        IFMTU            => '1518',
                        IFLASTCHANGE     => '(668) 0:00:06.68',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '1000000000',
                        IFINERRORS       => '0',
                        MAC              => '2C:6B:F5:9B:48:80'
                    },
                    {
                        IFINOCTETS       => '2680710288',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '1',
                        IFNAME           => 'xe-0/1/0',
                        IFTYPE           => '6',
                        IFLASTCHANGE     => '(717514804) 83 days, 1:05:48.04',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '1448828997',
                        IFDESCR          => 'xe-0/1/0',
                        IFNUMBER         => '649',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '4294967295',
                        MAC              => '2C:6B:F5:9B:48:80'
                    },
                    {
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '4294967295',
                        IFINERRORS       => '0',
                        IFNAME           => 'xe-0/1/0.0',
                        IFTYPE           => '53',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '10540',
                        IFSTATUS         => '1',
                        IFDESCR          => 'xe-0/1/0.0',
                        IFNUMBER         => '650',
                        IFLASTCHANGE     => '(717514804) 83 days, 1:05:48.04',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '164679696',
                        MAC              => '2C:6B:F5:9B:48:80'
                    },
                    {
                        IFINOCTETS       => '0',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '7',
                        IFNAME           => 'ge-1/0/10.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(717450648) 83 days, 0:55:06.48',
                        IFOUTOCTETS      => '0',
                        IFDESCR          => 'ge-1/0/10.0',
                        IFNUMBER         => '653',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        MAC              => '2C:6B:F5:9B:48:8A'
                    },
                    {
                        IFSPEED          => '4294967295',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFDESCR          => 'ae0',
                        IFNUMBER         => '654',
                        IFLASTCHANGE     => '(783398403) 90 days, 16:06:24.03',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '2323266978',
                        IFNAME           => 'ae0',
                        IFTYPE           => '161',
                        IFINOCTETS       => '1587472469',
                        IFSTATUS         => '1',
                        MAC              => '2C:6B:F5:9B:48:80'
                    },
                    {
                        IFSTATUS         => '1',
                        IFINOCTETS       => '717973288',
                        IFTYPE           => '161',
                        IFNAME           => 'ae1',
                        IFOUTOCTETS      => '3469730016',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1401320591) 162 days, 4:33:25.91',
                        IFNUMBER         => '655',
                        IFDESCR          => 'ae1',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '2000000000',
                        MAC              => '2C:6B:F5:9B:48:81'
                    },
                    {
                        IFSTATUS         => '2',
                        IFINOCTETS       => '0',
                        IFTYPE           => '161',
                        IFNAME           => 'ae2',
                        IFOUTOCTETS      => '0',
                        IFLASTCHANGE     => '(5836) 0:00:58.36',
                        IFMTU            => '1514',
                        IFNUMBER         => '656',
                        IFDESCR          => 'ae2',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        MAC              => '2C:6B:F5:9B:48:82'
                    },
                    {
                        IFDESCR          => 'ae3',
                        IFNUMBER         => '657',
                        IFLASTCHANGE     => '(5837) 0:00:58.37',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '0',
                        IFNAME           => 'ae3',
                        IFTYPE           => '161',
                        IFINOCTETS       => '0',
                        IFSTATUS         => '2',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        MAC              => '2C:6B:F5:9B:48:83'
                    },
                    {
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFNUMBER         => '658',
                        IFDESCR          => 'ae4',
                        IFOUTOCTETS      => '0',
                        IFLASTCHANGE     => '(5837) 0:00:58.37',
                        IFMTU            => '1514',
                        IFTYPE           => '161',
                        IFNAME           => 'ae4',
                        IFSTATUS         => '2',
                        IFINOCTETS       => '0',
                        MAC              => '2C:6B:F5:9B:48:84'
                    },
                    {
                        CONNECTIONS => {
                            CONNECTION => {
                                MAC => [
                                    '00:01:30:12:80:80',
                                    '00:01:30:12:91:80',
                                    '00:01:30:12:A6:C0',
                                    '00:01:30:12:A6:D0',
                                    '00:01:30:12:A8:30',
                                    '00:01:30:FD:05:F0',
                                    '00:0B:60:B0:B0:1B',
                                    '00:0F:34:AA:EE:1B',
                                    '00:10:DB:FF:10:02',
                                    '00:02:B3:31:FA:F9',
                                    '00:E0:86:11:1A:27',
                                    '00:E0:86:11:1D:B0',
                                    '00:E0:86:12:D9:6F',
                                    '00:E0:2B:00:00:01',
                                    '00:1B:EC:00:04:09',
                                    '00:1D:09:68:40:C8',
                                    '00:1E:C9:DA:3B:FC',
                                    '00:1E:C9:F2:C0:81',
                                    '00:1E:C9:F2:CA:8D',
                                    '00:1E:4F:1F:3C:44',
                                    '00:1E:4F:1F:57:4B',
                                    '00:1E:4F:31:A9:A0',
                                    '00:1E:4F:31:AB:88',
                                    '00:1E:4F:31:AB:AB',
                                    '00:1E:4F:32:E1:D3',
                                    '00:1E:4F:32:E4:69',
                                    '00:1E:4F:32:F7:9E',
                                    '00:1E:4F:33:14:D1',
                                    '00:1E:4F:33:07:E1',
                                    '00:1E:4F:41:D0:A4',
                                    '00:1E:4F:41:D8:69',
                                    '00:1E:4F:41:DC:7E',
                                    '00:1E:4F:41:DD:53',
                                    '00:1E:4F:41:E2:8C',
                                    '00:20:4A:0B:24:06',
                                    '00:20:4A:B1:3D:DA',
                                    '00:20:4A:08:72:D2',
                                    '00:20:4A:08:73:01',
                                    '00:20:4A:08:AC:F6',
                                    '00:20:4A:08:AC:56',
                                    '00:20:4A:08:E1:6D',
                                    '00:20:4A:08:60:C6',
                                    '00:22:19:7B:BE:11',
                                    '00:22:19:7B:BE:DA',
                                    '00:22:19:7B:BF:E6',
                                    '00:22:19:85:D9:70',
                                    '00:22:19:63:0F:55',
                                    '00:23:AE:FB:FD:89',
                                    '00:23:AE:FB:FD:B0',
                                    '00:23:AE:FC:00:CD',
                                    '00:23:AE:FC:00:D3',
                                    '00:23:AE:FC:00:D8',
                                    '00:23:AE:FE:9C:E0',
                                    '00:23:AE:FE:A9:E0',
                                    '00:04:96:18:6E:93',
                                    '00:04:96:18:5B:61',
                                    '00:04:96:1C:6F:F0',
                                    '00:04:96:1C:71:00',
                                    '00:04:96:1F:8F:0F',
                                    '00:04:96:1F:91:50',
                                    '00:04:96:27:93:F9',
                                    '00:04:96:04:58:20',
                                    '00:04:96:34:69:AB',
                                    '00:04:96:34:69:B1',
                                    '00:04:96:34:89:5C',
                                    '00:04:96:34:8B:82',
                                    '00:04:96:34:8B:F8',
                                    '00:04:96:34:8C:10',
                                    '00:04:96:34:8C:11',
                                    '00:04:96:34:92:82',
                                    '00:04:96:34:92:31',
                                    '00:04:96:34:92:47',
                                    '00:04:96:34:AF:AE',
                                    '00:04:96:35:77:14',
                                    '00:04:96:35:77:16',
                                    '00:04:96:35:90:67',
                                    '00:04:96:35:90:4D',
                                    '00:04:96:35:93:B9',
                                    '00:04:96:35:AD:E4',
                                    '00:04:96:35:C8:14',
                                    '00:04:96:35:C8:1F',
                                    '00:04:96:35:FA:AE',
                                    '00:04:96:35:FA:B1',
                                    '00:04:96:08:1E:70',
                                    '00:04:96:09:07:00',
                                    '00:05:1E:08:F8:20',
                                    '00:05:1E:08:F9:12',
                                    '00:05:1E:09:21:2D',
                                    '00:05:1E:09:21:50',
                                    '00:05:33:EC:D7:EE',
                                    '00:05:33:F5:6B:FD',
                                    '00:05:33:F5:49:AE',
                                    '00:05:33:43:78:2D',
                                    '00:05:33:54:16:AA',
                                    '00:50:56:BC:31:8A',
                                    '00:50:56:50:30:A0',
                                    '00:50:56:50:30:A2',
                                    '00:50:56:50:38:30',
                                    '00:50:56:50:38:32',
                                    '64:87:88:B7:A5:C1',
                                    '64:87:88:5C:2F:F7',
                                    '64:B9:E8:C0:B7:04',
                                    '78:FE:3D:DF:C1:82',
                                    '78:FE:3D:36:F7:01',
                                    '84:2B:2B:71:30:F3',
                                    'AC:4B:C8:23:0B:01',
                                    'B0:A8:6E:86:08:41',
                                    'B0:A8:6E:9A:2C:C1',
                                    'B0:A8:6E:9A:2D:41',
                                    'B0:A8:6E:9A:2F:81',
                                    'B0:A8:6E:9A:39:41',
                                    '02:04:96:35:F9:24',
                                    'D0:D0:FD:AB:1A:B5',
                                    'D0:D0:FD:AB:26:35',
                                    'D0:D0:FD:AC:AE:B5',
                                    'E4:1F:13:76:CA:35',
                                    'E4:1F:13:76:CD:E9',
                                    '18:03:73:0A:29:C2',
                                    '18:03:73:09:AE:8C',
                                    'F0:4D:A2:6E:CF:89',
                                    'F0:4D:A2:6E:D3:E6',
                                    'F0:4D:A2:6E:D4:96',
                                    'F0:4D:A2:6E:D4:1C',
                                    'F0:4D:A2:6F:03:39',
                                    'F0:4D:A2:6F:03:5B',
                                    'F0:4D:A2:D9:BC:3F',
                                    '28:C0:DA:3E:36:40',
                                    '58:35:D9:95:38:7E',
                                    '5C:5E:AB:66:60:80',
                                    '5C:5E:AB:6B:EC:01',
                                    '5C:5E:AB:78:0E:80'
                                ]
                            }
                        },
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '4294967295',
                        IFINOCTETS       => '0',
                        IFSTATUS         => '1',
                        IFNAME           => 'ae0.0',
                        IFTYPE           => '161',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(783398403) 90 days, 16:06:24.03',
                        IFOUTOCTETS      => '890130265',
                        IFDESCR          => 'ae0.0',
                        IFNUMBER         => '659',
                        MAC              => '2C:6B:F5:9B:48:80'
                    },
                    {
                        IFLASTCHANGE     => '(1564125317) 181 days, 0:47:33.17',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '59684653',
                        IFDESCR          => 'ge-1/0/11.0',
                        IFNUMBER         => '660',
                        IFINOCTETS       => '920045',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '7',
                        IFNAME           => 'ge-1/0/11.0',
                        IFTYPE           => '53',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        MAC              => '2C:6B:F5:9B:48:8B'
                    },
                    {
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '0',
                        IFDESCR          => 'ae4.0',
                        IFNUMBER         => '661',
                        IFINOCTETS       => '0',
                        IFSTATUS         => '2',
                        IFNAME           => 'ae4.0',
                        IFTYPE           => '161',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        MAC              => '2C:6B:F5:9B:48:84'
                    },
                    {
                        IFOUTOCTETS      => '0',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(889647615) 102 days, 23:14:36.15',
                        IFNUMBER         => '662',
                        IFDESCR          => 'ge-2/0/0',
                        IFSTATUS         => '2',
                        IFINOCTETS       => '0',
                        IFPORTDUPLEX     => '3',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-2/0/0',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        MAC              => '2C:6B:F5:9B:48:80'
                    },
                    {
                        IFOUTOCTETS      => '860831427',
                        IFLASTCHANGE     => '(1277376497) 147 days, 20:16:04.97',
                        IFMTU            => '1514',
                        IFNUMBER         => '663',
                        IFDESCR          => 'ge-2/0/1',
                        IFSTATUS         => '2',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '19694799',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-2/0/1',
                        IFINERRORS       => '0',
                        IFSPEED          => '1000000000',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        MAC              => '2C:6B:F5:9B:48:81'
                    },
                    {
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '1000000000',
                        IFSTATUS         => '1',
                        IFINOCTETS       => '16264718',
                        IFPORTDUPLEX     => '3',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-2/0/2',
                        IFOUTOCTETS      => '1942432931',
                        IFLASTCHANGE     => '(1579089654) 182 days, 18:21:36.54',
                        IFMTU            => '1514',
                        IFNUMBER         => '664',
                        IFDESCR          => 'ge-2/0/2',
                        MAC              => '2C:6B:F5:9B:48:82'
                    },
                    {
                        IFNAME           => 'ge-2/0/3',
                        IFTYPE           => '6',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '885026649',
                        IFSTATUS         => '1',
                        IFDESCR          => 'ge-2/0/3',
                        IFNUMBER         => '665',
                        IFLASTCHANGE     => '(1578862754) 182 days, 17:43:47.54',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '2105078228',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '1000000000',
                        IFINERRORS       => '0',
                        MAC              => '2C:6B:F5:9B:48:83'
                    },
                    {
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-2/0/4',
                        IFSTATUS         => '2',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFNUMBER         => '666',
                        IFDESCR          => 'ge-2/0/4',
                        IFOUTOCTETS      => '0',
                        IFLASTCHANGE     => '(889647628) 102 days, 23:14:36.28',
                        IFMTU            => '1514',
                        MAC              => '2C:6B:F5:9B:48:84'
                    },
                    {
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1579193654) 182 days, 18:38:56.54',
                        IFOUTOCTETS      => '1279880336',
                        IFDESCR          => 'ge-2/0/5',
                        IFNUMBER         => '667',
                        IFINOCTETS       => '864105490',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '1',
                        IFNAME           => 'ge-2/0/5',
                        IFTYPE           => '6',
                        IFINERRORS       => '123',
                        IFSPEED          => '100000000',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        MAC              => '2C:6B:F5:9B:48:85'
                    },
                    {
                        IFSTATUS         => '1',
                        IFINOCTETS       => '1777328163',
                        IFPORTDUPLEX     => '3',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-2/0/6',
                        IFOUTOCTETS      => '761161215',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1578905654) 182 days, 17:50:56.54',
                        IFNUMBER         => '668',
                        IFDESCR          => 'ge-2/0/6',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '1000000000',
                        MAC              => '2C:6B:F5:9B:48:86'
                    },
                    {
                        IFOUTOCTETS      => '0',
                        IFLASTCHANGE     => '(889647637) 102 days, 23:14:36.37',
                        IFMTU            => '1514',
                        IFNUMBER         => '669',
                        IFDESCR          => 'ge-2/0/7',
                        IFSTATUS         => '2',
                        IFINOCTETS       => '0',
                        IFPORTDUPLEX     => '3',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-2/0/7',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        MAC              => '2C:6B:F5:9B:48:87'
                    },
                    {
                        IFTYPE           => '6',
                        IFNAME           => 'ge-2/0/8',
                        IFSTATUS         => '1',
                        IFINOCTETS       => '259165073',
                        IFPORTDUPLEX     => '3',
                        IFNUMBER         => '670',
                        IFDESCR          => 'ge-2/0/8',
                        IFOUTOCTETS      => '3934855324',
                        IFLASTCHANGE     => '(1192428913) 138 days, 0:18:09.13',
                        IFMTU            => '1514',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '100000000',
                        IFINERRORS       => '0',
                        MAC              => '2C:6B:F5:9B:48:88'
                    },
                    {
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFSTATUS         => '2',
                        IFNAME           => 'ge-2/0/9',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(889647652) 102 days, 23:14:36.52',
                        IFOUTOCTETS      => '0',
                        IFDESCR          => 'ge-2/0/9',
                        IFNUMBER         => '671',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        MAC              => '2C:6B:F5:9B:48:89'
                    },
                    {
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFNAME           => 'ge-2/0/10',
                        IFTYPE           => '6',
                        IFINOCTETS       => '0',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '2',
                        IFDESCR          => 'ge-2/0/10',
                        IFNUMBER         => '672',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(889647654) 102 days, 23:14:36.54',
                        IFOUTOCTETS      => '0',
                        MAC              => '2C:6B:F5:9B:48:8A'
                    },
                    {
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1438500117',
                        IFSTATUS         => '1',
                        IFNAME           => 'ge-2/0/11',
                        IFTYPE           => '6',
                        IFLASTCHANGE     => '(1578979224) 182 days, 18:03:12.24',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '3257498147',
                        IFDESCR          => 'ge-2/0/11',
                        IFNUMBER         => '673',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '124',
                        IFSPEED          => '1000000000',
                        MAC              => '2C:6B:F5:9B:48:8B'
                    },
                    {
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1578972824) 182 days, 18:02:08.24',
                        IFOUTOCTETS      => '3007395638',
                        IFDESCR          => 'ge-2/0/12',
                        IFNUMBER         => '674',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2051222865',
                        IFSTATUS         => '1',
                        IFNAME           => 'ge-2/0/12',
                        IFTYPE           => '6',
                        IFINERRORS       => '133',
                        IFSPEED          => '1000000000',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        MAC              => '2C:6B:F5:9B:48:8C'
                    },
                    {
                        IFDESCR          => 'ge-2/0/13',
                        IFNUMBER         => '675',
                        IFLASTCHANGE     => '(889647674) 102 days, 23:14:36.74',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '0',
                        IFNAME           => 'ge-2/0/13',
                        IFTYPE           => '6',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFSTATUS         => '2',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        MAC              => '2C:6B:F5:9B:48:8D'
                    },
                    {
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-2/0/14',
                        IFSTATUS         => '2',
                        IFINOCTETS       => '0',
                        IFPORTDUPLEX     => '3',
                        IFNUMBER         => '676',
                        IFDESCR          => 'ge-2/0/14',
                        IFOUTOCTETS      => '0',
                        IFLASTCHANGE     => '(889647681) 102 days, 23:14:36.81',
                        IFMTU            => '1514',
                        MAC              => '2C:6B:F5:9B:48:8E'
                    },
                    {
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '1000000000',
                        IFINERRORS       => '0',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-2/0/15',
                        IFSTATUS         => '1',
                        IFINOCTETS       => '857341064',
                        IFPORTDUPLEX     => '3',
                        IFNUMBER         => '677',
                        IFDESCR          => 'ge-2/0/15',
                        IFOUTOCTETS      => '1972105888',
                        IFLASTCHANGE     => '(1578928254) 182 days, 17:54:42.54',
                        IFMTU            => '1514',
                        MAC              => '2C:6B:F5:9B:48:8F'
                    },
                    {
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-2/0/16',
                        IFSTATUS         => '2',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFNUMBER         => '678',
                        IFDESCR          => 'ge-2/0/16',
                        IFOUTOCTETS      => '0',
                        IFLASTCHANGE     => '(889647696) 102 days, 23:14:36.96',
                        IFMTU            => '1514',
                        MAC              => '2C:6B:F5:9B:48:90'
                    },
                    {
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFNAME           => 'ge-2/0/17',
                        IFTYPE           => '6',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFSTATUS         => '2',
                        IFDESCR          => 'ge-2/0/17',
                        IFNUMBER         => '679',
                        IFLASTCHANGE     => '(889647703) 102 days, 23:14:37.03',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '0',
                        MAC              => '2C:6B:F5:9B:48:91'
                    },
                    {
                        IFOUTOCTETS      => '522097451',
                        IFLASTCHANGE     => '(1572916894) 182 days, 1:12:48.94',
                        IFMTU            => '1514',
                        IFNUMBER         => '680',
                        IFDESCR          => 'ge-2/0/18',
                        IFSTATUS         => '1',
                        IFINOCTETS       => '794886388',
                        IFPORTDUPLEX     => '3',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-2/0/18',
                        IFINERRORS       => '62',
                        IFSPEED          => '10000000',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        MAC              => '2C:6B:F5:9B:48:92'
                    },
                    {
                        IFTYPE           => '6',
                        IFNAME           => 'ge-2/0/19',
                        IFSTATUS         => '1',
                        IFINOCTETS       => '4936307',
                        IFPORTDUPLEX     => '3',
                        IFNUMBER         => '681',
                        IFDESCR          => 'ge-2/0/19',
                        IFOUTOCTETS      => '946574273',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1578584634) 182 days, 16:57:26.34',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '100000000',
                        IFINERRORS       => '0',
                        MAC              => '2C:6B:F5:9B:48:93'
                    },
                    {
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '100000000',
                        IFSTATUS         => '1',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1153312159',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-2/0/20',
                        IFOUTOCTETS      => '516539527',
                        IFLASTCHANGE     => '(1578587184) 182 days, 16:57:51.84',
                        IFMTU            => '1514',
                        IFNUMBER         => '682',
                        IFDESCR          => 'ge-2/0/20',
                        MAC              => '2C:6B:F5:9B:48:94'
                    },
                    {
                        IFINERRORS       => '0',
                        IFSPEED          => '1000000000',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '59156',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1328744065) 153 days, 18:57:20.65',
                        IFNUMBER         => '683',
                        IFDESCR          => 'ge-2/0/21',
                        IFSTATUS         => '2',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '38238',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-2/0/21',
                        MAC              => '2C:6B:F5:9B:48:95'
                    },
                    {
                        IFSTATUS         => '2',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-2/0/22',
                        IFOUTOCTETS      => '0',
                        IFLASTCHANGE     => '(889647726) 102 days, 23:14:37.26',
                        IFMTU            => '1514',
                        IFNUMBER         => '684',
                        IFDESCR          => 'ge-2/0/22',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        MAC              => '2C:6B:F5:9B:48:96'
                    },
                    {
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFNUMBER         => '685',
                        IFDESCR          => 'ge-2/0/23',
                        IFOUTOCTETS      => '0',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(889647733) 102 days, 23:14:37.33',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-2/0/23',
                        IFSTATUS         => '2',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        MAC              => '2C:6B:F5:9B:48:97'
                    },
                    {
                        IFINOCTETS       => '0',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '2',
                        IFNAME           => 'ge-2/0/24',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(889647735) 102 days, 23:14:37.35',
                        IFOUTOCTETS      => '0',
                        IFDESCR          => 'ge-2/0/24',
                        IFNUMBER         => '686',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        MAC              => '2C:6B:F5:9B:48:98'
                    },
                    {
                        IFTYPE           => '6',
                        IFNAME           => 'ge-2/0/25',
                        IFSTATUS         => '1',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1252700608',
                        IFNUMBER         => '687',
                        IFDESCR          => 'ge-2/0/25',
                        IFOUTOCTETS      => '1346700443',
                        IFLASTCHANGE     => '(1578771194) 182 days, 17:28:31.94',
                        IFMTU            => '1514',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '1000000000',
                        IFINERRORS       => '0',
                        MAC              => '2C:6B:F5:9B:48:99'
                    },
                    {
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-2/0/26',
                        IFSTATUS         => '2',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFNUMBER         => '688',
                        IFDESCR          => 'ge-2/0/26',
                        IFOUTOCTETS      => '0',
                        IFLASTCHANGE     => '(889647741) 102 days, 23:14:37.41',
                        IFMTU            => '1514',
                        MAC              => '2C:6B:F5:9B:48:9A'
                    },
                    {
                        IFLASTCHANGE     => '(889647743) 102 days, 23:14:37.43',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '0',
                        IFDESCR          => 'ge-2/0/27',
                        IFNUMBER         => '689',
                        IFINOCTETS       => '0',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '2',
                        IFNAME           => 'ge-2/0/27',
                        IFTYPE           => '6',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        MAC              => '2C:6B:F5:9B:48:9B'
                    },
                    {
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '1000000000',
                        IFSTATUS         => '1',
                        IFINOCTETS       => '1949901923',
                        IFPORTDUPLEX     => '3',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-2/0/28',
                        IFOUTOCTETS      => '3933167650',
                        IFLASTCHANGE     => '(1579064374) 182 days, 18:17:23.74',
                        IFMTU            => '1514',
                        IFNUMBER         => '690',
                        IFDESCR          => 'ge-2/0/28',
                        MAC              => '2C:6B:F5:9B:48:9C'
                    },
                    {
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        IFSTATUS         => '2',
                        IFINOCTETS       => '0',
                        IFPORTDUPLEX     => '3',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-2/0/29',
                        IFOUTOCTETS      => '0',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(889647746) 102 days, 23:14:37.46',
                        IFNUMBER         => '691',
                        IFDESCR          => 'ge-2/0/29',
                        MAC              => '2C:6B:F5:9B:48:9D'
                    },
                    {
                        IFTYPE           => '6',
                        IFNAME           => 'ge-2/0/30',
                        IFSTATUS         => '2',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFNUMBER         => '692',
                        IFDESCR          => 'ge-2/0/30',
                        IFOUTOCTETS      => '0',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(889647749) 102 days, 23:14:37.49',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        MAC              => '2C:6B:F5:9B:48:9E'
                    },
                    {
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        IFSTATUS         => '2',
                        IFINOCTETS       => '0',
                        IFPORTDUPLEX     => '3',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-2/0/31',
                        IFOUTOCTETS      => '0',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(889647771) 102 days, 23:14:37.71',
                        IFNUMBER         => '693',
                        IFDESCR          => 'ge-2/0/31',
                        MAC              => '2C:6B:F5:9B:48:9F'
                    },
                    {
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFNUMBER         => '694',
                        IFDESCR          => 'ge-2/0/32',
                        IFOUTOCTETS      => '0',
                        IFLASTCHANGE     => '(889647772) 102 days, 23:14:37.72',
                        IFMTU            => '1514',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-2/0/32',
                        IFSTATUS         => '2',
                        IFINOCTETS       => '0',
                        IFPORTDUPLEX     => '3',
                        MAC              => '2C:6B:F5:9B:48:A0'
                    },
                    {
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFSTATUS         => '2',
                        IFNAME           => 'ge-2/0/33',
                        IFTYPE           => '6',
                        IFLASTCHANGE     => '(889647775) 102 days, 23:14:37.75',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '0',
                        IFDESCR          => 'ge-2/0/33',
                        IFNUMBER         => '695',
                        MAC              => '2C:6B:F5:9B:48:A1'
                    },
                    {
                        IFSPEED          => '100000000',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFNUMBER         => '696',
                        IFDESCR          => 'ge-2/0/34',
                        IFOUTOCTETS      => '3337289733',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1322849014) 153 days, 2:34:50.14',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-2/0/34',
                        IFSTATUS         => '1',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '287684405',
                        MAC              => '2C:6B:F5:9B:48:A2'
                    },
                    {
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFSTATUS         => '2',
                        IFNAME           => 'ge-2/0/35',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(889647798) 102 days, 23:14:37.98',
                        IFOUTOCTETS      => '0',
                        IFDESCR          => 'ge-2/0/35',
                        IFNUMBER         => '697',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        MAC              => '2C:6B:F5:9B:48:A3'
                    },
                    {
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFDESCR          => 'ge-2/0/36',
                        IFNUMBER         => '698',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(889647801) 102 days, 23:14:38.01',
                        IFOUTOCTETS      => '0',
                        IFNAME           => 'ge-2/0/36',
                        IFTYPE           => '6',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFSTATUS         => '2',
                        MAC              => '2C:6B:F5:9B:48:A4'
                    },
                    {
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '1000000000',
                        IFINERRORS       => '179',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-2/0/37',
                        IFSTATUS         => '1',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1014994314',
                        IFNUMBER         => '699',
                        IFDESCR          => 'ge-2/0/37',
                        IFOUTOCTETS      => '2218627453',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1578869584) 182 days, 17:44:55.84',
                        MAC              => '2C:6B:F5:9B:48:A5'
                    },
                    {
                        IFNUMBER         => '700',
                        IFDESCR          => 'ge-2/0/38',
                        IFOUTOCTETS      => '0',
                        IFLASTCHANGE     => '(889647804) 102 days, 23:14:38.04',
                        IFMTU            => '1514',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-2/0/38',
                        IFSTATUS         => '2',
                        IFINOCTETS       => '0',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        MAC              => '2C:6B:F5:9B:48:A6'
                    },
                    {
                        IFSTATUS         => '1',
                        IFINOCTETS       => '890348094',
                        IFPORTDUPLEX     => '3',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-2/0/39',
                        IFOUTOCTETS      => '1670613775',
                        IFLASTCHANGE     => '(1578551944) 182 days, 16:51:59.44',
                        IFMTU            => '1514',
                        IFNUMBER         => '701',
                        IFDESCR          => 'ge-2/0/39',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '478',
                        IFSPEED          => '100000000',
                        MAC              => '2C:6B:F5:9B:48:A7'
                    },
                    {
                        IFTYPE           => '6',
                        IFNAME           => 'ge-2/0/40',
                        IFSTATUS         => '1',
                        IFINOCTETS       => '84412015',
                        IFPORTDUPLEX     => '3',
                        IFNUMBER         => '702',
                        IFDESCR          => 'ge-2/0/40',
                        IFOUTOCTETS      => '110227968',
                        IFLASTCHANGE     => '(1485792124) 171 days, 23:12:01.24',
                        IFMTU            => '1514',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '1000000000',
                        IFINERRORS       => '0',
                        MAC              => '2C:6B:F5:9B:48:A8'
                    },
                    {
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '462',
                        IFSPEED          => '10000000',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1044124892',
                        IFSTATUS         => '1',
                        IFNAME           => 'ge-2/0/41',
                        IFTYPE           => '6',
                        IFLASTCHANGE     => '(1578870914) 182 days, 17:45:09.14',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '3934721224',
                        IFDESCR          => 'ge-2/0/41',
                        IFNUMBER         => '703',
                        MAC              => '2C:6B:F5:9B:48:A9'
                    },
                    {
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-2/0/42',
                        IFSTATUS         => '2',
                        IFINOCTETS       => '0',
                        IFPORTDUPLEX     => '3',
                        IFNUMBER         => '704',
                        IFDESCR          => 'ge-2/0/42',
                        IFOUTOCTETS      => '0',
                        IFLASTCHANGE     => '(889647814) 102 days, 23:14:38.14',
                        IFMTU            => '1514',
                        MAC              => '2C:6B:F5:9B:48:AA'
                    },
                    {
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFSTATUS         => '2',
                        IFNAME           => 'ge-2/0/43',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(889647815) 102 days, 23:14:38.15',
                        IFOUTOCTETS      => '0',
                        IFDESCR          => 'ge-2/0/43',
                        IFNUMBER         => '705',
                        MAC              => '2C:6B:F5:9B:48:AB'
                    },
                    {
                        IFSTATUS         => '2',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-2/0/44',
                        IFOUTOCTETS      => '0',
                        IFLASTCHANGE     => '(889647818) 102 days, 23:14:38.18',
                        IFMTU            => '1514',
                        IFNUMBER         => '706',
                        IFDESCR          => 'ge-2/0/44',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        MAC              => '2C:6B:F5:9B:48:AC'
                    },
                    {
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFDESCR          => 'ge-2/0/45',
                        IFNUMBER         => '707',
                        IFLASTCHANGE     => '(889647822) 102 days, 23:14:38.22',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '0',
                        IFNAME           => 'ge-2/0/45',
                        IFTYPE           => '6',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFSTATUS         => '2',
                        MAC              => '2C:6B:F5:9B:48:AD'
                    },
                    {
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-2/0/46',
                        IFSTATUS         => '2',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFNUMBER         => '708',
                        IFDESCR          => 'ge-2/0/46',
                        IFOUTOCTETS      => '0',
                        IFLASTCHANGE     => '(889647825) 102 days, 23:14:38.25',
                        IFMTU            => '1514',
                        MAC              => '2C:6B:F5:9B:48:AE'
                    },
                    {
                        IFNUMBER         => '709',
                        IFDESCR          => 'ge-2/0/47',
                        IFOUTOCTETS      => '0',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(889647826) 102 days, 23:14:38.26',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-2/0/47',
                        IFSTATUS         => '2',
                        IFINOCTETS       => '0',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        MAC              => '2C:6B:F5:9B:48:AF'
                    },
                    {
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '4294967295',
                        IFINERRORS       => '0',
                        IFNAME           => 'xe-2/1/0',
                        IFTYPE           => '6',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '928512917',
                        IFSTATUS         => '1',
                        IFDESCR          => 'xe-2/1/0',
                        IFNUMBER         => '710',
                        IFLASTCHANGE     => '(889650343) 102 days, 23:15:03.43',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '1057088068',
                        MAC              => '2C:6B:F5:9B:48:80'
                    },
                    {
                        IFTYPE           => '6',
                        IFNAME           => 'ge-3/0/0',
                        IFSTATUS         => '2',
                        IFINOCTETS       => '0',
                        IFPORTDUPLEX     => '3',
                        IFNUMBER         => '711',
                        IFDESCR          => 'ge-3/0/0',
                        IFOUTOCTETS      => '0',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(889646413) 102 days, 23:14:24.13',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        MAC              => '2C:6B:F5:9B:48:80'
                    },
                    {
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFNUMBER         => '712',
                        IFDESCR          => 'ge-3/0/1',
                        IFOUTOCTETS      => '0',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(889646422) 102 days, 23:14:24.22',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-3/0/1',
                        IFSTATUS         => '2',
                        IFINOCTETS       => '0',
                        IFPORTDUPLEX     => '3',
                        MAC              => '2C:6B:F5:9B:48:81'
                    },
                    {
                        IFSTATUS         => '2',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '4024299310',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-3/0/2',
                        IFOUTOCTETS      => '1336085659',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1520988290) 176 days, 0:58:02.90',
                        IFNUMBER         => '713',
                        IFDESCR          => 'ge-3/0/2',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '1000000000',
                        MAC              => '2C:6B:F5:9B:48:82'
                    },
                    {
                        IFSPEED          => '1000000000',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFDESCR          => 'ge-3/0/3',
                        IFNUMBER         => '714',
                        IFLASTCHANGE     => '(1450384926) 167 days, 20:50:49.26',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '3788064450',
                        IFNAME           => 'ge-3/0/3',
                        IFTYPE           => '6',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '34005860',
                        IFSTATUS         => '2',
                        MAC              => '2C:6B:F5:9B:48:83'
                    },
                    {
                        IFNUMBER         => '715',
                        IFDESCR          => 'ge-3/0/4',
                        IFOUTOCTETS      => '4206370913',
                        IFLASTCHANGE     => '(1450387743) 167 days, 20:51:17.43',
                        IFMTU            => '1514',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-3/0/4',
                        IFSTATUS         => '2',
                        IFINOCTETS       => '51906004',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '100000000',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        MAC              => '2C:6B:F5:9B:48:84'
                    },
                    {
                        IFINOCTETS       => '124374888',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '2',
                        IFNAME           => 'ge-3/0/5',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1450387216) 167 days, 20:51:12.16',
                        IFOUTOCTETS      => '946583611',
                        IFDESCR          => 'ge-3/0/5',
                        IFNUMBER         => '716',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '1000000000',
                        MAC              => '2C:6B:F5:9B:48:85'
                    },
                    {
                        IFOUTOCTETS      => '3120502992',
                        IFLASTCHANGE     => '(1520369320) 175 days, 23:14:53.20',
                        IFMTU            => '1514',
                        IFNUMBER         => '717',
                        IFDESCR          => 'ge-3/0/6',
                        IFSTATUS         => '2',
                        IFINOCTETS       => '79883720',
                        IFPORTDUPLEX     => '3',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-3/0/6',
                        IFINERRORS       => '0',
                        IFSPEED          => '1000000000',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        MAC              => '2C:6B:F5:9B:48:86'
                    },
                    {
                        IFOUTOCTETS      => '592790354',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1450388998) 167 days, 20:51:29.98',
                        IFNUMBER         => '718',
                        IFDESCR          => 'ge-3/0/7',
                        IFSTATUS         => '2',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '189074348',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-3/0/7',
                        IFINERRORS       => '0',
                        IFSPEED          => '1000000000',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        MAC              => '2C:6B:F5:9B:48:87'
                    },
                    {
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '100000000',
                        IFINERRORS       => '0',
                        IFNAME           => 'ge-3/0/8',
                        IFTYPE           => '6',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '70052326',
                        IFSTATUS         => '2',
                        IFDESCR          => 'ge-3/0/8',
                        IFNUMBER         => '719',
                        IFLASTCHANGE     => '(1450401450) 167 days, 20:53:34.50',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '3949735961',
                        MAC              => '2C:6B:F5:9B:48:88'
                    },
                    {
                        IFSTATUS         => '2',
                        IFINOCTETS       => '63979213',
                        IFPORTDUPLEX     => '3',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-3/0/9',
                        IFOUTOCTETS      => '714317279',
                        IFLASTCHANGE     => '(1520251378) 175 days, 22:55:13.78',
                        IFMTU            => '1514',
                        IFNUMBER         => '720',
                        IFDESCR          => 'ge-3/0/9',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '1000000000',
                        MAC              => '2C:6B:F5:9B:48:89'
                    },
                    {
                        IFTYPE           => '6',
                        IFNAME           => 'ge-3/0/14',
                        IFSTATUS         => '2',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '25116574',
                        IFNUMBER         => '721',
                        IFDESCR          => 'ge-3/0/14',
                        IFOUTOCTETS      => '3775172564',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1450388428) 167 days, 20:51:24.28',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '1000000000',
                        IFINERRORS       => '0',
                        MAC              => '2C:6B:F5:9B:48:8E'
                    },
                    {
                        IFNUMBER         => '722',
                        IFDESCR          => 'ge-3/0/10',
                        IFOUTOCTETS      => '3443544221',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1453627976) 168 days, 5:51:19.76',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-3/0/10',
                        IFSTATUS         => '2',
                        IFINOCTETS       => '19619677',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '100000000',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        MAC              => '2C:6B:F5:9B:48:8A'
                    },
                    {
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1364234866) 157 days, 21:32:28.66',
                        IFOUTOCTETS      => '3014350545',
                        IFDESCR          => 'ge-3/0/11',
                        IFNUMBER         => '723',
                        IFINOCTETS       => '16532151',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '2',
                        IFNAME           => 'ge-3/0/11',
                        IFTYPE           => '6',
                        IFINERRORS       => '0',
                        IFSPEED          => '1000000000',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        MAC              => '2C:6B:F5:9B:48:8B'
                    },
                    {
                        IFSTATUS         => '2',
                        IFINOCTETS       => '37349525',
                        IFPORTDUPLEX     => '3',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-3/0/21',
                        IFOUTOCTETS      => '1050909558',
                        IFLASTCHANGE     => '(1338153164) 154 days, 21:05:31.64',
                        IFMTU            => '1514',
                        IFNUMBER         => '724',
                        IFDESCR          => 'ge-3/0/21',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '1000000000',
                        MAC              => '2C:6B:F5:9B:48:95'
                    },
                    {
                        IFNUMBER         => '725',
                        IFDESCR          => 'ge-3/0/22',
                        IFOUTOCTETS      => '0',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(889646599) 102 days, 23:14:25.99',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-3/0/22',
                        IFSTATUS         => '2',
                        IFINOCTETS       => '0',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        MAC              => '2C:6B:F5:9B:48:96'
                    },
                    {
                        IFSTATUS         => '2',
                        IFINOCTETS       => '36852723',
                        IFPORTDUPLEX     => '3',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-3/0/12',
                        IFOUTOCTETS      => '3712872109',
                        IFLASTCHANGE     => '(1450386691) 167 days, 20:51:06.91',
                        IFMTU            => '1514',
                        IFNUMBER         => '726',
                        IFDESCR          => 'ge-3/0/12',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '1000000000',
                        MAC              => '2C:6B:F5:9B:48:8C'
                    },
                    {
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFNAME           => 'ge-3/0/23',
                        IFTYPE           => '6',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFSTATUS         => '2',
                        IFDESCR          => 'ge-3/0/23',
                        IFNUMBER         => '727',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(889646609) 102 days, 23:14:26.09',
                        IFOUTOCTETS      => '0',
                        MAC              => '2C:6B:F5:9B:48:97'
                    },
                    {
                        IFDESCR          => 'ge-3/0/13',
                        IFNUMBER         => '728',
                        IFLASTCHANGE     => '(1450398878) 167 days, 20:53:08.78',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '3711553524',
                        IFNAME           => 'ge-3/0/13',
                        IFTYPE           => '6',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '110431033',
                        IFSTATUS         => '2',
                        IFSPEED          => '100000000',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        MAC              => '2C:6B:F5:9B:48:8D'
                    },
                    {
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFNAME           => 'ge-3/0/24',
                        IFTYPE           => '6',
                        IFINOCTETS       => '0',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '2',
                        IFDESCR          => 'ge-3/0/24',
                        IFNUMBER         => '729',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(889646614) 102 days, 23:14:26.14',
                        IFOUTOCTETS      => '0',
                        MAC              => '2C:6B:F5:9B:48:98'
                    },
                    {
                        IFSTATUS         => '2',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-3/0/25',
                        IFOUTOCTETS      => '0',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(889646627) 102 days, 23:14:26.27',
                        IFNUMBER         => '730',
                        IFDESCR          => 'ge-3/0/25',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        MAC              => '2C:6B:F5:9B:48:99'
                    },
                    {
                        IFTYPE           => '6',
                        IFNAME           => 'ge-3/0/15',
                        IFSTATUS         => '2',
                        IFINOCTETS       => '23282650',
                        IFPORTDUPLEX     => '3',
                        IFNUMBER         => '731',
                        IFDESCR          => 'ge-3/0/15',
                        IFOUTOCTETS      => '3814199236',
                        IFLASTCHANGE     => '(1450386802) 167 days, 20:51:08.02',
                        IFMTU            => '1514',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '1000000000',
                        IFINERRORS       => '0',
                        MAC              => '2C:6B:F5:9B:48:8F'
                    },
                    {
                        IFINERRORS       => '0',
                        IFSPEED          => '1000000000',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '1132038986',
                        IFLASTCHANGE     => '(1520346686) 175 days, 23:11:06.86',
                        IFMTU            => '1514',
                        IFNUMBER         => '732',
                        IFDESCR          => 'ge-3/0/16',
                        IFSTATUS         => '2',
                        IFINOCTETS       => '65514699',
                        IFPORTDUPLEX     => '3',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-3/0/16',
                        MAC              => '2C:6B:F5:9B:48:90'
                    },
                    {
                        IFNAME           => 'ge-3/0/26',
                        IFTYPE           => '6',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFSTATUS         => '2',
                        IFDESCR          => 'ge-3/0/26',
                        IFNUMBER         => '733',
                        IFLASTCHANGE     => '(889646629) 102 days, 23:14:26.29',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        MAC              => '2C:6B:F5:9B:48:9A'
                    },
                    {
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '1000000000',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '20264914',
                        IFSTATUS         => '2',
                        IFNAME           => 'ge-3/0/17',
                        IFTYPE           => '6',
                        IFLASTCHANGE     => '(1520347478) 175 days, 23:11:14.78',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '1135247476',
                        IFDESCR          => 'ge-3/0/17',
                        IFNUMBER         => '734',
                        MAC              => '2C:6B:F5:9B:48:91'
                    },
                    {
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFSTATUS         => '2',
                        IFNAME           => 'ge-3/0/27',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(889646632) 102 days, 23:14:26.32',
                        IFOUTOCTETS      => '0',
                        IFDESCR          => 'ge-3/0/27',
                        IFNUMBER         => '735',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        MAC              => '2C:6B:F5:9B:48:9B'
                    },
                    {
                        IFINERRORS       => '0',
                        IFSPEED          => '100000000',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '1075691635',
                        IFLASTCHANGE     => '(1338153052) 154 days, 21:05:30.52',
                        IFMTU            => '1514',
                        IFNUMBER         => '736',
                        IFDESCR          => 'ge-3/0/18',
                        IFSTATUS         => '2',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '24764343',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-3/0/18',
                        MAC              => '2C:6B:F5:9B:48:92'
                    },
                    {
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '0',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(889646636) 102 days, 23:14:26.36',
                        IFNUMBER         => '737',
                        IFDESCR          => 'ge-3/0/28',
                        IFSTATUS         => '2',
                        IFINOCTETS       => '0',
                        IFPORTDUPLEX     => '3',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-3/0/28',
                        MAC              => '2C:6B:F5:9B:48:9C'
                    },
                    {
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFNAME           => 'ge-3/0/29',
                        IFTYPE           => '6',
                        IFINOCTETS       => '0',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '2',
                        IFDESCR          => 'ge-3/0/29',
                        IFNUMBER         => '738',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(889646640) 102 days, 23:14:26.40',
                        IFOUTOCTETS      => '0',
                        MAC              => '2C:6B:F5:9B:48:9D'
                    },
                    {
                        IFOUTOCTETS      => '1046130957',
                        IFLASTCHANGE     => '(1338153360) 154 days, 21:05:33.60',
                        IFMTU            => '1514',
                        IFNUMBER         => '739',
                        IFDESCR          => 'ge-3/0/19',
                        IFSTATUS         => '2',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '19075908',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-3/0/19',
                        IFINERRORS       => '0',
                        IFSPEED          => '1000000000',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        MAC              => '2C:6B:F5:9B:48:93'
                    },
                    {
                        IFLASTCHANGE     => '(889646641) 102 days, 23:14:26.41',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '0',
                        IFDESCR          => 'ge-3/0/30',
                        IFNUMBER         => '740',
                        IFINOCTETS       => '0',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '2',
                        IFNAME           => 'ge-3/0/30',
                        IFTYPE           => '6',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        MAC              => '2C:6B:F5:9B:48:9E'
                    },
                    {
                        IFDESCR          => 'ge-3/0/31',
                        IFNUMBER         => '741',
                        IFLASTCHANGE     => '(889646649) 102 days, 23:14:26.49',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '0',
                        IFNAME           => 'ge-3/0/31',
                        IFTYPE           => '6',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFSTATUS         => '2',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        MAC              => '2C:6B:F5:9B:48:9F'
                    },
                    {
                        IFSTATUS         => '2',
                        IFINOCTETS       => '26223796',
                        IFPORTDUPLEX     => '3',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-3/0/20',
                        IFOUTOCTETS      => '599205085',
                        IFLASTCHANGE     => '(1338153274) 154 days, 21:05:32.74',
                        IFMTU            => '1514',
                        IFNUMBER         => '742',
                        IFDESCR          => 'ge-3/0/20',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '1000000000',
                        MAC              => '2C:6B:F5:9B:48:94'
                    },
                    {
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-3/0/32',
                        IFSTATUS         => '2',
                        IFINOCTETS       => '0',
                        IFPORTDUPLEX     => '3',
                        IFNUMBER         => '743',
                        IFDESCR          => 'ge-3/0/32',
                        IFOUTOCTETS      => '0',
                        IFLASTCHANGE     => '(889646657) 102 days, 23:14:26.57',
                        IFMTU            => '1514',
                        MAC              => '2C:6B:F5:9B:48:A0'
                    },
                    {
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-3/0/33',
                        IFSTATUS         => '2',
                        IFINOCTETS       => '0',
                        IFPORTDUPLEX     => '3',
                        IFNUMBER         => '744',
                        IFDESCR          => 'ge-3/0/33',
                        IFOUTOCTETS      => '0',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(889646660) 102 days, 23:14:26.60',
                        MAC              => '2C:6B:F5:9B:48:A1'
                    },
                    {
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(889646662) 102 days, 23:14:26.62',
                        IFOUTOCTETS      => '0',
                        IFDESCR          => 'ge-3/0/34',
                        IFNUMBER         => '745',
                        IFINOCTETS       => '0',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '2',
                        IFNAME           => 'ge-3/0/34',
                        IFTYPE           => '6',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        MAC              => '2C:6B:F5:9B:48:A2'
                    },
                    {
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '0',
                        IFLASTCHANGE     => '(889646664) 102 days, 23:14:26.64',
                        IFMTU            => '1514',
                        IFNUMBER         => '746',
                        IFDESCR          => 'ge-3/0/35',
                        IFSTATUS         => '2',
                        IFINOCTETS       => '0',
                        IFPORTDUPLEX     => '3',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-3/0/35',
                        MAC              => '2C:6B:F5:9B:48:A3'
                    },
                    {
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFSTATUS         => '2',
                        IFNAME           => 'ge-3/0/36',
                        IFTYPE           => '6',
                        IFLASTCHANGE     => '(889646668) 102 days, 23:14:26.68',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '0',
                        IFDESCR          => 'ge-3/0/36',
                        IFNUMBER         => '747',
                        MAC              => '2C:6B:F5:9B:48:A4'
                    },
                    {
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '0',
                        IFLASTCHANGE     => '(889646674) 102 days, 23:14:26.74',
                        IFMTU            => '1514',
                        IFNUMBER         => '748',
                        IFDESCR          => 'ge-3/0/37',
                        IFSTATUS         => '2',
                        IFINOCTETS       => '0',
                        IFPORTDUPLEX     => '3',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-3/0/37',
                        MAC              => '2C:6B:F5:9B:48:A5'
                    },
                    {
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFNAME           => 'ge-3/0/38',
                        IFTYPE           => '6',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFSTATUS         => '2',
                        IFDESCR          => 'ge-3/0/38',
                        IFNUMBER         => '749',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(889646684) 102 days, 23:14:26.84',
                        IFOUTOCTETS      => '0',
                        MAC              => '2C:6B:F5:9B:48:A6'
                    },
                    {
                        IFNAME           => 'ge-3/0/39',
                        IFTYPE           => '6',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFSTATUS         => '2',
                        IFDESCR          => 'ge-3/0/39',
                        IFNUMBER         => '750',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(889646688) 102 days, 23:14:26.88',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        MAC              => '2C:6B:F5:9B:48:A7'
                    },
                    {
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(889646691) 102 days, 23:14:26.91',
                        IFOUTOCTETS      => '0',
                        IFDESCR          => 'ge-3/0/40',
                        IFNUMBER         => '751',
                        IFINOCTETS       => '0',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '2',
                        IFNAME           => 'ge-3/0/40',
                        IFTYPE           => '6',
                        MAC              => '2C:6B:F5:9B:48:A8'
                    },
                    {
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        IFSTATUS         => '2',
                        IFINOCTETS       => '0',
                        IFPORTDUPLEX     => '3',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-3/0/41',
                        IFOUTOCTETS      => '0',
                        IFLASTCHANGE     => '(889646696) 102 days, 23:14:26.96',
                        IFMTU            => '1514',
                        IFNUMBER         => '752',
                        IFDESCR          => 'ge-3/0/41',
                        MAC              => '2C:6B:F5:9B:48:A9'
                    },
                    {
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFNAME           => 'ge-3/0/42',
                        IFTYPE           => '6',
                        IFINOCTETS       => '0',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '2',
                        IFDESCR          => 'ge-3/0/42',
                        IFNUMBER         => '753',
                        IFLASTCHANGE     => '(889646699) 102 days, 23:14:26.99',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '0',
                        MAC              => '2C:6B:F5:9B:48:AA'
                    },
                    {
                        IFNAME           => 'ge-3/0/43',
                        IFTYPE           => '6',
                        IFINOCTETS       => '0',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '2',
                        IFDESCR          => 'ge-3/0/43',
                        IFNUMBER         => '754',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(889646702) 102 days, 23:14:27.02',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        MAC              => '2C:6B:F5:9B:48:AB'
                    },
                    {
                        IFNUMBER         => '755',
                        IFDESCR          => 'ge-3/0/44',
                        IFOUTOCTETS      => '0',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(889646707) 102 days, 23:14:27.07',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-3/0/44',
                        IFSTATUS         => '2',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        MAC              => '2C:6B:F5:9B:48:AC'
                    },
                    {
                        IFOUTOCTETS      => '0',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(889646710) 102 days, 23:14:27.10',
                        IFNUMBER         => '756',
                        IFDESCR          => 'ge-3/0/45',
                        IFSTATUS         => '2',
                        IFINOCTETS       => '0',
                        IFPORTDUPLEX     => '3',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-3/0/45',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        MAC              => '2C:6B:F5:9B:48:AD'
                    },
                    {
                        IFDESCR          => 'ge-3/0/46',
                        IFNUMBER         => '757',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(889646712) 102 days, 23:14:27.12',
                        IFOUTOCTETS      => '0',
                        IFNAME           => 'ge-3/0/46',
                        IFTYPE           => '6',
                        IFINOCTETS       => '0',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '2',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        MAC              => '2C:6B:F5:9B:48:AE'
                    },
                    {
                        IFSTATUS         => '2',
                        IFINOCTETS       => '0',
                        IFPORTDUPLEX     => '3',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-3/0/47',
                        IFOUTOCTETS      => '0',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(889646714) 102 days, 23:14:27.14',
                        IFNUMBER         => '758',
                        IFDESCR          => 'ge-3/0/47',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        MAC              => '2C:6B:F5:9B:48:AF'
                    },
                    {
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFNUMBER         => '759',
                        IFDESCR          => 'ge-1/0/12.0',
                        IFOUTOCTETS      => '208503454',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1573444441) 182 days, 2:40:44.41',
                        IFTYPE           => '53',
                        IFNAME           => 'ge-1/0/12.0',
                        IFSTATUS         => '7',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1923376',
                        MAC              => '2C:6B:F5:9B:48:8C'
                    },
                    {
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1442976434) 167 days, 0:16:04.34',
                        IFOUTOCTETS      => '2323959792',
                        IFDESCR          => 'ge-4/0/0',
                        IFNUMBER         => '760',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3011181804',
                        IFSTATUS         => '2',
                        IFNAME           => 'ge-4/0/0',
                        IFTYPE           => '6',
                        IFINERRORS       => '0',
                        IFSPEED          => '100000000',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        MAC              => '2C:6B:F5:9B:48:80'
                    },
                    {
                        IFOUTOCTETS      => '272770095',
                        IFLASTCHANGE     => '(1565042078) 181 days, 3:20:20.78',
                        IFMTU            => '1514',
                        IFNUMBER         => '761',
                        IFDESCR          => 'ge-4/0/1',
                        IFSTATUS         => '1',
                        IFINOCTETS       => '5522584',
                        IFPORTDUPLEX     => '3',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-4/0/1',
                        IFINERRORS       => '0',
                        IFSPEED          => '10000000',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        MAC              => '2C:6B:F5:9B:48:81'
                    },
                    {
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFNAME           => 'ge-4/0/2',
                        IFTYPE           => '6',
                        IFINOCTETS       => '0',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '2',
                        IFDESCR          => 'ge-4/0/2',
                        IFNUMBER         => '762',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1071466878) 124 days, 0:17:48.78',
                        IFOUTOCTETS      => '0',
                        MAC              => '2C:6B:F5:9B:48:82'
                    },
                    {
                        IFSPEED          => '1000000000',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFNUMBER         => '763',
                        IFDESCR          => 'ge-4/0/3',
                        IFOUTOCTETS      => '2122308007',
                        IFLASTCHANGE     => '(1578609968) 182 days, 17:01:39.68',
                        IFMTU            => '1514',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-4/0/3',
                        IFSTATUS         => '1',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1839442692',
                        MAC              => '2C:6B:F5:9B:48:83'
                    },
                    {
                        IFDESCR          => 'ge-4/0/4',
                        IFNUMBER         => '764',
                        IFLASTCHANGE     => '(1510174878) 174 days, 18:55:48.78',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '3407244235',
                        IFNAME           => 'ge-4/0/4',
                        IFTYPE           => '6',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1319966900',
                        IFSTATUS         => '1',
                        IFSPEED          => '100000000',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        MAC              => '2C:6B:F5:9B:48:84'
                    },
                    {
                        IFSPEED          => '100000000',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFNUMBER         => '765',
                        IFDESCR          => 'ge-4/0/5',
                        IFOUTOCTETS      => '565425',
                        IFLASTCHANGE     => '(1510153146) 174 days, 18:52:11.46',
                        IFMTU            => '1514',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-4/0/5',
                        IFSTATUS         => '2',
                        IFINOCTETS       => '75987',
                        IFPORTDUPLEX     => '3',
                        MAC              => '2C:6B:F5:9B:48:85'
                    },
                    {
                        IFDESCR          => 'ge-4/0/6',
                        IFNUMBER         => '766',
                        IFLASTCHANGE     => '(1578616548) 182 days, 17:02:45.48',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '891804136',
                        IFNAME           => 'ge-4/0/6',
                        IFTYPE           => '6',
                        IFINOCTETS       => '67480194',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '1',
                        IFSPEED          => '100000000',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        MAC              => '2C:6B:F5:9B:48:86'
                    },
                    {
                        IFLASTCHANGE     => '(1578616157) 182 days, 17:02:41.57',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '1633240401',
                        IFDESCR          => 'ge-4/0/7',
                        IFNUMBER         => '767',
                        IFINOCTETS       => '106356309',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '1',
                        IFNAME           => 'ge-4/0/7',
                        IFTYPE           => '6',
                        IFINERRORS       => '0',
                        IFSPEED          => '100000000',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        MAC              => '2C:6B:F5:9B:48:87'
                    },
                    {
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '100000000',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '87099310',
                        IFSTATUS         => '1',
                        IFNAME           => 'ge-4/0/8',
                        IFTYPE           => '6',
                        IFLASTCHANGE     => '(1574023308) 182 days, 4:17:13.08',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '1391538180',
                        IFDESCR          => 'ge-4/0/8',
                        IFNUMBER         => '768',
                        MAC              => '2C:6B:F5:9B:48:88'
                    },
                    {
                        IFNAME           => 'ge-4/0/9',
                        IFTYPE           => '6',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFSTATUS         => '2',
                        IFDESCR          => 'ge-4/0/9',
                        IFNUMBER         => '769',
                        IFLASTCHANGE     => '(1071466928) 124 days, 0:17:49.28',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        MAC              => '2C:6B:F5:9B:48:89'
                    },
                    {
                        IFSPEED          => '100000000',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFNUMBER         => '770',
                        IFDESCR          => 'ge-4/0/10',
                        IFOUTOCTETS      => '208218658',
                        IFLASTCHANGE     => '(1513317590) 175 days, 3:39:35.90',
                        IFMTU            => '1514',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-4/0/10',
                        IFSTATUS         => '2',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '28640055',
                        MAC              => '2C:6B:F5:9B:48:8A'
                    },
                    {
                        IFINERRORS       => '0',
                        IFSPEED          => '10000000',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '61900792',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1547189561) 179 days, 1:44:55.61',
                        IFNUMBER         => '771',
                        IFDESCR          => 'ge-4/0/11',
                        IFSTATUS         => '2',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '14848691',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-4/0/11',
                        MAC              => '2C:6B:F5:9B:48:8B'
                    },
                    {
                        IFNAME           => 'ge-4/0/19',
                        IFTYPE           => '6',
                        IFINOCTETS       => '25793187',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '2',
                        IFDESCR          => 'ge-4/0/19',
                        IFNUMBER         => '772',
                        IFLASTCHANGE     => '(1563849546) 181 days, 0:01:35.46',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '209641642',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '100000000',
                        IFINERRORS       => '0',
                        MAC              => '2C:6B:F5:9B:48:93'
                    },
                    {
                        IFNUMBER         => '773',
                        IFDESCR          => 'ge-4/0/20',
                        IFOUTOCTETS      => '708966548',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1457971644) 168 days, 17:55:16.44',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-4/0/20',
                        IFSTATUS         => '2',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '58823807',
                        IFSPEED          => '1000000000',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        MAC              => '2C:6B:F5:9B:48:94'
                    },
                    {
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '1000000000',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '16437056',
                        IFSTATUS         => '2',
                        IFNAME           => 'ge-4/0/21',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1260778133) 145 days, 22:09:41.33',
                        IFOUTOCTETS      => '78260776',
                        IFDESCR          => 'ge-4/0/21',
                        IFNUMBER         => '774',
                        MAC              => '2C:6B:F5:9B:48:95'
                    },
                    {
                        IFTYPE           => '6',
                        IFNAME           => 'ge-4/0/22',
                        IFSTATUS         => '2',
                        IFINOCTETS       => '8208903',
                        IFPORTDUPLEX     => '3',
                        IFNUMBER         => '775',
                        IFDESCR          => 'ge-4/0/22',
                        IFOUTOCTETS      => '117208148',
                        IFLASTCHANGE     => '(1521627060) 176 days, 2:44:30.60',
                        IFMTU            => '1514',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '1000000000',
                        IFINERRORS       => '0',
                        MAC              => '2C:6B:F5:9B:48:96'
                    },
                    {
                        IFINERRORS       => '0',
                        IFSPEED          => '100000000',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFLASTCHANGE     => '(1578618687) 182 days, 17:03:06.87',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '1035937653',
                        IFDESCR          => 'ge-4/0/23',
                        IFNUMBER         => '776',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '7348698',
                        IFSTATUS         => '1',
                        IFNAME           => 'ge-4/0/23',
                        IFTYPE           => '6',
                        MAC              => '2C:6B:F5:9B:48:97'
                    },
                    {
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '1000000000',
                        IFINERRORS       => '0',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-4/0/24',
                        IFSTATUS         => '2',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '182087782',
                        IFNUMBER         => '777',
                        IFDESCR          => 'ge-4/0/24',
                        IFOUTOCTETS      => '46782466',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1425677372) 165 days, 0:12:53.72',
                        MAC              => '2C:6B:F5:9B:48:98'
                    },
                    {
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '100000000',
                        IFINERRORS       => '0',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-4/0/25',
                        IFSTATUS         => '2',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '59330567',
                        IFNUMBER         => '778',
                        IFDESCR          => 'ge-4/0/25',
                        IFOUTOCTETS      => '106396743',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1424888386) 164 days, 22:01:23.86',
                        MAC              => '2C:6B:F5:9B:48:99'
                    },
                    {
                        IFSTATUS         => '2',
                        IFINOCTETS       => '32710818',
                        IFPORTDUPLEX     => '3',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-4/0/26',
                        IFOUTOCTETS      => '659616653',
                        IFLASTCHANGE     => '(1572311952) 181 days, 23:31:59.52',
                        IFMTU            => '1514',
                        IFNUMBER         => '779',
                        IFDESCR          => 'ge-4/0/26',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '1',
                        IFSPEED          => '10000000',
                        MAC              => '2C:6B:F5:9B:48:9A'
                    },
                    {
                        IFINERRORS       => '0',
                        IFSPEED          => '100000000',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1521697066) 176 days, 2:56:10.66',
                        IFOUTOCTETS      => '45929707',
                        IFDESCR          => 'ge-4/0/27',
                        IFNUMBER         => '780',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '12358989',
                        IFSTATUS         => '2',
                        IFNAME           => 'ge-4/0/27',
                        IFTYPE           => '6',
                        MAC              => '2C:6B:F5:9B:48:9B'
                    },
                    {
                        IFINOCTETS       => '6290653',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '2',
                        IFNAME           => 'ge-4/0/12',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1261267893) 145 days, 23:31:18.93',
                        IFOUTOCTETS      => '24869415',
                        IFDESCR          => 'ge-4/0/12',
                        IFNUMBER         => '781',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '1000000000',
                        MAC              => '2C:6B:F5:9B:48:8C'
                    },
                    {
                        IFINERRORS       => '0',
                        IFSPEED          => '1000000000',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '52432307',
                        IFLASTCHANGE     => '(1561658646) 180 days, 17:56:26.46',
                        IFMTU            => '1514',
                        IFNUMBER         => '782',
                        IFDESCR          => 'ge-4/0/28',
                        IFSTATUS         => '2',
                        IFINOCTETS       => '11989759',
                        IFPORTDUPLEX     => '3',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-4/0/28',
                        MAC              => '2C:6B:F5:9B:48:9C'
                    },
                    {
                        IFINERRORS       => '0',
                        IFSPEED          => '100000000',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFLASTCHANGE     => '(1504620827) 174 days, 3:30:08.27',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '12579632',
                        IFDESCR          => 'ge-4/0/29',
                        IFNUMBER         => '783',
                        IFINOCTETS       => '2091974',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '2',
                        IFNAME           => 'ge-4/0/29',
                        IFTYPE           => '6',
                        MAC              => '2C:6B:F5:9B:48:9D'
                    },
                    {
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '100000000',
                        IFSTATUS         => '2',
                        IFINOCTETS       => '18455400',
                        IFPORTDUPLEX     => '3',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-4/0/13',
                        IFOUTOCTETS      => '77489201',
                        IFLASTCHANGE     => '(1573227018) 182 days, 2:04:30.18',
                        IFMTU            => '1514',
                        IFNUMBER         => '784',
                        IFDESCR          => 'ge-4/0/13',
                        MAC              => '2C:6B:F5:9B:48:8D'
                    },
                    {
                        IFINOCTETS       => '16157248',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '2',
                        IFNAME           => 'ge-4/0/30',
                        IFTYPE           => '6',
                        IFLASTCHANGE     => '(1548020706) 179 days, 4:03:27.06',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '216770794',
                        IFDESCR          => 'ge-4/0/30',
                        IFNUMBER         => '785',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '100000000',
                        MAC              => '2C:6B:F5:9B:48:9E'
                    },
                    {
                        IFNUMBER         => '786',
                        IFDESCR          => 'ge-4/0/14',
                        IFOUTOCTETS      => '278801129',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1502383224) 173 days, 21:17:12.24',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-4/0/14',
                        IFSTATUS         => '2',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '74356189',
                        IFSPEED          => '1000000000',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        MAC              => '2C:6B:F5:9B:48:8E'
                    },
                    {
                        IFSTATUS         => '2',
                        IFINOCTETS       => '38081993',
                        IFPORTDUPLEX     => '3',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-4/0/31',
                        IFOUTOCTETS      => '211490099',
                        IFLASTCHANGE     => '(1444288680) 167 days, 3:54:46.80',
                        IFMTU            => '1514',
                        IFNUMBER         => '787',
                        IFDESCR          => 'ge-4/0/31',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '100000000',
                        MAC              => '2C:6B:F5:9B:48:9F'
                    },
                    {
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '1000000000',
                        IFINERRORS       => '0',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-4/0/32',
                        IFSTATUS         => '2',
                        IFINOCTETS       => '1556019',
                        IFPORTDUPLEX     => '3',
                        IFNUMBER         => '788',
                        IFDESCR          => 'ge-4/0/32',
                        IFOUTOCTETS      => '4349392',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1346820566) 155 days, 21:10:05.66',
                        MAC              => '2C:6B:F5:9B:48:A0'
                    },
                    {
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '100000000',
                        IFINOCTETS       => '21527530',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '2',
                        IFNAME           => 'ge-4/0/15',
                        IFTYPE           => '6',
                        IFLASTCHANGE     => '(1562688204) 180 days, 20:48:02.04',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '132061897',
                        IFDESCR          => 'ge-4/0/15',
                        IFNUMBER         => '789',
                        MAC              => '2C:6B:F5:9B:48:8F'
                    },
                    {
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '100000000',
                        IFINOCTETS       => '9155591',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '2',
                        IFNAME           => 'ge-4/0/33',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1494210849) 172 days, 22:35:08.49',
                        IFOUTOCTETS      => '23084470',
                        IFDESCR          => 'ge-4/0/33',
                        IFNUMBER         => '790',
                        MAC              => '2C:6B:F5:9B:48:A1'
                    },
                    {
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '100000000',
                        IFINERRORS       => '0',
                        IFNAME           => 'ge-4/0/34',
                        IFTYPE           => '6',
                        IFINOCTETS       => '55898539',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '1',
                        IFDESCR          => 'ge-4/0/34',
                        IFNUMBER         => '791',
                        IFLASTCHANGE     => '(1579356778) 182 days, 19:06:07.78',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '482021407',
                        MAC              => '2C:6B:F5:9B:48:A2'
                    },
                    {
                        IFLASTCHANGE     => '(1563844404) 181 days, 0:00:44.04',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '2329257',
                        IFDESCR          => 'ge-4/0/35',
                        IFNUMBER         => '792',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1037270',
                        IFSTATUS         => '2',
                        IFNAME           => 'ge-4/0/35',
                        IFTYPE           => '6',
                        IFINERRORS       => '0',
                        IFSPEED          => '1000000000',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        MAC              => '2C:6B:F5:9B:48:A3'
                    },
                    {
                        IFDESCR          => 'ge-4/0/36',
                        IFNUMBER         => '793',
                        IFLASTCHANGE     => '(1486855674) 172 days, 2:09:16.74',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '69718295',
                        IFNAME           => 'ge-4/0/36',
                        IFTYPE           => '6',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '12907713',
                        IFSTATUS         => '2',
                        IFSPEED          => '100000000',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        MAC              => '2C:6B:F5:9B:48:A4'
                    },
                    {
                        IFDESCR          => 'ge-4/0/16',
                        IFNUMBER         => '794',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1486971782) 172 days, 2:28:37.82',
                        IFOUTOCTETS      => '244357305',
                        IFNAME           => 'ge-4/0/16',
                        IFTYPE           => '6',
                        IFINOCTETS       => '23324170',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '2',
                        IFSPEED          => '100000000',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        MAC              => '2C:6B:F5:9B:48:90'
                    },
                    {
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '1000000000',
                        IFSTATUS         => '2',
                        IFINOCTETS       => '140430144',
                        IFPORTDUPLEX     => '3',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-4/0/37',
                        IFOUTOCTETS      => '2299666323',
                        IFLASTCHANGE     => '(1554987262) 179 days, 23:24:32.62',
                        IFMTU            => '1514',
                        IFNUMBER         => '795',
                        IFDESCR          => 'ge-4/0/37',
                        MAC              => '2C:6B:F5:9B:48:A5'
                    },
                    {
                        IFNUMBER         => '796',
                        IFDESCR          => 'ge-4/0/17',
                        IFOUTOCTETS      => '224139829',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1452293958) 168 days, 2:08:59.58',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-4/0/17',
                        IFSTATUS         => '2',
                        IFINOCTETS       => '24492045',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '100000000',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        MAC              => '2C:6B:F5:9B:48:91'
                    },
                    {
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '1000000000',
                        IFINERRORS       => '0',
                        IFNAME           => 'ge-4/0/38',
                        IFTYPE           => '6',
                        IFINOCTETS       => '10261944',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '2',
                        IFDESCR          => 'ge-4/0/38',
                        IFNUMBER         => '797',
                        IFLASTCHANGE     => '(1555608214) 180 days, 1:08:02.14',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '79620577',
                        MAC              => '2C:6B:F5:9B:48:A6'
                    },
                    {
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '100000000',
                        IFSTATUS         => '2',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '47468099',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-4/0/39',
                        IFOUTOCTETS      => '526945080',
                        IFLASTCHANGE     => '(1545422722) 178 days, 20:50:27.22',
                        IFMTU            => '1514',
                        IFNUMBER         => '798',
                        IFDESCR          => 'ge-4/0/39',
                        MAC              => '2C:6B:F5:9B:48:A7'
                    },
                    {
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '1000000000',
                        IFINOCTETS       => '20043930',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '2',
                        IFNAME           => 'ge-4/0/40',
                        IFTYPE           => '6',
                        IFLASTCHANGE     => '(1563754030) 180 days, 23:45:40.30',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '119143863',
                        IFDESCR          => 'ge-4/0/40',
                        IFNUMBER         => '799',
                        MAC              => '2C:6B:F5:9B:48:A8'
                    },
                    {
                        IFOUTOCTETS      => '56045039',
                        IFLASTCHANGE     => '(1555609888) 180 days, 1:08:18.88',
                        IFMTU            => '1514',
                        IFNUMBER         => '800',
                        IFDESCR          => 'ge-4/0/41',
                        IFSTATUS         => '2',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '11438989',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-4/0/41',
                        IFINERRORS       => '0',
                        IFSPEED          => '100000000',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        MAC              => '2C:6B:F5:9B:48:A9'
                    },
                    {
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '1000000000',
                        IFSTATUS         => '2',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '31559254',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-4/0/42',
                        IFOUTOCTETS      => '175945569',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1555987738) 180 days, 2:11:17.38',
                        IFNUMBER         => '801',
                        IFDESCR          => 'ge-4/0/42',
                        MAC              => '2C:6B:F5:9B:48:AA'
                    },
                    {
                        IFNUMBER         => '802',
                        IFDESCR          => 'ge-4/0/43',
                        IFOUTOCTETS      => '4597681',
                        IFLASTCHANGE     => '(1442185282) 166 days, 22:04:12.82',
                        IFMTU            => '1514',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-4/0/43',
                        IFSTATUS         => '2',
                        IFINOCTETS       => '1059664',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '1000000000',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        MAC              => '2C:6B:F5:9B:48:AB'
                    },
                    {
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '100000000',
                        IFINERRORS       => '0',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-4/0/44',
                        IFSTATUS         => '2',
                        IFINOCTETS       => '24234',
                        IFPORTDUPLEX     => '3',
                        IFNUMBER         => '803',
                        IFDESCR          => 'ge-4/0/44',
                        IFOUTOCTETS      => '21103',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1390509782) 160 days, 22:31:37.82',
                        MAC              => '2C:6B:F5:9B:48:AC'
                    },
                    {
                        IFSTATUS         => '2',
                        IFINOCTETS       => '41616761',
                        IFPORTDUPLEX     => '3',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-4/0/45',
                        IFOUTOCTETS      => '196610156',
                        IFLASTCHANGE     => '(1572042943) 181 days, 22:47:09.43',
                        IFMTU            => '1514',
                        IFNUMBER         => '804',
                        IFDESCR          => 'ge-4/0/45',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '100000000',
                        MAC              => '2C:6B:F5:9B:48:AD'
                    },
                    {
                        IFSTATUS         => '2',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3106421',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-4/0/46',
                        IFOUTOCTETS      => '18964541',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1277476099) 147 days, 20:32:40.99',
                        IFNUMBER         => '805',
                        IFDESCR          => 'ge-4/0/46',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '10000000',
                        MAC              => '2C:6B:F5:9B:48:AE'
                    },
                    {
                        IFOUTOCTETS      => '71662773',
                        IFLASTCHANGE     => '(1450302458) 167 days, 20:37:04.58',
                        IFMTU            => '1514',
                        IFNUMBER         => '806',
                        IFDESCR          => 'ge-4/0/47',
                        IFSTATUS         => '2',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '12594073',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-4/0/47',
                        IFINERRORS       => '0',
                        IFSPEED          => '1000000000',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        MAC              => '2C:6B:F5:9B:48:AF'
                    },
                    {
                        IFINERRORS       => '0',
                        IFSPEED          => '100000000',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '585',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1451188038) 167 days, 23:04:40.38',
                        IFNUMBER         => '807',
                        IFDESCR          => 'ge-4/0/18',
                        IFSTATUS         => '2',
                        IFINOCTETS       => '0',
                        IFPORTDUPLEX     => '3',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-4/0/18',
                        MAC              => '2C:6B:F5:9B:48:92'
                    },
                    {
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '100000000',
                        IFINOCTETS       => '108117',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '2',
                        IFNAME           => 'ge-5/0/0',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1555387048) 180 days, 0:31:10.48',
                        IFOUTOCTETS      => '0',
                        IFDESCR          => 'ge-5/0/0',
                        IFNUMBER         => '808',
                        MAC              => '2C:6B:F5:9B:48:80'
                    },
                    {
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '100000000',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '19041973',
                        IFSTATUS         => '2',
                        IFNAME           => 'ge-5/0/1',
                        IFTYPE           => '6',
                        IFLASTCHANGE     => '(1451300698) 167 days, 23:23:26.98',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '226123625',
                        IFDESCR          => 'ge-5/0/1',
                        IFNUMBER         => '809',
                        MAC              => '2C:6B:F5:9B:48:81'
                    },
                    {
                        IFSTATUS         => '2',
                        IFINOCTETS       => '4188493',
                        IFPORTDUPLEX     => '3',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-5/0/2',
                        IFOUTOCTETS      => '9809920',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1484763324) 171 days, 20:20:33.24',
                        IFNUMBER         => '810',
                        IFDESCR          => 'ge-5/0/2',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '10000000',
                        MAC              => '2C:6B:F5:9B:48:82'
                    },
                    {
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1555932102) 180 days, 2:02:01.02',
                        IFOUTOCTETS      => '455002923',
                        IFDESCR          => 'ge-5/0/3',
                        IFNUMBER         => '811',
                        IFINOCTETS       => '48671934',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '2',
                        IFNAME           => 'ge-5/0/3',
                        IFTYPE           => '6',
                        IFINERRORS       => '11',
                        IFSPEED          => '100000000',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        MAC              => '2C:6B:F5:9B:48:83'
                    },
                    {
                        IFSPEED          => '100000000',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFNUMBER         => '812',
                        IFDESCR          => 'ge-5/0/4',
                        IFOUTOCTETS      => '225047446',
                        IFLASTCHANGE     => '(1519665226) 175 days, 21:17:32.26',
                        IFMTU            => '1514',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-5/0/4',
                        IFSTATUS         => '2',
                        IFINOCTETS       => '26771024',
                        IFPORTDUPLEX     => '3',
                        MAC              => '2C:6B:F5:9B:48:84'
                    },
                    {
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '100000000',
                        IFINERRORS       => '0',
                        IFNAME           => 'ge-5/0/5',
                        IFTYPE           => '6',
                        IFINOCTETS       => '35815117',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '2',
                        IFDESCR          => 'ge-5/0/5',
                        IFNUMBER         => '813',
                        IFLASTCHANGE     => '(1424586254) 164 days, 21:11:02.54',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '133190535',
                        MAC              => '2C:6B:F5:9B:48:85'
                    },
                    {
                        IFINERRORS       => '0',
                        IFSPEED          => '100000000',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1572359425) 181 days, 23:39:54.25',
                        IFOUTOCTETS      => '118092175',
                        IFDESCR          => 'ge-5/0/6',
                        IFNUMBER         => '814',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '22128064',
                        IFSTATUS         => '2',
                        IFNAME           => 'ge-5/0/6',
                        IFTYPE           => '6',
                        MAC              => '2C:6B:F5:9B:48:86'
                    },
                    {
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '100000000',
                        IFSTATUS         => '2',
                        IFINOCTETS       => '1390694',
                        IFPORTDUPLEX     => '3',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-5/0/7',
                        IFOUTOCTETS      => '11391141',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1520500834) 175 days, 23:36:48.34',
                        IFNUMBER         => '815',
                        IFDESCR          => 'ge-5/0/7',
                        MAC              => '2C:6B:F5:9B:48:87'
                    },
                    {
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1457008',
                        IFSTATUS         => '2',
                        IFNAME           => 'ge-5/0/8',
                        IFTYPE           => '6',
                        IFLASTCHANGE     => '(1546292486) 178 days, 23:15:24.86',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '7694073',
                        IFDESCR          => 'ge-5/0/8',
                        IFNUMBER         => '816',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '100000000',
                        MAC              => '2C:6B:F5:9B:48:88'
                    },
                    {
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '100000000',
                        IFSTATUS         => '1',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '67458660',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-5/0/9',
                        IFOUTOCTETS      => '173983369',
                        IFLASTCHANGE     => '(1579320303) 182 days, 19:00:03.03',
                        IFMTU            => '1514',
                        IFNUMBER         => '817',
                        IFDESCR          => 'ge-5/0/9',
                        MAC              => '2C:6B:F5:9B:48:89'
                    },
                    {
                        IFNAME           => 'ge-5/0/10',
                        IFTYPE           => '6',
                        IFINOCTETS       => '3982718',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '2',
                        IFDESCR          => 'ge-5/0/10',
                        IFNUMBER         => '818',
                        IFLASTCHANGE     => '(1261147396) 145 days, 23:11:13.96',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '27342252',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '100000000',
                        IFINERRORS       => '0',
                        MAC              => '2C:6B:F5:9B:48:8A'
                    },
                    {
                        IFINERRORS       => '0',
                        IFSPEED          => '1000000000',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '4908155',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1554633641) 179 days, 22:25:36.41',
                        IFNUMBER         => '819',
                        IFDESCR          => 'ge-5/0/11',
                        IFSTATUS         => '2',
                        IFINOCTETS       => '1296155',
                        IFPORTDUPLEX     => '3',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-5/0/11',
                        MAC              => '2C:6B:F5:9B:48:8B'
                    },
                    {
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFNUMBER         => '820',
                        IFDESCR          => 'ge-5/0/12',
                        IFOUTOCTETS      => '0',
                        IFLASTCHANGE     => '(1071467479) 124 days, 0:17:54.79',
                        IFMTU            => '1514',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-5/0/12',
                        IFSTATUS         => '2',
                        IFINOCTETS       => '0',
                        IFPORTDUPLEX     => '3',
                        MAC              => '2C:6B:F5:9B:48:8C'
                    },
                    {
                        IFTYPE           => '6',
                        IFNAME           => 'ge-5/0/13',
                        IFSTATUS         => '2',
                        IFINOCTETS       => '8033027',
                        IFPORTDUPLEX     => '3',
                        IFNUMBER         => '821',
                        IFDESCR          => 'ge-5/0/13',
                        IFOUTOCTETS      => '28724098',
                        IFLASTCHANGE     => '(1254004460) 145 days, 3:20:44.60',
                        IFMTU            => '1514',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '1000000000',
                        IFINERRORS       => '0',
                        MAC              => '2C:6B:F5:9B:48:8D'
                    },
                    {
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '100000000',
                        IFSTATUS         => '2',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '12027799',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-5/0/18',
                        IFOUTOCTETS      => '292045902',
                        IFLASTCHANGE     => '(1565237721) 181 days, 3:52:57.21',
                        IFMTU            => '1514',
                        IFNUMBER         => '822',
                        IFDESCR          => 'ge-5/0/18',
                        MAC              => '2C:6B:F5:9B:48:92'
                    },
                    {
                        IFLASTCHANGE     => '(1459729300) 168 days, 22:48:13.00',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '37712327',
                        IFDESCR          => 'ge-5/0/19',
                        IFNUMBER         => '823',
                        IFINOCTETS       => '8454757',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '2',
                        IFNAME           => 'ge-5/0/19',
                        IFTYPE           => '6',
                        IFINERRORS       => '0',
                        IFSPEED          => '100000000',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        MAC              => '2C:6B:F5:9B:48:93'
                    },
                    {
                        IFLASTCHANGE     => '(1519633418) 175 days, 21:12:14.18',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '20751669',
                        IFDESCR          => 'ge-5/0/14',
                        IFNUMBER         => '824',
                        IFINOCTETS       => '7327759',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '2',
                        IFNAME           => 'ge-5/0/14',
                        IFTYPE           => '6',
                        IFINERRORS       => '0',
                        IFSPEED          => '100000000',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        MAC              => '2C:6B:F5:9B:48:8E'
                    },
                    {
                        IFDESCR          => 'ge-5/0/20',
                        IFNUMBER         => '825',
                        IFLASTCHANGE     => '(1553552604) 179 days, 19:25:26.04',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '1173177',
                        IFNAME           => 'ge-5/0/20',
                        IFTYPE           => '6',
                        IFINOCTETS       => '1145465',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '2',
                        IFSPEED          => '10000000',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        MAC              => '2C:6B:F5:9B:48:94'
                    },
                    {
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '100000000',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '5598588',
                        IFSTATUS         => '2',
                        IFNAME           => 'ge-5/0/21',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1562109850) 180 days, 19:11:38.50',
                        IFOUTOCTETS      => '99054163',
                        IFDESCR          => 'ge-5/0/21',
                        IFNUMBER         => '826',
                        MAC              => '2C:6B:F5:9B:48:95'
                    },
                    {
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '1000000000',
                        IFSTATUS         => '2',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '176329',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-5/0/15',
                        IFOUTOCTETS      => '91782',
                        IFLASTCHANGE     => '(1389868950) 160 days, 20:44:49.50',
                        IFMTU            => '1514',
                        IFNUMBER         => '827',
                        IFDESCR          => 'ge-5/0/15',
                        MAC              => '2C:6B:F5:9B:48:8F'
                    },
                    {
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '100000000',
                        IFSTATUS         => '2',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1734458',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-5/0/22',
                        IFOUTOCTETS      => '3745713',
                        IFLASTCHANGE     => '(1546933044) 179 days, 1:02:10.44',
                        IFMTU            => '1514',
                        IFNUMBER         => '828',
                        IFDESCR          => 'ge-5/0/22',
                        MAC              => '2C:6B:F5:9B:48:96'
                    },
                    {
                        IFSPEED          => '100000000',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFNUMBER         => '829',
                        IFDESCR          => 'ge-5/0/23',
                        IFOUTOCTETS      => '15728265',
                        IFLASTCHANGE     => '(1547856186) 179 days, 3:36:01.86',
                        IFMTU            => '1514',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-5/0/23',
                        IFSTATUS         => '2',
                        IFINOCTETS       => '5068741',
                        IFPORTDUPLEX     => '3',
                        MAC              => '2C:6B:F5:9B:48:97'
                    },
                    {
                        IFDESCR          => 'ge-5/0/16',
                        IFNUMBER         => '830',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1554786300) 179 days, 22:51:03.00',
                        IFOUTOCTETS      => '45982274',
                        IFNAME           => 'ge-5/0/16',
                        IFTYPE           => '6',
                        IFINOCTETS       => '13667656',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '2',
                        IFSPEED          => '1000000000',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        MAC              => '2C:6B:F5:9B:48:90'
                    },
                    {
                        IFSTATUS         => '2',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '214452',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-5/0/24',
                        IFOUTOCTETS      => '207402',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1571619548) 181 days, 21:36:35.48',
                        IFNUMBER         => '831',
                        IFDESCR          => 'ge-5/0/24',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '100000000',
                        MAC              => '2C:6B:F5:9B:48:98'
                    },
                    {
                        IFINERRORS       => '0',
                        IFSPEED          => '10000000',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1547593680) 179 days, 2:52:16.80',
                        IFOUTOCTETS      => '76692809',
                        IFDESCR          => 'ge-5/0/17',
                        IFNUMBER         => '832',
                        IFINOCTETS       => '23689293',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '2',
                        IFNAME           => 'ge-5/0/17',
                        IFTYPE           => '6',
                        MAC              => '2C:6B:F5:9B:48:91'
                    },
                    {
                        IFINOCTETS       => '4214149',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '2',
                        IFNAME           => 'ge-5/0/25',
                        IFTYPE           => '6',
                        IFLASTCHANGE     => '(1572400418) 181 days, 23:46:44.18',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '65567368',
                        IFDESCR          => 'ge-5/0/25',
                        IFNUMBER         => '833',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '100000000',
                        MAC              => '2C:6B:F5:9B:48:99'
                    },
                    {
                        IFNUMBER         => '834',
                        IFDESCR          => 'ge-5/0/26',
                        IFOUTOCTETS      => '40972797',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1484727143) 171 days, 20:14:31.43',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-5/0/26',
                        IFSTATUS         => '2',
                        IFINOCTETS       => '8375207',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '1000000000',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        MAC              => '2C:6B:F5:9B:48:9A'
                    },
                    {
                        IFINERRORS       => '0',
                        IFSPEED          => '1000000000',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFLASTCHANGE     => '(1443271750) 167 days, 1:05:17.50',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '1047348',
                        IFDESCR          => 'ge-5/0/27',
                        IFNUMBER         => '835',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '598634',
                        IFSTATUS         => '2',
                        IFNAME           => 'ge-5/0/27',
                        IFTYPE           => '6',
                        MAC              => '2C:6B:F5:9B:48:9B'
                    },
                    {
                        IFDESCR          => 'ge-5/0/28',
                        IFNUMBER         => '836',
                        IFLASTCHANGE     => '(1432715230) 165 days, 19:45:52.30',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '909',
                        IFNAME           => 'ge-5/0/28',
                        IFTYPE           => '6',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2358',
                        IFSTATUS         => '2',
                        IFSPEED          => '1000000000',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        MAC              => '2C:6B:F5:9B:48:9C'
                    },
                    {
                        IFDESCR          => 'ge-5/0/29',
                        IFNUMBER         => '837',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1365333952) 158 days, 0:35:39.52',
                        IFOUTOCTETS      => '181589184',
                        IFNAME           => 'ge-5/0/29',
                        IFTYPE           => '6',
                        IFINOCTETS       => '76433233',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '2',
                        IFSPEED          => '1000000000',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        MAC              => '2C:6B:F5:9B:48:9D'
                    },
                    {
                        IFINERRORS       => '0',
                        IFSPEED          => '100000000',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFLASTCHANGE     => '(1556438310) 180 days, 3:26:23.10',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '38992306',
                        IFDESCR          => 'ge-5/0/30',
                        IFNUMBER         => '838',
                        IFINOCTETS       => '10015009',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '2',
                        IFNAME           => 'ge-5/0/30',
                        IFTYPE           => '6',
                        MAC              => '2C:6B:F5:9B:48:9E'
                    },
                    {
                        IFNAME           => 'ge-5/0/31',
                        IFTYPE           => '6',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '4234374',
                        IFSTATUS         => '2',
                        IFDESCR          => 'ge-5/0/31',
                        IFNUMBER         => '839',
                        IFLASTCHANGE     => '(1363902920) 157 days, 20:37:09.20',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '77300633',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '1000000000',
                        IFINERRORS       => '0',
                        MAC              => '2C:6B:F5:9B:48:9F'
                    },
                    {
                        IFTYPE           => '6',
                        IFNAME           => 'ge-5/0/32',
                        IFSTATUS         => '2',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '7094065',
                        IFNUMBER         => '840',
                        IFDESCR          => 'ge-5/0/32',
                        IFOUTOCTETS      => '50617583',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1510880886) 174 days, 20:53:28.86',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '100000000',
                        IFINERRORS       => '0',
                        MAC              => '2C:6B:F5:9B:48:A0'
                    },
                    {
                        IFSTATUS         => '2',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-5/0/33',
                        IFOUTOCTETS      => '0',
                        IFLASTCHANGE     => '(1071467587) 124 days, 0:17:55.87',
                        IFMTU            => '1514',
                        IFNUMBER         => '841',
                        IFDESCR          => 'ge-5/0/33',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        MAC              => '2C:6B:F5:9B:48:A1'
                    },
                    {
                        IFDESCR          => 'ge-5/0/34',
                        IFNUMBER         => '842',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1390508038) 160 days, 22:31:20.38',
                        IFOUTOCTETS      => '56410855',
                        IFNAME           => 'ge-5/0/34',
                        IFTYPE           => '6',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2292784',
                        IFSTATUS         => '2',
                        IFSPEED          => '1000000000',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        MAC              => '2C:6B:F5:9B:48:A2'
                    },
                    {
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFDESCR          => 'ge-5/0/35',
                        IFNUMBER         => '843',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1071467590) 124 days, 0:17:55.90',
                        IFOUTOCTETS      => '0',
                        IFNAME           => 'ge-5/0/35',
                        IFTYPE           => '6',
                        IFINOCTETS       => '0',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '2',
                        MAC              => '2C:6B:F5:9B:48:A3'
                    },
                    {
                        IFNAME           => 'ge-5/0/36',
                        IFTYPE           => '6',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '6056220',
                        IFSTATUS         => '2',
                        IFDESCR          => 'ge-5/0/36',
                        IFNUMBER         => '844',
                        IFLASTCHANGE     => '(1391353106) 161 days, 0:52:11.06',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '136939566',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '100000000',
                        IFINERRORS       => '0',
                        MAC              => '2C:6B:F5:9B:48:A4'
                    },
                    {
                        IFNAME           => 'ge-5/0/37',
                        IFTYPE           => '6',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2521918',
                        IFSTATUS         => '2',
                        IFDESCR          => 'ge-5/0/37',
                        IFNUMBER         => '845',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1391354470) 161 days, 0:52:24.70',
                        IFOUTOCTETS      => '5653408',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '1000000000',
                        IFINERRORS       => '0',
                        MAC              => '2C:6B:F5:9B:48:A5'
                    },
                    {
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-5/0/38',
                        IFSTATUS         => '2',
                        IFINOCTETS       => '0',
                        IFPORTDUPLEX     => '3',
                        IFNUMBER         => '846',
                        IFDESCR          => 'ge-5/0/38',
                        IFOUTOCTETS      => '0',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1071467603) 124 days, 0:17:56.03',
                        MAC              => '2C:6B:F5:9B:48:A6'
                    },
                    {
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '1000000000',
                        IFSTATUS         => '2',
                        IFINOCTETS       => '515256634',
                        IFPORTDUPLEX     => '3',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-5/0/39',
                        IFOUTOCTETS      => '1209604228',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1573567062) 182 days, 3:01:10.62',
                        IFNUMBER         => '847',
                        IFDESCR          => 'ge-5/0/39',
                        MAC              => '2C:6B:F5:9B:48:A7'
                    },
                    {
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '100000000',
                        IFINERRORS       => '0',
                        IFNAME           => 'ge-5/0/40',
                        IFTYPE           => '6',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '380129',
                        IFSTATUS         => '2',
                        IFDESCR          => 'ge-5/0/40',
                        IFNUMBER         => '848',
                        IFLASTCHANGE     => '(1510174312) 174 days, 18:55:43.12',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '2578674',
                        MAC              => '2C:6B:F5:9B:48:A8'
                    },
                    {
                        IFDESCR          => 'ge-5/0/41',
                        IFNUMBER         => '849',
                        IFLASTCHANGE     => '(1071467613) 124 days, 0:17:56.13',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '0',
                        IFNAME           => 'ge-5/0/41',
                        IFTYPE           => '6',
                        IFINOCTETS       => '0',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '2',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        MAC              => '2C:6B:F5:9B:48:A9'
                    },
                    {
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '1000000000',
                        IFINERRORS       => '0',
                        IFNAME           => 'ge-5/0/42',
                        IFTYPE           => '6',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1909371630',
                        IFSTATUS         => '1',
                        IFDESCR          => 'ge-5/0/42',
                        IFNUMBER         => '850',
                        IFLASTCHANGE     => '(1578548403) 182 days, 16:51:24.03',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '2300728794',
                        MAC              => '2C:6B:F5:9B:48:AA'
                    },
                    {
                        IFSTATUS         => '2',
                        IFINOCTETS       => '0',
                        IFPORTDUPLEX     => '3',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-5/0/43',
                        IFOUTOCTETS      => '0',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1071467619) 124 days, 0:17:56.19',
                        IFNUMBER         => '851',
                        IFDESCR          => 'ge-5/0/43',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        MAC              => '2C:6B:F5:9B:48:AB'
                    },
                    {
                        IFSTATUS         => '2',
                        IFINOCTETS       => '141601590',
                        IFPORTDUPLEX     => '3',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-5/0/44',
                        IFOUTOCTETS      => '2234563808',
                        IFLASTCHANGE     => '(1521519295) 176 days, 2:26:32.95',
                        IFMTU            => '1514',
                        IFNUMBER         => '852',
                        IFDESCR          => 'ge-5/0/44',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '1000000000',
                        MAC              => '2C:6B:F5:9B:48:AC'
                    },
                    {
                        IFNUMBER         => '853',
                        IFDESCR          => 'ge-5/0/45',
                        IFOUTOCTETS      => '1443091799',
                        IFLASTCHANGE     => '(1071469953) 124 days, 0:18:19.53',
                        IFMTU            => '1514',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-5/0/45',
                        IFSTATUS         => '1',
                        IFINOCTETS       => '277977600',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '100000000',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        MAC              => '2C:6B:F5:9B:48:AD'
                    },
                    {
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '301200202',
                        IFSTATUS         => '1',
                        IFNAME           => 'ge-5/0/46',
                        IFTYPE           => '6',
                        IFLASTCHANGE     => '(1071469953) 124 days, 0:18:19.53',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '1479450375',
                        IFDESCR          => 'ge-5/0/46',
                        IFNUMBER         => '854',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '100000000',
                        MAC              => '2C:6B:F5:9B:48:AE'
                    },
                    {
                        IFINERRORS       => '0',
                        IFSPEED          => '1000000000',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '2661505111',
                        IFLASTCHANGE     => '(1071481912) 124 days, 0:20:19.12',
                        IFMTU            => '1514',
                        IFNUMBER         => '855',
                        IFDESCR          => 'ge-5/0/47',
                        IFSTATUS         => '1',
                        IFINOCTETS       => '1545186482',
                        IFPORTDUPLEX     => '3',
                        IFTYPE           => '6',
                        IFNAME           => 'ge-5/0/47',
                        MAC              => '2C:6B:F5:9B:48:AF'
                    },
                    {
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '4294967295',
                        IFINERRORS       => '0',
                        IFNAME           => 'xe-5/1/0',
                        IFTYPE           => '6',
                        IFINOCTETS       => '2273452514',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '1',
                        IFDESCR          => 'xe-5/1/0',
                        IFNUMBER         => '856',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1071469993) 124 days, 0:18:19.93',
                        IFOUTOCTETS      => '4112460048',
                        MAC              => '2C:6B:F5:9B:48:80'
                    },
                    {
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '4294967295',
                        IFINERRORS       => '0',
                        IFNAME           => 'xe-2/1/0.0',
                        IFTYPE           => '53',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1488',
                        IFSTATUS         => '1',
                        IFDESCR          => 'xe-2/1/0.0',
                        IFNUMBER         => '857',
                        IFLASTCHANGE     => '(889650343) 102 days, 23:15:03.43',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '71723173',
                        MAC              => '2C:6B:F5:9B:48:80'
                    },
                    {
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '744',
                        IFSTATUS         => '1',
                        IFNAME           => 'xe-5/1/0.0',
                        IFTYPE           => '53',
                        IFLASTCHANGE     => '(1071469993) 124 days, 0:18:19.93',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '330232315',
                        IFDESCR          => 'xe-5/1/0.0',
                        IFNUMBER         => '858',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '4294967295',
                        MAC              => '2C:6B:F5:9B:48:80'
                    },
                    {
                        IFDESCR          => 'ge-1/0/13.0',
                        IFNUMBER         => '859',
                        IFLASTCHANGE     => '(717450703) 83 days, 0:55:07.03',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '0',
                        IFNAME           => 'ge-1/0/13.0',
                        IFTYPE           => '53',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFSTATUS         => '7',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        MAC              => '2C:6B:F5:9B:48:8D'
                    },
                    {
                        CONNECTIONS => {
                            CONNECTION => {
                                MAC => [
                                    '00:27:0C:58:68:2D'
                                ]
                            }
                        },
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFNUMBER         => '860',
                        IFDESCR          => 'ge-1/0/14.0',
                        IFOUTOCTETS      => '579998571',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(717452073) 83 days, 0:55:20.73',
                        IFTYPE           => '53',
                        IFNAME           => 'ge-1/0/14.0',
                        IFSTATUS         => '1',
                        IFINOCTETS       => '37518681',
                        IFPORTDUPLEX     => '3',
                        MAC              => '2C:6B:F5:9B:48:8E'
                    },
                    {
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFSTATUS         => '7',
                        IFNAME           => 'ge-1/0/15.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(717450742) 83 days, 0:55:07.42',
                        IFOUTOCTETS      => '0',
                        IFDESCR          => 'ge-1/0/15.0',
                        IFNUMBER         => '861',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        MAC              => '2C:6B:F5:9B:48:8F'
                    },
                    {
                        IFTYPE           => '53',
                        IFNAME           => 'ge-1/0/16.0',
                        IFSTATUS         => '7',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFNUMBER         => '862',
                        IFDESCR          => 'ge-1/0/16.0',
                        IFOUTOCTETS      => '0',
                        IFLASTCHANGE     => '(717450758) 83 days, 0:55:07.58',
                        IFMTU            => '1514',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        MAC              => '2C:6B:F5:9B:48:90'
                    },
                    {
                        IFOUTOCTETS      => '0',
                        IFLASTCHANGE     => '(717450767) 83 days, 0:55:07.67',
                        IFMTU            => '1514',
                        IFNUMBER         => '863',
                        IFDESCR          => 'ge-1/0/17.0',
                        IFSTATUS         => '7',
                        IFINOCTETS       => '0',
                        IFPORTDUPLEX     => '3',
                        IFTYPE           => '53',
                        IFNAME           => 'ge-1/0/17.0',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        MAC              => '2C:6B:F5:9B:48:91'
                    },
                    {
                        IFTYPE           => '53',
                        IFNAME           => 'ge-1/0/18.0',
                        IFSTATUS         => '7',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFNUMBER         => '864',
                        IFDESCR          => 'ge-1/0/18.0',
                        IFOUTOCTETS      => '0',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(717450774) 83 days, 0:55:07.74',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        MAC              => '2C:6B:F5:9B:48:92'
                    },
                    {
                        IFTYPE           => '53',
                        IFNAME           => 'ge-1/0/19.0',
                        IFSTATUS         => '1',
                        IFINOCTETS       => '4809495',
                        IFPORTDUPLEX     => '3',
                        IFNUMBER         => '865',
                        IFDESCR          => 'ge-1/0/19.0',
                        IFOUTOCTETS      => '231735707',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1579481427) 182 days, 19:26:54.27',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        MAC              => '2C:6B:F5:9B:48:93'
                    },
                    {
                        IFINOCTETS       => '4146130',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '1',
                        IFNAME           => 'ge-1/0/2.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1518159237) 175 days, 17:06:32.37',
                        IFOUTOCTETS      => '558700068',
                        IFDESCR          => 'ge-1/0/2.0',
                        IFNUMBER         => '866',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        MAC              => '2C:6B:F5:9B:48:82'
                    },
                    {
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFDESCR          => 'ge-1/0/20.0',
                        IFNUMBER         => '867',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1578881557) 182 days, 17:46:55.57',
                        IFOUTOCTETS      => '275850692',
                        IFNAME           => 'ge-1/0/20.0',
                        IFTYPE           => '53',
                        IFINOCTETS       => '5033863',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '1',
                        MAC              => '2C:6B:F5:9B:48:94'
                    },
                    {
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '0',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(717450784) 83 days, 0:55:07.84',
                        IFNUMBER         => '868',
                        IFDESCR          => 'ge-1/0/21.0',
                        IFSTATUS         => '7',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFTYPE           => '53',
                        IFNAME           => 'ge-1/0/21.0',
                        MAC              => '2C:6B:F5:9B:48:95'
                    },
                    {
                        IFNUMBER         => '869',
                        IFDESCR          => 'ge-1/0/22.0',
                        IFOUTOCTETS      => '0',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(717450786) 83 days, 0:55:07.86',
                        IFTYPE           => '53',
                        IFNAME           => 'ge-1/0/22.0',
                        IFSTATUS         => '7',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        MAC              => '2C:6B:F5:9B:48:96'
                    },
                    {
                        IFTYPE           => '53',
                        IFNAME           => 'ge-1/0/23.0',
                        IFSTATUS         => '7',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFNUMBER         => '870',
                        IFDESCR          => 'ge-1/0/23.0',
                        IFOUTOCTETS      => '0',
                        IFLASTCHANGE     => '(717450789) 83 days, 0:55:07.89',
                        IFMTU            => '1514',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        MAC              => '2C:6B:F5:9B:48:97'
                    },
                    {
                        IFINOCTETS       => '3680489',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '7',
                        IFNAME           => 'ge-1/0/24.0',
                        IFTYPE           => '53',
                        IFLASTCHANGE     => '(1573311367) 182 days, 2:18:33.67',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '61557623',
                        IFDESCR          => 'ge-1/0/24.0',
                        IFNUMBER         => '871',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        MAC              => '2C:6B:F5:9B:48:98'
                    },
                    {
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        IFINOCTETS       => '12971366',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '1',
                        IFNAME           => 'ge-1/0/25.0',
                        IFTYPE           => '53',
                        IFLASTCHANGE     => '(1578898697) 182 days, 17:49:46.97',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '88783975',
                        IFDESCR          => 'ge-1/0/25.0',
                        IFNUMBER         => '872',
                        MAC              => '2C:6B:F5:9B:48:99'
                    },
                    {
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFNUMBER         => '873',
                        IFDESCR          => 'ge-1/0/26.0',
                        IFOUTOCTETS      => '438265',
                        IFLASTCHANGE     => '(1277650841) 147 days, 21:01:48.41',
                        IFMTU            => '1514',
                        IFTYPE           => '53',
                        IFNAME           => 'ge-1/0/26.0',
                        IFSTATUS         => '7',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '33323',
                        MAC              => '2C:6B:F5:9B:48:9A'
                    },
                    {
                        IFSTATUS         => '7',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFTYPE           => '53',
                        IFNAME           => 'ge-1/0/27.0',
                        IFOUTOCTETS      => '0',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(717450825) 83 days, 0:55:08.25',
                        IFNUMBER         => '874',
                        IFDESCR          => 'ge-1/0/27.0',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        MAC              => '2C:6B:F5:9B:48:9B'
                    },
                    {
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFDESCR          => 'ge-1/0/28.0',
                        IFNUMBER         => '875',
                        IFLASTCHANGE     => '(975037268) 112 days, 20:26:12.68',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '486269',
                        IFNAME           => 'ge-1/0/28.0',
                        IFTYPE           => '53',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '47896',
                        IFSTATUS         => '7',
                        MAC              => '2C:6B:F5:9B:48:9C'
                    },
                    {
                        IFNUMBER         => '876',
                        IFDESCR          => 'ge-1/0/29.0',
                        IFOUTOCTETS      => '145945569',
                        IFLASTCHANGE     => '(1579233077) 182 days, 18:45:30.77',
                        IFMTU            => '1514',
                        IFTYPE           => '53',
                        IFNAME           => 'ge-1/0/29.0',
                        IFSTATUS         => '1',
                        IFINOCTETS       => '978662',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        MAC              => '2C:6B:F5:9B:48:9D'
                    },
                    {
                        IFTYPE           => '53',
                        IFNAME           => 'ge-1/0/3.0',
                        IFSTATUS         => '7',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFNUMBER         => '877',
                        IFDESCR          => 'ge-1/0/3.0',
                        IFOUTOCTETS      => '0',
                        IFLASTCHANGE     => '(717450570) 83 days, 0:55:05.70',
                        IFMTU            => '1514',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        MAC              => '2C:6B:F5:9B:48:83'
                    },
                    {
                        IFNUMBER         => '878',
                        IFDESCR          => 'ge-1/0/30.0',
                        IFOUTOCTETS      => '0',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(717450846) 83 days, 0:55:08.46',
                        IFTYPE           => '53',
                        IFNAME           => 'ge-1/0/30.0',
                        IFSTATUS         => '7',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        MAC              => '2C:6B:F5:9B:48:9E'
                    },
                    {
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFSTATUS         => '7',
                        IFNAME           => 'ge-1/0/31.0',
                        IFTYPE           => '53',
                        IFLASTCHANGE     => '(717450851) 83 days, 0:55:08.51',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '0',
                        IFDESCR          => 'ge-1/0/31.0',
                        IFNUMBER         => '879',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        MAC              => '2C:6B:F5:9B:48:9F'
                    },
                    {
                        IFSTATUS         => '7',
                        IFINOCTETS       => '0',
                        IFPORTDUPLEX     => '3',
                        IFTYPE           => '53',
                        IFNAME           => 'ge-1/0/32.0',
                        IFOUTOCTETS      => '0',
                        IFLASTCHANGE     => '(717450860) 83 days, 0:55:08.60',
                        IFMTU            => '1514',
                        IFNUMBER         => '880',
                        IFDESCR          => 'ge-1/0/32.0',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        MAC              => '2C:6B:F5:9B:48:A0'
                    },
                    {
                        IFDESCR          => 'ge-1/0/33.0',
                        IFNUMBER         => '881',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1564340617) 181 days, 1:23:26.17',
                        IFOUTOCTETS      => '81620896',
                        IFNAME           => 'ge-1/0/33.0',
                        IFTYPE           => '53',
                        IFINOCTETS       => '1240794',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '7',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        MAC              => '2C:6B:F5:9B:48:A1'
                    },
                    {
                        IFDESCR          => 'ge-1/0/34.0',
                        IFNUMBER         => '882',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(717450875) 83 days, 0:55:08.75',
                        IFOUTOCTETS      => '0',
                        IFNAME           => 'ge-1/0/34.0',
                        IFTYPE           => '53',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFSTATUS         => '7',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        MAC              => '2C:6B:F5:9B:48:A2'
                    },
                    {
                        IFSTATUS         => '7',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFTYPE           => '53',
                        IFNAME           => 'ge-1/0/35.0',
                        IFOUTOCTETS      => '0',
                        IFLASTCHANGE     => '(717450885) 83 days, 0:55:08.85',
                        IFMTU            => '1514',
                        IFNUMBER         => '883',
                        IFDESCR          => 'ge-1/0/35.0',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        MAC              => '2C:6B:F5:9B:48:A3'
                    },
                    {
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFNAME           => 'ge-1/0/36.0',
                        IFTYPE           => '53',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFSTATUS         => '7',
                        IFDESCR          => 'ge-1/0/36.0',
                        IFNUMBER         => '884',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(717450897) 83 days, 0:55:08.97',
                        IFOUTOCTETS      => '0',
                        MAC              => '2C:6B:F5:9B:48:A4'
                    },
                    {
                        IFOUTOCTETS      => '557581059',
                        IFLASTCHANGE     => '(1563250557) 180 days, 22:21:45.57',
                        IFMTU            => '1514',
                        IFNUMBER         => '885',
                        IFDESCR          => 'ge-1/0/37.0',
                        IFSTATUS         => '1',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '157173',
                        IFTYPE           => '53',
                        IFNAME           => 'ge-1/0/37.0',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        MAC              => '2C:6B:F5:9B:48:A5'
                    },
                    {
                        IFSTATUS         => '7',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFTYPE           => '53',
                        IFNAME           => 'ge-1/0/38.0',
                        IFOUTOCTETS      => '0',
                        IFLASTCHANGE     => '(717450906) 83 days, 0:55:09.06',
                        IFMTU            => '1514',
                        IFNUMBER         => '886',
                        IFDESCR          => 'ge-1/0/38.0',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        MAC              => '2C:6B:F5:9B:48:A6'
                    },
                    {
                        IFDESCR          => 'ge-1/0/39.0',
                        IFNUMBER         => '887',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1578926177) 182 days, 17:54:21.77',
                        IFOUTOCTETS      => '22582434',
                        IFNAME           => 'ge-1/0/39.0',
                        IFTYPE           => '53',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '439536',
                        IFSTATUS         => '1',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        MAC              => '2C:6B:F5:9B:48:A7'
                    },
                    {
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        IFINOCTETS       => '4487602',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '1',
                        IFNAME           => 'ge-1/0/4.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1579371027) 182 days, 19:08:30.27',
                        IFOUTOCTETS      => '81018645',
                        IFDESCR          => 'ge-1/0/4.0',
                        IFNUMBER         => '888',
                        MAC              => '2C:6B:F5:9B:48:84'
                    },
                    {
                        IFDESCR          => 'ge-1/0/40.0',
                        IFNUMBER         => '889',
                        IFLASTCHANGE     => '(889630237) 102 days, 23:11:42.37',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '526809134',
                        IFNAME           => 'ge-1/0/40.0',
                        IFTYPE           => '53',
                        IFINOCTETS       => '77870',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '1',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        MAC              => '2C:6B:F5:9B:48:A8'
                    },
                    {
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '202825',
                        IFSTATUS         => '1',
                        IFNAME           => 'ge-1/0/41.0',
                        IFTYPE           => '53',
                        IFLASTCHANGE     => '(1579225957) 182 days, 18:44:19.57',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '154169972',
                        IFDESCR          => 'ge-1/0/41.0',
                        IFNUMBER         => '890',
                        MAC              => '2C:6B:F5:9B:48:A9'
                    },
                    {
                        IFOUTOCTETS      => '559025754',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1547175007) 179 days, 1:42:30.07',
                        IFNUMBER         => '891',
                        IFDESCR          => 'ge-1/0/42.0',
                        IFSTATUS         => '1',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2001766',
                        IFTYPE           => '53',
                        IFNAME           => 'ge-1/0/42.0',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        MAC              => '2C:6B:F5:9B:48:AA'
                    },
                    {
                        IFNUMBER         => '892',
                        IFDESCR          => 'ge-1/0/43.0',
                        IFOUTOCTETS      => '554394456',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1562377137) 180 days, 19:56:11.37',
                        IFTYPE           => '53',
                        IFNAME           => 'ge-1/0/43.0',
                        IFSTATUS         => '1',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '125601',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        MAC              => '2C:6B:F5:9B:48:AB'
                    },
                    {
                        IFDESCR          => 'ge-1/0/44.0',
                        IFNUMBER         => '893',
                        IFLASTCHANGE     => '(717450953) 83 days, 0:55:09.53',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '0',
                        IFNAME           => 'ge-1/0/44.0',
                        IFTYPE           => '53',
                        IFINOCTETS       => '0',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '7',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        MAC              => '2C:6B:F5:9B:48:AC'
                    },
                    {
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(717450959) 83 days, 0:55:09.59',
                        IFOUTOCTETS      => '0',
                        IFDESCR          => 'ge-1/0/45.0',
                        IFNUMBER         => '894',
                        IFINOCTETS       => '0',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '7',
                        IFNAME           => 'ge-1/0/45.0',
                        IFTYPE           => '53',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        MAC              => '2C:6B:F5:9B:48:AD'
                    },
                    {
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFNUMBER         => '895',
                        IFDESCR          => 'ge-1/0/46.0',
                        IFOUTOCTETS      => '0',
                        IFLASTCHANGE     => '(717450968) 83 days, 0:55:09.68',
                        IFMTU            => '1514',
                        IFTYPE           => '53',
                        IFNAME           => 'ge-1/0/46.0',
                        IFSTATUS         => '7',
                        IFINOCTETS       => '0',
                        IFPORTDUPLEX     => '3',
                        MAC              => '2C:6B:F5:9B:48:AE'
                    },
                    {
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFNAME           => 'ge-1/0/47.0',
                        IFTYPE           => '53',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFSTATUS         => '7',
                        IFDESCR          => 'ge-1/0/47.0',
                        IFNUMBER         => '896',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(717450976) 83 days, 0:55:09.76',
                        IFOUTOCTETS      => '0',
                        MAC              => '2C:6B:F5:9B:48:AF'
                    },
                    {
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFNAME           => 'ge-1/0/5.0',
                        IFTYPE           => '53',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFSTATUS         => '7',
                        IFDESCR          => 'ge-1/0/5.0',
                        IFNUMBER         => '897',
                        IFLASTCHANGE     => '(717450583) 83 days, 0:55:05.83',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '0',
                        MAC              => '2C:6B:F5:9B:48:85'
                    },
                    {
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        IFSTATUS         => '7',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '48063',
                        IFTYPE           => '53',
                        IFNAME           => 'ge-1/0/6.0',
                        IFOUTOCTETS      => '335567',
                        IFLASTCHANGE     => '(1303083182) 150 days, 19:40:31.82',
                        IFMTU            => '1514',
                        IFNUMBER         => '898',
                        IFDESCR          => 'ge-1/0/6.0',
                        MAC              => '2C:6B:F5:9B:48:86'
                    },
                    {
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFDESCR          => 'ge-1/0/7.0',
                        IFNUMBER         => '899',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(717450604) 83 days, 0:55:06.04',
                        IFOUTOCTETS      => '0',
                        IFNAME           => 'ge-1/0/7.0',
                        IFTYPE           => '53',
                        IFINOCTETS       => '0',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '7',
                        MAC              => '2C:6B:F5:9B:48:87'
                    },
                    {
                        IFOUTOCTETS      => '0',
                        IFLASTCHANGE     => '(717450618) 83 days, 0:55:06.18',
                        IFMTU            => '1514',
                        IFNUMBER         => '900',
                        IFDESCR          => 'ge-1/0/8.0',
                        IFSTATUS         => '7',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFTYPE           => '53',
                        IFNAME           => 'ge-1/0/8.0',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        MAC              => '2C:6B:F5:9B:48:88'
                    },
                    {
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFLASTCHANGE     => '(1380784997) 159 days, 19:30:49.97',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '558733495',
                        IFDESCR          => 'ge-1/0/9.0',
                        IFNUMBER         => '901',
                        IFINOCTETS       => '123727',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '1',
                        IFNAME           => 'ge-1/0/9.0',
                        IFTYPE           => '53',
                        MAC              => '2C:6B:F5:9B:48:89'
                    },
                    {
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        IFINOCTETS       => '0',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '7',
                        IFNAME           => 'ge-2/0/0.0',
                        IFTYPE           => '53',
                        IFLASTCHANGE     => '(889649022) 102 days, 23:14:50.22',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '0',
                        IFDESCR          => 'ge-2/0/0.0',
                        IFNUMBER         => '902',
                        MAC              => '2C:6B:F5:9B:48:80'
                    },
                    {
                        IFSTATUS         => '7',
                        IFINOCTETS       => '66569',
                        IFPORTDUPLEX     => '3',
                        IFTYPE           => '53',
                        IFNAME           => 'ge-2/0/1.0',
                        IFOUTOCTETS      => '4920691',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1277376497) 147 days, 20:16:04.97',
                        IFNUMBER         => '903',
                        IFDESCR          => 'ge-2/0/1.0',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        MAC              => '2C:6B:F5:9B:48:81'
                    },
                    {
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFDESCR          => 'ge-2/0/10.0',
                        IFNUMBER         => '904',
                        IFLASTCHANGE     => '(889649029) 102 days, 23:14:50.29',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '0',
                        IFNAME           => 'ge-2/0/10.0',
                        IFTYPE           => '53',
                        IFINOCTETS       => '0',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '7',
                        MAC              => '2C:6B:F5:9B:48:8A'
                    },
                    {
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1578979224) 182 days, 18:03:12.24',
                        IFOUTOCTETS      => '446314475',
                        IFDESCR          => 'ge-2/0/11.0',
                        IFNUMBER         => '905',
                        IFINOCTETS       => '107861',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '1',
                        IFNAME           => 'ge-2/0/11.0',
                        IFTYPE           => '53',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        MAC              => '2C:6B:F5:9B:48:8B'
                    },
                    {
                        IFDESCR          => 'ge-2/0/12.0',
                        IFNUMBER         => '906',
                        IFLASTCHANGE     => '(1578972824) 182 days, 18:02:08.24',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '446320174',
                        IFNAME           => 'ge-2/0/12.0',
                        IFTYPE           => '53',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '84585',
                        IFSTATUS         => '1',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        MAC              => '2C:6B:F5:9B:48:8C'
                    },
                    {
                        IFDESCR          => 'ge-2/0/13.0',
                        IFNUMBER         => '907',
                        IFLASTCHANGE     => '(889649030) 102 days, 23:14:50.30',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '0',
                        IFNAME           => 'ge-2/0/13.0',
                        IFTYPE           => '53',
                        IFINOCTETS       => '0',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '7',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        MAC              => '2C:6B:F5:9B:48:8D'
                    },
                    {
                        IFDESCR          => 'ge-2/0/14.0',
                        IFNUMBER         => '908',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(889649031) 102 days, 23:14:50.31',
                        IFOUTOCTETS      => '0',
                        IFNAME           => 'ge-2/0/14.0',
                        IFTYPE           => '53',
                        IFINOCTETS       => '0',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '7',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        MAC              => '2C:6B:F5:9B:48:8E'
                    },
                    {
                        IFLASTCHANGE     => '(1578928254) 182 days, 17:54:42.54',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '447223543',
                        IFDESCR          => 'ge-2/0/15.0',
                        IFNUMBER         => '909',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '64500',
                        IFSTATUS         => '1',
                        IFNAME           => 'ge-2/0/15.0',
                        IFTYPE           => '53',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        MAC              => '2C:6B:F5:9B:48:8F'
                    },
                    {
                        IFTYPE           => '53',
                        IFNAME           => 'ge-2/0/16.0',
                        IFSTATUS         => '7',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFNUMBER         => '910',
                        IFDESCR          => 'ge-2/0/16.0',
                        IFOUTOCTETS      => '0',
                        IFLASTCHANGE     => '(889649032) 102 days, 23:14:50.32',
                        IFMTU            => '1514',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        MAC              => '2C:6B:F5:9B:48:90'
                    },
                    {
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        IFSTATUS         => '7',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFTYPE           => '53',
                        IFNAME           => 'ge-2/0/17.0',
                        IFOUTOCTETS      => '0',
                        IFLASTCHANGE     => '(889649033) 102 days, 23:14:50.33',
                        IFMTU            => '1514',
                        IFNUMBER         => '911',
                        IFDESCR          => 'ge-2/0/17.0',
                        MAC              => '2C:6B:F5:9B:48:91'
                    },
                    {
                        IFNAME           => 'ge-2/0/18.0',
                        IFTYPE           => '53',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '67302',
                        IFSTATUS         => '1',
                        IFDESCR          => 'ge-2/0/18.0',
                        IFNUMBER         => '912',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1572916894) 182 days, 1:12:48.94',
                        IFOUTOCTETS      => '446310721',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        MAC              => '2C:6B:F5:9B:48:92'
                    },
                    {
                        IFLASTCHANGE     => '(1578584634) 182 days, 16:57:26.34',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '69604822',
                        IFDESCR          => 'ge-2/0/19.0',
                        IFNUMBER         => '913',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '722484',
                        IFSTATUS         => '1',
                        IFNAME           => 'ge-2/0/19.0',
                        IFTYPE           => '53',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        MAC              => '2C:6B:F5:9B:48:93'
                    },
                    {
                        IFDESCR          => 'ge-2/0/2.0',
                        IFNUMBER         => '914',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1579089654) 182 days, 18:21:36.54',
                        IFOUTOCTETS      => '163649008',
                        IFNAME           => 'ge-2/0/2.0',
                        IFTYPE           => '53',
                        IFINOCTETS       => '1754026',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '1',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        MAC              => '2C:6B:F5:9B:48:82'
                    },
                    {
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '100000000',
                        IFINOCTETS       => '667694',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '1',
                        IFNAME           => 'ge-2/0/20.0',
                        IFTYPE           => '53',
                        IFLASTCHANGE     => '(1578587184) 182 days, 16:57:51.84',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '213968655',
                        IFDESCR          => 'ge-2/0/20.0',
                        IFNUMBER         => '915',
                        MAC              => '2C:6B:F5:9B:48:94'
                    },
                    {
                        IFOUTOCTETS      => '91401',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1328744065) 153 days, 18:57:20.65',
                        IFNUMBER         => '916',
                        IFDESCR          => 'ge-2/0/21.0',
                        IFSTATUS         => '7',
                        IFINOCTETS       => '5700',
                        IFPORTDUPLEX     => '3',
                        IFTYPE           => '53',
                        IFNAME           => 'ge-2/0/21.0',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        MAC              => '2C:6B:F5:9B:48:95'
                    },
                    {
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFLASTCHANGE     => '(889649037) 102 days, 23:14:50.37',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '0',
                        IFDESCR          => 'ge-2/0/22.0',
                        IFNUMBER         => '917',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFSTATUS         => '7',
                        IFNAME           => 'ge-2/0/22.0',
                        IFTYPE           => '53',
                        MAC              => '2C:6B:F5:9B:48:96'
                    },
                    {
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFSTATUS         => '7',
                        IFNAME           => 'ge-2/0/23.0',
                        IFTYPE           => '53',
                        IFLASTCHANGE     => '(889649038) 102 days, 23:14:50.38',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '0',
                        IFDESCR          => 'ge-2/0/23.0',
                        IFNUMBER         => '918',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        MAC              => '2C:6B:F5:9B:48:97'
                    },
                    {
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFNUMBER         => '919',
                        IFDESCR          => 'ge-2/0/24.0',
                        IFOUTOCTETS      => '0',
                        IFLASTCHANGE     => '(889649039) 102 days, 23:14:50.39',
                        IFMTU            => '1514',
                        IFTYPE           => '53',
                        IFNAME           => 'ge-2/0/24.0',
                        IFSTATUS         => '7',
                        IFINOCTETS       => '0',
                        IFPORTDUPLEX     => '3',
                        MAC              => '2C:6B:F5:9B:48:98'
                    },
                    {
                        IFNUMBER         => '920',
                        IFDESCR          => 'ge-2/0/25.0',
                        IFOUTOCTETS      => '446302343',
                        IFLASTCHANGE     => '(1578771194) 182 days, 17:28:31.94',
                        IFMTU            => '1514',
                        IFTYPE           => '53',
                        IFNAME           => 'ge-2/0/25.0',
                        IFSTATUS         => '1',
                        IFINOCTETS       => '76277',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        MAC              => '2C:6B:F5:9B:48:99'
                    },
                    {
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        IFINOCTETS       => '0',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '7',
                        IFNAME           => 'ge-2/0/26.0',
                        IFTYPE           => '53',
                        IFLASTCHANGE     => '(889649040) 102 days, 23:14:50.40',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '0',
                        IFDESCR          => 'ge-2/0/26.0',
                        IFNUMBER         => '921',
                        MAC              => '2C:6B:F5:9B:48:9A'
                    },
                    {
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '0',
                        IFLASTCHANGE     => '(889649040) 102 days, 23:14:50.40',
                        IFMTU            => '1514',
                        IFNUMBER         => '922',
                        IFDESCR          => 'ge-2/0/27.0',
                        IFSTATUS         => '7',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFTYPE           => '53',
                        IFNAME           => 'ge-2/0/27.0',
                        MAC              => '2C:6B:F5:9B:48:9B'
                    },
                    {
                        IFSTATUS         => '1',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '47679',
                        IFTYPE           => '53',
                        IFNAME           => 'ge-2/0/28.0',
                        IFOUTOCTETS      => '446256829',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1579064374) 182 days, 18:17:23.74',
                        IFNUMBER         => '923',
                        IFDESCR          => 'ge-2/0/28.0',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        MAC              => '2C:6B:F5:9B:48:9C'
                    },
                    {
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(889649041) 102 days, 23:14:50.41',
                        IFOUTOCTETS      => '0',
                        IFDESCR          => 'ge-2/0/29.0',
                        IFNUMBER         => '924',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFSTATUS         => '7',
                        IFNAME           => 'ge-2/0/29.0',
                        IFTYPE           => '53',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        MAC              => '2C:6B:F5:9B:48:9D'
                    },
                    {
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '446047083',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1578862754) 182 days, 17:43:47.54',
                        IFNUMBER         => '925',
                        IFDESCR          => 'ge-2/0/3.0',
                        IFSTATUS         => '1',
                        IFINOCTETS       => '624410',
                        IFPORTDUPLEX     => '3',
                        IFTYPE           => '53',
                        IFNAME           => 'ge-2/0/3.0',
                        MAC              => '2C:6B:F5:9B:48:83'
                    },
                    {
                        IFDESCR          => 'ge-2/0/30.0',
                        IFNUMBER         => '926',
                        IFLASTCHANGE     => '(889649042) 102 days, 23:14:50.42',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '0',
                        IFNAME           => 'ge-2/0/30.0',
                        IFTYPE           => '53',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFSTATUS         => '7',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        MAC              => '2C:6B:F5:9B:48:9E'
                    },
                    {
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFDESCR          => 'ge-2/0/31.0',
                        IFNUMBER         => '927',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(889649043) 102 days, 23:14:50.43',
                        IFOUTOCTETS      => '0',
                        IFNAME           => 'ge-2/0/31.0',
                        IFTYPE           => '53',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFSTATUS         => '7',
                        MAC              => '2C:6B:F5:9B:48:9F'
                    },
                    {
                        IFNUMBER         => '928',
                        IFDESCR          => 'ge-2/0/32.0',
                        IFOUTOCTETS      => '0',
                        IFLASTCHANGE     => '(889649043) 102 days, 23:14:50.43',
                        IFMTU            => '1514',
                        IFTYPE           => '53',
                        IFNAME           => 'ge-2/0/32.0',
                        IFSTATUS         => '7',
                        IFINOCTETS       => '0',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        MAC              => '2C:6B:F5:9B:48:A0'
                    },
                    {
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        IFSTATUS         => '7',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFTYPE           => '53',
                        IFNAME           => 'ge-2/0/33.0',
                        IFOUTOCTETS      => '0',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(889649044) 102 days, 23:14:50.44',
                        IFNUMBER         => '929',
                        IFDESCR          => 'ge-2/0/33.0',
                        MAC              => '2C:6B:F5:9B:48:A1'
                    },
                    {
                        IFDESCR          => 'ge-2/0/34.0',
                        IFNUMBER         => '930',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1322849014) 153 days, 2:34:50.14',
                        IFOUTOCTETS      => '446560381',
                        IFNAME           => 'ge-2/0/34.0',
                        IFTYPE           => '53',
                        IFINOCTETS       => '98115',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '1',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        MAC              => '2C:6B:F5:9B:48:A2'
                    },
                    {
                        IFTYPE           => '53',
                        IFNAME           => 'ge-2/0/35.0',
                        IFSTATUS         => '7',
                        IFINOCTETS       => '0',
                        IFPORTDUPLEX     => '3',
                        IFNUMBER         => '931',
                        IFDESCR          => 'ge-2/0/35.0',
                        IFOUTOCTETS      => '0',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(889649045) 102 days, 23:14:50.45',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        MAC              => '2C:6B:F5:9B:48:A3'
                    },
                    {
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '0',
                        IFLASTCHANGE     => '(889649046) 102 days, 23:14:50.46',
                        IFMTU            => '1514',
                        IFNUMBER         => '932',
                        IFDESCR          => 'ge-2/0/36.0',
                        IFSTATUS         => '7',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFTYPE           => '53',
                        IFNAME           => 'ge-2/0/36.0',
                        MAC              => '2C:6B:F5:9B:48:A4'
                    },
                    {
                        IFDESCR          => 'ge-2/0/37.0',
                        IFNUMBER         => '933',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1578869584) 182 days, 17:44:55.84',
                        IFOUTOCTETS      => '447214884',
                        IFNAME           => 'ge-2/0/37.0',
                        IFTYPE           => '53',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '296918',
                        IFSTATUS         => '1',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        MAC              => '2C:6B:F5:9B:48:A5'
                    },
                    {
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFLASTCHANGE     => '(889649052) 102 days, 23:14:50.52',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '0',
                        IFDESCR          => 'ge-2/0/38.0',
                        IFNUMBER         => '934',
                        IFINOCTETS       => '0',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '7',
                        IFNAME           => 'ge-2/0/38.0',
                        IFTYPE           => '53',
                        MAC              => '2C:6B:F5:9B:48:A6'
                    },
                    {
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1578551944) 182 days, 16:51:59.44',
                        IFOUTOCTETS      => '447074797',
                        IFDESCR          => 'ge-2/0/39.0',
                        IFNUMBER         => '935',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '515540',
                        IFSTATUS         => '1',
                        IFNAME           => 'ge-2/0/39.0',
                        IFTYPE           => '53',
                        MAC              => '2C:6B:F5:9B:48:A7'
                    },
                    {
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(889649025) 102 days, 23:14:50.25',
                        IFOUTOCTETS      => '0',
                        IFDESCR          => 'ge-2/0/4.0',
                        IFNUMBER         => '936',
                        IFINOCTETS       => '0',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '7',
                        IFNAME           => 'ge-2/0/4.0',
                        IFTYPE           => '53',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        MAC              => '2C:6B:F5:9B:48:84'
                    },
                    {
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1775857',
                        IFSTATUS         => '1',
                        IFNAME           => 'ge-2/0/40.0',
                        IFTYPE           => '53',
                        IFLASTCHANGE     => '(1485792124) 171 days, 23:12:01.24',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '446280862',
                        IFDESCR          => 'ge-2/0/40.0',
                        IFNUMBER         => '937',
                        MAC              => '2C:6B:F5:9B:48:A8'
                    },
                    {
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFNAME           => 'ge-2/0/41.0',
                        IFTYPE           => '53',
                        IFINOCTETS       => '425059',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '1',
                        IFDESCR          => 'ge-2/0/41.0',
                        IFNUMBER         => '938',
                        IFLASTCHANGE     => '(1578870914) 182 days, 17:45:09.14',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '447065337',
                        MAC              => '2C:6B:F5:9B:48:A9'
                    },
                    {
                        IFDESCR          => 'ge-2/0/42.0',
                        IFNUMBER         => '939',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(889649057) 102 days, 23:14:50.57',
                        IFOUTOCTETS      => '0',
                        IFNAME           => 'ge-2/0/42.0',
                        IFTYPE           => '53',
                        IFINOCTETS       => '0',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '7',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        MAC              => '2C:6B:F5:9B:48:AA'
                    },
                    {
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        IFSTATUS         => '7',
                        IFINOCTETS       => '0',
                        IFPORTDUPLEX     => '3',
                        IFTYPE           => '53',
                        IFNAME           => 'ge-2/0/43.0',
                        IFOUTOCTETS      => '0',
                        IFLASTCHANGE     => '(889649058) 102 days, 23:14:50.58',
                        IFMTU            => '1514',
                        IFNUMBER         => '940',
                        IFDESCR          => 'ge-2/0/43.0',
                        MAC              => '2C:6B:F5:9B:48:AB'
                    },
                    {
                        IFNAME           => 'ge-2/0/44.0',
                        IFTYPE           => '53',
                        IFINOCTETS       => '0',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '7',
                        IFDESCR          => 'ge-2/0/44.0',
                        IFNUMBER         => '941',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(889649059) 102 days, 23:14:50.59',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        MAC              => '2C:6B:F5:9B:48:AC'
                    },
                    {
                        IFSTATUS         => '7',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFTYPE           => '53',
                        IFNAME           => 'ge-2/0/45.0',
                        IFOUTOCTETS      => '0',
                        IFLASTCHANGE     => '(889649060) 102 days, 23:14:50.60',
                        IFMTU            => '1514',
                        IFNUMBER         => '942',
                        IFDESCR          => 'ge-2/0/45.0',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        MAC              => '2C:6B:F5:9B:48:AD'
                    },
                    {
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFDESCR          => 'ge-2/0/46.0',
                        IFNUMBER         => '943',
                        IFLASTCHANGE     => '(889649061) 102 days, 23:14:50.61',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '0',
                        IFNAME           => 'ge-2/0/46.0',
                        IFTYPE           => '53',
                        IFINOCTETS       => '0',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '7',
                        MAC              => '2C:6B:F5:9B:48:AE'
                    },
                    {
                        IFTYPE           => '53',
                        IFNAME           => 'ge-2/0/47.0',
                        IFSTATUS         => '7',
                        IFINOCTETS       => '0',
                        IFPORTDUPLEX     => '3',
                        IFNUMBER         => '944',
                        IFDESCR          => 'ge-2/0/47.0',
                        IFOUTOCTETS      => '0',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(889649063) 102 days, 23:14:50.63',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        MAC              => '2C:6B:F5:9B:48:AF'
                    },
                    {
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFLASTCHANGE     => '(1579193654) 182 days, 18:38:56.54',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '446027667',
                        IFDESCR          => 'ge-2/0/5.0',
                        IFNUMBER         => '945',
                        IFINOCTETS       => '92917',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '1',
                        IFNAME           => 'ge-2/0/5.0',
                        IFTYPE           => '53',
                        MAC              => '2C:6B:F5:9B:48:85'
                    },
                    {
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        IFSTATUS         => '1',
                        IFINOCTETS       => '66331',
                        IFPORTDUPLEX     => '3',
                        IFTYPE           => '53',
                        IFNAME           => 'ge-2/0/6.0',
                        IFOUTOCTETS      => '446779566',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1578905654) 182 days, 17:50:56.54',
                        IFNUMBER         => '946',
                        IFDESCR          => 'ge-2/0/6.0',
                        MAC              => '2C:6B:F5:9B:48:86'
                    },
                    {
                        IFNUMBER         => '947',
                        IFDESCR          => 'ge-2/0/7.0',
                        IFOUTOCTETS      => '0',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(889649026) 102 days, 23:14:50.26',
                        IFTYPE           => '53',
                        IFNAME           => 'ge-2/0/7.0',
                        IFSTATUS         => '7',
                        IFINOCTETS       => '0',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        MAC              => '2C:6B:F5:9B:48:87'
                    },
                    {
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1192428913) 138 days, 0:18:09.13',
                        IFOUTOCTETS      => '446348488',
                        IFDESCR          => 'ge-2/0/8.0',
                        IFNUMBER         => '948',
                        IFINOCTETS       => '72863',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '1',
                        IFNAME           => 'ge-2/0/8.0',
                        IFTYPE           => '53',
                        MAC              => '2C:6B:F5:9B:48:88'
                    },
                    {
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(889649028) 102 days, 23:14:50.28',
                        IFOUTOCTETS      => '0',
                        IFDESCR          => 'ge-2/0/9.0',
                        IFNUMBER         => '949',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFSTATUS         => '7',
                        IFNAME           => 'ge-2/0/9.0',
                        IFTYPE           => '53',
                        MAC              => '2C:6B:F5:9B:48:89'
                    },
                    {
                        CONNECTIONS => {
                            CONNECTION => {
                                MAC => [
                                    '00:0B:DC:00:B2:11',
                                    '2C:6B:F5:99:7C:00',
                                    '2C:6B:F5:99:7C:01'
                                ]
                            }
                        },
                        IFOUTOCTETS      => '889063067',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1401320591) 162 days, 4:33:25.91',
                        IFNUMBER         => '950',
                        IFDESCR          => 'ae1.0',
                        IFSTATUS         => '1',
                        IFINOCTETS       => '0',
                        IFTYPE           => '161',
                        IFNAME           => 'ae1.0',
                        IFINERRORS       => '0',
                        IFSPEED          => '2000000000',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        MAC              => '2C:6B:F5:9B:48:81'
                    },
                    {
                        IFNUMBER         => '951',
                        IFDESCR          => 'ge-1/0/0.0',
                        IFOUTOCTETS      => '579626734',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(717450883) 83 days, 0:55:08.83',
                        IFTYPE           => '53',
                        IFNAME           => 'ge-1/0/0.0',
                        IFSTATUS         => '1',
                        IFINOCTETS       => '94543444',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '1000000000',
                        IFINERRORS       => '0',
                        CONNECTIONS => {
                            CONNECTION => {
                                IFDESCR  => 'ge-0/0/1.0',
                                SYSMAC   => '2C:6B:F5:99:7C:00',
                                IFNUMBER => '504',
                                SYSDESCR => 'Juniper Networks, Inc. ex3200-48p , version 10.3R1.9 Build date: 2010-08-13 12:56:38 UTC ',
                                SYSNAME  => 'jte4-02'
                            },
                            CDP => 1
                        },
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        MAC              => '2C:6B:F5:9B:48:81'
                    },
                    {
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFTYPE           => '53',
                        IFNAME           => 'ge-4/0/0.0',
                        IFSTATUS         => '7',
                        IFINOCTETS       => '180298',
                        IFPORTDUPLEX     => '3',
                        IFNUMBER         => '952',
                        IFDESCR          => 'ge-4/0/0.0',
                        IFOUTOCTETS      => '240732643',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1442976434) 167 days, 0:16:04.34',
                        MAC              => '2C:6B:F5:9B:48:80'
                    },
                    {
                        IFSTATUS         => '1',
                        IFINOCTETS       => '7182',
                        IFPORTDUPLEX     => '3',
                        IFTYPE           => '53',
                        IFNAME           => 'ge-4/0/1.0',
                        IFOUTOCTETS      => '11166785',
                        IFLASTCHANGE     => '(1565042078) 181 days, 3:20:20.78',
                        IFMTU            => '1514',
                        IFNUMBER         => '953',
                        IFDESCR          => 'ge-4/0/1.0',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        MAC              => '2C:6B:F5:9B:48:81'
                    },
                    {
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFNUMBER         => '954',
                        IFDESCR          => 'ge-4/0/2.0',
                        IFOUTOCTETS      => '0',
                        IFLASTCHANGE     => '(1071466880) 124 days, 0:17:48.80',
                        IFMTU            => '1514',
                        IFTYPE           => '53',
                        IFNAME           => 'ge-4/0/2.0',
                        IFSTATUS         => '7',
                        IFINOCTETS       => '0',
                        IFPORTDUPLEX     => '3',
                        MAC              => '2C:6B:F5:9B:48:82'
                    },
                    {
                        IFNAME           => 'ge-4/0/3.0',
                        IFTYPE           => '53',
                        IFINOCTETS       => '11040',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '1',
                        IFDESCR          => 'ge-4/0/3.0',
                        IFNUMBER         => '955',
                        IFLASTCHANGE     => '(1578609968) 182 days, 17:01:39.68',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '319003774',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        MAC              => '2C:6B:F5:9B:48:83'
                    },
                    {
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFTYPE           => '53',
                        IFNAME           => 'ge-4/0/4.0',
                        IFSTATUS         => '1',
                        IFINOCTETS       => '96031',
                        IFPORTDUPLEX     => '3',
                        IFNUMBER         => '956',
                        IFDESCR          => 'ge-4/0/4.0',
                        IFOUTOCTETS      => '88477095',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1510174878) 174 days, 18:55:48.78',
                        MAC              => '2C:6B:F5:9B:48:84'
                    },
                    {
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFDESCR          => 'ge-4/0/5.0',
                        IFNUMBER         => '957',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1510153146) 174 days, 18:52:11.46',
                        IFOUTOCTETS      => '4685',
                        IFNAME           => 'ge-4/0/5.0',
                        IFTYPE           => '53',
                        IFINOCTETS       => '750',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '7',
                        MAC              => '2C:6B:F5:9B:48:85'
                    },
                    {
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFNAME           => 'ge-5/0/38.0',
                        IFTYPE           => '53',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFSTATUS         => '7',
                        IFDESCR          => 'ge-5/0/38.0',
                        IFNUMBER         => '958',
                        IFLASTCHANGE     => '(1071467904) 124 days, 0:17:59.04',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '0',
                        MAC              => '2C:6B:F5:9B:48:A6'
                    },
                    {
                        IFSTATUS         => '7',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3138238',
                        IFTYPE           => '53',
                        IFNAME           => 'ge-5/0/39.0',
                        IFOUTOCTETS      => '94885107',
                        IFLASTCHANGE     => '(1573567062) 182 days, 3:01:10.62',
                        IFMTU            => '1514',
                        IFNUMBER         => '959',
                        IFDESCR          => 'ge-5/0/39.0',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        MAC              => '2C:6B:F5:9B:48:A7'
                    },
                    {
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFNAME           => 'ge-5/0/41.0',
                        IFTYPE           => '53',
                        IFINOCTETS       => '0',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '7',
                        IFDESCR          => 'ge-5/0/41.0',
                        IFNUMBER         => '960',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1071467937) 124 days, 0:17:59.37',
                        IFOUTOCTETS      => '0',
                        MAC              => '2C:6B:F5:9B:48:A9'
                    },
                    {
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        IFSTATUS         => '1',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '108613',
                        IFTYPE           => '53',
                        IFNAME           => 'ge-5/0/42.0',
                        IFOUTOCTETS      => '105532936',
                        IFLASTCHANGE     => '(1578548403) 182 days, 16:51:24.03',
                        IFMTU            => '1514',
                        IFNUMBER         => '961',
                        IFDESCR          => 'ge-5/0/42.0',
                        MAC              => '2C:6B:F5:9B:48:AA'
                    },
                    {
                        IFSTATUS         => '7',
                        IFINOCTETS       => '0',
                        IFPORTDUPLEX     => '3',
                        IFTYPE           => '53',
                        IFNAME           => 'ge-5/0/43.0',
                        IFOUTOCTETS      => '0',
                        IFLASTCHANGE     => '(1071467955) 124 days, 0:17:59.55',
                        IFMTU            => '1514',
                        IFNUMBER         => '962',
                        IFDESCR          => 'ge-5/0/43.0',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        MAC              => '2C:6B:F5:9B:48:AB'
                    },
                    {
                        IFDESCR          => 'ge-5/0/44.0',
                        IFNUMBER         => '963',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1521519295) 176 days, 2:26:32.95',
                        IFOUTOCTETS      => '33655471',
                        IFNAME           => 'ge-5/0/44.0',
                        IFTYPE           => '53',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '42279',
                        IFSTATUS         => '7',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        MAC              => '2C:6B:F5:9B:48:AC'
                    },
                    {
                        IFNAME           => 'ge-5/0/45.0',
                        IFTYPE           => '53',
                        IFINOCTETS       => '0',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '1',
                        IFDESCR          => 'ge-5/0/45.0',
                        IFNUMBER         => '964',
                        IFLASTCHANGE     => '(1071469953) 124 days, 0:18:19.53',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '329379227',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        MAC              => '2C:6B:F5:9B:48:AD'
                    },
                    {
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1071469953) 124 days, 0:18:19.53',
                        IFOUTOCTETS      => '329386182',
                        IFDESCR          => 'ge-5/0/46.0',
                        IFNUMBER         => '965',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFSTATUS         => '1',
                        IFNAME           => 'ge-5/0/46.0',
                        IFTYPE           => '53',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        MAC              => '2C:6B:F5:9B:48:AE'
                    },
                    {
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFSTATUS         => '1',
                        IFNAME           => 'ge-4/0/23.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1578618687) 182 days, 17:03:06.87',
                        IFOUTOCTETS      => '97504252',
                        IFDESCR          => 'ge-4/0/23.0',
                        IFNUMBER         => '966',
                        MAC              => '2C:6B:F5:9B:48:97'
                    },
                    {
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1578616548) 182 days, 17:02:45.48',
                        IFOUTOCTETS      => '84556688',
                        IFDESCR          => 'ge-4/0/6.0',
                        IFNUMBER         => '967',
                        IFINOCTETS       => '7680',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '1',
                        IFNAME           => 'ge-4/0/6.0',
                        IFTYPE           => '53',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        MAC              => '2C:6B:F5:9B:48:86'
                    },
                    {
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '133065023',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1578616157) 182 days, 17:02:41.57',
                        IFNUMBER         => '968',
                        IFDESCR          => 'ge-4/0/7.0',
                        IFSTATUS         => '1',
                        IFINOCTETS       => '9720',
                        IFPORTDUPLEX     => '3',
                        IFTYPE           => '53',
                        IFNAME           => 'ge-4/0/7.0',
                        MAC              => '2C:6B:F5:9B:48:87'
                    },
                    {
                        IFINOCTETS       => '22284',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '1',
                        IFNAME           => 'ge-4/0/8.0',
                        IFTYPE           => '53',
                        IFLASTCHANGE     => '(1574023308) 182 days, 4:17:13.08',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '329192800',
                        IFDESCR          => 'ge-4/0/8.0',
                        IFNUMBER         => '969',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        MAC              => '2C:6B:F5:9B:48:88'
                    },
                    {
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        IFINOCTETS       => '0',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '7',
                        IFNAME           => 'ge-4/0/9.0',
                        IFTYPE           => '53',
                        IFLASTCHANGE     => '(1071466953) 124 days, 0:17:49.53',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '0',
                        IFDESCR          => 'ge-4/0/9.0',
                        IFNUMBER         => '970',
                        MAC              => '2C:6B:F5:9B:48:89'
                    },
                    {
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFNAME           => 'ge-3/0/1.0',
                        IFTYPE           => '53',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFSTATUS         => '7',
                        IFDESCR          => 'ge-3/0/1.0',
                        IFNUMBER         => '971',
                        IFLASTCHANGE     => '(889646425) 102 days, 23:14:24.25',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '0',
                        MAC              => '2C:6B:F5:9B:48:81'
                    },
                    {
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFNUMBER         => '972',
                        IFDESCR          => 'ge-3/0/10.0',
                        IFOUTOCTETS      => '6084067',
                        IFLASTCHANGE     => '(1453627976) 168 days, 5:51:19.76',
                        IFMTU            => '1514',
                        IFTYPE           => '53',
                        IFNAME           => 'ge-3/0/10.0',
                        IFSTATUS         => '7',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '37976',
                        MAC              => '2C:6B:F5:9B:48:8A'
                    },
                    {
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '3630454',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1364234866) 157 days, 21:32:28.66',
                        IFNUMBER         => '973',
                        IFDESCR          => 'ge-3/0/11.0',
                        IFSTATUS         => '7',
                        IFINOCTETS       => '28156',
                        IFPORTDUPLEX     => '3',
                        IFTYPE           => '53',
                        IFNAME           => 'ge-3/0/11.0',
                        MAC              => '2C:6B:F5:9B:48:8B'
                    },
                    {
                        IFOUTOCTETS      => '4231984',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1450386691) 167 days, 20:51:06.91',
                        IFNUMBER         => '974',
                        IFDESCR          => 'ge-3/0/12.0',
                        IFSTATUS         => '7',
                        IFINOCTETS       => '45497',
                        IFPORTDUPLEX     => '3',
                        IFTYPE           => '53',
                        IFNAME           => 'ge-3/0/12.0',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        MAC              => '2C:6B:F5:9B:48:8C'
                    },
                    {
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFNAME           => 'ge-3/0/13.0',
                        IFTYPE           => '53',
                        IFINOCTETS       => '44968',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '7',
                        IFDESCR          => 'ge-3/0/13.0',
                        IFNUMBER         => '975',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1450398878) 167 days, 20:53:08.78',
                        IFOUTOCTETS      => '4354705',
                        MAC              => '2C:6B:F5:9B:48:8D'
                    },
                    {
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFNUMBER         => '976',
                        IFDESCR          => 'ge-3/0/14.0',
                        IFOUTOCTETS      => '4354982',
                        IFLASTCHANGE     => '(1450388428) 167 days, 20:51:24.28',
                        IFMTU            => '1514',
                        IFTYPE           => '53',
                        IFNAME           => 'ge-3/0/14.0',
                        IFSTATUS         => '7',
                        IFINOCTETS       => '43143',
                        IFPORTDUPLEX     => '3',
                        MAC              => '2C:6B:F5:9B:48:8E'
                    },
                    {
                        IFNAME           => 'ge-3/0/15.0',
                        IFTYPE           => '53',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '47871',
                        IFSTATUS         => '7',
                        IFDESCR          => 'ge-3/0/15.0',
                        IFNUMBER         => '977',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1450386802) 167 days, 20:51:08.02',
                        IFOUTOCTETS      => '4344816',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        MAC              => '2C:6B:F5:9B:48:8F'
                    },
                    {
                        IFDESCR          => 'ge-3/0/16.0',
                        IFNUMBER         => '978',
                        IFLASTCHANGE     => '(1520346686) 175 days, 23:11:06.86',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '2965103',
                        IFNAME           => 'ge-3/0/16.0',
                        IFTYPE           => '53',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '22483',
                        IFSTATUS         => '7',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        MAC              => '2C:6B:F5:9B:48:90'
                    },
                    {
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFTYPE           => '53',
                        IFNAME           => 'ge-3/0/17.0',
                        IFSTATUS         => '7',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '22570',
                        IFNUMBER         => '979',
                        IFDESCR          => 'ge-3/0/17.0',
                        IFOUTOCTETS      => '2963669',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1520347478) 175 days, 23:11:14.78',
                        MAC              => '2C:6B:F5:9B:48:91'
                    },
                    {
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFTYPE           => '53',
                        IFNAME           => 'ge-3/0/18.0',
                        IFSTATUS         => '7',
                        IFINOCTETS       => '19880',
                        IFPORTDUPLEX     => '3',
                        IFNUMBER         => '980',
                        IFDESCR          => 'ge-3/0/18.0',
                        IFOUTOCTETS      => '2856466',
                        IFLASTCHANGE     => '(1338153052) 154 days, 21:05:30.52',
                        IFMTU            => '1514',
                        MAC              => '2C:6B:F5:9B:48:92'
                    },
                    {
                        IFNAME           => 'ge-3/0/19.0',
                        IFTYPE           => '53',
                        IFINOCTETS       => '19505',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '7',
                        IFDESCR          => 'ge-3/0/19.0',
                        IFNUMBER         => '981',
                        IFLASTCHANGE     => '(1338153360) 154 days, 21:05:33.60',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '2907424',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        MAC              => '2C:6B:F5:9B:48:93'
                    },
                    {
                        IFSTATUS         => '7',
                        IFINOCTETS       => '143030',
                        IFPORTDUPLEX     => '3',
                        IFTYPE           => '53',
                        IFNAME           => 'ge-3/0/2.0',
                        IFOUTOCTETS      => '11200811',
                        IFLASTCHANGE     => '(1520988290) 176 days, 0:58:02.90',
                        IFMTU            => '1514',
                        IFNUMBER         => '982',
                        IFDESCR          => 'ge-3/0/2.0',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        MAC              => '2C:6B:F5:9B:48:82'
                    },
                    {
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFNAME           => 'ge-3/0/20.0',
                        IFTYPE           => '53',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '27279',
                        IFSTATUS         => '7',
                        IFDESCR          => 'ge-3/0/20.0',
                        IFNUMBER         => '983',
                        IFLASTCHANGE     => '(1338153274) 154 days, 21:05:32.74',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '2777341',
                        MAC              => '2C:6B:F5:9B:48:94'
                    },
                    {
                        IFDESCR          => 'ge-3/0/21.0',
                        IFNUMBER         => '984',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1338153164) 154 days, 21:05:31.64',
                        IFOUTOCTETS      => '3138332',
                        IFNAME           => 'ge-3/0/21.0',
                        IFTYPE           => '53',
                        IFINOCTETS       => '31430',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '7',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        MAC              => '2C:6B:F5:9B:48:95'
                    },
                    {
                        IFNUMBER         => '985',
                        IFDESCR          => 'ge-3/0/22.0',
                        IFOUTOCTETS      => '0',
                        IFLASTCHANGE     => '(889646729) 102 days, 23:14:27.29',
                        IFMTU            => '1514',
                        IFTYPE           => '53',
                        IFNAME           => 'ge-3/0/22.0',
                        IFSTATUS         => '7',
                        IFINOCTETS       => '0',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        MAC              => '2C:6B:F5:9B:48:96'
                    },
                    {
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        IFSTATUS         => '7',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFTYPE           => '53',
                        IFNAME           => 'ge-3/0/23.0',
                        IFOUTOCTETS      => '0',
                        IFLASTCHANGE     => '(889646736) 102 days, 23:14:27.36',
                        IFMTU            => '1514',
                        IFNUMBER         => '986',
                        IFDESCR          => 'ge-3/0/23.0',
                        MAC              => '2C:6B:F5:9B:48:97'
                    },
                    {
                        IFDESCR          => 'ge-3/0/24.0',
                        IFNUMBER         => '987',
                        IFLASTCHANGE     => '(889646744) 102 days, 23:14:27.44',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '0',
                        IFNAME           => 'ge-3/0/24.0',
                        IFTYPE           => '53',
                        IFINOCTETS       => '0',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '7',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        MAC              => '2C:6B:F5:9B:48:98'
                    },
                    {
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFTYPE           => '53',
                        IFNAME           => 'ge-3/0/25.0',
                        IFSTATUS         => '7',
                        IFINOCTETS       => '0',
                        IFPORTDUPLEX     => '3',
                        IFNUMBER         => '988',
                        IFDESCR          => 'ge-3/0/25.0',
                        IFOUTOCTETS      => '0',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(889646752) 102 days, 23:14:27.52',
                        MAC              => '2C:6B:F5:9B:48:99'
                    },
                    {
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFSTATUS         => '7',
                        IFNAME           => 'ge-3/0/26.0',
                        IFTYPE           => '53',
                        IFLASTCHANGE     => '(889646762) 102 days, 23:14:27.62',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '0',
                        IFDESCR          => 'ge-3/0/26.0',
                        IFNUMBER         => '989',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        MAC              => '2C:6B:F5:9B:48:9A'
                    },
                    {
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFNUMBER         => '990',
                        IFDESCR          => 'ge-3/0/27.0',
                        IFOUTOCTETS      => '0',
                        IFLASTCHANGE     => '(889646777) 102 days, 23:14:27.77',
                        IFMTU            => '1514',
                        IFTYPE           => '53',
                        IFNAME           => 'ge-3/0/27.0',
                        IFSTATUS         => '7',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        MAC              => '2C:6B:F5:9B:48:9B'
                    },
                    {
                        IFNAME           => 'ge-3/0/28.0',
                        IFTYPE           => '53',
                        IFINOCTETS       => '0',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '7',
                        IFDESCR          => 'ge-3/0/28.0',
                        IFNUMBER         => '991',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(889646767) 102 days, 23:14:27.67',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        MAC              => '2C:6B:F5:9B:48:9C'
                    },
                    {
                        IFNUMBER         => '992',
                        IFDESCR          => 'ge-3/0/29.0',
                        IFOUTOCTETS      => '0',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(889646786) 102 days, 23:14:27.86',
                        IFTYPE           => '53',
                        IFNAME           => 'ge-3/0/29.0',
                        IFSTATUS         => '7',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        MAC              => '2C:6B:F5:9B:48:9D'
                    },
                    {
                        IFSTATUS         => '7',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '55144',
                        IFTYPE           => '53',
                        IFNAME           => 'ge-3/0/3.0',
                        IFOUTOCTETS      => '4511091',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1450384926) 167 days, 20:50:49.26',
                        IFNUMBER         => '993',
                        IFDESCR          => 'ge-3/0/3.0',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        MAC              => '2C:6B:F5:9B:48:83'
                    },
                    {
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFSTATUS         => '7',
                        IFNAME           => 'ge-3/0/30.0',
                        IFTYPE           => '53',
                        IFLASTCHANGE     => '(889646796) 102 days, 23:14:27.96',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '0',
                        IFDESCR          => 'ge-3/0/30.0',
                        IFNUMBER         => '994',
                        MAC              => '2C:6B:F5:9B:48:9E'
                    },
                    {
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFNAME           => 'ge-3/0/31.0',
                        IFTYPE           => '53',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFSTATUS         => '7',
                        IFDESCR          => 'ge-3/0/31.0',
                        IFNUMBER         => '995',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(889646804) 102 days, 23:14:28.04',
                        IFOUTOCTETS      => '0',
                        MAC              => '2C:6B:F5:9B:48:9F'
                    },
                    {
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFSTATUS         => '7',
                        IFNAME           => 'ge-3/0/32.0',
                        IFTYPE           => '53',
                        IFLASTCHANGE     => '(889646814) 102 days, 23:14:28.14',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '0',
                        IFDESCR          => 'ge-3/0/32.0',
                        IFNUMBER         => '996',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        MAC              => '2C:6B:F5:9B:48:A0'
                    },
                    {
                        IFNAME           => 'ge-3/0/33.0',
                        IFTYPE           => '53',
                        IFINOCTETS       => '0',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '7',
                        IFDESCR          => 'ge-3/0/33.0',
                        IFNUMBER         => '997',
                        IFLASTCHANGE     => '(889646820) 102 days, 23:14:28.20',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        MAC              => '2C:6B:F5:9B:48:A1'
                    },
                    {
                        IFNUMBER         => '998',
                        IFDESCR          => 'ge-3/0/34.0',
                        IFOUTOCTETS      => '0',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(889646826) 102 days, 23:14:28.26',
                        IFTYPE           => '53',
                        IFNAME           => 'ge-3/0/34.0',
                        IFSTATUS         => '7',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        MAC              => '2C:6B:F5:9B:48:A2'
                    },
                    {
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFNAME           => 'ge-3/0/35.0',
                        IFTYPE           => '53',
                        IFINOCTETS       => '0',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '7',
                        IFDESCR          => 'ge-3/0/35.0',
                        IFNUMBER         => '999',
                        IFLASTCHANGE     => '(889646832) 102 days, 23:14:28.32',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '0',
                        MAC              => '2C:6B:F5:9B:48:A3'
                    },
                    {
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFNAME           => 'ge-3/0/36.0',
                        IFTYPE           => '53',
                        IFINOCTETS       => '0',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '7',
                        IFDESCR          => 'ge-3/0/36.0',
                        IFNUMBER         => '1000',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(889646840) 102 days, 23:14:28.40',
                        IFOUTOCTETS      => '0',
                        MAC              => '2C:6B:F5:9B:48:A4'
                    },
                    {
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        IFSTATUS         => '7',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFTYPE           => '53',
                        IFNAME           => 'ge-3/0/37.0',
                        IFOUTOCTETS      => '0',
                        IFLASTCHANGE     => '(889646849) 102 days, 23:14:28.49',
                        IFMTU            => '1514',
                        IFNUMBER         => '1001',
                        IFDESCR          => 'ge-3/0/37.0',
                        MAC              => '2C:6B:F5:9B:48:A5'
                    },
                    {
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        IFSTATUS         => '7',
                        IFINOCTETS       => '0',
                        IFPORTDUPLEX     => '3',
                        IFTYPE           => '53',
                        IFNAME           => 'ge-3/0/38.0',
                        IFOUTOCTETS      => '0',
                        IFLASTCHANGE     => '(889646857) 102 days, 23:14:28.57',
                        IFMTU            => '1514',
                        IFNUMBER         => '1002',
                        IFDESCR          => 'ge-3/0/38.0',
                        MAC              => '2C:6B:F5:9B:48:A6'
                    },
                    {
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFLASTCHANGE     => '(889646864) 102 days, 23:14:28.64',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '0',
                        IFDESCR          => 'ge-3/0/39.0',
                        IFNUMBER         => '1003',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFSTATUS         => '7',
                        IFNAME           => 'ge-3/0/39.0',
                        IFTYPE           => '53',
                        MAC              => '2C:6B:F5:9B:48:A7'
                    },
                    {
                        IFNUMBER         => '1004',
                        IFDESCR          => 'ge-3/0/4.0',
                        IFOUTOCTETS      => '6127299',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1450387743) 167 days, 20:51:17.43',
                        IFTYPE           => '53',
                        IFNAME           => 'ge-3/0/4.0',
                        IFSTATUS         => '7',
                        IFINOCTETS       => '56034',
                        IFPORTDUPLEX     => '3',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        MAC              => '2C:6B:F5:9B:48:84'
                    },
                    {
                        IFNAME           => 'ge-3/0/40.0',
                        IFTYPE           => '53',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFSTATUS         => '7',
                        IFDESCR          => 'ge-3/0/40.0',
                        IFNUMBER         => '1005',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(889646871) 102 days, 23:14:28.71',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        MAC              => '2C:6B:F5:9B:48:A8'
                    },
                    {
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFNUMBER         => '1006',
                        IFDESCR          => 'ge-3/0/41.0',
                        IFOUTOCTETS      => '0',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(889646879) 102 days, 23:14:28.79',
                        IFTYPE           => '53',
                        IFNAME           => 'ge-3/0/41.0',
                        IFSTATUS         => '7',
                        IFINOCTETS       => '0',
                        IFPORTDUPLEX     => '3',
                        MAC              => '2C:6B:F5:9B:48:A9'
                    },
                    {
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFSTATUS         => '7',
                        IFNAME           => 'ge-3/0/42.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(889646902) 102 days, 23:14:29.02',
                        IFOUTOCTETS      => '0',
                        IFDESCR          => 'ge-3/0/42.0',
                        IFNUMBER         => '1007',
                        MAC              => '2C:6B:F5:9B:48:AA'
                    },
                    {
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFLASTCHANGE     => '(889646934) 102 days, 23:14:29.34',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '0',
                        IFDESCR          => 'ge-3/0/43.0',
                        IFNUMBER         => '1008',
                        IFINOCTETS       => '0',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '7',
                        IFNAME           => 'ge-3/0/43.0',
                        IFTYPE           => '53',
                        MAC              => '2C:6B:F5:9B:48:AB'
                    },
                    {
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFDESCR          => 'ge-3/0/44.0',
                        IFNUMBER         => '1009',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(889646938) 102 days, 23:14:29.38',
                        IFOUTOCTETS      => '0',
                        IFNAME           => 'ge-3/0/44.0',
                        IFTYPE           => '53',
                        IFINOCTETS       => '0',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '7',
                        MAC              => '2C:6B:F5:9B:48:AC'
                    },
                    {
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFSTATUS         => '7',
                        IFNAME           => 'ge-3/0/45.0',
                        IFTYPE           => '53',
                        IFLASTCHANGE     => '(889646958) 102 days, 23:14:29.58',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '0',
                        IFDESCR          => 'ge-3/0/45.0',
                        IFNUMBER         => '1010',
                        MAC              => '2C:6B:F5:9B:48:AD'
                    },
                    {
                        IFNAME           => 'ge-3/0/46.0',
                        IFTYPE           => '53',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFSTATUS         => '7',
                        IFDESCR          => 'ge-3/0/46.0',
                        IFNUMBER         => '1011',
                        IFLASTCHANGE     => '(889646978) 102 days, 23:14:29.78',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        MAC              => '2C:6B:F5:9B:48:AE'
                    },
                    {
                        IFOUTOCTETS      => '0',
                        IFLASTCHANGE     => '(889646986) 102 days, 23:14:29.86',
                        IFMTU            => '1514',
                        IFNUMBER         => '1012',
                        IFDESCR          => 'ge-3/0/47.0',
                        IFSTATUS         => '7',
                        IFINOCTETS       => '0',
                        IFPORTDUPLEX     => '3',
                        IFTYPE           => '53',
                        IFNAME           => 'ge-3/0/47.0',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        MAC              => '2C:6B:F5:9B:48:AF'
                    },
                    {
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        IFSTATUS         => '7',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '64944',
                        IFTYPE           => '53',
                        IFNAME           => 'ge-3/0/5.0',
                        IFOUTOCTETS      => '8987124',
                        IFLASTCHANGE     => '(1450387216) 167 days, 20:51:12.16',
                        IFMTU            => '1514',
                        IFNUMBER         => '1013',
                        IFDESCR          => 'ge-3/0/5.0',
                        MAC              => '2C:6B:F5:9B:48:85'
                    },
                    {
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFDESCR          => 'ge-3/0/6.0',
                        IFNUMBER         => '1014',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1520369320) 175 days, 23:14:53.20',
                        IFOUTOCTETS      => '5600333',
                        IFNAME           => 'ge-3/0/6.0',
                        IFTYPE           => '53',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '64493',
                        IFSTATUS         => '7',
                        MAC              => '2C:6B:F5:9B:48:86'
                    },
                    {
                        IFOUTOCTETS      => '8647621',
                        IFLASTCHANGE     => '(1450388998) 167 days, 20:51:29.98',
                        IFMTU            => '1514',
                        IFNUMBER         => '1015',
                        IFDESCR          => 'ge-3/0/7.0',
                        IFSTATUS         => '7',
                        IFINOCTETS       => '69468',
                        IFPORTDUPLEX     => '3',
                        IFTYPE           => '53',
                        IFNAME           => 'ge-3/0/7.0',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        MAC              => '2C:6B:F5:9B:48:87'
                    },
                    {
                        IFLASTCHANGE     => '(1450401450) 167 days, 20:53:34.50',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '2946953',
                        IFDESCR          => 'ge-3/0/8.0',
                        IFNUMBER         => '1016',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '45500',
                        IFSTATUS         => '7',
                        IFNAME           => 'ge-3/0/8.0',
                        IFTYPE           => '53',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        MAC              => '2C:6B:F5:9B:48:88'
                    },
                    {
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFNUMBER         => '1017',
                        IFDESCR          => 'ge-3/0/9.0',
                        IFOUTOCTETS      => '6387035',
                        IFLASTCHANGE     => '(1520251378) 175 days, 22:55:13.78',
                        IFMTU            => '1514',
                        IFTYPE           => '53',
                        IFNAME           => 'ge-3/0/9.0',
                        IFSTATUS         => '7',
                        IFINOCTETS       => '65024',
                        IFPORTDUPLEX     => '3',
                        MAC              => '2C:6B:F5:9B:48:89'
                    },
                    {
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFNUMBER         => '1018',
                        IFDESCR          => 'ge-4/0/10.0',
                        IFOUTOCTETS      => '1777313',
                        IFLASTCHANGE     => '(1513317590) 175 days, 3:39:35.90',
                        IFMTU            => '1514',
                        IFTYPE           => '53',
                        IFNAME           => 'ge-4/0/10.0',
                        IFSTATUS         => '7',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '405945',
                        MAC              => '2C:6B:F5:9B:48:8A'
                    },
                    {
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        IFINOCTETS       => '271960',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '7',
                        IFNAME           => 'ge-4/0/11.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1547189561) 179 days, 1:44:55.61',
                        IFOUTOCTETS      => '2685389',
                        IFDESCR          => 'ge-4/0/11.0',
                        IFNUMBER         => '1019',
                        MAC              => '2C:6B:F5:9B:48:8B'
                    },
                    {
                        IFSTATUS         => '7',
                        IFINOCTETS       => '42474',
                        IFPORTDUPLEX     => '3',
                        IFTYPE           => '53',
                        IFNAME           => 'ge-4/0/12.0',
                        IFOUTOCTETS      => '183215',
                        IFLASTCHANGE     => '(1261267893) 145 days, 23:31:18.93',
                        IFMTU            => '1514',
                        IFNUMBER         => '1020',
                        IFDESCR          => 'ge-4/0/12.0',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        MAC              => '2C:6B:F5:9B:48:8C'
                    },
                    {
                        IFNAME           => 'ge-4/0/13.0',
                        IFTYPE           => '53',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '485324',
                        IFSTATUS         => '7',
                        IFDESCR          => 'ge-4/0/13.0',
                        IFNUMBER         => '1021',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1573227018) 182 days, 2:04:30.18',
                        IFOUTOCTETS      => '1957349',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        MAC              => '2C:6B:F5:9B:48:8D'
                    },
                    {
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFTYPE           => '53',
                        IFNAME           => 'ge-4/0/14.0',
                        IFSTATUS         => '7',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '302171',
                        IFNUMBER         => '1022',
                        IFDESCR          => 'ge-4/0/14.0',
                        IFOUTOCTETS      => '3246961',
                        IFLASTCHANGE     => '(1502383224) 173 days, 21:17:12.24',
                        IFMTU            => '1514',
                        MAC              => '2C:6B:F5:9B:48:8E'
                    },
                    {
                        IFTYPE           => '53',
                        IFNAME           => 'ge-4/0/15.0',
                        IFSTATUS         => '7',
                        IFINOCTETS       => '270593',
                        IFPORTDUPLEX     => '3',
                        IFNUMBER         => '1023',
                        IFDESCR          => 'ge-4/0/15.0',
                        IFOUTOCTETS      => '2360225',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1562688204) 180 days, 20:48:02.04',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        MAC              => '2C:6B:F5:9B:48:8F'
                    },
                    {
                        IFOUTOCTETS      => '1607515',
                        IFLASTCHANGE     => '(1486971782) 172 days, 2:28:37.82',
                        IFMTU            => '1514',
                        IFNUMBER         => '1024',
                        IFDESCR          => 'ge-4/0/16.0',
                        IFSTATUS         => '7',
                        IFINOCTETS       => '142748',
                        IFPORTDUPLEX     => '3',
                        IFTYPE           => '53',
                        IFNAME           => 'ge-4/0/16.0',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        MAC              => '2C:6B:F5:9B:48:90'
                    },
                    {
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFNUMBER         => '1025',
                        IFDESCR          => 'ge-4/0/17.0',
                        IFOUTOCTETS      => '2005526',
                        IFLASTCHANGE     => '(1452293958) 168 days, 2:08:59.58',
                        IFMTU            => '1514',
                        IFTYPE           => '53',
                        IFNAME           => 'ge-4/0/17.0',
                        IFSTATUS         => '7',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '245536',
                        MAC              => '2C:6B:F5:9B:48:91'
                    },
                    {
                        IFTYPE           => '53',
                        IFNAME           => 'ge-4/0/18.0',
                        IFSTATUS         => '7',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFNUMBER         => '1026',
                        IFDESCR          => 'ge-4/0/18.0',
                        IFOUTOCTETS      => '796',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1451188038) 167 days, 23:04:40.38',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        MAC              => '2C:6B:F5:9B:48:92'
                    },
                    {
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFNAME           => 'ge-4/0/19.0',
                        IFTYPE           => '53',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '182760',
                        IFSTATUS         => '7',
                        IFDESCR          => 'ge-4/0/19.0',
                        IFNUMBER         => '1027',
                        IFLASTCHANGE     => '(1563849546) 181 days, 0:01:35.46',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '1416969',
                        MAC              => '2C:6B:F5:9B:48:93'
                    },
                    {
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFDESCR          => 'ge-4/0/20.0',
                        IFNUMBER         => '1028',
                        IFLASTCHANGE     => '(1457971644) 168 days, 17:55:16.44',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '2011766',
                        IFNAME           => 'ge-4/0/20.0',
                        IFTYPE           => '53',
                        IFINOCTETS       => '262017',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '7',
                        MAC              => '2C:6B:F5:9B:48:94'
                    },
                    {
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1260778133) 145 days, 22:09:41.33',
                        IFOUTOCTETS      => '2323281',
                        IFDESCR          => 'ge-4/0/21.0',
                        IFNUMBER         => '1029',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '293820',
                        IFSTATUS         => '7',
                        IFNAME           => 'ge-4/0/21.0',
                        IFTYPE           => '53',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        MAC              => '2C:6B:F5:9B:48:95'
                    },
                    {
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1521627060) 176 days, 2:44:30.60',
                        IFOUTOCTETS      => '869618',
                        IFDESCR          => 'ge-4/0/22.0',
                        IFNUMBER         => '1030',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '78693',
                        IFSTATUS         => '7',
                        IFNAME           => 'ge-4/0/22.0',
                        IFTYPE           => '53',
                        MAC              => '2C:6B:F5:9B:48:96'
                    },
                    {
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1425677372) 165 days, 0:12:53.72',
                        IFOUTOCTETS      => '875417',
                        IFDESCR          => 'ge-4/0/24.0',
                        IFNUMBER         => '1031',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '248218',
                        IFSTATUS         => '7',
                        IFNAME           => 'ge-4/0/24.0',
                        IFTYPE           => '53',
                        MAC              => '2C:6B:F5:9B:48:98'
                    },
                    {
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '254265',
                        IFSTATUS         => '7',
                        IFNAME           => 'ge-4/0/25.0',
                        IFTYPE           => '53',
                        IFLASTCHANGE     => '(1424888386) 164 days, 22:01:23.86',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '1314895',
                        IFDESCR          => 'ge-4/0/25.0',
                        IFNUMBER         => '1032',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        MAC              => '2C:6B:F5:9B:48:99'
                    },
                    {
                        IFNUMBER         => '1033',
                        IFDESCR          => 'ge-4/0/26.0',
                        IFOUTOCTETS      => '3161191',
                        IFLASTCHANGE     => '(1572311952) 181 days, 23:31:59.52',
                        IFMTU            => '1514',
                        IFTYPE           => '53',
                        IFNAME           => 'ge-4/0/26.0',
                        IFSTATUS         => '7',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '835968',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        MAC              => '2C:6B:F5:9B:48:9A'
                    },
                    {
                        IFDESCR          => 'ge-4/0/27.0',
                        IFNUMBER         => '1034',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1521697066) 176 days, 2:56:10.66',
                        IFOUTOCTETS      => '1405760',
                        IFNAME           => 'ge-4/0/27.0',
                        IFTYPE           => '53',
                        IFINOCTETS       => '111918',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '7',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        MAC              => '2C:6B:F5:9B:48:9B'
                    },
                    {
                        IFDESCR          => 'ge-4/0/28.0',
                        IFNUMBER         => '1035',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1561658646) 180 days, 17:56:26.46',
                        IFOUTOCTETS      => '1726456',
                        IFNAME           => 'ge-4/0/28.0',
                        IFTYPE           => '53',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '334526',
                        IFSTATUS         => '7',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        MAC              => '2C:6B:F5:9B:48:9C'
                    },
                    {
                        IFSTATUS         => '7',
                        IFINOCTETS       => '17051',
                        IFPORTDUPLEX     => '3',
                        IFTYPE           => '53',
                        IFNAME           => 'ge-4/0/29.0',
                        IFOUTOCTETS      => '196812',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1504620827) 174 days, 3:30:08.27',
                        IFNUMBER         => '1036',
                        IFDESCR          => 'ge-4/0/29.0',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        MAC              => '2C:6B:F5:9B:48:9D'
                    },
                    {
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFDESCR          => 'ge-4/0/30.0',
                        IFNUMBER         => '1037',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1548020706) 179 days, 4:03:27.06',
                        IFOUTOCTETS      => '1977677',
                        IFNAME           => 'ge-4/0/30.0',
                        IFTYPE           => '53',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '478691',
                        IFSTATUS         => '7',
                        MAC              => '2C:6B:F5:9B:48:9E'
                    },
                    {
                        IFINOCTETS       => '383327',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '7',
                        IFNAME           => 'ge-4/0/31.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1444288680) 167 days, 3:54:46.80',
                        IFOUTOCTETS      => '1554424',
                        IFDESCR          => 'ge-4/0/31.0',
                        IFNUMBER         => '1038',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        MAC              => '2C:6B:F5:9B:48:9F'
                    },
                    {
                        IFINOCTETS       => '82189',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '7',
                        IFNAME           => 'ge-4/0/32.0',
                        IFTYPE           => '53',
                        IFLASTCHANGE     => '(1346820566) 155 days, 21:10:05.66',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '549718',
                        IFDESCR          => 'ge-4/0/32.0',
                        IFNUMBER         => '1039',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        MAC              => '2C:6B:F5:9B:48:A0'
                    },
                    {
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '882286',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1494210849) 172 days, 22:35:08.49',
                        IFNUMBER         => '1040',
                        IFDESCR          => 'ge-4/0/33.0',
                        IFSTATUS         => '7',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '320148',
                        IFTYPE           => '53',
                        IFNAME           => 'ge-4/0/33.0',
                        MAC              => '2C:6B:F5:9B:48:A1'
                    },
                    {
                        IFDESCR          => 'ge-4/0/34.0',
                        IFNUMBER         => '1041',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1579356778) 182 days, 19:06:07.78',
                        IFOUTOCTETS      => '5185945',
                        IFNAME           => 'ge-4/0/34.0',
                        IFTYPE           => '53',
                        IFINOCTETS       => '583990',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '1',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        MAC              => '2C:6B:F5:9B:48:A2'
                    },
                    {
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFLASTCHANGE     => '(1563844404) 181 days, 0:00:44.04',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '55291',
                        IFDESCR          => 'ge-4/0/35.0',
                        IFNUMBER         => '1042',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '28033',
                        IFSTATUS         => '7',
                        IFNAME           => 'ge-4/0/35.0',
                        IFTYPE           => '53',
                        MAC              => '2C:6B:F5:9B:48:A3'
                    },
                    {
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFDESCR          => 'ge-4/0/36.0',
                        IFNUMBER         => '1043',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1486855674) 172 days, 2:09:16.74',
                        IFOUTOCTETS      => '1262005',
                        IFNAME           => 'ge-4/0/36.0',
                        IFTYPE           => '53',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '219827',
                        IFSTATUS         => '7',
                        MAC              => '2C:6B:F5:9B:48:A4'
                    },
                    {
                        IFTYPE           => '53',
                        IFNAME           => 'ge-4/0/37.0',
                        IFSTATUS         => '7',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '39436',
                        IFNUMBER         => '1044',
                        IFDESCR          => 'ge-4/0/37.0',
                        IFOUTOCTETS      => '507797',
                        IFLASTCHANGE     => '(1554987262) 179 days, 23:24:32.62',
                        IFMTU            => '1514',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        MAC              => '2C:6B:F5:9B:48:A5'
                    },
                    {
                        IFOUTOCTETS      => '2505337',
                        IFLASTCHANGE     => '(1555608214) 180 days, 1:08:02.14',
                        IFMTU            => '1514',
                        IFNUMBER         => '1045',
                        IFDESCR          => 'ge-4/0/38.0',
                        IFSTATUS         => '7',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '431743',
                        IFTYPE           => '53',
                        IFNAME           => 'ge-4/0/38.0',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        MAC              => '2C:6B:F5:9B:48:A6'
                    },
                    {
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '471935',
                        IFSTATUS         => '7',
                        IFNAME           => 'ge-4/0/39.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1545422722) 178 days, 20:50:27.22',
                        IFOUTOCTETS      => '3019233',
                        IFDESCR          => 'ge-4/0/39.0',
                        IFNUMBER         => '1046',
                        MAC              => '2C:6B:F5:9B:48:A7'
                    },
                    {
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFNUMBER         => '1047',
                        IFDESCR          => 'ge-4/0/40.0',
                        IFOUTOCTETS      => '1654144',
                        IFLASTCHANGE     => '(1563754030) 180 days, 23:45:40.30',
                        IFMTU            => '1514',
                        IFTYPE           => '53',
                        IFNAME           => 'ge-4/0/40.0',
                        IFSTATUS         => '7',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '388026',
                        MAC              => '2C:6B:F5:9B:48:A8'
                    },
                    {
                        IFDESCR          => 'ge-4/0/41.0',
                        IFNUMBER         => '1048',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1555609888) 180 days, 1:08:18.88',
                        IFOUTOCTETS      => '1525142',
                        IFNAME           => 'ge-4/0/41.0',
                        IFTYPE           => '53',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '265438',
                        IFSTATUS         => '7',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        MAC              => '2C:6B:F5:9B:48:A9'
                    },
                    {
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        IFSTATUS         => '7',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '424780',
                        IFTYPE           => '53',
                        IFNAME           => 'ge-4/0/42.0',
                        IFOUTOCTETS      => '3875390',
                        IFLASTCHANGE     => '(1555987738) 180 days, 2:11:17.38',
                        IFMTU            => '1514',
                        IFNUMBER         => '1049',
                        IFDESCR          => 'ge-4/0/42.0',
                        MAC              => '2C:6B:F5:9B:48:AA'
                    },
                    {
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFTYPE           => '53',
                        IFNAME           => 'ge-4/0/43.0',
                        IFSTATUS         => '7',
                        IFINOCTETS       => '50074',
                        IFPORTDUPLEX     => '3',
                        IFNUMBER         => '1050',
                        IFDESCR          => 'ge-4/0/43.0',
                        IFOUTOCTETS      => '199380',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1442185282) 166 days, 22:04:12.82',
                        MAC              => '2C:6B:F5:9B:48:AB'
                    },
                    {
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFDESCR          => 'ge-4/0/44.0',
                        IFNUMBER         => '1051',
                        IFLASTCHANGE     => '(1390509782) 160 days, 22:31:37.82',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '1545',
                        IFNAME           => 'ge-4/0/44.0',
                        IFTYPE           => '53',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '6744',
                        IFSTATUS         => '7',
                        MAC              => '2C:6B:F5:9B:48:AC'
                    },
                    {
                        IFTYPE           => '53',
                        IFNAME           => 'ge-4/0/45.0',
                        IFSTATUS         => '7',
                        IFINOCTETS       => '691379',
                        IFPORTDUPLEX     => '3',
                        IFNUMBER         => '1052',
                        IFDESCR          => 'ge-4/0/45.0',
                        IFOUTOCTETS      => '5820489',
                        IFLASTCHANGE     => '(1572042943) 181 days, 22:47:09.43',
                        IFMTU            => '1514',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        MAC              => '2C:6B:F5:9B:48:AD'
                    },
                    {
                        IFTYPE           => '53',
                        IFNAME           => 'ge-4/0/46.0',
                        IFSTATUS         => '7',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '31883',
                        IFNUMBER         => '1053',
                        IFDESCR          => 'ge-4/0/46.0',
                        IFOUTOCTETS      => '545866',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1277476099) 147 days, 20:32:40.99',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        MAC              => '2C:6B:F5:9B:48:AE'
                    },
                    {
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFNAME           => 'ge-4/0/47.0',
                        IFTYPE           => '53',
                        IFINOCTETS       => '255078',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '7',
                        IFDESCR          => 'ge-4/0/47.0',
                        IFNUMBER         => '1054',
                        IFLASTCHANGE     => '(1450302458) 167 days, 20:37:04.58',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '2473863',
                        MAC              => '2C:6B:F5:9B:48:AF'
                    },
                    {
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        IFSTATUS         => '7',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '189600',
                        IFTYPE           => '53',
                        IFNAME           => 'ge-5/0/1.0',
                        IFOUTOCTETS      => '985388',
                        IFLASTCHANGE     => '(1451300698) 167 days, 23:23:26.98',
                        IFMTU            => '1514',
                        IFNUMBER         => '1055',
                        IFDESCR          => 'ge-5/0/1.0',
                        MAC              => '2C:6B:F5:9B:48:81'
                    },
                    {
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFNUMBER         => '1056',
                        IFDESCR          => 'ge-5/0/10.0',
                        IFOUTOCTETS      => '530510',
                        IFLASTCHANGE     => '(1261147396) 145 days, 23:11:13.96',
                        IFMTU            => '1514',
                        IFTYPE           => '53',
                        IFNAME           => 'ge-5/0/10.0',
                        IFSTATUS         => '7',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '60332',
                        MAC              => '2C:6B:F5:9B:48:8A'
                    },
                    {
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        IFSTATUS         => '7',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '15243',
                        IFTYPE           => '53',
                        IFNAME           => 'ge-5/0/11.0',
                        IFOUTOCTETS      => '15630',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1554633641) 179 days, 22:25:36.41',
                        IFNUMBER         => '1057',
                        IFDESCR          => 'ge-5/0/11.0',
                        MAC              => '2C:6B:F5:9B:48:8B'
                    },
                    {
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFTYPE           => '53',
                        IFNAME           => 'ge-5/0/12.0',
                        IFSTATUS         => '7',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFNUMBER         => '1058',
                        IFDESCR          => 'ge-5/0/12.0',
                        IFOUTOCTETS      => '0',
                        IFLASTCHANGE     => '(1071467652) 124 days, 0:17:56.52',
                        IFMTU            => '1514',
                        MAC              => '2C:6B:F5:9B:48:8C'
                    },
                    {
                        IFTYPE           => '53',
                        IFNAME           => 'ge-5/0/13.0',
                        IFSTATUS         => '7',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '103833',
                        IFNUMBER         => '1059',
                        IFDESCR          => 'ge-5/0/13.0',
                        IFOUTOCTETS      => '497765',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1254004460) 145 days, 3:20:44.60',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        MAC              => '2C:6B:F5:9B:48:8D'
                    },
                    {
                        IFINOCTETS       => '177072',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '7',
                        IFNAME           => 'ge-5/0/14.0',
                        IFTYPE           => '53',
                        IFLASTCHANGE     => '(1519633418) 175 days, 21:12:14.18',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '1143993',
                        IFDESCR          => 'ge-5/0/14.0',
                        IFNUMBER         => '1060',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        MAC              => '2C:6B:F5:9B:48:8E'
                    },
                    {
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        IFINOCTETS       => '14492',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '7',
                        IFNAME           => 'ge-5/0/15.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1389868950) 160 days, 20:44:49.50',
                        IFOUTOCTETS      => '15998',
                        IFDESCR          => 'ge-5/0/15.0',
                        IFNUMBER         => '1061',
                        MAC              => '2C:6B:F5:9B:48:8F'
                    },
                    {
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '1709315',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1554786300) 179 days, 22:51:03.00',
                        IFNUMBER         => '1062',
                        IFDESCR          => 'ge-5/0/16.0',
                        IFSTATUS         => '7',
                        IFINOCTETS       => '236903',
                        IFPORTDUPLEX     => '3',
                        IFTYPE           => '53',
                        IFNAME           => 'ge-5/0/16.0',
                        MAC              => '2C:6B:F5:9B:48:90'
                    },
                    {
                        IFINOCTETS       => '177990',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '7',
                        IFNAME           => 'ge-5/0/17.0',
                        IFTYPE           => '53',
                        IFLASTCHANGE     => '(1547593680) 179 days, 2:52:16.80',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '1655449',
                        IFDESCR          => 'ge-5/0/17.0',
                        IFNUMBER         => '1063',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        MAC              => '2C:6B:F5:9B:48:91'
                    },
                    {
                        IFTYPE           => '53',
                        IFNAME           => 'ge-5/0/18.0',
                        IFSTATUS         => '7',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '100252',
                        IFNUMBER         => '1064',
                        IFDESCR          => 'ge-5/0/18.0',
                        IFOUTOCTETS      => '1107028',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1565237721) 181 days, 3:52:57.21',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        MAC              => '2C:6B:F5:9B:48:92'
                    },
                    {
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1459729300) 168 days, 22:48:13.00',
                        IFOUTOCTETS      => '1179139',
                        IFDESCR          => 'ge-5/0/19.0',
                        IFNUMBER         => '1065',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '163554',
                        IFSTATUS         => '7',
                        IFNAME           => 'ge-5/0/19.0',
                        IFTYPE           => '53',
                        MAC              => '2C:6B:F5:9B:48:93'
                    },
                    {
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '1272858',
                        IFLASTCHANGE     => '(1484763324) 171 days, 20:20:33.24',
                        IFMTU            => '1514',
                        IFNUMBER         => '1066',
                        IFDESCR          => 'ge-5/0/2.0',
                        IFSTATUS         => '7',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '266050',
                        IFTYPE           => '53',
                        IFNAME           => 'ge-5/0/2.0',
                        MAC              => '2C:6B:F5:9B:48:82'
                    },
                    {
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFNAME           => 'ge-5/0/20.0',
                        IFTYPE           => '53',
                        IFINOCTETS       => '63978',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '7',
                        IFDESCR          => 'ge-5/0/20.0',
                        IFNUMBER         => '1067',
                        IFLASTCHANGE     => '(1553552604) 179 days, 19:25:26.04',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '81261',
                        MAC              => '2C:6B:F5:9B:48:94'
                    },
                    {
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        IFINOCTETS       => '99336',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '7',
                        IFNAME           => 'ge-5/0/21.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1562109850) 180 days, 19:11:38.50',
                        IFOUTOCTETS      => '982447',
                        IFDESCR          => 'ge-5/0/21.0',
                        IFNUMBER         => '1068',
                        MAC              => '2C:6B:F5:9B:48:95'
                    },
                    {
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '458352',
                        IFLASTCHANGE     => '(1546933044) 179 days, 1:02:10.44',
                        IFMTU            => '1514',
                        IFNUMBER         => '1069',
                        IFDESCR          => 'ge-5/0/22.0',
                        IFSTATUS         => '7',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '34792',
                        IFTYPE           => '53',
                        IFNAME           => 'ge-5/0/22.0',
                        MAC              => '2C:6B:F5:9B:48:96'
                    },
                    {
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFLASTCHANGE     => '(1547856186) 179 days, 3:36:01.86',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '1119889',
                        IFDESCR          => 'ge-5/0/23.0',
                        IFNUMBER         => '1070',
                        IFINOCTETS       => '127608',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '7',
                        IFNAME           => 'ge-5/0/23.0',
                        IFTYPE           => '53',
                        MAC              => '2C:6B:F5:9B:48:97'
                    },
                    {
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        IFSTATUS         => '7',
                        IFINOCTETS       => '19620',
                        IFPORTDUPLEX     => '3',
                        IFTYPE           => '53',
                        IFNAME           => 'ge-5/0/24.0',
                        IFOUTOCTETS      => '38985',
                        IFLASTCHANGE     => '(1571619548) 181 days, 21:36:35.48',
                        IFMTU            => '1514',
                        IFNUMBER         => '1071',
                        IFDESCR          => 'ge-5/0/24.0',
                        MAC              => '2C:6B:F5:9B:48:98'
                    },
                    {
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        IFSTATUS         => '7',
                        IFINOCTETS       => '141972',
                        IFPORTDUPLEX     => '3',
                        IFTYPE           => '53',
                        IFNAME           => 'ge-5/0/25.0',
                        IFOUTOCTETS      => '844932',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1572400418) 181 days, 23:46:44.18',
                        IFNUMBER         => '1072',
                        IFDESCR          => 'ge-5/0/25.0',
                        MAC              => '2C:6B:F5:9B:48:99'
                    },
                    {
                        IFOUTOCTETS      => '1011460',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1484727143) 171 days, 20:14:31.43',
                        IFNUMBER         => '1073',
                        IFDESCR          => 'ge-5/0/26.0',
                        IFSTATUS         => '7',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '452868',
                        IFTYPE           => '53',
                        IFNAME           => 'ge-5/0/26.0',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        MAC              => '2C:6B:F5:9B:48:9A'
                    },
                    {
                        IFNUMBER         => '1074',
                        IFDESCR          => 'ge-5/0/27.0',
                        IFOUTOCTETS      => '356792',
                        IFLASTCHANGE     => '(1443271750) 167 days, 1:05:17.50',
                        IFMTU            => '1514',
                        IFTYPE           => '53',
                        IFNAME           => 'ge-5/0/27.0',
                        IFSTATUS         => '7',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '37496',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        MAC              => '2C:6B:F5:9B:48:9B'
                    },
                    {
                        IFOUTOCTETS      => '796',
                        IFLASTCHANGE     => '(1432715230) 165 days, 19:45:52.30',
                        IFMTU            => '1514',
                        IFNUMBER         => '1075',
                        IFDESCR          => 'ge-5/0/28.0',
                        IFSTATUS         => '7',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFTYPE           => '53',
                        IFNAME           => 'ge-5/0/28.0',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        MAC              => '2C:6B:F5:9B:48:9C'
                    },
                    {
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        IFSTATUS         => '7',
                        IFINOCTETS       => '951427',
                        IFPORTDUPLEX     => '3',
                        IFTYPE           => '53',
                        IFNAME           => 'ge-5/0/29.0',
                        IFOUTOCTETS      => '1494699',
                        IFLASTCHANGE     => '(1365333952) 158 days, 0:35:39.52',
                        IFMTU            => '1514',
                        IFNUMBER         => '1076',
                        IFDESCR          => 'ge-5/0/29.0',
                        MAC              => '2C:6B:F5:9B:48:9D'
                    },
                    {
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1555932102) 180 days, 2:02:01.02',
                        IFOUTOCTETS      => '3030828',
                        IFDESCR          => 'ge-5/0/3.0',
                        IFNUMBER         => '1077',
                        IFINOCTETS       => '369814',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '7',
                        IFNAME           => 'ge-5/0/3.0',
                        IFTYPE           => '53',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        MAC              => '2C:6B:F5:9B:48:83'
                    },
                    {
                        IFNAME           => 'ge-5/0/30.0',
                        IFTYPE           => '53',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '189241',
                        IFSTATUS         => '7',
                        IFDESCR          => 'ge-5/0/30.0',
                        IFNUMBER         => '1078',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1556438310) 180 days, 3:26:23.10',
                        IFOUTOCTETS      => '1207069',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        MAC              => '2C:6B:F5:9B:48:9E'
                    },
                    {
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '132152',
                        IFSTATUS         => '7',
                        IFNAME           => 'ge-5/0/31.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1363902920) 157 days, 20:37:09.20',
                        IFOUTOCTETS      => '1052473',
                        IFDESCR          => 'ge-5/0/31.0',
                        IFNUMBER         => '1079',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        MAC              => '2C:6B:F5:9B:48:9F'
                    },
                    {
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFTYPE           => '53',
                        IFNAME           => 'ge-5/0/32.0',
                        IFSTATUS         => '7',
                        IFINOCTETS       => '316337',
                        IFPORTDUPLEX     => '3',
                        IFNUMBER         => '1080',
                        IFDESCR          => 'ge-5/0/32.0',
                        IFOUTOCTETS      => '495685',
                        IFLASTCHANGE     => '(1510880886) 174 days, 20:53:28.86',
                        IFMTU            => '1514',
                        MAC              => '2C:6B:F5:9B:48:A0'
                    },
                    {
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFSTATUS         => '7',
                        IFNAME           => 'ge-5/0/33.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1071467855) 124 days, 0:17:58.55',
                        IFOUTOCTETS      => '0',
                        IFDESCR          => 'ge-5/0/33.0',
                        IFNUMBER         => '1081',
                        MAC              => '2C:6B:F5:9B:48:A1'
                    },
                    {
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFTYPE           => '53',
                        IFNAME           => 'ge-5/0/34.0',
                        IFSTATUS         => '7',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '28297',
                        IFNUMBER         => '1082',
                        IFDESCR          => 'ge-5/0/34.0',
                        IFOUTOCTETS      => '74225',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1390508038) 160 days, 22:31:20.38',
                        MAC              => '2C:6B:F5:9B:48:A2'
                    },
                    {
                        IFTYPE           => '53',
                        IFNAME           => 'ge-5/0/35.0',
                        IFSTATUS         => '7',
                        IFINOCTETS       => '0',
                        IFPORTDUPLEX     => '3',
                        IFNUMBER         => '1083',
                        IFDESCR          => 'ge-5/0/35.0',
                        IFOUTOCTETS      => '0',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1071467875) 124 days, 0:17:58.75',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        MAC              => '2C:6B:F5:9B:48:A3'
                    },
                    {
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        IFSTATUS         => '7',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '55934',
                        IFTYPE           => '53',
                        IFNAME           => 'ge-5/0/36.0',
                        IFOUTOCTETS      => '610273',
                        IFLASTCHANGE     => '(1391353106) 161 days, 0:52:11.06',
                        IFMTU            => '1514',
                        IFNUMBER         => '1084',
                        IFDESCR          => 'ge-5/0/36.0',
                        MAC              => '2C:6B:F5:9B:48:A4'
                    },
                    {
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFLASTCHANGE     => '(1391354470) 161 days, 0:52:24.70',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '550394',
                        IFDESCR          => 'ge-5/0/37.0',
                        IFNUMBER         => '1085',
                        IFINOCTETS       => '89053',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '7',
                        IFNAME           => 'ge-5/0/37.0',
                        IFTYPE           => '53',
                        MAC              => '2C:6B:F5:9B:48:A5'
                    },
                    {
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFNAME           => 'ge-5/0/4.0',
                        IFTYPE           => '53',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '283783',
                        IFSTATUS         => '7',
                        IFDESCR          => 'ge-5/0/4.0',
                        IFNUMBER         => '1086',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1519665226) 175 days, 21:17:32.26',
                        IFOUTOCTETS      => '1784447',
                        MAC              => '2C:6B:F5:9B:48:84'
                    },
                    {
                        IFDESCR          => 'ge-5/0/40.0',
                        IFNUMBER         => '1087',
                        IFLASTCHANGE     => '(1510174312) 174 days, 18:55:43.12',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '20663',
                        IFNAME           => 'ge-5/0/40.0',
                        IFTYPE           => '53',
                        IFINOCTETS       => '1686',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '7',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        MAC              => '2C:6B:F5:9B:48:A8'
                    },
                    {
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '57471302',
                        IFSTATUS         => '1',
                        IFNAME           => 'ge-5/0/47.0',
                        IFTYPE           => '53',
                        IFLASTCHANGE     => '(1071481912) 124 days, 0:20:19.12',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '341928607',
                        IFDESCR          => 'ge-5/0/47.0',
                        IFNUMBER         => '1088',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        CONNECTIONS => {
                            CDP => 1,
                            CONNECTION => {
                                SYSMAC   => '78:FE:3D:3F:84:00',
                                IFDESCR  => 'ge-0/0/23.0',
                                IFNUMBER => '534',
                                SYSDESCR => 'Juniper Networks, Inc. ex2200-24p-4g , version 11.1R3.5 Build date: 2011-06-25 01:00:05 UTC ',
                                SYSNAME  => 'jta6-02'
                            }
                        },
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        MAC              => '2C:6B:F5:9B:48:AF'
                    },
                    {
                        IFOUTOCTETS      => '2645111',
                        IFLASTCHANGE     => '(1424586254) 164 days, 21:11:02.54',
                        IFMTU            => '1514',
                        IFNUMBER         => '1089',
                        IFDESCR          => 'ge-5/0/5.0',
                        IFSTATUS         => '7',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '326326',
                        IFTYPE           => '53',
                        IFNAME           => 'ge-5/0/5.0',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        MAC              => '2C:6B:F5:9B:48:85'
                    },
                    {
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFDESCR          => 'ge-5/0/6.0',
                        IFNUMBER         => '1090',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(1572359425) 181 days, 23:39:54.25',
                        IFOUTOCTETS      => '709660',
                        IFNAME           => 'ge-5/0/6.0',
                        IFTYPE           => '53',
                        IFINOCTETS       => '295188',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '7',
                        MAC              => '2C:6B:F5:9B:48:86'
                    },
                    {
                        IFINOCTETS       => '23563',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '7',
                        IFNAME           => 'ge-5/0/7.0',
                        IFTYPE           => '53',
                        IFLASTCHANGE     => '(1520500834) 175 days, 23:36:48.34',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '96567',
                        IFDESCR          => 'ge-5/0/7.0',
                        IFNUMBER         => '1091',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        MAC              => '2C:6B:F5:9B:48:87'
                    },
                    {
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFNAME           => 'ge-5/0/8.0',
                        IFTYPE           => '53',
                        IFINOCTETS       => '14015',
                        IFPORTDUPLEX     => '3',
                        IFSTATUS         => '7',
                        IFDESCR          => 'ge-5/0/8.0',
                        IFNUMBER         => '1092',
                        IFLASTCHANGE     => '(1546292486) 178 days, 23:15:24.86',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '340835',
                        MAC              => '2C:6B:F5:9B:48:88'
                    },
                    {
                        IFLASTCHANGE     => '(1579320303) 182 days, 19:00:03.03',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '754344',
                        IFDESCR          => 'ge-5/0/9.0',
                        IFNUMBER         => '1093',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '212072',
                        IFSTATUS         => '1',
                        IFNAME           => 'ge-5/0/9.0',
                        IFTYPE           => '53',
                        IFINERRORS       => '0',
                        IFSPEED          => '0',
                        IFINTERNALSTATUS => '1',
                        IFOUTERRORS      => '0',
                        MAC              => '2C:6B:F5:9B:48:89'
                    },
                    {
                        IFDESCR          => 'ge-3/0/0.0',
                        IFNUMBER         => '1094',
                        IFLASTCHANGE     => '(889646416) 102 days, 23:14:24.16',
                        IFMTU            => '1514',
                        IFOUTOCTETS      => '0',
                        IFNAME           => 'ge-3/0/0.0',
                        IFTYPE           => '53',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFSTATUS         => '7',
                        IFSPEED          => '0',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        MAC              => '2C:6B:F5:9B:48:80'
                    },
                    {
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => '1',
                        IFSPEED          => '1000000000',
                        IFINERRORS       => '0',
                        IFNAME           => 'jsrv.1',
                        IFTYPE           => '53',
                        IFINOCTETS       => '0',
                        IFSTATUS         => '1',
                        IFDESCR          => 'jsrv.1',
                        IFNUMBER         => '1096',
                        IFLASTCHANGE     => '(665) 0:00:06.65',
                        IFMTU            => '1500',
                        IFOUTOCTETS      => '0',
                        MAC              => '2C:6B:F5:9B:05:80'
                    }
                ]
            },
        }
    ],
    'juniper/srx3400.1.walk' => [
        {
            MANUFACTURER => 'Juniper',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Routeur Dauphine Juniper SRX3400',
            SNMPHOSTNAME => 'Dauphine-routeur',
            MAC          => '00:21:59:86:A8:00',
        },
        {
            MANUFACTURER => 'Juniper',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Routeur Dauphine Juniper SRX3400',
            SNMPHOSTNAME => 'Dauphine-routeur',
            MAC          => '00:21:59:86:A8:00',
        },
        {
            INFO => {
                MANUFACTURER => 'Juniper',
                TYPE         => 'NETWORKING',
                ID           => undef,
                MODEL        => undef,
            },
            PORTS => {
                PORT => []
            }
        }
    ],
    'juniper/srx3400.2.walk' => [
        {
            MANUFACTURER => 'Juniper',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Routeur Dauphine Juniper SRX3400',
            SNMPHOSTNAME => 'Dauphine-routeur',
            MAC          => '00:21:59:86:A8:00',
        },
        {
            MANUFACTURER => 'Juniper',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Routeur Dauphine Juniper SRX3400',
            SNMPHOSTNAME => 'Dauphine-routeur',
            MAC          => '00:21:59:86:A8:00',
        },
        {
            INFO => {
                MANUFACTURER => 'Juniper',
                TYPE         => 'NETWORKING',
                ID           => undef,
                MODEL        => undef,
            },
            PORTS => {
                PORT => []
            }
        }
    ],
    'juniper/srx3400.3.walk' => [
        {
            MANUFACTURER => 'Juniper',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Routeur Dauphine Juniper SRX3400',
            SNMPHOSTNAME => 'Dauphine-routeur',
            MAC          => '00:21:59:86:A8:00',
        },
        {
            MANUFACTURER => 'Juniper',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Routeur Dauphine Juniper SRX3400',
            SNMPHOSTNAME => 'Dauphine-routeur',
            MAC          => '00:21:59:86:A8:00',
        },
        {
            INFO => {
                MANUFACTURER => 'Juniper',
                TYPE         => 'NETWORKING',
                ID           => undef,
                MODEL        => undef,
            },
            PORTS => {
                PORT => []
            }
        }
    ],
);

setPlan(scalar keys %tests);

my $dictionary = getDictionnary();
my $index      = getIndex();

foreach my $test (sort keys %tests) {
    my $snmp  = getSNMP($test);
    my $model = getModel($index, $tests{$test}->[1]->{MODELSNMP});

    my %device0 = getDeviceInfo($snmp);
    cmp_deeply(\%device0, $tests{$test}->[0], "$test: base stage");

    my %device1 = getDeviceInfo($snmp, $dictionary);
    cmp_deeply(\%device1, $tests{$test}->[1], "$test: base + dictionnary stage");

    my $device3 = getDeviceFullInfo(
        snmp  => $snmp,
        model => $model,
    );
    cmp_deeply($device3, $tests{$test}->[2], "$test: base + model stage");
}
