#############################################################
# This file was automatically generated on 2022-05-11.      #
#                                                           #
# Perl Bindings Version 2.1.31                              #
#                                                           #
# If you have a bugfix for this file and want to commit it, #
# please fix the bug in the generator. You can find a link  #
# to the generators git repository on tinkerforge.com       #
#############################################################

=pod

=encoding utf8

=head1 NAME

Tinkerforge::BrickletTemperature - Measures ambient temperature with 0.5°C accuracy

=cut

package Tinkerforge::BrickletTemperature;

use strict;
use warnings;
use Carp;
use threads;
use threads::shared;
use parent 'Tinkerforge::Device';
use Tinkerforge::IPConnection;
use Tinkerforge::Error;

=head1 CONSTANTS

=over

=item DEVICE_IDENTIFIER

This constant is used to identify a Temperature Bricklet.

The get_identity() subroutine and the CALLBACK_ENUMERATE callback of the
IP Connection have a device_identifier parameter to specify the Brick's or
Bricklet's type.

=cut

use constant DEVICE_IDENTIFIER => 216;

=item DEVICE_DISPLAY_NAME

This constant represents the display name of a Temperature Bricklet.

=cut

use constant DEVICE_DISPLAY_NAME => 'Temperature Bricklet';

=item CALLBACK_TEMPERATURE

This constant is used with the register_callback() subroutine to specify
the CALLBACK_TEMPERATURE callback.

=cut

use constant CALLBACK_TEMPERATURE => 8;

=item CALLBACK_TEMPERATURE_REACHED

This constant is used with the register_callback() subroutine to specify
the CALLBACK_TEMPERATURE_REACHED callback.

=cut

use constant CALLBACK_TEMPERATURE_REACHED => 9;

=item FUNCTION_GET_TEMPERATURE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_TEMPERATURE => 1;

=item FUNCTION_SET_TEMPERATURE_CALLBACK_PERIOD

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_TEMPERATURE_CALLBACK_PERIOD => 2;

=item FUNCTION_GET_TEMPERATURE_CALLBACK_PERIOD

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_TEMPERATURE_CALLBACK_PERIOD => 3;

=item FUNCTION_SET_TEMPERATURE_CALLBACK_THRESHOLD

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_TEMPERATURE_CALLBACK_THRESHOLD => 4;

=item FUNCTION_GET_TEMPERATURE_CALLBACK_THRESHOLD

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_TEMPERATURE_CALLBACK_THRESHOLD => 5;

=item FUNCTION_SET_DEBOUNCE_PERIOD

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_DEBOUNCE_PERIOD => 6;

=item FUNCTION_GET_DEBOUNCE_PERIOD

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_DEBOUNCE_PERIOD => 7;

=item FUNCTION_SET_I2C_MODE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_I2C_MODE => 10;

=item FUNCTION_GET_I2C_MODE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_I2C_MODE => 11;

=item FUNCTION_GET_IDENTITY

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_IDENTITY => 255;
use constant THRESHOLD_OPTION_OFF => 'x';
use constant THRESHOLD_OPTION_OUTSIDE => 'o';
use constant THRESHOLD_OPTION_INSIDE => 'i';
use constant THRESHOLD_OPTION_SMALLER => '<';
use constant THRESHOLD_OPTION_GREATER => '>';
use constant I2C_MODE_FAST => 0;
use constant I2C_MODE_SLOW => 1;


=back

=head1 FUNCTIONS

=over

=item new()

Creates an object with the unique device ID *uid* and adds it to
the IP Connection *ipcon*.

=cut

sub new
{
	my ($class, $uid, $ipcon) = @_;

	my $self = Tinkerforge::Device->_new($uid, $ipcon, [2, 0, 1], &DEVICE_IDENTIFIER, &DEVICE_DISPLAY_NAME);

	$self->{response_expected}->{&FUNCTION_GET_TEMPERATURE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_TEMPERATURE_CALLBACK_PERIOD} = Tinkerforge::Device->_RESPONSE_EXPECTED_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_TEMPERATURE_CALLBACK_PERIOD} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_TEMPERATURE_CALLBACK_THRESHOLD} = Tinkerforge::Device->_RESPONSE_EXPECTED_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_TEMPERATURE_CALLBACK_THRESHOLD} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_DEBOUNCE_PERIOD} = Tinkerforge::Device->_RESPONSE_EXPECTED_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_DEBOUNCE_PERIOD} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_I2C_MODE} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_I2C_MODE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_IDENTITY} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;

	$self->{callback_formats}->{&CALLBACK_TEMPERATURE} = shared_clone([10, 's']);
	$self->{callback_formats}->{&CALLBACK_TEMPERATURE_REACHED} = shared_clone([10, 's']);



	bless($self, $class);

	$ipcon->_add_device($self);

	return $self;
}


=item get_temperature()

Returns the temperature of the sensor.

If you want to get the temperature periodically, it is recommended
to use the :cb:`Temperature` callback and set the period with
:func:`Set Temperature Callback Period`.

=cut

sub get_temperature
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_TEMPERATURE, [], '', 10, 's');
}

=item set_temperature_callback_period()

Sets the period with which the :cb:`Temperature` callback is triggered
periodically. A value of 0 turns the callback off.

The :cb:`Temperature` callback is only triggered if the temperature has changed
since the last triggering.

=cut

sub set_temperature_callback_period
{
	my ($self, $period) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_SET_TEMPERATURE_CALLBACK_PERIOD, [$period], 'L', 0, '');
}

=item get_temperature_callback_period()

Returns the period as set by :func:`Set Temperature Callback Period`.

=cut

sub get_temperature_callback_period
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_TEMPERATURE_CALLBACK_PERIOD, [], '', 12, 'L');
}

=item set_temperature_callback_threshold()

Sets the thresholds for the :cb:`Temperature Reached` callback.

The following options are possible:

.. csv-table::
 :header: "Option", "Description"
 :widths: 10, 100

 "'x'",    "Callback is turned off"
 "'o'",    "Callback is triggered when the temperature is *outside* the min and max values"
 "'i'",    "Callback is triggered when the temperature is *inside* the min and max values"
 "'<'",    "Callback is triggered when the temperature is smaller than the min value (max is ignored)"
 "'>'",    "Callback is triggered when the temperature is greater than the min value (max is ignored)"

=cut

sub set_temperature_callback_threshold
{
	my ($self, $option, $min, $max) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_SET_TEMPERATURE_CALLBACK_THRESHOLD, [$option, $min, $max], 'a s s', 0, '');
}

=item get_temperature_callback_threshold()

Returns the threshold as set by :func:`Set Temperature Callback Threshold`.

=cut

sub get_temperature_callback_threshold
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_TEMPERATURE_CALLBACK_THRESHOLD, [], '', 13, 'a s s');
}

=item set_debounce_period()

Sets the period with which the threshold callback

* :cb:`Temperature Reached`

is triggered, if the threshold

* :func:`Set Temperature Callback Threshold`

keeps being reached.

=cut

sub set_debounce_period
{
	my ($self, $debounce) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_SET_DEBOUNCE_PERIOD, [$debounce], 'L', 0, '');
}

=item get_debounce_period()

Returns the debounce period as set by :func:`Set Debounce Period`.

=cut

sub get_debounce_period
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_DEBOUNCE_PERIOD, [], '', 12, 'L');
}

=item set_i2c_mode()

Sets the I2C mode. Possible modes are:

* 0: Fast (400kHz)
* 1: Slow (100kHz)

If you have problems with obvious outliers in the
Temperature Bricklet measurements, they may be caused by EMI issues.
In this case it may be helpful to lower the I2C speed.

It is however not recommended to lower the I2C speed in applications where
a high throughput needs to be achieved.

.. versionadded:: 2.0.1$nbsp;(Plugin)

=cut

sub set_i2c_mode
{
	my ($self, $mode) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_SET_I2C_MODE, [$mode], 'C', 0, '');
}

=item get_i2c_mode()

Returns the I2C mode as set by :func:`Set I2C Mode`.

.. versionadded:: 2.0.1$nbsp;(Plugin)

=cut

sub get_i2c_mode
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_I2C_MODE, [], '', 9, 'C');
}

=item get_identity()

Returns the UID, the UID where the Bricklet is connected to,
the position, the hardware and firmware version as well as the
device identifier.

The position can be 'a', 'b', 'c', 'd', 'e', 'f', 'g' or 'h' (Bricklet Port).
A Bricklet connected to an :ref:`Isolator Bricklet <isolator_bricklet>` is always at
position 'z'.

The device identifier numbers can be found :ref:`here <device_identifier>`.
|device_identifier_constant|

=cut

sub get_identity
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_IDENTITY, [], '', 33, 'Z8 Z8 a C3 C3 S');
}

=back
=cut

1;
