# perl-worldcat-api

Perl bindings to the OCLC WorldCat API.

## Usage

```perl
my $api = WorldCat::API->new(
    institution_id         => "...",
    principle_id           => "...",
    principle_id_namespace => "...",
    secret                 => "...",
    wskey                  => "...",
);

my $marc_record = $api->find_by_oclc_number("12345678") or die "No such record";
```

## Testing

### Configuration

WorldCat::API gets its default credentials from the environment. It doesn't matter how you get them there; an easy solution is to add your test credentials to a .env file at the root of the project:

```ini
WORLDCAT_API_INSTITUTION_ID="..."
WORLDCAT_API_PRINCIPLE_ID="..."
WORLDCAT_API_PRINCIPLE_ID_NAMESPACE="..."
WORLDCAT_API_SECRET="..."
WORLDCAT_API_WSKEY="..."
```

### Build / Test

Docker makes it super easy to build the project and run tests:

```sh
docker build -t worldcatapi .
docker run --env-file .env worldcatapi prove -v
```
