use strict;
use warnings;
package WebService::SendGrid::Newsletter::Recipients;

use parent 'WebService::SendGrid::Newsletter::Base';


sub new {
    my ($class, %args) = @_;
    
    my $self = {};
    bless($self, $class);
    
    $self->{sgn} = $args{sgn};
    
    return $self;
}


sub add {
    my ($self, %args) = @_;

    $self->_check_required_args([ qw( name list ) ], %args);

    $self->{sgn}->_send_request('recipients/add', %args);
}


sub get {
    my ($self, %args) = @_;

    $self->_check_required_args([ qw( name ) ], %args);
    
    $self->{sgn}->_send_request('recipients/get', %args);
}


sub delete {
    my ($self, %args) = @_;

    $self->_check_required_args([ qw( name list ) ], %args);
    
    $self->{sgn}->_send_request('recipients/delete', %args);
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

WebService::SendGrid::Newsletter::Recipients

=head1 VERSION

version 0.01

=head1 METHODS

=head2 new

Creates a new instance of WebService::SendGrid::Newsletter::Recipients.

    my $recipients = WebService::SendGrid::Newsletter::Recipients->new(sgn => $sgn);

Parameters:

=over 4

=item * sgn

An instance of WebService::SendGrid::Newsletter.

=back

=head2 add

Assigns recipients list to the newsletter.

Parameters:

=over 4

=item * name

B<(Required)> The name of newsletter.

=item * list

B<(Required)> The name of existing list to assign to newsletter.

=back

=head2 get

Retrieves all recipient lists assigned to specified newsletter.

Parameters:

=over 4

=item * name

B<(Required)> The name of newsletter to retrieve lists.

=back

=head2 delete

Removes recipients list from the newsletter.

Parameters:

=over 4

=item * name

B<(Required)> The name of existing newsletter to be unassinged.

=item * list

B<(Required)> The name of specific list be removed from newsletter.

=back

=head1 AUTHOR

Michal Wojciechowski <odyniec@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2012 by Michal Wojciechowski.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
