package TestURIs;
use Moose;
use namespace::autoclean;

use Catalyst::Runtime 5.80;

# Set flags and add plugins for the application.
#
# Note that ORDERING IS IMPORTANT here as plugins are initialized in order,
# therefore you almost certainly want to keep ConfigLoader at the head of the
# list if you're using it.
#
#         -Debug: activates the debug mode for very useful log messages
#   ConfigLoader: will load the configuration from a Config::General file in the
#                 application's home directory
# Static::Simple: will serve static files from the application's root
#                 directory

use Catalyst qw/
    -Debug
    ConfigLoader
    Static::Simple
    ExternalURI
/;

extends 'Catalyst';

our $VERSION = '0.01';


# Configure the application.
#
# Note that settings in testuris.conf (or other external
# configuration file that you set up manually) take precedence
# over this when using ConfigLoader. Thus configuration
# details given here can function as a default configuration,
# with an external configuration file acting as an override for
# local deployment.

__PACKAGE__->config(
    name => 'TestURIs',
    # Disable deprecated behavior needed by old applications
    disable_component_resolution_regex_fallback => 1,
    enable_catalyst_header => 1, # Send X-Catalyst header
    externaluri => [
      { '^/static/' => 'https://static.example.com/mystatic' },
      { '^/static2/' => 'https://static.example.com/' },
      { match => '^/static3/', rewrite => 'https://static.example.com/mystatic' },
      { '^/static4/' => 'https://static.example.com/mystatic/' },
      { '^/css' => 'http://css.example.com' },
      { '^/js' => 'js.example.com:99' },
      { match => 'content', rewrite => 'content.example.com', continue => 1 },
      { 'secure' => 'https://' },
      { '^/versioned' => "http://static.example.com/$VERSION" },
      { '^/prefixed' => "/v2" },

      { match => 'archive', rewrite => 'archive.example.com' },
    ]
);

# Start the application
__PACKAGE__->setup();


=head1 NAME

TestURIs - Catalyst based application

=head1 SYNOPSIS

    script/testuris_server.pl

=head1 DESCRIPTION

[enter your description here]

=head1 SEE ALSO

L<TestURIs::Controller::Root>, L<Catalyst>

=head1 AUTHOR

capside,102,320,342

=head1 LICENSE

This library is free software. You can redistribute it and/or modify
it under the same terms as Perl itself.

=cut

1;
