package Sah::Schemas::Date::ID;

use strict;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2022-10-20'; # DATE
our $DIST = 'Sah-Schemas-Date-ID'; # DIST
our $VERSION = '0.008'; # VERSION

1;
# ABSTRACT: Sah schemas related to date (Indonesian)

__END__

=pod

=encoding UTF-8

=head1 NAME

Sah::Schemas::Date::ID - Sah schemas related to date (Indonesian)

=head1 VERSION

This document describes version 0.008 of Sah::Schemas::Date::ID (from Perl distribution Sah-Schemas-Date-ID), released on 2022-10-20.

=head1 SYNOPSIS

=head1 SAH SCHEMAS

The following schemas are included in this distribution:

=over

=item * L<date::dow_name::id|Sah::Schema::date::dow_name::id>

Day-of-week name (abbreviated or full, in Indonesian).

=item * L<date::dow_num::en_or_id|Sah::Schema::date::dow_num::en_or_id>

Day-of-week number (1-7, 1=Monday).

=item * L<date::dow_num::id|Sah::Schema::date::dow_num::id>

Day-of-week number (1-7, 1=Monday).

=item * L<date::dow_nums::en_or_id|Sah::Schema::date::dow_nums::en_or_id>

Array of day-of-week numbers (1-7, 1=Monday).

=item * L<date::dow_nums::id|Sah::Schema::date::dow_nums::id>

Array of day-of-week numbers (1-7, 1=Monday).

=item * L<date::month::id|Sah::Schema::date::month::id>

Month numberE<sol>name (abbreviated or full, in Indonesian).

=item * L<date::month_name::id|Sah::Schema::date::month_name::id>

Month name (abbreviated or full, in Indonesian).

=item * L<date::month_num::en_or_id|Sah::Schema::date::month_num::en_or_id>

Month number.

=item * L<date::month_num::id|Sah::Schema::date::month_num::id>

Month number.

=item * L<date::month_nums::en_or_id|Sah::Schema::date::month_nums::en_or_id>

Array of month numbers.

=item * L<date::month_nums::id|Sah::Schema::date::month_nums::id>

Array of month numbers.

=back

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Sah-Schemas-Date-ID>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Sah-Schemas-Date-ID>.

=head1 SEE ALSO

L<Data::Sah::Type::date>

L<Sah::Schemas::Date>

L<Sah> - schema specification

L<Data::Sah> - Perl implementation of Sah

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 CONTRIBUTING


To contribute, you can send patches by email/via RT, or send pull requests on
GitHub.

Most of the time, you don't need to build the distribution yourself. You can
simply modify the code, then test via:

 % prove -l

If you want to build the distribution (e.g. to try to install it locally on your
system), you can install L<Dist::Zilla>,
L<Dist::Zilla::PluginBundle::Author::PERLANCAR>,
L<Pod::Weaver::PluginBundle::Author::PERLANCAR>, and sometimes one or two other
Dist::Zilla- and/or Pod::Weaver plugins. Any additional steps required beyond
that are considered a bug and can be reported to me.

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2022, 2020, 2019 by perlancar <perlancar@cpan.org>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Sah-Schemas-Date-ID>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=cut
