.TH FINDSRC 1L
''' $Id: findsrc.man,v 3.0.3.3 1993/08/25 17:04:36 ram Exp $
'''
''' $Log: findsrc.man,v $
''' Revision 3.0.3.3  1993/08/25  17:04:36  ram
''' patch12: cleanup checkin for RCS 5.6
'''
''' Revision 3.0.3.2  91/04/07  18:50:30  ram
''' patch1: merged official cshar 3.0 into beta version
''' 
''' Revision 3.0.3.1  91/01/21  11:31:56  ram
''' 3.0 baseline (ram).
''' 
'''
.SH NAME
findsrc \- walk directories, trying to find source files
.SH SYNOPSIS
.RS
.na
.ti -.5i
.B findsrc
[
.BI \-d\| y_or_n
] [
.BI \-h\| #
] [
.B \-l
] [
.B \-m
] [
.BI \-n\| pattern
] [
.BI \-N\| pattern
] [
.BI \-o\| name
] [
.B \-r
] [
.B \-s
] [
.B \-v
] [
.B \-x
] [
.BI \-y\| pattern
] [
.BI \-Y\| pattern
] [ file... ]
.ad
.RE
.SH DESCRIPTION
.I Findsrc
recursively examines all directories and files specified on the command
line, and determines, based on the file name, whether the file contains
source code or not.
All directories are listed first, followed by all regular files,
with one item per line.
.PP
.I Findsrc
has a built-in table of shell wildcard patterns that it uses to determine
whether or not a file is source or not.
To add to the table, use the ``\-y'' or ``\-n'' options.
Both options take a shell pattern; the ``\-y'' indicates that the pattern
is to be included, and the ``\-n'' indicates that files matching the
pattern are to be excluded.
For the patterns, an asterisk means any zero or more characters, and
square brackets match any characters in the brackets.
For example, ``\-yconfig.*'' will add the configuration files distributed
with the shar package, while ``\-nPart0[0-9]'' will exclude shar kits.
To just see the pattern table, use the ``\-x'' option.
The order in the table is important, so patterns added on the
command line will be inserted at the start of the table.
Note that patterns are added in the order in which they appear in the
command line, so to exclude all but one log file, use this order
\&``\-n\e*.log\ -ypatch.log.''
.PP
The ``\-y'' or ``\-n'' options only look at the last component of
the filename.
To compare the full pathname of the file against the pattern, use
the uppercase version of the letter.
For example, ``\-N*/junk/*'' will skip all files in any directory named ``junk.''
.PP
Note that since the patterns used contain shell wildcard characters, they
will have to be quoted to prevent the shell from trying to do the expansion.
.PP
If it is unable to make a decision, it invokes the
.IR file (1)
command, and prompts the user for a decision.
In reply to the prompt, type the letter ``y'' or ``n'' (either case);
a simple return is taken to mean ``yes.''
If the reply starts with an exclamation point, the rest of the line
is passed off to a sub-shell and the question is repeated.
The ``\-d'' option may be used with an argument of ``y'' or ``n''
to by-pass the interaction, and provide a default answer.
.PP
The ``\-o'' option may be used to specify an output filename.
This is designed to prevent confusion if a command like the following
is executed:
.RS
findsrc . * >LIST
.RE
.PP
As a convenience to
.IR maniscan (1L)
and
.IR makekit (1L),
.I findsrc
can put some leading blank lines at the top of its output.
These are normally skipped by
.I maniscan
and turned into manifest headers by
.IR makekit .
The ``\-h'' option may be used to indicate the number of header lines to
generate.
The ``\-m'' option is the same as giving the options
\&``-oMANIFEST -h2.''
.PP
By default,
.I findsrc
ignores RCS and SCCS files and directories; using either the ``\-r''
or ``\-s'' option causes both to be included.
.PP
.I Findsrc
normally lists only the names of those files that have been selected.
If the ``\-l'' option is used, rejected files are logged to the output
preceeded by the word ``REJECTED.''
.PP
If no files are specified on the command line, the program operates as
a filter, reading a list of files and directories from the standard
input, one per line.
.PP
The ``\-v'' option prints out the current version and exits.
.SH "SEE ALSO"
makekit(1L).
