
package Paws::IoT::ListViolationEvents;
  use Moose;
  has EndTime => (is => 'ro', isa => 'Str', traits => ['ParamInQuery'], query_name => 'endTime', required => 1);
  has MaxResults => (is => 'ro', isa => 'Int', traits => ['ParamInQuery'], query_name => 'maxResults');
  has NextToken => (is => 'ro', isa => 'Str', traits => ['ParamInQuery'], query_name => 'nextToken');
  has SecurityProfileName => (is => 'ro', isa => 'Str', traits => ['ParamInQuery'], query_name => 'securityProfileName');
  has StartTime => (is => 'ro', isa => 'Str', traits => ['ParamInQuery'], query_name => 'startTime', required => 1);
  has ThingName => (is => 'ro', isa => 'Str', traits => ['ParamInQuery'], query_name => 'thingName');

  use MooseX::ClassAttribute;

  class_has _api_call => (isa => 'Str', is => 'ro', default => 'ListViolationEvents');
  class_has _api_uri  => (isa => 'Str', is => 'ro', default => '/violation-events');
  class_has _api_method  => (isa => 'Str', is => 'ro', default => 'GET');
  class_has _returns => (isa => 'Str', is => 'ro', default => 'Paws::IoT::ListViolationEventsResponse');
1;

### main pod documentation begin ###

=head1 NAME

Paws::IoT::ListViolationEvents - Arguments for method ListViolationEvents on L<Paws::IoT>

=head1 DESCRIPTION

This class represents the parameters used for calling the method ListViolationEvents on the
L<AWS IoT|Paws::IoT> service. Use the attributes of this class
as arguments to method ListViolationEvents.

You shouldn't make instances of this class. Each attribute should be used as a named argument in the call to ListViolationEvents.

=head1 SYNOPSIS

    my $iot = Paws->service('IoT');
    my $ListViolationEventsResponse = $iot->ListViolationEvents(
      EndTime             => '1970-01-01T01:00:00',
      StartTime           => '1970-01-01T01:00:00',
      MaxResults          => 1,                              # OPTIONAL
      NextToken           => 'MyNextToken',                  # OPTIONAL
      SecurityProfileName => 'MySecurityProfileName',        # OPTIONAL
      ThingName           => 'MyDeviceDefenderThingName',    # OPTIONAL
    );

    # Results:
    my $NextToken       = $ListViolationEventsResponse->NextToken;
    my $ViolationEvents = $ListViolationEventsResponse->ViolationEvents;

    # Returns a L<Paws::IoT::ListViolationEventsResponse> object.

Values for attributes that are native types (Int, String, Float, etc) can passed as-is (scalar values). Values for complex Types (objects) can be passed as a HashRef. The keys and values of the hashref will be used to instance the underlying object.
For the AWS API documentation, see L<https://docs.aws.amazon.com/goto/WebAPI/iot/ListViolationEvents>

=head1 ATTRIBUTES


=head2 B<REQUIRED> EndTime => Str

The end time for the alerts to be listed.



=head2 MaxResults => Int

The maximum number of results to return at one time.



=head2 NextToken => Str

The token for the next set of results.



=head2 SecurityProfileName => Str

A filter to limit results to those alerts generated by the specified
security profile.



=head2 B<REQUIRED> StartTime => Str

The start time for the alerts to be listed.



=head2 ThingName => Str

A filter to limit results to those alerts caused by the specified
thing.




=head1 SEE ALSO

This class forms part of L<Paws>, documenting arguments for method ListViolationEvents in L<Paws::IoT>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

