# Generated by default/object.tt
package Paws::ACMPCA::GeneralName;
  use Moose;
  has DirectoryName => (is => 'ro', isa => 'Paws::ACMPCA::ASN1Subject');
  has DnsName => (is => 'ro', isa => 'Str');
  has EdiPartyName => (is => 'ro', isa => 'Paws::ACMPCA::EdiPartyName');
  has IpAddress => (is => 'ro', isa => 'Str');
  has OtherName => (is => 'ro', isa => 'Paws::ACMPCA::OtherName');
  has RegisteredId => (is => 'ro', isa => 'Str');
  has Rfc822Name => (is => 'ro', isa => 'Str');
  has UniformResourceIdentifier => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::ACMPCA::GeneralName

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::ACMPCA::GeneralName object:

  $service_obj->Method(Att1 => { DirectoryName => $value, ..., UniformResourceIdentifier => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::ACMPCA::GeneralName object:

  $result = $service_obj->Method(...);
  $result->Att1->DirectoryName

=head1 DESCRIPTION

Describes an ASN.1 X.400 C<GeneralName> as defined in RFC 5280
(https://tools.ietf.org/html/rfc5280). Only one of the following naming
options should be provided. Providing more than one option results in
an C<InvalidArgsException> error.

=head1 ATTRIBUTES


=head2 DirectoryName => L<Paws::ACMPCA::ASN1Subject>




=head2 DnsName => Str

Represents C<GeneralName> as a DNS name.


=head2 EdiPartyName => L<Paws::ACMPCA::EdiPartyName>

Represents C<GeneralName> as an C<EdiPartyName> object.


=head2 IpAddress => Str

Represents C<GeneralName> as an IPv4 or IPv6 address.


=head2 OtherName => L<Paws::ACMPCA::OtherName>

Represents C<GeneralName> using an C<OtherName> object.


=head2 RegisteredId => Str

Represents C<GeneralName> as an object identifier (OID).


=head2 Rfc822Name => Str

Represents C<GeneralName> as an RFC 822
(https://tools.ietf.org/html/rfc822) email address.


=head2 UniformResourceIdentifier => Str

Represents C<GeneralName> as a URI.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::ACMPCA>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

