# Generated by default/object.tt
package Paws::KMS::MultiRegionKey;
  use Moose;
  has Arn => (is => 'ro', isa => 'Str');
  has Region => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::KMS::MultiRegionKey

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::KMS::MultiRegionKey object:

  $service_obj->Method(Att1 => { Arn => $value, ..., Region => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::KMS::MultiRegionKey object:

  $result = $service_obj->Method(...);
  $result->Att1->Arn

=head1 DESCRIPTION

Describes the primary or replica key in a multi-Region key.

=head1 ATTRIBUTES


=head2 Arn => Str

Displays the key ARN of a primary or replica key of a multi-Region key.


=head2 Region => Str

Displays the AWS Region of a primary or replica key in a multi-Region
key.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::KMS>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

