#!/usr/bin/perl -w
use strict;

# -------------------------------------------------------------------
# Library Modules

use lib qw(t/lib);
use Test::More tests => 41;

use CPAN::Testers::WWW::Reports::Mailer;

use TestObject;

# -------------------------------------------------------------------
# Variables

my $CONFIG = 't/_DBDIR/preferences.ini';

# -------------------------------------------------------------------
# Tests

SKIP: {
    skip "No supported databases available", 41  unless(-f $CONFIG);

    ok( my $obj = TestObject->load(), "got object" );

    # test the attributes generated by Class::Accessor::Fast

    # predefined attributes
    for my $k ( qw/
        verbose
        nomail
        test
        logfile
        logclean
        tt
        pause
        lastmail
        mode
        mailrc
    / ){
        my $label = "[$k]";
        SKIP: {
            ok( $obj->can($k), "$label can" )                   or skip "'$k' attribute missing", 3;
            isnt( $obj->$k(), undef, "$label has default" );
            is( $obj->$k(123), 123, "$label set" );
            is( $obj->$k, 123, "$label get" );
        };
    }
}
