#!/usr/bin/perl -w

use strict;

require 5.006 ;
use ExtUtils::MakeMaker ;
use Config ;

########
# VARS #
########

my $exe = $Config{_exe};

my $rm = $^O eq 'MSWin32' ? '$(PERL) -MExtUtils::Command -e rm_f' : 'rm';
my $mv = $^O eq 'MSWin32' ? '$(PERL) -MExtUtils::Command -e mv' : 'mv';

my $rm_exe = "-\$(RM) *$exe" if $exe ;

#################
# WRITEMAKEFILE #
#################

print "Writing Makefile for the embed program (LibZipBin)\n";

open OUT, "> Makefile" or die "open 'Makefile': $!";

################################################################################

print OUT <<EOT;
# AUTOGENERATED, DO NOT EDIT, RERUN Makefile.PL

RM=$rm
MV=$mv
PERL=$^X


all: tinyperl$exe

clean:
	-\$(RM) *.dll *.so *.exe *.zip libzip.modules
	-\$(RM) *.opt *.pdb
	\$(MV) Makefile Makefile.old

realclean: clean
	-\$(RM) tinyperl$exe
	-\$(RM) Makefile Makefile.old

tinyperl$exe: \$(OBJECTS)
	\$(PERL) lib.pl
	\$(PERL) ../script/libzip.pl -ob tinyperl.pl -allowopts ceiITvVwWX


EOT


################################################################################


