package Net::Async::Spotify::Object::Generated::Disallows;

use strict;
use warnings;

our $VERSION = '0.001'; # VERSION
our $AUTHORITY = 'cpan:VNEALV'; # AUTHORITY

use mro;
use parent qw(Net::Async::Spotify::Object::Base);

=encoding utf8

=head1 NAME

Net::Async::Spotify::Object::Generated::Disallows - Package representing Spotify Disallows Object

=head1 DESCRIPTION

Autogenerated module.
Based on https://developer.spotify.com/documentation/web-api/reference/#objects-index
Check C<crawl-api-doc.pl> for more information.

=head1 PARAMETERS

Those are Spotify Disallows Object attributes:

=over 4

=item interrupting_playback

Type:Boolean
Description:Interrupting playback. Optional field.

=item pausing

Type:Boolean
Description:Pausing. Optional field.

=item resuming

Type:Boolean
Description:Resuming. Optional field.

=item seeking

Type:Boolean
Description:Seeking playback location. Optional field.

=item skipping_next

Type:Boolean
Description:Skipping to the next context. Optional field.

=item skipping_prev

Type:Boolean
Description:Skipping to the previous context. Optional field.

=item toggling_repeat_context

Type:Boolean
Description:Toggling repeat context flag. Optional field.

=item toggling_repeat_track

Type:Boolean
Description:Toggling repeat track flag. Optional field.

=item toggling_shuffle

Type:Boolean
Description:Toggling shuffle flag. Optional field.

=item transferring_playback

Type:Boolean
Description:Transfering playback between devices. Optional field.

=back

=cut

sub new {
    my ($class, %args) = @_;

    my $fields = {
        interrupting_playback => 'Boolean',
        pausing => 'Boolean',
        resuming => 'Boolean',
        seeking => 'Boolean',
        skipping_next => 'Boolean',
        skipping_prev => 'Boolean',
        toggling_repeat_context => 'Boolean',
        toggling_repeat_track => 'Boolean',
        toggling_shuffle => 'Boolean',
        transferring_playback => 'Boolean',
    };

    my $obj = next::method($class, $fields, %args);

    return $obj;
}

1;
