use strict;
use warnings;
use Test::More;
use Git::Version::Compare;

my @tests = (
    [ undef, undef ],

    # actual output from `git --version`
    [ '0.99.7',                '00.99.07.00.00.0000' ],
    [ '0.99.9l',               '00.99.09.12.00.0000' ],
    [ '1.2.3',                 '01.02.03.00.00.0000' ],
    [ '1.2.3',                 '01.02.03.00.00.0000' ],
    [ '1.8.0.rc3',             '01.08.00.00-03.0000' ],
    [ '1.8.0',                 '01.08.00.00.00.0000' ],
    [ '1.8.0.3',               '01.08.00.03.00.0000' ],
    [ '1.8.5.4.19.g5032098',   '01.08.05.04.00.0019' ],
    [ '2.3.0.rc0.36.g63a0e83', '02.03.00.00-00.0036' ],

    # Win32 msysgit
    [ '1.9.4.msysgit.0', '01.09.04.00.00.0000' ],
    [ '1.9.5.msysgit.1', '01.09.05.00.00.0000' ],

    # plausible version numbers
    [ '1.0.rc4', '00.99.09.12.00.0000' ],
    [ '1.0rc4',  '00.99.09.12.00.0000' ],
    [ '1.6',     '01.06.00.00.00.0000' ],

    # tags from git.git
    [ 'v1.0rc4',                '00.99.09.12.00.0000' ],
    [ 'v1.7.12-rc2',            '01.07.12.00-02.0000' ],
    [ 'v1.8.4.5',               '01.08.04.05.00.0000' ],
    [ 'v1.8.5.4-19-g5032098',   '01.08.05.04.00.0019' ],
    [ 'v2.0.0-rc0',             '02.00.00.00-00.0000' ],
    [ 'v1.5.3.7-971-g61fd255',  '01.05.03.07.00.0971' ],
    [ 'v1.5.3.7-1198-g467f42c', '01.05.03.07.00.1198' ],
);

plan tests => scalar @tests;

for my $t (@tests) {
    is( Git::Version::Compare::_normalize( $t->[0] ),
        $t->[1], $t->[0] || 'undef' );
}
