#!/usr/bin/perl
# based on fl3.mpg
# http://bmrc.berkeley.edu/ftp/pub/multimedia/mpeg/mpeg2/conformance-bitstreams/audio/mpeg1/compliance/

use strict;
use integer;

my $n;
use Test::More tests => ($n = 49) * 8 + 3;
BEGIN { use_ok("MPEG::Audio::Frame") };

my $i;
for (1 .. $n){
	isa_ok(my $frame = MPEG::Audio::Frame->read(*DATA), "MPEG::Audio::Frame", "frame $_");
	ok($frame->mpeg1, "frame is MPEG1");
	ok($frame->layer1, "frame is layer I");
	ok($frame->has_crc, "frame has CRC");
	ok(!$frame->broken, "frame isn't broken");
	is($frame->bitrate, 384, "bitrate");
	is($frame->sample, 48000, "sample rate");
	ok($frame->any_stereo, "frame is some kind of stereo");
	$i++ if $frame->joint_stereo;
}
is(MPEG::Audio::Frame->read(*DATA), undef, "nothing else in the file");
ok($i, "at least some frames were intensity mode joint stereo");

__DATA__
d{ڈwfwUfDUD2        4ں<m4ڍuy~}  ߿}{ڸ 0 _`~}ڀ	 p7}}_ڿ{{}0^߃ݸ\=ڄ8ڷڗ~} .cژw-ˁڋErrڱ\]ڌگQhV}pX_< mLz1`XPP^ڌaE gOb'17HڐAjޒA+"	 OissBuu}p]ڻW$ڞWA `4h(&xRچ:
`G~~Bڿzz}P{tڣ2ڙwUUUDDDDDD33"!       0ھھڷOں͖_~(w9!7ڝf,,ڮtc3Z\ڍr6$IPP9eڶ9wwmh
)Sڼm9ъֵڤM7ڍb(ڨmj1kYn]yu®\3ڲ
l!ڎ	'<H9s\ԤYg]kZ9ZyUW1*"TP4MM3,tڹc4BLaڇ9r$ږ]uBe'ݙڶ+کڄ0t9|N;'D1}:խc-gffm.qڤMgu\!ڜc;7 ڹ5ںwUUDDDDD333""               4ھ{}M/<JLcLڶn
hfڞuJڄ2!	0ڰVtc)Nn-+N8pNM`ڌ\ڌffnEڙczLLL1nt)F.sڼCmڪ  	ATnnڌ\9΄mmۥXȱM4Ӝ0ڝjA1oښڊǽkiGxfZa$Iڜy5B|b;ڻ"evfg]61ΌaAUڴ5ljdƺڒNs LͶگ?ژ0@UY\qڌAUڈm% D2wwvfTC!      q]ھھ(XPک	0\QL\s?N>ڜp1#<4 锆ڭwpt4q?`@:]iڢ*̭Nq,m8pmۃm"d&AΘ2 t(Qڑ:zzں·Eڲ6"ڽo$Iډڗ'/>`e@ZڵPڡ 8"Ƭ+4`ڑ/BDkc gڶzZ~a
Zھ'])җںmJTL]p`Sگ_˄	/[Lo^\oqF$osF}/j>}{羄#ڊ-OfNڙ
ڋGڢS9ڢN)ڭڭ TefffffUD2      M4ڪھھDQ%c4 g3F|`I&ŢzڪU @gڳ0 P>8B:g"a`j9rAXh'L!zp
տJړgb ~&}gS0fڃ."y[|٭KSXnڰڞ<e;wFڞmL%{)aR ZڍGǓ&Kǰ릾/ڌݙ8-pZڿ~>3|ڲ؞'ڏű0ړ'ϑڬaXT:ڹo2eڌa}ړ) .ڶ_/۸0[i7k>A|'NDR)
={2dڣDZ d<	wUfUUUDDDD3!       4ھھffXq G}ujڌc#EY2ڋ)l	ڳ$ڼ5ڳ36>>Bԅ^ڇ~2zR1'h(fڜ;/ڹlQDO|bPС( 
ieI΃[n4ME-tT\>ڸXFAb ueڔڐhMedl;l<x5$s̙ڀՇ`݃qp(ڌVڝ˫Q=DM5{3%-;\L3(ڱ9ږWڔڻ;@ڀ
I,CXگ<39Ns&tn@fU33DUUUDDD33"      }I#ڒOھھ޷Wܤ_Effqږ^ykZwxՋ2̈A߈{^_}kcڙh3fڃu7Wwwsڗ]U`ځuVn扠ځUW][m΄!Wvؑڟ	5Xߙڈb(zscڶׯbȰS'PufZahڗd>ڞUsڢiډ9hP-ڄ	څWf{ډrs{h!fڄ1ڹfw}ڦvڵچNX\40U{ڝucyڗ1ww{J8ڎRci&L| AڈUsږY\qJsY HDw3"3DUDDD33""              ھc8ھھ{\_cǟڈdkcXVڵ.ځt>Yݶe*#;ww&E,ڬs	!&]wsbssgtYRR"Q7:nvaڈBa	JwfI%{Pډ`ڕRfa^TDڛWڂ
0Qܯ]UڹB8罌UwnE{3	+ڼWZڨwRڄffXB;u[H*i)HfE`ڟڲ3dP
[wk_~1NwtDXA P~ǌzڵ\Awڑ  )HP7[kRJ1{ffÝ Poڌ>C'u8ڹJ1wwE DWTWvU2     U4ھW*+V4a
mOK<6US
a]A:EYnjڊ&g2ڲsgڥ7EMڀMnc-Oڳ\wڦڣϠAܠ(&8sCZ<(Z8gڶK_6k;"E3K%}OڪFt|9-ET]ڎNb1*RڒzIڃ5ss+ybP2`P*MIڐBڤ/IoڠW$<=~w|P؜Mڍ1ڞ2v"D:%++k!0ƇC]kݘ;0.Sy,780ڜNs>4ʏ8>fڅ1ڋCVK)1&'ڦ@+*$ TStgڪD"4fveC!      ھ(4ӎگھھڅ
IyFEH:BC5i13fL(QMl]ڻA{pڐ8ښS@h
/isگAzڜ>
ڌ˚ڽ_ C\Pڍ$h6gڝVlڶY+%?چB
ڼgbݩDcF8o%.q9ڞQlڵ2eEԗ7F&MJT+[$5ڻ]{6$Kڟک;Fuck)$u+`T%1ڕ+ڤ JM^Hyu-c4=@6k*IKo7maڛڂX3ƫ5\ڽuH5,St `V:ڬw\z޶nkޭ diffwډ""DUeTC!      QCmھf,Yڽ%Y*j<ttŊ-څj:/muکU(e˓%ڱi9 @
n")<ڡK)ڕ?/.Zڟ?~m[aAwnECjڶQE-8glXݺ:6ڧ!	|VҘapqkڵWnc^҄-YNBz+rq^A6mjڊu2eNbBڡVպQhhtHI/uڛCk#kZfkvС

	0'`NfZ*Emڵ1ګcFbaڴ8
4ڧؒڷEHUڪ/_=<cԠڔJI[ڄysګtکzffwڻ3#DDDDC!      ھM<8ھھڛ5VچpڟOq\%Udڽ|bJ>{Ǒ4?W5sںsڥ$Rړ˘ڱgg`1vBfmWuUe)ګFRR=rt /Fnڙ͌L6ڐjڸڬT! ڄ#>U4ڥtYSXڨBTuG;ڪiIڭsڼbD~Oڍ6ڛfUVZBذ<;ڽ^ڛ9ڣmgڔMEjյڸ$~?Bڻ&2bکiR[JFfڕ)ip %ЗEWUsڪc%&1rڵ[UڍV6iUlSބk<ڼsË!ʪڭ* ځwfwwڻw"3DD3"             ھU4ھھڻuei]\Sb@TUUڽwIg'ڃ}秗ڼ
ڗURw^tdǧڦ31gz}}UIڕΈIe@aau: &ڏ4~OU[ZFnm>>JrS^ڃUU)1wI\ڙ}}ګU!_
ATdRf799HUUgwmcNڍiښ<)%URڈ!i&#Oޭ//UVGwھwmc޽چb` NU[fXɖ>=ÈtO%%UVHډ͌Unڿsstں\U[kXTDY㪙ڪt4VwvS      4Mھ8B;vլ2M"zMe5);Gڋqn6Fwڻ0|?6[wllmڍ|ZڻWfli/x4R%jjZQ
! im\ڭȦqjXںRg D8&JPs㦾eLBڀJA-ڗfu[a0+d^<)w=
4dLYI#'eG=ڣq8ڐd<&Rhjڽb`=څ'\ݝ%Dx:GFڕѼKQA&el-cX}8Cx̈ں"<LU*y^Xa+t5D\pϧulڀ0 T+wڈwݳ!#4D2     ھeړU_ھھn+hm{^ `:0+\,LAڠqd/{{MkiڒS[Eڕ~`0QTKGxWFIHMpYhZ"bYv˲uր5hv%UUڥO%1LQQQڊRjaڥډ33Cacژhh@Caچ]Q;_ڈd1:Nڪ+Opɓ."x&0QyEh>-yxL%Րd99@1ڼR;S(LljnyB! rrkOd=l-^ڹR00?ړߊP5H)av]a`	 KoVxcY
 dڣfwwwwD33!      ھM0,ھ~ڃAid{څvڽjfds++]\t<^3|Kڰc[6ڒC<\saZڱ.\GAw45mXڂXPڞ^_ڞxl5NO^>ڷ5\{֬yڇl8s3333i=		u*T#Џ=UڵjjZW+ږwwOXںB*[&L|}uto&.ANdڜɗ_zpέ*663Dp31jwvtrOPC hϣ< [\=]:ښZ-JGڽ{9Zb3&::5ڔ*ssGړ
WRtfwwwwU"  "3!      ھ]4ھ
ڑڡvvj
G#ڍIUdڻv1C8gW_6ڪ:_ڿnnڏjjEڒXKn}[mհڹG)ڑ=*%B8hMm)Rۛکڦڐh!ڠsږkFګkqqq۳ڲpnvJ4TIEegY_Kڈ. cC%VݛRڣ{}
;;]p |%8!"mj~~BAi4ڊX)8VIvtڢCBtڥ;u[ڶlXrrff}>_`g)QJUJ*ծ.CCGn1qnںSqMڇ2-I wwڈxfU̻D               ھ}I#Mڦwxt9X,`Fzڇڪҷ7Je1X|U|UT)99i6o<F5=ꪴ26+^//B?ڻUUUnnڜL^/+<q@zګcc|Hn}^NDsڕUUcڣںuګުڪt3d3CI]Rږa&% UUWGGB[ڛh$g[_*3CC@rKY116m]B]%UUV:9ta	VڴP'%"RJڱήڴ*
ڄzLLuOB{{UUU D	ڪ23DD!     ھڊ#MAھھp75fڭ"ڊ@s?@oڅdڪ"Pښ3FSڜIʆ<Y4>sb(Jڐ:H	 Q '$ڜ%71KړFX+_ngo
s)"HXV-څUDڑw|Mo ڵڔ)ڪi8G[ڎlT(4[Et**ډ|qڼnl9Ky=;&{ښ.^,ڡhB	P8rHIڛ3ڎπ07qڼԲlU+qoڠq0j~vBZUq`؃A"<  bڏ
^ա9;`dd7ڠAq.r Tڙڈfn!""     ھ0 ھaڸN.Ł`_/^.kڂ:cǑږX!]mm|Cڛf٥id9cQڦlPjbA`ڃ%IJڷJ#55cmeځgA#l*JMڑR8g685jھ>Oq9C`MVZyt'ʏVګlK#fm-~,>>fھ}
UD׫ dڄ!
ځe{
7ښ*ۋ9P#ڮl:Aڶi=Ižx<wڴm'I{ڎI2b !jr9DRk
5qxڻfƭ[i dwڈwUDgݻ1        ھ4ԒھnnMڝѬ֋E$}g
0E] ś8#ee`ڣ_/lapڸ86Yc'O4,np:]/}FM4!#Md[;9#r9zMڹڧ#~W䪧'JOն|+Uڽ{gڜs63jVFcCڢ/vvydJڲt*hl|ڄO=Ummwso7$ 1~O%4Kګt<^.dھ^]o{Z	h_`s9hasU\P*ڀ9gڳlڶ00E4<
Ptھ3fwwwUDDw          ھھEMqϾQ::s9rڹcaξu|ڿnkuڼ a abbږK+feھ]ut44q1ڮ0.PXڪTW.\ڜUcK3jjږXkok{Zj
Ԩuq(\[,ҍlzڧ `V\
A ڍq'>ڮCHHH$J{ڸ
l{gڣEڅBq8HG]ڭ^P::*/110E"\LE?=\^]Z4uuLڒǳ~}e* `ښzjllR(~I)2IJP	LXP Cfwwwwf33U"                  ھھM4y
N'U`Uw);$쁌[Rڒ`8UiO=<zbƞڝսھ^^`ڏ>o}HJJ:9Nڈ}@cS>66zyݨԇ:fڈqW_Xr"!^]u: ww}VځPڛvڶrJ$Lw_J2Qvڱ?ڧgfLڈw};Aە)>>bb[-o7ڗǈw}S4Aڢ$rڵ`0ww}V rڥ>>@_/XbDw}[ a ڍ
ڵZ~\ٳڈw}_`36 Dpڪvm2!     ھ0ښھ$eڷy/(گ3+oڀ7jھo
ځQ?@8y	c
n^?%S^׶ $d,̛ڕ?E
BE9hڱ3D{ڮu̝ړFڪeڦn>PC-X#zUڶyE(ڳ<Nڋ4{K6:[Bhi_,xؙ9uUڃ`m",;Xڏ:&63ݨ<ԊAX+`c9&
>ni{5Fy7гW,;}ڜ"iXJڶL
ڽuw@	{ڨI[y/C(e$?De4Fڳ쵖ڳz2Y%_aڋh3	X TڢňڙڙtFA      ھھ4MھGeuڰ)bX~JZb=XJAwIiw DځaC|X:zڒ$q܌FژG)Wڜg.8ڲ,fs:iگm)+y<2ڡhfVy.{=fqڬFC!"
.ڒ䷕%d2n/چt]5z޷Ű,幃AJ=h$ڎǍy|cWcXzھ~Nڕx`p89iGγTڝ^/ڣsZi՟'~ډv]5v2ژ}t:"Q'8gYցڠjaڛڪ@[u|5|gډe
̃ 8 dڱwwڈڈfD33        ھ]sU_aauuڄB"FF;GJQK #kk
4&S3kBLڇڟg`ڰUڝNAiDڡ˕
&etʚMK%PjڊF.3+Hک98uXI<y<tfڞODDE"ڎ7e1oX{ګnn
	f3+L&[-LZf(sslڌcڵgsyڼz=3[cM[ڊ?vRڧSe
'5UW9"<;YG76.};w3?ĸڠ k5~6ڶ! vpmJe1x[cZڮ0`0tgfwwwwxwwU3"3ڻ"        ھھ瓎0,JI:;55	q	({S03n͵GMG-%U%"XEmډûڬ3$ڱM4jҤ??

11ww{{ڞuVfOշگ_bgg_QJګ"Al16܄ڔʎڢ$WxڔB,Jڞڂppڅ@LL"D&Rd\ۇڒڵQIڗ$wnjtRR"!UUm
ګ۪:wK=ھ>D()ic!%w)bڹJ\ڻdc,|M]##33ڃ(" p` =ffwwwwwfU4" wڻ                ھھyEdڊrrllږj8
ڛhKJ쒓y[QQQ@ځ}}jiמڶ06Çr䔕ml
UTllxm^ژߛ~Rڷ))ډchxy&ڙXG8C>30pkڮPO߬B@"-=9!W^ڽuׂJߛ&Mں:?FAn1c6FګaðڰڄZZڐ&YYͫZw.=z)(<Q+XUUڸ8&JJڝBډa4LݻڣSTڄ44,ڲI_뺻ځ5 D}ڪڨdFr     ھھM3ڢ}_[rYuڷ$kHH#[|S훷$qJ)<Ǚ2iSLkھ@PڕravPJ	-%qLySQچOq9:1kK\ڷX;Ƕ[euqڋZӱڴiIBP5ږQ"ڐ^IfԈ5ڦEڐI^'ډf¸]C :ڱ3%uXVKqFژPfڐ9n	9ڵj5
t.څ*ViV;رWڸxFگK%IO	Eڌ.p1ڍbiƍ^/V7W*ڮZ5k/IڤI)Z;N'	ں'D}ګŌqھ1Alڨgڠ3P TڦiڈڙB"}       ھھﾆ<ھd2M'phjڨ|څsoJ].A fi̳7ڳwcu4~TڏܮX4v(Iu!hZ
ڨsI7+=}HڑtgbXڜY8Gڽ3a00&ڟw{څB0c x(Mpm6d9pڏH4ަ/څh4XD!fbH͕r.oڛbtbrڜz]ڧiO(;`8em6g{bڢ9Z&Vښ6{ڧ+چ"ګZfڙ(`1ڂAs:ښڽoCjmaIC!t:"ڶ

y er dwwwڈwwfD"*       ھھU4$ڛ``ڭZ=#yybba"RPPLtAY21QN5ڭh~
-y<ڥ"ڒrr:9˘BE5E/TKc/wBHH<xګifڷTڪ oڷu#P>HtJ$R(ڬ|bTפڤS('Pbڪ2ڜWMK;<ڣipldcڲK'u#yyڃAlڸqwwmcrKmo/0r3YڭMSڒ1ڣs,A&%Bگ]-ڽņEڎK]8ڿ?XSyTkJ2d֤tgvwwwwwf3" 3      ھھ蘒;\ܻӶ~©TBJL쬯T&L8ĉ3"&CEF ڐ>	/0 ;ڶERoo%$-,,ddl*sdͿDڮV''
3jڳ0wo/1W+"ڑHH%%EڣNc23uȤM-.op ;kQڃ#"ڟχ]\ڄ׮<]ڶ&z<4Cr{"ڕ>h88444ڥK2ڮ|*}{ڢld=ڞҲ퍏߳6ڽ9Mڎ
d,cۛڜq
W >vfwwwwwffU3   U             ھھUL1VڃCC-,qq'&(MO;ڵ6I%ڍBB
55d+WcߠڠTSګsrړVڮ2ڔNDڏrIJxwp߿ueu ~^\Xګډ)0`Ŋn>}z4_ ک^ھڬy8ڮE11KK**:ڲdڪs,50UUڄbbll۹wU2AX={MMA@f@ڬF#sFƃ22&&JIʊډ.]uWڻ_ieonڥK##cb:;Ɏ\4B6hڈ('Rڜڵ`P"|ODVڙڙuC"^     ھھڶM4޺[V:4&NچRaӁڀTzr3xm)ڱ}^~9'-sڜ<cl2
k[Wbhp9Y?,ږ YڸC`mARڔژS	Gڦx^%ڦ3atڝctF	:V/#1Xͳڣ!s}ښ}eښ^[G;Fk{}:aڌ(y!ڨ6\ھOڔ%
ZږQ)lɡMڵ</ڙ[5um~[k{E:r@ub(RAڅ!Goں{+ڋs|&b[xڠHhڭۛ{XA Tڬwڈڈd!)     ھھaaeeW+ڟOݴn7M*ڝNFm
V \\VhD!ړٌaxھ,DHFDEwKA Hrgڊ'+sڹ~Tj4ڼ=ӚھIT%n7$Cܮ]]b#}>w>ڠ1\}gmp<bQ(D!ԞaڭjqڝVքBwڳa0p8GKҷUղڒhT)7y<w#ڞvڭ]ڳb"ڍE
_/cQځF,ځYnڷTHrw0JRmE}~u:ڍFPڥb#t:*ڔZ dھifwwwwwfU3!       ھھM4ܲPڡ]^5sڹچxwNڝ!fQq"Hȼ</WA##98$DE$ɮIک78
i\]]kږgN={hs9ts;<<_ڶacp8Z'}}xxN(Rg>{SSl;]ڴLIRڶګY*hr(]]\\ڎG+ڑکfc»ΎzY-6>ھ½zړ-gڣڶ>=`ڕڦͣ.֮Wn\ڴ9.fN&CBxxٳ%
Dڙɬ֥RBږ@ڹIڵk
; lkXگ`tffwwwwwwffUD"  ڀ     ھھ0׋ɹ'&FIcFڒHAtڿں;;vM3Zڹڧ?ڽ"!wnzRIQ,8q))33

?>QP͜HȮ'00+nn}}~~llTTvڨasUiRXگ/;;6E;ںu3M&6$F$[]ڝڝcnr\#ڳVpt400//2rsfÇMkjxtۺjgYXډjڻ9%_|F˖ݭڤkkV`ڼڰ)X
BBuv..ņ͝v1Hӝѵk[ZKK.[=J6g ڹwUfffgwffffD"               ھھ84Mڢ|*TڽĈٴ.ݵ*ډ!%3fjV EڊծI^vڭIhڞUbDztProڟBڲTڊ5˸0dڄ-ӦڳcUx+uM9 @!|$$Oڻvڤ/eڬC.\8qڣcڳ
Dډӧ2U_CܹbډӪ:h
dڅ)$_VLA|Hڧύ|:REV۷NVlz43jhB*^ڶ(ODڽӧڏ>lٌUڰ6 8ک
\ڸpҲڭZjլ8pڃjIP@cڇ٢DFڎD_>k[Uy< Dڹ߈ڙڙS!(     ھھ4#ڑ (ڃpEڀܘJڦ/v1melQjHڹ|xRkZiڷjrڳYj2z}#7FD6ډ: G~9xnڅZTڧ)sN`3ڌC%

wjwc&;
#Dh^Ey9*~B&Fs:Q(xR(cYїj0ay[)K%a6MuoJc\_7֊ڸ$ڀ$d'~گiڦ.JLwڷsэiڮk71eZV*3F'j"q=ڔ!|4%aو%Aڊ7eN@ T~wwڈڈwuC! 0    ھھڎ0ʪڋ}}ڝ1C"C!yk
maڈ}0t]Ē'Wwګ5D!qq1wu+]ځk5څeJw"koڇ\\rrza$U*A fIgOڥ׊E#(&}<]\swGGmڒI"	٥ڦou!ba	H 0 ڊ7"ڳr6{{ڌG#ڤR%Jڦ3d\&؟p\=\` ,w;	ڊEL(3Q<SږRD~?.vE?yr
nn6
}>]Z3څ9ڣc%͈ d.fwwwwwwwwffD2  \    ھھ0~ڡUVVUfeډƍjP JEQQMMMͻ;,E6mڤOыjeک	IGڏ'Nkal5k
MM ڳڵ*xX㣝]bbbڟ_a!2ګVsh2HLLڔssssڅ,+ThڑZ4ee__[[||yykk~~T\ڸ"DxQMڔ4*JP00АZk2_ߙ2feډabnn^]ڻyEkae"9ڹD224ڴOYY@e$ 4I6LwwGK;9ډihPڤɜگԲڻv	33ML#ڷt׈tffgwwwwfffUD3"       ھھM3MYڗ'&AA&Kb["@گ80_>%%4sfڬڻ76ړ&''!!4bڜd7ϩRrEE



	&Qc2ڝظPڪՑ%76ߤ("ڡ9RJڰZ2Zڻڹ0ڏڙ1b ڶڑ&͑"MM
ĹqbڏĺTڠ)ccխ*Lڙ&!گ6%z	ڌx8!U"!L ڨ+׫<2گѤɝ<GG,Hڒd[Ǖ` wUffffffffUUD#       "ڪw        ھھﾞsMQH h!Bڏۺ4[6}(ڮ#ڻHXږ|hټy3m"!v*)کQ4-۵ji*yO8fȑ.\ڹt4کM$ڌ0&Tocc&l޽t<yfnڋ mڸ*Рѣװ`رq͕{OFb,Yn2i"hцv1lڭ{(1bڬfڪTxE4[ulڠag^l.Z4\Dڈ!ڎ5|ڟddQD"={J6l+ޕ[CiYYE pRڥ rN]ڡ	
D@ڀ59rE9ڥVYګ22 D
sڙڙT2 p   ھھ4]n_wޒڙVU{~+U:gګU+ʉuڥhbڛ)ڬ!,-A_r8.ڌ(vwvU%ڎWɯڋ<گ+ڽKv5Bkx	$ڮ)L?o{M&ɭsi.ګ.ڷ[Yio[ ژ)<," kڵRڻGti#vۂXvڤ^FXQ K/fYV=<O)jڡ"n"'v~pe\N(gl.ڼ:eډڄ-i4
EC2HfvqPvmڬP TswwڈڈwvT"  ;   ھھڪ0Mڌډڅ/cn	$wacN'HڬHږJBCpڒ|ڇ
Y3BB#`v)g3%kڦn>H΃mmC_/p\ڷwڡmڠp6EьFL'%&Luت	ڹifڋEo7FEo~]mRRYQ&i獍C.g>ג6jj+ڕhڴ_ڎYM@,LڛDۍMqmy>Zq8t`P)ڙ.ڀT^*{}ډ*)TAڢQ&#/ځw`NڀE dڶCffwwwwwwfffUC!   ڦ   ھھYcaچ,XXggگYYddOOڟ>4e˛n*ڒ,V͢!⢗ڗFn 4z?LGGڊ*)hfڝl8	ToٳڥIڹg.Y2&Lڿ%%ڜss{{^^nޭX*3l۵ڗ!ڝ((P~۶6@Xڙxyɩڳff͖fڌ0r"!BB21)2`@}<aޛ^ddtt[[^7}ڣD]Xژe]ڝZ\ڜPF)ڛ5ot<x֖ژxzzzZXnUV~ԩڜ8xڅzy]]ړ'Ni_7 tڜ0fgwwwwwwfffU3"        ھھM<.`@ڸ711KKDD..Fڌ4(QDw	F+kp0+KNڪ,7o40"څcc{{ڋTSkk.,ڳ-%ڈ&r99==-- εmqb+ڻkڙR;+6600[[88L͜8pڑ˒`˗+,ڸT.dsrSfwuI*pb33ɏ߶#kSڀej@I::G`5A=zڬ_ڊT0p00po/7QP`ƍJ0ڶf{zڂ,,کLXo$
ڪڽ''550ڶK0P ,UUfffffUUUUD3"         UU     ھھ4Uwڑ!BәpTQڦwmD
}arjړ+vz4I:wqږfZڸ4vW^VZbڊ})r<dBnn\vՖAڀiڧn$Gnj 8ifc#}Q]wϜ8ڏ8 \ڸ\( ڒHan݋n:X}ڢ1fm^x]چ0|ڇmEyaYڡAϟ>EyEywm_~a0u㢈0YUl~"Rv_ڥUHb<zt޽t8qڭfH,ڹe)&LYYf&fQ!E D홈ڙڙuC!    ھھu4M=mWڅ]sJ
sQrG9t]kY pu-%1ڪ$Gڸd2
}g[dnNkC+*XNڋxbs3ڍ!19ݼz޷|d5 ڭ+V*Oڢ9ھXVڝ$w
9ͤr0SڪkIڸb=H
ڒ!2L1:ՊڄX9ڼޥR@Pb{Ͷ*KV*V~lڶ WUׁڐ|*Fڍ4!c\E\WojڗڲS4J#!ڪِ{FmX	ڮkd-Ĳ7
ZڂA_شڬF٫U, 
