# NAME

jacode.pl - Perl program for Japanese character code conversion

# v

## gp@

```
require 'jacode.pl';
```

pbP[W jacode ł jcode łǂłpł܂B

```
jacode::convert(\$line, $OUTPUT_encoding [, $INPUT_encoding [, $option [, $INPUT_encoding_suggestion]]])
jacode::xxx2yyy(\$line [, $option])
jacode::to($OUTPUT_encoding, $line [, $INPUT_encoding [, $option [, $INPUT_encoding_suggestion]]])
jacode::jis($line [, $INPUT_encoding [, $option [, $INPUT_encoding_suggestion]]])
jacode::euc($line [, $INPUT_encoding [, $option [, $INPUT_encoding_suggestion]]])
jacode::sjis($line [, $INPUT_encoding [, $option [, $INPUT_encoding_suggestion]]])
jacode::utf8($line [, $INPUT_encoding [, $option [, $INPUT_encoding_suggestion]]])
jacode::jis_inout($JIS_Kanji_IN, $ASCII_IN)
jacode::get_inout($line)
jacode::cache()
jacode::nocache()
jacode::flushcache()
jacode::flush()
jacode::h2z_xxx(\$line)
jacode::z2h_xxx(\$line)
jacode::getcode(\$line)
jacode::getcode2(\$line [, $encoding_suggestion])
jacode::tr(\$line, $from, $to [, $option])
jacode::trans($line, $from, $to [, $option])
jacode::init()
$jacode::convf{'xxx', 'yyy'}
$jacode::z2hf{'xxx'}
$jacode::h2zf{'xxx'}
```

# Tv

 "jacode.pl" ͕̕ϊs߂̃\tgEFAłB̑a
̍쐬ꂽ "jcode.pl"  "pkf" ƂɂčĂÃ\tg
EFAX[YɈڍsł悤lĂ܂B

Perl CuƂėp "jcode.pl" ̂悤ɁAR}hCvO
Ƃėp "pkf" ̂悤ɋ@\܂BR}hCIvV̐
IvVɎs邱ƂŎQƂł܂B

 jacode.pl P̂ JISAVtgJISAEUC-JPAUTF-8 ƂłAEncode
W[płł jacode.pl  Encode W[Ăяo
ƂɂA܂܂ȕ̕ϊsƂł܂B

ȂȀꍇł jcode.pl ̃C^tF[XgƂł̂ŁAȂJ
 jacode.pl ɓEڍs邱Ƃł܂B

## ȓ

* jcode.pl ʌ݊̋@\EvO~OC^tF[X
* pkf R}hʌ݊̋@\Egp@
* Perl4 XNvgłAPerl5 XNvgł
* Encode::from_to ̃bp[Ƃċ@\
* ɓnėp\ȃ\tgEFA
* pJ^JiT|[g
* UTF-8  cp932 ւ̕ϊ͈ȉ̃e[u𗘗p

  http://unicode.org/Public/MAPPINGS/VENDORS/MICSFT/WINDOWS/CP932.TXT
  http://support.microsoft.com/kb/170559/ja
  (JIS X 0221:2007 BASIC JAPANESE and COMMON JAPANESE)

* ̃\tgEFAɂ UTF8 tO͉B
* C^tF[X@IuWFNgw𗘗pĂȂ
* `IȃvO~OZ@𗘗p邱Ƃł

# @

2018N2̎_ł́Aȉ URL  jacode.pl ܂B

  http://search.cpan.org/dist/jacode/

t@C "jacode.pl" 𒼐ڃ_E[hꍇ́At@C POD ̏I
łu=cutvŏIĂ邱ƂmFĂBu=cutvŏI
ĂȂꍇ͂̃t@C͊Sł͂ȂAɓ삵܂B

# CXg[@

t@C̖O "jacode.pl" ƂāAPerl ̓ϐ  @INC Ɋ܂܂邢
ꂩ̃tH_Ɋi[܂Bǂɒu΂悢ꍇAAvP[
VvOƓtH_ɔzuƂ悢ł傤B

# ˑĂ\tgEFA

̃\tgEFA perl 4.036 ͂ȍ~ perl Ŏsł܂B

# Tu[`̌Ăяo@

jacode.pl ̃Tu[` jacode pbP[WɊ܂܂Ă܂B܂
jcode.pl Ƃ̌݊mۂړI jcode pbP[Wɂ܂܂ĂA
ǂ̃pbP[Włpł悤ɂȂĂ܂Bȉ̐ł
pbP[W jacode ƂĂ܂B

# gpĂ perl C^v^ Perl5 ̏ꍇ

Tu[`̑O jacode:: t܂BႦ convert() ̏ꍇ

jacode::convert(...);

̂悤ɂČĂяo܂B

# jcode.pl Ƃ̌݊lKvꍇ

jcode.pl 𗘗pč쐬ꂽvOێ炷AȂǂ̖ړI jcode.pl
̃C^tF[X𗘗pꍇAȉ̂悤 jcode pbP[WŃTu[
`𗘗p邱Ƃł܂B

&jcode'convert(...);

# Tu[`

## jacode::convert

Cӂ̕ɕϊ

### 

```
jacode::convert(\$line, $OUTPUT_encoding [, $INPUT_encoding [, $option [, $INPUT_encoding_suggestion]]])
```

###  \\$line

ϊXJ[ϐ $line Ɋi[Ãt@Xɂ܂B
z̗vf̃t@XnbV̗vf̃t@Xw肷邱Ƃł
B̃t@XɂC^tF[X͓IɖpȃRs[Ȃ
ړIƂĂ܂BTu[`sA$line ̓e͏܂B

###  $OUTPUT_encoding

ϊ̕w肵܂B
̃\tgEFAP̂ŕϊł镄͈ȉ̂ƂłB

* 'jis' JISR[h
* 'sjis' VtgJISR[h
* 'euc' EUC-JP R[h
* 'utf8' UTF-8 R[h
* 'noconv' ϊsȂꍇ

LȊO̕w肵ꍇ́AEncode W[płł
 Encode::from_to() Ăяo܂B

###  $INPUT_encoding

ϊO̕w肵܂B̈ jcode.pl ƌ݊ۂ߂ɏȗ
\ƂȂĂ܂A܂ȗׂł͂܂Bȗɂ
jacode::getcode() ŌĂяoAϊO̕܂B̐
͊ԈႦꍇ܂B

̃\tgEFAP̂ŕϊł镄͈ȉ̂ƂłB

* 'jis' JISR[h
* 'sjis' VtgJISR[h
* 'euc' EUC-JP R[h
* 'utf8' UTF-8 R[h

LȊO̕w肵ꍇ́AEncode W[płł
 Encode::from_to() Ăяo܂B

###  $option

pJ^Ji̕ϊ̃IvVw肵܂B̈͏ȗ\łB

* 'z' $line Ɋ܂܂锼pJ^JiSpJ^Jiɕϊ܂(zenkaku)B
* 'h' $line Ɋ܂܂SpJ^Ji𔼊pJ^Jiɕϊ܂(hankaku)B

### @\

w肵ɕϊ

̊֐ $line Ɋi[Ă镶 $OUTPUT_encoding Ŏw肵
ɕϊ܂B

### ߂l(XJ[ReLXg̏ꍇ)

$line ̕ϊ̕Ԃ܂B

### ߂l(XgReLXg̏ꍇ)

* 1vf ϊTu[`ւ̃t@X
* 2vf $line ̕ϊ̕

### ⑫

̃Tu[`쐬ꂽA͔ɋMd߁AϊÕ
ƕϊ͓̗̃̈𗘗pĂ܂BϊIƕϊO̕
͂ȂȂ܂B܂ϊO͎̕s悤ɂȂĂ
߁Aȗ\Ȃ悤ɍ쐬ĂÂ߈̏A

$OUTPUT_encoding ̎ $INPUT_encoding

ƂȂĂ܂B

## jacode::xxx2yyy

 xxx   yyy ɕϊ

### 

xxx  yyy ɂ jis, euc, sjis, utf8 ̂ꂩASňȉ 16
̃Tu[`܂B

```
jacode::euc2euc(\$line [, $option])
jacode::euc2jis(\$line [, $option])
jacode::euc2sjis(\$line [, $option])
jacode::jis2jis(\$line [, $option])
jacode::jis2euc(\$line [, $option])
jacode::jis2sjis(\$line [, $option])
jacode::sjis2sjis(\$line [, $option])
jacode::sjis2euc(\$line [, $option])
jacode::sjis2jis(\$line [, $option])
jacode::utf82utf8(\$line [, $option])
jacode::utf82jis(\$line [, $option])
jacode::utf82euc(\$line [, $option])
jacode::utf82sjis(\$line [, $option])
jacode::jis2utf8(\$line [, $option])
jacode::euc2utf8(\$line [, $option])
jacode::sjis2utf8(\$line [, $option])
```

###  \\$line

ϊXJ[ϐ $line Ɋi[Ãt@Xɂ܂B
z̗vf̃t@XnbV̗vf̃t@Xw肷邱Ƃł܂B
Tu[`sA$line ̓e͏܂B

###  $option

pJ^Ji̕ϊ̃IvVw肵܂B̈͏ȗ\łB

* 'z' $line Ɋ܂܂锼pJ^JiSpJ^Jiɕϊ܂(zenkaku)B
* 'h' $line Ɋ܂܂SpJ^Ji𔼊pJ^Jiɕϊ܂(hankaku)B

### @\

$line Ɋi[ĂA xxx ̕𕄍 yyy ɕϊ܂B
̃Tu[`̌Ăяoɂĕϐ $line ̓e܂B

### ߂l

ߋ̎ɂẮAϊɐ悻̕ԂAƂĂƂ
܂B̏ꍇAϊłȂꍇ 0 Ԃ܂BȂAɂĂ
ł͂ȂoCgԂAƋLqĂ܂B

## jacode::to

ϊ̕Ԃ

### 

```
jacode::to($OUTPUT_encoding, $line [, $INPUT_encoding [, $option [, $INPUT_encoding_suggestion]]])
```

###  $OUTPUT_encoding

ϊ̕w肵܂B

###  $line

ϊXJ[ϐ $line Ɋi[܂B

###  $INPUT_encoding

ϊO̕w肵܂B̈ jcode.pl ƌ݊ۂ߂ɏȗ
\ƂȂĂ܂A܂ȗׂł͂܂Bȗɂ
jacode::getcode() ŌĂяoAϊO̕܂B̐
͊ԈႦꍇ܂B

̃\tgEFAP̂ŕϊł镄͈ȉ̂ƂłB

* 'jis' JISR[h
* 'sjis' VtgJISR[h
* 'euc' EUC-JP R[h
* 'utf8' UTF-8 R[h

LȊO̕w肵ꍇ́AEncode W[płł
 Encode::from_to() Ăяo܂B

###  $option

pJ^Ji̕ϊ̃IvVw肵܂B̈͏ȗ\łB

* 'z' $line Ɋ܂܂锼pJ^JiSpJ^Jiɕϊ܂(zenkaku)B
* 'h' $line Ɋ܂܂SpJ^Ji𔼊pJ^Jiɕϊ܂(hankaku)B

### @\

$line Ŏw肵 $OUTPUT_encoding Ŏw肵ɕϊĕԂ
B

Tu[`sA$line ̓e͕ω܂B

### ߂l

ϊ̕łB

### ⑫

̊֐́A call/return-by-value C^[tF[XƂĊȒPɎg܂B
Ⴆ s///e Zqŗp邱Ƃł܂B

## jacode::xxx

 xxx ɕϊ

### 

xxx ɂ jis, euc, sjis, utf8 ̂ꂩ܂B

```
jacode::jis($line [, $INPUT_encoding [, $option [, $INPUT_encoding_suggestion]]])
jacode::euc($line [, $INPUT_encoding [, $option [, $INPUT_encoding_suggestion]]])
jacode::sjis($line [, $INPUT_encoding [, $option [, $INPUT_encoding_suggestion]]])
jacode::utf8($line [, $INPUT_encoding [, $option [, $INPUT_encoding_suggestion]]])
```

###  $line

ϊXJ[ϐ $line Ɋi[܂B

###  $INPUT_encoding

ϊO̕w肵܂B̈ jcode.pl ƌ݊ۂ߂ɏȗ
\ƂȂĂ܂A܂ȗׂł͂܂Bȗɂ
jacode::getcode() ŌĂяoAϊO̕܂B̐
͊ԈႦꍇ܂B

̃\tgEFAP̂ŕϊł镄͈ȉ̂ƂłB

* 'jis' JISR[h
* 'sjis' VtgJISR[h
* 'euc' EUC-JP R[h
* 'utf8' UTF-8 R[h

LȊO̕w肵ꍇ́AEncode W[płł
 Encode::from_to() Ăяo܂B

###  $option

pJ^Ji̕ϊ̃IvVw肵܂B̈͏ȗ\łB

* 'z' $line Ɋ܂܂锼pJ^JiSpJ^Jiɕϊ܂(zenkaku)B
* 'h' $line Ɋ܂܂SpJ^Ji𔼊pJ^Jiɕϊ܂(hankaku)B

### @\

$line Ŏw肵A $INPUT_encoding Tu[`Ŏw
镄ɕϊA̕Ԃ܂B

Tu[`sA$line ̓e͕ω܂B

### ߂l

ϊ̕Ԃ܂B

## jacode::jis_inout

### 

```
jacode::jis_inout($JIS_Kanji_IN, $ASCII_IN)
```

GXP[vV[PX̕ύX

###  $JIS_Kanji_IN

2oCgւ̃GXP[vV[PXw肵܂B

###  $ASCII_IN

1oCgւ̃GXP[vV[PXw肵܂B

### @\

jacode::jis_inout() ́AJIS R[hŗpGXP[vV[PXύXAύX
̒lԂ܂B$JIS_Kanji_IN ɂ́A2oCgւ̃GXP[vV[PXA
$ASCII_IN ɂ́APoCgւ̃GXP[vV[PXw肵܂Bjacode.pl 
ftHgł́A$JIS_Kanji_IN ɂ JIS X 0208-1983(VJIS83)̊Jn
"1Bh 24h 42h"  3 oCgA$ASCII_IN ɂ ASCII ̊Jn
"1Bh 28h 42h"  3 oCgꂼwꂽԂƂȂĂ܂B
jacode::jis_inout() ͕KvɉĂύXł܂B

ȂA͏ȗ` 1 oCgŎw肷邱Ƃł܂B

* ESC-$-@ JIS C 6226-1978 ̏ꍇ(ȗ`́u@v)
* ESC-$-B JIS X 0208-1983 ̏ꍇ(ȗ`́uBv)
* ESC-&-@-ESC-$-B JIS X 0208-1990 ̏ꍇ(ȗ`́u&v)
* ESC-$-(-O JIS X 0213:2000 ʂ̏ꍇ(ȗ`́uO(I[)v)
* ESC-$-(-Q JIS X 0213:2004 ʂ̏ꍇ(ȗ`́uQv)

### ߂l

ύX̃GXP[vV[PX̃Xg ($JIS_Kanji_IN, $ASCII_IN) Ԃ܂B

## jacode::get_inout

JIS 񂩂AGXP[vV[PX擾

### 

```
jacode::get_inout($line)
```

###  $line

GXP[vV[PX𒲂ׂXJ[ϐ $line Ɋi[܂B

### @\

$line A jacode::jis_inout() ɂĐݒ肳ĂGXP[vV[P
X̃oCgTāA΂̃GXP[vV[PXԂAȂ
 undef Ԃ܂B

### ߂l

jacode::jis_inout() ƓlɁA($JIS_Kanji_IN, $ASCII_IN) ̌`łB 

* ESC-$-@ JIS C 6226-1978 ̏ꍇ
* ESC-$-B JIS X 0208-1983 ̏ꍇ
* ESC-&-@-ESC-$-B JIS X 0208-1990 ̏ꍇ
* ESC-$-(-O JIS X 0213:2000 ʂ̏ꍇ
* ESC-$-(-Q JIS X 0213:2004 ʂ̏ꍇ

## jacode::h2z_xxx

pJ^JiSpJ^Jiɕϊ

### 

xxx ɂ jis, euc, sjis, utf8 ̂ꂩ܂B

```
jacode::h2z_jis(\$line)
jacode::h2z_euc(\$line)
jacode::h2z_sjis(\$line)
jacode::h2z_utf8(\$line)
```

###  \\$line

ϊXJ[ϐ $line Ɋi[Ãt@Xɂ܂B
z̗vf̃t@XnbV̗vf̃t@Xw肷邱Ƃł܂B
Tu[`sA$line ̓e͏܂B

### @\

$line Ŏw肵Ɋ܂܂锼pJ^JiSpJ^Jiɕϊ܂B
xxx ɂ͕Ƃ jis, euc, sjis, utf8 ̂ꂩ܂B
̃Tu[`sA$line ̓eς܂B

### ߂l

ߋ̎ɂẮAϊɐ悻̕ԂAƂĂƂ
܂B̏ꍇAϊłȂꍇ 0 Ԃ܂B

## jacode::z2h_xxx

SpJ^Ji𔼊pJ^Jiɕϊ

### 

xxx ɂ jis, euc, sjis, utf8 ̂ꂩ܂B

```
jacode::z2h_jis(\$line)
jacode::z2h_euc(\$line)
jacode::z2h_sjis(\$line)
jacode::z2h_utf8(\$line)
```

###  \\$line

ϊXJ[ϐ $line Ɋi[Ãt@Xɂ܂B
z̗vf̃t@XnbV̗vf̃t@Xw肷邱Ƃł܂B
Tu[`sA$line ̓e͏܂B

### @\

$line Ŏw肵Ɋ܂܂SpJ^Ji𔼊pJ^Jiɕϊ܂B
xxx ɂ͕Ƃ jis, euc, sjis, utf8 ̂ꂩ܂B
̃Tu[`sA$line ̓eς܂B

### ߂l

ߋ̎ɂẮAϊɐ悻̕ԂAƂĂƂ
܂B̏ꍇAϊłȂꍇ 0 Ԃ܂B

## jacode::getcode

̕𐄑ĕԂ

### 

```
jacode::getcode(\$line)
```

𒲂ׂ

###  \\$line

𒲂ׂXJ[ϐ $line Ɋi[Ãt@X
ɂ܂Bz̗vf̃t@XnbV̗vf̃t@Xw肷邱
ł܂B

### @\

̃Tu[`́A$line ŗ^ꂽ̕𐄑ĕԂ܂B

### ߂l(XJ[ReLXg̏ꍇ)

ȉ̂ЂƂԂ܂B

* 'jis' $line  JIS Ɛ
* 'sjis' $line  VtgJIS Ɛ
* 'euc' $line  EUC-JP Ɛ
* 'utf8' $line  UTF-8 Ɛ
* 'binary' $line ͔񕶎܂
* undef L̂łȂ

### ߂l(XgReLXg̏ꍇ)

ȉ2̒l߂lɂȂ܂B

* 1̗vf

Ƃė^ꂽ񒆁ÃTu[`fɊY
oCg(uvƏꂽ݂邪AoCg)

* 2̗vf

̃Tu[`f

### 

```
#        .........1...
#        1234567890123 oCg
$line = 'ABC';           # $line  EUC-JP R[hƂB
$code = jacode::getcode(\$line);   # $code ɂ́A"euc" B
@code = jacode::getcode(\$line);   # @code ɂ́A(13, "euc") B
```

̃Tu[`͔pJ^JiAтɑ镄oꍇł
Ƃ͂ȂȂΏۂƂ܂B

jacode.pl  jcode.pl Ƃ͈قȂAUTF-8 T|[gĂ邽߂
jacode::getcode() ̖߂l̐m͒ႭȂĂ܂B
̂߁ÃTu[`̗p͂͂␄Ă܂B

## jacode::getcode2

̕𐄑ĕԂ

### 

```
jacode::getcode2(\$line [, $encoding_suggestion])
```

𒲂ׂ

###  \\$line

𒲂ׂXJ[ϐ $line Ɋi[Ãt@X
ɂ܂Bz̗vf̃t@XnbV̗vf̃t@Xw肷邱
ł܂B

### @\

̃Tu[`́A$line ŗ^ꂽ̕𐄑ĕԂ܂B

### ߂l(XJ[ReLXg̏ꍇ)

ȉ̂ЂƂԂ܂B

* 'jis' $line  JIS Ɛ
* 'sjis' $line  VtgJIS Ɛ
* 'euc' $line  EUC-JP Ɛ
* 'utf8' $line  UTF-8 Ɛ
* 'binary' $line ͔񕶎܂
* undef L̂łȂ

### ߂l(XgReLXg̏ꍇ)

ȉ2̒l߂lɂȂ܂B

* 1̗vf

Ƃė^ꂽ񒆁ÃTu[`fɊY
oCg(uvƏꂽ݂邪AoCg)

* 2̗vf

̃Tu[`f

### 

```
#        .........1...
#        1234567890123 oCg
$line = 'ABC';           # $line  EUC-JP R[hƂB
$code = jacode::getcode2(\$line);   # $code ɂ́A"euc" B
@code = jacode::getcode2(\$line);   # @code ɂ́A(13, "euc") B
```

̃Tu[`͔pJ^JiAтɑ镄oꍇł
Ƃ͂ȂȂΏۂƂ܂B

jacode.pl  jcode.pl Ƃ͈قȂAUTF-8 T|[gĂ邽߂
jacode::getcode2() ̖߂l̐m͒ႭȂĂ܂B
̂߁ÃTu[`̗p͂͂␄Ă܂B

## jacode::cache

LbVJn

### 

```
jacode::cache()
```

### 

܂B

### @\

jacode.pl ́AZɂĕ̕ϊsꍇ܂BxvZ
ʂ̓nbVɕۑAoꍇɍėp܂Bʏ͂
@\ ON ɂȂĂ̂ŁAON/OFF ؂ւȂ̂łΈӎKv͂
܂B

### ߂l

jacode::cache() ĂяoÕLbV ON/OFF ̏ԂԂ܂B

## jacode::nocache

LbV̒~

### 

```
jacode::nocache()
```

### 

܂B

### @\

jacode.pl pLbV~܂B

### ߂l

jacode::nocache() ĂяoÕLbV ON/OFF ̏ԂԂ܂B

## jacode::flushcache

LbV̏

### 

```
jacode::flushcache()
```

### 

܂B

### @\

jacode.pl ̃LbVɕۑĂe܂B

### ߂l

܂B

## jacode::flush

LbV̏

### 

```
jacode::flush()
```

### 

܂B

### @\

ŃTu[` jacode::flushcache() Ăяo܂B̃Tu[`͌
hLǧ~ړIő݂Ă܂B

### ߂l

܂B

## jacode::tr

perl  tr/// Zq̋@\͕

### 

```
jacode::tr(\$line, $from, $to [,$option])
```

###  \\$line

ϊXJ[ϐ $line Ɋi[Ãt@Xɂ܂B
z̗vf̃t@XnbV̗vf̃t@Xw肷邱Ƃł܂B
Tu[`sA$line ̓e͏܂B

###  $from

ϊϊOׂ̕ċLq܂B

###  $to

 $from ̏ɕϊϊׂ̕ċLq܂B

###  $option

'd' w肵ꍇ tr///d ̋@\͕킵܂B

### @\

̃Tu[` Perl  tr/// Zq̋@\͕킵܂B
jcode.pl  jacode.pl ͕̕ϊړIƂCuȂ̂
tr/// ̖͕͋@\Iɏ\ł͂܂B

$line ̕񒆂 $from Ɋ܂܂Ă镶΁A$to ̑Ή镶ɒu
܂B$line, $from, $to ͈̕vKvAJIS ܂
EUC-JP ݂̂pł܂BȂAJIS X 0212(ʏ́A⏕)͈Ƃł
B

Vtg JIS 邢 UTF-8 ̏ꍇ́Ajacode::convert() ɂĕ
EUC-JP ܂ JIS ɕϊǍ jacode::tr() ̎ssAɂ̌
jacode::convert() ɂČ̕ɖ߂Kv܂B

$fromA $to ɂ "a-z" ̂悤ɔ͈͂w肷邱Ƃł܂B̋L@
K\̕NXɎĂ܂ "[a-z]" ̂悤Ɋpň͂ޕKv͂
B"[", "]" ň͂ނƂ̕ϊΏۂƂĈ܂B

2oCgɂ͈͎w̏ꍇAJnƏÎꂼ̑1oCg̒l
͓łKv܂B

$option ɂ 'd' w肷邱Ƃł܂B'd' w肵ꍇ́A$from Ɋ܂
Ă $to Ɋ܂܂ĂȂ $line ɏoꍇAϊ̕񂩂
菜܂B tr///d ̋@\͕킷邱ƂӐ}Ă܂B

nCtu - vguꍇAnCt͈͎w̍Ōɔzu܂B

```
$line = 'sdkOR|XXXX|XXXX';              # Sp
jacode::tr(\$line, 'O-X`-y-|', '0-9A-Za-z-'); # pɒu
print $line;                                           # "TEL03-9999-9999" ƕ\
```

### ߂l

ϊ̐Ԃ܂B

## jacode::trans

tr/// Zq̋@\͕

### 

```
jacode::trans($line, $from, $to [,$option])
```

###  $line

ϊXJ[ϐ $line Ɋi[Aɂ܂Bz̗vf̃t@
XnbV̗vf̃t@Xw肷邱Ƃł܂B

###  $from

ϊϊOׂ̕ċLq܂B

###  $to

 $from ̏ɕϊϊׂ̕ċLq܂B

###  $option

'd' w肵ꍇ tr///d ̋@\͕킵܂B

### @\

jacode::tr() Ɠl Perl  tr/// ̋@\͕킵܂Bjacode::tr() ƈقȂA
$line ͏ς܂B

### ߂l

ϊ̕Ԃ܂B

## %jacode::convf

ϊ̃Tu[` jacode::xxx2yyy() ̃t@X擾

### 

```
$jacode::convf{'xxx', 'yyy'}
```

### @\

xxx  yyy  jis, euc, sjis, utf8 ̂ꂩw肷 jacode::xxx2yyy()
̃Tu[`̃t@X擾邱Ƃł܂B

## %jacode::h2zf

ϊ̃Tu[` jacode::h2z_xxx() ̃t@X擾

### 

```
$jacode::h2zf{'xxx'}
```

### @\

xxx  jis, euc, sjis, utf8 ̂ꂩw肷 jacode::h2z_xxx() ̃Tu[
`̃t@X擾邱Ƃł܂B

## %jacode::z2hf

ϊ̃Tu[` jacode::z2h_xxx() ̃t@X擾

### 

```
$jacode::z2hf{'xxx'}
```

### @\

xxx  jis, euc, sjis, utf8 ̂ꂩw肷 jacode::z2h_xxx() ̃Tu[
`̃t@X擾邱Ƃł܂B

## jacode::init

ϐ̏s

### 

```
jacode::init()
```

### 

܂B

### @\

jacode pbP[W̕ϐ܂Bjacode.pl  require 'jacode.pl';
ɂėpꍇ́AIɌĂяo܂Bjacode.pl ̓eAvP[
VvO̒ɃRs[Ėߍ񂾏ꍇ́Ajacode ̑̃Tu[`
̌Ăяoɐ旧 jacode::init() sAŗpϐ
Kv܂B

### ߂l

܂B

# 

  Copyright (c) 1992,1993,1994 Kazumasa Utashiro
  Copyright (c) 1995-2000 Kazumasa Utashiro
  Copyright (c) 2002 Kazumasa Utashiro
  Copyright (c) 2010, 2011, 2014, 2015, 2016, 2017, 2018 INABA Hitoshi

# 쌠

IWi "jcode.pl" Ɠŗpł܂BȉɈp܂B

  This software is free software;
  
  Use and redistribution for ANY PURPOSE are granted as long as all
  copyright notices are retained.  Redistribution with modification
  is allowed provided that you make your modified version obviously
  distinguishable from the original one.  THIS SOFTWARE IS PROVIDED
  BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES ARE
  DISCLAIMED.
  
  This software is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

