use 5.10.0;
use strict;
use warnings;

# ABSTRACT: Internal Moose
our $AUTHORITY = 'cpan:CSSON'; # AUTHORITY
our $VERSION = '0.2404';

package Map::Metro::Elk;

use Moose();
use MooseX::AttributeShortcuts();
use MooseX::AttributeDocumented();
use namespace::autoclean();
use Moose::Exporter;

Moose::Exporter->setup_import_methods(also => ['Moose']);

sub init_meta {
    my $class = shift;

    my %params = @_;
    my $for_class = $params{'for_class'};
    Moose->init_meta(@_);
    MooseX::AttributeShortcuts->init_meta(for_class => $for_class);
    MooseX::AttributeDocumented->init_meta(for_class => $for_class);
    namespace::autoclean->import(-cleanee => $for_class, -except => [qw/system_maps found_plugins/]);
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Map::Metro::Elk - Internal Moose

=head1 VERSION

Version 0.2404, released 2016-04-30.

=head1 SOURCE

L<https://github.com/Csson/p5-Map-Metro>

=head1 HOMEPAGE

L<https://metacpan.org/release/Map-Metro>

=head1 AUTHOR

Erik Carlsson <info@code301.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by Erik Carlsson.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
