# Generated by default/object.tt
package Paws::IoTSiteWise::PropertyType;
  use Moose;
  has Attribute => (is => 'ro', isa => 'Paws::IoTSiteWise::Attribute', request_name => 'attribute', traits => ['NameInRequest']);
  has Measurement => (is => 'ro', isa => 'Paws::IoTSiteWise::Measurement', request_name => 'measurement', traits => ['NameInRequest']);
  has Metric => (is => 'ro', isa => 'Paws::IoTSiteWise::Metric', request_name => 'metric', traits => ['NameInRequest']);
  has Transform => (is => 'ro', isa => 'Paws::IoTSiteWise::Transform', request_name => 'transform', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::IoTSiteWise::PropertyType

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::IoTSiteWise::PropertyType object:

  $service_obj->Method(Att1 => { Attribute => $value, ..., Transform => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::IoTSiteWise::PropertyType object:

  $result = $service_obj->Method(...);
  $result->Att1->Attribute

=head1 DESCRIPTION

Contains a property type, which can be one of C<attribute>,
C<measurement>, C<metric>, or C<transform>.

=head1 ATTRIBUTES


=head2 Attribute => L<Paws::IoTSiteWise::Attribute>

Specifies an asset attribute property. An attribute generally contains
static information, such as the serial number of an IIoT
(https://en.wikipedia.org/wiki/Internet_of_things#Industrial_applications)
wind turbine.


=head2 Measurement => L<Paws::IoTSiteWise::Measurement>

Specifies an asset measurement property. A measurement represents a
device's raw sensor data stream, such as timestamped temperature values
or timestamped power values.


=head2 Metric => L<Paws::IoTSiteWise::Metric>

Specifies an asset metric property. A metric contains a mathematical
expression that uses aggregate functions to process all input data
points over a time interval and output a single data point, such as to
calculate the average hourly temperature.


=head2 Transform => L<Paws::IoTSiteWise::Transform>

Specifies an asset transform property. A transform contains a
mathematical expression that maps a property's data points from one
form to another, such as a unit conversion from Celsius to Fahrenheit.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::IoTSiteWise>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

