# Generated by default/object.tt
package Paws::Macie2::Occurrences;
  use Moose;
  has Cells => (is => 'ro', isa => 'ArrayRef[Paws::Macie2::Cell]', request_name => 'cells', traits => ['NameInRequest']);
  has LineRanges => (is => 'ro', isa => 'ArrayRef[Paws::Macie2::Range]', request_name => 'lineRanges', traits => ['NameInRequest']);
  has OffsetRanges => (is => 'ro', isa => 'ArrayRef[Paws::Macie2::Range]', request_name => 'offsetRanges', traits => ['NameInRequest']);
  has Pages => (is => 'ro', isa => 'ArrayRef[Paws::Macie2::Page]', request_name => 'pages', traits => ['NameInRequest']);
  has Records => (is => 'ro', isa => 'ArrayRef[Paws::Macie2::Record]', request_name => 'records', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Macie2::Occurrences

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Macie2::Occurrences object:

  $service_obj->Method(Att1 => { Cells => $value, ..., Records => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Macie2::Occurrences object:

  $result = $service_obj->Method(...);
  $result->Att1->Cells

=head1 DESCRIPTION

Specifies the location of 1-15 occurrences of sensitive data that was
detected by managed data identifiers or a custom data identifier and
produced a sensitive data finding.

=head1 ATTRIBUTES


=head2 Cells => ArrayRef[L<Paws::Macie2::Cell>]

An array of objects, one for each occurrence of sensitive data in a
Microsoft Excel workbook, CSV file, or TSV file. This value is null for
all other types of files.

Each Cell object specifies a cell or field that contains the sensitive
data.


=head2 LineRanges => ArrayRef[L<Paws::Macie2::Range>]

An array of objects, one for each occurrence of sensitive data in a
non-binary text file, such as an HTML, TXT, or XML file. Each Range
object specifies a line or inclusive range of lines that contains the
sensitive data, and the position of the data on the specified line or
lines.

This value is often null for file types that are supported by Cell,
Page, or Record objects. Exceptions are the location of sensitive data
in: unstructured sections of an otherwise structured file, such as a
comment in a file; a malformed file that Amazon Macie analyzes as plain
text; and, a CSV or TSV file that has any column names that contain
sensitive data.


=head2 OffsetRanges => ArrayRef[L<Paws::Macie2::Range>]

Reserved for future use.


=head2 Pages => ArrayRef[L<Paws::Macie2::Page>]

An array of objects, one for each occurrence of sensitive data in an
Adobe Portable Document Format file. This value is null for all other
types of files.

Each Page object specifies a page that contains the sensitive data.


=head2 Records => ArrayRef[L<Paws::Macie2::Record>]

An array of objects, one for each occurrence of sensitive data in an
Apache Avro object container, Apache Parquet file, JSON file, or JSON
Lines file. This value is null for all other types of files.

For an Avro object container or Parquet file, each Record object
specifies a record index and the path to a field in a record that
contains the sensitive data. For a JSON or JSON Lines file, each Record
object specifies the path to a field or array that contains the
sensitive data. For a JSON Lines file, it also specifies the index of
the line that contains the data.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Macie2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

