
package Paws::FraudDetector::DescribeDetector;
  use Moose;
  has DetectorId => (is => 'ro', isa => 'Str', traits => ['NameInRequest'], request_name => 'detectorId' , required => 1);
  has MaxResults => (is => 'ro', isa => 'Int', traits => ['NameInRequest'], request_name => 'maxResults' );
  has NextToken => (is => 'ro', isa => 'Str', traits => ['NameInRequest'], request_name => 'nextToken' );

  use MooseX::ClassAttribute;

  class_has _api_call => (isa => 'Str', is => 'ro', default => 'DescribeDetector');
  class_has _returns => (isa => 'Str', is => 'ro', default => 'Paws::FraudDetector::DescribeDetectorResult');
  class_has _result_key => (isa => 'Str', is => 'ro');
1;

### main pod documentation begin ###

=head1 NAME

Paws::FraudDetector::DescribeDetector - Arguments for method DescribeDetector on L<Paws::FraudDetector>

=head1 DESCRIPTION

This class represents the parameters used for calling the method DescribeDetector on the
L<Amazon Fraud Detector|Paws::FraudDetector> service. Use the attributes of this class
as arguments to method DescribeDetector.

You shouldn't make instances of this class. Each attribute should be used as a named argument in the call to DescribeDetector.

=head1 SYNOPSIS

    my $frauddetector = Paws->service('FraudDetector');
    my $DescribeDetectorResult = $frauddetector->DescribeDetector(
      DetectorId => 'Myidentifier',
      MaxResults => 1,                # OPTIONAL
      NextToken  => 'Mystring',       # OPTIONAL
    );

    # Results:
    my $Arn        = $DescribeDetectorResult->Arn;
    my $DetectorId = $DescribeDetectorResult->DetectorId;
    my $DetectorVersionSummaries =
      $DescribeDetectorResult->DetectorVersionSummaries;
    my $NextToken = $DescribeDetectorResult->NextToken;

    # Returns a L<Paws::FraudDetector::DescribeDetectorResult> object.

Values for attributes that are native types (Int, String, Float, etc) can passed as-is (scalar values). Values for complex Types (objects) can be passed as a HashRef. The keys and values of the hashref will be used to instance the underlying object.
For the AWS API documentation, see L<https://docs.aws.amazon.com/goto/WebAPI/frauddetector/DescribeDetector>

=head1 ATTRIBUTES


=head2 B<REQUIRED> DetectorId => Str

The detector ID.



=head2 MaxResults => Int

The maximum number of results to return for the request.



=head2 NextToken => Str

The next token from the previous response.




=head1 SEE ALSO

This class forms part of L<Paws>, documenting arguments for method DescribeDetector in L<Paws::FraudDetector>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

