# Generated by default/object.tt
package Paws::ImageBuilder::Container;
  use Moose;
  has ImageUris => (is => 'ro', isa => 'ArrayRef[Str|Undef]', request_name => 'imageUris', traits => ['NameInRequest']);
  has Region => (is => 'ro', isa => 'Str', request_name => 'region', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::ImageBuilder::Container

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::ImageBuilder::Container object:

  $service_obj->Method(Att1 => { ImageUris => $value, ..., Region => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::ImageBuilder::Container object:

  $result = $service_obj->Method(...);
  $result->Att1->ImageUris

=head1 DESCRIPTION

A container encapsulates the runtime environment for an application.

=head1 ATTRIBUTES


=head2 ImageUris => ArrayRef[Str|Undef]

A list of URIs for containers created in the context Region.


=head2 Region => Str

Containers and container images are Region-specific. This is the Region
context for the container.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::ImageBuilder>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

