# Generated by default/object.tt
package Paws::Lightsail::CookieObject;
  use Moose;
  has CookiesAllowList => (is => 'ro', isa => 'ArrayRef[Str|Undef]', request_name => 'cookiesAllowList', traits => ['NameInRequest']);
  has Option => (is => 'ro', isa => 'Str', request_name => 'option', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Lightsail::CookieObject

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Lightsail::CookieObject object:

  $service_obj->Method(Att1 => { CookiesAllowList => $value, ..., Option => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Lightsail::CookieObject object:

  $result = $service_obj->Method(...);
  $result->Att1->CookiesAllowList

=head1 DESCRIPTION

Describes whether an Amazon Lightsail content delivery network (CDN)
distribution forwards cookies to the origin and, if so, which ones.

For the cookies that you specify, your distribution caches separate
versions of the specified content based on the cookie values in viewer
requests.

=head1 ATTRIBUTES


=head2 CookiesAllowList => ArrayRef[Str|Undef]

The specific cookies to forward to your distribution's origin.


=head2 Option => Str

Specifies which cookies to forward to the distribution's origin for a
cache behavior: C<all>, C<none>, or C<allow-list> to forward only the
cookies specified in the C<cookiesAllowList> parameter.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Lightsail>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

