# Generated by default/object.tt
package Paws::WAFV2::GeoMatchStatement;
  use Moose;
  has CountryCodes => (is => 'ro', isa => 'ArrayRef[Str|Undef]');
  has ForwardedIPConfig => (is => 'ro', isa => 'Paws::WAFV2::ForwardedIPConfig');

1;

### main pod documentation begin ###

=head1 NAME

Paws::WAFV2::GeoMatchStatement

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::WAFV2::GeoMatchStatement object:

  $service_obj->Method(Att1 => { CountryCodes => $value, ..., ForwardedIPConfig => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::WAFV2::GeoMatchStatement object:

  $result = $service_obj->Method(...);
  $result->Att1->CountryCodes

=head1 DESCRIPTION

A rule statement used to identify web requests based on country of
origin.

=head1 ATTRIBUTES


=head2 CountryCodes => ArrayRef[Str|Undef]

An array of two-character country codes, for example, C<[ "US", "CN"
]>, from the alpha-2 country ISO codes of the ISO 3166 international
standard.


=head2 ForwardedIPConfig => L<Paws::WAFV2::ForwardedIPConfig>

The configuration for inspecting IP addresses in an HTTP header that
you specify, instead of using the IP address that's reported by the web
request origin. Commonly, this is the X-Forwarded-For (XFF) header, but
you can specify any header name.

If the specified header isn't present in the request, WAF doesn't apply
the rule to the web request at all.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::WAFV2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

