# Generated by default/object.tt
package Paws::SecurityHub::AwsDynamoDbTableDetails;
  use Moose;
  has AttributeDefinitions => (is => 'ro', isa => 'ArrayRef[Paws::SecurityHub::AwsDynamoDbTableAttributeDefinition]');
  has BillingModeSummary => (is => 'ro', isa => 'Paws::SecurityHub::AwsDynamoDbTableBillingModeSummary');
  has CreationDateTime => (is => 'ro', isa => 'Str');
  has GlobalSecondaryIndexes => (is => 'ro', isa => 'ArrayRef[Paws::SecurityHub::AwsDynamoDbTableGlobalSecondaryIndex]');
  has GlobalTableVersion => (is => 'ro', isa => 'Str');
  has ItemCount => (is => 'ro', isa => 'Int');
  has KeySchema => (is => 'ro', isa => 'ArrayRef[Paws::SecurityHub::AwsDynamoDbTableKeySchema]');
  has LatestStreamArn => (is => 'ro', isa => 'Str');
  has LatestStreamLabel => (is => 'ro', isa => 'Str');
  has LocalSecondaryIndexes => (is => 'ro', isa => 'ArrayRef[Paws::SecurityHub::AwsDynamoDbTableLocalSecondaryIndex]');
  has ProvisionedThroughput => (is => 'ro', isa => 'Paws::SecurityHub::AwsDynamoDbTableProvisionedThroughput');
  has Replicas => (is => 'ro', isa => 'ArrayRef[Paws::SecurityHub::AwsDynamoDbTableReplica]');
  has RestoreSummary => (is => 'ro', isa => 'Paws::SecurityHub::AwsDynamoDbTableRestoreSummary');
  has SseDescription => (is => 'ro', isa => 'Paws::SecurityHub::AwsDynamoDbTableSseDescription');
  has StreamSpecification => (is => 'ro', isa => 'Paws::SecurityHub::AwsDynamoDbTableStreamSpecification');
  has TableId => (is => 'ro', isa => 'Str');
  has TableName => (is => 'ro', isa => 'Str');
  has TableSizeBytes => (is => 'ro', isa => 'Int');
  has TableStatus => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SecurityHub::AwsDynamoDbTableDetails

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SecurityHub::AwsDynamoDbTableDetails object:

  $service_obj->Method(Att1 => { AttributeDefinitions => $value, ..., TableStatus => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SecurityHub::AwsDynamoDbTableDetails object:

  $result = $service_obj->Method(...);
  $result->Att1->AttributeDefinitions

=head1 DESCRIPTION

Provides details about a DynamoDB table.

=head1 ATTRIBUTES


=head2 AttributeDefinitions => ArrayRef[L<Paws::SecurityHub::AwsDynamoDbTableAttributeDefinition>]

A list of attribute definitions for the table.


=head2 BillingModeSummary => L<Paws::SecurityHub::AwsDynamoDbTableBillingModeSummary>

Information about the billing for read/write capacity on the table.


=head2 CreationDateTime => Str

Indicates when the table was created.

Uses the C<date-time> format specified in RFC 3339 section 5.6,
Internet Date/Time Format
(https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
contain spaces. For example, C<2020-03-22T13:22:13.933Z>.


=head2 GlobalSecondaryIndexes => ArrayRef[L<Paws::SecurityHub::AwsDynamoDbTableGlobalSecondaryIndex>]

List of global secondary indexes for the table.


=head2 GlobalTableVersion => Str

The version of global tables being used.


=head2 ItemCount => Int

The number of items in the table.


=head2 KeySchema => ArrayRef[L<Paws::SecurityHub::AwsDynamoDbTableKeySchema>]

The primary key structure for the table.


=head2 LatestStreamArn => Str

The ARN of the latest stream for the table.


=head2 LatestStreamLabel => Str

The label of the latest stream. The label is not a unique identifier.


=head2 LocalSecondaryIndexes => ArrayRef[L<Paws::SecurityHub::AwsDynamoDbTableLocalSecondaryIndex>]

The list of local secondary indexes for the table.


=head2 ProvisionedThroughput => L<Paws::SecurityHub::AwsDynamoDbTableProvisionedThroughput>

Information about the provisioned throughput for the table.


=head2 Replicas => ArrayRef[L<Paws::SecurityHub::AwsDynamoDbTableReplica>]

The list of replicas of this table.


=head2 RestoreSummary => L<Paws::SecurityHub::AwsDynamoDbTableRestoreSummary>

Information about the restore for the table.


=head2 SseDescription => L<Paws::SecurityHub::AwsDynamoDbTableSseDescription>

Information about the server-side encryption for the table.


=head2 StreamSpecification => L<Paws::SecurityHub::AwsDynamoDbTableStreamSpecification>

The current DynamoDB Streams configuration for the table.


=head2 TableId => Str

The identifier of the table.


=head2 TableName => Str

The name of the table.


=head2 TableSizeBytes => Int

The total size of the table in bytes.


=head2 TableStatus => Str

The current status of the table.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SecurityHub>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

