# This file was autogenerated.
use 5.008001;
use strict;
use warnings;
no warnings qw( void once );
use Hydrogen ();

package Hydrogen::Topic::ArrayRef;

our $AUTHORITY = 'cpan:TOBYINK';
our $VERSION   = '0.021000';

=head1 NAME

Hydrogen::Topic::ArrayRef - functions from Hydrogen::ArrayRef applied to C<$_>

=head1 VERSION

This documentation is for Hydrogen::Topic::ArrayRef 0.021000,
which is based on Sub::HandlesVia::HandlerLibrary::Array 0.050003.

=cut

=head1 FUNCTIONS

Each function implicitly operates on C<< $_ >>, expecting it to be a reference to an array.

=cut

use Exporter::Shiny qw(
    accessor
    all
    all_true
    any
    apply
    clear
    count
    delete
    elements
    first
    first_index
    flatten
    flatten_deep
    for_each
    for_each_pair
    get
    grep
    head
    indexed
    insert
    is_empty
    join
    map
    max
    maxstr
    min
    minstr
    natatime
    not_all_true
    pairfirst
    pairgrep
    pairkeys
    pairmap
    pairs
    pairvalues
    pick_random
    pop
    print
    product
    push
    reduce
    reductions
    reset
    reverse
    sample
    set
    shallow_clone
    shift
    shuffle
    shuffle_in_place
    sort
    sort_in_place
    splice
    sum
    tail
    uniq
    uniq_in_place
    uniqnum
    uniqnum_in_place
    uniqstr
    uniqstr_in_place
    unshift
);

=head2 C<< accessor( $index, $value? ) >>

Operates on C<< $_ >>, which must be a reference to an array.

Arguments: B<< Int >>, B<< Optional[Any] >>.

Acts like C<get> if given just an index, or C<set> if given an index and value.

=cut

{
    my $__signature;

    sub accessor {

        package Hydrogen::ArrayRef::__SANDBOX__;
        $__signature ||= sub {
            my ( %tmp, $tmp );

            @_ >= 1 && @_ <= 2
              or Hydrogen::croak(
                "Wrong number of parameters in signature for %s: got %d, %s",
                "accessor", scalar(@_), "expected exactly 1 parameters" );

            # Parameter $_[0] (type: Int)
            (
                do {
                    my $tmp = $_[0];
                    defined($tmp) and !ref($tmp) and $tmp =~ /\A-?[0-9]+\z/;
                }
              )
              or Hydrogen::croak(
                "Type check failed in signature for accessor: %s should be %s",
                "\$_[0]", "Int"
              );

            # Parameter $_[1] (type: Optional[Any])
            $#_ >= 1
              or return (@_);
            ( !!1 )
              or Hydrogen::croak(
                "Type check failed in signature for accessor: %s should be %s",
                "\$_[1]", "Optional[Any]"
              );

            (@_);
        };
        @_ = &$__signature;
        1;
        ( ( 0 + @_ ) == 1 ) ? ($_)->[ $_[0] ] : ( ($_)->[ $_[0] ] = $_[1] );
    }
}

=head2 C<< all() >>

Operates on C<< $_ >>, which must be a reference to an array.

All elements in the array, in list context.

=cut

sub all {

    package Hydrogen::ArrayRef::__SANDBOX__;
    @_ == 0
      or Hydrogen::croak( "Wrong number of parameters for all; usage: "
          . "Hydrogen::Topic::ArrayRef::all()" );
    @{$_};
}

=head2 C<< all_true( $coderef ) >>

Operates on C<< $_ >>, which must be a reference to an array.

Arguments: B<< CodeRef >>.

Like C<< List::Util::all() >>.

=cut

sub all_true {

    package Hydrogen::ArrayRef::__SANDBOX__;
    @_ = do {
        my ( %tmp, $tmp );

        @_ == 1
          or Hydrogen::croak(
            "Wrong number of parameters in signature for %s: got %d, %s",
            "all_true", scalar(@_), "expected exactly 1 parameters" );

        # Parameter $_[0] (type: CodeRef)
        ( ref( $_[0] ) eq 'CODE' )
          or Hydrogen::croak(
            "Type check failed in signature for all_true: %s should be %s",
            "\$_[0]", "CodeRef" );

        (@_);
    };
    &List::Util::all( $_[0], @{$_} );
}

=head2 C<< any( $coderef ) >>

Operates on C<< $_ >>, which must be a reference to an array.

Arguments: B<< CodeRef >>.

Like C<< List::Util::any() >>.

=cut

sub any {

    package Hydrogen::ArrayRef::__SANDBOX__;
    @_ = do {
        my ( %tmp, $tmp );

        @_ == 1
          or Hydrogen::croak(
            "Wrong number of parameters in signature for %s: got %d, %s",
            "any", scalar(@_), "expected exactly 1 parameters" );

        # Parameter $_[0] (type: CodeRef)
        ( ref( $_[0] ) eq 'CODE' )
          or Hydrogen::croak(
            "Type check failed in signature for any: %s should be %s",
            "\$_[0]", "CodeRef" );

        (@_);
    };
    &List::Util::any( $_[0], @{$_} );
}

=head2 C<< apply( $coderef ) >>

Operates on C<< $_ >>, which must be a reference to an array.

Arguments: B<< CodeRef >>.

Executes the coderef (which should modify C<< $_ >>) against each element of the array; returns the resulting array in list context.

=cut

sub apply {

    package Hydrogen::ArrayRef::__SANDBOX__;
    @_ = do {
        my ( %tmp, $tmp );

        @_ == 1
          or Hydrogen::croak(
            "Wrong number of parameters in signature for %s: got %d, %s",
            "apply", scalar(@_), "expected exactly 1 parameters" );

        # Parameter $_[0] (type: CodeRef)
        ( ref( $_[0] ) eq 'CODE' )
          or Hydrogen::croak(
            "Type check failed in signature for apply: %s should be %s",
            "\$_[0]", "CodeRef" );

        (@_);
    };
    my @shv_tmp = @{$_};
    &{ $_[0] } foreach @shv_tmp;
    wantarray ? @shv_tmp : $shv_tmp[-1];
}

=head2 C<< clear() >>

Operates on C<< $_ >>, which must be a reference to an array.

Empties the array.

=cut

sub clear {

    package Hydrogen::ArrayRef::__SANDBOX__;
    @_ == 0
      or Hydrogen::croak( "Wrong number of parameters for clear; usage: "
          . "Hydrogen::Topic::ArrayRef::clear()" );
    1;
    @{$_} = ();
}

=head2 C<< count() >>

Operates on C<< $_ >>, which must be a reference to an array.

The number of elements in the referenced array.

=cut

sub count {

    package Hydrogen::ArrayRef::__SANDBOX__;
    @_ == 0
      or Hydrogen::croak( "Wrong number of parameters for count; usage: "
          . "Hydrogen::Topic::ArrayRef::count()" );
    scalar( @{$_} );
}

=head2 C<< delete( $index ) >>

Operates on C<< $_ >>, which must be a reference to an array.

Arguments: B<< Int >>.

Removes the indexed element from the array and returns it. Elements after it will be "moved up".

=cut

sub delete {

    package Hydrogen::ArrayRef::__SANDBOX__;
    @_ = do {
        my ( %tmp, $tmp );

        @_ == 1
          or Hydrogen::croak(
            "Wrong number of parameters in signature for %s: got %d, %s",
            "delete", scalar(@_), "expected exactly 1 parameters" );

        # Parameter $_[0] (type: Int)
        (
            do {
                my $tmp = $_[0];
                defined($tmp) and !ref($tmp) and $tmp =~ /\A-?[0-9]+\z/;
            }
          )
          or Hydrogen::croak(
            "Type check failed in signature for delete: %s should be %s",
            "\$_[0]", "Int" );

        (@_);
    };
    1;
    splice( @{$_}, $_[0], 1 );
}

=head2 C<< elements() >>

Operates on C<< $_ >>, which must be a reference to an array.

All elements in the array, in list context. (Essentially the same as C<all>.)

=cut

sub elements {

    package Hydrogen::ArrayRef::__SANDBOX__;
    @_ == 0
      or Hydrogen::croak( "Wrong number of parameters for elements; usage: "
          . "Hydrogen::Topic::ArrayRef::elements()" );
    @{$_};
}

=head2 C<< first( $coderef ) >>

Operates on C<< $_ >>, which must be a reference to an array.

Arguments: B<< CodeRef >>.

Like C<< List::Util::first() >>.

=cut

sub first {

    package Hydrogen::ArrayRef::__SANDBOX__;
    @_ = do {
        my ( %tmp, $tmp );

        @_ == 1
          or Hydrogen::croak(
            "Wrong number of parameters in signature for %s: got %d, %s",
            "first", scalar(@_), "expected exactly 1 parameters" );

        # Parameter $_[0] (type: CodeRef)
        ( ref( $_[0] ) eq 'CODE' )
          or Hydrogen::croak(
            "Type check failed in signature for first: %s should be %s",
            "\$_[0]", "CodeRef" );

        (@_);
    };
    &List::Util::first( $_[0], @{$_} );
}

=head2 C<< first_index( $coderef ) >>

Operates on C<< $_ >>, which must be a reference to an array.

Arguments: B<< CodeRef >>.

Like C<< List::MoreUtils::first_index() >>.

=cut

sub first_index {

    package Hydrogen::ArrayRef::__SANDBOX__;
    @_ = do {
        my ( %tmp, $tmp );

        @_ == 1
          or Hydrogen::croak(
            "Wrong number of parameters in signature for %s: got %d, %s",
            "first_index", scalar(@_), "expected exactly 1 parameters" );

        # Parameter $_[0] (type: CodeRef)
        ( ref( $_[0] ) eq 'CODE' )
          or Hydrogen::croak(
            "Type check failed in signature for first_index: %s should be %s",
            "\$_[0]", "CodeRef" );

        (@_);
    };
    for my $i ( 0 .. $#{$_} ) { local *_ = \$_->[$i]; return $i if $_[0]->($_) };
    return -1;
}

=head2 C<< flatten() >>

Operates on C<< $_ >>, which must be a reference to an array.

All elements in the array, in list context. (Essentially the same as C<all>.)

=cut

sub flatten {

    package Hydrogen::ArrayRef::__SANDBOX__;
    @_ == 0
      or Hydrogen::croak( "Wrong number of parameters for flatten; usage: "
          . "Hydrogen::Topic::ArrayRef::flatten()" );
    @{$_};
}

=head2 C<< flatten_deep( $depth? ) >>

Operates on C<< $_ >>, which must be a reference to an array.

Arguments: B<< Optional[Int] >>.

Flattens the arrayref into a list, including any nested arrayrefs. (Has the potential to loop infinitely.)

=cut

{
    my $__signature;

    sub flatten_deep {

        package Hydrogen::ArrayRef::__SANDBOX__;
        $__signature ||= sub {
            my ( %tmp, $tmp );

            @_ >= 0
              or Hydrogen::croak(
                "Wrong number of parameters in signature for %s: got %d, %s",
                "flatten_deep", scalar(@_), "expected exactly 0 parameters" );

            # Parameter $_[0] (type: Optional[Int])
            $#_ >= 0
              or return (@_);
            (
                do {
                    my $tmp = $_[0];
                    defined($tmp) and !ref($tmp) and $tmp =~ /\A-?[0-9]+\z/;
                }
              )
              or Hydrogen::croak(
"Type check failed in signature for flatten_deep: %s should be %s",
                "\$_[0]", "Optional[Int]"
              );

            (@_);
        };
        @_ = &$__signature;
        my $shv_fd;
        $shv_fd = sub {
            my $d = pop;
            --$d if defined $d;
            map ref() eq "ARRAY"
              ? ( defined $d && $d < 0 )
                  ? $_
                  : $shv_fd->( @$_, $d )
              : $_, @_;
        };
        $shv_fd->( @{$_}, $_[0] );
    }
}

=head2 C<< for_each( $coderef ) >>

Operates on C<< $_ >>, which must be a reference to an array.

Arguments: B<< CodeRef >>.

Function which executes the coderef on each element of the array. The coderef will be passed two values: the element and its index.

=cut

sub for_each {

    package Hydrogen::ArrayRef::__SANDBOX__;
    @_ = do {
        my ( %tmp, $tmp );

        @_ == 1
          or Hydrogen::croak(
            "Wrong number of parameters in signature for %s: got %d, %s",
            "for_each", scalar(@_), "expected exactly 1 parameters" );

        # Parameter $_[0] (type: CodeRef)
        ( ref( $_[0] ) eq 'CODE' )
          or Hydrogen::croak(
            "Type check failed in signature for for_each: %s should be %s",
            "\$_[0]", "CodeRef" );

        (@_);
    };
    foreach my $shv_index ( 0 .. $#{$_} ) {
        &{ $_[0] }( ($_)->[$shv_index], $shv_index );
    };
    $_;
}

=head2 C<< for_each_pair( $coderef ) >>

Operates on C<< $_ >>, which must be a reference to an array.

Arguments: B<< CodeRef >>.

Function which executes the coderef on each pair of elements in the array. The coderef will be passed the two elements.

=cut

sub for_each_pair {

    package Hydrogen::ArrayRef::__SANDBOX__;
    @_ = do {
        my ( %tmp, $tmp );

        @_ == 1
          or Hydrogen::croak(
            "Wrong number of parameters in signature for %s: got %d, %s",
            "for_each_pair", scalar(@_), "expected exactly 1 parameters" );

        # Parameter $_[0] (type: CodeRef)
        ( ref( $_[0] ) eq 'CODE' )
          or Hydrogen::croak(
            "Type check failed in signature for for_each_pair: %s should be %s",
            "\$_[0]", "CodeRef"
          );

        (@_);
    };
    for ( my $shv_index = 0 ; $shv_index < @{$_} ; $shv_index += 2 ) {
        &{ $_[0] }( ($_)->[$shv_index], ($_)->[ $shv_index + 1 ] );
    };
    $_;
}

=head2 C<< get( $index ) >>

Operates on C<< $_ >>, which must be a reference to an array.

Arguments: B<< Int >>.

Returns a single element from the array by index.

=cut

sub get {

    package Hydrogen::ArrayRef::__SANDBOX__;
    @_ = do {
        my ( %tmp, $tmp );

        @_ == 1
          or Hydrogen::croak(
            "Wrong number of parameters in signature for %s: got %d, %s",
            "get", scalar(@_), "expected exactly 1 parameters" );

        # Parameter $_[0] (type: Int)
        (
            do {
                my $tmp = $_[0];
                defined($tmp) and !ref($tmp) and $tmp =~ /\A-?[0-9]+\z/;
            }
          )
          or Hydrogen::croak(
            "Type check failed in signature for get: %s should be %s",
            "\$_[0]", "Int" );

        (@_);
    };
    ($_)->[ $_[0] ];
}

=head2 C<< grep( $coderef ) >>

Operates on C<< $_ >>, which must be a reference to an array.

Arguments: B<< CodeRef >>.

Like C<grep> from L<perlfunc>.

=cut

sub grep {

    package Hydrogen::ArrayRef::__SANDBOX__;
    @_ = do {
        my ( %tmp, $tmp );

        @_ == 1
          or Hydrogen::croak(
            "Wrong number of parameters in signature for %s: got %d, %s",
            "grep", scalar(@_), "expected exactly 1 parameters" );

        # Parameter $_[0] (type: CodeRef)
        ( ref( $_[0] ) eq 'CODE' )
          or Hydrogen::croak(
            "Type check failed in signature for grep: %s should be %s",
            "\$_[0]", "CodeRef" );

        (@_);
    };
    grep( $_[0]->($_), @{$_} );
}

=head2 C<< head( $count ) >>

Operates on C<< $_ >>, which must be a reference to an array.

Arguments: B<< Int >>.

Returns the first C<< $count >> elements of the array in list context.

=cut

sub head {

    package Hydrogen::ArrayRef::__SANDBOX__;
    @_ = do {
        my ( %tmp, $tmp );

        @_ == 1
          or Hydrogen::croak(
            "Wrong number of parameters in signature for %s: got %d, %s",
            "head", scalar(@_), "expected exactly 1 parameters" );

        # Parameter $_[0] (type: Int)
        (
            do {
                my $tmp = $_[0];
                defined($tmp) and !ref($tmp) and $tmp =~ /\A-?[0-9]+\z/;
            }
          )
          or Hydrogen::croak(
            "Type check failed in signature for head: %s should be %s",
            "\$_[0]", "Int" );

        (@_);
    };
    my $shv_count = $_[0];
    $shv_count = @{$_}              if $shv_count > @{$_};
    $shv_count = @{$_} + $shv_count if $shv_count < 0;
    ( @{$_} )[ 0 .. ( $shv_count - 1 ) ];
}

=head2 C<< indexed() >>

Operates on C<< $_ >>, which must be a reference to an array.

Like C<indexed> from L<builtin>.

=cut

sub indexed {

    package Hydrogen::ArrayRef::__SANDBOX__;
    @_ == 0
      or Hydrogen::croak( "Wrong number of parameters for indexed; usage: "
          . "Hydrogen::Topic::ArrayRef::indexed()" );
    my $shv_ix = 0;
    map +( $shv_ix++, $_ ), @{$_};
}

=head2 C<< insert( $index, $value ) >>

Operates on C<< $_ >>, which must be a reference to an array.

Arguments: B<< Int >>, B<< Any >>.

Inserts a value into the array with the given index. Elements after it will be "moved down".

=cut

sub insert {

    package Hydrogen::ArrayRef::__SANDBOX__;
    @_ = do {
        my ( %tmp, $tmp );

        @_ == 2
          or Hydrogen::croak(
            "Wrong number of parameters in signature for %s: got %d, %s",
            "insert", scalar(@_), "expected exactly 2 parameters" );

        # Parameter $_[0] (type: Int)
        (
            do {
                my $tmp = $_[0];
                defined($tmp) and !ref($tmp) and $tmp =~ /\A-?[0-9]+\z/;
            }
          )
          or Hydrogen::croak(
            "Type check failed in signature for insert: %s should be %s",
            "\$_[0]", "Int" );

        # Parameter $_[1] (type: Any)
        1;    # ... nothing to do

        (@_);
    };
    1;
    splice( @{$_}, $_[0], 0, $_[1] );
}

=head2 C<< is_empty() >>

Operates on C<< $_ >>, which must be a reference to an array.

Boolean indicating if the referenced array is empty.

=cut

sub is_empty {

    package Hydrogen::ArrayRef::__SANDBOX__;
    @_ == 0
      or Hydrogen::croak( "Wrong number of parameters for is_empty; usage: "
          . "Hydrogen::Topic::ArrayRef::is_empty()" );
    !scalar( @{$_} );
}

=head2 C<< join( $with? ) >>

Operates on C<< $_ >>, which must be a reference to an array.

Arguments: B<< Optional[Str] >>.

Returns a string joining all the elements in the array; if C<< $with >> is omitted, defaults to a comma.

=cut

{
    my $__signature;

    sub join {

        package Hydrogen::ArrayRef::__SANDBOX__;
        $__signature ||= sub {
            my ( %tmp, $tmp );

            @_ >= 0
              or Hydrogen::croak(
                "Wrong number of parameters in signature for %s: got %d, %s",
                "join", scalar(@_), "expected exactly 0 parameters" );

            # Parameter $_[0] (type: Optional[Str])
            $#_ >= 0
              or return (@_);
            do {

                package Hydrogen::ArrayRef::__SANDBOX__;
                defined( $_[0] ) and do {
                    ref( \$_[0] ) eq 'SCALAR'
                      or ref( \( my $val = $_[0] ) ) eq 'SCALAR';
                }
              }
              or Hydrogen::croak(
                "Type check failed in signature for join: %s should be %s",
                "\$_[0]", "Optional[Str]" );

            (@_);
        };
        @_ = &$__signature;
        my $shv_param_with = ( 0 + @_ ) ? $_[0] : q[,];
        join( $shv_param_with, @{$_} );
    }
}

=head2 C<< map( $coderef ) >>

Operates on C<< $_ >>, which must be a reference to an array.

Arguments: B<< CodeRef >>.

Like C<map> from L<perlfunc>.

=cut

sub map {

    package Hydrogen::ArrayRef::__SANDBOX__;
    @_ = do {
        my ( %tmp, $tmp );

        @_ == 1
          or Hydrogen::croak(
            "Wrong number of parameters in signature for %s: got %d, %s",
            "map", scalar(@_), "expected exactly 1 parameters" );

        # Parameter $_[0] (type: CodeRef)
        ( ref( $_[0] ) eq 'CODE' )
          or Hydrogen::croak(
            "Type check failed in signature for map: %s should be %s",
            "\$_[0]", "CodeRef" );

        (@_);
    };
    map( $_[0]->($_), @{$_} );
}

=head2 C<< max() >>

Operates on C<< $_ >>, which must be a reference to an array.

Like C<< List::Util::max() >>.

=cut

sub max {

    package Hydrogen::ArrayRef::__SANDBOX__;
    @_ == 0
      or Hydrogen::croak( "Wrong number of parameters for max; usage: "
          . "Hydrogen::Topic::ArrayRef::max()" );
    &List::Util::max( @{$_} );
}

=head2 C<< maxstr() >>

Operates on C<< $_ >>, which must be a reference to an array.

Like C<< List::Util::maxstr() >>.

=cut

sub maxstr {

    package Hydrogen::ArrayRef::__SANDBOX__;
    @_ == 0
      or Hydrogen::croak( "Wrong number of parameters for maxstr; usage: "
          . "Hydrogen::Topic::ArrayRef::maxstr()" );
    &List::Util::maxstr( @{$_} );
}

=head2 C<< min() >>

Operates on C<< $_ >>, which must be a reference to an array.

Like C<< List::Util::min() >>.

=cut

sub min {

    package Hydrogen::ArrayRef::__SANDBOX__;
    @_ == 0
      or Hydrogen::croak( "Wrong number of parameters for min; usage: "
          . "Hydrogen::Topic::ArrayRef::min()" );
    &List::Util::min( @{$_} );
}

=head2 C<< minstr() >>

Operates on C<< $_ >>, which must be a reference to an array.

Like C<< List::Util::minstr() >>.

=cut

sub minstr {

    package Hydrogen::ArrayRef::__SANDBOX__;
    @_ == 0
      or Hydrogen::croak( "Wrong number of parameters for minstr; usage: "
          . "Hydrogen::Topic::ArrayRef::minstr()" );
    &List::Util::minstr( @{$_} );
}

=head2 C<< natatime( $n, $callback? ) >>

Operates on C<< $_ >>, which must be a reference to an array.

Arguments: B<< Int >>, B<< Optional[CodeRef] >>.

Given just a number, returns an iterator which reads that many elements from the array at a time. If also given a callback, calls the callback repeatedly with those values.

=cut

{
    my $__signature;

    sub natatime {

        package Hydrogen::ArrayRef::__SANDBOX__;
        $__signature ||= sub {
            my ( %tmp, $tmp );

            @_ >= 1 && @_ <= 2
              or Hydrogen::croak(
                "Wrong number of parameters in signature for %s: got %d, %s",
                "natatime", scalar(@_), "expected exactly 1 parameters" );

            # Parameter $_[0] (type: Int)
            (
                do {
                    my $tmp = $_[0];
                    defined($tmp) and !ref($tmp) and $tmp =~ /\A-?[0-9]+\z/;
                }
              )
              or Hydrogen::croak(
                "Type check failed in signature for natatime: %s should be %s",
                "\$_[0]", "Int"
              );

            # Parameter $_[1] (type: Optional[CodeRef])
            $#_ >= 1
              or return (@_);
            ( ref( $_[1] ) eq 'CODE' )
              or Hydrogen::croak(
                "Type check failed in signature for natatime: %s should be %s",
                "\$_[1]", "Optional[CodeRef]"
              );

            (@_);
        };
        @_ = &$__signature;
        my @shv_remaining = @{$_};
        my $shv_n         = $_[0];
        my $shv_iterator  = sub { CORE::splice @shv_remaining, 0, $shv_n };
        if ( $_[1] ) {
            while ( my @shv_values = $shv_iterator->() ) {
                $_[1]->(@shv_values);
            }
        }
        else { $shv_iterator }
    }
}

=head2 C<< not_all_true( $coderef ) >>

Operates on C<< $_ >>, which must be a reference to an array.

Arguments: B<< CodeRef >>.

Like C<< List::Util::notall() >>.

=cut

sub not_all_true {

    package Hydrogen::ArrayRef::__SANDBOX__;
    @_ = do {
        my ( %tmp, $tmp );

        @_ == 1
          or Hydrogen::croak(
            "Wrong number of parameters in signature for %s: got %d, %s",
            "not_all_true", scalar(@_), "expected exactly 1 parameters" );

        # Parameter $_[0] (type: CodeRef)
        ( ref( $_[0] ) eq 'CODE' )
          or Hydrogen::croak(
            "Type check failed in signature for not_all_true: %s should be %s",
            "\$_[0]", "CodeRef"
          );

        (@_);
    };
    &List::Util::notall( $_[0], @{$_} );
}

=head2 C<< pairfirst( $coderef ) >>

Operates on C<< $_ >>, which must be a reference to an array.

Arguments: B<< CodeRef >>.

Like C<< List::Util::pairfirst() >>.

=cut

sub pairfirst {

    package Hydrogen::ArrayRef::__SANDBOX__;
    @_ = do {
        my ( %tmp, $tmp );

        @_ == 1
          or Hydrogen::croak(
            "Wrong number of parameters in signature for %s: got %d, %s",
            "pairfirst", scalar(@_), "expected exactly 1 parameters" );

        # Parameter $_[0] (type: CodeRef)
        ( ref( $_[0] ) eq 'CODE' )
          or Hydrogen::croak(
            "Type check failed in signature for pairfirst: %s should be %s",
            "\$_[0]", "CodeRef" );

        (@_);
    };
    List::Util::pairfirst { $_[0]->($_) } @{$_};
}

=head2 C<< pairgrep( $coderef ) >>

Operates on C<< $_ >>, which must be a reference to an array.

Arguments: B<< CodeRef >>.

Like C<< List::Util::pairgrep() >>.

=cut

sub pairgrep {

    package Hydrogen::ArrayRef::__SANDBOX__;
    @_ = do {
        my ( %tmp, $tmp );

        @_ == 1
          or Hydrogen::croak(
            "Wrong number of parameters in signature for %s: got %d, %s",
            "pairgrep", scalar(@_), "expected exactly 1 parameters" );

        # Parameter $_[0] (type: CodeRef)
        ( ref( $_[0] ) eq 'CODE' )
          or Hydrogen::croak(
            "Type check failed in signature for pairgrep: %s should be %s",
            "\$_[0]", "CodeRef" );

        (@_);
    };
    List::Util::pairgrep { $_[0]->($_) } @{$_};
}

=head2 C<< pairkeys() >>

Operates on C<< $_ >>, which must be a reference to an array.

Like C<< List::Util::pairkeys() >>.

=cut

sub pairkeys {

    package Hydrogen::ArrayRef::__SANDBOX__;
    @_ == 0
      or Hydrogen::croak( "Wrong number of parameters for pairkeys; usage: "
          . "Hydrogen::Topic::ArrayRef::pairkeys()" );
    &List::Util::pairkeys( @{$_} );
}

=head2 C<< pairmap( $coderef ) >>

Operates on C<< $_ >>, which must be a reference to an array.

Arguments: B<< CodeRef >>.

Like C<< List::Util::pairmap() >>.

=cut

sub pairmap {

    package Hydrogen::ArrayRef::__SANDBOX__;
    @_ = do {
        my ( %tmp, $tmp );

        @_ == 1
          or Hydrogen::croak(
            "Wrong number of parameters in signature for %s: got %d, %s",
            "pairmap", scalar(@_), "expected exactly 1 parameters" );

        # Parameter $_[0] (type: CodeRef)
        ( ref( $_[0] ) eq 'CODE' )
          or Hydrogen::croak(
            "Type check failed in signature for pairmap: %s should be %s",
            "\$_[0]", "CodeRef" );

        (@_);
    };
    List::Util::pairmap { $_[0]->($_) } @{$_};
}

=head2 C<< pairs() >>

Operates on C<< $_ >>, which must be a reference to an array.

Like C<< List::Util::pairs() >>.

=cut

sub pairs {

    package Hydrogen::ArrayRef::__SANDBOX__;
    @_ == 0
      or Hydrogen::croak( "Wrong number of parameters for pairs; usage: "
          . "Hydrogen::Topic::ArrayRef::pairs()" );
    &List::Util::pairs( @{$_} );
}

=head2 C<< pairvalues() >>

Operates on C<< $_ >>, which must be a reference to an array.

Like C<< List::Util::pairvalues() >>.

=cut

sub pairvalues {

    package Hydrogen::ArrayRef::__SANDBOX__;
    @_ == 0
      or Hydrogen::croak( "Wrong number of parameters for pairvalues; usage: "
          . "Hydrogen::Topic::ArrayRef::pairvalues()" );
    &List::Util::pairvalues( @{$_} );
}

=head2 C<< pick_random( $count ) >>

Operates on C<< $_ >>, which must be a reference to an array.

Arguments: B<< Optional[Int] >>.

If no C<< $count >> is given, returns one element of the array at random. If C<< $count >> is given, creates a new array with that many random elements from the original array (or fewer if the original array is not long enough) and returns that as an arrayref or list depending on context

=cut

{
    my $__signature;

    sub pick_random {

        package Hydrogen::ArrayRef::__SANDBOX__;
        $__signature ||= sub {
            my ( %tmp, $tmp );

            @_ >= 0
              or Hydrogen::croak(
                "Wrong number of parameters in signature for %s: got %d, %s",
                "pick_random", scalar(@_), "expected exactly 0 parameters" );

            # Parameter $_[0] (type: Optional[Int])
            $#_ >= 0
              or return (@_);
            (
                do {
                    my $tmp = $_[0];
                    defined($tmp) and !ref($tmp) and $tmp =~ /\A-?[0-9]+\z/;
                }
              )
              or Hydrogen::croak(
"Type check failed in signature for pick_random: %s should be %s",
                "\$_[0]", "Optional[Int]"
              );

            (@_);
        };
        @_ = &$__signature;
        my @shv_tmp   = List::Util::shuffle( @{$_} );
        my $shv_count = $_[0];
        $shv_count = @{$_}              if $shv_count > @{$_};
        $shv_count = @{$_} + $shv_count if $shv_count < 0;
        if    ( wantarray and ( 0 + @_ ) ) { @shv_tmp[ 0 .. $shv_count - 1 ] }
        elsif ( ( 0 + @_ ) ) { [ @shv_tmp[ 0 .. $shv_count - 1 ] ] }
        else                 { $shv_tmp[0] }
    }
}

=head2 C<< pop() >>

Operates on C<< $_ >>, which must be a reference to an array.

Removes the last element from the array and returns it.

=cut

sub pop {

    package Hydrogen::ArrayRef::__SANDBOX__;
    @_ == 0
      or Hydrogen::croak( "Wrong number of parameters for pop; usage: "
          . "Hydrogen::Topic::ArrayRef::pop()" );
    1;
    pop( @{$_} );
}

=head2 C<< print( $fh?, $with? ) >>

Operates on C<< $_ >>, which must be a reference to an array.

Arguments: B<< Optional[FileHandle] >>, B<< Optional[Str] >>.

Prints a string joining all the elements in the array; if C<< $fh >> is omitted, defaults to STDOUT; if C<< $with >> is omitted, defaults to a comma.

=cut

{
    my $__signature;

    sub print {

        package Hydrogen::ArrayRef::__SANDBOX__;
        $__signature ||= sub {
            my ( %tmp, $tmp );

            @_ >= 0
              or Hydrogen::croak(
                "Wrong number of parameters in signature for %s: got %d, %s",
                "print", scalar(@_), "expected exactly 0 parameters" );

            # Parameter $_[0] (type: Optional[FileHandle])
            $#_ >= 0
              or return (@_);
            (
                do {

                    package Hydrogen::ArrayRef::__SANDBOX__;
                    use Scalar::Util ();
                    ( ref( $_[0] ) && Scalar::Util::openhandle( $_[0] ) )
                      or ( Scalar::Util::blessed( $_[0] )
                        && $_[0]->isa("IO::Handle") );
                }
              )
              or Hydrogen::croak(
                "Type check failed in signature for print: %s should be %s",
                "\$_[0]", "Optional[FileHandle]" );

            # Parameter $_[1] (type: Optional[Str])
            $#_ >= 1
              or return (@_);
            do {

                package Hydrogen::ArrayRef::__SANDBOX__;
                defined( $_[1] ) and do {
                    ref( \$_[1] ) eq 'SCALAR'
                      or ref( \( my $val = $_[1] ) ) eq 'SCALAR';
                }
              }
              or Hydrogen::croak(
                "Type check failed in signature for print: %s should be %s",
                "\$_[1]", "Optional[Str]" );

            (@_);
        };
        @_ = &$__signature;
        my $shv_param_with = ( ( 0 + @_ ) > 1 ) ? $_[1] : q[,];
        print { $_[0] || *STDOUT } join( $shv_param_with, @{$_} );
    }
}

=head2 C<< product() >>

Operates on C<< $_ >>, which must be a reference to an array.

Like C<< List::Util::product() >>.

=cut

sub product {

    package Hydrogen::ArrayRef::__SANDBOX__;
    @_ == 0
      or Hydrogen::croak( "Wrong number of parameters for product; usage: "
          . "Hydrogen::Topic::ArrayRef::product()" );
    &List::Util::product( 1, @{$_} );
}

=head2 C<< push( @values ) >>

Operates on C<< $_ >>, which must be a reference to an array.

Adds elements to the end of the array.

=cut

sub push {

    package Hydrogen::ArrayRef::__SANDBOX__;
    1;
    push( @{$_}, @_ );
}

=head2 C<< reduce( $coderef ) >>

Operates on C<< $_ >>, which must be a reference to an array.

Arguments: B<< CodeRef >>.

Like C<< List::Util::reduce() >>.

=cut

sub reduce {

    package Hydrogen::ArrayRef::__SANDBOX__;
    @_ = do {
        my ( %tmp, $tmp );

        @_ == 1
          or Hydrogen::croak(
            "Wrong number of parameters in signature for %s: got %d, %s",
            "reduce", scalar(@_), "expected exactly 1 parameters" );

        # Parameter $_[0] (type: CodeRef)
        ( ref( $_[0] ) eq 'CODE' )
          or Hydrogen::croak(
            "Type check failed in signature for reduce: %s should be %s",
            "\$_[0]", "CodeRef" );

        (@_);
    };
    my $shv_callback = $_[0];
    List::Util::reduce { $shv_callback->( $a, $b ) } @{$_};
}

=head2 C<< reductions( $coderef ) >>

Operates on C<< $_ >>, which must be a reference to an array.

Arguments: B<< CodeRef >>.

Like C<< List::Util::reductions() >>.

=cut

sub reductions {

    package Hydrogen::ArrayRef::__SANDBOX__;
    @_ = do {
        my ( %tmp, $tmp );

        @_ == 1
          or Hydrogen::croak(
            "Wrong number of parameters in signature for %s: got %d, %s",
            "reductions", scalar(@_), "expected exactly 1 parameters" );

        # Parameter $_[0] (type: CodeRef)
        ( ref( $_[0] ) eq 'CODE' )
          or Hydrogen::croak(
            "Type check failed in signature for reductions: %s should be %s",
            "\$_[0]", "CodeRef" );

        (@_);
    };
    my $shv_callback = $_[0];
    List::Util::reductions { $shv_callback->( $a, $b ) } @{$_};
}

=head2 C<< reset() >>

Operates on C<< $_ >>, which must be a reference to an array.

Resets the original value to its default value, or an empty arrayref if it has no default.

=cut

sub reset {

    package Hydrogen::ArrayRef::__SANDBOX__;
    @_ == 0
      or Hydrogen::croak( "Wrong number of parameters for reset; usage: "
          . "Hydrogen::Topic::ArrayRef::reset()" );
    (
        @{$_} = @{
            +do {
                my $shv_final_unchecked = [];
                do {
                    ( ref($shv_final_unchecked) eq 'ARRAY' )
                      or Hydrogen::croak(
"Type check failed for reset: expected %s, got value %s",
                        "ArrayRef", $shv_final_unchecked
                      );
                    $shv_final_unchecked;
                };
            }
        }
    );
}

=head2 C<< reverse() >>

Operates on C<< $_ >>, which must be a reference to an array.

Returns the reversed array in list context.

=cut

sub reverse {

    package Hydrogen::ArrayRef::__SANDBOX__;
    @_ == 0
      or Hydrogen::croak( "Wrong number of parameters for reverse; usage: "
          . "Hydrogen::Topic::ArrayRef::reverse()" );
    reverse @{$_};
}

=head2 C<< sample( $count ) >>

Operates on C<< $_ >>, which must be a reference to an array.

Arguments: B<< Int >>.

Like C<< List::Util::sample() >>.

=cut

sub sample {

    package Hydrogen::ArrayRef::__SANDBOX__;
    @_ = do {
        my ( %tmp, $tmp );

        @_ == 1
          or Hydrogen::croak(
            "Wrong number of parameters in signature for %s: got %d, %s",
            "sample", scalar(@_), "expected exactly 1 parameters" );

        # Parameter $_[0] (type: Int)
        (
            do {
                my $tmp = $_[0];
                defined($tmp) and !ref($tmp) and $tmp =~ /\A-?[0-9]+\z/;
            }
          )
          or Hydrogen::croak(
            "Type check failed in signature for sample: %s should be %s",
            "\$_[0]", "Int" );

        (@_);
    };
    &List::Util::sample( $_[0], @{$_} );
}

=head2 C<< set( $index, $value ) >>

Operates on C<< $_ >>, which must be a reference to an array.

Arguments: B<< Int >>, B<< Any >>.

Sets the element with the given index to the supplied value.

=cut

sub set {

    package Hydrogen::ArrayRef::__SANDBOX__;
    @_ = do {
        my ( %tmp, $tmp );

        @_ == 2
          or Hydrogen::croak(
            "Wrong number of parameters in signature for %s: got %d, %s",
            "set", scalar(@_), "expected exactly 2 parameters" );

        # Parameter $_[0] (type: Int)
        (
            do {
                my $tmp = $_[0];
                defined($tmp) and !ref($tmp) and $tmp =~ /\A-?[0-9]+\z/;
            }
          )
          or Hydrogen::croak(
            "Type check failed in signature for set: %s should be %s",
            "\$_[0]", "Int" );

        # Parameter $_[1] (type: Any)
        1;    # ... nothing to do

        (@_);
    };
    1;
    ($_)->[ $_[0] ] = $_[1];
}

=head2 C<< shallow_clone() >>

Operates on C<< $_ >>, which must be a reference to an array.

Creates a new arrayref with the same elements as the original.

=cut

sub shallow_clone {

    package Hydrogen::ArrayRef::__SANDBOX__;
    @_ == 0
      or
      Hydrogen::croak( "Wrong number of parameters for shallow_clone; usage: "
          . "Hydrogen::Topic::ArrayRef::shallow_clone()" );
    [ @{$_} ];
}

=head2 C<< shift() >>

Operates on C<< $_ >>, which must be a reference to an array.

Removes an element from the start of the array and returns it.

=cut

sub shift {

    package Hydrogen::ArrayRef::__SANDBOX__;
    @_ == 0
      or Hydrogen::croak( "Wrong number of parameters for shift; usage: "
          . "Hydrogen::Topic::ArrayRef::shift()" );
    1;
    shift( @{$_} );
}

=head2 C<< shuffle() >>

Operates on C<< $_ >>, which must be a reference to an array.

Returns the array in a random order; can be called in list context or scalar context and will return an arrayref in the latter case.

=cut

sub shuffle {

    package Hydrogen::ArrayRef::__SANDBOX__;
    @_ == 0
      or Hydrogen::croak( "Wrong number of parameters for shuffle; usage: "
          . "Hydrogen::Topic::ArrayRef::shuffle()" );
    my @shv_return = List::Util::shuffle( @{$_} );
    wantarray ? @shv_return : \@shv_return;
}

=head2 C<< shuffle_in_place() >>

Operates on C<< $_ >>, which must be a reference to an array.

Rearranges the array in a random order, and changes the original value to point to the new order.

=cut

sub shuffle_in_place {

    package Hydrogen::ArrayRef::__SANDBOX__;
    @_ == 0
      or Hydrogen::croak(
            "Wrong number of parameters for shuffle_in_place; usage: "
          . "Hydrogen::Topic::ArrayRef::shuffle_in_place()" );
    1;
    my @shv_return = List::Util::shuffle( @{$_} );
    ( @{$_} = @{ +\@shv_return } );
}

=head2 C<< sort( $coderef? ) >>

Operates on C<< $_ >>, which must be a reference to an array.

Arguments: B<< Optional[CodeRef] >>.

Like C<sort> from L<perlfunc>.

=cut

{
    my $__signature;

    sub sort {

        package Hydrogen::ArrayRef::__SANDBOX__;
        $__signature ||= sub {
            my ( %tmp, $tmp );

            @_ >= 0
              or Hydrogen::croak(
                "Wrong number of parameters in signature for %s: got %d, %s",
                "sort", scalar(@_), "expected exactly 0 parameters" );

            # Parameter $_[0] (type: Optional[CodeRef])
            $#_ >= 0
              or return (@_);
            ( ref( $_[0] ) eq 'CODE' )
              or Hydrogen::croak(
                "Type check failed in signature for sort: %s should be %s",
                "\$_[0]", "Optional[CodeRef]" );

            (@_);
        };
        @_ = &$__signature;
        my @shv_return =
          $_[0] ? ( sort { $_[0]->( $a, $b ) } @{$_} ) : ( sort @{$_} );
    }
}

=head2 C<< sort_in_place( $coderef? ) >>

Operates on C<< $_ >>, which must be a reference to an array.

Arguments: B<< Optional[CodeRef] >>.

Like C<sort> from L<perlfunc>, but changes the original value to point to the newly sorted array.

=cut

{
    my $__signature;

    sub sort_in_place {

        package Hydrogen::ArrayRef::__SANDBOX__;
        $__signature ||= sub {
            my ( %tmp, $tmp );

            @_ >= 0
              or Hydrogen::croak(
                "Wrong number of parameters in signature for %s: got %d, %s",
                "sort_in_place", scalar(@_), "expected exactly 0 parameters" );

            # Parameter $_[0] (type: Optional[CodeRef])
            $#_ >= 0
              or return (@_);
            ( ref( $_[0] ) eq 'CODE' )
              or Hydrogen::croak(
"Type check failed in signature for sort_in_place: %s should be %s",
                "\$_[0]", "Optional[CodeRef]"
              );

            (@_);
        };
        @_ = &$__signature;
        1;
        my @shv_return =
          $_[0] ? ( sort { $_[0]->( $a, $b ) } @{$_} ) : ( sort @{$_} );
        ( @{$_} = @{ +\@shv_return } );
    }
}

=head2 C<< splice( $index, $length, @values ) >>

Operates on C<< $_ >>, which must be a reference to an array.

Like C<splice> from L<perlfunc>.

=cut

sub splice {

    package Hydrogen::ArrayRef::__SANDBOX__;
    @_ >= 1
      or Hydrogen::croak( "Wrong number of parameters for splice; usage: "
          . "Hydrogen::Topic::ArrayRef::splice( \$index, \$length, \@values )"
      );
    if ( ( 0 + @_ ) >= 1 ) {
        do {
            (
                do {
                    my $tmp = $_[0];
                    defined($tmp) and !ref($tmp) and $tmp =~ /\A-?[0-9]+\z/;
                }
              )
              or Hydrogen::croak(
                "Type check failed for splice: expected %s, got value %s",
                "Int", $_[0] );
            $_[0];
        };
    }
    ;
    if ( ( 0 + @_ ) >= 2 ) {
        do {
            (
                do {
                    my $tmp = $_[1];
                    defined($tmp) and !ref($tmp) and $tmp =~ /\A-?[0-9]+\z/;
                }
              )
              or Hydrogen::croak(
                "Type check failed for splice: expected %s, got value %s",
                "Int", $_[1] );
            $_[1];
        };
    }
    my ( $shv_index, $shv_length, @shv_values ) = @_;
    splice( @{$_}, $shv_index, $shv_length, @shv_values );
}

=head2 C<< sum() >>

Operates on C<< $_ >>, which must be a reference to an array.

Like C<< List::Util::sum0() >>.

=cut

sub sum {

    package Hydrogen::ArrayRef::__SANDBOX__;
    @_ == 0
      or Hydrogen::croak( "Wrong number of parameters for sum; usage: "
          . "Hydrogen::Topic::ArrayRef::sum()" );
    &List::Util::sum( 0, @{$_} );
}

=head2 C<< tail( $count ) >>

Operates on C<< $_ >>, which must be a reference to an array.

Arguments: B<< Int >>.

Returns the last C<< $count >> elements of the array in list context.

=cut

sub tail {

    package Hydrogen::ArrayRef::__SANDBOX__;
    @_ = do {
        my ( %tmp, $tmp );

        @_ == 1
          or Hydrogen::croak(
            "Wrong number of parameters in signature for %s: got %d, %s",
            "tail", scalar(@_), "expected exactly 1 parameters" );

        # Parameter $_[0] (type: Int)
        (
            do {
                my $tmp = $_[0];
                defined($tmp) and !ref($tmp) and $tmp =~ /\A-?[0-9]+\z/;
            }
          )
          or Hydrogen::croak(
            "Type check failed in signature for tail: %s should be %s",
            "\$_[0]", "Int" );

        (@_);
    };
    my $shv_count = $_[0];
    $shv_count = @{$_}              if $shv_count > @{$_};
    $shv_count = @{$_} + $shv_count if $shv_count < 0;
    my $shv_start = scalar( @{$_} ) - $shv_count;
    my $shv_end   = scalar( @{$_} ) - 1;
    ( @{$_} )[ $shv_start .. $shv_end ];
}

=head2 C<< uniq() >>

Operates on C<< $_ >>, which must be a reference to an array.

Returns the array filtered to remove duplicates; can be called in list context or scalar context and will return an arrayref in the latter case.

=cut

sub uniq {

    package Hydrogen::ArrayRef::__SANDBOX__;
    @_ == 0
      or Hydrogen::croak( "Wrong number of parameters for uniq; usage: "
          . "Hydrogen::Topic::ArrayRef::uniq()" );
    my @shv_return = List::Util::uniq( @{$_} );
    wantarray ? @shv_return : \@shv_return;
}

=head2 C<< uniq_in_place() >>

Operates on C<< $_ >>, which must be a reference to an array.

Filters the array to remove duplicates, and changes the original value to point to the filtered array.

=cut

sub uniq_in_place {

    package Hydrogen::ArrayRef::__SANDBOX__;
    @_ == 0
      or
      Hydrogen::croak( "Wrong number of parameters for uniq_in_place; usage: "
          . "Hydrogen::Topic::ArrayRef::uniq_in_place()" );
    1;
    my @shv_return = List::Util::uniq( @{$_} );
    ( @{$_} = @{ +\@shv_return } );
}

=head2 C<< uniqnum() >>

Operates on C<< $_ >>, which must be a reference to an array.

Returns the array filtered to remove duplicates numerically; can be called in list context or scalar context and will return an arrayref in the latter case.

=cut

sub uniqnum {

    package Hydrogen::ArrayRef::__SANDBOX__;
    @_ == 0
      or Hydrogen::croak( "Wrong number of parameters for uniqnum; usage: "
          . "Hydrogen::Topic::ArrayRef::uniqnum()" );
    my @shv_return = List::Util::uniqnum( @{$_} );
    wantarray ? @shv_return : \@shv_return;
}

=head2 C<< uniqnum_in_place() >>

Operates on C<< $_ >>, which must be a reference to an array.

Filters the array to remove duplicates numerically, and changes the original value to point to the filtered array.

=cut

sub uniqnum_in_place {

    package Hydrogen::ArrayRef::__SANDBOX__;
    @_ == 0
      or Hydrogen::croak(
            "Wrong number of parameters for uniqnum_in_place; usage: "
          . "Hydrogen::Topic::ArrayRef::uniqnum_in_place()" );
    1;
    my @shv_return = List::Util::uniqnum( @{$_} );
    ( @{$_} = @{ +\@shv_return } );
}

=head2 C<< uniqstr() >>

Operates on C<< $_ >>, which must be a reference to an array.

Returns the array filtered to remove duplicates stringwise; can be called in list context or scalar context and will return an arrayref in the latter case.

=cut

sub uniqstr {

    package Hydrogen::ArrayRef::__SANDBOX__;
    @_ == 0
      or Hydrogen::croak( "Wrong number of parameters for uniqstr; usage: "
          . "Hydrogen::Topic::ArrayRef::uniqstr()" );
    my @shv_return = List::Util::uniqstr( @{$_} );
    wantarray ? @shv_return : \@shv_return;
}

=head2 C<< uniqstr_in_place() >>

Operates on C<< $_ >>, which must be a reference to an array.

Filters the array to remove duplicates stringwise, and changes the original value to point to the filtered array.

=cut

sub uniqstr_in_place {

    package Hydrogen::ArrayRef::__SANDBOX__;
    @_ == 0
      or Hydrogen::croak(
            "Wrong number of parameters for uniqstr_in_place; usage: "
          . "Hydrogen::Topic::ArrayRef::uniqstr_in_place()" );
    1;
    my @shv_return = List::Util::uniqstr( @{$_} );
    ( @{$_} = @{ +\@shv_return } );
}

=head2 C<< unshift( @values ) >>

Operates on C<< $_ >>, which must be a reference to an array.

Adds an element to the start of the array.

=cut

sub unshift {

    package Hydrogen::ArrayRef::__SANDBOX__;
    1;
    unshift( @{$_}, @_ );
}

1;

=head1 EXPORT

No functions are exported by this module by default. To import them all (this is usually a bad idea), use:

    use Hydrogen::Topic::ArrayRef -all;

To import a particular function, use:

    use Hydrogen::Topic::ArrayRef 'all_true';

To rename functions:

    use Hydrogen::Topic::ArrayRef 'all_true' => { -as => 'myfunc' };

On Perl 5.37.2+ (or if L<Lexical::Sub> is installed) you can import lexically:

    use Hydrogen::Topic::ArrayRef -lexical, 'all_true';

See L<Exporter::Tiny::Manual::Importing> for more hints on importing.

=head1 BUGS

Please report any bugs to
L<http://github.com/tobyink/p5-hydrogen/issues>.

=head1 SEE ALSO

L<Hydrogen>,
L<Hydrogen::ArrayRef>,
L<Hydrogen::Array>,
L<Hydrogen::Curry::ArrayRef>,
L<Sub::HandlesVia::HandlerLibrary::Array>,
L<List::Util>,
L<List::MoreUtils>.

=head1 AUTHOR

Toby Inkster E<lt>tobyink@cpan.orgE<gt>.

=head1 COPYRIGHT AND LICENCE

This software is copyright (c) 2022-2025 by Toby Inkster.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 DISCLAIMER OF WARRANTIES

THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED
WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.

