package Lingua::ZH::CEDICT::HanConvert;

# Copyright (c) 2002 Christian Renz <crenz@web42.com>
# This module is free software; you can redistribute it and/or modify
# it under the same terms as Perl itself.

# $Id: HanConvert.pm,v 1.2 2002/08/13 19:07:07 crenz Exp $

use 5.006;
use strict;
use warnings;
use utf8;
use Exporter;

our @ISA = qw(Exporter);
our $VERSION = '0.01';
our @EXPORT_OK = qw(&simple);
our %simpMappings;

sub simple {
    my ($text) = @_;

    $text =~ s/(\S)/ defined $simpMappings{$1} ? $simpMappings{$1} : $1; /eg;

    return $text;
}


%simpMappings =
   ('丟' => '丢', '並' => '并', '亂' => '乱', '亙' => '亘',
    '亞' => '亚', '伕' => '夫', '佇' => '伫', '佈' => '布',
    '佔' => '占', '併' => '并', '來' => '来', '侖' => '仑',
    '侚' => '徇', '侶' => '侣', '侷' => '局', '俁' => '俣',
    '係' => '系', '俠' => '侠', '倀' => '伥', '倆' => '俩',
    '倉' => '仓', '個' => '个', '們' => '们', '倖' => '幸',
    '倣' => '仿', '倫' => '伦', '偉' => '伟', '偪' => '逼',
    '側' => '侧', '偵' => '侦', '偽' => '伪', '傑' => '杰',
    '傖' => '伧', '傘' => '伞', '備' => '备', '傚' => '效',
    '傢' => '家', '傯' => '偬', '傳' => '传', '傴' => '伛',
    '債' => '债', '傷' => '伤', '傾' => '倾', '僂' => '偻',
    '僅' => '仅', '僉' => '佥', '僊' => '仙', '僑' => '侨',
    '僕' => '仆', '僥' => '侥', '僨' => '偾', '僱' => '雇',
    '價' => '价', '儀' => '仪', '儂' => '侬', '億' => '亿',
    '儈' => '侩', '儉' => '俭', '儐' => '傧', '儔' => '俦',
    '儕' => '侪', '儘' => '尽', '償' => '偿', '優' => '优',
    '儲' => '储', '儷' => '俪', '儺' => '傩', '儻' => '傥',
    '儼' => '俨', '兇' => '凶', '兌' => '兑', '兒' => '儿',
    '兗' => '兖', '內' => '内', '兩' => '两', '冊' => '册',
    '冑' => '胄', '冪' => '幂', '凈' => '净', '凍' => '冻',
    '凜' => '凛', '凱' => '凯', '別' => '别', '刪' => '删',
    '剄' => '刭', '則' => '则', '剉' => '锉', '剋' => '克',
    '剎' => '刹', '剛' => '刚', '剝' => '剥', '剮' => '剐',
    '剴' => '剀', '創' => '创', '剷' => '铲', '劃' => '划',
    '劄' => '札', '劇' => '剧', '劉' => '刘', '劊' => '刽',
    '劌' => '刿', '劍' => '剑', '劑' => '剂', '勁' => '劲',
    '動' => '动', '務' => '务', '勛' => '勋', '勝' => '胜',
    '勞' => '劳', '勢' => '势', '勣' => '绩', '勱' => '劢',
    '勳' => '勋', '勵' => '励', '勸' => '劝', '勻' => '匀',
    '匋' => '陶', '匭' => '匦', '匯' => '汇', '匱' => '匮',
    '區' => '区', '協' => '协', '卬' => '昂', '卹' => '恤',
    '卻' => '却', '厙' => '厍', '厭' => '厌', '厲' => '厉',
    '厴' => '厣', '參' => '参', '叢' => '丛', '吳' => '吴',
    '吶' => '呐', '呂' => '吕', '咷' => '啕', '員' => '员',
    '唄' => '呗', '唸' => '念', '問' => '问', '啞' => '哑',
    '啟' => '启', '啣' => '衔', '喚' => '唤', '喪' => '丧',
    '喫' => '吃', '喬' => '乔', '單' => '单', '喲' => '哟',
    '嗆' => '呛', '嗇' => '啬', '嗎' => '吗', '嗚' => '呜',
    '嗩' => '唢', '嗶' => '哔', '嘆' => '叹', '嘍' => '喽',
    '嘔' => '呕', '嘖' => '啧', '嘗' => '尝', '嘜' => '唛',
    '嘩' => '哗', '嘮' => '唠', '嘯' => '啸', '嘰' => '叽',
    '嘵' => '哓', '嘸' => '呒', '噁' => '恶', '噓' => '嘘',
    '噠' => '哒', '噥' => '哝', '噦' => '哕', '噯' => '嗳',
    '噲' => '哙', '噴' => '喷', '噸' => '吨', '嚀' => '咛',
    '嚇' => '吓', '嚌' => '哜', '嚐' => '尝', '嚕' => '噜',
    '嚙' => '啮', '嚦' => '呖', '嚨' => '咙', '嚮' => '向',
    '嚳' => '喾', '嚴' => '严', '嚶' => '嘤', '囀' => '啭',
    '囁' => '嗫', '囂' => '嚣', '囅' => '冁', '囈' => '呓',
    '囉' => '罗', '囌' => '苏', '囑' => '嘱', '囪' => '囱',
    '圇' => '囵', '國' => '国', '圍' => '围', '園' => '园',
    '圓' => '圆', '圖' => '图', '團' => '团', '坵' => '丘',
    '埡' => '垭', '執' => '执', '堅' => '坚', '堊' => '垩',
    '堝' => '埚', '堯' => '尧', '報' => '报', '場' => '场',
    '塊' => '块', '塋' => '茔', '塏' => '垲', '塒' => '埘',
    '塗' => '涂', '塚' => '冢', '塢' => '坞', '塤' => '埙',
    '塵' => '尘', '塹' => '堑', '墊' => '垫', '墜' => '坠',
    '墮' => '堕', '墳' => '坟', '墾' => '垦', '壇' => '坛',
    '壓' => '压', '壘' => '垒', '壙' => '圹', '壚' => '垆',
    '壞' => '坏', '壟' => '垄', '壢' => '坜', '壩' => '坝',
    '壯' => '壮', '壺' => '壶', '壽' => '寿', '夠' => '够',
    '夢' => '梦', '夾' => '夹', '奐' => '奂', '奧' => '奥',
    '奩' => '奁', '奪' => '夺', '奮' => '奋', '妝' => '妆',
    '姍' => '姗', '姦' => '奸', '姪' => '侄', '娛' => '娱',
    '婁' => '娄', '婦' => '妇', '婭' => '娅', '媧' => '娲',
    '媯' => '妫', '媼' => '媪', '媽' => '妈', '嫗' => '妪',
    '嫵' => '妩', '嫻' => '娴', '嬈' => '娆', '嬋' => '婵',
    '嬌' => '娇', '嬙' => '嫱', '嬡' => '嫒', '嬤' => '嬷',
    '嬪' => '嫔', '嬰' => '婴', '嬸' => '婶', '孃' => '娘',
    '孌' => '娈', '孫' => '孙', '學' => '学', '孿' => '孪',
    '宮' => '宫', '寢' => '寝', '實' => '实', '寧' => '宁',
    '審' => '审', '寫' => '写', '寬' => '宽', '寵' => '宠',
    '寶' => '宝', '將' => '将', '專' => '专', '尋' => '寻',
    '對' => '对', '導' => '导', '尷' => '尴', '屆' => '届',
    '屍' => '尸', '屜' => '屉', '屢' => '屡', '層' => '层',
    '屨' => '屦', '屬' => '属', '岡' => '冈', '峴' => '岘',
    '島' => '岛', '峽' => '峡', '崍' => '崃', '崑' => '昆',
    '崗' => '岗', '崙' => '仑', '崢' => '峥', '崳' => '嵛',
    '嵐' => '岚', '嶁' => '嵝', '嶄' => '崭', '嶇' => '岖',
    '嶗' => '崂', '嶠' => '峤', '嶧' => '峄', '嶸' => '嵘',
    '嶺' => '岭', '嶼' => '屿', '嶽' => '岳', '巋' => '岿',
    '巒' => '峦', '巔' => '巅', '巖' => '岩', '巹' => '卺',
    '帥' => '帅', '師' => '师', '帳' => '帐', '帶' => '带',
    '幀' => '帧', '幃' => '帏', '幗' => '帼', '幘' => '帻',
    '幟' => '帜', '幣' => '币', '幫' => '帮', '幬' => '帱',
    '幹' => '干', '幾' => '几', '庫' => '库', '廁' => '厕',
    '廂' => '厢', '廄' => '厩', '廈' => '厦', '廚' => '厨',
    '廟' => '庙', '廠' => '厂', '廡' => '庑', '廢' => '废',
    '廣' => '广', '廩' => '廪', '廬' => '庐', '廳' => '厅',
    '弒' => '弑', '弔' => '吊', '弳' => '弪', '張' => '张',
    '強' => '强', '彈' => '弹', '彌' => '弥', '彎' => '弯',
    '彙' => '汇', '彥' => '彦', '彫' => '雕', '彿' => '佛',
    '徑' => '径', '從' => '从', '徠' => '徕', '復' => '复',
    '徹' => '彻', '忷' => '汹', '恆' => '恒', '恟' => '汹',
    '恥' => '耻', '悅' => '悦', '悵' => '怅', '悶' => '闷',
    '悽' => '凄', '惇' => '敦', '惡' => '恶', '惱' => '恼',
    '惲' => '恽', '惻' => '恻', '愛' => '爱', '愜' => '惬',
    '愨' => '悫', '愴' => '怆', '愷' => '恺', '愾' => '忾',
    '慄' => '栗', '態' => '态', '慍' => '愠', '慘' => '惨',
    '慚' => '惭', '慟' => '恸', '慣' => '惯', '慪' => '怄',
    '慫' => '怂', '慮' => '虑', '慳' => '悭', '慶' => '庆',
    '慼' => '戚', '慾' => '欲', '憂' => '忧', '憊' => '惫',
    '憐' => '怜', '憑' => '凭', '憒' => '愦', '憚' => '惮',
    '憤' => '愤', '憫' => '悯', '憮' => '怃', '憲' => '宪',
    '憶' => '忆', '懇' => '恳', '應' => '应', '懌' => '怿',
    '懍' => '懔', '懟' => '怼', '懣' => '懑', '懨' => '恹',
    '懲' => '惩', '懶' => '懒', '懷' => '怀', '懸' => '悬',
    '懺' => '忏', '懼' => '惧', '懾' => '慑', '戀' => '恋',
    '戇' => '戆', '戔' => '戋', '戧' => '戗', '戩' => '戬',
    '戰' => '战', '戲' => '戏', '戶' => '户', '拋' => '抛',
    '挾' => '挟', '捨' => '舍', '捫' => '扪', '捲' => '卷',
    '掃' => '扫', '掄' => '抡', '掙' => '挣', '掛' => '挂',
    '採' => '采', '揀' => '拣', '揚' => '扬', '換' => '换',
    '揮' => '挥', '揹' => '背', '損' => '损', '搖' => '摇',
    '搗' => '捣', '搯' => '掏', '搶' => '抢', '摀' => '捂',
    '摑' => '掴', '摜' => '掼', '摟' => '搂', '摯' => '挚',
    '摳' => '抠', '摶' => '抟', '摻' => '掺', '撈' => '捞',
    '撐' => '撑', '撓' => '挠', '撚' => '捻', '撟' => '挢',
    '撣' => '掸', '撥' => '拨', '撫' => '抚', '撲' => '扑',
    '撳' => '揿', '撻' => '挞', '撾' => '挝', '撿' => '捡',
    '擁' => '拥', '擄' => '掳', '擇' => '择', '擊' => '击',
    '擋' => '挡', '擔' => '担', '據' => '据', '擠' => '挤',
    '擬' => '拟', '擯' => '摈', '擰' => '拧', '擱' => '搁',
    '擲' => '掷', '擴' => '扩', '擷' => '撷', '擺' => '摆',
    '擻' => '擞', '擼' => '撸', '擾' => '扰', '攄' => '摅',
    '攆' => '撵', '攏' => '拢', '攔' => '拦', '攖' => '撄',
    '攙' => '搀', '攛' => '撺', '攜' => '携', '攝' => '摄',
    '攢' => '攒', '攣' => '挛', '攤' => '摊', '攪' => '搅',
    '攬' => '揽', '敗' => '败', '敘' => '叙', '敵' => '敌',
    '數' => '数', '斂' => '敛', '斃' => '毙', '斕' => '斓',
    '斬' => '斩', '斷' => '断', '於' => '于', '昇' => '升',
    '時' => '时', '晉' => '晋', '晝' => '昼', '暈' => '晕',
    '暉' => '晖', '暢' => '畅', '暫' => '暂', '曄' => '晔',
    '曆' => '历', '曇' => '昙', '曉' => '晓', '曖' => '暧',
    '曠' => '旷', '曬' => '晒', '書' => '书', '會' => '会',
    '朧' => '胧', '朮' => '术', '東' => '东', '柵' => '栅',
    '桿' => '杆', '梔' => '栀', '條' => '条', '梟' => '枭',
    '棄' => '弃', '棖' => '枨', '棗' => '枣', '棟' => '栋',
    '棧' => '栈', '棲' => '栖', '椏' => '桠', '楄' => '匾',
    '楊' => '杨', '楓' => '枫', '楨' => '桢', '業' => '业',
    '極' => '极', '榐' => '搌', '榪' => '杩', '榮' => '荣',
    '榿' => '桤', '槃' => '盘', '構' => '构', '槍' => '枪',
    '槤' => '连', '槧' => '椠', '槨' => '椁', '槳' => '桨',
    '樁' => '桩', '樂' => '乐', '樅' => '枞', '樑' => '梁',
    '樓' => '楼', '標' => '标', '樞' => '枢', '樣' => '样',
    '樹' => '树', '樺' => '桦', '橈' => '桡', '橋' => '桥',
    '機' => '机', '橢' => '椭', '橫' => '横', '檁' => '檩',
    '檉' => '柽', '檔' => '档', '檜' => '桧', '檢' => '检',
    '檣' => '樯', '檳' => '槟', '檷' => '祢', '檸' => '柠',
    '檻' => '槛', '櫃' => '柜', '櫓' => '橹', '櫚' => '榈',
    '櫛' => '栉', '櫝' => '椟', '櫞' => '橼', '櫟' => '栎',
    '櫥' => '橱', '櫧' => '槠', '櫨' => '栌', '櫪' => '枥',
    '櫫' => '橥', '櫬' => '榇', '櫳' => '栊', '櫸' => '榉',
    '櫺' => '棂', '櫻' => '樱', '欄' => '栏', '權' => '权',
    '欏' => '椤', '欒' => '栾', '欖' => '榄', '欽' => '钦',
    '歎' => '叹', '歐' => '欧', '歟' => '欤', '歡' => '欢',
    '歲' => '岁', '歷' => '历', '歸' => '归', '歿' => '殁',
    '殘' => '残', '殞' => '殒', '殤' => '殇', '殫' => '殚',
    '殭' => '僵', '殮' => '殓', '殯' => '殡', '殲' => '歼',
    '殺' => '杀', '殼' => '壳', '殽' => '肴', '毀' => '毁',
    '毆' => '殴', '毿' => '毵', '氈' => '毡', '氌' => '氇',
    '氣' => '气', '氫' => '氢', '氬' => '氩', '氳' => '氲',
    '汆' => '氽', '汎' => '泛', '汙' => '污', '決' => '决',
    '沒' => '没', '沖' => '冲', '況' => '况', '洶' => '汹',
    '浹' => '浃', '涇' => '泾', '涼' => '凉', '淒' => '凄',
    '淚' => '泪', '淥' => '渌', '淨' => '净', '淪' => '沦',
    '淵' => '渊', '淶' => '涞', '淺' => '浅', '渙' => '涣',
    '減' => '减', '渦' => '涡', '測' => '测', '渾' => '浑',
    '湊' => '凑', '湞' => '浈', '湧' => '涌', '湯' => '汤',
    '溈' => '沩', '準' => '准', '溝' => '沟', '溫' => '温',
    '滄' => '沧', '滅' => '灭', '滌' => '涤', '滎' => '荥',
    '滬' => '沪', '滯' => '滞', '滲' => '渗', '滷' => '卤',
    '滸' => '浒', '滾' => '滚', '滿' => '满', '漁' => '渔',
    '漚' => '沤', '漢' => '汉', '漣' => '涟', '漬' => '渍',
    '漲' => '涨', '漵' => '溆', '漸' => '渐', '漿' => '浆',
    '潑' => '泼', '潔' => '洁', '潛' => '潜', '潤' => '润',
    '潯' => '浔', '潰' => '溃', '潷' => '滗', '潿' => '涠',
    '澀' => '涩', '澂' => '澄', '澆' => '浇', '澇' => '涝',
    '澗' => '涧', '澠' => '渑', '澤' => '泽', '澩' => '泶',
    '澮' => '浍', '澱' => '淀', '濁' => '浊', '濃' => '浓',
    '濕' => '湿', '濘' => '泞', '濛' => '蒙', '濟' => '济',
    '濤' => '涛', '濫' => '滥', '濰' => '潍', '濱' => '滨',
    '濺' => '溅', '濼' => '泺', '濾' => '滤', '瀅' => '滢',
    '瀆' => '渎', '瀉' => '泻', '瀋' => '渖', '瀏' => '浏',
    '瀕' => '濒', '瀘' => '泸', '瀝' => '沥', '瀟' => '潇',
    '瀠' => '潆', '瀦' => '潴', '瀧' => '泷', '瀨' => '濑',
    '瀰' => '弥', '瀲' => '潋', '瀾' => '澜', '灃' => '沣',
    '灄' => '滠', '灘' => '滩', '灝' => '灏', '灣' => '湾',
    '灤' => '滦', '灩' => '滟', '災' => '灾', '為' => '为',
    '烏' => '乌', '烴' => '烃', '無' => '无', '煉' => '炼',
    '煒' => '炜', '煙' => '烟', '煢' => '茕', '煥' => '焕',
    '煩' => '烦', '煬' => '炀', '熒' => '荧', '熱' => '热',
    '熾' => '炽', '燁' => '烨', '燄' => '焰', '燈' => '灯',
    '燉' => '炖', '燒' => '烧', '燙' => '烫', '燜' => '焖',
    '營' => '营', '燦' => '灿', '燬' => '毁', '燭' => '烛',
    '燴' => '烩', '燻' => '熏', '燼' => '烬', '燾' => '焘',
    '爍' => '烁', '爐' => '炉', '爛' => '烂', '爭' => '争',
    '爺' => '爷', '爾' => '尔', '牆' => '墙', '牘' => '牍',
    '牽' => '牵', '犖' => '荦', '犢' => '犊', '犧' => '牺',
    '狀' => '状', '狹' => '狭', '狽' => '狈', '猙' => '狰',
    '猶' => '犹', '猻' => '狲', '獃' => '呆', '獄' => '狱',
    '獅' => '狮', '獎' => '奖', '獨' => '独', '獪' => '狯',
    '獫' => '猃', '獰' => '狞', '獲' => '获', '獵' => '猎',
    '獷' => '犷', '獸' => '兽', '獺' => '獭', '獻' => '献',
    '獼' => '猕', '玀' => '猡', '玨' => '珏', '珮' => '佩',
    '現' => '现', '琺' => '珐', '琿' => '珲', '瑋' => '玮',
    '瑣' => '琐', '瑤' => '瑶', '瑩' => '莹', '瑪' => '玛',
    '瑯' => '琅', '璉' => '琏', '璣' => '玑', '璦' => '瑷',
    '環' => '环', '璽' => '玺', '瓊' => '琼', '瓏' => '珑',
    '瓔' => '璎', '瓚' => '瓒', '甌' => '瓯', '產' => '产',
    '甦' => '苏', '畝' => '亩', '畢' => '毕', '畫' => '画',
    '畬' => '畲', '異' => '异', '當' => '当', '疇' => '畴',
    '疊' => '叠', '痙' => '痉', '痺' => '痹', '瘋' => '疯',
    '瘍' => '疡', '瘓' => '痪', '瘞' => '瘗', '瘡' => '疮',
    '瘧' => '疟', '療' => '疗', '癆' => '痨', '癇' => '痫',
    '癉' => '瘅', '癒' => '愈', '癘' => '疠', '癟' => '瘪',
    '癡' => '痴', '癤' => '疖', '癩' => '癞', '癬' => '癣',
    '癭' => '瘿', '癮' => '瘾', '癰' => '痈', '癱' => '瘫',
    '癲' => '癫', '發' => '发', '皚' => '皑', '皸' => '皲',
    '皺' => '皱', '盜' => '盗', '盞' => '盏', '盡' => '尽',
    '監' => '监', '盤' => '盘', '盧' => '卢', '眾' => '众',
    '睏' => '困', '睜' => '睁', '睞' => '睐', '睪' => '睾',
    '瞇' => '眯', '瞞' => '瞒', '瞭' => '了', '瞼' => '睑',
    '矇' => '蒙', '矓' => '胧', '矚' => '瞩', '矯' => '矫',
    '砲' => '炮', '硃' => '朱', '硤' => '硖', '硨' => '砗',
    '硯' => '砚', '碩' => '硕', '碭' => '砀', '確' => '确',
    '碼' => '码', '磚' => '砖', '磣' => '碜', '磧' => '碛',
    '磯' => '矶', '磽' => '硗', '礎' => '础', '礙' => '碍',
    '礡' => '礴', '礦' => '矿', '礪' => '砺', '礫' => '砾',
    '礬' => '矾', '礱' => '砻', '祇' => '只', '祐' => '佑',
    '祕' => '秘', '祿' => '禄', '禍' => '祸', '禎' => '祯',
    '禦' => '御', '禪' => '禅', '禮' => '礼', '禱' => '祷',
    '禿' => '秃', '稅' => '税', '稈' => '秆', '稟' => '禀',
    '稨' => '扁', '種' => '种', '稱' => '称', '穀' => '谷',
    '穌' => '稣', '積' => '积', '穎' => '颖', '穡' => '穑',
    '穢' => '秽', '穩' => '稳', '穫' => '获', '窩' => '窝',
    '窪' => '洼', '窮' => '穷', '窯' => '窑', '窶' => '窭',
    '窺' => '窥', '竄' => '窜', '竅' => '窍', '竇' => '窦',
    '竊' => '窃', '競' => '竞', '筆' => '笔', '筍' => '笋',
    '筧' => '笕', '箋' => '笺', '箏' => '筝', '節' => '节',
    '築' => '筑', '篋' => '箧', '篤' => '笃', '篩' => '筛',
    '篳' => '筚', '簀' => '箦', '簍' => '篓', '簞' => '箪',
    '簡' => '简', '簣' => '篑', '簫' => '箫', '簷' => '檐',
    '簽' => '签', '籃' => '篮', '籌' => '筹', '籜' => '箨',
    '籟' => '籁', '籠' => '笼', '籤' => '签', '籩' => '笾',
    '籪' => '簖', '籬' => '篱', '籮' => '箩', '籲' => '吁',
    '粵' => '粤', '糝' => '糁', '糞' => '粪', '糧' => '粮',
    '糰' => '团', '糴' => '籴', '糾' => '纠', '紀' => '纪',
    '紂' => '纣', '約' => '约', '紅' => '红', '紆' => '纡',
    '紇' => '纥', '紈' => '纨', '紉' => '纫', '紋' => '纹',
    '納' => '纳', '紐' => '纽', '紓' => '纾', '純' => '纯',
    '紕' => '纰', '紗' => '纱', '紙' => '纸', '級' => '级',
    '紛' => '纷', '紜' => '纭', '紡' => '纺', '紮' => '扎',
    '細' => '细', '紱' => '绂', '紲' => '绁', '紳' => '绅',
    '紹' => '绍', '紺' => '绀', '紼' => '绋', '絀' => '绌',
    '終' => '终', '絃' => '弦', '組' => '组', '絆' => '绊',
    '絎' => '绗', '結' => '结', '絕' => '绝', '絛' => '绦',
    '絞' => '绞', '絡' => '络', '絢' => '绚', '給' => '给',
    '絨' => '绒', '統' => '统', '絲' => '丝', '絳' => '绛',
    '絹' => '绢', '綁' => '绑', '綃' => '绡', '綆' => '绠',
    '綈' => '绨', '綏' => '绥', '綑' => '困', '經' => '经',
    '綜' => '综', '綞' => '缍', '綠' => '绿', '綢' => '绸',
    '綣' => '绻', '綬' => '绶', '維' => '维', '綰' => '绾',
    '綱' => '纲', '網' => '网', '綴' => '缀', '綵' => '彩',
    '綸' => '纶', '綹' => '绺', '綺' => '绮', '綻' => '绽',
    '綽' => '绰', '綾' => '绫', '綿' => '绵', '緄' => '绲',
    '緇' => '缁', '緊' => '紧', '緋' => '绯', '緒' => '绪',
    '緗' => '缃', '緘' => '缄', '緙' => '缂', '線' => '线',
    '緝' => '缉', '緞' => '缎', '締' => '缔', '緡' => '缗',
    '緣' => '缘', '緦' => '缌', '編' => '编', '緩' => '缓',
    '緬' => '缅', '緯' => '纬', '緱' => '缑', '緲' => '缈',
    '練' => '练', '緶' => '缏', '緹' => '缇', '緻' => '致',
    '縈' => '萦', '縉' => '缙', '縊' => '缢', '縋' => '缒',
    '縐' => '绉', '縑' => '缣', '縛' => '缚', '縝' => '缜',
    '縞' => '缟', '縟' => '缛', '縣' => '县', '縫' => '缝',
    '縭' => '缡', '縮' => '缩', '縱' => '纵', '縲' => '缧',
    '縴' => '纤', '縵' => '缦', '縶' => '絷', '縷' => '缕',
    '縹' => '缥', '總' => '总', '績' => '绩', '繃' => '绷',
    '繅' => '缫', '繆' => '缪', '繒' => '缯', '織' => '织',
    '繕' => '缮', '繚' => '缭', '繞' => '绕', '繡' => '绣',
    '繢' => '缋', '繩' => '绳', '繪' => '绘', '繫' => '系',
    '繭' => '茧', '繯' => '缳', '繰' => '缲', '繳' => '缴',
    '繹' => '绎', '繼' => '继', '繽' => '缤', '繾' => '缱',
    '纈' => '缬', '纊' => '纩', '續' => '续', '纏' => '缠',
    '纓' => '缨', '纔' => '才', '纖' => '纤', '纘' => '缵',
    '纜' => '缆', '缽' => '钵', '罌' => '罂', '罰' => '罚',
    '罵' => '骂', '罷' => '罢', '羅' => '罗', '羆' => '罴',
    '羈' => '羁', '羋' => '芈', '羥' => '羟', '羨' => '羡',
    '義' => '义', '習' => '习', '翹' => '翘', '耑' => '专',
    '耬' => '耧', '聖' => '圣', '聞' => '闻', '聯' => '联',
    '聰' => '聪', '聲' => '声', '聳' => '耸', '聵' => '聩',
    '聶' => '聂', '職' => '职', '聹' => '聍', '聽' => '听',
    '聾' => '聋', '肅' => '肃', '胇' => '巯', '脅' => '胁',
    '脈' => '脉', '脛' => '胫', '脫' => '脱', '脹' => '胀',
    '腎' => '肾', '腡' => '脶', '腦' => '脑', '腫' => '肿',
    '腳' => '脚', '腸' => '肠', '膃' => '腽', '膆' => '嗉',
    '膚' => '肤', '膠' => '胶', '膩' => '腻', '膽' => '胆',
    '膾' => '脍', '膿' => '脓', '臉' => '脸', '臍' => '脐',
    '臏' => '膑', '臘' => '腊', '臚' => '胪', '臟' => '脏',
    '臠' => '脔', '臥' => '卧', '臨' => '临', '與' => '与',
    '興' => '兴', '舉' => '举', '舊' => '旧', '舋' => '衅',
    '舖' => '铺', '艙' => '舱', '艤' => '舣', '艦' => '舰',
    '艫' => '舻', '艱' => '艰', '艷' => '艳', '芻' => '刍',
    '苧' => '苎', '茲' => '兹', '荊' => '荆', '荳' => '豆',
    '莊' => '庄', '莖' => '茎', '莢' => '荚', '莧' => '苋',
    '華' => '华', '萇' => '苌', '萊' => '莱', '萬' => '万',
    '萵' => '莴', '萹' => '扁', '葉' => '叶', '葒' => '荭',
    '著' => '着', '葦' => '苇', '葷' => '荤', '蒔' => '莳',
    '蒞' => '莅', '蒼' => '苍', '蓀' => '荪', '蓆' => '席',
    '蓋' => '盖', '蓮' => '莲', '蓯' => '苁', '蓽' => '荜',
    '蔔' => '卜', '蔞' => '蒌', '蔣' => '蒋', '蔥' => '葱',
    '蔦' => '茑', '蔭' => '荫', '蕆' => '蒇', '蕎' => '荞',
    '蕕' => '莸', '蕘' => '荛', '蕢' => '蒉', '蕩' => '荡',
    '蕪' => '芜', '蕭' => '萧', '蕷' => '蓣', '薈' => '荟',
    '薊' => '蓟', '薌' => '芗', '薑' => '姜', '薔' => '蔷',
    '薙' => '剃', '薦' => '荐', '薩' => '萨', '薺' => '荠',
    '藍' => '蓝', '藎' => '荩', '藝' => '艺', '藥' => '药',
    '藪' => '薮', '藶' => '苈', '藹' => '蔼', '藺' => '蔺',
    '蘄' => '蕲', '蘆' => '芦', '蘇' => '苏', '蘊' => '蕴',
    '蘋' => '苹', '蘚' => '藓', '蘞' => '蔹', '蘢' => '茏',
    '蘭' => '兰', '蘺' => '蓠', '蘿' => '萝', '處' => '处',
    '虛' => '虚', '虜' => '虏', '號' => '号', '虧' => '亏',
    '虯' => '虬', '蛺' => '蛱', '蛻' => '蜕', '蜆' => '蚬',
    '蝕' => '蚀', '蝦' => '虾', '蝸' => '蜗', '螄' => '蛳',
    '螞' => '蚂', '螢' => '萤', '螻' => '蝼', '蟄' => '蛰',
    '蟈' => '蝈', '蟣' => '虮', '蟬' => '蝉', '蟯' => '蛲',
    '蟲' => '虫', '蟶' => '蛏', '蟻' => '蚁', '蠅' => '蝇',
    '蠆' => '虿', '蠍' => '蝎', '蠐' => '蛴', '蠑' => '蝾',
    '蠟' => '蜡', '蠣' => '蛎', '蠱' => '蛊', '蠶' => '蚕',
    '蠷' => '蠼', '蠻' => '蛮', '衒' => '炫', '術' => '术',
    '衛' => '卫', '衝' => '冲', '袞' => '衮', '裊' => '袅',
    '裏' => '里', '補' => '补', '裝' => '装', '裡' => '里',
    '製' => '制', '複' => '复', '褲' => '裤', '褳' => '裢',
    '褸' => '褛', '褻' => '亵', '襉' => '裥', '襖' => '袄',
    '襝' => '裣', '襠' => '裆', '襤' => '褴', '襪' => '袜',
    '襯' => '衬', '襲' => '袭', '見' => '见', '規' => '规',
    '覓' => '觅', '視' => '视', '覘' => '觇', '覡' => '觋',
    '覦' => '觎', '親' => '亲', '覬' => '觊', '覯' => '觏',
    '覲' => '觐', '覷' => '觑', '覺' => '觉', '覽' => '览',
    '覿' => '觌', '觀' => '观', '觴' => '觞', '觶' => '觯',
    '觸' => '触', '訂' => '订', '訃' => '讣', '計' => '计',
    '訊' => '讯', '訌' => '讧', '討' => '讨', '訐' => '讦',
    '訓' => '训', '訕' => '讪', '訖' => '讫', '託' => '托',
    '記' => '记', '訛' => '讹', '訝' => '讶', '訟' => '讼',
    '訢' => '欣', '訣' => '诀', '訥' => '讷', '訪' => '访',
    '設' => '设', '許' => '许', '訴' => '诉', '訶' => '诃',
    '診' => '诊', '註' => '注', '証' => '证', '詁' => '诂',
    '詆' => '诋', '詎' => '讵', '詐' => '诈', '詒' => '诒',
    '詔' => '诏', '評' => '评', '詛' => '诅', '詞' => '词',
    '詠' => '咏', '詡' => '诩', '詢' => '询', '詣' => '诣',
    '試' => '试', '詩' => '诗', '詫' => '诧', '詬' => '诟',
    '詭' => '诡', '詮' => '诠', '詰' => '诘', '話' => '话',
    '該' => '该', '詳' => '详', '詵' => '诜', '詼' => '诙',
    '詿' => '诖', '誄' => '诔', '誅' => '诛', '誆' => '诓',
    '誇' => '夸', '誌' => '志', '認' => '认', '誑' => '诳',
    '誒' => '诶', '誕' => '诞', '誘' => '诱', '誚' => '诮',
    '語' => '语', '誠' => '诚', '誡' => '诫', '誣' => '诬',
    '誤' => '误', '誥' => '诰', '誦' => '诵', '誨' => '诲',
    '說' => '说', '誰' => '谁', '課' => '课', '誶' => '谇',
    '誹' => '诽', '誼' => '谊', '調' => '调', '諂' => '谄',
    '諄' => '谆', '談' => '谈', '諉' => '诿', '請' => '请',
    '諍' => '诤', '諏' => '诹', '諑' => '诼', '諒' => '谅',
    '論' => '论', '諗' => '谂', '諛' => '谀', '諜' => '谍',
    '諞' => '谝', '諠' => '喧', '諢' => '诨', '諤' => '谔',
    '諦' => '谛', '諧' => '谐', '諫' => '谏', '諭' => '谕',
    '諮' => '谘', '諱' => '讳', '諳' => '谙', '諶' => '谌',
    '諷' => '讽', '諸' => '诸', '諺' => '谚', '諼' => '谖',
    '諾' => '诺', '謀' => '谋', '謁' => '谒', '謂' => '谓',
    '謄' => '誊', '謅' => '诌', '謊' => '谎', '謎' => '谜',
    '謐' => '谧', '謔' => '谑', '謖' => '谡', '謗' => '谤',
    '謙' => '谦', '謚' => '谥', '講' => '讲', '謝' => '谢',
    '謠' => '谣', '謨' => '谟', '謫' => '谪', '謬' => '谬',
    '謳' => '讴', '謹' => '谨', '謾' => '谩', '譁' => '哗',
    '證' => '证', '譎' => '谲', '譏' => '讥', '譔' => '撰',
    '譖' => '谮', '識' => '识', '譙' => '谯', '譚' => '谭',
    '譜' => '谱', '譟' => '噪', '譫' => '谵', '譭' => '毁',
    '譯' => '译', '議' => '议', '譴' => '谴', '護' => '护',
    '譽' => '誉', '譾' => '谫', '讀' => '读', '變' => '变',
    '讌' => '宴', '讎' => '雠', '讒' => '谗', '讓' => '让',
    '讕' => '谰', '讖' => '谶', '讚' => '赞', '讜' => '谠',
    '讞' => '谳', '谿' => '溪', '豈' => '岂', '豎' => '竖',
    '豐' => '丰', '豬' => '猪', '貓' => '猫', '貝' => '贝',
    '貞' => '贞', '負' => '负', '財' => '财', '貢' => '贡',
    '貧' => '贫', '貨' => '货', '販' => '贩', '貪' => '贪',
    '貫' => '贯', '責' => '责', '貯' => '贮', '貰' => '贳',
    '貲' => '赀', '貳' => '贰', '貴' => '贵', '貶' => '贬',
    '買' => '买', '貸' => '贷', '貺' => '贶', '費' => '费',
    '貼' => '贴', '貽' => '贻', '貿' => '贸', '賀' => '贺',
    '賁' => '贲', '賂' => '赂', '賃' => '赁', '賄' => '贿',
    '賅' => '赅', '資' => '资', '賈' => '贾', '賊' => '贼',
    '賑' => '赈', '賒' => '赊', '賓' => '宾', '賕' => '赇',
    '賙' => '周', '賚' => '赉', '賜' => '赐', '賞' => '赏',
    '賠' => '赔', '賡' => '赓', '賢' => '贤', '賣' => '卖',
    '賤' => '贱', '賦' => '赋', '賧' => '赕', '質' => '质',
    '賬' => '账', '賭' => '赌', '賴' => '赖', '賺' => '赚',
    '賻' => '赙', '購' => '购', '賽' => '赛', '賾' => '赜',
    '贄' => '贽', '贅' => '赘', '贈' => '赠', '贊' => '赞',
    '贍' => '赡', '贏' => '赢', '贐' => '赆', '贓' => '赃',
    '贖' => '赎', '贗' => '赝', '贛' => '赣', '趕' => '赶',
    '趙' => '赵', '趨' => '趋', '趲' => '趱', '跡' => '迹',
    '踐' => '践', '踰' => '逾', '踴' => '踊', '蹌' => '跄',
    '蹕' => '跸', '蹟' => '迹', '蹣' => '蹒', '蹤' => '踪',
    '蹧' => '糟', '蹺' => '跷', '躉' => '趸', '躊' => '踌',
    '躋' => '跻', '躍' => '跃', '躑' => '踯', '躒' => '跞',
    '躓' => '踬', '躕' => '蹰', '躚' => '跹', '躡' => '蹑',
    '躥' => '蹿', '躦' => '躜', '躪' => '躏', '軀' => '躯',
    '車' => '车', '軋' => '轧', '軌' => '轨', '軍' => '军',
    '軒' => '轩', '軔' => '轫', '軛' => '轭', '軟' => '软',
    '軫' => '轸', '軸' => '轴', '軹' => '轵', '軺' => '轺',
    '軻' => '轲', '軼' => '轶', '軾' => '轼', '較' => '较',
    '輅' => '辂', '輇' => '辁', '載' => '载', '輊' => '轾',
    '輒' => '辄', '輓' => '挽', '輔' => '辅', '輕' => '轻',
    '輛' => '辆', '輜' => '辎', '輝' => '辉', '輞' => '辋',
    '輟' => '辍', '輥' => '辊', '輦' => '辇', '輩' => '辈',
    '輪' => '轮', '輯' => '辑', '輳' => '辏', '輸' => '输',
    '輻' => '辐', '輾' => '辗', '輿' => '舆', '轂' => '毂',
    '轄' => '辖', '轅' => '辕', '轆' => '辘', '轉' => '转',
    '轍' => '辙', '轎' => '轿', '轔' => '辚', '轟' => '轰',
    '轡' => '辔', '轢' => '轹', '轤' => '轳', '辦' => '办',
    '辭' => '辞', '辮' => '辫', '辯' => '辩', '農' => '农',
    '逕' => '迳', '這' => '这', '連' => '连', '週' => '周',
    '進' => '进', '遊' => '游', '運' => '运', '過' => '过',
    '達' => '达', '違' => '违', '遙' => '遥', '遜' => '逊',
    '遞' => '递', '遠' => '远', '適' => '适', '遲' => '迟',
    '遷' => '迁', '選' => '选', '遺' => '遗', '遼' => '辽',
    '邁' => '迈', '還' => '还', '邇' => '迩', '邊' => '边',
    '邏' => '逻', '邐' => '逦', '郟' => '郏', '郵' => '邮',
    '鄆' => '郓', '鄉' => '乡', '鄒' => '邹', '鄔' => '邬',
    '鄖' => '郧', '鄧' => '邓', '鄭' => '郑', '鄰' => '邻',
    '鄲' => '郸', '鄴' => '邺', '鄶' => '郐', '鄺' => '邝',
    '酈' => '郦', '醃' => '腌', '醆' => '盏', '醜' => '丑',
    '醞' => '酝', '醫' => '医', '醬' => '酱', '釀' => '酿',
    '釃' => '酾', '釅' => '酽', '釋' => '释', '釓' => '钆',
    '釔' => '钇', '釕' => '钌', '釗' => '钊', '釘' => '钉',
    '釙' => '钋', '針' => '针', '釣' => '钓', '釤' => '钐',
    '釦' => '扣', '釧' => '钏', '釩' => '钒', '釵' => '钗',
    '釷' => '钍', '釹' => '钕', '鈀' => '钯', '鈁' => '钫',
    '鈄' => '钭', '鈉' => '钠', '鈍' => '钝', '鈐' => '钤',
    '鈑' => '钣', '鈔' => '钞', '鈕' => '钮', '鈞' => '钧',
    '鈣' => '钙', '鈥' => '钬', '鈦' => '钛', '鈧' => '钪',
    '鈮' => '铌', '鈰' => '铈', '鈳' => '钶', '鈴' => '铃',
    '鈷' => '钴', '鈸' => '钹', '鈹' => '铍', '鈺' => '钰',
    '鈽' => '钸', '鈾' => '铀', '鈿' => '钿', '鉀' => '钾',
    '鉅' => '钜', '鉈' => '铊', '鉉' => '铉', '鉋' => '刨',
    '鉍' => '铋', '鉑' => '铂', '鉗' => '钳', '鉚' => '铆',
    '鉛' => '铅', '鉞' => '钺', '鉤' => '钩', '鉦' => '钲',
    '鉬' => '钼', '鉭' => '钽', '鉸' => '铰', '鉺' => '铒',
    '鉻' => '铬', '鉿' => '铪', '銀' => '银', '銃' => '铳',
    '銅' => '铜', '銑' => '铣', '銓' => '铨', '銖' => '铢',
    '銘' => '铭', '銚' => '铫', '銜' => '衔', '銠' => '铑',
    '銣' => '铷', '銥' => '铱', '銦' => '铟', '銨' => '铵',
    '銩' => '铥', '銪' => '铕', '銫' => '铯', '銬' => '铐',
    '銲' => '焊', '銳' => '锐', '銷' => '销', '銻' => '锑',
    '銼' => '锉', '鋁' => '铝', '鋃' => '锒', '鋅' => '锌',
    '鋇' => '钡', '鋌' => '铤', '鋏' => '铗', '鋒' => '锋',
    '鋝' => '锊', '鋟' => '锓', '鋤' => '锄', '鋦' => '锔',
    '鋨' => '锇', '鋪' => '铺', '鋮' => '铖', '鋯' => '锆',
    '鋰' => '锂', '鋱' => '铽', '鋸' => '锯', '鋼' => '钢',
    '錁' => '锞', '錄' => '录', '錆' => '锖', '錈' => '锩',
    '錐' => '锥', '錒' => '锕', '錕' => '锟', '錘' => '锤',
    '錙' => '锱', '錚' => '铮', '錛' => '锛', '錟' => '锬',
    '錠' => '锭', '錢' => '钱', '錦' => '锦', '錨' => '锚',
    '錫' => '锡', '錮' => '锢', '錯' => '错', '錳' => '锰',
    '錸' => '铼', '鍆' => '钔', '鍇' => '锴', '鍊' => '炼',
    '鍋' => '锅', '鍍' => '镀', '鍔' => '锷', '鍘' => '铡',
    '鍛' => '锻', '鍤' => '锸', '鍥' => '锲', '鍬' => '锹',
    '鍰' => '锾', '鍵' => '键', '鍶' => '锶', '鍺' => '锗',
    '鍼' => '针', '鍾' => '锺', '鎂' => '镁', '鎊' => '镑',
    '鎖' => '锁', '鎗' => '枪', '鎘' => '镉', '鎢' => '钨',
    '鎦' => '镏', '鎧' => '铠', '鎩' => '铩', '鎪' => '锼',
    '鎬' => '镐', '鎮' => '镇', '鎰' => '镒', '鎳' => '镍',
    '鎵' => '镓', '鏃' => '镞', '鏇' => '镟', '鏈' => '链',
    '鏌' => '镆', '鏍' => '镙', '鏑' => '镝', '鏗' => '铿',
    '鏘' => '锵', '鏜' => '镗', '鏝' => '镘', '鏞' => '镛',
    '鏟' => '铲', '鏡' => '镜', '鏢' => '镖', '鏤' => '镂',
    '鏨' => '錾', '鏵' => '铧', '鏷' => '镤', '鏹' => '镪',
    '鏽' => '锈', '鐃' => '铙', '鐋' => '铴', '鐐' => '镣',
    '鐒' => '铹', '鐓' => '镦', '鐔' => '镡', '鐘' => '钟',
    '鐙' => '镫', '鐠' => '镨', '鐫' => '镌', '鐮' => '镰',
    '鐲' => '镯', '鐳' => '镭', '鐵' => '铁', '鐸' => '铎',
    '鐺' => '铛', '鐿' => '镱', '鑄' => '铸', '鑊' => '镬',
    '鑌' => '镔', '鑒' => '鉴', '鑠' => '铄', '鑣' => '镳',
    '鑭' => '镧', '鑰' => '钥', '鑲' => '镶', '鑷' => '镊',
    '鑼' => '锣', '鑽' => '钻', '鑾' => '銮', '鑿' => '凿',
    '長' => '长', '門' => '门', '閂' => '闩', '閃' => '闪',
    '閆' => '闫', '閉' => '闭', '開' => '开', '閌' => '闶',
    '閎' => '闳', '閏' => '闰', '閑' => '闲', '間' => '间',
    '閔' => '闵', '閘' => '闸', '閡' => '阂', '閣' => '阁',
    '閤' => '阖', '閥' => '阀', '閨' => '闺', '閩' => '闽',
    '閫' => '阃', '閬' => '阆', '閭' => '闾', '閱' => '阅',
    '閶' => '阊', '閹' => '阉', '閻' => '阎', '閼' => '阏',
    '閽' => '阍', '閾' => '阈', '閿' => '阌', '闃' => '阒',
    '闆' => '板', '闇' => '暗', '闈' => '闱', '闊' => '阔',
    '闋' => '阕', '闌' => '阑', '闐' => '阗', '闔' => '阖',
    '闕' => '阙', '闖' => '闯', '關' => '关', '闞' => '阚',
    '闡' => '阐', '闢' => '辟', '闥' => '闼', '陘' => '陉',
    '陝' => '陕', '陞' => '升', '陣' => '阵', '陰' => '阴',
    '陳' => '陈', '陸' => '陆', '陽' => '阳', '隄' => '堤',
    '隉' => '陧', '隊' => '队', '階' => '阶', '隕' => '陨',
    '際' => '际', '隨' => '随', '險' => '险', '隱' => '隐',
    '隴' => '陇', '隸' => '隶', '隻' => '只', '雋' => '隽',
    '雖' => '虽', '雙' => '双', '雛' => '雏', '雜' => '杂',
    '雞' => '鸡', '離' => '离', '難' => '难', '雲' => '云',
    '電' => '电', '霑' => '沾', '霧' => '雾', '霽' => '霁',
    '靂' => '雳', '靄' => '霭', '靈' => '灵', '靚' => '靓',
    '靜' => '静', '靨' => '靥', '鞏' => '巩', '鞦' => '秋',
    '韃' => '鞑', '韆' => '千', '韉' => '鞯', '韋' => '韦',
    '韌' => '韧', '韓' => '韩', '韙' => '韪', '韜' => '韬',
    '韞' => '韫', '韻' => '韵', '響' => '响', '頁' => '页',
    '頂' => '顶', '頃' => '顷', '項' => '项', '順' => '顺',
    '頇' => '顸', '須' => '须', '頊' => '顼', '頌' => '颂',
    '頎' => '颀', '頏' => '颃', '預' => '预', '頑' => '顽',
    '頒' => '颁', '頓' => '顿', '頗' => '颇', '領' => '领',
    '頜' => '颌', '頡' => '颉', '頤' => '颐', '頦' => '颏',
    '頭' => '头', '頰' => '颊', '頷' => '颔', '頸' => '颈',
    '頹' => '颓', '頻' => '频', '顆' => '颗', '題' => '题',
    '額' => '额', '顎' => '颚', '顏' => '颜', '顓' => '颛',
    '願' => '愿', '顙' => '颡', '顛' => '颠', '類' => '类',
    '顢' => '颟', '顥' => '颢', '顧' => '顾', '顫' => '颤',
    '顯' => '显', '顰' => '颦', '顱' => '颅', '顳' => '颞',
    '顴' => '颧', '風' => '风', '颮' => '飑', '颯' => '飒',
    '颳' => '刮', '颶' => '飓', '颼' => '飕', '飄' => '飘',
    '飆' => '飙', '飛' => '飞', '飢' => '饥', '飩' => '饨',
    '飪' => '饪', '飫' => '饫', '飭' => '饬', '飯' => '饭',
    '飲' => '饮', '飴' => '饴', '飼' => '饲', '飽' => '饱',
    '飾' => '饰', '餃' => '饺', '餅' => '饼', '餉' => '饷',
    '養' => '养', '餌' => '饵', '餑' => '饽', '餒' => '馁',
    '餓' => '饿', '餔' => '哺', '餘' => '馀', '餚' => '肴',
    '餛' => '馄', '餞' => '饯', '餡' => '馅', '館' => '馆',
    '餳' => '饧', '餵' => '喂', '餼' => '饩', '餾' => '馏',
    '餿' => '馊', '饃' => '馍', '饅' => '馒', '饈' => '馐',
    '饉' => '馑', '饋' => '馈', '饌' => '馔', '饑' => '饥',
    '饒' => '饶', '饗' => '飨', '饜' => '餍', '饞' => '馋',
    '饟' => '饷', '馬' => '马', '馭' => '驭', '馮' => '冯',
    '馱' => '驮', '馳' => '驰', '馴' => '驯', '駁' => '驳',
    '駐' => '驻', '駑' => '驽', '駒' => '驹', '駔' => '驵',
    '駕' => '驾', '駘' => '骀', '駙' => '驸', '駛' => '驶',
    '駝' => '驼', '駟' => '驷', '駢' => '骈', '駭' => '骇',
    '駮' => '驳', '駱' => '骆', '駿' => '骏', '騁' => '骋',
    '騅' => '骓', '騍' => '骒', '騎' => '骑', '騏' => '骐',
    '騖' => '骛', '騙' => '骗', '騫' => '骞', '騭' => '骘',
    '騮' => '骝', '騰' => '腾', '騶' => '驺', '騷' => '骚',
    '騸' => '骟', '騾' => '骡', '驀' => '蓦', '驁' => '骜',
    '驂' => '骖', '驃' => '骠', '驄' => '骢', '驅' => '驱',
    '驊' => '骅', '驍' => '骁', '驏' => '骣', '驕' => '骄',
    '驗' => '验', '驚' => '惊', '驛' => '驿', '驟' => '骤',
    '驢' => '驴', '驤' => '骧', '驥' => '骥', '驪' => '骊',
    '骯' => '肮', '髏' => '髅', '髒' => '脏', '體' => '体',
    '髕' => '髌', '髖' => '髋', '髮' => '发', '鬆' => '松',
    '鬍' => '胡', '鬚' => '须', '鬢' => '鬓', '鬥' => '斗',
    '鬧' => '闹', '鬨' => '哄', '鬮' => '阄', '鬱' => '郁',
    '魎' => '魉', '魘' => '魇', '魚' => '鱼', '魯' => '鲁',
    '魴' => '鲂', '魷' => '鱿', '鮐' => '鲐', '鮑' => '鲍',
    '鮒' => '鲋', '鮚' => '鲒', '鮞' => '鲕', '鮪' => '鲔',
    '鮫' => '鲛', '鮮' => '鲜', '鯀' => '鲧', '鯁' => '鲠',
    '鯇' => '鲩', '鯉' => '鲤', '鯊' => '鲨', '鯔' => '鲻',
    '鯖' => '鲭', '鯗' => '鲞', '鯛' => '鲷', '鯡' => '鲱',
    '鯢' => '鲵', '鯤' => '鲲', '鯧' => '鲳', '鯨' => '鲸',
    '鯪' => '鲮', '鯫' => '鲰', '鯰' => '鲶', '鯽' => '鲫',
    '鰈' => '鲽', '鰉' => '鳇', '鰍' => '鳅', '鰒' => '鳆',
    '鰓' => '鳃', '鰣' => '鲥', '鰥' => '鳏', '鰨' => '鳎',
    '鰩' => '鳐', '鰭' => '鳍', '鰱' => '鲢', '鰲' => '鳌',
    '鰳' => '鳓', '鰷' => '鲦', '鰹' => '鲣', '鰻' => '鳗',
    '鰾' => '鳔', '鱈' => '鳕', '鱉' => '鳖', '鱍' => '鲅',
    '鱒' => '鳟', '鱔' => '鳝', '鱖' => '鳜', '鱗' => '鳞',
    '鱘' => '鲟', '鱟' => '鲎', '鱧' => '鳢', '鱭' => '鲚',
    '鱷' => '鳄', '鱸' => '鲈', '鱺' => '鲡', '鳥' => '鸟',
    '鳧' => '凫', '鳩' => '鸠', '鳳' => '凤', '鳴' => '鸣',
    '鳶' => '鸢', '鴆' => '鸩', '鴇' => '鸨', '鴉' => '鸦',
    '鴕' => '鸵', '鴛' => '鸳', '鴝' => '鸲', '鴟' => '鸱',
    '鴣' => '鸪', '鴦' => '鸯', '鴨' => '鸭', '鴯' => '鸸',
    '鴰' => '鸹', '鴻' => '鸿', '鴿' => '鸽', '鵂' => '鸺',
    '鵑' => '鹃', '鵒' => '鹆', '鵓' => '鹁', '鵜' => '鹈',
    '鵝' => '鹅', '鵠' => '鹄', '鵡' => '鹉', '鵪' => '鹌',
    '鵬' => '鹏', '鵯' => '鹎', '鵰' => '雕', '鵲' => '鹊',
    '鶇' => '鸫', '鶉' => '鹑', '鶘' => '鹕', '鶚' => '鹗',
    '鶯' => '莺', '鶴' => '鹤', '鶻' => '鹘', '鶼' => '鹣',
    '鷂' => '鹞', '鷓' => '鹧', '鷗' => '鸥', '鷙' => '鸷',
    '鷚' => '鹨', '鷥' => '鸶', '鷦' => '鹪', '鷯' => '鹩',
    '鷲' => '鹫', '鷴' => '鹇', '鷸' => '鹬', '鷹' => '鹰',
    '鷺' => '鹭', '鸕' => '鸬', '鸚' => '鹦', '鸛' => '鹳',
    '鸝' => '鹂', '鸞' => '鸾', '鹵' => '卤', '鹹' => '咸',
    '鹺' => '鹾', '鹼' => '硷', '鹽' => '盐', '麗' => '丽',
    '麥' => '麦', '麩' => '麸', '麵' => '面', '麼' => '麽',
    '黃' => '黄', '黌' => '黉', '點' => '点', '黨' => '党',
    '黲' => '黪', '黷' => '黩', '黽' => '黾', '黿' => '鼋',
    '鼉' => '鼍', '鼴' => '鼹', '齊' => '齐', '齋' => '斋',
    '齏' => '齑', '齒' => '齿', '齔' => '龀', '齙' => '龅',
    '齜' => '龇', '齟' => '龃', '齠' => '龆', '齡' => '龄',
    '齦' => '龈', '齪' => '龊', '齬' => '龉', '齲' => '龋',
    '齷' => '龌', '龍' => '龙', '龐' => '庞', '龔' => '龚',
    '龕' => '龛', '龜' => '龟');

1;

__END__

=head1 NAME

Lingua::ZH::CEDICT::HanConvert - Maps traditional to simplified Chinese characters

=head1 SYNOPSIS

  use Lingua::ZH::HanConvert qw (simple);

  my $simp = simple($text);

=head1 DESCRIPTION

This module is specially adapted to the purposes of L<Lingua::ZH::CEDICT|Lingua::ZH::CEDICT>, therefore it might or might not suit yours. It uses the conversion table shipped with HanZi converter 3.0.

=head1 METHODS

=over 4

=item C<simple($text)>

Maps traditional Chinese characters to simplified equivalents. Performs one-to-one mapping. Leaves unknown characters alone.

=back

=head1 AUTHOR

Christian Renz, E<lt>crenz@web42.comE<gt>

=head1 LICENSE

Copyright (C) 2002 Christian Renz. This program is free software; you can redistribute it and/or modify it under the same terms as Perl itself.

Portions of this software (that is, the conversion table) derived from Hanzi Converter 3.0, copyrighted 1988-1993 by Fung Fung Lee and Ricky Yeung. See L<http://umunhum.stanford.edu/~lee/chicomp/HC-license.html>.

=head1 SEE ALSO

L<Lingua::ZH::CEDICT>.

=cut
