use 5.16.0;
use strict;
use warnings;

package Map::Metro::Plugin::Map::Helsinki  {

    our $VERSION = '0.1984'; # VERSION
    # ABSTRACT: Map::Metro map for Helsinki

    use Moose;
    with 'Map::Metro::Plugin::Map';

    has '+mapfile' => (
        default => 'map-helsinki.metro',
    );
    sub map_version {
        return $VERSION;
    }
    sub map_package {
        return __PACKAGE__;
    }
}


1;

__END__

=pod

=encoding utf-8

=head1 NAME

Map::Metro::Plugin::Map::Helsinki - Map::Metro map for Helsinki

=head1 VERSION

Version 0.1984, released 2015-01-16.

=head1 SYNOPSIS

    use Map::Metro;
    my $graph = Map::Metro->new('Helsinki')->parse;

    my $graph2 = Map::Metro->new('Helsinki', hooks => 'Helsinki::Swedish')->parse;
    # now the station names are in Swedish

=head1 DESCRIPTION

See L<Map::Metro> for usage information.

This distribution also includes the C<Map::Metro::Plugin::Hook::Helsinki::Swedish> hook, which if applied
translates all station names into Swedish.

=head1 Status

See L<Map::Metro::Plugin::Map::Helsinki::Lines>

This map includes:

=over 4

=item *

The two branches of the Helsinki metro [L<wikipedia|https://en.wikipedia.org/wiki/Helsinki_Metro>]

=back

=for HTML <p><a href="https://raw.githubusercontent.com/Csson/p5-Map-Metro-Helsinki/master/static/images/helsinki.png"><img src="https://raw.githubusercontent.com/Csson/p5-Map-Metro-Helsinki/master/static/images/helsinki.png" style="max-width: 600px" /></a></p>

=head1 SOURCE

L<https://github.com/Csson/p5-Map-Metro-Helsinki>

=head1 HOMEPAGE

L<https://metacpan.org/release/Map-Metro-Plugin-Map-Helsinki>

=head1 AUTHOR

Erik Carlsson <info@code301.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by Erik Carlsson <info@code301.com>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
