#!/usr/local/bin/perl

# This is for generating the perldoc executable.
# It may eventually be expanded to generate many executables, as
# explained in the preface of /Programming Perl/ 3e.

require 5;
use strict;
use Config;
use File::Basename qw(&basename &dirname);
use Cwd;

# List explicitly here the variables you want Configure to
# generate.  Metaconfig only looks for shell variables, so you
# have to mention them as if they were shell variables, not
# %Config entries.  Thus you write
#  $startperl
# to ensure Configure will look for $Config{startperl}.

# This forces PL files to create target in same directory as PL file.
# This is so that make depend always knows where to find PL derivatives.

my $origdir = cwd;
chdir dirname($0);
my $file = basename($0, '.PL');
my $file_shortname = $file;  # should be like "perldoc", maybe "perlsyn", etc.
warn "How odd, I'm going to generate $file_shortname?!"
 unless $file_shortname =~ m/^\w+$/;

$file .= '.com' if $^O eq 'VMS';

open OUT,">$file" or die "Can't create $file: $!";

print "Extracting \"$file\" (with variable substitutions)\n";

# In this section, perl variables will be expanded during extraction.
# You can use $Config{...} to use Configure variables.

print OUT <<"!GROK!THIS!";
$Config{startperl}
    eval 'exec $Config{perlpath} -S \$0 \${1+"\$@"}'
	if 0;

# This "$file" file was generated by "$0"

require 5;
use Pod::Perldoc;
BEGIN { \$^W = 1 if \$ENV{'PERLDOCDEBUG'} }
exit( Pod::Perldoc->run() );

!GROK!THIS!


close OUT or die "Can't close $file: $!";
chmod 0755, $file or die "Can't reset permissions for $file: $!\n";
exec("$Config{'eunicefix'} $file") if $Config{'eunicefix'} ne ':';
chdir $origdir;

