#!/usr/bin/perl

package eBay::API::XML::Call::AddOrder::AddOrderResponseType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. AddOrderResponseType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::AddOrder::AddOrderResponseType

=head1 DESCRIPTION

Returns a unique identifier for the order. A buyer may make a single
payment to purchase all of the item transactions that are included
in the order.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::AddOrder::AddOrderResponseType inherits from the L<eBay::API::XML::ResponseDataType> class

=cut

use eBay::API::XML::ResponseDataType;
our @ISA = ("eBay::API::XML::ResponseDataType");

use eBay::API::XML::DataType::OrderIDType;


my @gaProperties = ( [ 'CreatedTime', 'xs:dateTime', '', '', '' ]
	, [ 'OrderID', 'ns:OrderIDType', ''
	     ,'eBay::API::XML::DataType::OrderIDType', '1' ]
                    );
push @gaProperties, @{eBay::API::XML::ResponseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::ResponseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setCreatedTime()

The date and time the order was created.

#    Argument: 'xs:dateTime'

=cut

sub setCreatedTime {
  my $self = shift;
  $self->{'CreatedTime'} = shift
}

=head2 getCreatedTime()

  Returned: Always
#    Returns: 'xs:dateTime'

=cut

sub getCreatedTime {
  my $self = shift;
  return $self->{'CreatedTime'};
}


=head2 setOrderID()

The unique identifier for the order.

#    Argument: 'ns:OrderIDType'

=cut

sub setOrderID {
  my $self = shift;
  $self->{'OrderID'} = shift
}

=head2 getOrderID()

  Returned: Always
#    Returns: 'ns:OrderIDType'

=cut

sub getOrderID {
  my $self = shift;
  return $self->_getDataTypeInstance( 'OrderID'
		,'eBay::API::XML::DataType::OrderIDType');
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
