#!/usr/bin/perl

package eBay::API::XML::DataType::NotificationEnableType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. NotificationEnableType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::NotificationEnableType

=head1 DESCRIPTION

Specifies a notification event and whether the
notification is enabled or disabled.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::NotificationEnableType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::Enum::EnableCodeType;
use eBay::API::XML::DataType::Enum::NotificationEventTypeCodeType;


my @gaProperties = ( [ 'EventEnable', 'ns:EnableCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::EnableCodeType', '' ]
	, [ 'EventType', 'ns:NotificationEventTypeCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::NotificationEventTypeCodeType', '' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setEventEnable()

Whether the event is enabled or disabled.

  Calls: SetNotificationPreferences
  RequiredInput: No

#    Argument: 'ns:EnableCodeType'

=cut

sub setEventEnable {
  my $self = shift;
  $self->{'EventEnable'} = shift
}

=head2 getEventEnable()

  Calls: GetNotificationPreferences
  Returned: Conditionally

#    Returns: 'ns:EnableCodeType'

=cut

sub getEventEnable {
  my $self = shift;
  return $self->{'EventEnable'};
}


=head2 setEventType()

The name of the notification event.

  Calls: SetNotificationPreferences
  RequiredInput: No
  AllValuesExcept: None, FeedbackForSeller

#    Argument: 'ns:NotificationEventTypeCodeType'

=cut

sub setEventType {
  my $self = shift;
  $self->{'EventType'} = shift
}

=head2 getEventType()

  Calls: GetNotificationPreferences
  Returned: Conditionally
  AllValuesExcept: FeedbackForSeller

#    Returns: 'ns:NotificationEventTypeCodeType'

=cut

sub getEventType {
  my $self = shift;
  return $self->{'EventType'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
