#!/usr/bin/env perl
#-*-perl-*-
#
#

## make this a module
package ISO::639::5;

# use 5.006;
use strict;
use warnings;

use utf8;
use open ':locale';
use Pod::Usage;
# use ISO::639::3;

=head1 NAME

ISO::639::5 - Language groups

=head1 VERSION

Version 0.02

=cut

our $VERSION      = '0.02';

use Exporter 'import';
our @EXPORT = qw(
    language_group
    language_parent
    language_group_children
);
our %EXPORT_TAGS = ( all => \@EXPORT );


=head1 SYNOPSIS

    use ISO::639::5 qw/:all/;

=cut

our $LanguageGroup;
our $LanguageParent;

$LanguageGroup = {
  'xnd' => [
    'ath',
    'eya',
    'hoi',
    'tfn',
    'tli'
  ],
  'aus' => [
    'bck',
    'dbl',
    'ddj',
    'gbu',
    'gni',
    'kdd',
    'kjn',
    'kld',
    'mep',
    'nha',
    'nuy',
    'pix',
    'pkn',
    'vma',
    'vmb',
    'wbp',
    'wmt',
    'xbp',
    'xrg',
    'yii',
    'yij'
  ],
  'alg' => [
    'alq',
    'arp',
    'atj',
    'ats',
    'bla',
    'chy',
    'ciw',
    'cre',
    'del',
    'kic',
    'mez',
    'mia',
    'mic',
    'mjy',
    'moe',
    'nnt',
    'oji',
    'ojs',
    'ojw',
    'otw',
    'pim',
    'pot',
    'qyp',
    'sac',
    'sjw',
    'unm',
    'wam',
    'xlb',
    'xlo',
    'xnt',
    'xpq'
  ],
  'ber' => [
    'cnu',
    'grr',
    'jbe',
    'jbn',
    'kab',
    'mzb',
    'nxm',
    'oua',
    'rif',
    'sds',
    'shr',
    'shy',
    'siz',
    'taq',
    'thv',
    'tmh',
    'tzm',
    'zen',
    'zgh'
  ],
  'art' => [
    'afh',
    'avk',
    'bzt',
    'dws',
    'epo',
    'ina',
    'ile',
    'igs',
    'ido',
    'jbo',
    'ldn',
    'lfn',
    'neu',
    'nov',
    'qya',
    'rmv',
    'sjn',
    'tlh',
    'tzl',
    'vol',
    'zbl'
  ],
  'ypk' => [
    'ems',
    'ess',
    'esu',
    'ynk'
  ],
  'urj' => [
    'fiu',
    'syd'
  ],
  'azc' => [
    'chl',
    'com',
    'cup',
    'hch',
    'hop',
    'lui',
    'mfy',
    'mnr',
    'nah',
    'ntp',
    'ood',
    'opt',
    'pao',
    'par',
    'pia',
    'ppl',
    'ser',
    'shh',
    'stp',
    'tac',
    'tar',
    'tla',
    'tub',
    'var',
    'xaw',
    'xgf',
    'yaq'
  ],
  'fiu' => [
    'chm',
    'est',
    'fin',
    'fit',
    'fkv',
    'hun',
    'izh',
    'kca',
    'kkt',
    'krl',
    'kom',
    'liv',
    'mdf',
    'mns',
    'mrj',
    'myv',
    'ong',
    'smi',
    'udm',
    'vep',
    'vot',
    'vro'
  ],
  'itc' => [
    'lat',
    'osc',
    'roa',
    'spx',
    'xfa',
    'xum'
  ],
  'bnt' => [
    'abb',
    'asa',
    'auh',
    'bas',
    'beb',
    'bem',
    'beq',
    'bez',
    'bip',
    'bja',
    'bkh',
    'bkw',
    'bng',
    'bni',
    'bqz',
    'brf',
    'btb',
    'bmv',
    'bvb',
    'bwt',
    'bxg',
    'cgg',
    'cjk',
    'cwe',
    'dav',
    'dez',
    'dma',
    'dua',
    'ebu',
    'eko',
    'eto',
    'ewo',
    'fan',
    'fip',
    'guz',
    'haq',
    'heh',
    'hke',
    'hoo',
    'her',
    'jmc',
    'kdx',
    'kck',
    'kcv',
    'kde',
    'kon',
    'kik',
    'kua',
    'kkj',
    'kmb',
    'koo',
    'koq',
    'kqn',
    'ksb',
    'ksf',
    'kws',
    'kzo',
    'lag',
    'lch',
    'lug',
    'lik',
    'lin',
    'lol',
    'loz',
    'lub',
    'lua',
    'lue',
    'lun',
    'luy',
    'lyn',
    'mbo',
    'mdw',
    'mnu',
    'mgh',
    'mhb',
    'mhw',
    'mye',
    'nba',
    'nde',
    'ndc',
    'ndo',
    'ngc',
    'ngl',
    'njx',
    'nmg',
    'nnb',
    'nbl',
    'nse',
    'nso',
    'nya',
    'nyf',
    'nym',
    'nyn',
    'pic',
    'run',
    'rng',
    'rof',
    'kin',
    'rwk',
    'rwm',
    'sbp',
    'seh',
    'shr',
    'sna',
    'snq',
    'urw',
    'ssw',
    'sot',
    'suk',
    'swa',
    'swb',
    'tll',
    'tsn',
    'toi',
    'tso',
    'tum',
    'umb',
    'ven',
    'vif',
    'vmk',
    'vun',
    'wdd',
    'wlc',
    'wni',
    'xho',
    'xog',
    'yao',
    'zdj',
    'zmw',
    'zul'
  ],
  'sit' => [
    'dzo',
    'ero',
    'grt',
    'hmr',
    'hni',
    'iii',
    'jkr',
    'kac',
    'kar',
    'lbj',
    'lus',
    'mni',
    'mya',
    'new',
    'njh',
    'njm',
    'nmy',
    'nwc',
    'nxq',
    'qvy',
    'sxg',
    'tbq',
    'tsj',
    'txg',
    'xsr',
    'zhx'
  ],
  'esx' => [
    'ale',
    'ipk',
    'iku',
    'kal',
    'ypk',
    'ysr'
  ],
  'tup' => [
    'eme',
    'grn',
    'gui',
    'guq',
    'gyr',
    'kay',
    'kgk',
    'kpn',
    'ktn',
    'kyr',
    'mpu',
    'myu',
    'nhd',
    'psm',
    'skf',
    'srq',
    'tpj',
    'tpr',
    'tpw',
    'twt',
    'wyr',
    'yrl'
  ],
  'ngb' => [
    'sag'
  ],
  'omq' => [
    'cco',
    'coz',
    'czn',
    'ixc',
    'maj',
    'maq',
    'miz',
    'mxb',
    'oto',
    'pbs',
    'pmq',
    'pmz',
    'tpc',
    'tpl',
    'tpx',
    'trs',
    'zap',
    'zaw',
    'ztq',
    'zty'
  ],
  'gme' => [
    'got',
    'xvn'
  ],
  'apa' => [
    'apj',
    'apk',
    'apl',
    'apw',
    'nav'
  ],
  'plf' => [
    'alo',
    'amv',
    'gap',
    'hbu',
    'kje',
    'lti',
    'mhs',
    'szn',
    'tet',
    'tlv',
    'txn',
    'wha'
  ],
  'iir' => [
    'ask',
    'bsh',
    'inc',
    'ira',
    'prn',
    'wbk',
    'xvi'
  ],
  'xsi' => [
    'asb',
    'bll',
    'cro',
    'dak',
    'hid',
    'iow',
    'ksk',
    'lkt',
    'mhq',
    'ofo',
    'oma',
    'osa',
    'qua',
    'sto',
    'tta',
    'win',
    'xwc'
  ],
  'sal' => [
    'cjh',
    'clm',
    'liw',
    'coo',
    'cow',
    'crd',
    'fla',
    'hur',
    'lil',
    'nok',
    'oka',
    'qun',
    'shs',
    'spo',
    'squ',
    'str',
    'thp'
  ],
  'nah' => [
    'nci'
  ],
  'afa' => [
    'ber',
    'bxe',
    'cdc',
    'cop',
    'cus',
    'egy',
    'omv',
    'sem',
    'zwa'
  ],
  'alv' => [
    'aba',
    'abi',
    'abr',
    'ado',
    'ada',
    'adj',
    'agq',
    'ajg',
    'aka',
    'anw',
    'atk',
    'avi',
    'ayb',
    'azo',
    'bad',
    'bai',
    'bax',
    'bba',
    'bce',
    'bci',
    'bda',
    'beh',
    'bfd',
    'bfl',
    'bgj',
    'bim',
    'bin',
    'bju',
    'bkc',
    'bkm',
    'blo',
    'bmq',
    'bnt',
    'bqj',
    'bsc',
    'cae',
    'cou',
    'cwt',
    'dag',
    'dij',
    'dop',
    'dur',
    'dyo',
    'ebr',
    'ewe',
    'efi',
    'fap',
    'ful',
    'fod',
    'fon',
    'ttb',
    'gba',
    'gej',
    'gjn',
    'gkn',
    'goy',
    'gur',
    'gux',
    'ibo',
    'ijo',
    'jab',
    'kbp',
    'kcj',
    'kdh',
    'keu',
    'kia',
    'kma',
    'knf',
    'kqs',
    'kro',
    'krx',
    'kss',
    'kzc',
    'kzr',
    'ldm',
    'lee',
    'lmp',
    'lob',
    'mdd',
    'mfq',
    'mfv',
    'mgo',
    'mlo',
    'mnh',
    'mor',
    'mos',
    'mql',
    'mua',
    'myk',
    'mzm',
    'mzv',
    'mzw',
    'naj',
    'ndv',
    'nfr',
    'nga',
    'ngb',
    'nie',
    'nku',
    'ntm',
    'nza',
    'nzi',
    'ogc',
    'oku',
    'otr',
    'ozm',
    'pbo',
    'pbp',
    'pil',
    'pny',
    'pug',
    'sav',
    'sev',
    'shz',
    'snf',
    'soy',
    'spp',
    'srr',
    'tbz',
    'kdh',
    'tfi',
    'tik',
    'tiv',
    'tkq',
    'tnr',
    'tui',
    'tuz',
    'urh',
    'wci',
    'wol',
    'wwa',
    'xsm',
    'xwe',
    'yav',
    'yky',
    'yor'
  ],
  'ine' => [
    'aln',
    'anp',
    'bat',
    'cel',
    'cms',
    'gem',
    'grk',
    'hit',
    'hlu',
    'hye',
    'iir',
    'imy',
    'itc',
    'plq',
    'scx',
    'sdt',
    'sla',
    'sqi',
    'txb',
    'txh',
    'xcl',
    'xcr',
    'xdc',
    'xlc',
    'xld',
    'xlg',
    'xls',
    'xmk',
    'xpg',
    'xps',
    'xsd',
    'xto',
    'xve'
  ],
  'kro' => [
    'ald',
    'bsq',
    'dic',
    'grb',
    'gud',
    'gxx',
    'ney',
    'nwb',
    'wec'
  ],
  'cau' => [
    'ccn',
    'ccs'
  ],
  'map' => [
    'fox',
    'lcl',
    'lnd',
    'poz'
  ],
  'tut' => [
    'nog',
    'trk',
    'tuw',
    'xgn'
  ],
  'aav' => [
    'irr',
    'kdt',
    'mkh',
    'mun',
    'nyl',
    'sss',
    'tth'
  ],
  'mkh' => [
    'bbh',
    'bgk',
    'blr',
    'caq',
    'cbn',
    'crv',
    'cwg',
    'huo',
    'jah',
    'jhi',
    'kha',
    'kjg',
    'khm',
    'lbn',
    'mhe',
    'mlf',
    'mml',
    'mnw',
    'mqt',
    'mra',
    'mtq',
    'ncb',
    'oyb',
    'ply',
    'prk',
    'prt',
    'rka',
    'scb',
    'sea',
    'sii',
    'tef',
    'tnz',
    'tpu',
    'tyh',
    'uuu',
    'vie',
    'vwa',
    'wbm',
    'xao',
    'xnh',
    'zng'
  ],
  'znd' => [
    'zne'
  ],
  'zle' => [
    'bel',
    'orv',
    'rus',
    'rue',
    'ukr'
  ],
  'cpf' => [
    'acf',
    'cks',
    'crs',
    'gcf',
    'gcr',
    'hat',
    'kmv',
    'loj',
    'mfe',
    'rcf'
  ],
  'poz' => [
    'aol',
    'bhp',
    'end',
    'hvn',
    'ivv',
    'kei',
    'kvh',
    'mqy',
    'nxe',
    'ple',
    'plf',
    'pqe',
    'pqw',
    'ski',
    'tao',
    'xbr',
    'xxk'
  ],
  'euq' => [
    'eus'
  ],
  'nub' => [
    'fia',
    'onw'
  ],
  'dai' => [
    'bth',
    'lra',
    'sdo',
    'sne'
  ],
  'hmx' => [
    'bje',
    'bpn',
    'buh',
    'bwn',
    'cqd',
    'hmd',
    'hml',
    'hmn',
    'hnj',
    'ium',
    'mji',
    'mmr',
    'mww',
    'pha',
    'pnu',
    'shx'
  ],
  'aql' => [
    'alg',
    'wiy',
    'yur'
  ],
  'roa' => [
    'arg',
    'ast',
    'cat',
    'cos',
    'cpf',
    'cpp',
    'dlm',
    'egl',
    'spa',
    'ext',
    'fax',
    'fra',
    'frc',
    'frm',
    'fro',
    'frp',
    'fvr',
    'glg',
    'ist',
    'ita',
    'lad',
    'lij',
    'lld',
    'lmo',
    'mwl',
    'mxi',
    'nap',
    'nrf',
    'oci',
    'osp',
    'pcd',
    'pms',
    'por',
    'rgn',
    'roh',
    'ron',
    'ruo',
    'rup',
    'ruq',
    'srd',
    'scn',
    'sdc',
    'sdn',
    'vec',
    'wln'
  ],
  'inc' => [
    'asm',
    'awa',
    'bgc',
    'bhb',
    'bho',
    'bjj',
    'bkk',
    'ben',
    'bns',
    'bpy',
    'bra',
    'ccp',
    'ctg',
    'dml',
    'doi',
    'div',
    'emx',
    'guj',
    'gwc',
    'gwt',
    'hin',
    'hif',
    'hne',
    'khw',
    'kls',
    'kok',
    'kas',
    'lah',
    'mag',
    'mai',
    'mar',
    'mvy',
    'mwr',
    'nep',
    'ori',
    'pan',
    'phl',
    'pra',
    'raj',
    'rml',
    'rmq',
    'rmt',
    'rom',
    'scl',
    'snd',
    'sdg',
    'sin',
    'skr',
    'syl',
    'urd'
  ],
  'dra' => [
    'brh',
    'gon',
    'iru',
    'kfa',
    'kfc',
    'kff',
    'kmj',
    'kan',
    'kru',
    'kru',
    'kxu',
    'kxv',
    'mjt',
    'mjv',
    'mal',
    'muv',
    'tam',
    'tcx',
    'tcy',
    'tel'
  ],
  'kar' => [
    'kvq'
  ],
  'cel' => [
    'bre',
    'cym',
    'gle',
    'gla',
    'glv',
    'cor',
    'mga',
    'nrc',
    'obt',
    'owl',
    'sga',
    'wlm',
    'xbm',
    'xcb',
    'xce',
    'xga',
    'xpi'
  ],
  'oto' => [
    'otm'
  ],
  'swa' => [
    'swc'
  ],
  'cba' => [
    'bzd',
    'cbg',
    'chb',
    'kog',
    'mbp',
    'mot',
    'tuf'
  ],
  'sla' => [
    'zle',
    'zls',
    'zlw'
  ],
  'jpx' => [
    'jpn'
  ],
  'nic' => [
    'alv',
    'dmn',
    'eka',
    'kdo',
    'lam',
    'nqo',
    'nyo',
    'tog',
    'znd'
  ],
  'mul' => [
    'aav',
    'afa',
    'aqa',
    'aql',
    'art',
    'auf',
    'aus',
    'awd',
    'azc',
    'cau',
    'cba',
    'cdd',
    'dra',
    'esx',
    'euq',
    'hmx',
    'hok',
    'ine',
    'iro',
    'jpx',
    'khi',
    'map',
    'myn',
    'nic',
    'omq',
    'paa',
    'sal',
    'sgn',
    'xsi',
    'sit',
    'ssa',
    'taw',
    'tup',
    'tut',
    'urj',
    'wak',
    'xnd'
  ],
  'pqw' => [
    'abl',
    'abs',
    'abx',
    'ban',
    'bdg',
    'bdl',
    'bdr',
    'beg',
    'bew',
    'bjn',
    'bkz',
    'bsu',
    'btk',
    'buc',
    'bug',
    'cha',
    'cia',
    'cmc',
    'dai',
    'dbj',
    'drg',
    'dtr',
    'dun',
    'dup',
    'duq',
    'duw',
    'eno',
    'gay',
    'goq',
    'iba',
    'ind',
    'jav',
    'kaw',
    'kge',
    'kjc',
    'kjk',
    'kqr',
    'ktq',
    'kvr',
    'kxd',
    'kyi',
    'kys',
    'lbw',
    'lbx',
    'lce',
    'lcf',
    'ley',
    'liw',
    'ljp',
    'llk',
    'mad',
    'mak',
    'mdr',
    'mfa',
    'mfb',
    'mlg',
    'mhy',
    'min',
    'mkm',
    'mqn',
    'msa',
    'mtd',
    'mui',
    'mwv',
    'mxr',
    'myl',
    'mzq',
    'nia',
    'nij',
    'nrm',
    'otd',
    'pau',
    'pdo',
    'pel',
    'phi',
    'pku',
    'pse',
    'raz',
    'ree',
    'rej',
    'sas',
    'sda',
    'sjm',
    'skh',
    'slm',
    'sml',
    'smr',
    'smw',
    'snv',
    'ssb',
    'sse',
    'sun',
    'sya',
    'tdi',
    'dtp',
    'tdx',
    'tjg',
    'tkg',
    'tlk',
    'twy',
    'txy',
    'ulu',
    'vkl',
    'vko',
    'wow',
    'wru',
    'xkq',
    'xmv',
    'xmw',
    'xmz',
    'yka',
    'zbc',
    'zbe',
    'zbw'
  ],
  'gem' => [
    'gme',
    'gmq',
    'gmw'
  ],
  'smi' => [
    'sme',
    'sia',
    'sjd',
    'sje',
    'sjt',
    'sma',
    'smj',
    'smn',
    'sms'
  ],
  'gmw' => [
    'afr',
    'ang',
    'cim',
    'deu',
    'dum',
    'eng',
    'enm',
    'frk',
    'frr',
    'fry',
    'gct',
    'gmh',
    'gml',
    'goh',
    'gos',
    'gsw',
    'ksh',
    'ltz',
    'lim',
    'lng',
    'mhn',
    'nds',
    'nld',
    'odt',
    'ofs',
    'osx',
    'pdc',
    'pfl',
    'sco',
    'stq',
    'swg',
    'wae',
    'wep',
    'wym',
    'yec',
    'yid',
    'zea'
  ],
  'wak' => [
    'dtd',
    'has',
    'hei',
    'kwk',
    'myh',
    'noc'
  ],
  'dmn' => [
    'bib',
    'bam',
    'bqc',
    'dnj',
    'dyu',
    'goa',
    'kax',
    'knk',
    'kno',
    'knu',
    'kpe',
    'lom',
    'man',
    'men',
    'mlq',
    'moa',
    'mwk',
    'rkm',
    'snk',
    'sus',
    'vai',
    'xkg',
    'yal'
  ],
  'fox' => [
    'bnn',
    'bzg',
    'ckv',
    'dru',
    'fos',
    'pwn',
    'pyu',
    'ssf',
    'sxr',
    'tay',
    'trv',
    'tsu',
    'uun',
    'xnb',
    'xsy'
  ],
  'hok' => [
    'acv',
    'atw',
    'boi',
    'cid',
    'coc',
    'crz',
    'esq',
    'inz',
    'kju',
    'klb',
    'kyh',
    'mov',
    'mrc',
    'obi',
    'peb',
    'pef',
    'pej',
    'peq',
    'pmo',
    'poo',
    'ppi',
    'puy',
    'sei',
    'sht',
    'sln',
    'veo',
    'was',
    'ynn',
    'yuf',
    'yum'
  ],
  'grk' => [
    'cpg',
    'ell',
    'gmy',
    'grc',
    'pnt',
    'tsd',
    'yej'
  ],
  'tuw' => [
    'eve',
    'evn',
    'gld',
    'juc',
    'mnc',
    'neg',
    'oaa',
    'oac',
    'orh',
    'sjo',
    'ude',
    'ulc'
  ],
  'cdd' => [
    'aac',
    'cad',
    'kii',
    'paw',
    'wic'
  ],
  'taw' => [
    'lao',
    'tha'
  ],
  'pra' => [
    'pli',
    'san'
  ],
  'bat' => [
    'lit',
    'ltg',
    'lav',
    'ndf',
    'olt',
    'prg',
    'sgs',
    'svx',
    'sxl',
    'xcu',
    'xgl',
    'xsv',
    'xzm'
  ],
  'gmq' => [
    'dan',
    'fao',
    'isl',
    'nob',
    'nno',
    'non',
    'nrn',
    'ovd',
    'rmg',
    'swe'
  ],
  'zlw' => [
    'ces',
    'csb',
    'czk',
    'pol',
    'pox',
    'slk',
    'szl',
    'wen'
  ],
  'awd' => [
    'aca',
    'ame',
    'apu',
    'bae',
    'brg',
    'ccc',
    'cui',
    'gob',
    'guc',
    'guh',
    'guo',
    'ign',
    'inp',
    'kpc',
    'mbn',
    'not',
    'pbg',
    'pib',
    'pio',
    'plu',
    'tae',
    'trn',
    'ycn'
  ],
  'tbq' => [
    'adx',
    'anm',
    'bod',
    'bqh',
    'brx',
    'duu',
    'ers',
    'gqi',
    'gro',
    'jya',
    'lhu',
    'lpo',
    'mxj',
    'njo',
    'nun',
    'trp',
    'twm'
  ],
  'iro' => [
    'cay',
    'chr',
    'lre',
    'moh',
    'ntw',
    'one',
    'ons',
    'see',
    'sqn',
    'tus',
    'wya'
  ],
  'paa' => [
    'aau',
    'anz',
    'ddg',
    'gak',
    'kax',
    'kmo',
    'lvk',
    'mqt',
    'nas',
    'ngf',
    'pgu',
    'saj',
    'tcm',
    'tft',
    'tif',
    'tlb',
    'tqu',
    'waj',
    'wli',
    'yee',
    'zuh'
  ],
  'csu' => [
    'avu',
    'bdh',
    'bex',
    'bot',
    'kcm',
    'led',
    'mdi',
    'mdj',
    'mhi',
    'mwm',
    'myb',
    'niy',
    'sba'
  ],
  'zhx' => [
    'cdo',
    'cjy',
    'cpx',
    'czh',
    'czo',
    'gan',
    'hak',
    'hsn',
    'ltc',
    'mnp',
    'nan',
    'och',
    'wuu',
    'wxa',
    'yue',
    'zho'
  ],
  'sdv' => [
    'ach',
    'alz',
    'anu',
    'bfa',
    'ddd',
    'din',
    'enb',
    'eyo',
    'kdj',
    'keo',
    'kln',
    'kpz',
    'lky',
    'lot',
    'lpx',
    'luo',
    'mas',
    'mqu',
    'muz',
    'niq',
    'nsg',
    'nub',
    'nus',
    'saq',
    'sgc',
    'shk',
    'tec',
    'teo',
    'toq',
    'tuv',
    'tuy'
  ],
  'sgn' => [
    'csn',
    'fcs',
    'fsl',
    'ils',
    'isg',
    'rsl'
  ],
  'mun' => [
    'hoc',
    'pcj',
    'sat',
    'unr'
  ],
  'btk' => [
    'akb',
    'bbc',
    'btd',
    'btm',
    'bts',
    'btx',
    'btz'
  ],
  'ngf' => [
    'bjz',
    'ekg',
    'uhn'
  ],
  'trk' => [
    'aib',
    'alt',
    'aze',
    'azb',
    'bak',
    'chg',
    'cjs',
    'clw',
    'crh',
    'chv',
    'dlg',
    'gag',
    'ili',
    'jct',
    'kaa',
    'kdr',
    'kia',
    'kjh',
    'kaz',
    'klj',
    'kmz',
    'krc',
    'kum',
    'kir',
    'ota',
    'otk',
    'qwm',
    'qxq',
    'sah',
    'slr',
    'tuk',
    'tur',
    'tat',
    'tyv',
    'uig',
    'uzb',
    'uzs',
    'xpc',
    'ybe'
  ],
  'auf' => [
    'aru',
    'cul',
    'dny',
    'pad',
    'swx'
  ],
  'cus' => [
    'aar',
    'arv',
    'bej',
    'bji',
    'byn',
    'dal',
    'irk',
    'orm',
    'orc',
    'sid',
    'som',
    'ssn',
    'ssy'
  ],
  'ssa' => [
    'csu',
    'dzg',
    'fvr',
    'gly',
    'guk',
    'ikx',
    'kbl',
    'kie',
    'kmq',
    'kau',
    'lgn',
    'mde',
    'mls',
    'rou',
    'sdv',
    'son',
    'teu',
    'tuq',
    'udu',
    'wti',
    'xmr',
    'xom'
  ],
  'phi' => [
    'akl',
    'bik',
    'blf',
    'bno',
    'bnq',
    'ceb',
    'cps',
    'fil',
    'gqr',
    'hil',
    'ibg',
    'ibl',
    'ify',
    'ilk',
    'ilo',
    'kak',
    'krj',
    'kyj',
    'kyk',
    'loc',
    'mdh',
    'mno',
    'mog',
    'mrw',
    'msb',
    'pag',
    'pmn',
    'rth',
    'sgd',
    'snl',
    'sxn',
    'tbl',
    'tdn',
    'kak',
    'tnt',
    'tnw',
    'tom',
    'txs',
    'war'
  ],
  'zls' => [
    'bul',
    'bos',
    'chu',
    'hrv',
    'mkd',
    'slv',
    'srp'
  ],
  'aqa' => [
    'alc'
  ],
  'syd' => [
    'mtm',
    'nio',
    'sel',
    'xas',
    'yrk'
  ],
  'khi' => [
    'hts',
    'ktz',
    'kwz',
    'naq',
    'nmn',
    'sad'
  ],
  'cpp' => [
    'aoa',
    'cri',
    'fab',
    'kea',
    'mzs',
    'pap',
    'pov',
    'pre',
    'srm',
    'xmm'
  ],
  'wen' => [
    'dsb',
    'hsb'
  ],
  'ath' => [
    'aht',
    'apa',
    'bcr',
    'bea',
    'caf',
    'chp',
    'clc',
    'crx',
    'den',
    'dgr',
    'gwi',
    'haa',
    'hup',
    'ing',
    'kkz',
    'koy',
    'kuu',
    'srs',
    'tau',
    'tcb',
    'tgx',
    'tht',
    'jic'
  ],
  'pqe' => [
    'agw',
    'ahb',
    'aia',
    'aie',
    'aji',
    'akr',
    'alm',
    'alu',
    'ane',
    'anx',
    'apb',
    'app',
    'apr',
    'asz',
    'aty',
    'aua',
    'aud',
    'aul',
    'auq',
    'aut',
    'baa',
    'bch',
    'bcm',
    'bcu',
    'bgt',
    'bhc',
    'bhw',
    'biq',
    'bjk',
    'blp',
    'blq',
    'bnk',
    'bnr',
    'bpa',
    'brr',
    'btr',
    'buk',
    'bvc',
    'bvd',
    'bwd',
    'bxa',
    'bxf',
    'bzh',
    'bzq',
    'cal',
    'cam',
    'chk',
    'crc',
    'ddi',
    'dgg',
    'dhv',
    'dob',
    'dor',
    'kzk',
    'erg',
    'erk',
    'etn',
    'faf',
    'far',
    'fij',
    'frt',
    'fud',
    'fut',
    'fwa',
    'gdd',
    'gei',
    'gfk',
    'gga',
    'ggt',
    'ghn',
    'gil',
    'kzk',
    'gmb',
    'goo',
    'gri',
    'grz',
    'gzn',
    'hah',
    'hao',
    'haw',
    'hiw',
    'hla',
    'hoa',
    'hrw',
    'iai',
    'irh',
    'jae',
    'jaj',
    'jaz',
    'kbm',
    'kdk',
    'khl',
    'kij',
    'kji',
    'kkk',
    'klv',
    'koa',
    'kos',
    'kpg',
    'kqw',
    'krf',
    'ksd',
    'ksg',
    'ktm',
    'kvc',
    'kwd',
    'kwf',
    'kxr',
    'kzk',
    'kzu',
    'lbb',
    'lbv',
    'lcm',
    'lek',
    'ler',
    'leu',
    'lga',
    'lgb',
    'lgk',
    'lgl',
    'lgr',
    'lgu',
    'lht',
    'lib',
    'lid',
    'lkn',
    'lle',
    'llf',
    'llp',
    'llu',
    'llx',
    'lmg',
    'lml',
    'lmu',
    'lmv',
    'loj',
    'los',
    'lpa',
    'lrv',
    'lrz',
    'lww',
    'mee',
    'mek',
    'met',
    'meu',
    'mft',
    'mgl',
    'mah',
    'mri',
    'mkj',
    'mkv',
    'mky',
    'mla',
    'mln',
    'mlu',
    'mlv',
    'mme',
    'mmg',
    'mmt',
    'mmw',
    'mmx',
    'mna',
    'mnv',
    'mox',
    'mpr',
    'mpy',
    'mqa',
    'mqm',
    'mrb',
    'mrl',
    'mrm',
    'mrn',
    'mrq',
    'mrv',
    'msq',
    'mte',
    'mtt',
    'mvo',
    'mwc',
    'mwh',
    'mwi',
    'mwo',
    'mxe',
    'nau',
    'nal',
    'ncc',
    'ncf',
    'ncn',
    'nee',
    'nem',
    'nqn',
    'nfl',
    'ngr',
    'niu',
    'nke',
    'nkr',
    'nlg',
    'nmb',
    'nmk',
    'nms',
    'nmt',
    'nnd',
    'npn',
    'nsn',
    'nss',
    'nsw',
    'nua',
    'nuw',
    'nwi',
    'olr',
    'omb',
    'onu',
    'ora',
    'pek',
    'pex',
    'pfa',
    'pgk',
    'pif',
    'piv',
    'piz',
    'pkg',
    'pma',
    'pme',
    'pmt',
    'pnh',
    'pon',
    'pop',
    'ppn',
    'pri',
    'pss',
    'psw',
    'ptp',
    'ptv',
    'puw',
    'pwg',
    'rai',
    'rak',
    'rap',
    'rar',
    'ray',
    'roe',
    'rri',
    'rro',
    'rug',
    'sax',
    'sbb',
    'sbc',
    'sbe',
    'sbh',
    'sgz',
    'sij',
    'sjr',
    'sku',
    'slz',
    'smo',
    'sns',
    'sob',
    'sol',
    'sov',
    'sps',
    'ssg',
    'stn',
    'stw',
    'swp',
    'szw',
    'tbc',
    'tbe',
    'tbf',
    'tbj',
    'tgc',
    'tgi',
    'tgp',
    'tgs',
    'tio',
    'tkl',
    'tkp',
    'tkw',
    'tlm',
    'tlr',
    'tlx',
    'tmb',
    'tmi',
    'tmy',
    'tnk',
    'tnl',
    'tnn',
    'tnp',
    'tnx',
    'ton',
    'tox',
    'tpv',
    'tpz',
    'tql',
    'tqp',
    'tsr',
    'ttu',
    'ttv',
    'tuc',
    'tva',
    'tvk',
    'tvl',
    'twp',
    'tah',
    'ubr',
    'uge',
    'uli',
    'upv',
    'urr',
    'urv',
    'utp',
    'uve',
    'uvl',
    'vao',
    'vmg',
    'vnk',
    'vnm',
    'vra',
    'vrs',
    'vrt',
    'wiv',
    'wls',
    'woe',
    'wuv',
    'wwo',
    'wyy',
    'xsi',
    'yap',
    'yly',
    'zgr'
  ],
  'cdc' => [
    'anc',
    'ank',
    'bid',
    'daa',
    'hau',
    'hed',
    'lme',
    'maf',
    'mcn',
    'mmy',
    'mpz',
    'mse',
    'mug',
    'nnc',
    'nnn',
    'pip',
    'sor',
    'tmc',
    'zim',
    'zuy'
  ],
  'son' => [
    'ddn',
    'dje',
    'kcy',
    'khq',
    'ses',
    'twq'
  ],
  'ccs' => [
    'kat',
    'lzz',
    'sva',
    'xmf'
  ],
  'cmc' => [
    'ace',
    'cje',
    'cjm',
    'hro',
    'huq',
    'jra',
    'rad',
    'rog'
  ],
  'myn' => [
    'acr',
    'agu',
    'caa',
    'cac',
    'cak',
    'ctu',
    'hus',
    'itz',
    'ixl',
    'jac',
    'kek',
    'kjb',
    'knj',
    'mam',
    'mhc',
    'mop',
    'poc',
    'poh',
    'quc',
    'qum',
    'quv',
    'toj',
    'ttc',
    'tzh',
    'tzj',
    'tzo',
    'usp',
    'yua'
  ],
  'xgn' => [
    'bub',
    'dta',
    'kxs',
    'mhj',
    'mjg',
    'mon',
    'mvf',
    'peh',
    'sce',
    'xal',
    'xwo',
    'yuy'
  ],
  'omv' => [
    'aiw',
    'bcq',
    'bwo',
    'dim',
    'doz',
    'jnj',
    'mdx',
    'noz',
    'shx',
    'wal',
    'zwa'
  ],
  'ccn' => [
    'abk',
    'abq',
    'ady',
    'agx',
    'akv',
    'ani',
    'aqc',
    'ava',
    'bbl',
    'bdk',
    'bph',
    'che',
    'cji',
    'dar',
    'ddo',
    'gdo',
    'gin',
    'huz',
    'inh',
    'ykm',
    'kbd',
    'khv',
    'kjj',
    'kpt',
    'kry',
    'kva',
    'lbe',
    'lez',
    'rut',
    'tab',
    'tin',
    'tkr',
    'uby',
    'udi'
  ],
  'sem' => [
    'aao',
    'acw',
    'acy',
    'aeb',
    'afb',
    'aii',
    'ajt',
    'akk',
    'amh',
    'amw',
    'apc',
    'ara',
    'arc',
    'arq',
    'ary',
    'arz',
    'ayl',
    'gdq',
    'gez',
    'har',
    'heb',
    'jrb',
    'mey',
    'mlt',
    'phn',
    'snx',
    'shu',
    'smp',
    'sqr',
    'syc',
    'tir',
    'tig',
    'tmr',
    'uga',
    'xaa',
    'xeb',
    'xpu'
  ],
  'bai' => [
    'bbj',
    'bko',
    'byv',
    'fmp',
    'jgo',
    'nla',
    'nnh',
    'nnz',
    'nwe',
    'xmg',
    'ybb'
  ],
  'ira' => [
    'ave',
    'bal',
    'bsg',
    'ckb',
    'fas',
    'glk',
    'hac',
    'haz',
    'isk',
    'jdt',
    'jpr',
    'kho',
    'kur',
    'lrc',
    'lsa',
    'mzn',
    'oru',
    'oss',
    'abw',
    'peo',
    'prc',
    'pus',
    'sgh',
    'sgl',
    'sgy',
    'siy',
    'smy',
    'sog',
    'sqo',
    'srh',
    'tgk',
    'tly',
    'ttt',
    'wbl',
    'xbc',
    'xco',
    'xpr',
    'xsc',
    'yai',
    'zum',
    'zza'
  ]
};
$LanguageParent = {
  'tuw' => 'tut',
  'nla' => 'bai',
  'ude' => 'tuw',
  'nnn' => 'cdc',
  'chv' => 'trk',
  'wwa' => 'alv',
  'toj' => 'myn',
  'ado' => 'alv',
  'mnc' => 'tuw',
  'pgu' => 'paa',
  'aru' => 'auf',
  'ply' => 'mkh',
  'man' => 'dmn',
  'puw' => 'pqe',
  'lml' => 'pqe',
  'kdx' => 'bnt',
  'nbl' => 'bnt',
  'dbj' => 'pqw',
  'sjt' => 'smi',
  'caa' => 'myn',
  'pag' => 'phi',
  'jmc' => 'bnt',
  'soy' => 'alv',
  'cus' => 'afa',
  'kru' => 'dra',
  'drg' => 'pqw',
  'prk' => 'mkh',
  'tom' => 'phi',
  'anu' => 'sdv',
  'kpe' => 'dmn',
  'luy' => 'bnt',
  'omq' => 'mul',
  'llp' => 'pqe',
  'bbl' => 'ccn',
  'kqn' => 'bnt',
  'lat' => 'itc',
  'anm' => 'tbq',
  'sbc' => 'pqe',
  'fiu' => 'urj',
  'tmr' => 'sem',
  'njh' => 'sit',
  'slk' => 'zlw',
  'aav' => 'mul',
  'tut' => 'mul',
  'twy' => 'pqw',
  'ald' => 'kro',
  'cor' => 'cel',
  'tpu' => 'mkh',
  'bew' => 'pqw',
  'oyb' => 'mkh',
  'tef' => 'mkh',
  'bqh' => 'tbq',
  'mrj' => 'fiu',
  'bko' => 'bai',
  'kge' => 'pqw',
  'xdc' => 'ine',
  'mmw' => 'pqe',
  'xmv' => 'pqw',
  'ful' => 'alv',
  'udi' => 'ccn',
  'rng' => 'bnt',
  'bdl' => 'pqw',
  'oma' => 'xsi',
  'lld' => 'roa',
  'fro' => 'roa',
  'tpx' => 'omq',
  'mep' => 'aus',
  'tnk' => 'pqe',
  'ess' => 'ypk',
  'ani' => 'ccn',
  'bel' => 'zle',
  'kbp' => 'alv',
  'roh' => 'roa',
  'cad' => 'cdd',
  'bll' => 'xsi',
  'thv' => 'ber',
  'seh' => 'bnt',
  'uby' => 'ccn',
  'vun' => 'bnt',
  'xnt' => 'alg',
  'sga' => 'cel',
  'fan' => 'bnt',
  'rai' => 'pqe',
  'dal' => 'cus',
  'lue' => 'bnt',
  'kzo' => 'bnt',
  'ciw' => 'alg',
  'faf' => 'pqe',
  'xps' => 'ine',
  'bnt' => 'alv',
  'tlk' => 'pqw',
  'kpt' => 'ccn',
  'mbo' => 'bnt',
  'dun' => 'pqw',
  'cbg' => 'cba',
  'ssg' => 'pqe',
  'asm' => 'inc',
  'kck' => 'bnt',
  'hur' => 'sal',
  'abl' => 'pqw',
  'tpz' => 'pqe',
  'meu' => 'pqe',
  'trp' => 'tbq',
  'qua' => 'xsi',
  'wxa' => 'zhx',
  'snl' => 'phi',
  'syl' => 'inc',
  'srq' => 'tup',
  'gcr' => 'cpf',
  'lyn' => 'bnt',
  'nwe' => 'bai',
  'tsd' => 'grk',
  'nah' => 'azc',
  'atw' => 'hok',
  'xbr' => 'poz',
  'twq' => 'son',
  'kro' => 'alv',
  'bxg' => 'bnt',
  'jaj' => 'pqe',
  'itz' => 'myn',
  'xsd' => 'ine',
  'cel' => 'ine',
  'shh' => 'azc',
  'euq' => 'mul',
  'crh' => 'trk',
  'sev' => 'alv',
  'wya' => 'iro',
  'ses' => 'son',
  'tgk' => 'ira',
  'sea' => 'mkh',
  'moa' => 'dmn',
  'iru' => 'dra',
  'bng' => 'bnt',
  'tin' => 'ccn',
  'siy' => 'ira',
  'nav' => 'apa',
  'krf' => 'pqe',
  'hni' => 'sit',
  'umb' => 'bnt',
  'kbl' => 'ssa',
  'dup' => 'pqw',
  'aao' => 'sem',
  'kfc' => 'dra',
  'bfd' => 'alv',
  'new' => 'sit',
  'kzr' => 'alv',
  'lez' => 'ccn',
  'bkz' => 'pqw',
  'ibg' => 'phi',
  'ace' => 'cmc',
  'tcm' => 'paa',
  'bad' => 'alv',
  'mlv' => 'pqe',
  'ahb' => 'pqe',
  'mdw' => 'bnt',
  'kmv' => 'cpf',
  'amw' => 'sem',
  'wep' => 'gmw',
  'szw' => 'pqe',
  'ebr' => 'alv',
  'stq' => 'gmw',
  'tmy' => 'pqe',
  'awa' => 'inc',
  'mhe' => 'mkh',
  'ndv' => 'alv',
  'den' => 'ath',
  'myk' => 'alv',
  'btr' => 'pqe',
  'tpw' => 'tup',
  'tht' => 'ath',
  'bae' => 'awd',
  'alo' => 'plf',
  'sun' => 'pqw',
  'twt' => 'tup',
  'xvi' => 'iir',
  'mnu' => 'bnt',
  'mui' => 'pqw',
  'mzv' => 'alv',
  'sqr' => 'sem',
  'ssn' => 'cus',
  'mak' => 'pqw',
  'kkt' => 'fiu',
  'ify' => 'phi',
  'grz' => 'pqe',
  'tso' => 'bnt',
  'arp' => 'alg',
  'lrc' => 'ira',
  'ukr' => 'zle',
  'nfl' => 'pqe',
  'yuf' => 'hok',
  'shk' => 'sdv',
  'beb' => 'bnt',
  'agw' => 'pqe',
  'czn' => 'omq',
  'tth' => 'aav',
  'mua' => 'alv',
  'frp' => 'roa',
  'mhi' => 'csu',
  'guz' => 'bnt',
  'sxn' => 'phi',
  'not' => 'awd',
  'mrn' => 'pqe',
  'tio' => 'pqe',
  'ikx' => 'ssa',
  'mos' => 'alv',
  'orh' => 'tuw',
  'bdg' => 'pqw',
  'avi' => 'alv',
  'wam' => 'alg',
  'knk' => 'dmn',
  'bwn' => 'hmx',
  'sqn' => 'iro',
  'tql' => 'pqe',
  'gak' => 'paa',
  'sax' => 'pqe',
  'zho' => 'zhx',
  'gdo' => 'ccn',
  'kss' => 'alv',
  'rwm' => 'bnt',
  'enm' => 'gmw',
  'apl' => 'apa',
  'mya' => 'sit',
  'kls' => 'inc',
  'igs' => 'art',
  'muv' => 'dra',
  'aus' => 'mul',
  'bzg' => 'fox',
  'fon' => 'alv',
  'vnm' => 'pqe',
  'unm' => 'alg',
  'tog' => 'nic',
  'bea' => 'ath',
  'crd' => 'sal',
  'aqc' => 'ccn',
  'nms' => 'pqe',
  'glg' => 'roa',
  'kwd' => 'pqe',
  'pri' => 'pqe',
  'srs' => 'ath',
  'xsr' => 'sit',
  'aql' => 'mul',
  'kpg' => 'pqe',
  'gej' => 'alv',
  'fin' => 'fiu',
  'abx' => 'pqw',
  'eya' => 'xnd',
  'kdr' => 'trk',
  'arq' => 'sem',
  'zza' => 'ira',
  'kjc' => 'pqw',
  'pox' => 'zlw',
  'hac' => 'ira',
  'npn' => 'pqe',
  'kno' => 'dmn',
  'fvr' => 'ssa',
  'ksb' => 'bnt',
  'bjn' => 'pqw',
  'mzb' => 'ber',
  'vao' => 'pqe',
  'mwh' => 'pqe',
  'otd' => 'pqw',
  'kva' => 'ccn',
  'ane' => 'pqe',
  'bat' => 'ine',
  'xfa' => 'itc',
  'eno' => 'pqw',
  'urw' => 'bnt',
  'vmg' => 'pqe',
  'ruk' => 'ccn',
  'lav' => 'bat',
  'suk' => 'bnt',
  'kmz' => 'trk',
  'luo' => 'sdv',
  'twp' => 'pqe',
  'jae' => 'pqe',
  'bdk' => 'ccn',
  'mwl' => 'roa',
  'osc' => 'itc',
  'hed' => 'cdc',
  'hvn' => 'poz',
  'jah' => 'mkh',
  'quc' => 'myn',
  'kkz' => 'ath',
  'bjz' => 'ngf',
  'eko' => 'bnt',
  'bex' => 'csu',
  'enb' => 'sdv',
  'xas' => 'syd',
  'wti' => 'ssa',
  'frk' => 'gmw',
  'dur' => 'alv',
  'owl' => 'cel',
  'ldn' => 'art',
  'gxx' => 'kro',
  'fia' => 'nub',
  'poc' => 'myn',
  'blq' => 'pqe',
  'lom' => 'dmn',
  'swe' => 'gmq',
  'gld' => 'tuw',
  'sbh' => 'pqe',
  'bvc' => 'pqe',
  'yap' => 'pqe',
  'lgb' => 'pqe',
  'agu' => 'myn',
  'pic' => 'bnt',
  'sgy' => 'ira',
  'boi' => 'hok',
  'ovd' => 'gmq',
  'buc' => 'pqw',
  'sna' => 'bnt',
  'mno' => 'phi',
  'yee' => 'paa',
  'mwm' => 'csu',
  'lvk' => 'paa',
  'nas' => 'paa',
  'dua' => 'bnt',
  'fip' => 'bnt',
  'kkj' => 'bnt',
  'hah' => 'pqe',
  'sgh' => 'ira',
  'mzq' => 'pqw',
  'tuz' => 'alv',
  'ssw' => 'bnt',
  'dav' => 'bnt',
  'bfa' => 'sdv',
  'dyo' => 'alv',
  'chb' => 'cba',
  'slv' => 'zls',
  'wlm' => 'cel',
  'aib' => 'trk',
  'oog' => 'fiu',
  'alu' => 'pqe',
  'bzd' => 'cba',
  'wci' => 'alv',
  'nsw' => 'pqe',
  'sse' => 'pqw',
  'gmy' => 'grk',
  'kcv' => 'bnt',
  'zbw' => 'pqw',
  'scb' => 'mkh',
  'xga' => 'cel',
  'pio' => 'awd',
  'juc' => 'tuw',
  'hop' => 'azc',
  'mwc' => 'pqe',
  'nxe' => 'poz',
  'fqs' => 'ira',
  'teo' => 'sdv',
  'kwf' => 'pqe',
  'itc' => 'ine',
  'xmf' => 'ccs',
  'nie' => 'alv',
  'sgs' => 'bat',
  'mdd' => 'alv',
  'jbe' => 'ber',
  'ota' => 'trk',
  'thy' => 'taw',
  'gjn' => 'alv',
  'otw' => 'alg',
  'hrv' => 'zls',
  'bgc' => 'inc',
  'sjw' => 'alg',
  'mon' => 'xgn',
  'txn' => 'plf',
  'ben' => 'inc',
  'mee' => 'pqe',
  'wlc' => 'bnt',
  'sjm' => 'pqw',
  'beq' => 'bnt',
  'ghn' => 'pqe',
  'smw' => 'pqw',
  'tnw' => 'phi',
  'sco' => 'gmw',
  'hsb' => 'wen',
  'ddd' => 'sdv',
  'smr' => 'pqw',
  'tpl' => 'omq',
  'amv' => 'plf',
  'yua' => 'myn',
  'tbc' => 'pqe',
  'nmy' => 'sit',
  'xpq' => 'alg',
  'xve' => 'ine',
  'jhi' => 'mkh',
  'jpr' => 'ira',
  'mdj' => 'csu',
  'nba' => 'bnt',
  'zlw' => 'sla',
  'sgd' => 'phi',
  'xce' => 'cel',
  'fkv' => 'fiu',
  'sns' => 'pqe',
  'lim' => 'gmw',
  'wen' => 'zlw',
  'tuf' => 'cba',
  'aoa' => 'cpp',
  'zap' => 'omq',
  'pcd' => 'roa',
  'sdt' => 'ine',
  'puy' => 'hok',
  'ido' => 'art',
  'avk' => 'art',
  'gly' => 'ssa',
  'mam' => 'myn',
  'osp' => 'roa',
  'kaz' => 'trk',
  'arg' => 'roa',
  'dws' => 'art',
  'aar' => 'cus',
  'nfr' => 'alv',
  'ojw' => 'alg',
  'hlu' => 'ine',
  'cmc' => 'pqw',
  'saj' => 'paa',
  'tkw' => 'pqe',
  'plf' => 'poz',
  'lui' => 'azc',
  'alg' => 'aql',
  'clw' => 'trk',
  'tbj' => 'pqe',
  'wln' => 'roa',
  'ori' => 'inc',
  'lsa' => 'ira',
  'gin' => 'ccn',
  'vec' => 'roa',
  'kum' => 'trk',
  'mtt' => 'pqe',
  'cos' => 'roa',
  'shs' => 'sal',
  'oua' => 'ber',
  'pre' => 'cpp',
  'ksg' => 'pqe',
  'bns' => 'inc',
  'tam' => 'dra',
  'xpr' => 'ira',
  'kic' => 'alg',
  'ybe' => 'trk',
  'som' => 'cus',
  'vot' => 'fiu',
  'krj' => 'phi',
  'tuc' => 'pqe',
  'xmm' => 'cpp',
  'ivv' => 'poz',
  'wwo' => 'pqe',
  'ncc' => 'pqe',
  'ree' => 'pqw',
  'goa' => 'dmn',
  'bts' => 'btk',
  'llk' => 'pqw',
  'asz' => 'pqe',
  'btb' => 'bnt',
  'hil' => 'phi',
  'vol' => 'art',
  'mfy' => 'azc',
  'xkq' => 'pqw',
  'vmb' => 'aus',
  'mog' => 'phi',
  'nmg' => 'bnt',
  'anw' => 'alv',
  'ile' => 'art',
  'bam' => 'dmn',
  'ruo' => 'roa',
  'btk' => 'pqw',
  'slz' => 'pqe',
  'kek' => 'myn',
  'bqj' => 'alv',
  'tsu' => 'fox',
  'tcb' => 'ath',
  'bni' => 'bnt',
  'pej' => 'hok',
  'nob' => 'gmq',
  'srr' => 'alv',
  'leu' => 'pqe',
  'agx' => 'ccn',
  'nno' => 'gmq',
  'teu' => 'ssa',
  'moh' => 'iro',
  'ext' => 'roa',
  'lcf' => 'pqw',
  'xaw' => 'azc',
  'uzs' => 'trk',
  'aba' => 'alv',
  'wdd' => 'bnt',
  'mmx' => 'pqe',
  'sin' => 'inc',
  'njx' => 'bnt',
  'tft' => 'paa',
  'pmt' => 'pqe',
  'ppi' => 'hok',
  'ell' => 'grk',
  'coz' => 'omq',
  'raj' => 'inc',
  'iai' => 'pqe',
  'zbc' => 'pqw',
  'nun' => 'tbq',
  'kea' => 'cpp',
  'hts' => 'khi',
  'mrm' => 'pqe',
  'gag' => 'trk',
  'mvo' => 'pqe',
  'roa' => 'itc',
  'tel' => 'dra',
  'gfk' => 'pqe',
  'mnp' => 'zhx',
  'wru' => 'pqw',
  'scn' => 'roa',
  'nha' => 'aus',
  'ero' => 'sit',
  'ist' => 'roa',
  'ina' => 'art',
  'pqw' => 'poz',
  'snd' => 'inc',
  'mxj' => 'tbq',
  'wyy' => 'pqe',
  'koa' => 'pqe',
  'wls' => 'pqe',
  'uga' => 'sem',
  'mqu' => 'sdv',
  'wal' => 'omv',
  'was' => 'hok',
  'dsb' => 'wen',
  'xld' => 'ine',
  'mxi' => 'roa',
  'bsh' => 'iir',
  'xao' => 'mkh',
  'smc' => 'cus',
  'lzz' => 'ccs',
  'soh' => 'alv',
  'met' => 'pqe',
  'srh' => 'ira',
  'gni' => 'aus',
  'jaz' => 'pqe',
  'ozm' => 'alv',
  'bgt' => 'pqe',
  'lug' => 'bnt',
  'tay' => 'fox',
  'blo' => 'alv',
  'ksh' => 'gmw',
  'xmg' => 'bai',
  'mot' => 'cba',
  'lus' => 'sit',
  'apw' => 'apa',
  'phn' => 'sem',
  'cym' => 'cel',
  'paa' => 'mul',
  'klb' => 'hok',
  'sat' => 'mun',
  'uge' => 'pqe',
  'xcl' => 'ine',
  'ssb' => 'pqw',
  'pma' => 'pqe',
  'keo' => 'sdv',
  'kal' => 'esx',
  'crz' => 'hok',
  'fra' => 'roa',
  'clc' => 'ath',
  'ank' => 'cdc',
  'loc' => 'phi',
  'sce' => 'xgn',
  'dbl' => 'aus',
  'ast' => 'roa',
  'cdo' => 'zhx',
  'nse' => 'bnt',
  'ita' => 'roa',
  'bej' => 'cus',
  'onu' => 'pqe',
  'nya' => 'bnt',
  'art' => 'mul',
  'gos' => 'gmw',
  'nxq' => 'sit',
  'kur' => 'ira',
  'ogc' => 'alv',
  'dez' => 'bnt',
  'bid' => 'cdc',
  'bbh' => 'mkh',
  'ijo' => 'alv',
  'tnt' => 'phi',
  'lbb' => 'pqe',
  'akr' => 'pqe',
  'bkc' => 'alv',
  'mbp' => 'cba',
  'ptp' => 'pqe',
  'mwr' => 'inc',
  'bot' => 'csu',
  'xto' => 'ine',
  'sah' => 'trk',
  'srm' => 'cpp',
  'ind' => 'pqw',
  'alq' => 'alg',
  'sba' => 'csu',
  'krc' => 'trk',
  'ora' => 'pqe',
  'mpu' => 'tup',
  'bim' => 'alv',
  'dgg' => 'pqe',
  'tlx' => 'pqe',
  'toq' => 'sdv',
  'yur' => 'aql',
  'osx' => 'gmw',
  'sbb' => 'pqe',
  'uzb' => 'trk',
  'mah' => 'pqe',
  'ctu' => 'myn',
  'tkr' => 'ccn',
  'lpx' => 'sdv',
  'yrl' => 'tup',
  'irr' => 'aav',
  'ttv' => 'pqe',
  'btx' => 'btk',
  'olr' => 'pqe',
  'ces' => 'zlw',
  'kjg' => 'mkh',
  'pmz' => 'omq',
  'grr' => 'ber',
  'naj' => 'alv',
  'ing' => 'ath',
  'goh' => 'gmw',
  'pel' => 'pqw',
  'tly' => 'ira',
  'tae' => 'awd',
  'mwi' => 'pqe',
  'bbc' => 'btk',
  'mbn' => 'awd',
  'niy' => 'csu',
  'otm' => 'oto',
  'kvh' => 'poz',
  'nnb' => 'bnt',
  'bja' => 'bnt',
  'syc' => 'sem',
  'bfl' => 'alv',
  'lpo' => 'tbq',
  'buk' => 'pqe',
  'rcf' => 'cpf',
  'kxu' => 'dra',
  'srd' => 'roa',
  'dny' => 'auf',
  'kde' => 'bnt',
  'vmk' => 'bnt',
  'kju' => 'hok',
  'gdd' => 'pqe',
  'nia' => 'pqw',
  'pot' => 'alg',
  'vko' => 'pqw',
  'tla' => 'azc',
  'duu' => 'tbq',
  'ekg' => 'ngf',
  'ame' => 'awd',
  'spp' => 'alv',
  'lcm' => 'pqe',
  'peb' => 'hok',
  'anx' => 'pqe',
  'scx' => 'ine',
  'huq' => 'cmc',
  'aie' => 'pqe',
  'tzo' => 'myn',
  'shx' => 'omv',
  'mji' => 'hmx',
  'qum' => 'myn',
  'bmq' => 'alv',
  'lbe' => 'ccn',
  'hau' => 'cdc',
  'tsn' => 'bnt',
  'gap' => 'plf',
  'zgh' => 'ber',
  'msb' => 'phi',
  'hok' => 'mul',
  'xkg' => 'dmn',
  'wow' => 'pqw',
  'irh' => 'pqe',
  'cat' => 'roa',
  'plu' => 'awd',
  'tox' => 'pqe',
  'sms' => 'smi',
  'brx' => 'tbq',
  'asb' => 'xsi',
  'ssa' => 'mul',
  'vai' => 'dmn',
  'tao' => 'poz',
  'pop' => 'pqe',
  'cpp' => 'roa',
  'fcs' => 'sgn',
  'amh' => 'sem',
  'mzs' => 'cpp',
  'mde' => 'ssa',
  'ptv' => 'pqe',
  'cgg' => 'bnt',
  'bdh' => 'csu',
  'sem' => 'afa',
  'xrg' => 'aus',
  'ajt' => 'sem',
  'ktn' => 'tup',
  'yue' => 'zhx',
  'kaw' => 'pqw',
  'hif' => 'inc',
  'fao' => 'gmq',
  'ajg' => 'alv',
  'nyf' => 'bnt',
  'egy' => 'afa',
  'nza' => 'alv',
  'yrk' => 'syd',
  'auq' => 'pqe',
  'kik' => 'bnt',
  'esq' => 'hok',
  'cjk' => 'bnt',
  'neu' => 'art',
  'kyj' => 'phi',
  'saq' => 'sdv',
  'mzw' => 'alv',
  'gqr' => 'phi',
  'bnk' => 'pqe',
  'bcu' => 'pqe',
  'aze' => 'trk',
  'spo' => 'sal',
  'peo' => 'ira',
  'psw' => 'pqe',
  'ybb' => 'bai',
  'mpy' => 'pqe',
  'eyo' => 'sdv',
  'nic' => 'mul',
  'qun' => 'sal',
  'pap' => 'cpp',
  'mjy' => 'alg',
  'tta' => 'xsi',
  'mnw' => 'xgn',
  'gux' => 'alv',
  'cji' => 'ccn',
  'eng' => 'gmw',
  'trn' => 'awd',
  'pse' => 'pqw',
  'mfq' => 'alv',
  'tau' => 'ath',
  'xsc' => 'ira',
  'rar' => 'pqe',
  'tuq' => 'ssa',
  'fax' => 'roa',
  'fas' => 'ira',
  'pkn' => 'aus',
  'rus' => 'zle',
  'nss' => 'pqe',
  'jnj' => 'omv',
  'adj' => 'alv',
  'cje' => 'cmc',
  'bip' => 'bnt',
  'tlv' => 'plf',
  'piz' => 'pqe',
  'cac' => 'myn',
  'kys' => 'pqw',
  'syr' => 'sem',
  'nua' => 'pqe',
  'eka' => 'nic',
  'sps' => 'pqe',
  'tgs' => 'pqe',
  'inh' => 'ccn',
  'hao' => 'pqe',
  'sxg' => 'sit',
  'qya' => 'art',
  'rsl' => 'sgn',
  'kjh' => 'trk',
  'aji' => 'pqe',
  'nij' => 'pqw',
  'alm' => 'pqe',
  'gla' => 'cel',
  'pib' => 'awd',
  'hnj' => 'hmx',
  'rml' => 'inc',
  'lij' => 'roa',
  'ypk' => 'esx',
  'dic' => 'kro',
  'bji' => 'cus',
  'hbs' => 'zls',
  'njm' => 'sit',
  'nrf' => 'roa',
  'xho' => 'bnt',
  'tzm' => 'ber',
  'sov' => 'pqe',
  'tlh' => 'art',
  'bez' => 'bnt',
  'sgz' => 'pqe',
  'myv' => 'fiu',
  'ssy' => 'cus',
  'nap' => 'roa',
  'vnk' => 'pqe',
  'jct' => 'trk',
  'acy' => 'sem',
  'pkg' => 'pqe',
  'yuy' => 'xgn',
  'see' => 'iro',
  'mkh' => 'aav',
  'mxr' => 'pqw',
  'ler' => 'pqe',
  'sla' => 'ine',
  'pnh' => 'pqe',
  'tmc' => 'cdc',
  'sag' => 'ngb',
  'tiv' => 'alv',
  'taw' => 'mul',
  'czo' => 'zhx',
  'ong' => 'fiu',
  'nan' => 'zhx',
  'guh' => 'awd',
  'urd' => 'inc',
  'lpa' => 'pqe',
  'kwk' => 'wak',
  'lah' => 'inc',
  'xgf' => 'azc',
  'mml' => 'mkh',
  'min' => 'pqw',
  'bkw' => 'bnt',
  'ntw' => 'iro',
  'sii' => 'mkh',
  'csn' => 'sgn',
  'ndf' => 'bat',
  'pix' => 'aus',
  'cui' => 'awd',
  'tuk' => 'trk',
  'pip' => 'cdc',
  'apu' => 'awd',
  'wni' => 'bnt',
  'ils' => 'sgn',
  'mpz' => 'cdc',
  'nuy' => 'aus',
  'slr' => 'trk',
  'rad' => 'cmc',
  'mnv' => 'pqe',
  'bib' => 'dmn',
  'bub' => 'xgn',
  'auf' => 'mul',
  'sjd' => 'smi',
  'tah' => 'pqe',
  'shr' => 'bnt',
  'mxb' => 'omq',
  'acf' => 'cpf',
  'sss' => 'aav',
  'sma' => 'smi',
  'mkv' => 'pqe',
  'xmz' => 'pqw',
  'acr' => 'myn',
  'nnh' => 'bai',
  'nrm' => 'pqw',
  'sbp' => 'bnt',
  'lag' => 'bnt',
  'nrn' => 'gmq',
  'dag' => 'alv',
  'tll' => 'bnt',
  'mdf' => 'fiu',
  'abr' => 'alv',
  'och' => 'zhx',
  'nsn' => 'pqe',
  'nkr' => 'pqe',
  'jgo' => 'bai',
  'txb' => 'ine',
  'xcb' => 'cel',
  'kqw' => 'pqe',
  'afa' => 'mul',
  'mga' => 'cel',
  'tpv' => 'pqe',
  'ers' => 'tbq',
  'kmj' => 'dra',
  'liw' => 'sal',
  'xpc' => 'trk',
  'aud' => 'pqe',
  'ncb' => 'mkh',
  'mft' => 'pqe',
  'tuy' => 'sdv',
  'oto' => 'omq',
  'gml' => 'gmw',
  'aia' => 'pqe',
  'vrs' => 'pqe',
  'swp' => 'pqe',
  'tpr' => 'tup',
  'mor' => 'alv',
  'gwt' => 'inc',
  'caq' => 'mkh',
  'quv' => 'myn',
  'txg' => 'sit',
  'pyu' => 'fox',
  'mfb' => 'pqw',
  'pra' => 'inc',
  'kei' => 'poz',
  'ewo' => 'bnt',
  'ems' => 'ypk',
  'udu' => 'ssa',
  'lun' => 'bnt',
  'guj' => 'inc',
  'muz' => 'sdv',
  'trk' => 'tut',
  'nld' => 'gmw',
  'div' => 'inc',
  'ban' => 'pqw',
  'omv' => 'afa',
  'ncf' => 'pqe',
  'yal' => 'dmn',
  'tup' => 'mul',
  'pon' => 'pqe',
  'xpu' => 'sem',
  'vif' => 'bnt',
  'ats' => 'alg',
  'heb' => 'sem',
  'wbp' => 'aus',
  'ztq' => 'omq',
  'cwt' => 'alv',
  'mme' => 'pqe',
  'biq' => 'pqe',
  'etn' => 'pqe',
  'pku' => 'pqw',
  'tvk' => 'pqe',
  'spa' => 'roa',
  'jpn' => 'jpx',
  'stp' => 'azc',
  'skr' => 'inc',
  'lin' => 'bnt',
  'fab' => 'cpp',
  'akk' => 'sem',
  'gcf' => 'cpf',
  'kbm' => 'pqe',
  'smn' => 'smi',
  'xsm' => 'alv',
  'wbk' => 'iir',
  'inp' => 'awd',
  'cpf' => 'roa',
  'mdh' => 'phi',
  'swx' => 'auf',
  'lik' => 'bnt',
  'pbo' => 'alv',
  'nqn' => 'pqe',
  'cba' => 'mul',
  'koy' => 'ath',
  'ipk' => 'esx',
  'eus' => 'euq',
  'tzh' => 'myn',
  'bzt' => 'art',
  'cdd' => 'mul',
  'sgl' => 'ira',
  'gyr' => 'tup',
  'sjo' => 'tuw',
  'yec' => 'gmw',
  'tnn' => 'pqe',
  'fwa' => 'pqe',
  'jav' => 'pqw',
  'veo' => 'hok',
  'lmu' => 'pqe',
  'mfv' => 'alv',
  'tbq' => 'sit',
  'bzh' => 'pqe',
  'bju' => 'alv',
  'lgk' => 'pqe',
  'hus' => 'myn',
  'kyh' => 'hok',
  'tnz' => 'mkh',
  'tet' => 'plf',
  'heh' => 'bnt',
  'swb' => 'bnt',
  'pov' => 'cpp',
  'fry' => 'gmw',
  'mrv' => 'pqe',
  'hrw' => 'pqe',
  'nyl' => 'aav',
  'din' => 'sdv',
  'sac' => 'alg',
  'cid' => 'hok',
  'myb' => 'csu',
  'ktz' => 'khi',
  'prn' => 'iir',
  'app' => 'pqe',
  'xbm' => 'cel',
  'vwa' => 'mkh',
  'nga' => 'alv',
  'vma' => 'aus',
  'acv' => 'hok',
  'emx' => 'inc',
  'rom' => 'inc',
  'wbl' => 'ira',
  'bos' => 'zls',
  'obi' => 'hok',
  'rou' => 'ssa',
  'kje' => 'plf',
  'uig' => 'trk',
  'zle' => 'sla',
  'poz' => 'map',
  'mhb' => 'bnt',
  'nso' => 'bnt',
  'oka' => 'sal',
  'unr' => 'mun',
  'swa' => 'swa',
  'rth' => 'phi',
  'dnj' => 'gmq',
  'tbz' => 'alv',
  'imy' => 'ine',
  'nci' => 'nah',
  'sqo' => 'ira',
  'lga' => 'pqe',
  'oru' => 'ira',
  'xcr' => 'ine',
  'kcj' => 'alv',
  'sdg' => 'inc',
  'lrz' => 'pqe',
  'ton' => 'pqe',
  'bkh' => 'bnt',
  'rif' => 'ber',
  'btz' => 'btk',
  'che' => 'ccn',
  'eve' => 'tuw',
  'pfl' => 'gmw',
  'kon' => 'bnt',
  'tab' => 'ccn',
  'ven' => 'bnt',
  'hit' => 'ine',
  'gct' => 'gmw',
  'mns' => 'fiu',
  'mwv' => 'pqw',
  'wae' => 'gmw',
  'pus' => 'ira',
  'gud' => 'kro',
  'sxr' => 'fox',
  'bax' => 'alv',
  'sav' => 'alv',
  'qvy' => 'sit',
  'hmd' => 'hmx',
  'bnr' => 'pqe',
  'son' => 'ssa',
  'sjr' => 'pqe',
  'tar' => 'azc',
  'jab' => 'alv',
  'tkl' => 'pqe',
  'avu' => 'csu',
  'kzc' => 'alv',
  'lub' => 'bnt',
  'yly' => 'pqe',
  'ndo' => 'bnt',
  'liv' => 'fiu',
  'lob' => 'alv',
  'dta' => 'xgn',
  'bcm' => 'pqe',
  'maq' => 'omq',
  'orm' => 'cus',
  'dtd' => 'wak',
  'iir' => 'ine',
  'sln' => 'hok',
  'chp' => 'ath',
  'tdn' => 'phi',
  'zaw' => 'omq',
  'kha' => 'mkh',
  'kld' => 'aus',
  'oku' => 'alv',
  'cqd' => 'hmx',
  'tyu' => 'bnt',
  'msa' => 'sal',
  'mri' => 'pqe',
  'haq' => 'bnt',
  'mrq' => 'pqe',
  'hch' => 'azc',
  'aca' => 'awd',
  'ady' => 'ccn',
  'xlc' => 'ine',
  'nog' => 'tut',
  'ddg' => 'paa',
  'lot' => 'sdv',
  'tdi' => 'pqw',
  'nem' => 'pqe',
  'gkn' => 'alv',
  'men' => 'dmn',
  'nal' => 'pqe',
  'aiw' => 'omv',
  'kmo' => 'paa',
  'efi' => 'alv',
  'gui' => 'tup',
  'haz' => 'ira',
  'siz' => 'ber',
  'ttb' => 'alv',
  'ary' => 'sem',
  'end' => 'poz',
  'lbj' => 'sit',
  'tdx' => 'pqw',
  'yej' => 'grk',
  'phi' => 'pqw',
  'xwc' => 'xsi',
  'iba' => 'pqw',
  'khi' => 'mul',
  'huo' => 'mkh',
  'adx' => 'tbq',
  'spx' => 'itc',
  'kvr' => 'pqw',
  'lww' => 'pqe',
  'frm' => 'roa',
  'snx' => 'sem',
  'lbn' => 'mkh',
  'kfa' => 'dra',
  'ath' => 'xnd',
  'san' => 'pra',
  'tnx' => 'pqe',
  'fud' => 'pqe',
  'ddi' => 'pqe',
  'xmk' => 'ine',
  'nqo' => 'nic',
  'kzu' => 'pqe',
  'oac' => 'tuw',
  'myl' => 'pqw',
  'ksk' => 'xsi',
  'cre' => 'alg',
  'sne' => 'dai',
  'njo' => 'tbq',
  'sus' => 'dmn',
  'knf' => 'alv',
  'nku' => 'alv',
  'gga' => 'pqe',
  'llf' => 'pqe',
  'cal' => 'pqe',
  'szn' => 'plf',
  'bhb' => 'inc',
  'shu' => 'sem',
  'xpi' => 'cel',
  'grn' => 'tup',
  'aau' => 'paa',
  'znd' => 'nic',
  'sje' => 'smi',
  'mgl' => 'pqe',
  'zen' => 'ber',
  'mla' => 'pqe',
  'mjv' => 'dra',
  'tlm' => 'pqe',
  'pef' => 'hok',
  'kdk' => 'pqe',
  'win' => 'xsi',
  'gez' => 'sem',
  'anz' => 'paa',
  'kdd' => 'aus',
  'nus' => 'sdv',
  'twm' => 'tbq',
  'bth' => 'dai',
  'cks' => 'cpf',
  'mvf' => 'xgn',
  'skf' => 'tup',
  'gil' => 'pqe',
  'cpg' => 'grk',
  'jkr' => 'sit',
  'fla' => 'sal',
  'mad' => 'pqw',
  'qwm' => 'trk',
  'bod' => 'tbq',
  'kac' => 'sit',
  'kmq' => 'ssa',
  'tha' => 'taw',
  'mdr' => 'pqw',
  'btm' => 'btk',
  'yij' => 'aus',
  'smy' => 'ira',
  'buh' => 'hmx',
  'rue' => 'zle',
  'ojs' => 'alg',
  'pnt' => 'grk',
  'hml' => 'hmx',
  'rwk' => 'bnt',
  'tlb' => 'paa',
  'run' => 'bnt',
  'bcq' => 'omv',
  'wiy' => 'aql',
  'aut' => 'pqe',
  'uhn' => 'ngf',
  'sad' => 'khi',
  'kog' => 'cba',
  'gay' => 'pqw',
  'guo' => 'awd',
  'niu' => 'pqe',
  'ctg' => 'inc',
  'squ' => 'sal',
  'urj' => 'mul',
  'xxk' => 'poz',
  'bak' => 'trk',
  'bxe' => 'afa',
  'sva' => 'ccs',
  'mwo' => 'pqe',
  'aua' => 'pqe',
  'dyu' => 'dmn',
  'xsy' => 'fox',
  'sij' => 'pqe',
  'ine' => 'mul',
  'ntm' => 'alv',
  'czh' => 'zhx',
  'rap' => 'pqe',
  'xpg' => 'ine',
  'gem' => 'ine',
  'hup' => 'ath',
  'mpr' => 'pqe',
  'aol' => 'poz',
  'kom' => 'fiu',
  'gmw' => 'gem',
  'tzj' => 'myn',
  'llu' => 'pqe',
  'mey' => 'sem',
  'zty' => 'omq',
  'oss' => 'ira',
  'mdx' => 'omv',
  'atj' => 'alg',
  'jra' => 'cmc',
  'pao' => 'azc',
  'mhy' => 'pqw',
  'ckb' => 'ira',
  'dru' => 'fox',
  'afh' => 'art',
  'paw' => 'cdd',
  'bra' => 'inc',
  'bin' => 'alv',
  'tat' => 'trk',
  'bas' => 'bnt',
  'nhd' => 'tup',
  'fij' => 'pqe',
  'dlm' => 'roa',
  'ilo' => 'phi',
  'xvn' => 'gme',
  'gri' => 'pqe',
  'cae' => 'alv',
  'inz' => 'hok',
  'rup' => 'roa',
  'yky' => 'alv',
  'alt' => 'trk',
  'kxv' => 'dra',
  'ppl' => 'azc',
  'urr' => 'pqe',
  'xmr' => 'ssa',
  'bgj' => 'alv',
  'mqm' => 'pqe',
  'wbm' => 'mkh',
  'nwc' => 'sit',
  'mlq' => 'dmn',
  'ceb' => 'phi',
  'egl' => 'roa',
  'yor' => 'alv',
  'sme' => 'smi',
  'lib' => 'pqe',
  'xeb' => 'sem',
  'bqc' => 'dmn',
  'mrw' => 'phi',
  'bhw' => 'pqe',
  'dra' => 'mul',
  'lmg' => 'pqe',
  'mas' => 'sdv',
  'khv' => 'ccn',
  'opt' => 'azc',
  'sol' => 'pqe',
  'sxl' => 'bat',
  'ayl' => 'sem',
  'aac' => 'cdd',
  'lbx' => 'pqw',
  'wha' => 'plf',
  'rug' => 'pqe',
  'mtq' => 'mkh',
  'cul' => 'auf',
  'tsr' => 'pqe',
  'lnd' => 'map',
  'pss' => 'pqe',
  'otk' => 'trk',
  'ntp' => 'azc',
  'tqp' => 'pqe',
  'tur' => 'trk',
  'sqi' => 'ine',
  'cps' => 'phi',
  'nee' => 'pqe',
  'kgk' => 'tup',
  'kdj' => 'sdv',
  'abi' => 'alv',
  'rmv' => 'art',
  'mzn' => 'ira',
  'lbv' => 'pqe',
  'mtd' => 'pqw',
  'pcj' => 'mun',
  'war' => 'phi',
  'cjh' => 'sal',
  'smo' => 'pqe',
  'osa' => 'xsi',
  'chm' => 'fiu',
  'sdo' => 'dai',
  'khq' => 'son',
  'dgr' => 'ath',
  'tub' => 'azc',
  'ada' => 'alv',
  'mar' => 'inc',
  'aii' => 'sem',
  'aul' => 'pqe',
  'ofs' => 'gmw',
  'cow' => 'sal',
  'guq' => 'tup',
  'ltz' => 'gmw',
  'mjt' => 'dra',
  'xnd' => 'mul',
  'ycn' => 'awd',
  'bwo' => 'omv',
  'lra' => 'dai',
  'dma' => 'bnt',
  'ksf' => 'bnt',
  'tva' => 'pqe',
  'com' => 'azc',
  'tgp' => 'pqe',
  'orc' => 'cus',
  'gan' => 'zhx',
  'kpc' => 'awd',
  'waj' => 'paa',
  'kcy' => 'son',
  'xgl' => 'bat',
  'far' => 'pqe',
  'ulc' => 'tuw',
  'gon' => 'dra',
  'apj' => 'apa',
  'cpx' => 'zhx',
  'ron' => 'roa',
  'kau' => 'ssa',
  'atk' => 'alv',
  'bzq' => 'pqe',
  'jbn' => 'ber',
  'cla' => 'roa',
  'kma' => 'alv',
  'ncn' => 'pqe',
  'lee' => 'alv',
  'kok' => 'inc',
  'tkg' => 'pqw',
  'ser' => 'azc',
  'mal' => 'dra',
  'xwe' => 'alv',
  'zhx' => 'sit',
  'hak' => 'zhx',
  'kjj' => 'ccn',
  'beg' => 'pqw',
  'tpc' => 'omq',
  'gmq' => 'gem',
  'bqz' => 'bnt',
  'aqa' => 'mul',
  'nok' => 'sal',
  'nmt' => 'pqe',
  'ngl' => 'bnt',
  'one' => 'iro',
  'ngf' => 'paa',
  'lbw' => 'pqw',
  'cjm' => 'cmc',
  'khw' => 'inc',
  'kjn' => 'aus',
  'sgc' => 'sdv',
  'kyi' => 'pqw',
  'nlg' => 'pqe',
  'bai' => 'alv',
  'arz' => 'sem',
  'tlr' => 'pqe',
  'gzn' => 'pqe',
  'kho' => 'ira',
  'cjs' => 'trk',
  'ykm' => 'ccn',
  'uli' => 'pqe',
  'aln' => 'ine',
  'pia' => 'azc',
  'brf' => 'bnt',
  'kbd' => 'ccn',
  'pnu' => 'hmx',
  'gme' => 'gem',
  'ccc' => 'awd',
  'lam' => 'nic',
  'hne' => 'inc',
  'xal' => 'xgn',
  'anc' => 'cdc',
  'mkj' => 'pqe',
  'ngc' => 'bnt',
  'apb' => 'pqe',
  'deu' => 'gmw',
  'naq' => 'khi',
  'xlb' => 'alg',
  'xzm' => 'bat',
  'gsw' => 'gmw',
  'tui' => 'alv',
  'mye' => 'bnt',
  'kff' => 'dra',
  'ray' => 'pqe',
  'bpn' => 'hmx',
  'byn' => 'cus',
  'sid' => 'cus',
  'lit' => 'bat',
  'nwb' => 'kro',
  'yaq' => 'azc',
  'pug' => 'alv',
  'noz' => 'omv',
  'xom' => 'ssa',
  'led' => 'csu',
  'rak' => 'pqe',
  'mrc' => 'hok',
  'fos' => 'fox',
  'dop' => 'alv',
  'trv' => 'fox',
  'yav' => 'alv',
  'jpx' => 'mul',
  'mwk' => 'dmn',
  'bgk' => 'mkh',
  'cri' => 'cpp',
  'neg' => 'tuw',
  'bph' => 'ccn',
  'kry' => 'ccn',
  'toi' => 'bnt',
  'kmb' => 'bnt',
  'rog' => 'cmc',
  'kuv' => 'ira',
  'bsu' => 'pqw',
  'ktq' => 'pqw',
  'bce' => 'alv',
  'kdt' => 'aav',
  'lmp' => 'alv',
  'ttu' => 'pqe',
  'ktm' => 'pqe',
  'pfa' => 'pqe',
  'yid' => 'gmw',
  'vro' => 'fiu',
  'tbl' => 'phi',
  'blr' => 'mkh',
  'gwc' => 'inc',
  'jic' => 'ath',
  'wmt' => 'aus',
  'gqi' => 'tbq',
  'bpa' => 'pqe',
  'ney' => 'kro',
  'epo' => 'art',
  'sob' => 'pqe',
  'frt' => 'pqe',
  'mlt' => 'sem',
  'pwn' => 'fox',
  'nuw' => 'pqe',
  'erg' => 'pqe',
  'zdj' => 'bnt',
  'non' => 'gmq',
  'arv' => 'cus',
  'xwo' => 'xgn',
  'mhc' => 'myn',
  'mlu' => 'pqe',
  'tyh' => 'mkh',
  'haa' => 'ath',
  'kdh' => 'alv',
  'nep' => 'inc',
  'hsn' => 'zhx',
  'dai' => 'pqw',
  'hun' => 'fiu',
  'peq' => 'hok',
  'kin' => 'bnt',
  'ixc' => 'omq',
  'olt' => 'bat',
  'wiv' => 'pqe',
  'bem' => 'bnt',
  'ach' => 'sdv',
  'woe' => 'pqe',
  'ple' => 'poz',
  'mia' => 'alg',
  'mag' => 'inc',
  'ltc' => 'zhx',
  'pha' => 'hmx',
  'nmb' => 'pqe',
  'mqy' => 'poz',
  'mqt' => 'paa',
  'wec' => 'kro',
  'crs' => 'cpf',
  'ons' => 'iro',
  'dob' => 'pqe',
  'ebu' => 'bnt',
  'lng' => 'gmw',
  'utp' => 'pqe',
  'ale' => 'esx',
  'poo' => 'hok',
  'bba' => 'alv',
  'sjn' => 'art',
  'kak' => 'phi',
  'mnr' => 'azc',
  'mmt' => 'pqe',
  'esu' => 'ypk',
  'ibo' => 'alv',
  'iow' => 'xsi',
  'guk' => 'ssa',
  'mhn' => 'gmw',
  'baa' => 'pqe',
  'mez' => 'alg',
  'kxs' => 'xgn',
  'klj' => 'trk',
  'dlg' => 'trk',
  'xnh' => 'mkh',
  'yum' => 'hok',
  'mna' => 'pqe',
  'bul' => 'zls',
  'mrb' => 'pqe',
  'kie' => 'ssa',
  'ber' => 'afa',
  'azc' => 'mul',
  'zbe' => 'pqw',
  'mse' => 'cdc',
  'cau' => 'mul',
  'gmh' => 'gmw',
  'svx' => 'bat',
  'coo' => 'sal',
  'sdc' => 'roa',
  'cay' => 'iro',
  'sal' => 'mul',
  'chy' => 'alg',
  'lcl' => 'map',
  'miz' => 'omq',
  'tus' => 'iro',
  'lua' => 'bnt',
  'bbj' => 'bai',
  'nzi' => 'alv',
  'fod' => 'alv',
  'iii' => 'sit',
  'bhp' => 'poz',
  'bal' => 'ira',
  'jdt' => 'ira',
  'gei' => 'pqe',
  'mxe' => 'pqe',
  'nmn' => 'khi',
  'glk' => 'ira',
  'grk' => 'ine',
  'isk' => 'ira',
  'brr' => 'pqe',
  'lmv' => 'pqe',
  'mra' => 'mkh',
  'fox' => 'map',
  'sda' => 'pqw',
  'kat' => 'ccs',
  'dij' => 'pqw',
  'zuh' => 'paa',
  'tif' => 'paa',
  'kay' => 'tup',
  'ddj' => 'aus',
  'mov' => 'hok',
  'bnq' => 'phi',
  'maf' => 'cdc',
  'iro' => 'mul',
  'zls' => 'sla',
  'piv' => 'pqe',
  'pex' => 'pqe',
  'sia' => 'smi',
  'knj' => 'myn',
  'taq' => 'ber',
  'bvb' => 'bnt',
  'vra' => 'pqe',
  'tzl' => 'art',
  'rmt' => 'inc',
  'crx' => 'ath',
  'azb' => 'trk',
  'bho' => 'inc',
  'nwi' => 'pqe',
  'lgn' => 'ssa',
  'kdo' => 'nic',
  'fmp' => 'bai',
  'ljp' => 'pqw',
  'qxq' => 'trk',
  'tjg' => 'pqw',
  'kax' => 'paa',
  'bug' => 'pqw',
  'lgr' => 'pqe',
  'eme' => 'tup',
  'got' => 'gme',
  'lil' => 'sal',
  'gba' => 'alv',
  'tpj' => 'tup',
  'bjk' => 'pqe',
  'rgn' => 'roa',
  'kyr' => 'tup',
  'kji' => 'pqe',
  'pim' => 'alg',
  'abq' => 'ccn',
  'aeb' => 'sem',
  'tqu' => 'paa',
  'kvq' => 'kar',
  'lre' => 'iro',
  'par' => 'azc',
  'lle' => 'pqe',
  'snv' => 'pqw',
  'shz' => 'alv',
  'asa' => 'bnt',
  'hoo' => 'bnt',
  'tgx' => 'ath',
  'nnd' => 'pqe',
  'mhq' => 'xsi',
  'aht' => 'ath',
  'doz' => 'omv',
  'lek' => 'pqe',
  'wli' => 'paa',
  'sdv' => 'ssa',
  'tnp' => 'pqe',
  'rka' => 'mkh',
  'tkp' => 'pqe',
  'aty' => 'pqe',
  'tik' => 'alv',
  'dar' => 'ccn',
  'mug' => 'cdc',
  'mln' => 'pqe',
  'pms' => 'roa',
  'kqr' => 'pqw',
  'tuv' => 'sdv',
  'stn' => 'pqe',
  'jac' => 'myn',
  'doi' => 'inc',
  'bxf' => 'pqe',
  'ndp' => 'bnt',
  'obt' => 'cel',
  'oaa' => 'tuw',
  'frc' => 'roa',
  'kxr' => 'pqe',
  'xgn' => 'tut',
  'wyr' => 'tup',
  'duw' => 'pqw',
  'blp' => 'pqe',
  'abs' => 'pqw',
  'roe' => 'pqe',
  'ccs' => 'cau',
  'czk' => 'zlw',
  'rmg' => 'gmq',
  'pdc' => 'gmw',
  'tir' => 'sem',
  'yao' => 'bnt',
  'pny' => 'alv',
  'koq' => 'bnt',
  'fit' => 'fiu',
  'ood' => 'azc',
  'usp' => 'myn',
  'txy' => 'pqw',
  'ppn' => 'pqe',
  'mfa' => 'pqw',
  'scl' => 'inc',
  'snf' => 'alv',
  'dor' => 'pqe',
  'xlg' => 'ine',
  'lce' => 'pqw',
  'dtp' => 'pqw',
  'ttc' => 'myn',
  'xmw' => 'pqw',
  'kij' => 'pqe',
  'bsg' => 'ira',
  'tfi' => 'alv',
  'xum' => 'itc',
  'sas' => 'pqw',
  'csb' => 'zlw',
  'pif' => 'pqe',
  'sog' => 'ira',
  'uun' => 'fox',
  'guc' => 'awd',
  'ndc' => 'bnt',
  'rof' => 'bnt',
  'apr' => 'pqe',
  'csu' => 'ssa',
  'kqs' => 'alv',
  'ltg' => 'bat',
  'bcr' => 'ath',
  'chg' => 'trk',
  'mvy' => 'inc',
  'dum' => 'gmw',
  'apc' => 'sem',
  'haw' => 'pqe',
  'tgi' => 'pqe',
  'pmq' => 'omq',
  'msq' => 'pqe',
  'zul' => 'bnt',
  'los' => 'pqe',
  'nrc' => 'cel',
  'wol' => 'alv',
  'alc' => 'aqa',
  'ium' => 'hmx',
  'akb' => 'btk',
  'khm' => 'mkh',
  'nym' => 'bnt',
  'bmv' => 'bnt',
  'xlo' => 'alg',
  'bci' => 'alv',
  'apa' => 'ath',
  'mgh' => 'bnt',
  'otr' => 'alv',
  'hei' => 'wak',
  'sml' => 'pqw',
  'vkl' => 'pqw',
  'pmo' => 'hok',
  'afb' => 'sem',
  'poh' => 'myn',
  'btd' => 'btk',
  'hid' => 'xsi',
  'fil' => 'phi',
  'uuu' => 'mkh',
  'tnl' => 'pqe',
  'pau' => 'pqw',
  'rmq' => 'inc',
  'pmn' => 'phi',
  'goo' => 'pqe',
  'gle' => 'cel',
  'bpy' => 'inc',
  'mte' => 'pqe',
  'agq' => 'alv',
  'prc' => 'ira',
  'smi' => 'fiu',
  'cia' => 'pqw',
  'wak' => 'mul',
  'zwa' => 'omv',
  'myu' => 'tup',
  'apk' => 'apa',
  'mic' => 'alg',
  'aka' => 'alv',
  'txs' => 'phi',
  'tcy' => 'dra',
  'ulu' => 'pqw',
  'hke' => 'bnt',
  'nio' => 'syd',
  'byv' => 'bai',
  'xbc' => 'ira',
  'xbp' => 'aus',
  'mql' => 'alv',
  'xcu' => 'bat',
  'bsq' => 'kro',
  'wuu' => 'zhx',
  'niq' => 'sdv',
  'sel' => 'syd',
  'caf' => 'ath',
  'ibl' => 'phi',
  'mlo' => 'alv',
  'abb' => 'bnt',
  'dml' => 'inc',
  'pbp' => 'alv',
  'ira' => 'iir',
  'yai' => 'ira',
  'ksd' => 'pqe',
  'anp' => 'ine',
  'jbo' => 'art',
  'xnb' => 'fox',
  'xog' => 'bnt',
  'cup' => 'azc',
  'khl' => 'pqe',
  'mhw' => 'bnt',
  'pgk' => 'pqe',
  'ngb' => 'alv',
  'vie' => 'mkh',
  'ang' => 'gmw',
  'hiw' => 'pqe',
  'zgr' => 'pqe',
  'cam' => 'pqe',
  'map' => 'mul',
  'abk' => 'ccn',
  'evn' => 'tuw',
  'vep' => 'fiu',
  'gwi' => 'ath',
  'bsc' => 'alv',
  'kas' => 'inc',
  'izh' => 'fiu',
  'kuu' => 'ath',
  'sei' => 'hok',
  'lfn' => 'art',
  'frr' => 'gmw',
  'tbe' => 'pqe',
  'tmi' => 'pqe',
  'nub' => 'sdv',
  'dmn' => 'nic',
  'sot' => 'bnt',
  'afr' => 'gmw',
  'llx' => 'pqe',
  'tmh' => 'ber',
  'lid' => 'pqe',
  'crc' => 'pqe',
  'kan' => 'dra',
  'ggt' => 'pqe',
  'bda' => 'alv',
  'chu' => 'zls',
  'mox' => 'pqe',
  'ley' => 'pqw',
  'gbu' => 'aus',
  'kjb' => 'myn',
  'ssf' => 'fox',
  'raz' => 'pqw',
  'sgn' => 'mul',
  'her' => 'bnt',
  'blf' => 'phi',
  'gdq' => 'sem',
  'nke' => 'pqe',
  'oji' => 'alg',
  'yii' => 'aus',
  'daa' => 'cdc',
  'nov' => 'art',
  'tmb' => 'pqe',
  'zim' => 'cdc',
  'chr' => 'iro',
  'ccp' => 'inc',
  'mtm' => 'syd',
  'lgu' => 'pqe',
  'lad' => 'roa',
  'pek' => 'pqe',
  'koo' => 'bnt',
  'abw' => 'ira',
  'ilk' => 'phi',
  'pme' => 'pqe',
  'cms' => 'ine',
  'cnu' => 'ber',
  'ili' => 'trk',
  'slm' => 'pqw',
  'nnz' => 'bai',
  'lme' => 'cdc',
  'bje' => 'hmx',
  'urv' => 'pqe',
  'kos' => 'pqe',
  'mkd' => 'zls',
  'thp' => 'sal',
  'chk' => 'pqe',
  'ixl' => 'myn',
  'iku' => 'esx',
  'eto' => 'bnt',
  'lao' => 'taw',
  'xsi' => 'pqe',
  'alv' => 'nic',
  'hmx' => 'mul',
  'mmg' => 'pqe',
  'zum' => 'ira',
  'inc' => 'iir',
  'ayb' => 'alv',
  'hoi' => 'xnd',
  'lhu' => 'tbq',
  'odt' => 'gmw',
  'orv' => 'zle',
  'cim' => 'gmw',
  'plq' => 'ine',
  'mlf' => 'mkh',
  'hin' => 'inc',
  'dzo' => 'sit',
  'mjg' => 'xgn',
  'loz' => 'bnt',
  'tnr' => 'alv',
  'fsl' => 'sgn',
  'tcx' => 'dra',
  'mnh' => 'alv',
  'gob' => 'awd',
  'cco' => 'omq',
  'ysr' => 'esx',
  'ynn' => 'hok',
  'rro' => 'pqe',
  'bre' => 'cel',
  'mrl' => 'pqe',
  'wym' => 'gmw',
  'mqn' => 'pqw',
  'ckv' => 'fox',
  'mls' => 'ssa',
  'lgl' => 'pqe',
  'swg' => 'gmw',
  'lrv' => 'pqe',
  'mop' => 'myn',
  'ski' => 'poz',
  'grc' => 'grk',
  'smj' => 'smi',
  'zmw' => 'bnt',
  'kir' => 'trk',
  'psm' => 'tup',
  'mni' => 'sit',
  'tgc' => 'pqe',
  'keu' => 'alv',
  'hbu' => 'plf',
  'szl' => 'zlw',
  'rut' => 'ccn',
  'uve' => 'pqe',
  'mgo' => 'alv',
  'sds' => 'ber',
  'ccn' => 'cau',
  'hmn' => 'hmx',
  'xco' => 'ira',
  'sht' => 'hok',
  'smp' => 'sem',
  'mcn' => 'cdc',
  'ldp' => 'bnt',
  'oci' => 'roa',
  'zea' => 'gmw',
  'mqa' => 'pqe',
  'irk' => 'cus',
  'clm' => 'sal',
  'nmk' => 'pqe',
  'cak' => 'myn',
  'cwg' => 'mkh',
  'mmy' => 'cdc',
  'arc' => 'sem',
  'cjy' => 'zhx',
  'cha' => 'pqw',
  'tac' => 'azc',
  'tfn' => 'xnd',
  'pli' => 'pra',
  'isl' => 'gmq',
  'akv' => 'ccn',
  'del' => 'alg',
  'dhv' => 'pqe',
  'xaa' => 'sem',
  'wic' => 'cdd',
  'nde' => 'bnt',
  'por' => 'roa',
  'has' => 'wak',
  'huz' => 'ccn',
  'kwz' => 'khi',
  'bkk' => 'inc',
  'nor' => 'gmq',
  'ara' => 'sem',
  'mzm' => 'alv',
  'kpz' => 'sdv',
  'wuv' => 'pqe',
  'kab' => 'ber',
  'acw' => 'sem',
  'urh' => 'alv',
  'rkm' => 'dmn',
  'tum' => 'bnt',
  'pbs' => 'omq',
  'lol' => 'bnt',
  'sor' => 'cdc',
  'syd' => 'urj',
  'lht' => 'pqe',
  'sku' => 'pqe',
  'kxd' => 'pqw',
  'ask' => 'iir',
  'pil' => 'alv',
  'vrt' => 'pqe',
  'mkm' => 'pqw',
  'moe' => 'alg',
  'pqe' => 'poz',
  'klv' => 'pqe',
  'pdo' => 'pqw',
  'myn' => 'mul',
  'zbl' => 'art',
  'phl' => 'inc',
  'mai' => 'inc',
  'tec' => 'sdv',
  'tyv' => 'trk',
  'hye' => 'ine',
  'nds' => 'gmw',
  'uvl' => 'pqe',
  'bnn' => 'fox',
  'rej' => 'pqw',
  'zuy' => 'cdc',
  'ign' => 'awd',
  'goq' => 'pqw',
  'cou' => 'alv',
  'pol' => 'zlw',
  'jya' => 'tbq',
  'kua' => 'bnt',
  'kaa' => 'trk',
  'hoc' => 'mun',
  'dtr' => 'pqw',
  'hmr' => 'sit',
  'krx' => 'alv',
  'nsg' => 'sdv',
  'brh' => 'dra',
  'lmo' => 'roa',
  'gro' => 'tbq',
  'bno' => 'phi',
  'bhc' => 'pqe',
  'mfe' => 'cpf',
  'kia' => 'trk',
  'hat' => 'cpf',
  'krl' => 'fiu',
  'fut' => 'pqe',
  'tsj' => 'sit',
  'tbf' => 'pqe',
  'dzg' => 'ssa',
  'sbe' => 'pqe',
  'mun' => 'aav',
  'bwd' => 'pqe',
  'cbn' => 'mkh',
  'lky' => 'sdv',
  'tig' => 'sem',
  'kws' => 'bnt',
  'ewe' => 'alv',
  'grt' => 'sit',
  'kcm' => 'csu',
  'lch' => 'bnt',
  'gur' => 'alv',
  'var' => 'azc',
  'upv' => 'pqe',
  'dan' => 'gmq',
  'omb' => 'pqe',
  'sto' => 'xsi',
  'crv' => 'mkh',
  'lti' => 'plf',
  'dim' => 'omv',
  'bkm' => 'alv',
  'snq' => 'bnt',
  'bxa' => 'pqe',
  'dak' => 'xsi',
  'srp' => 'zls',
  'myh' => 'wak',
  'mky' => 'pqe',
  'udm' => 'fiu',
  'esx' => 'mul',
  'brg' => 'awd',
  'bjj' => 'inc',
  'isg' => 'sgn',
  'chl' => 'azc',
  'xls' => 'ine',
  'peh' => 'xgn',
  'prg' => 'bat',
  'ddo' => 'ccn',
  'nyo' => 'nic',
  'noc' => 'wak',
  'mhs' => 'plf',
  'goy' => 'alv',
  'dje' => 'son',
  'bch' => 'pqe',
  'bvd' => 'pqe',
  'fap' => 'alv',
  'kar' => 'sit',
  'swc' => 'swa',
  'pwg' => 'pqe',
  'shy' => 'ber',
  'akl' => 'phi',
  'kkk' => 'pqe',
  'loj' => 'pqe',
  'bwt' => 'bnt',
  'pad' => 'auf',
  'txh' => 'ine',
  'xsv' => 'bat',
  'bck' => 'aus',
  'skh' => 'pqw',
  'kvc' => 'pqe',
  'lkn' => 'pqe',
  'sya' => 'pqw',
  'onw' => 'nub',
  'pan' => 'inc',
  'nau' => 'pqe',
  'bdr' => 'pqw',
  'ttt' => 'ira',
  'glv' => 'cel',
  'ave' => 'ira',
  'bik' => 'phi',
  'mww' => 'hmx',
  'ubr' => 'pqe',
  'nnt' => 'alg',
  'grb' => 'kro',
  'mhj' => 'xgn',
  'jrb' => 'sem',
  'awd' => 'mul',
  'kpn' => 'tup',
  'ngr' => 'pqe',
  'kzk' => 'pqe',
  'gmb' => 'pqe',
  'cro' => 'xsi',
  'lkt' => 'xsi',
  'nxm' => 'ber',
  'str' => 'sal',
  'ynk' => 'ypk',
  'stw' => 'pqe',
  'mek' => 'pqe',
  'sdn' => 'roa',
  'tkq' => 'alv',
  'maj' => 'omq',
  'ruq' => 'roa',
  'duq' => 'pqw',
  'beh' => 'alv',
  'ava' => 'ccn',
  'snk' => 'dmn',
  'har' => 'sem',
  'cdc' => 'afa',
  'cop' => 'afa',
  'kln' => 'sdv',
  'sit' => 'mul',
  'mdi' => 'csu',
  'mlg' => 'pqw',
  'pbg' => 'awd',
  'qyp' => 'alg',
  'ddn' => 'son',
  'bla' => 'alg',
  'trs' => 'omq',
  'kyk' => 'phi',
  'ofo' => 'xsi',
  'nyn' => 'bnt',
  'kca' => 'fiu',
  'tvl' => 'pqe',
  'rri' => 'pqe',
  'cwe' => 'bnt',
  'hoa' => 'pqe',
  'yka' => 'pqw',
  'hro' => 'cmc',
  'azo' => 'alv',
  'prt' => 'mkh',
  'coc' => 'hok',
  'kjk' => 'pqw',
  'knu' => 'dmn',
  'mmr' => 'hmx',
  'est' => 'fiu',
  'zng' => 'mkh',
  'nnc' => 'cdc',
  'kii' => 'cdd',
  'tli' => 'xnd',
  'ldm' => 'alv',
  'hla' => 'pqe',
  'zne' => 'znd',
  'alz' => 'sdv',
  'auh' => 'bnt',
  'erk' => 'pqe'
};
#-*-perl-*-

=head1 SUBROUTINES

=head2 @langcodes = language_group( $groupcode )

Returns a list of language codes within the given language group.

=cut


sub language_group{
    my %children = ();
    if (exists $$LanguageGroup{$_[0]}){
	foreach my $l (@{$$LanguageGroup{$_[0]}}){
	    if (exists $$LanguageGroup{$l}){
		foreach (&language_group($l)){
		    $children{$_}++;
		}
	    }
	    else{
		$children{$l}++;
	    }
	}
    }
    else{
	return ($_[0]);
    }
    return sort keys %children;
}


=head2 @langcodes = language_group_children( $groupcode )

Returns a list of language codes that are immediate children of the given language group.

=cut

sub language_group_children{
    if (exists $$LanguageGroup{$_[0]}){
	return @{$$LanguageGroup{$_[0]}};
    }
    print STDERR "unknown language group $_[0]\n";
    return ();
}


=head2 @parentcode = language_group( $langcode )

Returns the parent language code for the given language.

=cut


sub language_parent{
    if (exists $$LanguageParent{$_[0]}){
	return $$LanguageParent{$_[0]};
    }
    print STDERR "no parent found for '$_[0]'\n";
    return undef;
}


## don't need the functions below, just use ISO::639::3
##

# =head2 $name = language_group_name( $groupcode )

# Returns the name of the language group

# =cut


# sub language_group_name{
#     return ISO::639::3::get_language_name($_[0]);
# }


# =head2 $code = language_group_code( $groupname )

# Returns the name of the language group

# =cut


# sub language_group_name{
#     return ISO::639::3::get_iso639_3($_[0]);
# }



1;

