/*
 * Decompiled with CFR 0.152.
 */
import com.touchgraph.graphlayout.Edge;
import com.touchgraph.graphlayout.Node;
import com.touchgraph.graphlayout.TGException;
import com.touchgraph.graphlayout.graphelements.GraphEltSet;
import com.touchgraph.graphlayout.graphelements.TGForEachEdge;
import com.touchgraph.graphlayout.graphelements.TGForEachNode;
import com.touchgraph.linkbrowser.LBEdge;
import com.touchgraph.linkbrowser.LBNode;
import java.awt.Color;
import java.awt.Point;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import net.n3.nanoxml.IXMLElement;
import net.n3.nanoxml.IXMLParser;
import net.n3.nanoxml.IXMLReader;
import net.n3.nanoxml.StdXMLReader;
import net.n3.nanoxml.XMLElement;
import net.n3.nanoxml.XMLParserFactory;
import net.n3.nanoxml.XMLWriter;

public class C103to120 {
    GraphEltSet graphEltSet = new GraphEltSet();

    C103to120() {
    }

    public void read(String string) throws Exception {
        FileInputStream fileInputStream = new FileInputStream(string);
        IXMLParser iXMLParser = XMLParserFactory.createDefaultXMLParser();
        StdXMLReader stdXMLReader = new StdXMLReader((InputStream)fileInputStream);
        iXMLParser.setReader((IXMLReader)stdXMLReader);
        IXMLElement iXMLElement = null;
        try {
            iXMLElement = (IXMLElement)iXMLParser.parse();
        }
        catch (Exception exception) {
            System.out.println("LINE " + stdXMLReader.getLineNr());
            exception.printStackTrace();
        }
        ((InputStream)fileInputStream).close();
        this.buildGraphEltSet(iXMLElement);
    }

    private boolean getBooleanAttr(IXMLElement iXMLElement, String string, boolean bl) {
        String string2 = iXMLElement.getAttribute(string, bl ? "true" : "false");
        return string2.toLowerCase().equals("true");
    }

    private String encodeColor(Color color) {
        if (color == null) {
            return null;
        }
        int n = color.getRGB() & 0xFFFFFF;
        String string = "000000";
        String string2 = Integer.toHexString(n);
        return (string.substring(string2.length()) + string2).toUpperCase();
    }

    public void buildGraphEltSet(IXMLElement iXMLElement) throws TGException {
        LBNode lBNode;
        String string;
        int n;
        int n2;
        String string2;
        String string3;
        Object object;
        IXMLElement iXMLElement2;
        IXMLElement iXMLElement3 = (IXMLElement)iXMLElement.getChildrenNamed("NODESET").firstElement();
        Enumeration enumeration = iXMLElement3.enumerateChildren();
        while (enumeration.hasMoreElements()) {
            iXMLElement2 = (IXMLElement)enumeration.nextElement();
            object = iXMLElement2.getAttribute("name", " ");
            string3 = iXMLElement2.getAttribute("url", " ");
            string2 = iXMLElement2.getAttribute("hint", "");
            int n3 = iXMLElement2.getAttribute("x", 0);
            n2 = iXMLElement2.getAttribute("y", 0);
            n = iXMLElement2.getAttribute("col", 0);
            Color color = Color.black;
            try {
                String string4 = iXMLElement2.getAttribute("color", "#000000");
                color = Color.decode(string4);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            boolean bl = this.getBooleanAttr(iXMLElement2, "urlIsLocal", false);
            boolean bl2 = this.getBooleanAttr(iXMLElement2, "urlIsXML", false);
            string = iXMLElement2.getAttribute("nodeID", null);
            if (string == null) {
                throw new TGException(3, "node has no ID");
            }
            lBNode = new LBNode(string, (String)object, string3);
            lBNode.setVisible(true);
            lBNode.setURLIsLocal(bl);
            lBNode.setURLIsXML(bl2);
            lBNode.setLocation(new Point(n3, n2));
            lBNode.setHint(string2);
            switch (n) {
                case 0: {
                    lBNode.setBackColor(color);
                    break;
                }
                case 1: {
                    lBNode.setBackColor(new Color(160, 64, 0));
                    break;
                }
                case 2: {
                    lBNode.setBackColor(new Color(64, 160, 0));
                    break;
                }
                case 3: {
                    lBNode.setBackColor(new Color(0, 0, 224));
                    break;
                }
                default: {
                    lBNode.setBackColor(color);
                }
            }
            this.graphEltSet.addNode((Node)lBNode);
        }
        iXMLElement2 = (IXMLElement)iXMLElement.getChildrenNamed("EDGESET").firstElement();
        object = iXMLElement2.enumerateChildren();
        while (object.hasMoreElements()) {
            String string5;
            string3 = (IXMLElement)object.nextElement();
            string2 = string3.getAttribute("fromID", null);
            String string6 = string3.getAttribute("toID", null);
            n2 = string3.getAttribute("tension", 4000);
            n = string3.getAttribute("length", 4000);
            int n4 = string3.getAttribute("type", 1);
            if (n == 0) {
                n = n2;
            }
            Color color = Edge.DEFAULT_COLOR;
            try {
                string5 = string3.getAttribute("color", null);
                if (string5 != null) {
                    color = Color.decode(string5);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            string5 = (LBNode)this.graphEltSet.findNode(string2);
            string = (LBNode)this.graphEltSet.findNode(string6);
            lBNode = new LBEdge((LBNode)string5, (LBNode)string, n / 100);
            lBNode.setVisible(true);
            lBNode.setColor(color);
            switch (n4) {
                case 0: {
                    lBNode.edgeType = 0;
                    break;
                }
                case 1: {
                    lBNode.edgeType = 1;
                    break;
                }
                default: {
                    lBNode.edgeType = 0;
                }
            }
            this.graphEltSet.addEdge((Edge)lBNode);
        }
    }

    public void write(String string) throws Exception {
        int n;
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        XMLElement xMLElement = new XMLElement("TOUCHGRAPH_LB");
        xMLElement.setAttribute("version", "1.20");
        final XMLElement xMLElement2 = new XMLElement("NODESET");
        xMLElement.addChild((IXMLElement)xMLElement2);
        TGForEachNode tGForEachNode = new TGForEachNode(){

            public void forEachNode(Node node) {
                LBNode lBNode = (LBNode)node;
                XMLElement xMLElement = new XMLElement("NODE");
                xMLElement.setAttribute("nodeID", lBNode.getID());
                XMLElement xMLElement22 = new XMLElement("NODE_LOCATION");
                xMLElement22.setAttribute("x", "" + (int)lBNode.getLocation().getX());
                xMLElement22.setAttribute("y", "" + (int)lBNode.getLocation().getY());
                xMLElement22.setAttribute("visible", lBNode.isVisible() ? "true" : "false");
                xMLElement.addChild((IXMLElement)xMLElement22);
                XMLElement xMLElement3 = new XMLElement("NODE_LABEL");
                xMLElement3.setAttribute("label", lBNode.getLabel());
                xMLElement3.setAttribute("shape", "" + lBNode.getType());
                xMLElement3.setAttribute("backColor", C103to120.this.encodeColor(lBNode.getBackColor()));
                xMLElement3.setAttribute("textColor", C103to120.this.encodeColor(lBNode.getTextColor()));
                xMLElement3.setAttribute("fontSize", "" + lBNode.getFont().getSize());
                xMLElement.addChild((IXMLElement)xMLElement3);
                XMLElement xMLElement4 = new XMLElement("NODE_URL");
                xMLElement4.setAttribute("url", lBNode.getURL());
                xMLElement4.setAttribute("urlIsLocal", lBNode.getURLIsLocal() ? "true" : "false");
                xMLElement4.setAttribute("urlIsXML", lBNode.getURLIsXML() ? "true" : "false");
                xMLElement.addChild((IXMLElement)xMLElement4);
                XMLElement xMLElement5 = new XMLElement("NODE_HINT");
                xMLElement5.setAttribute("hint", lBNode.getHint());
                xMLElement5.setAttribute("width", "" + lBNode.getHintWidth());
                xMLElement5.setAttribute("height", "" + lBNode.getHintHeight());
                xMLElement5.setAttribute("isHTML", lBNode.getHintIsHTML() ? "true" : "false");
                xMLElement.addChild((IXMLElement)xMLElement5);
                xMLElement2.addChild((IXMLElement)xMLElement);
            }
        };
        this.graphEltSet.forAllNodes(tGForEachNode);
        final XMLElement xMLElement3 = new XMLElement("EDGESET");
        xMLElement.addChild((IXMLElement)xMLElement3);
        TGForEachEdge tGForEachEdge = new TGForEachEdge(){

            public void forEachEdge(Edge edge) {
                LBEdge lBEdge = (LBEdge)edge;
                XMLElement xMLElement = new XMLElement("EDGE");
                xMLElement.setAttribute("fromID", lBEdge.getFrom().getID());
                xMLElement.setAttribute("toID", lBEdge.getTo().getID());
                xMLElement.setAttribute("type", "" + lBEdge.getType());
                xMLElement.setAttribute("length", "" + lBEdge.getLength());
                xMLElement.setAttribute("visible", lBEdge.isVisible() ? "true" : "false");
                xMLElement.setAttribute("color", C103to120.this.encodeColor(lBEdge.getColor()));
                xMLElement3.addChild((IXMLElement)xMLElement);
            }
        };
        this.graphEltSet.forAllEdges(tGForEachEdge);
        XMLElement xMLElement4 = new XMLElement("PARAMETERS");
        xMLElement.addChild((IXMLElement)xMLElement4);
        InputStream inputStream = this.getClass().getResourceAsStream("/TG_Prepend_DTD.xml");
        while ((n = inputStream.read()) != -1) {
            ((OutputStream)fileOutputStream).write(n);
        }
        inputStream.close();
        XMLWriter xMLWriter = new XMLWriter((OutputStream)fileOutputStream);
        xMLWriter.write((IXMLElement)xMLElement, true);
        ((OutputStream)fileOutputStream).close();
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 2) {
            System.out.println("Usage: C103to120 source_file destination_file");
            return;
        }
        C103to120 c103to120 = new C103to120();
        try {
            c103to120.read(stringArray[0]);
            c103to120.write(stringArray[1]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

