/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.ChannelHelper;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoTypeReader;
import com.coremedia.iso.IsoTypeWriter;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.CastUtils;
import com.coremedia.iso.boxes.ContainerBox;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.logging.Logger;

public abstract class AbstractBoxParser
implements BoxParser {
    private static Logger LOG = Logger.getLogger(AbstractBoxParser.class.getName());

    public abstract Box createBox(String var1, byte[] var2, String var3);

    public Box parseBox(ReadableByteChannel byteChannel, ContainerBox parent) throws IOException {
        long contentSize;
        ByteBuffer bb;
        ByteBuffer header = ChannelHelper.readFully(byteChannel, 8L);
        long size = IsoTypeReader.readUInt32(header);
        if (size < 8L && size > 1L) {
            LOG.severe("Plausibility check failed: size < 8 (size = " + size + "). Stop parsing!");
            return null;
        }
        String type = IsoTypeReader.read4cc(header);
        String prefix = "";
        boolean iWant = false;
        if (iWant) {
            ContainerBox t = parent.getParent();
            while (t != null) {
                prefix = String.valueOf(t.getType()) + "/" + prefix;
                t = t.getParent();
            }
        }
        byte[] usertype = null;
        if (size == 1L) {
            bb = ByteBuffer.allocate(8);
            byteChannel.read(bb);
            bb.rewind();
            size = IsoTypeReader.readUInt64(bb);
            contentSize = size - 16L;
        } else if (size == 0L) {
            if (!(byteChannel instanceof FileChannel)) {
                throw new RuntimeException("Only FileChannel inputs may use size == 0 (box reaches to the end of file)");
            }
            size = ((FileChannel)byteChannel).size() - ((FileChannel)byteChannel).position() - 8L;
            contentSize = size - 8L;
        } else {
            contentSize = size - 8L;
        }
        if ("uuid".equals(type)) {
            bb = ByteBuffer.allocate(16);
            byteChannel.read(bb);
            bb.rewind();
            usertype = bb.array();
            contentSize -= 16L;
        }
        Box box = this.createBox(type, usertype, parent.getType());
        box.setParent(parent);
        LOG.finest("Parsing " + box.getType());
        if (CastUtils.l2i(size - contentSize) == 8) {
            header.rewind();
        } else if (CastUtils.l2i(size - contentSize) == 16) {
            header = ByteBuffer.allocate(16);
            IsoTypeWriter.writeUInt32(header, 1L);
            header.put(IsoFile.fourCCtoBytes(type));
            IsoTypeWriter.writeUInt64(header, size);
        } else if (CastUtils.l2i(size - contentSize) == 24) {
            header = ByteBuffer.allocate(24);
            IsoTypeWriter.writeUInt32(header, size);
            header.put(IsoFile.fourCCtoBytes(type));
            header.put(usertype);
        } else if (CastUtils.l2i(size - contentSize) == 32) {
            header = ByteBuffer.allocate(32);
            IsoTypeWriter.writeUInt32(header, size);
            header.put(IsoFile.fourCCtoBytes(type));
            IsoTypeWriter.writeUInt64(header, size);
            header.put(usertype);
        } else {
            throw new RuntimeException("I didn't expect that");
        }
        box.parse(byteChannel, header, contentSize, this);
        assert (size == box.getSize()) : "Reconstructed Size is not x to the number of parsed bytes! (" + box.getType() + ")" + " Actual Box size: " + size + " Calculated size: " + box.getSize();
        return box;
    }
}

