/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.util;

import com.coremedia.iso.IsoFile;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.ContainerBox;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Path {
    IsoFile isoFile;
    private static Pattern component = Pattern.compile("(....)(\\[(.*)\\])?");

    public Path(IsoFile isoFile) {
        this.isoFile = isoFile;
    }

    public String createPath(Box box) {
        return this.createPath(box, "");
    }

    private String createPath(Box box, String path) {
        if (box instanceof IsoFile) {
            assert (box == this.isoFile);
            return path;
        }
        List<?> boxesOfBoxType = box.getParent().getBoxes(box.getClass());
        int index = boxesOfBoxType.indexOf(box);
        path = index != 0 ? String.valueOf(String.format("/%s[%d]", box.getType(), index)) + path : String.valueOf(String.format("/%s", box.getType())) + path;
        return this.createPath(box.getParent(), path);
    }

    public Box getPath(String path) {
        return this.getPath(this.isoFile, path);
    }

    private Box getPath(Box box, String path) {
        String now;
        String later;
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.isEmpty()) {
            return box;
        }
        if (path.contains("/")) {
            later = path.substring(path.indexOf(47));
            now = path.substring(0, path.indexOf(47));
        } else {
            now = path;
            later = "";
        }
        Matcher m = component.matcher(now);
        if (m.matches()) {
            String type = m.group(1);
            int index = 0;
            if (m.group(2) != null) {
                String indexString = m.group(3);
                index = Integer.parseInt(indexString);
            }
            for (Box box1 : ((ContainerBox)box).getBoxes()) {
                if (!box1.getType().equals(type)) continue;
                if (index == 0) {
                    return this.getPath(box1, later);
                }
                --index;
            }
            return null;
        }
        throw new RuntimeException("invalid path.");
    }
}

