/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hmef.attribute;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hmef.attribute.MAPIDateAttribute;
import org.apache.poi.hmef.attribute.MAPIRtfAttribute;
import org.apache.poi.hmef.attribute.MAPIStringAttribute;
import org.apache.poi.hmef.attribute.TNEFAttribute;
import org.apache.poi.hmef.attribute.TNEFProperty;
import org.apache.poi.hsmf.datatypes.MAPIProperty;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.IOUtils;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MAPIAttribute {
    private final MAPIProperty property;
    private final int type;
    private final byte[] data;

    public MAPIAttribute(MAPIProperty property, int type, byte[] data) {
        this.property = property;
        this.type = type;
        this.data = data;
    }

    public MAPIProperty getProperty() {
        return this.property;
    }

    public int getType() {
        return this.type;
    }

    public byte[] getData() {
        return this.data;
    }

    public String toString() {
        String hex;
        if (this.data.length <= 16) {
            hex = HexDump.toHex(this.data);
        } else {
            byte[] d = new byte[16];
            System.arraycopy(this.data, 0, d, 0, 16);
            hex = HexDump.toHex(d);
            hex = hex.substring(0, hex.length() - 1) + ", ....]";
        }
        return this.property.toString() + " " + hex;
    }

    public static List<MAPIAttribute> create(TNEFAttribute parent) throws IOException {
        if (parent.getProperty() != TNEFProperty.ID_MAPIPROPERTIES && parent.getProperty() != TNEFProperty.ID_ATTACHMENT) {
            throw new IllegalArgumentException("Can only create from a MAPIProperty attribute, instead received a " + parent.getProperty() + " one");
        }
        ByteArrayInputStream inp = new ByteArrayInputStream(parent.getData());
        int count = LittleEndian.readInt(inp);
        ArrayList<MAPIAttribute> attrs = new ArrayList<MAPIAttribute>();
        for (int i = 0; i < count; ++i) {
            int typeAndMV = LittleEndian.readUShort(inp);
            int id = LittleEndian.readUShort(inp);
            boolean isMV = false;
            boolean isVL = false;
            int type = typeAndMV;
            if ((typeAndMV & 0x1000) > 0) {
                isMV = true;
                type -= 4096;
            }
            if (type == 30 || type == 31 || type == 258 || type == 13) {
                isVL = true;
            }
            MAPIProperty prop = MAPIProperty.get(id);
            if (id >= 32768 && id <= 65535) {
                String name;
                byte[] guid = new byte[16];
                IOUtils.readFully(inp, guid);
                int mptype = LittleEndian.readInt(inp);
                if (mptype == 0) {
                    int mpid = LittleEndian.readInt(inp);
                    MAPIProperty base = MAPIProperty.get(mpid);
                    name = base.name;
                } else {
                    int mplen = LittleEndian.readInt(inp);
                    byte[] mpdata = new byte[mplen];
                    IOUtils.readFully(inp, mpdata);
                    name = StringUtil.getFromUnicodeLE(mpdata, 0, mplen / 2 - 1);
                    MAPIAttribute.skipToBoundary(mplen, inp);
                }
                prop = MAPIProperty.createCustom(id, type, name);
            }
            if (prop == MAPIProperty.UNKNOWN) {
                prop = MAPIProperty.createCustom(id, type, "(unknown " + Integer.toHexString(id) + ")");
            }
            int values = 1;
            if (isMV || isVL) {
                values = LittleEndian.readInt(inp);
            }
            for (int j = 0; j < values; ++j) {
                int len = MAPIAttribute.getLength(type, inp);
                byte[] data = new byte[len];
                IOUtils.readFully(inp, data);
                MAPIAttribute.skipToBoundary(len, inp);
                MAPIAttribute attr = type == 31 || type == 30 ? new MAPIStringAttribute(prop, type, data) : (type == 7 || type == 64 ? new MAPIDateAttribute(prop, type, data) : (id == MAPIProperty.RTF_COMPRESSED.id ? new MAPIRtfAttribute(prop, type, data) : new MAPIAttribute(prop, type, data)));
                attrs.add(attr);
            }
        }
        return attrs;
    }

    private static int getLength(int type, InputStream inp) throws IOException {
        switch (type) {
            case 1: {
                return 0;
            }
            case 2: 
            case 11: {
                return 2;
            }
            case 3: 
            case 4: 
            case 10: {
                return 4;
            }
            case 5: 
            case 6: 
            case 7: 
            case 20: 
            case 64: {
                return 8;
            }
            case 72: {
                return 16;
            }
            case 13: 
            case 30: 
            case 31: 
            case 258: {
                return LittleEndian.readInt(inp);
            }
        }
        throw new IllegalArgumentException("Unknown type " + type);
    }

    private static void skipToBoundary(int length, InputStream inp) throws IOException {
        if (length % 4 != 0) {
            int skip = 4 - length % 4;
            byte[] padding = new byte[skip];
            IOUtils.readFully(inp, padding);
        }
    }
}

