/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.ooxml;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.microsoft.ooxml.OOXMLExtractorFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OOXMLParser
extends AbstractParser {
    private static final long serialVersionUID = 6535995710857776481L;
    protected static final Set<MediaType> SUPPORTED_TYPES = Collections.unmodifiableSet(new HashSet<MediaType>(Arrays.asList(MediaType.application("x-tika-ooxml"), MediaType.application("vnd.openxmlformats-officedocument.presentationml.presentation"), MediaType.application("vnd.ms-powerpoint.presentation.macroenabled.12"), MediaType.application("vnd.openxmlformats-officedocument.presentationml.template"), MediaType.application("vnd.openxmlformats-officedocument.presentationml.slideshow"), MediaType.application("vnd.ms-powerpoint.slideshow.macroenabled.12"), MediaType.application("vnd.ms-powerpoint.addin.macroenabled.12"), MediaType.application("vnd.openxmlformats-officedocument.spreadsheetml.sheet"), MediaType.application("vnd.ms-excel.sheet.macroenabled.12"), MediaType.application("vnd.openxmlformats-officedocument.spreadsheetml.template"), MediaType.application("vnd.ms-excel.template.macroenabled.12"), MediaType.application("vnd.ms-excel.addin.macroenabled.12"), MediaType.application("vnd.openxmlformats-officedocument.wordprocessingml.document"), MediaType.application("vnd.ms-word.document.macroenabled.12"), MediaType.application("vnd.openxmlformats-officedocument.wordprocessingml.template"), MediaType.application("vnd.ms-word.template.macroenabled.12"))));
    protected static final Set<MediaType> UNSUPPORTED_OOXML_TYPES = Collections.unmodifiableSet(new HashSet<MediaType>(Arrays.asList(MediaType.application("vnd.ms-excel.sheet.binary.macroenabled.12"), MediaType.application("vnd.ms-xpsdocument"))));

    @Override
    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    @Override
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        OOXMLExtractorFactory.parse(stream, handler, metadata, context);
    }
}

