/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.FFT;
import com.sun.media.jai.opimage.JaiI18N;
import com.sun.media.jai.util.JDKWorkarounds;
import com.sun.media.jai.util.MathJAI;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.EnumeratedParameter;
import javax.media.jai.ImageLayout;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFactory;
import javax.media.jai.RasterFormatTag;
import javax.media.jai.UntiledOpImage;
import javax.media.jai.operator.DFTDescriptor;

public class DFTOpImage
extends UntiledOpImage {
    FFT fft;
    protected boolean complexSrc;
    protected boolean complexDst;

    private static ImageLayout layoutHelper(ImageLayout imageLayout, RenderedImage renderedImage, EnumeratedParameter enumeratedParameter) {
        int n;
        int n2;
        int n3;
        ImageLayout imageLayout2 = imageLayout == null ? new ImageLayout() : (ImageLayout)imageLayout.clone();
        imageLayout2.setMinX(renderedImage.getMinX());
        imageLayout2.setMinY(renderedImage.getMinY());
        int n4 = imageLayout2.getWidth(renderedImage);
        int n5 = imageLayout2.getHeight(renderedImage);
        if (n4 == 1 && n5 == 1) {
            n3 = 1;
            n2 = 1;
        } else if (n4 == 1 && n5 > 1) {
            n2 = 1;
            n3 = MathJAI.nextPositivePowerOf2(n5);
        } else if (n4 > 1 && n5 == 1) {
            n2 = MathJAI.nextPositivePowerOf2(n4);
            n3 = 1;
        } else {
            n2 = MathJAI.nextPositivePowerOf2(n4);
            n3 = MathJAI.nextPositivePowerOf2(n5);
        }
        imageLayout2.setWidth(n2);
        imageLayout2.setHeight(n3);
        boolean bl = !enumeratedParameter.equals(DFTDescriptor.REAL_TO_COMPLEX);
        boolean bl2 = !enumeratedParameter.equals(DFTDescriptor.COMPLEX_TO_REAL);
        boolean bl3 = false;
        SampleModel sampleModel = renderedImage.getSampleModel();
        int n6 = sampleModel.getNumBands();
        if (bl && !bl2) {
            n6 /= 2;
        } else if (!bl && bl2) {
            n6 *= 2;
        }
        SampleModel sampleModel2 = imageLayout2.getSampleModel(renderedImage);
        int n7 = sampleModel2.getNumBands();
        if (n7 != n6) {
            n7 = n6;
            bl3 = true;
        }
        if ((n = sampleModel2.getTransferType()) != 4 && n != 5) {
            n = 4;
            bl3 = true;
        }
        if (bl3) {
            sampleModel2 = RasterFactory.createComponentSampleModel(sampleModel2, n, n2, n3, n7);
            imageLayout2.setSampleModel(sampleModel2);
            ColorModel colorModel = imageLayout2.getColorModel(null);
            if (colorModel != null && !JDKWorkarounds.areCompatibleDataModels(sampleModel2, colorModel)) {
                imageLayout2.unsetValid(512);
            }
        }
        return imageLayout2;
    }

    public DFTOpImage(RenderedImage renderedImage, Map map, ImageLayout imageLayout, EnumeratedParameter enumeratedParameter, FFT fFT) {
        super(renderedImage, map, DFTOpImage.layoutHelper(imageLayout, renderedImage, enumeratedParameter));
        this.fft = fFT;
        this.complexSrc = !enumeratedParameter.equals(DFTDescriptor.REAL_TO_COMPLEX);
        this.complexDst = !enumeratedParameter.equals(DFTDescriptor.COMPLEX_TO_REAL);
    }

    public Point2D mapDestPoint(Point2D point2D) {
        if (point2D == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        return null;
    }

    public Point2D mapSourcePoint(Point2D point2D) {
        if (point2D == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        return null;
    }

    protected void computeImage(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        Raster raster = rasterArray[0];
        if (rectangle.width == 1 && rectangle.height == 1) {
            int n = this.sampleModel.getNumBands();
            double[] dArray = new double[raster.getSampleModel().getNumBands()];
            raster.getPixel(rectangle.x, rectangle.y, dArray);
            if (this.complexSrc && this.complexDst) {
                writableRaster.setPixel(rectangle.x, rectangle.y, dArray);
            } else if (this.complexSrc) {
                int n2 = 0;
                while (n2 < n) {
                    writableRaster.setSample(rectangle.x, rectangle.y, n2, dArray[2 * n2]);
                    ++n2;
                }
            } else if (this.complexDst) {
                int n3 = 0;
                while (n3 < n) {
                    writableRaster.setSample(rectangle.x, rectangle.y, n3, n3 % 2 == 0 ? dArray[n3 / 2] : 0.0);
                    ++n3;
                }
            } else {
                throw new RuntimeException(JaiI18N.getString("DFTOpImage1"));
            }
            return;
        }
        this.fft.setLength(rectangle.width > 1 ? this.getWidth() : this.getHeight());
        int n = raster.getWidth();
        int n4 = raster.getHeight();
        int n5 = raster.getMinX();
        int n6 = raster.getMinY();
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        RasterAccessor rasterAccessor = new RasterAccessor(raster, new Rectangle(n5, n6, n, n4), rasterFormatTagArray[0], this.getSourceImage(0).getColorModel());
        RasterAccessor rasterAccessor2 = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
        int n7 = rasterAccessor.getDataType();
        int n8 = rasterAccessor2.getDataType();
        int n9 = rasterAccessor.getPixelStride();
        int n10 = rasterAccessor.getScanlineStride();
        int n11 = rasterAccessor2.getPixelStride();
        int n12 = rasterAccessor2.getScanlineStride();
        int n13 = 1;
        int n14 = rectangle.width;
        if (this.complexDst) {
            n13 = n11;
            n14 = n12;
        }
        int n15 = 0;
        int n16 = this.complexSrc ? 2 : 1;
        int n17 = 0;
        int n18 = this.complexDst ? 2 : 1;
        int n19 = this.complexDst ? writableRaster.getSampleModel().getNumBands() / 2 : writableRaster.getSampleModel().getNumBands();
        int n20 = 0;
        while (n20 < n19) {
            int n21;
            int n22;
            int n23;
            int n24;
            Object object = rasterAccessor.getDataArray(n15);
            Object object2 = null;
            if (this.complexSrc) {
                object2 = rasterAccessor.getDataArray(n15 + 1);
            }
            Object object3 = rasterAccessor2.getDataArray(n17);
            Object object4 = null;
            object4 = this.complexDst ? rasterAccessor2.getDataArray(n17 + 1) : (n8 == 4 ? (Object)new float[rectangle.width * rectangle.height] : (Object)new double[rectangle.width * rectangle.height]);
            if (rectangle.width > 1) {
                this.fft.setLength(this.getWidth());
                n24 = rasterAccessor.getBandOffset(n15);
                n23 = 0;
                if (this.complexSrc) {
                    n23 = rasterAccessor.getBandOffset(n15 + 1);
                }
                n22 = rasterAccessor2.getBandOffset(n17);
                n21 = 0;
                if (this.complexDst) {
                    n21 = rasterAccessor2.getBandOffset(n17 + 1);
                }
                int n25 = 0;
                while (n25 < n4) {
                    this.fft.setData(n7, object, n24, n9, object2, n23, n9, n);
                    this.fft.transform();
                    this.fft.getData(n8, object3, n22, n11, object4, n21, n13);
                    n24 += n10;
                    n23 += n10;
                    n22 += n12;
                    n21 += n14;
                    ++n25;
                }
            }
            if (rectangle.width == 1) {
                n24 = rasterAccessor.getBandOffset(n15);
                n23 = 0;
                if (this.complexSrc) {
                    n23 = rasterAccessor.getBandOffset(n15 + 1);
                }
                n22 = rasterAccessor2.getBandOffset(n17);
                n21 = 0;
                if (this.complexDst) {
                    n21 = rasterAccessor2.getBandOffset(n17 + 1);
                }
                this.fft.setData(n7, object, n24, n10, object2, n23, n10, n4);
                this.fft.transform();
                this.fft.getData(n8, object3, n22, n12, object4, n21, n14);
            } else if (rectangle.height > 1) {
                this.fft.setLength(this.getHeight());
                n24 = rasterAccessor2.getBandOffset(n17);
                n23 = 0;
                if (this.complexDst) {
                    n23 = rasterAccessor2.getBandOffset(n17 + 1);
                }
                n22 = 0;
                while (n22 < rectangle.width) {
                    this.fft.setData(n8, object3, n24, n12, object4, n23, n14, rectangle.height);
                    this.fft.transform();
                    this.fft.getData(n8, object3, n24, n12, this.complexDst ? object4 : null, n23, n14);
                    n24 += n11;
                    n23 += n13;
                    ++n22;
                }
            }
            n15 += n16;
            n17 += n18;
            ++n20;
        }
        if (rasterAccessor2.needsClamping()) {
            rasterAccessor2.clampDataArrays();
        }
        rasterAccessor2.copyDataToRaster();
    }
}

