/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.tilecodec;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGDecodeParam;
import com.sun.image.codec.jpeg.JPEGImageDecoder;
import com.sun.media.jai.tilecodec.JaiI18N;
import com.sun.media.jai.tilecodec.TileCodecUtils;
import com.sun.media.jai.util.ImageUtil;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import javax.media.jai.RasterFactory;
import javax.media.jai.tilecodec.TileCodecDescriptor;
import javax.media.jai.tilecodec.TileCodecParameterList;
import javax.media.jai.tilecodec.TileDecoderImpl;
import javax.media.jai.util.ImagingListener;

public class JPEGTileDecoder
extends TileDecoderImpl {
    private TileCodecDescriptor tcd = TileCodecUtils.getTileCodecDescriptor("tileDecoder", "jpeg");

    public JPEGTileDecoder(InputStream inputStream, TileCodecParameterList tileCodecParameterList) {
        super("jpeg", inputStream, tileCodecParameterList);
    }

    public Raster decode() throws IOException {
        if (!this.tcd.includesLocationInfo()) {
            throw new IllegalArgumentException(JaiI18N.getString("JPEGTileDecoder0"));
        }
        return this.decode(null);
    }

    public Raster decode(Point point) throws IOException {
        SampleModel sampleModel = null;
        byte[] byArray = null;
        ObjectInputStream objectInputStream = new ObjectInputStream(this.inputStream);
        try {
            try {
                this.paramList.setParameter("quality", objectInputStream.readFloat());
                this.paramList.setParameter("qualitySet", objectInputStream.readBoolean());
                sampleModel = TileCodecUtils.deserializeSampleModel(objectInputStream.readObject());
                point = (Point)objectInputStream.readObject();
                byArray = (byte[])objectInputStream.readObject();
            }
            catch (ClassNotFoundException classNotFoundException) {
                ImagingListener imagingListener = ImageUtil.getImagingListener((RenderingHints)null);
                imagingListener.errorOccurred(JaiI18N.getString("ClassNotFound"), classNotFoundException, this, false);
                Raster raster = null;
                Object var9_6 = null;
                objectInputStream.close();
                return raster;
            }
            Object var9_5 = null;
        }
        catch (Throwable throwable) {
            Object var9_7 = null;
            objectInputStream.close();
            throw throwable;
        }
        objectInputStream.close();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        JPEGImageDecoder jPEGImageDecoder = JPEGCodec.createJPEGDecoder((InputStream)byteArrayInputStream);
        Raster raster = jPEGImageDecoder.decodeAsRaster().createTranslatedChild(point.x, point.y);
        this.extractParameters(jPEGImageDecoder.getJPEGDecodeParam(), raster.getSampleModel().getNumBands());
        if (sampleModel != null) {
            int n = raster.getMinX();
            int n2 = raster.getMinY();
            int n3 = raster.getHeight();
            int n4 = raster.getWidth();
            double[] dArray = raster.getPixels(n, n2, n4, n3, (double[])null);
            raster = RasterFactory.createWritableRaster(sampleModel, new Point(n, n2));
            ((WritableRaster)raster).setPixels(n, n2, n4, n3, dArray);
        }
        return raster;
    }

    private void extractParameters(JPEGDecodeParam jPEGDecodeParam, int n) {
        int n2;
        Object object;
        int[] nArray = new int[n];
        int n3 = 0;
        while (n3 < n) {
            nArray[n3] = jPEGDecodeParam.getHorizontalSubsampling(n3);
            ++n3;
        }
        this.paramList.setParameter("horizontalSubsampling", nArray);
        int[] nArray2 = new int[n];
        int n4 = 0;
        while (n4 < n) {
            nArray2[n4] = jPEGDecodeParam.getVerticalSubsampling(n4);
            ++n4;
        }
        this.paramList.setParameter("verticalSubsampling", nArray2);
        if (!this.paramList.getBooleanParameter("qualitySet")) {
            int n5 = 0;
            while (n5 < 4) {
                object = jPEGDecodeParam.getQTable(n5);
                this.paramList.setParameter("quantizationTable" + n5, object == null ? null : object.getTable());
                ++n5;
            }
        } else {
            object = this.paramList.getParameterListDescriptor();
            n2 = 0;
            while (n2 < 4) {
                this.paramList.setParameter("quantizationTable" + n2, object.getParamDefaultValue("quantizationTable" + n2));
                ++n2;
            }
        }
        object = new int[n];
        n2 = 0;
        while (n2 < n) {
            object[n2] = jPEGDecodeParam.getQTableComponentMapping(n2);
            ++n2;
        }
        this.paramList.setParameter("quantizationTableMapping", object);
        this.paramList.setParameter("writeTableInfo", jPEGDecodeParam.isTableInfoValid());
        this.paramList.setParameter("writeImageInfo", jPEGDecodeParam.isImageInfoValid());
        this.paramList.setParameter("restartInterval", jPEGDecodeParam.getRestartInterval());
        this.paramList.setParameter("writeJFIFHeader", jPEGDecodeParam.getMarker(224));
    }
}

