/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.util;

import com.sun.media.jai.util.JaiI18N;
import java.io.Serializable;
import java.util.Hashtable;
import javax.media.jai.util.CaselessStringKey;

public class CaselessStringArrayTable
implements Serializable {
    private CaselessStringKey[] keys;
    private Hashtable indices;

    public CaselessStringArrayTable() {
        this((CaselessStringKey[])null);
    }

    public CaselessStringArrayTable(CaselessStringKey[] caselessStringKeyArray) {
        this.keys = caselessStringKeyArray;
        this.indices = new Hashtable();
        if (caselessStringKeyArray != null) {
            int n = 0;
            while (n < caselessStringKeyArray.length) {
                this.indices.put(caselessStringKeyArray[n], new Integer(n));
                ++n;
            }
        }
    }

    public CaselessStringArrayTable(String[] stringArray) {
        this(CaselessStringArrayTable.toCaselessStringKey(stringArray));
    }

    private static CaselessStringKey[] toCaselessStringKey(String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        CaselessStringKey[] caselessStringKeyArray = new CaselessStringKey[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            caselessStringKeyArray[n] = new CaselessStringKey(stringArray[n]);
            ++n;
        }
        return caselessStringKeyArray;
    }

    public int indexOf(CaselessStringKey caselessStringKey) {
        if (caselessStringKey == null) {
            throw new IllegalArgumentException(JaiI18N.getString("CaselessStringArrayTable0"));
        }
        Integer n = (Integer)this.indices.get(caselessStringKey);
        if (n == null) {
            throw new IllegalArgumentException(caselessStringKey.getName() + " - " + JaiI18N.getString("CaselessStringArrayTable1"));
        }
        return n;
    }

    public int indexOf(String string) {
        return this.indexOf(new CaselessStringKey(string));
    }

    public String getName(int n) {
        if (this.keys == null) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.keys[n].getName();
    }

    public CaselessStringKey get(int n) {
        if (this.keys == null) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.keys[n];
    }

    public boolean contains(CaselessStringKey caselessStringKey) {
        if (caselessStringKey == null) {
            throw new IllegalArgumentException(JaiI18N.getString("CaselessStringArrayTable0"));
        }
        return this.indices.get(caselessStringKey) != null;
    }

    public boolean contains(String string) {
        return this.contains(new CaselessStringKey(string));
    }
}

