/*
 * Decompiled with CFR 0.152.
 */
package org.maltparser.parser.guide.instance;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.maltparser.core.config.ConfigurationDir;
import org.maltparser.core.exception.MaltChainedException;
import org.maltparser.core.feature.FeatureException;
import org.maltparser.core.feature.FeatureVector;
import org.maltparser.core.feature.function.FeatureFunction;
import org.maltparser.core.feature.function.Modifiable;
import org.maltparser.core.feature.value.SingleFeatureValue;
import org.maltparser.core.syntaxgraph.DependencyStructure;
import org.maltparser.parser.guide.ClassifierGuide;
import org.maltparser.parser.guide.GuideException;
import org.maltparser.parser.guide.Model;
import org.maltparser.parser.guide.instance.AtomicModel;
import org.maltparser.parser.guide.instance.InstanceModel;
import org.maltparser.parser.history.action.SingleDecision;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DecisionTreeModel
implements InstanceModel {
    private static int leafModelIndexConter = 0;
    private static final int OTHER_BRANCH_ID = 1000000;
    private int numberOfCrossValidationSplits = 10;
    private static final double CROSS_VALIDATION_ACCURACY_NOT_SET_VALUE = -1.0;
    private double crossValidationAccuracy = -1.0;
    private Model parent = null;
    private LinkedList<FeatureFunction> divideFeatures = null;
    private SortedMap<Integer, DecisionTreeModel> branches = null;
    private AtomicModel leafModel = null;
    private int frequency = 0;
    private int divideThreshold = 0;
    private FeatureVector featureVector;
    private FeatureVector subFeatureVector = null;
    private static final int MODEL_INDEX_NOT_SET = Integer.MIN_VALUE;
    private int modelIndex = Integer.MIN_VALUE;
    private ArrayList<Integer> divideFeatureIndexVector;
    private boolean automaticSplit = false;
    private boolean treeForceDivide = false;
    private HashMap<Integer, Integer> classIdToCountMap = null;
    private HashMap<FeatureFunction, HashMap<Integer, Integer>> featureIdToCountMap = null;
    private HashMap<FeatureFunction, HashMap<Integer, HashMap<Integer, Integer>>> featureIdToClassIdToCountMap = null;

    public DecisionTreeModel(FeatureVector featureVector, Model parent) throws MaltChainedException {
        this.featureVector = featureVector;
        this.divideFeatures = new LinkedList();
        this.setParent(parent);
        this.setFrequency(0);
        this.initDecisionTreeParam();
        if (this.getGuide().getGuideMode() == ClassifierGuide.GuideMode.BATCH) {
            this.branches = new TreeMap<Integer, DecisionTreeModel>();
            this.leafModel = new AtomicModel(-1, featureVector, this);
        } else if (this.getGuide().getGuideMode() == ClassifierGuide.GuideMode.CLASSIFY) {
            this.load();
        }
    }

    private DecisionTreeModel(int modelIndex, FeatureVector featureVector, Model parent, LinkedList<FeatureFunction> divideFeatures, int divideThreshold) throws MaltChainedException {
        this.featureVector = featureVector;
        this.setParent(parent);
        this.setFrequency(0);
        this.modelIndex = modelIndex;
        this.divideFeatures = divideFeatures;
        this.divideThreshold = divideThreshold;
        if (this.getGuide().getGuideMode() == ClassifierGuide.GuideMode.BATCH) {
            if (divideFeatures.size() > 0) {
                this.divideFeatureIndexVector = new ArrayList();
                for (int i = 0; i < featureVector.size(); ++i) {
                    if (!((FeatureFunction)featureVector.get(i)).equals(divideFeatures.get(0))) continue;
                    this.divideFeatureIndexVector.add(i);
                }
            }
            ++leafModelIndexConter;
            this.branches = new TreeMap<Integer, DecisionTreeModel>();
            this.leafModel = new AtomicModel(-1, featureVector, this);
        } else if (this.getGuide().getGuideMode() == ClassifierGuide.GuideMode.CLASSIFY) {
            this.load();
        }
    }

    protected void load() throws MaltChainedException {
        ConfigurationDir configDir = this.getGuide().getConfiguration().getConfigurationDir();
        try {
            String line;
            BufferedReader in = new BufferedReader(configDir.getInputStreamReaderFromConfigFile(this.getModelName() + ".dsm"));
            Pattern tabPattern = Pattern.compile("\t");
            boolean first = true;
            while ((line = in.readLine()) != null) {
                String[] cols = tabPattern.split(line);
                if (cols.length != 2) {
                    throw new GuideException("");
                }
                int code = -1;
                int freq = 0;
                try {
                    code = Integer.parseInt(cols[0]);
                    freq = Integer.parseInt(cols[1]);
                }
                catch (NumberFormatException e) {
                    throw new GuideException("Could not convert a string value into an integer value when loading the feature divide model settings (.fsm). ", e);
                }
                if (code == Integer.MIN_VALUE) {
                    if (!first) {
                        throw new GuideException("Error in config file '" + this.getModelName() + ".dsm" + "'. If the index in the .dsm file is MODEL_INDEX_NOT_SET it should be the first.");
                    }
                    first = false;
                    this.leafModel = new AtomicModel(-1, this.featureVector, this);
                    continue;
                }
                if (first) {
                    this.branches = new TreeMap<Integer, DecisionTreeModel>();
                    first = false;
                }
                if (this.branches == null) {
                    throw new GuideException("Error in config file '" + this.getModelName() + ".dsm" + "'. If MODEL_INDEX_NOT_SET is the first model index in the .dsm file it should be the only.");
                }
                if (code == 1000000) {
                    this.branches.put(code, new DecisionTreeModel(code, this.featureVector, this, new LinkedList<FeatureFunction>(), this.divideThreshold));
                } else {
                    this.branches.put(code, new DecisionTreeModel(code, this.getSubFeatureVector(), this, this.createNextLevelDivideFeatures(), this.divideThreshold));
                }
                ((DecisionTreeModel)this.branches.get(code)).setFrequency(freq);
                this.setFrequency(this.getFrequency() + freq);
            }
            in.close();
        }
        catch (IOException e) {
            throw new GuideException("Could not read from the guide model settings file '" + this.getModelName() + ".dsm" + "', when " + "loading the guide model settings. ", e);
        }
    }

    private void initDecisionTreeParam() throws MaltChainedException {
        String treeSplitColumns = this.getGuide().getConfiguration().getOptionValue("guide", "tree_split_columns").toString();
        String treeSplitStructures = this.getGuide().getConfiguration().getOptionValue("guide", "tree_split_structures").toString();
        this.automaticSplit = this.getGuide().getConfiguration().getOptionValue("guide", "tree_automatic_split_order").toString().equals("yes");
        this.treeForceDivide = this.getGuide().getConfiguration().getOptionValue("guide", "tree_force_divide").toString().equals("yes");
        if (this.automaticSplit) {
            this.divideFeatures = new LinkedList();
            for (FeatureFunction feature : this.featureVector) {
                if (!(feature.getFeatureValue() instanceof SingleFeatureValue)) continue;
                this.divideFeatures.add(feature);
            }
        } else {
            String[] treeSplitStructuresArray;
            if (treeSplitColumns == null || treeSplitColumns.length() == 0) {
                throw new GuideException("The option '--guide-tree_split_columns' cannot be found, when initializing the decision tree model. ");
            }
            if (treeSplitStructures == null || treeSplitStructures.length() == 0) {
                throw new GuideException("The option '--guide-tree_split_structures' cannot be found, when initializing the decision tree model. ");
            }
            String[] treeSplitColumnsArray = treeSplitColumns.split("@");
            if (treeSplitColumnsArray.length != (treeSplitStructuresArray = treeSplitStructures.split("@")).length) {
                throw new GuideException("The option '--guide-tree_split_structures' and '--guide-tree_split_columns' must be followed by a ; separated lists of the same length");
            }
            try {
                for (int n = 0; n < treeSplitColumnsArray.length; ++n) {
                    String spec = "InputColumn(" + treeSplitColumnsArray[n].trim() + ", " + treeSplitStructuresArray[n].trim() + ")";
                    this.divideFeatures.addLast(this.featureVector.getFeatureModel().identifyFeature(spec));
                }
            }
            catch (FeatureException e) {
                throw new GuideException("The data split feature 'InputColumn(" + this.getGuide().getConfiguration().getOptionValue("guide", "data_split_column").toString() + ", " + this.getGuide().getConfiguration().getOptionValue("guide", "data_split_structure").toString() + ") cannot be initialized. ", e);
            }
            for (FeatureFunction divideFeature : this.divideFeatures) {
                if (divideFeature instanceof Modifiable) continue;
                throw new GuideException("The data split feature 'InputColumn(" + this.getGuide().getConfiguration().getOptionValue("guide", "data_split_column").toString() + ", " + this.getGuide().getConfiguration().getOptionValue("guide", "data_split_structure").toString() + ") does not implement Modifiable interface. ");
            }
            this.divideFeatureIndexVector = new ArrayList();
            for (int i = 0; i < this.featureVector.size(); ++i) {
                if (!((FeatureFunction)this.featureVector.get(i)).equals(this.divideFeatures.get(0))) continue;
                this.divideFeatureIndexVector.add(i);
            }
            if (this.divideFeatureIndexVector.size() == 0) {
                throw new GuideException("Could not match the given divide features to any of the available features.");
            }
        }
        try {
            String treeSplitTreshold = this.getGuide().getConfiguration().getOptionValue("guide", "tree_split_threshold").toString();
            this.divideThreshold = treeSplitTreshold != null && treeSplitTreshold.length() > 0 ? Integer.parseInt(treeSplitTreshold) : 0;
        }
        catch (NumberFormatException e) {
            throw new GuideException("The --guide-tree_split_threshold option is not an integer value. ", e);
        }
        try {
            String treeNumberOfCrossValidationDivisions = this.getGuide().getConfiguration().getOptionValue("guide", "tree_number_of_cross_validation_divisions").toString();
            if (treeNumberOfCrossValidationDivisions != null && treeNumberOfCrossValidationDivisions.length() > 0) {
                this.numberOfCrossValidationSplits = Integer.parseInt(treeNumberOfCrossValidationDivisions);
            } else {
                this.divideThreshold = 0;
            }
        }
        catch (NumberFormatException e) {
            throw new GuideException("The --guide-tree_number_of_cross_validation_divisions option is not an integer value. ", e);
        }
    }

    @Override
    public void addInstance(SingleDecision decision) throws MaltChainedException {
        if (this.getGuide().getGuideMode() == ClassifierGuide.GuideMode.CLASSIFY) {
            throw new GuideException("Can only add instance during learning. ");
        }
        if (this.divideFeatures.size() > 0) {
            for (FeatureFunction divideFeature : this.divideFeatures) {
                if (!(divideFeature.getFeatureValue() instanceof SingleFeatureValue)) {
                    throw new GuideException("The divide feature does not have a single value. ");
                }
                divideFeature.update();
            }
            this.leafModel.addInstance(decision);
            this.updateStatistics(decision);
        } else {
            if (this.branches != null) {
                this.setIsLeafNode();
            }
            this.leafModel.addInstance(decision);
            this.updateStatistics(decision);
        }
    }

    private double log2(double n) {
        return Math.log(n) / Math.log(2.0);
    }

    private void updateStatistics(SingleDecision decision) throws MaltChainedException {
        int featureCode;
        int instanceClass;
        Integer classCount;
        if (this.featureIdToCountMap == null) {
            this.featureIdToCountMap = new HashMap();
            for (FeatureFunction columnsDivideFeature : this.divideFeatures) {
                this.featureIdToCountMap.put(columnsDivideFeature, new HashMap());
            }
            this.featureIdToClassIdToCountMap = new HashMap();
            for (FeatureFunction columnsDivideFeature : this.divideFeatures) {
                this.featureIdToClassIdToCountMap.put(columnsDivideFeature, new HashMap());
            }
            this.classIdToCountMap = new HashMap();
        }
        if ((classCount = this.classIdToCountMap.get(instanceClass = decision.getDecisionCode())) == null) {
            classCount = 0;
        }
        this.classIdToCountMap.put(instanceClass, classCount + 1);
        for (FeatureFunction columnsDivideFeature : this.divideFeatures) {
            featureCode = ((SingleFeatureValue)columnsDivideFeature.getFeatureValue()).getCode();
            HashMap<Integer, Integer> statisticsMap = this.featureIdToCountMap.get(columnsDivideFeature);
            Integer count = statisticsMap.get(featureCode);
            if (count == null) {
                count = 0;
            }
            statisticsMap.put(featureCode, count + 1);
        }
        for (FeatureFunction columnsDivideFeature : this.divideFeatures) {
            Integer count;
            featureCode = ((SingleFeatureValue)columnsDivideFeature.getFeatureValue()).getCode();
            HashMap<Integer, HashMap<Integer, Integer>> featureIdToclassIdToCountMapTmp = this.featureIdToClassIdToCountMap.get(columnsDivideFeature);
            HashMap<Integer, Integer> classIdToCountMapTmp = featureIdToclassIdToCountMapTmp.get(featureCode);
            if (classIdToCountMapTmp == null) {
                classIdToCountMapTmp = new HashMap();
                featureIdToclassIdToCountMapTmp.put(featureCode, classIdToCountMapTmp);
            }
            if ((count = classIdToCountMapTmp.get(instanceClass)) == null) {
                count = 0;
            }
            classIdToCountMapTmp.put(instanceClass, count + 1);
        }
    }

    private LinkedList<FeatureFunction> createNextLevelDivideFeatures() {
        LinkedList nextLevelDivideFeatures = (LinkedList)this.divideFeatures.clone();
        nextLevelDivideFeatures.removeFirst();
        return nextLevelDivideFeatures;
    }

    private FeatureVector getSubFeatureVector() {
        if (this.subFeatureVector != null) {
            return this.subFeatureVector;
        }
        FeatureFunction divideFeature = this.divideFeatures.getFirst();
        ArrayList<Integer> divideFeatureIndexVector = new ArrayList<Integer>();
        for (int i = 0; i < this.featureVector.size(); ++i) {
            if (!((FeatureFunction)this.featureVector.get(i)).equals(divideFeature)) continue;
            divideFeatureIndexVector.add(i);
        }
        FeatureVector divideFeatureVector = (FeatureVector)this.featureVector.clone();
        for (Integer i : divideFeatureIndexVector) {
            divideFeatureVector.remove(divideFeatureVector.get(i));
        }
        this.subFeatureVector = divideFeatureVector;
        return divideFeatureVector;
    }

    @Override
    public FeatureVector extract() throws MaltChainedException {
        return this.getCurrentAtomicModel().extract();
    }

    private AtomicModel getCurrentAtomicModel() throws MaltChainedException {
        if (this.getGuide().getGuideMode() == ClassifierGuide.GuideMode.BATCH) {
            throw new GuideException("Can only predict during parsing. ");
        }
        if (this.branches == null && this.leafModel != null) {
            return this.leafModel;
        }
        FeatureFunction divideFeature = this.divideFeatures.getFirst();
        if (!(divideFeature.getFeatureValue() instanceof SingleFeatureValue)) {
            throw new GuideException("The divide feature does not have a single value. ");
        }
        if (this.branches != null && this.branches.containsKey(((SingleFeatureValue)divideFeature.getFeatureValue()).getCode())) {
            return ((DecisionTreeModel)this.branches.get(((SingleFeatureValue)divideFeature.getFeatureValue()).getCode())).getCurrentAtomicModel();
        }
        if (this.branches.containsKey(1000000) && ((DecisionTreeModel)this.branches.get(1000000)).getFrequency() > 0) {
            return ((DecisionTreeModel)this.branches.get(1000000)).getCurrentAtomicModel();
        }
        this.getGuide().getConfiguration().getConfigLogger().info("Could not predict the next parser decision because there is no divide or master model that covers the divide value '" + ((SingleFeatureValue)divideFeature.getFeatureValue()).getCode() + "', as default" + " class code '1' is used. ");
        return null;
    }

    @Override
    public void increaseFrequency() {
        ++this.frequency;
    }

    @Override
    public void decreaseFrequency() {
        --this.frequency;
    }

    @Override
    public boolean predict(SingleDecision decision) throws MaltChainedException {
        if (this.getGuide().getGuideMode() == ClassifierGuide.GuideMode.BATCH) {
            throw new GuideException("Can only predict during parsing. ");
        }
        if (this.divideFeatures.size() > 0 && !(this.divideFeatures.getFirst().getFeatureValue() instanceof SingleFeatureValue)) {
            throw new GuideException("The divide feature does not have a single value. ");
        }
        if (this.branches != null && this.branches.containsKey(((SingleFeatureValue)this.divideFeatures.getFirst().getFeatureValue()).getCode())) {
            return ((DecisionTreeModel)this.branches.get(((SingleFeatureValue)this.divideFeatures.getFirst().getFeatureValue()).getCode())).predict(decision);
        }
        if (this.branches != null && this.branches.containsKey(1000000)) {
            return ((DecisionTreeModel)this.branches.get(1000000)).predict(decision);
        }
        if (this.leafModel != null) {
            return this.leafModel.predict(decision);
        }
        this.getGuide().getConfiguration().getConfigLogger().info("Could not predict the next parser decision because there is no divide or master model that covers the divide value '" + ((SingleFeatureValue)this.divideFeatures.getFirst().getFeatureValue()).getCode() + "', as default" + " class code '1' is used. ");
        decision.addDecision(1);
        return true;
    }

    @Override
    public FeatureVector predictExtract(SingleDecision decision) throws MaltChainedException {
        return this.getCurrentAtomicModel().predictExtract(decision);
    }

    private double decideNodeType() throws MaltChainedException {
        if (this.crossValidationAccuracy != -1.0) {
            return this.crossValidationAccuracy;
        }
        if (this.modelIndex == Integer.MIN_VALUE && this.getGuide().getConfiguration().getConfigLogger().isInfoEnabled()) {
            this.getGuide().getConfiguration().getConfigLogger().info("Starting deph first pruning of the decision tree\n");
        }
        long start = System.currentTimeMillis();
        double leafModelCrossValidationAccuracy = 0.0;
        if (this.treeForceDivide && this.getGuide().getConfiguration().getConfigLogger().isInfoEnabled()) {
            this.getGuide().getConfiguration().getConfigLogger().info("Skipping cross validation of the root node since the flag tree_force_divide is set to yes. The cross validation score for the root node is set to zero.\n");
        }
        if (!this.treeForceDivide) {
            leafModelCrossValidationAccuracy = this.leafModel.getMethod().crossValidate(this.featureVector, this.numberOfCrossValidationSplits);
        }
        long stop = System.currentTimeMillis();
        if (this.getGuide().getConfiguration().getConfigLogger().isInfoEnabled()) {
            this.getGuide().getConfiguration().getConfigLogger().info("Cross Validation Time: " + (stop - start) + " ms" + " for model " + this.getModelName() + "\n");
        }
        if (this.getGuide().getConfiguration().getConfigLogger().isInfoEnabled()) {
            this.getGuide().getConfiguration().getConfigLogger().info("Cross Validation Accuracy as leaf node = " + leafModelCrossValidationAccuracy + " for model " + this.getModelName() + "\n");
        }
        if (this.branches == null && this.leafModel != null) {
            this.crossValidationAccuracy = leafModelCrossValidationAccuracy;
            return this.crossValidationAccuracy;
        }
        int totalFrequency = 0;
        double totalAccuracyCount = 0.0;
        for (DecisionTreeModel b : this.branches.values()) {
            double bAccuracy = b.decideNodeType();
            totalFrequency += b.getFrequency();
            totalAccuracyCount += bAccuracy * (double)b.getFrequency();
        }
        double branchModelCrossValidationAccuracy = totalAccuracyCount / (double)totalFrequency;
        if (this.getGuide().getConfiguration().getConfigLogger().isInfoEnabled()) {
            this.getGuide().getConfiguration().getConfigLogger().info("Total Cross Validation Accuracy for branches = " + branchModelCrossValidationAccuracy + " for model " + this.getModelName() + "\n");
        }
        if (branchModelCrossValidationAccuracy > leafModelCrossValidationAccuracy) {
            this.setIsBranchNode();
            this.crossValidationAccuracy = branchModelCrossValidationAccuracy;
            return this.crossValidationAccuracy;
        }
        this.setIsLeafNode();
        this.crossValidationAccuracy = leafModelCrossValidationAccuracy;
        return this.crossValidationAccuracy;
    }

    @Override
    public void train() throws MaltChainedException {
        this.decideNodeType();
        if (this.branches == null && this.leafModel != null) {
            this.leafModel.train();
            this.save();
            this.leafModel.terminate();
        } else {
            for (DecisionTreeModel b : this.branches.values()) {
                b.train();
            }
            this.save();
            for (DecisionTreeModel b : this.branches.values()) {
                b.terminate();
            }
        }
        this.terminate();
    }

    private void save() throws MaltChainedException {
        try {
            BufferedWriter out = new BufferedWriter(this.getGuide().getConfiguration().getConfigurationDir().getOutputStreamWriter(this.getModelName() + ".dsm"));
            if (this.branches != null) {
                for (DecisionTreeModel b : this.branches.values()) {
                    out.write(b.getModelIndex() + "\t" + b.getFrequency() + "\n");
                }
            } else {
                out.write("-2147483648\t" + this.getFrequency() + "\n");
            }
            out.close();
        }
        catch (IOException e) {
            throw new GuideException("Could not write to the guide model settings file '" + this.getModelName() + ".dsm" + "' or the name mapping file '" + this.getModelName() + ".nmf" + "', when " + "saving the guide model settings to files. ", e);
        }
    }

    @Override
    public void finalizeSentence(DependencyStructure dependencyGraph) throws MaltChainedException {
        if (this.branches != null) {
            for (DecisionTreeModel b : this.branches.values()) {
                b.finalizeSentence(dependencyGraph);
            }
        } else if (this.leafModel != null) {
            this.leafModel.finalizeSentence(dependencyGraph);
        } else {
            throw new GuideException("The feature divide models cannot be found. ");
        }
    }

    @Override
    public ClassifierGuide getGuide() {
        return this.parent.getGuide();
    }

    @Override
    public String getModelName() throws MaltChainedException {
        try {
            return this.parent.getModelName() + (this.modelIndex == Integer.MIN_VALUE ? "" : "_" + this.modelIndex);
        }
        catch (NullPointerException e) {
            throw new GuideException("The parent guide model cannot be found. ", e);
        }
    }

    private void setIsLeafNode() throws MaltChainedException {
        if (this.branches == null && this.leafModel != null) {
            return;
        }
        if (this.branches != null && this.leafModel != null) {
            for (DecisionTreeModel t : this.branches.values()) {
                t.terminate();
            }
        } else {
            throw new MaltChainedException("Can't set a node that have aleready been set to a leaf node.");
        }
        this.branches = null;
    }

    private void setIsBranchNode() throws MaltChainedException {
        if (this.branches == null || this.leafModel == null) {
            throw new MaltChainedException("Can't set a node that have aleready been set to a branch node.");
        }
        this.leafModel.terminate();
        this.leafModel = null;
    }

    @Override
    public void noMoreInstances() throws MaltChainedException {
        if (this.leafModel == null) {
            throw new GuideException("The model in tree node is null in a state where it is not allowed");
        }
        this.leafModel.noMoreInstances();
        if (this.divideFeatures.size() == 0) {
            this.setIsLeafNode();
        }
        if (this.branches != null) {
            if (this.automaticSplit) {
                this.divideFeatures = this.createGainRatioSplitList(this.divideFeatures);
                this.divideFeatureIndexVector = new ArrayList();
                for (int i = 0; i < this.featureVector.size(); ++i) {
                    if (!((FeatureFunction)this.featureVector.get(i)).equals(this.divideFeatures.get(0))) continue;
                    this.divideFeatureIndexVector.add(i);
                }
                if (this.divideFeatureIndexVector.size() == 0) {
                    throw new GuideException("Could not match the given divide features to any of the available features.");
                }
            }
            FeatureFunction divideFeature = this.divideFeatures.getFirst();
            divideFeature.updateCardinality();
            this.leafModel.noMoreInstances();
            Map<Integer, Integer> divideFeatureIdToCountMap = this.leafModel.getMethod().createFeatureIdToCountMap(this.divideFeatureIndexVector);
            int totalInOther = 0;
            HashSet<Integer> featureIdsToCreateSeparateBranchesForSet = new HashSet<Integer>();
            LinkedList<Integer> removeFromDivideFeatureIdToCountMap = new LinkedList<Integer>();
            for (Map.Entry<Integer, Integer> entry : divideFeatureIdToCountMap.entrySet()) {
                if (entry.getValue() >= this.divideThreshold) {
                    featureIdsToCreateSeparateBranchesForSet.add(entry.getKey());
                    continue;
                }
                removeFromDivideFeatureIdToCountMap.add(entry.getKey());
                totalInOther += entry.getValue().intValue();
            }
            Iterator<Map.Entry<Integer, Integer>> i$ = removeFromDivideFeatureIdToCountMap.iterator();
            while (i$.hasNext()) {
                int removeIndex = (Integer)((Object)i$.next());
                divideFeatureIdToCountMap.remove(removeIndex);
            }
            boolean otherExists = false;
            if (totalInOther > 0) {
                otherExists = true;
            }
            if (totalInOther < this.divideThreshold && featureIdsToCreateSeparateBranchesForSet.size() <= 1 || featureIdsToCreateSeparateBranchesForSet.size() == 0) {
                this.setIsLeafNode();
            } else {
                if (otherExists && totalInOther < this.divideThreshold) {
                    int smallestSoFar = Integer.MAX_VALUE;
                    int smallestSoFarId = Integer.MAX_VALUE;
                    for (Map.Entry<Integer, Integer> entry : divideFeatureIdToCountMap.entrySet()) {
                        if (entry.getValue() >= smallestSoFar) continue;
                        smallestSoFar = entry.getValue();
                        smallestSoFarId = entry.getKey();
                    }
                    featureIdsToCreateSeparateBranchesForSet.remove(smallestSoFarId);
                }
                this.leafModel.getMethod().divideByFeatureSet(featureIdsToCreateSeparateBranchesForSet, this.divideFeatureIndexVector, "1000000");
                Iterator<Object> i$2 = featureIdsToCreateSeparateBranchesForSet.iterator();
                while (i$2.hasNext()) {
                    int id = (Integer)i$2.next();
                    DecisionTreeModel newBranch = new DecisionTreeModel(id, this.getSubFeatureVector(), this, this.createNextLevelDivideFeatures(), this.divideThreshold);
                    this.branches.put(id, newBranch);
                }
                if (otherExists) {
                    DecisionTreeModel newBranch = new DecisionTreeModel(1000000, this.featureVector, this, new LinkedList<FeatureFunction>(), this.divideThreshold);
                    this.branches.put(1000000, newBranch);
                }
                for (DecisionTreeModel b : this.branches.values()) {
                    b.noMoreInstances();
                }
            }
        }
    }

    @Override
    public void terminate() throws MaltChainedException {
        if (this.branches != null) {
            for (DecisionTreeModel branch : this.branches.values()) {
                branch.terminate();
            }
            this.branches = null;
        }
        if (this.leafModel != null) {
            this.leafModel.terminate();
            this.leafModel = null;
        }
    }

    public void setParent(Model parent) {
        this.parent = parent;
    }

    public Model getParent() {
        return this.parent;
    }

    public void setFrequency(int frequency) {
        this.frequency = frequency;
    }

    public int getFrequency() {
        return this.frequency;
    }

    public int getModelIndex() {
        return this.modelIndex;
    }

    private LinkedList<FeatureFunction> createGainRatioSplitList(LinkedList<FeatureFunction> divideFeatures) {
        if (this.getGuide().getConfiguration().getConfigLogger().isInfoEnabled()) {
            this.getGuide().getConfiguration().getConfigLogger().info("Start calculating gain ratio for all posible divide features");
        }
        double total = 0.0;
        for (int count : this.classIdToCountMap.values()) {
            double fraction = (double)count / (double)this.getFrequency();
            total += fraction * this.log2(fraction);
        }
        double rootEntropy = -total;
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class FeatureFunctionInformationGainPair
        implements Comparable<FeatureFunctionInformationGainPair> {
            double informationGain;
            FeatureFunction featureFunction;
            double splitInfo;

            public FeatureFunctionInformationGainPair(FeatureFunction featureFunction) {
                this.featureFunction = featureFunction;
            }

            public double getGainRatio() {
                return this.informationGain / this.splitInfo;
            }

            @Override
            public int compareTo(FeatureFunctionInformationGainPair o) {
                int result = 0;
                if (this.getGainRatio() - o.getGainRatio() < 0.0) {
                    result = -1;
                } else if (this.getGainRatio() - o.getGainRatio() > 0.0) {
                    result = 1;
                }
                return result;
            }
        }
        ArrayList<FeatureFunctionInformationGainPair> gainRatioList = new ArrayList<FeatureFunctionInformationGainPair>();
        for (FeatureFunction f : divideFeatures) {
            gainRatioList.add(new FeatureFunctionInformationGainPair(f));
        }
        for (FeatureFunctionInformationGainPair p : gainRatioList) {
            HashMap<Integer, Integer> featureIdToCountMapTmp = this.featureIdToCountMap.get(p.featureFunction);
            HashMap<Integer, HashMap<Integer, Integer>> featureIdToClassIdToCountMapTmp = this.featureIdToClassIdToCountMap.get(p.featureFunction);
            double sum = 0.0;
            for (Map.Entry<Integer, Integer> entry : featureIdToCountMapTmp.entrySet()) {
                int featureId = entry.getKey();
                int numberOfElementsWithFeatureId = entry.getValue();
                HashMap<Integer, Integer> classIdToCountMapTmp = featureIdToClassIdToCountMapTmp.get(featureId);
                double sumImpurityMesure = 0.0;
                int totalElementsWithIdAndClass = 0;
                for (int elementsWithIdAndClass : classIdToCountMapTmp.values()) {
                    double fractionOfInstancesBelongingToClass = (double)elementsWithIdAndClass / (double)numberOfElementsWithFeatureId;
                    totalElementsWithIdAndClass += elementsWithIdAndClass;
                    sumImpurityMesure += fractionOfInstancesBelongingToClass * this.log2(fractionOfInstancesBelongingToClass);
                }
                double impurityMesure = -sumImpurityMesure;
                sum += (double)numberOfElementsWithFeatureId / (double)this.getFrequency() * impurityMesure;
            }
            p.informationGain = rootEntropy - sum;
            double splitInfoTotal = 0.0;
            for (int nrOfElementsWithFeatureId : featureIdToCountMapTmp.values()) {
                double fractionOfTotal = (double)nrOfElementsWithFeatureId / (double)this.getFrequency();
                splitInfoTotal += fractionOfTotal * this.log2(fractionOfTotal);
            }
            p.splitInfo = splitInfoTotal;
        }
        Collections.sort(gainRatioList);
        if (this.getGuide().getConfiguration().getConfigLogger().isInfoEnabled()) {
            this.getGuide().getConfiguration().getConfigLogger().info("Gain ratio calculation finished the result follows:\n");
            this.getGuide().getConfiguration().getConfigLogger().info("Divide Feature\tGain Ratio\tInformation Gain\tSplit Info\n");
            for (FeatureFunctionInformationGainPair p : gainRatioList) {
                this.getGuide().getConfiguration().getConfigLogger().info(p.featureFunction + "\t" + p.getGainRatio() + "\t" + p.informationGain + "\t" + p.splitInfo + "\n");
            }
        }
        LinkedList<FeatureFunction> divideFeaturesNew = new LinkedList<FeatureFunction>();
        for (FeatureFunctionInformationGainPair p : gainRatioList) {
            divideFeaturesNew.add(p.featureFunction);
        }
        return divideFeaturesNew;
    }
}

