#!/usr/bin/perl

package eBay::API::XML::Call::GetCart::GetCartRequestType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. GetCartRequestType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 07/07/2008 17:42
# API Release Number: ... 571
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::GetCart::GetCartRequestType

=head1 DESCRIPTION

Retrieves information about an eBay Express shopping cart.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::GetCart::GetCartRequestType inherits from the L<eBay::API::XML::RequestDataType> class

=cut

use eBay::API::XML::RequestDataType;
our @ISA = ("eBay::API::XML::RequestDataType");

use eBay::API::XML::DataType::AddressType;
use eBay::API::XML::DataType::AffiliateTrackingDetailsType;


my @gaProperties = ( [ 'AffiliateTrackingDetails', 'ns:AffiliateTrackingDetailsType', ''
	     ,'eBay::API::XML::DataType::AffiliateTrackingDetailsType', '1' ]
	, [ 'CartID', 'xs:long', '', '', '' ]
	, [ 'ShippingAddress', 'ns:AddressType', ''
	     ,'eBay::API::XML::DataType::AddressType', '1' ]
                    );
push @gaProperties, @{eBay::API::XML::RequestDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::RequestDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setAffiliateTrackingDetails()

Container for affiliate tags.
If you use affiliate tags, it is possible to get affiliate commissions
based on calls made by your application.
(See the <a href="https://www.ebaypartnernetwork.com/" target="_blank">eBay Partner Network</a>
for information about commissions.)
Affiliate tags enable the tracking of user activity.
You can use child tags of AffiliateTrackingDetails if you want
call output to include a string, in
Item.ListingDetails.ViewItemURL, that includes
affiliate tracking information.
Affiliate details that you provide appear in the CheckoutURL that is returned by GetCart.
Child elements of this element that are marked as conditionally required are required
only if this container is present.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=AffiliateTrackingConcepts
Title: Affiliate Tracking Concepts

  RequiredInput: No
#    Argument: 'ns:AffiliateTrackingDetailsType'

=cut

sub setAffiliateTrackingDetails {
  my $self = shift;
  $self->{'AffiliateTrackingDetails'} = shift
}

=head2 getAffiliateTrackingDetails()

#    Returns: 'ns:AffiliateTrackingDetailsType'

=cut

sub getAffiliateTrackingDetails {
  my $self = shift;
  return $self->_getDataTypeInstance( 'AffiliateTrackingDetails'
		,'eBay::API::XML::DataType::AffiliateTrackingDetailsType');
}


=head2 setCartID()

The ID of the shopping cart to inspect, obtained from a prior run of SetCart.

  RequiredInput: Yes
#    Argument: 'xs:long'

=cut

sub setCartID {
  my $self = shift;
  $self->{'CartID'} = shift
}

=head2 getCartID()

#    Returns: 'xs:long'

=cut

sub getCartID {
  my $self = shift;
  return $self->{'CartID'};
}


=head2 setShippingAddress()

The country and postal code to which the items in the cart are to be shipped. Required only
if you want shipping costs calculated for those items for which calculated
shipping applies. Of no value if there are no items in the cart with calculated shipping.

  RequiredInput: No
#    Argument: 'ns:AddressType'

=cut

sub setShippingAddress {
  my $self = shift;
  $self->{'ShippingAddress'} = shift
}

=head2 getShippingAddress()

#    Returns: 'ns:AddressType'

=cut

sub getShippingAddress {
  my $self = shift;
  return $self->_getDataTypeInstance( 'ShippingAddress'
		,'eBay::API::XML::DataType::AddressType');
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
