#!/usr/bin/perl

package eBay::API::XML::DataType::AnnouncementMessageType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. AnnouncementMessageType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::AnnouncementMessageType

=head1 DESCRIPTION

Event messaging details



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::AnnouncementMessageType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::Enum::AnnouncementMessageCodeType;


my @gaProperties = ( [ 'AnnouncementStartTime', 'xs:dateTime', '', '', '' ]
	, [ 'EventTime', 'xs:dateTime', '', '', '' ]
	, [ 'MessageType', 'ns:AnnouncementMessageCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::AnnouncementMessageCodeType', '' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setAnnouncementStartTime()

The date on which an upcoming event can start to be announced.

#    Argument: 'xs:dateTime'

=cut

sub setAnnouncementStartTime {
  my $self = shift;
  $self->{'AnnouncementStartTime'} = shift
}

=head2 getAnnouncementStartTime()

  Calls: GeteBayDetails
  Returned: Conditionally

#    Returns: 'xs:dateTime'

=cut

sub getAnnouncementStartTime {
  my $self = shift;
  return $self->{'AnnouncementStartTime'};
}


=head2 setEventTime()

The date on which the event occurs. This is also the ending date of the
announcement that lead up to the event (see AnnouncementStartTime).

#    Argument: 'xs:dateTime'

=cut

sub setEventTime {
  my $self = shift;
  $self->{'EventTime'} = shift
}

=head2 getEventTime()

  Calls: GeteBayDetails
  Returned: Conditionally

#    Returns: 'xs:dateTime'

=cut

sub getEventTime {
  my $self = shift;
  return $self->{'EventTime'};
}


=head2 setMessageType()

Control of what messages to display.

#    Argument: 'ns:AnnouncementMessageCodeType'

=cut

sub setMessageType {
  my $self = shift;
  $self->{'MessageType'} = shift
}

=head2 getMessageType()

  Calls: GeteBayDetails
  Returned: Conditionally

#    Returns: 'ns:AnnouncementMessageCodeType'

=cut

sub getMessageType {
  my $self = shift;
  return $self->{'MessageType'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
