#!/usr/bin/perl

package eBay::API::XML::DataType::LookupAttributeType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. LookupAttributeType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::LookupAttributeType

=head1 DESCRIPTION

An optional attribute that the seller wants to include in the listing.
Enables you to specify an attribute by name rather than by ID.
Only valid in Media categories (Books, DVD and Movies, Music, and Video Game categories).
Currently, only the Condition attribute is supported.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::LookupAttributeType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");



my @gaProperties = ( [ 'Name', 'xs:string', '', '', '' ]
	, [ 'Value', 'xs:string', '', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setName()

The literal name of the attribute. Pass "Condition" (without quotes).
Not applicable to Half.com.

  Calls: AddItem
         GetItemRecommendations
         RelistItem
         VerifyAddItem
  RequiredInput: No

#    Argument: 'xs:string'

=cut

sub setName {
  my $self = shift;
  $self->{'Name'} = shift
}

=head2 getName()

#    Returns: 'xs:string'

=cut

sub getName {
  my $self = shift;
  return $self->{'Name'};
}


=head2 setValue()

HASH(0x42b3120)
The literal name of the attribute value. Pass "New" or "Used" (without quotes).
Not applicable to Half.com.<br>
<br>

  Calls: AddItem
         GetItemRecommendations
         RelistItem
         VerifyAddItem
  RequiredInput: No

#    Argument: 'xs:string'

=cut

sub setValue {
  my $self = shift;
  $self->{'Value'} = shift
}

=head2 getValue()

#    Returns: 'xs:string'

=cut

sub getValue {
  my $self = shift;
  return $self->{'Value'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
