#!/usr/bin/perl

package eBay::API::XML::DataType::RemindersType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. RemindersType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::RemindersType

=head1 DESCRIPTION

Specifies the type of reminders for which you want information.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::RemindersType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");



my @gaProperties = ( [ 'DeclinedRTERequestCount', 'xs:int', '', '', '' ]
	, [ 'DocsForCCProcessingToSendCount', 'xs:int', '', '', '' ]
	, [ 'FeedbackToReceiveCount', 'xs:int', '', '', '' ]
	, [ 'FeedbackToSendCount', 'xs:int', '', '', '' ]
	, [ 'ItemReceiptConfirmationToReceiveCount', 'xs:int', '', '', '' ]
	, [ 'ItemReceiptToConfirmCount', 'xs:int', '', '', '' ]
	, [ 'OutbidCount', 'xs:int', '', '', '' ]
	, [ 'PaymentToReceiveCount', 'xs:int', '', '', '' ]
	, [ 'PaymentToSendCount', 'xs:int', '', '', '' ]
	, [ 'PendingRTERequestCount', 'xs:int', '', '', '' ]
	, [ 'RTEToProcessCount', 'xs:int', '', '', '' ]
	, [ 'RefundCancelledCount', 'xs:int', '', '', '' ]
	, [ 'RefundInitiatedCount', 'xs:int', '', '', '' ]
	, [ 'RefundOnHoldCount', 'xs:int', '', '', '' ]
	, [ 'RelistingNeededCount', 'xs:int', '', '', '' ]
	, [ 'SecondChanceOfferCount', 'xs:int', '', '', '' ]
	, [ 'ShippingDetailsToBeProvidedCount', 'xs:int', '', '', '' ]
	, [ 'ShippingNeededCount', 'xs:int', '', '', '' ]
	, [ 'TotalNewLeadsCount', 'xs:int', '', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setDeclinedRTERequestCount()

The number of reminders to the seller on declined shipping time extension requests by the buyer

#    Argument: 'xs:int'

=cut

sub setDeclinedRTERequestCount {
  my $self = shift;
  $self->{'DeclinedRTERequestCount'} = shift
}

=head2 getDeclinedRTERequestCount()

  Calls: GetMyeBayReminders
  Returned: Conditionally
  Context: SellingReminders

#    Returns: 'xs:int'

=cut

sub getDeclinedRTERequestCount {
  my $self = shift;
  return $self->{'DeclinedRTERequestCount'};
}


=head2 setDocsForCCProcessingToSendCount()

The number of reminders advising the buyer to send documents for credit card processing.

#    Argument: 'xs:int'

=cut

sub setDocsForCCProcessingToSendCount {
  my $self = shift;
  $self->{'DocsForCCProcessingToSendCount'} = shift
}

=head2 getDocsForCCProcessingToSendCount()

  Calls: GetMyeBayReminders
  Returned: Conditionally
  Context: SellingReminders

#    Returns: 'xs:int'

=cut

sub getDocsForCCProcessingToSendCount {
  my $self = shift;
  return $self->{'DocsForCCProcessingToSendCount'};
}


=head2 setFeedbackToReceiveCount()

The number of reminders that feedback has not yet been received by the buyer or seller.

#    Argument: 'xs:int'

=cut

sub setFeedbackToReceiveCount {
  my $self = shift;
  $self->{'FeedbackToReceiveCount'} = shift
}

=head2 getFeedbackToReceiveCount()

  Calls: GetMyeBayReminders
  Returned: Conditionally

#    Returns: 'xs:int'

=cut

sub getFeedbackToReceiveCount {
  my $self = shift;
  return $self->{'FeedbackToReceiveCount'};
}


=head2 setFeedbackToSendCount()

The number of reminders that feedback has not yet been sent by the buyer or seller.

#    Argument: 'xs:int'

=cut

sub setFeedbackToSendCount {
  my $self = shift;
  $self->{'FeedbackToSendCount'} = shift
}

=head2 getFeedbackToSendCount()

  Calls: GetMyeBayReminders
  Returned: Conditionally

#    Returns: 'xs:int'

=cut

sub getFeedbackToSendCount {
  my $self = shift;
  return $self->{'FeedbackToSendCount'};
}


=head2 setItemReceiptConfirmationToReceiveCount()

The number of reminders to the seller on item receipt confirmation pending from buyer

#    Argument: 'xs:int'

=cut

sub setItemReceiptConfirmationToReceiveCount {
  my $self = shift;
  $self->{'ItemReceiptConfirmationToReceiveCount'} = shift
}

=head2 getItemReceiptConfirmationToReceiveCount()

  Calls: GetMyeBayReminders
  Returned: Conditionally
  Context: SellingReminders

#    Returns: 'xs:int'

=cut

sub getItemReceiptConfirmationToReceiveCount {
  my $self = shift;
  return $self->{'ItemReceiptConfirmationToReceiveCount'};
}


=head2 setItemReceiptToConfirmCount()

The number of reminders requesting the Buyer to confirm item receipt to seller.

#    Argument: 'xs:int'

=cut

sub setItemReceiptToConfirmCount {
  my $self = shift;
  $self->{'ItemReceiptToConfirmCount'} = shift
}

=head2 getItemReceiptToConfirmCount()

  Calls: GetMyeBayReminders
  Returned: Conditionally
  Context: SellingReminders

#    Returns: 'xs:int'

=cut

sub getItemReceiptToConfirmCount {
  my $self = shift;
  return $self->{'ItemReceiptToConfirmCount'};
}


=head2 setOutbidCount()

The number of reminders advising the buyer that the buyer has been
outbid.

#    Argument: 'xs:int'

=cut

sub setOutbidCount {
  my $self = shift;
  $self->{'OutbidCount'} = shift
}

=head2 getOutbidCount()

  Calls: GetMyeBayReminders
  Returned: Conditionally
  Context: BuyingReminders

#    Returns: 'xs:int'

=cut

sub getOutbidCount {
  my $self = shift;
  return $self->{'OutbidCount'};
}


=head2 setPaymentToReceiveCount()

The number of reminders that the seller has not yet received a payment.

#    Argument: 'xs:int'

=cut

sub setPaymentToReceiveCount {
  my $self = shift;
  $self->{'PaymentToReceiveCount'} = shift
}

=head2 getPaymentToReceiveCount()

  Calls: GetMyeBayReminders
  Returned: Conditionally
  Context: SellingReminders

#    Returns: 'xs:int'

=cut

sub getPaymentToReceiveCount {
  my $self = shift;
  return $self->{'PaymentToReceiveCount'};
}


=head2 setPaymentToSendCount()

The number of reminders requesting that the buyer send payment.

#    Argument: 'xs:int'

=cut

sub setPaymentToSendCount {
  my $self = shift;
  $self->{'PaymentToSendCount'} = shift
}

=head2 getPaymentToSendCount()

  Calls: GetMyeBayReminders
  Returned: Conditionally
  Context: BuyingReminders

#    Returns: 'xs:int'

=cut

sub getPaymentToSendCount {
  my $self = shift;
  return $self->{'PaymentToSendCount'};
}


=head2 setPendingRTERequestCount()

The number of reminders to the seller on pending shipping time extension requests with the buyer

#    Argument: 'xs:int'

=cut

sub setPendingRTERequestCount {
  my $self = shift;
  $self->{'PendingRTERequestCount'} = shift
}

=head2 getPendingRTERequestCount()

  Calls: GetMyeBayReminders
  Returned: Conditionally
  Context: SellingReminders

#    Returns: 'xs:int'

=cut

sub getPendingRTERequestCount {
  my $self = shift;
  return $self->{'PendingRTERequestCount'};
}


=head2 setRTEToProcessCount()

The number of reminders requesting the buyer to process request time extension submitted by the seller.

#    Argument: 'xs:int'

=cut

sub setRTEToProcessCount {
  my $self = shift;
  $self->{'RTEToProcessCount'} = shift
}

=head2 getRTEToProcessCount()

  Calls: GetMyeBayReminders
  Returned: Conditionally
  Context: SellingReminders

#    Returns: 'xs:int'

=cut

sub getRTEToProcessCount {
  my $self = shift;
  return $self->{'RTEToProcessCount'};
}


=head2 setRefundCancelledCount()

The number of reminders to the buyer on refund cancelled.

#    Argument: 'xs:int'

=cut

sub setRefundCancelledCount {
  my $self = shift;
  $self->{'RefundCancelledCount'} = shift
}

=head2 getRefundCancelledCount()

  Calls: GetMyeBayReminders
  Returned: Conditionally
  Context: SellingReminders

#    Returns: 'xs:int'

=cut

sub getRefundCancelledCount {
  my $self = shift;
  return $self->{'RefundCancelledCount'};
}


=head2 setRefundInitiatedCount()

The number of reminders to the seller on refunds initiated

#    Argument: 'xs:int'

=cut

sub setRefundInitiatedCount {
  my $self = shift;
  $self->{'RefundInitiatedCount'} = shift
}

=head2 getRefundInitiatedCount()

  Calls: GetMyeBayReminders
  Returned: Conditionally
  Context: SellingReminders

#    Returns: 'xs:int'

=cut

sub getRefundInitiatedCount {
  my $self = shift;
  return $self->{'RefundInitiatedCount'};
}


=head2 setRefundOnHoldCount()

The number of reminders to the buyer on refund on hold.

#    Argument: 'xs:int'

=cut

sub setRefundOnHoldCount {
  my $self = shift;
  $self->{'RefundOnHoldCount'} = shift
}

=head2 getRefundOnHoldCount()

  Calls: GetMyeBayReminders
  Returned: Conditionally
  Context: SellingReminders

#    Returns: 'xs:int'

=cut

sub getRefundOnHoldCount {
  my $self = shift;
  return $self->{'RefundOnHoldCount'};
}


=head2 setRelistingNeededCount()

The number of reminders advising the seller that relisting is needed.

#    Argument: 'xs:int'

=cut

sub setRelistingNeededCount {
  my $self = shift;
  $self->{'RelistingNeededCount'} = shift
}

=head2 getRelistingNeededCount()

  Calls: GetMyeBayReminders
  Returned: Conditionally
  Context: SellingReminders

#    Returns: 'xs:int'

=cut

sub getRelistingNeededCount {
  my $self = shift;
  return $self->{'RelistingNeededCount'};
}


=head2 setSecondChanceOfferCount()

The number of reminders requesting that the seller review second
chance offers.

#    Argument: 'xs:int'

=cut

sub setSecondChanceOfferCount {
  my $self = shift;
  $self->{'SecondChanceOfferCount'} = shift
}

=head2 getSecondChanceOfferCount()

  Calls: GetMyeBayReminders
  Returned: Conditionally
  Context: SellingReminders

#    Returns: 'xs:int'

=cut

sub getSecondChanceOfferCount {
  my $self = shift;
  return $self->{'SecondChanceOfferCount'};
}


=head2 setShippingDetailsToBeProvidedCount()

The number of reminders requesting the seller to provide shipping details

#    Argument: 'xs:int'

=cut

sub setShippingDetailsToBeProvidedCount {
  my $self = shift;
  $self->{'ShippingDetailsToBeProvidedCount'} = shift
}

=head2 getShippingDetailsToBeProvidedCount()

  Calls: GetMyeBayReminders
  Returned: Conditionally
  Context: SellingReminders

#    Returns: 'xs:int'

=cut

sub getShippingDetailsToBeProvidedCount {
  my $self = shift;
  return $self->{'ShippingDetailsToBeProvidedCount'};
}


=head2 setShippingNeededCount()

The number of reminders advising the seller that shipping is
needed.

#    Argument: 'xs:int'

=cut

sub setShippingNeededCount {
  my $self = shift;
  $self->{'ShippingNeededCount'} = shift
}

=head2 getShippingNeededCount()

  Calls: GetMyeBayReminders
  Returned: Conditionally
  Context: SellingReminders

#    Returns: 'xs:int'

=cut

sub getShippingNeededCount {
  my $self = shift;
  return $self->{'ShippingNeededCount'};
}


=head2 setTotalNewLeadsCount()

The number of new leads the seller has recieved.

#    Argument: 'xs:int'

=cut

sub setTotalNewLeadsCount {
  my $self = shift;
  $self->{'TotalNewLeadsCount'} = shift
}

=head2 getTotalNewLeadsCount()

  Calls: GetMyeBayReminders
  Returned: Conditionally
  Context: SellingReminders

#    Returns: 'xs:int'

=cut

sub getTotalNewLeadsCount {
  my $self = shift;
  return $self->{'TotalNewLeadsCount'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
