#!/usr/bin/perl

package eBay::API::XML::DataType::ReviewDetailsType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. ReviewDetailsType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::ReviewDetailsType

=head1 DESCRIPTION

Contains product reviews written by eBay members.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::ReviewDetailsType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::ReviewType;


my @gaProperties = ( [ 'AverageRating', 'xs:float', '', '', '' ]
	, [ 'Review', 'ns:ReviewType', '1'
	     ,'eBay::API::XML::DataType::ReviewType', '1' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setAverageRating()

The product's average rating (out of 5) based on all reviews.
For example, a value like 4.5 would mean the average rating
is 4.5 out of 5. (See ReviewCount for the total number of reviews.)

Max: 5
Min: 0

#    Argument: 'xs:float'

=cut

sub setAverageRating {
  my $self = shift;
  $self->{'AverageRating'} = shift
}

=head2 getAverageRating()

  Calls: GetProducts
  Returned: Conditionally

#    Returns: 'xs:float'

=cut

sub getAverageRating {
  my $self = shift;
  return $self->{'AverageRating'};
}


=head2 setReview()

An eBay member's review of the product.

MaxOccurs: 20

#    Argument: reference to an array  
                      of 'ns:ReviewType'

=cut

sub setReview {
  my $self = shift;
  $self->{'Review'} = 
		$self->convertArray_To_RefToArrayIfNeeded(@_);
}

=head2 getReview()

  Calls: GetProducts
  Returned: Conditionally

#    Returns: reference to an array  
                      of 'ns:ReviewType'

=cut

sub getReview {
  my $self = shift;
  return $self->_getDataTypeArray('Review');
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
