package Net::ESMTP;

use 5.008;
use strict;
use warnings;
use Carp;

require Exporter;
use AutoLoader;

our @ISA = qw(Exporter);

# Items to export into callers namespace by default. Note: do not export
# names by default without a very good reason. Use EXPORT_OK instead.
# Do not simply export all your public functions/methods/constants.

# This allows declaration	use Net::ESMTP ':all';
# If you do not need this, moving things directly into @EXPORT or @EXPORT_OK
# will save memory.
our %EXPORT_TAGS = ( 'all' => [ qw(
  AUTH_USER
  AUTH_REALM
  AUTH_PASS
  AUTH_CLEARTEXT
  AUTH_PLUGIN_ANONYMOUS
  AUTH_PLUGIN_PLAIN
  AUTH_PLUGIN_EXTERNAL
  By_NOTSET
  By_NOTIFY
  By_RETURN
  E8bitmime_NOTSET
  E8bitmime_7BIT
  E8bitmime_8BITMIME
  E8bitmime_BINARYMIME
  Hdr_OVERRIDE
  Hdr_PROHIBIT
  Notify_NOTSET
  Notify_NEVER
  Notify_SUCCESS
  Notify_FAILURE
  Notify_DELAY
  Ret_NOTSET
  Ret_FULL
  Ret_HDRS
  SMTP_EV_CONNECT
  SMTP_EV_MAILSTATUS
  SMTP_EV_RCPTSTATUS
  SMTP_EV_MESSAGEDATA
  SMTP_EV_MESSAGESENT
  SMTP_EV_DISCONNECT
  SMTP_EV_ETRNSTATUS
  SMTP_EV_EXTNA_DSN
  SMTP_EV_EXTNA_8BITMIME
  SMTP_EV_EXTNA_STARTTLS
  SMTP_EV_EXTNA_ETRN
  SMTP_EV_EXTNA_CHUNKING
  SMTP_EV_EXTNA_BINARYMIME
  SMTP_EV_DELIVERBY_EXPIRED
  SMTP_EV_WEAK_CIPHER
  SMTP_EV_STARTTLS_OK
  SMTP_EV_INVALID_PEER_CERTIFICATE
  SMTP_EV_NO_PEER_CERTIFICATE
  SMTP_EV_WRONG_PEER_CERTIFICATE
  SMTP_EV_NO_CLIENT_CERTIFICATE
  SMTP_EV_UNUSABLE_CLIENT_CERTIFICATE
  SMTP_EV_UNUSABLE_CA_LIST
  SMTP_CB_HEADERS
  SMTP_CB_READING
  SMTP_CB_WRITING
  SMTP_ERR_DROPPED_CONNECTION
  SMTP_ERR_EAI_ADDRFAMILY
  SMTP_ERR_EAI_AGAIN
  SMTP_ERR_EAI_BADFLAGS
  SMTP_ERR_EAI_FAIL
  SMTP_ERR_EAI_FAMILY
  SMTP_ERR_EAI_MEMORY
  SMTP_ERR_EAI_NODATA
  SMTP_ERR_EAI_NONAME
  SMTP_ERR_EAI_SERVICE
  SMTP_ERR_EAI_SOCKTYPE
  SMTP_ERR_EXTENSION_NOT_AVAILABLE
  SMTP_ERR_HOST_NOT_FOUND
  SMTP_ERR_INVAL
  SMTP_ERR_INVALID_RESPONSE_STATUS
  SMTP_ERR_INVALID_RESPONSE_SYNTAX
  SMTP_ERR_NOTHING_TO_DO
  SMTP_ERR_NO_ADDRESS
  SMTP_ERR_NO_RECOVERY
  SMTP_ERR_STATUS_MISMATCH
  SMTP_ERR_TRY_AGAIN
  SMTP_ERR_UNTERMINATED_RESPONSE
  Starttls_DISABLED
  Starttls_ENABLED
  Starttls_REQUIRED
  Timeout_GREETING
  Timeout_ENVELOPE
  Timeout_DATA
  Timeout_TRANSFER
  Timeout_DATA2
  Timeout_OVERRIDE_RFC2822_MINIMUM
) ] );

our @EXPORT_OK = (
	'smtp_version',
	'smtp_errno',
	'smtp_strerror',
	@{ $EXPORT_TAGS{'all'} } );

our @EXPORT = qw(
  smtp_version
  smtp_errno
  smtp_strerror
  AUTH_USER
  AUTH_REALM
  AUTH_PASS
  AUTH_CLEARTEXT
  AUTH_PLUGIN_ANONYMOUS
  AUTH_PLUGIN_PLAIN
  AUTH_PLUGIN_EXTERNAL
  By_NOTSET
  By_NOTIFY
  By_RETURN
  E8bitmime_NOTSET
  E8bitmime_7BIT
  E8bitmime_8BITMIME
  E8bitmime_BINARYMIME
  Hdr_OVERRIDE
  Hdr_PROHIBIT
  Notify_NOTSET
  Notify_NEVER
  Notify_SUCCESS
  Notify_FAILURE
  Notify_DELAY
  Ret_NOTSET
  Ret_FULL
  Ret_HDRS
  SMTP_EV_CONNECT
  SMTP_EV_MAILSTATUS
  SMTP_EV_RCPTSTATUS
  SMTP_EV_MESSAGEDATA
  SMTP_EV_MESSAGESENT
  SMTP_EV_DISCONNECT
  SMTP_EV_ETRNSTATUS
  SMTP_EV_EXTNA_DSN
  SMTP_EV_EXTNA_8BITMIME
  SMTP_EV_EXTNA_STARTTLS
  SMTP_EV_EXTNA_ETRN
  SMTP_EV_EXTNA_CHUNKING
  SMTP_EV_EXTNA_BINARYMIME
  SMTP_EV_DELIVERBY_EXPIRED
  SMTP_EV_WEAK_CIPHER
  SMTP_EV_STARTTLS_OK
  SMTP_EV_INVALID_PEER_CERTIFICATE
  SMTP_EV_NO_PEER_CERTIFICATE
  SMTP_EV_WRONG_PEER_CERTIFICATE
  SMTP_CB_HEADERS
  SMTP_CB_READING
  SMTP_CB_WRITING
  SMTP_ERR_DROPPED_CONNECTION
  SMTP_ERR_EAI_ADDRFAMILY
  SMTP_ERR_EAI_AGAIN
  SMTP_ERR_EAI_BADFLAGS
  SMTP_ERR_EAI_FAIL
  SMTP_ERR_EAI_FAMILY
  SMTP_ERR_EAI_MEMORY
  SMTP_ERR_EAI_NODATA
  SMTP_ERR_EAI_NONAME
  SMTP_ERR_EAI_SERVICE
  SMTP_ERR_EAI_SOCKTYPE
  SMTP_ERR_EXTENSION_NOT_AVAILABLE
  SMTP_ERR_HOST_NOT_FOUND
  SMTP_ERR_INVAL
  SMTP_ERR_INVALID_RESPONSE_STATUS
  SMTP_ERR_INVALID_RESPONSE_SYNTAX
  SMTP_ERR_NOTHING_TO_DO
  SMTP_ERR_NO_ADDRESS
  SMTP_ERR_NO_RECOVERY
  SMTP_ERR_STATUS_MISMATCH
  SMTP_ERR_TRY_AGAIN
  SMTP_ERR_UNTERMINATED_RESPONSE
  Starttls_DISABLED
  Starttls_ENABLED
  Starttls_REQUIRED
  Timeout_GREETING
  Timeout_ENVELOPE
  Timeout_DATA
  Timeout_TRANSFER
  Timeout_DATA2
  Timeout_OVERRIDE_RFC2822_MINIMUM
);

our $VERSION = '0.2.1';

sub AUTOLOAD {
    # This AUTOLOAD is used to 'autoload' constants from the constant()
    # XS function.

    my $constname;
    our $AUTOLOAD;
    ($constname = $AUTOLOAD) =~ s/.*:://;
    croak "&Net::ESMTP::constant not defined" if $constname eq 'constant';
    my ($error, $val) = constant($constname);
    if ($error) { croak $error; }
    {
	no strict 'refs';
	# Fixed between 5.005_53 and 5.005_61
#XXX	if ($] >= 5.00561) {
#XXX	    *$AUTOLOAD = sub () { $val };
#XXX	}
#XXX	else {
	    *$AUTOLOAD = sub { $val };
#XXX	}
    }
    goto &$AUTOLOAD;
}

require XSLoader;
XSLoader::load('Net::ESMTP', $VERSION);

# Preloaded methods go here.

# Autoload methods go after =cut, and are processed by the autosplit program.

1;
__END__
