# Generated by default/object.tt
package Paws::AppMesh::SubjectAlternativeNameMatchers;
  use Moose;
  has Exact => (is => 'ro', isa => 'ArrayRef[Str|Undef]', request_name => 'exact', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::AppMesh::SubjectAlternativeNameMatchers

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::AppMesh::SubjectAlternativeNameMatchers object:

  $service_obj->Method(Att1 => { Exact => $value, ..., Exact => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::AppMesh::SubjectAlternativeNameMatchers object:

  $result = $service_obj->Method(...);
  $result->Att1->Exact

=head1 DESCRIPTION

An object that represents the methods by which a subject alternative
name on a peer Transport Layer Security (TLS) certificate can be
matched.

=head1 ATTRIBUTES


=head2 B<REQUIRED> Exact => ArrayRef[Str|Undef]

The values sent must match the specified values exactly.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::AppMesh>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

