
package Paws::EBS::PutSnapshotBlock;
  use Moose;
  has BlockData => (is => 'ro', isa => 'Str', traits => ['ParamInBody'], required => 1);
  has BlockIndex => (is => 'ro', isa => 'Int', traits => ['ParamInURI'], uri_name => 'blockIndex', required => 1);
  has Checksum => (is => 'ro', isa => 'Str', traits => ['ParamInHeader'], header_name => 'x-amz-Checksum', required => 1);
  has ChecksumAlgorithm => (is => 'ro', isa => 'Str', traits => ['ParamInHeader'], header_name => 'x-amz-Checksum-Algorithm', required => 1);
  has DataLength => (is => 'ro', isa => 'Int', traits => ['ParamInHeader'], header_name => 'x-amz-Data-Length', required => 1);
  has Progress => (is => 'ro', isa => 'Int', traits => ['ParamInHeader'], header_name => 'x-amz-Progress');
  has SnapshotId => (is => 'ro', isa => 'Str', traits => ['ParamInURI'], uri_name => 'snapshotId', required => 1);

  use MooseX::ClassAttribute;
  class_has _stream_param => (is => 'ro', default => 'BlockData');
  class_has _api_call => (isa => 'Str', is => 'ro', default => 'PutSnapshotBlock');
  class_has _api_uri  => (isa => 'Str', is => 'ro', default => '/snapshots/{snapshotId}/blocks/{blockIndex}');
  class_has _api_method  => (isa => 'Str', is => 'ro', default => 'PUT');
  class_has _returns => (isa => 'Str', is => 'ro', default => 'Paws::EBS::PutSnapshotBlockResponse');
1;

### main pod documentation begin ###

=head1 NAME

Paws::EBS::PutSnapshotBlock - Arguments for method PutSnapshotBlock on L<Paws::EBS>

=head1 DESCRIPTION

This class represents the parameters used for calling the method PutSnapshotBlock on the
L<Amazon Elastic Block Store|Paws::EBS> service. Use the attributes of this class
as arguments to method PutSnapshotBlock.

You shouldn't make instances of this class. Each attribute should be used as a named argument in the call to PutSnapshotBlock.

=head1 SYNOPSIS

    my $ebs = Paws->service('EBS');
    my $PutSnapshotBlockResponse = $ebs->PutSnapshotBlock(
      BlockData         => 'BlobBlockData',
      BlockIndex        => 1,
      Checksum          => 'MyChecksum',
      ChecksumAlgorithm => 'SHA256',
      DataLength        => 1,
      SnapshotId        => 'MySnapshotId',
      Progress          => 1,                 # OPTIONAL
    );

    # Results:
    my $Checksum          = $PutSnapshotBlockResponse->Checksum;
    my $ChecksumAlgorithm = $PutSnapshotBlockResponse->ChecksumAlgorithm;

    # Returns a L<Paws::EBS::PutSnapshotBlockResponse> object.

Values for attributes that are native types (Int, String, Float, etc) can passed as-is (scalar values). Values for complex Types (objects) can be passed as a HashRef. The keys and values of the hashref will be used to instance the underlying object.
For the AWS API documentation, see L<https://docs.aws.amazon.com/goto/WebAPI/ebs/PutSnapshotBlock>

=head1 ATTRIBUTES


=head2 B<REQUIRED> BlockData => Str

The data to write to the block.

The block data is not signed as part of the Signature Version 4 signing
process. As a result, you must generate and provide a Base64-encoded
SHA256 checksum for the block data using the B<x-amz-Checksum> header.
Also, you must specify the checksum algorithm using the
B<x-amz-Checksum-Algorithm> header. The checksum that you provide is
part of the Signature Version 4 signing process. It is validated
against a checksum generated by Amazon EBS to ensure the validity and
authenticity of the data. If the checksums do not correspond, the
request fails. For more information, see Using checksums with the EBS
direct APIs
(https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-accessing-snapshot.html#ebsapis-using-checksums)
in the I<Amazon Elastic Compute Cloud User Guide>.



=head2 B<REQUIRED> BlockIndex => Int

The block index of the block in which to write the data. A block index
is a logical index in units of C<512> KiB blocks. To identify the block
index, divide the logical offset of the data in the logical volume by
the block size (logical offset of data/C<524288>). The logical offset
of the data must be C<512> KiB aligned.



=head2 B<REQUIRED> Checksum => Str

A Base64-encoded SHA256 checksum of the data. Only SHA256 checksums are
supported.



=head2 B<REQUIRED> ChecksumAlgorithm => Str

The algorithm used to generate the checksum. Currently, the only
supported algorithm is C<SHA256>.

Valid values are: C<"SHA256">

=head2 B<REQUIRED> DataLength => Int

The size of the data to write to the block, in bytes. Currently, the
only supported size is C<524288>.

Valid values: C<524288>



=head2 Progress => Int

The progress of the write process, as a percentage.



=head2 B<REQUIRED> SnapshotId => Str

The ID of the snapshot.




=head1 SEE ALSO

This class forms part of L<Paws>, documenting arguments for method PutSnapshotBlock in L<Paws::EBS>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

